/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.math.BigDecimal;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;

public abstract class NumberDataType
extends DataType
implements NumberDataValue {
    static DataValueDescriptor ZERO_DECIMAL;
    static final BigDecimal ZERO;
    static final BigDecimal ONE;
    static final BigDecimal MAXLONG_PLUS_ONE;
    static final BigDecimal MINLONG_MINUS_ONE;

    public final NumberDataValue absolute(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNegative()) {
            return this.minus(numberDataValue);
        }
        if (numberDataValue == null) {
            numberDataValue = (NumberDataValue)this.getNewNull();
        }
        numberDataValue.setValue(this);
        return numberDataValue;
    }

    public NumberDataValue sqrt(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = (NumberDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        double d = this.getDouble();
        if (this.isNegative()) {
            if (new Double(d).equals(new Double(-0.0))) {
                d = 0.0;
            } else {
                throw StandardException.newException("22013", this);
            }
        }
        numberDataValue.setValue(Math.sqrt(d));
        return numberDataValue;
    }

    public NumberDataValue plus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = (NumberDataValue)this.getNewNull();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n = numberDataValue.getInt();
        int n2 = numberDataValue2.getInt();
        int n3 = n + n2;
        if (n < 0 == n2 < 0 && n < 0 != n3 < 0) {
            throw this.outOfRange();
        }
        numberDataValue3.setValue(n3);
        return numberDataValue3;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = (NumberDataValue)this.getNewNull();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n = numberDataValue.getInt() - numberDataValue2.getInt();
        if (numberDataValue.getInt() < 0 != numberDataValue2.getInt() < 0 && numberDataValue.getInt() < 0 != n < 0) {
            throw this.outOfRange();
        }
        numberDataValue3.setValue(n);
        return numberDataValue3;
    }

    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = (NumberDataValue)this.getNewNull();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n = numberDataValue2.getInt();
        if (n == 0) {
            throw StandardException.newException("22012");
        }
        numberDataValue3.setValue(numberDataValue.getInt() / n);
        return numberDataValue3;
    }

    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3, int n) throws StandardException {
        return this.divide(numberDataValue, numberDataValue2, numberDataValue3);
    }

    public NumberDataValue mod(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        return null;
    }

    public final int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        boolean bl = this.isNull();
        boolean bl2 = dataValueDescriptor.isNull();
        if (bl || bl2) {
            if (!bl) {
                return -1;
            }
            if (!bl2) {
                return 1;
            }
            return 0;
        }
        return this.typeCompare(dataValueDescriptor);
    }

    protected abstract int typeCompare(DataValueDescriptor var1) throws StandardException;

    public final boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        return super.compare(n, dataValueDescriptor, bl, bl2);
    }

    protected abstract boolean isNegative();

    public void setValue(short s) throws StandardException {
        this.setValue((int)s);
    }

    public void setValue(byte by) throws StandardException {
        this.setValue((int)by);
    }

    public void setValue(Number number) throws StandardException {
        if (this.objectNull(number)) {
            return;
        }
        this.setValue(number.intValue());
    }

    void setObject(Object object) throws StandardException {
        this.setValue((Integer)object);
    }

    public void setBigDecimal(Number number) throws StandardException {
        if (this.objectNull(number)) {
            return;
        }
        Comparable comparable = (Comparable)((Object)number);
        if (comparable.compareTo(MINLONG_MINUS_ONE) != 1 || comparable.compareTo(MAXLONG_PLUS_ONE) != -1) {
            throw StandardException.newException("22003", this.getTypeName());
        }
        this.setValue(number.longValue());
    }

    public int typeToBigDecimal() {
        return -5;
    }

    public int getDecimalValuePrecision() {
        return -1;
    }

    public int getDecimalValueScale() {
        return -1;
    }

    protected final boolean objectNull(Object object) {
        if (object == null) {
            this.restoreToNull();
            return true;
        }
        return false;
    }

    public static float normalizeREAL(float f) throws StandardException {
        if (Float.isNaN(f) || Float.isInfinite(f) || f < -3.402E38f || f > 3.402E38f || f > 0.0f && f < 1.175E-37f || f < 0.0f && f > -1.175E-37f) {
            throw StandardException.newException("22003", "REAL");
        }
        if (f == -0.0f) {
            f = 0.0f;
        }
        return f;
    }

    public static float normalizeREAL(double d) throws StandardException {
        if (Double.isNaN(d) || Double.isInfinite(d) || d < (double)-3.402E38f || d > (double)3.402E38f || d > 0.0 && d < (double)1.175E-37f || d < 0.0 && d > (double)-1.175E-37f) {
            throw StandardException.newException("22003", "REAL");
        }
        if (d == -0.0) {
            d = 0.0;
        }
        return (float)d;
    }

    public static double normalizeDOUBLE(double d) throws StandardException {
        if (Double.isNaN(d) || Double.isInfinite(d) || d < -1.79769E308 || d > 1.79769E308 || d > 0.0 && d < 2.225E-307 || d < 0.0 && d > -2.225E-307) {
            throw StandardException.newException("22003", "DOUBLE");
        }
        if (d == -0.0) {
            d = 0.0;
        }
        return d;
    }

    static {
        ZERO = BigDecimal.valueOf(0L);
        ONE = BigDecimal.valueOf(1L);
        MAXLONG_PLUS_ONE = BigDecimal.valueOf(Long.MAX_VALUE).add(ONE);
        MINLONG_MINUS_ONE = BigDecimal.valueOf(Long.MIN_VALUE).subtract(ONE);
    }
}

