/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Vector;
import org.apache.derby.iapi.error.SQLWarningFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.impl.sql.execute.AggregatorInfoList;
import org.apache.derby.impl.sql.execute.GenericAggregator;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

abstract class GenericAggregateResultSet
extends NoPutResultSetImpl {
    protected GenericAggregator[] aggregates;
    protected GeneratedMethod rowAllocator;
    protected AggregatorInfoList aggInfoList;
    public NoPutResultSet source;
    protected NoPutResultSet originalSource;

    GenericAggregateResultSet(NoPutResultSet noPutResultSet, int n, Activation activation, GeneratedMethod generatedMethod, int n2, double d, double d2) throws StandardException {
        super(activation, n2, d, d2);
        this.source = noPutResultSet;
        this.originalSource = noPutResultSet;
        this.rowAllocator = generatedMethod;
        this.aggInfoList = (AggregatorInfoList)activation.getPreparedStatement().getSavedObject(n);
        this.aggregates = this.getSortAggregators(this.aggInfoList, false, activation.getLanguageConnectionContext(), noPutResultSet);
    }

    protected final GenericAggregator[] getSortAggregators(AggregatorInfoList aggregatorInfoList, boolean bl, LanguageConnectionContext languageConnectionContext, NoPutResultSet noPutResultSet) throws StandardException {
        Vector<GenericAggregator> vector = new Vector<GenericAggregator>();
        ClassFactory classFactory = languageConnectionContext.getLanguageConnectionFactory().getClassFactory();
        int n = aggregatorInfoList.size();
        for (int i = 0; i < n; ++i) {
            AggregatorInfo aggregatorInfo = (AggregatorInfo)aggregatorInfoList.elementAt(i);
            if (bl && aggregatorInfo.isDistinct()) continue;
            vector.addElement(new GenericAggregator(aggregatorInfo, classFactory));
        }
        Object[] objectArray = new GenericAggregator[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected final ExecIndexRow finishAggregation(ExecIndexRow execIndexRow) throws StandardException {
        int n = this.aggregates.length;
        if (execIndexRow == null) {
            execIndexRow = this.getExecutionFactory().getIndexableRow((ExecRow)this.rowAllocator.invoke(this.activation));
        }
        this.setCurrentRow(execIndexRow);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            GenericAggregator genericAggregator = this.aggregates[i];
            if (!genericAggregator.finish(execIndexRow)) continue;
            bl = true;
        }
        if (bl) {
            this.addWarning(SQLWarningFactory.newSQLWarning("01003"));
        }
        return execIndexRow;
    }

    public void finish() throws StandardException {
        this.source.finish();
        super.finish();
    }
}

