/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;

public class FormattingFilter
extends JsonQuery {
    private String name;

    public FormattingFilter(String name) {
        this.name = name;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        Function f = scope.getFunction("@" + this.name, 0);
        if (f == null) {
            throw new JsonQueryException("Formatting operator @" + this.name + " does not exist");
        }
        return f.apply(scope, Collections.emptyList(), in);
    }

    public String toString() {
        return "@" + this.name;
    }
}

