/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.MathArrays;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ScaleEvaluator
extends RecursiveNumericEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public ScaleEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (null == first || null == second) {
            return null;
        }
        if (first instanceof List) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting Number as first value but found a list", this.toExpression(this.constructingFactory)));
        }
        double[] scaleOver = second instanceof Number ? Arrays.asList((Number)second).stream().mapToDouble(value -> value.doubleValue()).toArray() : ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
        return Arrays.stream(MathArrays.scale((double)((Number)first).doubleValue(), (double[])scaleOver)).boxed().collect(Collectors.toList());
    }
}

