/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene70;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;

final class IndexedDISI
extends DocIdSetIterator {
    static final int MAX_ARRAY_LENGTH = 4095;
    private final IndexInput slice;
    private final long cost;
    private int block = -1;
    private long blockEnd;
    private int nextBlockIndex = -1;
    Method method;
    private int doc = -1;
    private int index = -1;
    boolean exists;
    private long word;
    private int wordIndex = -1;
    private int numberOfOnes;
    private int gap;

    private static void flush(int block, FixedBitSet buffer, int cardinality, IndexOutput out) throws IOException {
        block5: {
            block4: {
                assert (block >= 0 && block < 65536);
                out.writeShort((short)block);
                assert (cardinality > 0 && cardinality <= 65536);
                out.writeShort((short)(cardinality - 1));
                if (cardinality <= 4095) break block4;
                if (cardinality == 65536) break block5;
                for (long word : buffer.getBits()) {
                    out.writeLong(word);
                }
                break block5;
            }
            BitSetIterator it = new BitSetIterator((BitSet)buffer, (long)cardinality);
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                out.writeShort((short)doc);
                doc = it.nextDoc();
            }
        }
    }

    static void writeBitSet(DocIdSetIterator it, IndexOutput out) throws IOException {
        int i = 0;
        FixedBitSet buffer = new FixedBitSet(65536);
        int prevBlock = -1;
        int doc = it.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int block = doc >>> 16;
            if (prevBlock != -1 && block != prevBlock) {
                IndexedDISI.flush(prevBlock, buffer, i, out);
                buffer.clear(0, buffer.length());
                prevBlock = block;
                i = 0;
            }
            buffer.set(doc & 0xFFFF);
            ++i;
            prevBlock = block;
            doc = it.nextDoc();
        }
        if (i > 0) {
            IndexedDISI.flush(prevBlock, buffer, i, out);
            buffer.clear(0, buffer.length());
        }
        buffer.set(65535);
        IndexedDISI.flush(Short.MAX_VALUE, buffer, 1, out);
    }

    IndexedDISI(IndexInput in, long offset, long length, long cost) throws IOException {
        this(in.slice("docs", offset, length), cost);
    }

    IndexedDISI(IndexInput slice, long cost) throws IOException {
        this.slice = slice;
        this.cost = cost;
    }

    public int docID() {
        return this.doc;
    }

    public int advance(int target) throws IOException {
        int targetBlock = target & 0xFFFF0000;
        if (this.block < targetBlock) {
            this.advanceBlock(targetBlock);
        }
        if (this.block == targetBlock) {
            if (this.method.advanceWithinBlock(this, target)) {
                return this.doc;
            }
            this.readBlockHeader();
        }
        boolean found = this.method.advanceWithinBlock(this, this.block);
        assert (found);
        return this.doc;
    }

    public boolean advanceExact(int target) throws IOException {
        int targetBlock = target & 0xFFFF0000;
        if (this.block < targetBlock) {
            this.advanceBlock(targetBlock);
        }
        boolean found = this.block == targetBlock && this.method.advanceExactWithinBlock(this, target);
        this.doc = target;
        return found;
    }

    private void advanceBlock(int targetBlock) throws IOException {
        do {
            this.slice.seek(this.blockEnd);
            this.readBlockHeader();
        } while (this.block < targetBlock);
    }

    private void readBlockHeader() throws IOException {
        this.block = Short.toUnsignedInt(this.slice.readShort()) << 16;
        assert (this.block >= 0);
        int numValues = 1 + Short.toUnsignedInt(this.slice.readShort());
        this.index = this.nextBlockIndex;
        this.nextBlockIndex = this.index + numValues;
        if (numValues <= 4095) {
            this.method = Method.SPARSE;
            this.blockEnd = this.slice.getFilePointer() + (long)(numValues << 1);
        } else if (numValues == 65536) {
            this.method = Method.ALL;
            this.blockEnd = this.slice.getFilePointer();
            this.gap = this.block - this.index - 1;
        } else {
            this.method = Method.DENSE;
            this.blockEnd = this.slice.getFilePointer() + 8192L;
            this.wordIndex = -1;
            this.numberOfOnes = this.index + 1;
        }
    }

    public int nextDoc() throws IOException {
        return this.advance(this.doc + 1);
    }

    public int index() {
        return this.index;
    }

    public long cost() {
        return this.cost;
    }

    static enum Method {
        SPARSE{

            @Override
            boolean advanceWithinBlock(IndexedDISI disi, int target) throws IOException {
                int targetInBlock = target & 0xFFFF;
                while (disi.index < disi.nextBlockIndex) {
                    int doc = Short.toUnsignedInt(disi.slice.readShort());
                    disi.index++;
                    if (doc < targetInBlock) continue;
                    disi.doc = disi.block | doc;
                    disi.exists = true;
                    return true;
                }
                return false;
            }

            @Override
            boolean advanceExactWithinBlock(IndexedDISI disi, int target) throws IOException {
                int targetInBlock = target & 0xFFFF;
                if (target == disi.doc) {
                    return disi.exists;
                }
                while (disi.index < disi.nextBlockIndex) {
                    int doc = Short.toUnsignedInt(disi.slice.readShort());
                    disi.index++;
                    if (doc < targetInBlock) continue;
                    if (doc != targetInBlock) {
                        disi.index--;
                        disi.slice.seek(disi.slice.getFilePointer() - 2L);
                        break;
                    }
                    disi.exists = true;
                    return true;
                }
                disi.exists = false;
                return false;
            }
        }
        ,
        DENSE{

            @Override
            boolean advanceWithinBlock(IndexedDISI disi, int target) throws IOException {
                int targetInBlock = target & 0xFFFF;
                int targetWordIndex = targetInBlock >>> 6;
                for (int i = disi.wordIndex + 1; i <= targetWordIndex; ++i) {
                    disi.word = disi.slice.readLong();
                    disi.numberOfOnes += Long.bitCount(disi.word);
                }
                disi.wordIndex = targetWordIndex;
                long leftBits = disi.word >>> target;
                if (leftBits != 0L) {
                    disi.doc = target + Long.numberOfTrailingZeros(leftBits);
                    disi.index = disi.numberOfOnes - Long.bitCount(leftBits);
                    return true;
                }
                while (++disi.wordIndex < 1024) {
                    disi.word = disi.slice.readLong();
                    if (disi.word == 0L) continue;
                    disi.index = disi.numberOfOnes;
                    disi.numberOfOnes += Long.bitCount(disi.word);
                    disi.doc = disi.block | disi.wordIndex << 6 | Long.numberOfTrailingZeros(disi.word);
                    return true;
                }
                return false;
            }

            @Override
            boolean advanceExactWithinBlock(IndexedDISI disi, int target) throws IOException {
                int targetInBlock = target & 0xFFFF;
                int targetWordIndex = targetInBlock >>> 6;
                for (int i = disi.wordIndex + 1; i <= targetWordIndex; ++i) {
                    disi.word = disi.slice.readLong();
                    disi.numberOfOnes += Long.bitCount(disi.word);
                }
                disi.wordIndex = targetWordIndex;
                long leftBits = disi.word >>> target;
                disi.index = disi.numberOfOnes - Long.bitCount(leftBits);
                return (leftBits & 1L) != 0L;
            }
        }
        ,
        ALL{

            @Override
            boolean advanceWithinBlock(IndexedDISI disi, int target) throws IOException {
                disi.doc = target;
                disi.index = target - disi.gap;
                return true;
            }

            @Override
            boolean advanceExactWithinBlock(IndexedDISI disi, int target) throws IOException {
                disi.index = target - disi.gap;
                return true;
            }
        };


        abstract boolean advanceWithinBlock(IndexedDISI var1, int var2) throws IOException;

        abstract boolean advanceExactWithinBlock(IndexedDISI var1, int var2) throws IOException;
    }
}

