/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.misc.CollectorMemoryTracker;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.FixedBitSet;

public class MemoryAccountingBitsetCollector
extends SimpleCollector {
    final CollectorMemoryTracker tracker;
    FixedBitSet bitSet = new FixedBitSet(0);
    int length = 0;
    int docBase = 0;

    public MemoryAccountingBitsetCollector(CollectorMemoryTracker tracker) {
        this.tracker = tracker;
        tracker.updateBytes(this.bitSet.ramBytesUsed());
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.length += context.reader().maxDoc();
        FixedBitSet newBitSet = FixedBitSet.ensureCapacity((FixedBitSet)this.bitSet, (int)this.length);
        if (newBitSet != this.bitSet) {
            this.tracker.updateBytes(newBitSet.ramBytesUsed() - this.bitSet.ramBytesUsed());
            this.bitSet = newBitSet;
        }
    }

    public void collect(int doc) {
        this.bitSet.set(this.docBase + doc);
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }
}

