/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2CellUnion;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Projections;
import com.google.common.geometry.S2Region;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.PriorityQueue;

public strictfp final class S2RegionCoverer {
    public static final int DEFAULT_MAX_CELLS = 8;
    private static final S2Cell[] FACE_CELLS = new S2Cell[6];
    private int minLevel = 0;
    private int maxLevel = 30;
    private int levelMod = 1;
    private int maxCells = 8;
    private boolean interiorCovering;
    S2Region region = null;
    ArrayList<S2CellId> result = new ArrayList();
    private PriorityQueue<QueueEntry> candidateQueue = new PriorityQueue<QueueEntry>(10, new QueueEntriesComparator());

    public void setMinLevel(int minLevel) {
        this.minLevel = Math.max(0, Math.min(30, minLevel));
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = Math.max(0, Math.min(30, maxLevel));
    }

    public int minLevel() {
        return this.minLevel;
    }

    public int maxLevel() {
        return this.maxLevel;
    }

    public int maxCells() {
        return this.maxCells;
    }

    public void setLevelMod(int levelMod) {
        this.levelMod = Math.max(1, Math.min(3, levelMod));
    }

    public int levelMod() {
        return this.levelMod;
    }

    public void setMaxCells(int maxCells) {
        this.maxCells = maxCells;
    }

    public void getCovering(S2Region region, ArrayList<S2CellId> covering) {
        S2CellUnion tmp = this.getCovering(region);
        tmp.denormalize(this.minLevel(), this.levelMod(), covering);
    }

    public void getInteriorCovering(S2Region region, ArrayList<S2CellId> interior) {
        S2CellUnion tmp = this.getInteriorCovering(region);
        tmp.denormalize(this.minLevel(), this.levelMod(), interior);
    }

    public S2CellUnion getCovering(S2Region region) {
        S2CellUnion covering = new S2CellUnion();
        this.getCovering(region, covering);
        return covering;
    }

    public void getCovering(S2Region region, S2CellUnion covering) {
        this.interiorCovering = false;
        this.getCoveringInternal(region);
        covering.initSwap(this.result);
    }

    public S2CellUnion getInteriorCovering(S2Region region) {
        S2CellUnion covering = new S2CellUnion();
        this.getInteriorCovering(region, covering);
        return covering;
    }

    public void getInteriorCovering(S2Region region, S2CellUnion covering) {
        this.interiorCovering = true;
        this.getCoveringInternal(region);
        covering.initSwap(this.result);
    }

    public static void getSimpleCovering(S2Region region, S2Point start, int level, ArrayList<S2CellId> output) {
        S2RegionCoverer.floodFill(region, S2CellId.fromPoint(start).parent(level), output);
    }

    private Candidate newCandidate(S2Cell cell) {
        if (!this.region.mayIntersect(cell)) {
            return null;
        }
        boolean isTerminal = false;
        if (cell.level() >= this.minLevel) {
            if (this.interiorCovering) {
                if (this.region.contains(cell)) {
                    isTerminal = true;
                } else if (cell.level() + this.levelMod > this.maxLevel) {
                    return null;
                }
            } else if (cell.level() + this.levelMod > this.maxLevel || this.region.contains(cell)) {
                isTerminal = true;
            }
        }
        Candidate candidate = new Candidate();
        candidate.cell = cell;
        candidate.isTerminal = isTerminal;
        if (!isTerminal) {
            Candidate.access$302(candidate, new Candidate[1 << this.maxChildrenShift()]);
        }
        return candidate;
    }

    private int maxChildrenShift() {
        return 2 * this.levelMod;
    }

    private void addCandidate(Candidate candidate) {
        if (candidate == null) {
            return;
        }
        if (candidate.isTerminal) {
            this.result.add(candidate.cell.id());
            return;
        }
        int numLevels = candidate.cell.level() < this.minLevel ? 1 : this.levelMod;
        int numTerminals = this.expandChildren(candidate, candidate.cell, numLevels);
        if (candidate.numChildren != 0) {
            if (!this.interiorCovering && numTerminals == 1 << this.maxChildrenShift() && candidate.cell.level() >= this.minLevel) {
                candidate.isTerminal = true;
                this.addCandidate(candidate);
            } else {
                int priority = -(((candidate.cell.level() << this.maxChildrenShift()) + candidate.numChildren << this.maxChildrenShift()) + numTerminals);
                this.candidateQueue.add(new QueueEntry(priority, candidate));
            }
        }
    }

    private int expandChildren(Candidate candidate, S2Cell cell, int numLevels) {
        --numLevels;
        S2Cell[] childCells = new S2Cell[4];
        for (int i = 0; i < 4; ++i) {
            childCells[i] = new S2Cell();
        }
        cell.subdivide(childCells);
        int numTerminals = 0;
        for (int i = 0; i < 4; ++i) {
            if (numLevels > 0) {
                if (!this.region.mayIntersect(childCells[i])) continue;
                numTerminals += this.expandChildren(candidate, childCells[i], numLevels);
                continue;
            }
            Candidate child = this.newCandidate(childCells[i]);
            if (child == null) continue;
            ((Candidate)candidate).children[((Candidate)candidate).numChildren++] = child;
            if (!child.isTerminal) continue;
            ++numTerminals;
        }
        return numTerminals;
    }

    private void getInitialCandidates() {
        if (this.maxCells >= 4) {
            S2Cap cap = this.region.getCapBound();
            int level = Math.min(S2Projections.MIN_WIDTH.getMaxLevel(2.0 * cap.angle().radians()), Math.min(this.maxLevel(), 29));
            if (this.levelMod() > 1 && level > this.minLevel()) {
                level -= (level - this.minLevel()) % this.levelMod();
            }
            if (level > 0) {
                ArrayList<S2CellId> base = new ArrayList<S2CellId>(4);
                S2CellId id = S2CellId.fromPoint(cap.axis());
                id.getVertexNeighbors(level, base);
                for (int i = 0; i < base.size(); ++i) {
                    this.addCandidate(this.newCandidate(new S2Cell(base.get(i))));
                }
                return;
            }
        }
        for (int face = 0; face < 6; ++face) {
            this.addCandidate(this.newCandidate(FACE_CELLS[face]));
        }
    }

    private void getCoveringInternal(S2Region region) {
        if (!this.candidateQueue.isEmpty() || !this.result.isEmpty()) {
            throw new IllegalStateException();
        }
        this.region = region;
        this.getInitialCandidates();
        while (!(this.candidateQueue.isEmpty() || this.interiorCovering && this.result.size() >= this.maxCells)) {
            Candidate candidate = this.candidateQueue.poll().candidate;
            if (candidate.cell.level() < this.minLevel || candidate.numChildren == 1 || this.result.size() + (this.interiorCovering ? 0 : this.candidateQueue.size()) + candidate.numChildren <= this.maxCells) {
                for (int i = 0; i < candidate.numChildren; ++i) {
                    this.addCandidate(candidate.children[i]);
                }
                continue;
            }
            if (this.interiorCovering) continue;
            candidate.isTerminal = true;
            this.addCandidate(candidate);
        }
        this.candidateQueue.clear();
        this.region = null;
    }

    private static void floodFill(S2Region region, S2CellId start, ArrayList<S2CellId> output) {
        HashSet<S2CellId> all = new HashSet<S2CellId>();
        ArrayList<S2CellId> frontier = new ArrayList<S2CellId>();
        output.clear();
        all.add(start);
        frontier.add(start);
        while (!frontier.isEmpty()) {
            S2CellId id = (S2CellId)frontier.get(frontier.size() - 1);
            frontier.remove(frontier.size() - 1);
            if (!region.mayIntersect(new S2Cell(id))) continue;
            output.add(id);
            S2CellId[] neighbors = new S2CellId[4];
            id.getEdgeNeighbors(neighbors);
            for (int edge = 0; edge < 4; ++edge) {
                S2CellId nbr = neighbors[edge];
                if (all.contains(nbr)) continue;
                frontier.add(nbr);
                all.add(nbr);
            }
        }
    }

    static {
        for (int face = 0; face < 6; ++face) {
            S2RegionCoverer.FACE_CELLS[face] = S2Cell.fromFacePosLevel(face, (byte)0, 0);
        }
    }

    strictfp static class QueueEntriesComparator
    implements Comparator<QueueEntry> {
        QueueEntriesComparator() {
        }

        @Override
        public int compare(QueueEntry x, QueueEntry y) {
            return x.id < y.id ? 1 : (x.id > y.id ? -1 : 0);
        }
    }

    strictfp static class QueueEntry {
        private int id;
        private Candidate candidate;

        public QueueEntry(int id, Candidate candidate) {
            this.id = id;
            this.candidate = candidate;
        }
    }

    strictfp static class Candidate {
        private S2Cell cell;
        private boolean isTerminal;
        private int numChildren;
        private Candidate[] children;

        Candidate() {
        }

        static /* synthetic */ Candidate[] access$302(Candidate x0, Candidate[] x1) {
            x0.children = x1;
            return x1;
        }
    }
}

