/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class RrdSyncThreadPool {
    private final AtomicReference<Thread> shutdownHook = new AtomicReference();
    private final ScheduledExecutorService syncExecutor;

    public RrdSyncThreadPool() {
        this(6);
    }

    public RrdSyncThreadPool(ScheduledExecutorService syncExecutor) {
        if (syncExecutor == null) {
            throw new NullPointerException("syncExecutor");
        }
        this.syncExecutor = syncExecutor;
    }

    public RrdSyncThreadPool(int syncPoolSize) {
        this(syncPoolSize, null);
    }

    public RrdSyncThreadPool(int syncPoolSize, ThreadFactory threadFactory) {
        ThreadFactory poolThreadFactory = threadFactory;
        if (poolThreadFactory == null) {
            poolThreadFactory = new DaemonThreadFactory("RRD4J Sync-ThreadPool for " + this);
        }
        this.syncExecutor = Executors.newScheduledThreadPool(syncPoolSize, poolThreadFactory);
    }

    public RrdSyncThreadPool registerShutdownHook() {
        ShutdownThread shutdownThread = new ShutdownThread();
        boolean wasNull = this.shutdownHook.compareAndSet(null, shutdownThread);
        if (wasNull) {
            Runtime.getRuntime().addShutdownHook(shutdownThread);
        }
        return this;
    }

    public void unregisterShutdownHook() {
        Thread shutdownThread = this.shutdownHook.getAndSet(null);
        if (shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(shutdownThread);
        }
    }

    public void shutdown() {
        this.unregisterShutdownHook();
        this.syncExecutor.shutdown();
    }

    ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.syncExecutor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    private class ShutdownThread
    extends Thread {
        public ShutdownThread() {
            super("RRD4J Sync-ThreadPool-Shutdown for " + RrdSyncThreadPool.this);
        }

        @Override
        public void run() {
            RrdSyncThreadPool.this.syncExecutor.shutdown();
        }
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String poolName;

        DaemonThreadFactory(String poolName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.poolName = poolName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.poolName + " [Thread-" + this.threadNumber.getAndIncrement() + "]");
            t.setDaemon(true);
            t.setContextClassLoader(null);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

