/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Hashing;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableEnumSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet$RegularSetBuilderImpl;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet$SetBuilderImpl;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableAsList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Sets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.SingletonImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.math.IntMath;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.j2objc.annotations.RetainedWith;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ImmutableSet
extends ImmutableCollection
implements Set {
    @LazyInit
    @NullableDecl
    @RetainedWith
    private transient ImmutableList asList;

    public static ImmutableSet of() {
        return RegularImmutableSet.EMPTY;
    }

    public static ImmutableSet of(Object object) {
        return new SingletonImmutableSet(object);
    }

    private static ImmutableSet construct(int n, Object ... objectArray) {
        switch (n) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object object = objectArray[0];
                return ImmutableSet.of(object);
            }
        }
        ImmutableSet$SetBuilderImpl immutableSet$SetBuilderImpl = new ImmutableSet$RegularSetBuilderImpl(4);
        for (int i = 0; i < n; ++i) {
            Object object = Preconditions.checkNotNull(objectArray[i]);
            immutableSet$SetBuilderImpl = ((ImmutableSet$SetBuilderImpl)immutableSet$SetBuilderImpl).add(object);
        }
        return ((ImmutableSet$SetBuilderImpl)immutableSet$SetBuilderImpl).review().build();
    }

    public static ImmutableSet copyOf(Collection collection) {
        Object[] objectArray;
        if (collection instanceof ImmutableSet && !(collection instanceof SortedSet)) {
            objectArray = (Object[])collection;
            if (!objectArray.isPartialView()) {
                return objectArray;
            }
        } else if (collection instanceof EnumSet) {
            return ImmutableSet.copyOfEnumSet((EnumSet)collection);
        }
        objectArray = collection.toArray();
        return ImmutableSet.construct(objectArray.length, objectArray);
    }

    public static ImmutableSet copyOf(Iterable iterable) {
        return iterable instanceof Collection ? ImmutableSet.copyOf((Collection)iterable) : ImmutableSet.copyOf(iterable.iterator());
    }

    public static ImmutableSet copyOf(Iterator iterator) {
        if (!iterator.hasNext()) {
            return ImmutableSet.of();
        }
        Object e = iterator.next();
        if (!iterator.hasNext()) {
            return ImmutableSet.of(e);
        }
        return new ImmutableSet$Builder().add(e).addAll(iterator).build();
    }

    public static ImmutableSet copyOf(Object[] objectArray) {
        switch (objectArray.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(objectArray[0]);
            }
        }
        return ImmutableSet.construct(objectArray.length, (Object[])objectArray.clone());
    }

    private static ImmutableSet copyOfEnumSet(EnumSet enumSet) {
        return ImmutableEnumSet.asImmutable(EnumSet.copyOf(enumSet));
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator iterator();

    @Override
    public ImmutableList asList() {
        ImmutableList immutableList = this.asList;
        return immutableList == null ? (this.asList = this.createAsList()) : immutableList;
    }

    ImmutableList createAsList() {
        return new RegularImmutableAsList((ImmutableCollection)this, this.toArray());
    }

    public static ImmutableSet$Builder builder() {
        return new ImmutableSet$Builder();
    }

    static Object[] rebuildHashTable(int n, Object[] objectArray, int n2) {
        Object[] objectArray2 = new Object[n];
        int n3 = objectArray2.length - 1;
        for (int i = 0; i < n2; ++i) {
            int n4;
            Object object = objectArray[i];
            int n5 = n4 = Hashing.smear(object.hashCode());
            while (true) {
                int n6;
                if (objectArray2[n6 = n5 & n3] == null) break;
                ++n5;
            }
            objectArray2[n6] = object;
        }
        return objectArray2;
    }

    static int chooseTableSize(int n) {
        if ((n = Math.max(n, 2)) < 0x2CCCCCCC) {
            int n2 = Integer.highestOneBit(n - 1) << 1;
            while ((double)n2 * 0.7 < (double)n) {
                n2 <<= 1;
            }
            return n2;
        }
        Preconditions.checkArgument(n < 0x40000000, "collection too large");
        return 0x40000000;
    }

    static boolean hashFloodingDetected(Object[] objectArray) {
        int n;
        int n2 = ImmutableSet.maxRunBeforeFallback(objectArray.length);
        int n3 = 0;
        while (n3 < objectArray.length && objectArray[n3] != null) {
            if (++n3 <= n2) continue;
            return true;
        }
        for (n = objectArray.length - 1; n > n3 && objectArray[n] != null; --n) {
            if (n3 + (objectArray.length - 1 - n) <= n2) continue;
            return true;
        }
        for (int i = n3 + 1; i < n; ++i) {
            int n4 = 0;
            while (i < n && objectArray[i] != null) {
                if (++n4 > n2) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    static int maxRunBeforeFallback(int n) {
        return 12 * IntMath.log2(n, RoundingMode.UNNECESSARY);
    }
}

