/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.BitSet;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;

public class IntersectOrExceptNode
extends SetOperatorNode {
    private int opType;
    public static final int INTERSECT_OP = 1;
    public static final int EXCEPT_OP = 2;
    private boolean addNewNodesCalled;
    private int[] intermediateOrderByColumns;
    private int[] intermediateOrderByDirection;
    private boolean[] intermediateOrderByNullsLow;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5) throws StandardException {
        super.init(object2, object3, object4, object5);
        this.opType = (Integer)object;
    }

    private int getOpType() {
        return this.opType;
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        this.intermediateOrderByColumns = new int[this.getResultColumns().size()];
        this.intermediateOrderByDirection = new int[this.intermediateOrderByColumns.length];
        this.intermediateOrderByNullsLow = new boolean[this.intermediateOrderByColumns.length];
        if (this.orderByList != null) {
            int n2;
            BitSet bitSet = new BitSet(this.intermediateOrderByColumns.length);
            int n3 = this.orderByList.size();
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                int n5;
                if (bitSet.get(n2)) continue;
                OrderByColumn orderByColumn = this.orderByList.getOrderByColumn(n2);
                this.intermediateOrderByDirection[n4] = orderByColumn.isAscending() ? 1 : -1;
                this.intermediateOrderByNullsLow[n4] = orderByColumn.isNullsOrderedLow();
                this.intermediateOrderByColumns[n4] = n5 = orderByColumn.getResultColumn().getColumnPosition() - 1;
                bitSet.set(n5);
                ++n4;
            }
            for (n2 = 0; n2 < this.intermediateOrderByColumns.length; ++n2) {
                if (bitSet.get(n2)) continue;
                this.intermediateOrderByDirection[n4] = 1;
                this.intermediateOrderByNullsLow[n4] = false;
                this.intermediateOrderByColumns[n4] = n2;
                ++n4;
            }
            this.orderByList = null;
        } else {
            for (int i = 0; i < this.intermediateOrderByColumns.length; ++i) {
                this.intermediateOrderByDirection[i] = 1;
                this.intermediateOrderByNullsLow[i] = false;
                this.intermediateOrderByColumns[i] = i;
            }
        }
        this.pushOrderingDown(this.leftResultSet);
        this.pushOrderingDown(this.rightResultSet);
        return super.preprocess(n, groupByList, fromList);
    }

    private void pushOrderingDown(ResultSetNode resultSetNode) throws StandardException {
        ContextManager contextManager = this.getContextManager();
        NodeFactory nodeFactory = this.getNodeFactory();
        OrderByList orderByList = (OrderByList)nodeFactory.getNode(7, contextManager);
        for (int i = 0; i < this.intermediateOrderByColumns.length; ++i) {
            OrderByColumn orderByColumn = (OrderByColumn)nodeFactory.getNode(104, nodeFactory.getNode(70, ReuseFactory.getInteger(this.intermediateOrderByColumns[i] + 1), contextManager), contextManager);
            if (this.intermediateOrderByDirection[i] < 0) {
                orderByColumn.setDescending();
            }
            if (this.intermediateOrderByNullsLow[i]) {
                orderByColumn.setNullsOrderedLow();
            }
            orderByList.addOrderByColumn(orderByColumn);
        }
        orderByList.bindOrderByColumns(resultSetNode);
        resultSetNode.pushOrderByList(orderByList);
    }

    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, null, costEstimate);
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, null, costEstimate);
        CostEstimate costEstimate2 = this.getCostEstimate(optimizer);
        CostEstimate costEstimate3 = this.leftResultSet.getCostEstimate();
        CostEstimate costEstimate4 = this.rightResultSet.getCostEstimate();
        costEstimate2.setCost(costEstimate3.getEstimatedCost() + costEstimate4.getEstimatedCost(), this.getRowCountEstimate(costEstimate3.rowCount(), costEstimate4.rowCount()), this.getSingleScanRowCountEstimate(costEstimate3.singleScanRowCount(), costEstimate4.singleScanRowCount()));
        return costEstimate2;
    }

    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        Optimizable optimizable = super.modifyAccessPath(jBitSet);
        if (this.addNewNodesCalled) {
            return optimizable;
        }
        return (Optimizable)((Object)this.addNewNodes());
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        ResultSetNode resultSetNode = super.modifyAccessPaths();
        if (this.addNewNodesCalled) {
            return resultSetNode;
        }
        return this.addNewNodes();
    }

    private ResultSetNode addNewNodes() throws StandardException {
        if (this.addNewNodesCalled) {
            return this;
        }
        this.addNewNodesCalled = true;
        ResultSetNode resultSetNode = this;
        if (this.orderByList != null) {
            resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(140, resultSetNode, this.orderByList, this.tableProperties, this.getContextManager());
        }
        if (this.offset != null || this.fetchFirst != null) {
            ResultColumnList resultColumnList = resultSetNode.getResultColumns().copyListAndObjects();
            resultColumnList.genVirtualColumnNodes(resultSetNode, resultSetNode.getResultColumns());
            resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(223, resultSetNode, resultColumnList, this.offset, this.fetchFirst, this.hasJDBClimitClause, this.getContextManager());
        }
        return resultSetNode;
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        this.costEstimate = this.getFinalCostEstimate();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.getLeftResultSet().generate(activationClassBuilder, methodBuilder);
        this.getRightResultSet().generate(activationClassBuilder, methodBuilder);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(this.resultSetNumber);
        methodBuilder.push(this.costEstimate.getEstimatedRowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        methodBuilder.push(this.getOpType());
        methodBuilder.push(this.all);
        methodBuilder.push(this.getCompilerContext().addSavedObject(this.intermediateOrderByColumns));
        methodBuilder.push(this.getCompilerContext().addSavedObject(this.intermediateOrderByDirection));
        methodBuilder.push(this.getCompilerContext().addSavedObject(this.intermediateOrderByNullsLow));
        methodBuilder.callMethod((short)185, null, "getSetOpResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 11);
    }

    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        CostEstimate costEstimate = this.leftResultSet.getFinalCostEstimate();
        CostEstimate costEstimate2 = this.rightResultSet.getFinalCostEstimate();
        this.finalCostEstimate = this.getNewCostEstimate();
        this.finalCostEstimate.setCost(costEstimate.getEstimatedCost() + costEstimate2.getEstimatedCost(), this.getRowCountEstimate(costEstimate.rowCount(), costEstimate2.rowCount()), this.getSingleScanRowCountEstimate(costEstimate.singleScanRowCount(), costEstimate2.singleScanRowCount()));
        return this.finalCostEstimate;
    }

    String getOperatorName() {
        switch (this.opType) {
            case 1: {
                return "INTERSECT";
            }
            case 2: {
                return "EXCEPT";
            }
        }
        return "?";
    }

    double getRowCountEstimate(double d, double d2) {
        switch (this.opType) {
            case 1: {
                return Math.min(d, d2) / 2.0;
            }
            case 2: {
                return (d + Math.max(0.0, d - d2)) / 2.0;
            }
        }
        return 1.0;
    }

    double getSingleScanRowCountEstimate(double d, double d2) {
        return this.getRowCountEstimate(d, d2);
    }
}

