/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import com.carrotsearch.hppc.IntFloatHashMap;
import com.carrotsearch.hppc.cursors.FloatCursor;
import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.solr.util.DynamicMap;
import org.apache.solr.util.FloatConsumer;

public class IntFloatDynamicMap
implements DynamicMap {
    private int maxSize;
    private IntFloatHashMap hashMap;
    private float[] keyValues;
    private float emptyValue;
    private int threshold;

    public IntFloatDynamicMap(int expectedKeyMax, float emptyValue) {
        this.threshold = this.threshold(expectedKeyMax);
        this.maxSize = expectedKeyMax;
        this.emptyValue = emptyValue;
        if (this.useArrayBased(expectedKeyMax)) {
            this.upgradeToArray();
        } else {
            this.hashMap = new IntFloatHashMap(this.mapExpectedElements(expectedKeyMax));
        }
    }

    private void upgradeToArray() {
        this.keyValues = new float[this.maxSize];
        if (this.emptyValue != 0.0f) {
            Arrays.fill(this.keyValues, this.emptyValue);
        }
        if (this.hashMap != null) {
            this.hashMap.forEach((key, value) -> {
                this.keyValues[key] = value;
            });
            this.hashMap = null;
        }
    }

    private void growBuffer(int minSize) {
        assert (this.keyValues != null);
        int size = this.keyValues.length;
        this.keyValues = ArrayUtil.grow((float[])this.keyValues, (int)minSize);
        if (this.emptyValue != 0.0f) {
            for (int i = size; i < this.keyValues.length; ++i) {
                this.keyValues[i] = this.emptyValue;
            }
        }
    }

    public void put(int key, float value) {
        if (this.keyValues != null) {
            if (key >= this.keyValues.length) {
                this.growBuffer(key + 1);
            }
            this.keyValues[key] = value;
        } else {
            this.hashMap.put(key, value);
            this.maxSize = Math.max(key + 1, this.maxSize);
            if (this.hashMap.size() >= this.threshold) {
                this.upgradeToArray();
            }
        }
    }

    public float get(int key) {
        if (this.keyValues != null) {
            if (key >= this.keyValues.length) {
                return this.emptyValue;
            }
            return this.keyValues[key];
        }
        return this.hashMap.getOrDefault(key, this.emptyValue);
    }

    public void forEachValue(FloatConsumer consumer) {
        if (this.keyValues != null) {
            for (float val : this.keyValues) {
                if (val == this.emptyValue) continue;
                consumer.accept(val);
            }
        } else {
            for (FloatCursor ord : this.hashMap.values()) {
                consumer.accept(ord.value);
            }
        }
    }

    public void remove(int key) {
        if (this.keyValues != null) {
            if (key < this.keyValues.length) {
                this.keyValues[key] = this.emptyValue;
            }
        } else {
            this.hashMap.remove(key);
        }
    }
}

