/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLBufferStorage;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.GLArrayDataClient;
import com.jogamp.opengl.util.GLArrayDataEditable;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jogamp.opengl.util.GLArrayHandler;
import jogamp.opengl.util.GLArrayHandlerInterleaved;
import jogamp.opengl.util.GLDataArrayHandler;
import jogamp.opengl.util.GLFixedArrayHandler;
import jogamp.opengl.util.GLFixedArrayHandlerFlat;
import jogamp.opengl.util.glsl.GLSLArrayHandler;
import jogamp.opengl.util.glsl.GLSLArrayHandlerFlat;
import jogamp.opengl.util.glsl.GLSLArrayHandlerInterleaved;

public class GLArrayDataServer
extends GLArrayDataClient
implements GLArrayDataEditable {
    private int interleavedOffset = 0;
    private GLBufferStorage mappedStorage = null;

    public static GLArrayDataServer createFixed(int n, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLFixedArrayHandler gLFixedArrayHandler = new GLFixedArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, n, n2, n3, bl, n4, buffer, buffer.limit(), 0, false, gLFixedArrayHandler, 0, 0L, n5, 34962, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createFixed(int n, int n2, int n3, boolean bl, int n4, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLFixedArrayHandler gLFixedArrayHandler = new GLFixedArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, n, n2, n3, bl, 0, null, n4, 0, false, gLFixedArrayHandler, 0, 0L, n5, 34962, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createGLSL(String string, int n, int n2, boolean bl, int n3, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(string, -1, n, n2, bl, 0, null, n3, 0, true, gLSLArrayHandler, 0, 0L, n4, 34962, true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createGLSLMapped(String string, int n, int n2, boolean bl, int n3, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(string, -1, n, n2, bl, 0, null, 0, n3, true, gLSLArrayHandler, 0, 0L, n4, 34962, true);
        gLArrayDataServer.seal(true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createGLSL(String string, int n, int n2, boolean bl, int n3, Buffer buffer, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(string, -1, n, n2, bl, n3, buffer, buffer.limit(), 0, true, gLSLArrayHandler, 0, 0L, n4, 34962, true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createData(int n, int n2, int n3, Buffer buffer, int n4, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLDataArrayHandler gLDataArrayHandler = new GLDataArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, -1, n, n2, false, n3, buffer, buffer.limit(), 0, false, gLDataArrayHandler, 0, 0L, n4, n5, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createData(int n, int n2, int n3, int n4, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLDataArrayHandler gLDataArrayHandler = new GLDataArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, -1, n, n2, false, 0, null, n3, 0, false, gLDataArrayHandler, 0, 0L, n4, n5, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createDataMapped(int n, int n2, int n3, int n4, int n5) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLDataArrayHandler gLDataArrayHandler = new GLDataArrayHandler(gLArrayDataServer);
        gLArrayDataServer.init(null, -1, n, n2, false, 0, null, 0, n3, false, gLDataArrayHandler, 0, 0L, n4, n5, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createFixedInterleaved(int n, int n2, boolean bl, int n3, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLArrayHandlerInterleaved gLArrayHandlerInterleaved = new GLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n, n2, false, 0, null, n3, 0, false, gLArrayHandlerInterleaved, 0, 0L, n4, 34962, false);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createFixedInterleavedMapped(int n, int n2, boolean bl, int n3, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLArrayHandlerInterleaved gLArrayHandlerInterleaved = new GLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n, n2, false, 0, null, 0, n3, false, gLArrayHandlerInterleaved, 0, 0L, n4, 34962, false);
        gLArrayDataServer.seal(true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createFixedInterleaved(int n, int n2, boolean bl, int n3, Buffer buffer, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLArrayHandlerInterleaved gLArrayHandlerInterleaved = new GLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n, n2, bl, n3, buffer, buffer.limit(), 0, false, gLArrayHandlerInterleaved, 0, 0L, n4, 34962, false);
        return gLArrayDataServer;
    }

    public GLArrayData addFixedSubArray(int n, int n2, int n3) {
        if (this.interleavedOffset >= this.getComponentCount() * this.getComponentSizeInBytes()) {
            int n4 = this.interleavedOffset / this.getComponentSizeInBytes();
            throw new GLException("Interleaved offset > total components (" + n4 + " > " + this.getComponentCount() + ")");
        }
        if (this.usesGLSL) {
            throw new GLException("buffer uses GLSL");
        }
        int n5 = 0 == this.getStride() ? this.getComponentCount() * this.getComponentSizeInBytes() : this.getStride();
        GLArrayDataWrapper gLArrayDataWrapper = 0 < this.mappedElementCount ? GLArrayDataWrapper.createFixed(n, n2, this.getComponentType(), this.getNormalized(), n5, this.mappedElementCount, this.getVBOName(), (long)this.interleavedOffset, this.getVBOUsage(), n3) : GLArrayDataWrapper.createFixed(n, n2, this.getComponentType(), this.getNormalized(), n5, this.getBuffer(), this.getVBOName(), (long)this.interleavedOffset, this.getVBOUsage(), n3);
        gLArrayDataWrapper.setVBOEnabled(this.isVBO());
        this.interleavedOffset += n2 * this.getComponentSizeInBytes();
        if (34962 == n3) {
            this.glArrayHandler.addSubHandler(new GLFixedArrayHandlerFlat(gLArrayDataWrapper));
        }
        return gLArrayDataWrapper;
    }

    public static GLArrayDataServer createGLSLInterleaved(int n, int n2, boolean bl, int n3, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandlerInterleaved gLSLArrayHandlerInterleaved = new GLSLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n, n2, bl, 0, null, n3, 0, false, gLSLArrayHandlerInterleaved, 0, 0L, n4, 34962, true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createGLSLInterleavedMapped(int n, int n2, boolean bl, int n3, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandlerInterleaved gLSLArrayHandlerInterleaved = new GLSLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n, n2, bl, 0, null, 0, n3, false, gLSLArrayHandlerInterleaved, 0, 0L, n4, 34962, true);
        gLArrayDataServer.seal(true);
        return gLArrayDataServer;
    }

    public static GLArrayDataServer createGLSLInterleaved(int n, int n2, boolean bl, int n3, Buffer buffer, int n4) throws GLException {
        GLArrayDataServer gLArrayDataServer = new GLArrayDataServer();
        GLSLArrayHandlerInterleaved gLSLArrayHandlerInterleaved = new GLSLArrayHandlerInterleaved(gLArrayDataServer);
        gLArrayDataServer.init("mgl_InterleaveArray", -1, n, n2, bl, n3, buffer, buffer.limit(), 0, false, gLSLArrayHandlerInterleaved, 0, 0L, n4, 34962, true);
        return gLArrayDataServer;
    }

    public GLArrayData addGLSLSubArray(String string, int n, int n2) {
        if (this.interleavedOffset >= this.getComponentCount() * this.getComponentSizeInBytes()) {
            int n3 = this.interleavedOffset / this.getComponentSizeInBytes();
            throw new GLException("Interleaved offset > total components (" + n3 + " > " + this.getComponentCount() + ")");
        }
        if (!this.usesGLSL) {
            throw new GLException("buffer uses fixed function");
        }
        int n4 = 0 == this.getStride() ? this.getComponentCount() * this.getComponentSizeInBytes() : this.getStride();
        GLArrayDataWrapper gLArrayDataWrapper = 0 < this.mappedElementCount ? GLArrayDataWrapper.createGLSL(string, n, this.getComponentType(), this.getNormalized(), n4, this.mappedElementCount, this.getVBOName(), (long)this.interleavedOffset, this.getVBOUsage(), n2) : GLArrayDataWrapper.createGLSL(string, n, this.getComponentType(), this.getNormalized(), n4, this.getBuffer(), this.getVBOName(), (long)this.interleavedOffset, this.getVBOUsage(), n2);
        gLArrayDataWrapper.setVBOEnabled(this.isVBO());
        this.interleavedOffset += n * this.getComponentSizeInBytes();
        if (34962 == n2) {
            this.glArrayHandler.addSubHandler(new GLSLArrayHandlerFlat(gLArrayDataWrapper));
        }
        return gLArrayDataWrapper;
    }

    public final void setInterleavedOffset(int n) {
        this.interleavedOffset = n;
    }

    public final int getInterleavedOffset() {
        return this.interleavedOffset;
    }

    @Override
    public void destroy(GL gL) {
        int n = this.vboName;
        super.destroy(gL);
        if (n != 0) {
            int[] nArray = new int[]{n};
            gL.glDeleteBuffers(1, nArray, 0);
            this.vboName = 0;
        }
    }

    @Override
    public void setVBOEnabled(boolean bl) {
        this.checkSeal(false);
        super.setVBOEnabled(bl);
    }

    public GLBufferStorage mapStorage(GL gL, int n) {
        if (null != this.getBuffer()) {
            throw new IllegalStateException("user buffer not null");
        }
        if (null != this.mappedStorage) {
            throw new IllegalStateException("already mapped: " + this.mappedStorage);
        }
        this.checkSeal(true);
        this.bindBuffer(gL, true);
        gL.glBufferData(this.getVBOTarget(), this.getSizeInBytes(), null, this.getVBOUsage());
        GLBufferStorage gLBufferStorage = gL.mapBuffer(this.getVBOTarget(), n);
        this.setMappedBuffer(gLBufferStorage);
        this.bindBuffer(gL, false);
        this.seal(false);
        this.rewind();
        return gLBufferStorage;
    }

    public GLBufferStorage mapStorage(GL gL, long l, long l2, int n) {
        if (null != this.getBuffer()) {
            throw new IllegalStateException("user buffer not null");
        }
        if (null != this.mappedStorage) {
            throw new IllegalStateException("already mapped: " + this.mappedStorage);
        }
        this.checkSeal(true);
        this.bindBuffer(gL, true);
        gL.glBufferData(this.getVBOTarget(), this.getSizeInBytes(), null, this.getVBOUsage());
        GLBufferStorage gLBufferStorage = gL.mapBufferRange(this.getVBOTarget(), l, l2, n);
        this.setMappedBuffer(gLBufferStorage);
        this.bindBuffer(gL, false);
        this.seal(false);
        this.rewind();
        return gLBufferStorage;
    }

    private final void setMappedBuffer(GLBufferStorage gLBufferStorage) {
        this.mappedStorage = gLBufferStorage;
        ByteBuffer byteBuffer = gLBufferStorage.getMappedBuffer();
        if (this.componentClazz == ByteBuffer.class) {
            this.buffer = byteBuffer;
        } else if (this.componentClazz == ShortBuffer.class) {
            this.buffer = byteBuffer.asShortBuffer();
        } else if (this.componentClazz == IntBuffer.class) {
            this.buffer = byteBuffer.asIntBuffer();
        } else if (this.componentClazz == FloatBuffer.class) {
            this.buffer = byteBuffer.asFloatBuffer();
        } else {
            throw new GLException("Given Buffer Class not supported: " + this.componentClazz + ":\n\t" + this);
        }
    }

    public void unmapStorage(GL gL) {
        if (null == this.mappedStorage) {
            throw new IllegalStateException("not mapped");
        }
        this.mappedStorage = null;
        this.buffer = null;
        this.seal(true);
        this.bindBuffer(gL, true);
        gL.glUnmapBuffer(this.getVBOTarget());
        this.bindBuffer(gL, false);
    }

    @Override
    public String toString() {
        return "GLArrayDataServer[" + this.name + ", index " + this.index + ", location " + this.location + ", isVertexAttribute " + this.isVertexAttribute + ", usesGLSL " + this.usesGLSL + ", usesShaderState " + (null != this.shaderState) + ", dataType 0x" + Integer.toHexString(this.componentType) + ", bufferClazz " + this.componentClazz + ", elements " + this.getElementCount() + ", components " + this.componentsPerElement + ", stride " + this.strideB + "b " + this.strideL + "c, initialElementCount " + this.initialElementCount + ", mappedElementCount " + this.mappedElementCount + ", mappedStorage " + this.mappedStorage + ", vboEnabled " + this.vboEnabled + ", vboName " + this.vboName + ", vboUsage 0x" + Integer.toHexString(this.vboUsage) + ", vboTarget 0x" + Integer.toHexString(this.vboTarget) + ", vboOffset " + this.vboOffset + ", sealed " + this.sealed + ", bufferEnabled " + this.bufferEnabled + ", bufferWritten " + this.bufferWritten + ", buffer " + this.buffer + ", alive " + this.alive + "]";
    }

    @Override
    protected void init(String string, int n, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5, int n6, boolean bl2, GLArrayHandler gLArrayHandler, int n7, long l, int n8, int n9, boolean bl3) throws GLException {
        super.init(string, n, n2, n3, bl, n4, buffer, n5, n6, bl2, gLArrayHandler, n7, l, n8, n9, bl3);
        this.vboEnabled = true;
    }

    @Override
    protected void init_vbo(GL gL) {
        super.init_vbo(gL);
        if (this.vboEnabled && this.vboName == 0) {
            int[] nArray = new int[1];
            gL.glGenBuffers(1, nArray, 0);
            this.vboName = nArray[0];
            if (0 < this.interleavedOffset) {
                this.glArrayHandler.setSubArrayVBOName(this.vboName);
            }
        }
    }

    protected GLArrayDataServer() {
    }

    public GLArrayDataServer(GLArrayDataServer gLArrayDataServer) {
        super(gLArrayDataServer);
        this.interleavedOffset = gLArrayDataServer.interleavedOffset;
        this.mappedStorage = gLArrayDataServer.mappedStorage;
    }
}

