/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image;

import org.sunflow.image.Color;
import org.sunflow.image.XYZColor;
import org.sunflow.math.MathUtils;

public final class RGBSpace {
    public static final RGBSpace ADOBE = new RGBSpace(0.64f, 0.33f, 0.21f, 0.71f, 0.15f, 0.06f, 0.31271f, 0.32902f, 2.2f, 0.0f);
    public static final RGBSpace APPLE = new RGBSpace(0.625f, 0.34f, 0.28f, 0.595f, 0.155f, 0.07f, 0.31271f, 0.32902f, 1.8f, 0.0f);
    public static final RGBSpace NTSC = new RGBSpace(0.67f, 0.33f, 0.21f, 0.71f, 0.14f, 0.08f, 0.3101f, 0.3162f, 2.2222223f, 0.018f);
    public static final RGBSpace HDTV = new RGBSpace(0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f, 0.31271f, 0.32902f, 2.2222223f, 0.018f);
    public static final RGBSpace SRGB = new RGBSpace(0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f, 0.31271f, 0.32902f, 2.4f, 0.00304f);
    public static final RGBSpace CIE = new RGBSpace(0.735f, 0.265f, 0.274f, 0.717f, 0.167f, 0.009f, 0.33333334f, 0.33333334f, 2.2f, 0.0f);
    public static final RGBSpace EBU = new RGBSpace(0.64f, 0.33f, 0.29f, 0.6f, 0.15f, 0.06f, 0.31271f, 0.32902f, 2.2222223f, 0.018f);
    public static final RGBSpace SMPTE_C = new RGBSpace(0.63f, 0.34f, 0.31f, 0.595f, 0.155f, 0.07f, 0.31271f, 0.32902f, 2.2222223f, 0.018f);
    public static final RGBSpace SMPTE_240M = new RGBSpace(0.63f, 0.34f, 0.31f, 0.595f, 0.155f, 0.07f, 0.31271f, 0.32902f, 2.2222223f, 0.018f);
    public static final RGBSpace WIDE_GAMUT = new RGBSpace(0.7347f, 0.2653f, 0.1152f, 0.8264f, 0.1566f, 0.0177f, 0.3457f, 0.3585f, 2.2f, 0.0f);
    private final float gamma;
    private final float breakPoint;
    private final float slope;
    private final float slopeMatch;
    private final float segmentOffset;
    private final float xr;
    private final float yr;
    private final float zr;
    private final float xg;
    private final float yg;
    private final float zg;
    private final float xb;
    private final float yb;
    private final float zb;
    private final float xw;
    private final float yw;
    private final float zw;
    private final float rx;
    private final float ry;
    private final float rz;
    private final float gx;
    private final float gy;
    private final float gz;
    private final float bx;
    private final float by;
    private final float bz;
    private final float rw;
    private final float gw;
    private final float bw;
    private final int[] GAMMA_CURVE;
    private final int[] INV_GAMMA_CURVE;

    public RGBSpace(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11;
        this.gamma = f9;
        this.breakPoint = f10;
        if (f10 > 0.0f) {
            this.slope = 1.0f / (f9 / (float)Math.pow(f10, 1.0f / f9 - 1.0f) - f9 * f10 + f10);
            this.slopeMatch = f9 * this.slope / (float)Math.pow(f10, 1.0f / f9 - 1.0f);
            this.segmentOffset = this.slopeMatch * (float)Math.pow(f10, 1.0f / f9) - this.slope * f10;
        } else {
            this.slope = 1.0f;
            this.slopeMatch = 1.0f;
            this.segmentOffset = 0.0f;
        }
        this.GAMMA_CURVE = new int[256];
        this.INV_GAMMA_CURVE = new int[256];
        for (int i = 0; i < 256; ++i) {
            f11 = (float)i / 255.0f;
            this.GAMMA_CURVE[i] = MathUtils.clamp((int)(this.gammaCorrect(f11) * 255.0f + 0.5f), 0, 255);
            this.INV_GAMMA_CURVE[i] = MathUtils.clamp((int)(this.ungammaCorrect(f11) * 255.0f + 0.5f), 0, 255);
        }
        float f12 = f;
        f11 = f2;
        float f13 = 1.0f - (f12 + f11);
        float f14 = f3;
        float f15 = f4;
        float f16 = 1.0f - (f14 + f15);
        float f17 = f5;
        float f18 = f6;
        float f19 = 1.0f - (f17 + f18);
        this.xw = f7;
        this.yw = f8;
        this.zw = 1.0f - (this.xw + this.yw);
        float f20 = f15 * f19 - f18 * f16;
        float f21 = f17 * f16 - f14 * f19;
        float f22 = f14 * f18 - f17 * f15;
        float f23 = f18 * f13 - f11 * f19;
        float f24 = f12 * f19 - f17 * f13;
        float f25 = f17 * f11 - f12 * f18;
        float f26 = f11 * f16 - f15 * f13;
        float f27 = f14 * f13 - f12 * f16;
        float f28 = f12 * f15 - f14 * f11;
        this.rw = (f20 * this.xw + f21 * this.yw + f22 * this.zw) / this.yw;
        this.gw = (f23 * this.xw + f24 * this.yw + f25 * this.zw) / this.yw;
        this.bw = (f26 * this.xw + f27 * this.yw + f28 * this.zw) / this.yw;
        this.rx = f20 / this.rw;
        this.ry = f21 / this.rw;
        this.rz = f22 / this.rw;
        this.gx = f23 / this.gw;
        this.gy = f24 / this.gw;
        this.gz = f25 / this.gw;
        this.bx = f26 / this.bw;
        this.by = f27 / this.bw;
        this.bz = f28 / this.bw;
        float f29 = 1.0f / (this.rx * (this.gy * this.bz - this.by * this.gz) - this.ry * (this.gx * this.bz - this.bx * this.gz) + this.rz * (this.gx * this.by - this.bx * this.gy));
        this.xr = f29 * (this.gy * this.bz - this.gz * this.by);
        this.xg = f29 * (this.rz * this.by - this.ry * this.bz);
        this.xb = f29 * (this.ry * this.gz - this.rz * this.gy);
        this.yr = f29 * (this.gz * this.bx - this.gx * this.bz);
        this.yg = f29 * (this.rx * this.bz - this.rz * this.bx);
        this.yb = f29 * (this.rz * this.gx - this.rx * this.gz);
        this.zr = f29 * (this.gx * this.by - this.gy * this.bx);
        this.zg = f29 * (this.ry * this.bx - this.rx * this.by);
        this.zb = f29 * (this.rx * this.gy - this.ry * this.gx);
    }

    public final Color convertXYZtoRGB(XYZColor xYZColor) {
        return this.convertXYZtoRGB(xYZColor.getX(), xYZColor.getY(), xYZColor.getZ());
    }

    public final Color convertXYZtoRGB(float f, float f2, float f3) {
        float f4 = this.rx * f + this.ry * f2 + this.rz * f3;
        float f5 = this.gx * f + this.gy * f2 + this.gz * f3;
        float f6 = this.bx * f + this.by * f2 + this.bz * f3;
        return new Color(f4, f5, f6);
    }

    public final XYZColor convertRGBtoXYZ(Color color) {
        float[] fArray = color.getRGB();
        float f = this.xr * fArray[0] + this.xg * fArray[1] + this.xb * fArray[2];
        float f2 = this.yr * fArray[0] + this.yg * fArray[1] + this.yb * fArray[2];
        float f3 = this.zr * fArray[0] + this.zg * fArray[1] + this.zb * fArray[2];
        return new XYZColor(f, f2, f3);
    }

    public final boolean insideGamut(float f, float f2, float f3) {
        return f >= 0.0f && f2 >= 0.0f && f3 >= 0.0f;
    }

    public final float gammaCorrect(float f) {
        if (f <= 0.0f) {
            return 0.0f;
        }
        if (f >= 1.0f) {
            return 1.0f;
        }
        if (f <= this.breakPoint) {
            return this.slope * f;
        }
        return this.slopeMatch * (float)Math.pow(f, 1.0f / this.gamma) - this.segmentOffset;
    }

    public final float ungammaCorrect(float f) {
        if (f <= 0.0f) {
            return 0.0f;
        }
        if (f >= 1.0f) {
            return 1.0f;
        }
        if (f <= this.breakPoint * this.slope) {
            return f / this.slope;
        }
        return (float)Math.pow((f + this.segmentOffset) / this.slopeMatch, this.gamma);
    }

    public final int rgbToNonLinear(int n) {
        int n2 = this.GAMMA_CURVE[n >> 16 & 0xFF];
        int n3 = this.GAMMA_CURVE[n >> 8 & 0xFF];
        int n4 = this.GAMMA_CURVE[n & 0xFF];
        return n2 << 16 | n3 << 8 | n4;
    }

    public final int rgbToLinear(int n) {
        int n2 = this.INV_GAMMA_CURVE[n >> 16 & 0xFF];
        int n3 = this.INV_GAMMA_CURVE[n >> 8 & 0xFF];
        int n4 = this.INV_GAMMA_CURVE[n & 0xFF];
        return n2 << 16 | n3 << 8 | n4;
    }

    public final byte rgbToNonLinear(byte by) {
        return (byte)this.GAMMA_CURVE[by & 0xFF];
    }

    public final byte rgbToLinear(byte by) {
        return (byte)this.INV_GAMMA_CURVE[by & 0xFF];
    }

    public final String toString() {
        String string = "Gamma function parameters:\n";
        string = string + String.format("  * Gamma:          %7.4f\n", Float.valueOf(this.gamma));
        string = string + String.format("  * Breakpoint:     %7.4f\n", Float.valueOf(this.breakPoint));
        string = string + String.format("  * Slope:          %7.4f\n", Float.valueOf(this.slope));
        string = string + String.format("  * Slope Match:    %7.4f\n", Float.valueOf(this.slopeMatch));
        string = string + String.format("  * Segment Offset: %7.4f\n", Float.valueOf(this.segmentOffset));
        string = string + "XYZ -> RGB Matrix:\n";
        string = string + String.format("| %7.4f %7.4f %7.4f|\n", Float.valueOf(this.rx), Float.valueOf(this.ry), Float.valueOf(this.rz));
        string = string + String.format("| %7.4f %7.4f %7.4f|\n", Float.valueOf(this.gx), Float.valueOf(this.gy), Float.valueOf(this.gz));
        string = string + String.format("| %7.4f %7.4f %7.4f|\n", Float.valueOf(this.bx), Float.valueOf(this.by), Float.valueOf(this.bz));
        string = string + "RGB -> XYZ Matrix:\n";
        string = string + String.format("| %7.4f %7.4f %7.4f|\n", Float.valueOf(this.xr), Float.valueOf(this.xg), Float.valueOf(this.xb));
        string = string + String.format("| %7.4f %7.4f %7.4f|\n", Float.valueOf(this.yr), Float.valueOf(this.yg), Float.valueOf(this.yb));
        string = string + String.format("| %7.4f %7.4f %7.4f|\n", Float.valueOf(this.zr), Float.valueOf(this.zg), Float.valueOf(this.zb));
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println(SRGB.toString());
        System.out.println(HDTV.toString());
        System.out.println(WIDE_GAMUT.toString());
    }
}

