/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GeometryStripArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

class TriangleFanArrayRetained
extends GeometryStripArrayRetained {
    TriangleFanArrayRetained() {
        this.geoType = 6;
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int n, Point3d point3d, GeometryRetained geometryRetained, int n2) {
        Point3d[] point3dArray = new Point3d[3];
        double[] dArray = new double[1];
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = 0;
        point3dArray[0] = new Point3d();
        point3dArray[1] = new Point3d();
        point3dArray[2] = new Point3d();
        int[] nArray = new int[3];
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (n3 < this.stripVertexCounts.length) {
                    int n4 = this.stripStartVertexIndices[n3];
                    int n5 = n4 + this.stripVertexCounts[n3++];
                    for (int i = 0; i < 2; ++i) {
                        nArray[i] = n4;
                        this.getVertexData(n4++, point3dArray[i]);
                    }
                    while (n4 < n5) {
                        nArray[2] = n4;
                        this.getVertexData(n4++, point3dArray[2]);
                        if (this.intersectRay(point3dArray, pickRay, dArray, point3d)) {
                            if (n == 0) {
                                return true;
                            }
                            if (dArray[0] < d) {
                                d = dArray[0];
                                d2 = point3d.x;
                                d3 = point3d.y;
                                d4 = point3d.z;
                                if ((n & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set((Tuple3d)point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                while (n3 < this.stripVertexCounts.length) {
                    int n6 = this.stripStartVertexIndices[n3];
                    int n7 = n6 + this.stripVertexCounts[n3++];
                    for (int i = 0; i < 2; ++i) {
                        nArray[i] = n6;
                        this.getVertexData(n6++, point3dArray[i]);
                    }
                    while (n6 < n7) {
                        nArray[2] = n6;
                        this.getVertexData(n6++, point3dArray[2]);
                        if (this.intersectSegment(point3dArray, pickSegment.start, pickSegment.end, dArray, point3d)) {
                            if (n == 0) {
                                return true;
                            }
                            if (dArray[0] < d) {
                                d = dArray[0];
                                d2 = point3d.x;
                                d3 = point3d.y;
                                d4 = point3d.z;
                                if ((n & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set((Tuple3d)point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 6: {
                BoundingBox boundingBox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (n3 < this.stripVertexCounts.length) {
                    int n8 = this.stripStartVertexIndices[n3];
                    int n9 = n8 + this.stripVertexCounts[n3++];
                    for (int i = 0; i < 2; ++i) {
                        nArray[i] = n8;
                        this.getVertexData(n8++, point3dArray[i]);
                    }
                    while (n8 < n9) {
                        nArray[2] = n8;
                        this.getVertexData(n8++, point3dArray[2]);
                        if (this.intersectBoundingBox(point3dArray, boundingBox, dArray, point3d)) {
                            if (n == 0) {
                                return true;
                            }
                            if (dArray[0] < d) {
                                d = dArray[0];
                                d2 = point3d.x;
                                d3 = point3d.y;
                                d4 = point3d.z;
                                if ((n & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set((Tuple3d)point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere boundingSphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (n3 < this.stripVertexCounts.length) {
                    int n10 = this.stripStartVertexIndices[n3];
                    int n11 = n10 + this.stripVertexCounts[n3++];
                    for (int i = 0; i < 2; ++i) {
                        nArray[i] = n10;
                        this.getVertexData(n10++, point3dArray[i]);
                    }
                    while (n10 < n11) {
                        nArray[2] = n10;
                        this.getVertexData(n10++, point3dArray[2]);
                        if (this.intersectBoundingSphere(point3dArray, boundingSphere, dArray, point3d)) {
                            if (n == 0) {
                                return true;
                            }
                            if (dArray[0] < d) {
                                d = dArray[0];
                                d2 = point3d.x;
                                d3 = point3d.y;
                                d4 = point3d.z;
                                if ((n & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set((Tuple3d)point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope boundingPolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (n3 < this.stripVertexCounts.length) {
                    int n12 = this.stripStartVertexIndices[n3];
                    int n13 = n12 + this.stripVertexCounts[n3++];
                    for (int i = 0; i < 2; ++i) {
                        nArray[i] = n12;
                        this.getVertexData(n12++, point3dArray[i]);
                    }
                    while (n12 < n13) {
                        nArray[2] = n12;
                        this.getVertexData(n12++, point3dArray[2]);
                        if (this.intersectBoundingPolytope(point3dArray, boundingPolytope, dArray, point3d)) {
                            if (n == 0) {
                                return true;
                            }
                            if (dArray[0] < d) {
                                d = dArray[0];
                                d2 = point3d.x;
                                d3 = point3d.y;
                                d4 = point3d.z;
                                if ((n & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set((Tuple3d)point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (n3 < this.stripVertexCounts.length) {
                    int n14 = this.stripStartVertexIndices[n3];
                    int n15 = n14 + this.stripVertexCounts[n3++];
                    for (int i = 0; i < 2; ++i) {
                        nArray[i] = n14;
                        this.getVertexData(n14++, point3dArray[i]);
                    }
                    while (n14 < n15) {
                        nArray[2] = n14;
                        this.getVertexData(n14++, point3dArray[2]);
                        if (this.intersectCylinder(point3dArray, pickCylinder, dArray, point3d)) {
                            if (n == 0) {
                                return true;
                            }
                            if (dArray[0] < d) {
                                d = dArray[0];
                                d2 = point3d.x;
                                d3 = point3d.y;
                                d4 = point3d.z;
                                if ((n & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set((Tuple3d)point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (n3 < this.stripVertexCounts.length) {
                    int n16 = this.stripStartVertexIndices[n3];
                    int n17 = n16 + this.stripVertexCounts[n3++];
                    for (int i = 0; i < 2; ++i) {
                        nArray[i] = n16;
                        this.getVertexData(n16++, point3dArray[i]);
                    }
                    while (n16 < n17) {
                        nArray[2] = n16;
                        this.getVertexData(n16++, point3dArray[2]);
                        if (this.intersectCone(point3dArray, pickCone, dArray, point3d)) {
                            if (n == 0) {
                                return true;
                            }
                            if (dArray[0] < d) {
                                d = dArray[0];
                                d2 = point3d.x;
                                d3 = point3d.y;
                                d4 = point3d.z;
                                if ((n & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n, geometryRetained, n2, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set((Tuple3d)point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("TriangleFanArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (d < Double.MAX_VALUE) {
            point3d.x = d2;
            point3d.y = d3;
            point3d.z = d4;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d[] point3dArray) {
        Point3d[] point3dArray2 = new Point3d[3];
        double[] dArray = new double[1];
        int n = 0;
        point3dArray2[0] = new Point3d();
        point3dArray2[1] = new Point3d();
        point3dArray2[2] = new Point3d();
        switch (point3dArray.length) {
            case 3: {
                while (n < this.stripVertexCounts.length) {
                    int n2 = this.stripStartVertexIndices[n];
                    int n3 = n2 + this.stripVertexCounts[n++];
                    this.getVertexData(n2++, point3dArray2[0]);
                    this.getVertexData(n2++, point3dArray2[1]);
                    while (n2 < n3) {
                        this.getVertexData(n2++, point3dArray2[2]);
                        if (this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[1], point3dArray[2])) {
                            return true;
                        }
                        point3dArray2[1].set((Tuple3d)point3dArray2[2]);
                    }
                }
                break;
            }
            case 4: {
                while (n < this.stripVertexCounts.length) {
                    int n4 = this.stripStartVertexIndices[n];
                    int n5 = n4 + this.stripVertexCounts[n++];
                    this.getVertexData(n4++, point3dArray2[0]);
                    this.getVertexData(n4++, point3dArray2[1]);
                    while (n4 < n5) {
                        this.getVertexData(n4++, point3dArray2[2]);
                        if (this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[1], point3dArray[2]) || this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[2], point3dArray[3])) {
                            return true;
                        }
                        point3dArray2[1].set((Tuple3d)point3dArray2[2]);
                    }
                }
                break;
            }
            case 2: {
                while (n < this.stripVertexCounts.length) {
                    int n6 = this.stripStartVertexIndices[n];
                    int n7 = n6 + this.stripVertexCounts[n++];
                    this.getVertexData(n6++, point3dArray2[0]);
                    this.getVertexData(n6++, point3dArray2[1]);
                    while (n6 < n7) {
                        this.getVertexData(n6++, point3dArray2[2]);
                        if (this.intersectSegment(point3dArray2, point3dArray[0], point3dArray[1], dArray, null)) {
                            return true;
                        }
                        point3dArray2[1].set((Tuple3d)point3dArray2[2]);
                    }
                }
                break;
            }
            case 1: {
                while (n < this.stripVertexCounts.length) {
                    int n8 = this.stripStartVertexIndices[n];
                    int n9 = n8 + this.stripVertexCounts[n++];
                    this.getVertexData(n8++, point3dArray2[0]);
                    this.getVertexData(n8++, point3dArray2[1]);
                    while (n8 < n9) {
                        this.getVertexData(n8++, point3dArray2[2]);
                        if (this.intersectTriPnt(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0])) {
                            return true;
                        }
                        point3dArray2[1].set((Tuple3d)point3dArray2[2]);
                    }
                }
                break;
            }
        }
        return false;
    }

    @Override
    boolean intersect(Transform3D transform3D, GeometryRetained geometryRetained) {
        int n = 0;
        Point3d[] point3dArray = new Point3d[]{new Point3d(), new Point3d(), new Point3d()};
        while (n < this.stripVertexCounts.length) {
            int n2 = this.stripStartVertexIndices[n];
            int n3 = n2 + this.stripVertexCounts[n++];
            this.getVertexData(n2++, point3dArray[0]);
            this.getVertexData(n2++, point3dArray[1]);
            transform3D.transform(point3dArray[0]);
            transform3D.transform(point3dArray[1]);
            while (n2 < n3) {
                this.getVertexData(n2++, point3dArray[2]);
                transform3D.transform(point3dArray[2]);
                if (geometryRetained.intersect(point3dArray)) {
                    return true;
                }
                point3dArray[1].set((Tuple3d)point3dArray[2]);
            }
        }
        return false;
    }

    @Override
    boolean intersect(Bounds bounds) {
        int n = 0;
        Point3d[] point3dArray = new Point3d[]{new Point3d(), new Point3d(), new Point3d()};
        switch (bounds.getPickType()) {
            case 6: {
                BoundingBox boundingBox = (BoundingBox)bounds;
                while (n < this.stripVertexCounts.length) {
                    int n2 = this.stripStartVertexIndices[n];
                    this.getVertexData(n2++, point3dArray[0]);
                    this.getVertexData(n2++, point3dArray[1]);
                    int n3 = n2 + this.stripVertexCounts[n++];
                    while (n2 < n3) {
                        this.getVertexData(n2++, point3dArray[2]);
                        if (this.intersectBoundingBox(point3dArray, boundingBox, null, null)) {
                            return true;
                        }
                        point3dArray[1].set((Tuple3d)point3dArray[2]);
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere boundingSphere = (BoundingSphere)bounds;
                while (n < this.stripVertexCounts.length) {
                    int n4 = this.stripStartVertexIndices[n];
                    int n5 = n4 + this.stripVertexCounts[n++];
                    this.getVertexData(n4++, point3dArray[0]);
                    this.getVertexData(n4++, point3dArray[1]);
                    while (n4 < n5) {
                        this.getVertexData(n4++, point3dArray[2]);
                        if (this.intersectBoundingSphere(point3dArray, boundingSphere, null, null)) {
                            return true;
                        }
                        point3dArray[1].set((Tuple3d)point3dArray[2]);
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
                while (n < this.stripVertexCounts.length) {
                    int n6 = this.stripStartVertexIndices[n];
                    int n7 = n6 + this.stripVertexCounts[n++];
                    this.getVertexData(n6++, point3dArray[0]);
                    this.getVertexData(n6++, point3dArray[1]);
                    while (n6 < n7) {
                        this.getVertexData(n6++, point3dArray[2]);
                        if (this.intersectBoundingPolytope(point3dArray, boundingPolytope, null, null)) {
                            return true;
                        }
                        point3dArray[1].set((Tuple3d)point3dArray[2]);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + bounds);
            }
        }
        return false;
    }

    @Override
    void computeCentroid() {
        double d;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        double d2 = 0.0;
        int n = 0;
        this.centroid.x = 0.0;
        this.centroid.y = 0.0;
        this.centroid.z = 0.0;
        while (n < this.stripVertexCounts.length) {
            int n2 = this.stripStartVertexIndices[n];
            int n3 = n2 + this.stripVertexCounts[n++];
            this.getVertexData(n2++, point3d);
            this.getVertexData(n2++, point3d2);
            int n4 = 2;
            while (n2 < n3) {
                d = 0.0;
                if (n4 == 2) {
                    this.getVertexData(n2++, point3d3);
                    n4 = 1;
                } else {
                    this.getVertexData(n2++, point3d2);
                    n4 = 2;
                }
                vector3d.sub((Tuple3d)point3d, (Tuple3d)point3d2);
                vector3d3.sub((Tuple3d)point3d2, (Tuple3d)point3d3);
                vector3d2.cross(vector3d, vector3d3);
                vector3d2.normalize();
                if (Double.isNaN(vector3d2.x + vector3d2.y + vector3d2.z)) continue;
                vector3d3.set(0.0, 0.0, 0.0);
                this.getCrossValue(point3d, point3d2, vector3d3);
                this.getCrossValue(point3d2, point3d3, vector3d3);
                this.getCrossValue(point3d3, point3d, vector3d3);
                d = vector3d2.dot(vector3d3);
                d2 += d;
                this.centroid.x += (point3d.x + point3d2.x + point3d3.x) * d;
                this.centroid.y += (point3d.y + point3d2.y + point3d3.y) * d;
                this.centroid.z += (point3d.z + point3d2.z + point3d3.z) * d;
            }
        }
        if (d2 != 0.0) {
            d = 1.0 / (3.0 * d2);
            this.centroid.x *= d;
            this.centroid.y *= d;
            this.centroid.z *= d;
        }
    }

    @Override
    int getClassType() {
        return 3;
    }
}

