/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.LinkedList;
import java.util.List;
import org.jgrapht.graph.SimpleWeightedGraph;

public class HamiltonianCycle {
    public static <V, E> List<V> getApproximateOptimalForCompleteGraph(SimpleWeightedGraph<V, E> g) {
        LinkedList vertices = new LinkedList(g.vertexSet());
        if (vertices.size() * (vertices.size() - 1) / 2 != g.edgeSet().size()) {
            return null;
        }
        LinkedList tour = new LinkedList();
        while (tour.size() != g.vertexSet().size()) {
            boolean firstEdge = true;
            double minEdgeValue = 0.0;
            int minVertexFound = 0;
            int vertexConnectedTo = 0;
            for (int i = 0; i < tour.size(); ++i) {
                Object v = tour.get(i);
                for (int j = 0; j < vertices.size(); ++j) {
                    double weight = g.getEdgeWeight(g.getEdge(v, vertices.get(j)));
                    if (!firstEdge && !(weight < minEdgeValue)) continue;
                    firstEdge = false;
                    minEdgeValue = weight;
                    minVertexFound = j;
                    vertexConnectedTo = i;
                }
            }
            tour.add(vertexConnectedTo, vertices.get(minVertexFound));
            vertices.remove(minVertexFound);
        }
        return tour;
    }
}

