/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class RoutineSchema
implements SchemaObject {
    static RoutineSchema[] emptyArray = new RoutineSchema[0];
    Routine[] routines = Routine.emptyArray;
    int routineType;
    private HsqlNameManager.HsqlName name;

    public RoutineSchema(int n, HsqlNameManager.HsqlName hsqlName) {
        this.routineType = n;
        this.name = hsqlName;
    }

    @Override
    public int getType() {
        return this.routineType;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (int i = 0; i < this.routines.length; ++i) {
            orderedHashSet.addAll(this.routines[i].getReferences());
        }
        return orderedHashSet;
    }

    @Override
    public OrderedHashSet getComponents() {
        OrderedHashSet<Routine> orderedHashSet = new OrderedHashSet<Routine>();
        orderedHashSet.addAll(this.routines);
        return orderedHashSet;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        return null;
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String[] getSQLArray() {
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        for (int i = 0; i < this.routines.length; ++i) {
            hsqlArrayList.add(this.routines[i].getSQL());
        }
        String[] stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public void addSpecificRoutine(HsqlNameManager hsqlNameManager, Routine routine, boolean bl) {
        int n = routine.getParameterSignature();
        Type[] typeArray = routine.getParameterTypes();
        int n2 = this.routines.length;
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i].parameterTypes.length != typeArray.length) continue;
            if (this.routineType == 17 && !bl) {
                throw Error.error(5605);
            }
            if (this.routines[i].isAggregate() != routine.isAggregate()) {
                throw Error.error(5605);
            }
            boolean bl2 = true;
            for (int j = 0; j < typeArray.length; ++j) {
                if (this.routines[i].parameterTypes[j].equals(typeArray[j])) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            if (bl) {
                routine.setSpecificName(this.routines[i].getSpecificName());
                n2 = i;
                break;
            }
            throw Error.error(5605);
        }
        if (routine.getSpecificName() == null) {
            HsqlNameManager.HsqlName hsqlName = hsqlNameManager.newSpecificRoutineName(this.name);
            routine.setSpecificName(hsqlName);
        } else {
            routine.getSpecificName().parent = this.name;
            routine.getSpecificName().schema = this.name.schema;
        }
        routine.setName(this.name);
        routine.routineSchema = this;
        if (n2 == this.routines.length) {
            this.routines = (Routine[])ArrayUtil.resizeArray(this.routines, this.routines.length + 1);
        }
        this.routines[n2] = routine;
    }

    public void removeSpecificRoutine(Routine routine) {
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i] != routine) continue;
            this.routines = (Routine[])ArrayUtil.toAdjustedArray(this.routines, null, i, -1);
            break;
        }
    }

    public Routine[] getSpecificRoutines() {
        return this.routines;
    }

    public Routine getSpecificRoutine(Type[] typeArray) {
        Routine routine = this.findSpecificRoutine(typeArray);
        if (routine == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.name.getSchemaQualifiedStatementName());
            stringBuilder.append("(");
            for (int i = 0; i < typeArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(",");
                }
                if (typeArray[i] == null) {
                    stringBuilder.append("null");
                    continue;
                }
                stringBuilder.append(typeArray[i].getNameString());
            }
            stringBuilder.append(")");
            throw Error.error(5609, stringBuilder.toString());
        }
        return routine;
    }

    public Routine findSpecificRoutine(Type[] typeArray) {
        int n = -1;
        block0: for (int i = 0; i < this.routines.length; ++i) {
            int n2;
            int n3;
            int n4;
            int n5 = 0;
            if (this.routines[i].isAggregate() && typeArray.length == 1) {
                if (typeArray[0] == null) {
                    return this.routines[i];
                }
                n4 = typeArray[0].precedenceDegree(this.routines[i].parameterTypes[0]);
                if (n4 < -128) {
                    if (n == -1 || (n3 = typeArray[0].precedenceDegree(this.routines[n].parameterTypes[0])) == (n2 = typeArray[0].precedenceDegree(this.routines[i].parameterTypes[0])) || n2 >= n3) continue;
                    n = i;
                    continue;
                }
                if (n4 == 0) {
                    return this.routines[i];
                }
                n = i;
                continue;
            }
            if (this.routines[i].parameterTypes.length != typeArray.length) continue;
            if (typeArray.length == 0) {
                return this.routines[i];
            }
            for (n4 = 0; n4 < typeArray.length; ++n4) {
                if (typeArray[n4] == null) continue;
                n3 = typeArray[n4].precedenceDegree(this.routines[i].parameterTypes[n4]);
                if (n3 < -128) continue block0;
                if (n3 != 0 || n5 != n4) continue;
                n5 = n4 + 1;
            }
            if (n5 == typeArray.length) {
                return this.routines[i];
            }
            if (n == -1) {
                n = i;
                continue;
            }
            for (n4 = 0; n4 < typeArray.length; ++n4) {
                if (typeArray[n4] == null || (n3 = typeArray[n4].precedenceDegree(this.routines[n].parameterTypes[n4])) == (n2 = typeArray[n4].precedenceDegree(this.routines[i].parameterTypes[n4]))) continue;
                if (n2 >= n3) continue block0;
                n = i;
                continue block0;
            }
        }
        return n < 0 ? null : this.routines[n];
    }

    public Routine getSpecificRoutine(int n) {
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i].parameterTypes.length != n) continue;
            return this.routines[i];
        }
        throw Error.error(5501);
    }

    public boolean isAggregate() {
        return this.routines[0].isAggregate;
    }
}

