// This file exists to create a libc.so file so that LLD has something to look at
// and emit linker errors if an attempt to link against a non-existent C symbol happens.

const builtin = @import("builtin");

comptime {
    switch (builtin.arch) {
        builtin.Arch.i386 => _ = @import("c/i386.zig"),
        builtin.Arch.x86_64 => _ = @import("c/x86_64.zig"),
        else => {},
    }
}

export fn @"error"() void {}
export fn _Exit() void {}
export fn _IO_2_1_stderr_() void {}
export fn _IO_2_1_stdin_() void {}
export fn _IO_2_1_stdout_() void {}
export fn _IO_adjust_column() void {}
export fn _IO_adjust_wcolumn() void {}
export fn _IO_default_doallocate() void {}
export fn _IO_default_finish() void {}
export fn _IO_default_pbackfail() void {}
export fn _IO_default_uflow() void {}
export fn _IO_default_xsgetn() void {}
export fn _IO_default_xsputn() void {}
export fn _IO_do_write() void {}
export fn _IO_doallocbuf() void {}
export fn _IO_enable_locks() void {}
export fn _IO_fclose() void {}
export fn _IO_fdopen() void {}
export fn _IO_feof() void {}
export fn _IO_ferror() void {}
export fn _IO_fflush() void {}
export fn _IO_fgetpos() void {}
export fn _IO_fgetpos64() void {}
export fn _IO_fgets() void {}
export fn _IO_file_attach() void {}
export fn _IO_file_close() void {}
export fn _IO_file_close_it() void {}
export fn _IO_file_doallocate() void {}
export fn _IO_file_finish() void {}
export fn _IO_file_fopen() void {}
export fn _IO_file_init() void {}
export fn _IO_file_jumps() void {}
export fn _IO_file_open() void {}
export fn _IO_file_overflow() void {}
export fn _IO_file_read() void {}
export fn _IO_file_seek() void {}
export fn _IO_file_seekoff() void {}
export fn _IO_file_setbuf() void {}
export fn _IO_file_stat() void {}
export fn _IO_file_sync() void {}
export fn _IO_file_underflow() void {}
export fn _IO_file_write() void {}
export fn _IO_file_xsputn() void {}
export fn _IO_flockfile() void {}
export fn _IO_flush_all() void {}
export fn _IO_flush_all_linebuffered() void {}
export fn _IO_fopen() void {}
export fn _IO_fprintf() void {}
export fn _IO_fputs() void {}
export fn _IO_fread() void {}
export fn _IO_free_backup_area() void {}
export fn _IO_free_wbackup_area() void {}
export fn _IO_fsetpos() void {}
export fn _IO_fsetpos64() void {}
export fn _IO_ftell() void {}
export fn _IO_ftrylockfile() void {}
export fn _IO_funlockfile() void {}
export fn _IO_fwrite() void {}
export fn _IO_getc() void {}
export fn _IO_getline() void {}
export fn _IO_getline_info() void {}
export fn _IO_gets() void {}
export fn _IO_init() void {}
export fn _IO_init_marker() void {}
export fn _IO_init_wmarker() void {}
export fn _IO_iter_begin() void {}
export fn _IO_iter_end() void {}
export fn _IO_iter_file() void {}
export fn _IO_iter_next() void {}
export fn _IO_least_wmarker() void {}
export fn _IO_link_in() void {}
export fn _IO_list_all() void {}
export fn _IO_list_lock() void {}
export fn _IO_list_resetlock() void {}
export fn _IO_list_unlock() void {}
export fn _IO_marker_delta() void {}
export fn _IO_marker_difference() void {}
export fn _IO_padn() void {}
export fn _IO_peekc_locked() void {}
export fn _IO_popen() void {}
export fn _IO_printf() void {}
export fn _IO_proc_close() void {}
export fn _IO_proc_open() void {}
export fn _IO_putc() void {}
export fn _IO_puts() void {}
export fn _IO_remove_marker() void {}
export fn _IO_seekmark() void {}
export fn _IO_seekoff() void {}
export fn _IO_seekpos() void {}
export fn _IO_seekwmark() void {}
export fn _IO_setb() void {}
export fn _IO_setbuffer() void {}
export fn _IO_setvbuf() void {}
export fn _IO_sgetn() void {}
export fn _IO_sprintf() void {}
export fn _IO_sputbackc() void {}
export fn _IO_sputbackwc() void {}
export fn _IO_sscanf() void {}
export fn _IO_str_init_readonly() void {}
export fn _IO_str_init_static() void {}
export fn _IO_str_overflow() void {}
export fn _IO_str_pbackfail() void {}
export fn _IO_str_seekoff() void {}
export fn _IO_str_underflow() void {}
export fn _IO_sungetc() void {}
export fn _IO_sungetwc() void {}
export fn _IO_switch_to_get_mode() void {}
export fn _IO_switch_to_main_wget_area() void {}
export fn _IO_switch_to_wbackup_area() void {}
export fn _IO_switch_to_wget_mode() void {}
export fn _IO_un_link() void {}
export fn _IO_ungetc() void {}
export fn _IO_unsave_markers() void {}
export fn _IO_unsave_wmarkers() void {}
export fn _IO_vfprintf() void {}
export fn _IO_vfscanf() void {}
export fn _IO_vsprintf() void {}
export fn _IO_wdefault_doallocate() void {}
export fn _IO_wdefault_finish() void {}
export fn _IO_wdefault_pbackfail() void {}
export fn _IO_wdefault_uflow() void {}
export fn _IO_wdefault_xsgetn() void {}
export fn _IO_wdefault_xsputn() void {}
export fn _IO_wdo_write() void {}
export fn _IO_wdoallocbuf() void {}
export fn _IO_wfile_jumps() void {}
export fn _IO_wfile_overflow() void {}
export fn _IO_wfile_seekoff() void {}
export fn _IO_wfile_sync() void {}
export fn _IO_wfile_underflow() void {}
export fn _IO_wfile_xsputn() void {}
export fn _IO_wmarker_delta() void {}
export fn _IO_wsetb() void {}
export fn __abort_msg() void {}
export fn __adjtimex() void {}
export fn __after_morecore_hook() void {}
export fn __argz_count() void {}
export fn __argz_next() void {}
export fn __argz_stringify() void {}
export fn __asprintf() void {}
export fn __asprintf_chk() void {}
export fn __assert() void {}
export fn __assert_fail() void {}
export fn __assert_perror_fail() void {}
export fn __backtrace() void {}
export fn __backtrace_symbols() void {}
export fn __backtrace_symbols_fd() void {}
export fn __bsd_getpgrp() void {}
export fn __bzero() void {}
export fn __call_tls_dtors() void {}
export fn __check_rhosts_file() void {}
export fn __chk_fail() void {}
export fn __clock_getcpuclockid() void {}
export fn __clock_getres() void {}
export fn __clock_gettime() void {}
export fn __clock_nanosleep() void {}
export fn __clock_settime() void {}
export fn __clone() void {}
export fn __close() void {}
export fn __close_nocancel() void {}
export fn __cmsg_nxthdr() void {}
export fn __confstr_chk() void {}
export fn __connect() void {}
export fn __copy_grp() void {}
export fn __ctype32_b() void {}
export fn __ctype32_tolower() void {}
export fn __ctype32_toupper() void {}
export fn __ctype_b() void {}
export fn __ctype_b_loc() void {}
export fn __ctype_get_mb_cur_max() void {}
export fn __ctype_init() void {}
export fn __ctype_tolower() void {}
export fn __ctype_tolower_loc() void {}
export fn __ctype_toupper() void {}
export fn __ctype_toupper_loc() void {}
export fn __curbrk() void {}
export fn __cxa_at_quick_exit() void {}
export fn __cxa_atexit() void {}
export fn __cxa_finalize() void {}
export fn __cxa_thread_atexit_impl() void {}
export fn __cyg_profile_func_enter() void {}
export fn __cyg_profile_func_exit() void {}
export fn __daylight() void {}
export fn __dcgettext() void {}
export fn __default_morecore() void {}
export fn __dgettext() void {}
export fn __dprintf_chk() void {}
export fn __dup2() void {}
export fn __duplocale() void {}
export fn __endmntent() void {}
export fn __environ() void {}
export fn __errno_location() void {}
export fn __explicit_bzero_chk() void {}
export fn __fbufsize() void {}
export fn __fcntl() void {}
export fn __fdelt_chk() void {}
export fn __fdelt_warn() void {}
export fn __fentry__() void {}
export fn __ffs() void {}
export fn __fgets_chk() void {}
export fn __fgets_unlocked_chk() void {}
export fn __fgetws_chk() void {}
export fn __fgetws_unlocked_chk() void {}
export fn __finite() void {}
export fn __finitef() void {}
export fn __finitel() void {}
export fn __flbf() void {}
export fn __fork() void {}
export fn __fortify_fail() void {}
export fn __fpending() void {}
export fn __fprintf_chk() void {}
export fn __fpu_control() void {}
export fn __fpurge() void {}
export fn __fread_chk() void {}
export fn __fread_unlocked_chk() void {}
export fn __freadable() void {}
export fn __freading() void {}
export fn __free_hook() void {}
export fn __freelocale() void {}
export fn __fseeko64() void {}
export fn __fsetlocking() void {}
export fn __ftello64() void {}
export fn __fwprintf_chk() void {}
export fn __fwritable() void {}
export fn __fwriting() void {}
export fn __fxstat() void {}
export fn __fxstat64() void {}
export fn __fxstatat() void {}
export fn __fxstatat64() void {}
export fn __gai_sigqueue() void {}
export fn __gconv_get_alias_db() void {}
export fn __gconv_get_cache() void {}
export fn __gconv_get_modules_db() void {}
export fn __gconv_transliterate() void {}
export fn __getauxval() void {}
export fn __getcwd_chk() void {}
export fn __getdelim() void {}
export fn __getdomainname_chk() void {}
export fn __getgroups_chk() void {}
export fn __gethostname_chk() void {}
export fn __getlogin_r_chk() void {}
export fn __getmntent_r() void {}
export fn __getpagesize() void {}
export fn __getpgid() void {}
export fn __getpid() void {}
export fn __getrlimit() void {}
export fn __gets_chk() void {}
export fn __gettimeofday() void {}
export fn __getwd_chk() void {}
export fn __gmtime_r() void {}
export fn __h_errno() void {}
export fn __h_errno_location() void {}
export fn __idna_from_dns_encoding() void {}
export fn __idna_to_dns_encoding() void {}
export fn __inet6_scopeid_pton() void {}
export fn __inet_aton_exact() void {}
export fn __inet_pton_length() void {}
export fn __internal_endnetgrent() void {}
export fn __internal_getnetgrent_r() void {}
export fn __internal_setnetgrent() void {}
export fn __isalnum_l() void {}
export fn __isalpha_l() void {}
export fn __isascii_l() void {}
export fn __isblank_l() void {}
export fn __iscntrl_l() void {}
export fn __isctype() void {}
export fn __isdigit_l() void {}
export fn __isgraph_l() void {}
export fn __isinf() void {}
export fn __isinff() void {}
export fn __isinfl() void {}
export fn __islower_l() void {}
export fn __isnan() void {}
export fn __isnanf() void {}
export fn __isnanl() void {}
export fn __isoc99_fscanf() void {}
export fn __isoc99_fwscanf() void {}
export fn __isoc99_scanf() void {}
export fn __isoc99_sscanf() void {}
export fn __isoc99_swscanf() void {}
export fn __isoc99_vfscanf() void {}
export fn __isoc99_vfwscanf() void {}
export fn __isoc99_vscanf() void {}
export fn __isoc99_vsscanf() void {}
export fn __isoc99_vswscanf() void {}
export fn __isoc99_vwscanf() void {}
export fn __isoc99_wscanf() void {}
export fn __isprint_l() void {}
export fn __ispunct_l() void {}
export fn __isspace_l() void {}
export fn __isupper_l() void {}
export fn __iswalnum_l() void {}
export fn __iswalpha_l() void {}
export fn __iswblank_l() void {}
export fn __iswcntrl_l() void {}
export fn __iswctype() void {}
export fn __iswctype_l() void {}
export fn __iswdigit_l() void {}
export fn __iswgraph_l() void {}
export fn __iswlower_l() void {}
export fn __iswprint_l() void {}
export fn __iswpunct_l() void {}
export fn __iswspace_l() void {}
export fn __iswupper_l() void {}
export fn __iswxdigit_l() void {}
export fn __isxdigit_l() void {}
export fn __ivaliduser() void {}
export fn __key_decryptsession_pk_LOCAL() void {}
export fn __key_encryptsession_pk_LOCAL() void {}
export fn __key_gendes_LOCAL() void {}
export fn __libc_alloc_buffer_alloc_array() void {}
export fn __libc_alloc_buffer_allocate() void {}
export fn __libc_alloc_buffer_copy_bytes() void {}
export fn __libc_alloc_buffer_copy_string() void {}
export fn __libc_alloc_buffer_create_failure() void {}
export fn __libc_alloca_cutoff() void {}
export fn __libc_allocate_once_slow() void {}
export fn __libc_allocate_rtsig() void {}
export fn __libc_allocate_rtsig_private() void {}
export fn __libc_calloc() void {}
export fn __libc_clntudp_bufcreate() void {}
export fn __libc_current_sigrtmax() void {}
export fn __libc_current_sigrtmax_private() void {}
export fn __libc_current_sigrtmin() void {}
export fn __libc_current_sigrtmin_private() void {}
export fn __libc_dlclose() void {}
export fn __libc_dlopen_mode() void {}
export fn __libc_dlsym() void {}
export fn __libc_dlvsym() void {}
export fn __libc_dynarray_at_failure() void {}
export fn __libc_dynarray_emplace_enlarge() void {}
export fn __libc_dynarray_finalize() void {}
export fn __libc_dynarray_resize() void {}
export fn __libc_dynarray_resize_clear() void {}
export fn __libc_fatal() void {}
export fn __libc_fcntl64() void {}
export fn __libc_fork() void {}
export fn __libc_free() void {}
export fn __libc_freeres() void {}
export fn __libc_ifunc_impl_list() void {}
export fn __libc_init_first() void {}
export fn __libc_longjmp() void {}
export fn __libc_mallinfo() void {}
export fn __libc_malloc() void {}
export fn __libc_mallopt() void {}
export fn __libc_memalign() void {}
export fn __libc_msgrcv() void {}
export fn __libc_msgsnd() void {}
export fn __libc_pread() void {}
export fn __libc_pthread_init() void {}
export fn __libc_pvalloc() void {}
export fn __libc_pwrite() void {}
export fn __libc_readline_unlocked() void {}
export fn __libc_realloc() void {}
export fn __libc_reallocarray() void {}
export fn __libc_rpc_getport() void {}
export fn __libc_sa_len() void {}
export fn __libc_scratch_buffer_grow() void {}
export fn __libc_scratch_buffer_grow_preserve() void {}
export fn __libc_scratch_buffer_set_array_size() void {}
export fn __libc_secure_getenv() void {}
export fn __libc_siglongjmp() void {}
export fn __libc_start_main() void {}
export fn __libc_system() void {}
export fn __libc_thread_freeres() void {}
export fn __libc_valloc() void {}
export fn __libc_vfork() void {}
export fn __longjmp_chk() void {}
export fn __lseek() void {}
export fn __lxstat() void {}
export fn __lxstat64() void {}
export fn __madvise() void {}
export fn __malloc_hook() void {}
export fn __malloc_initialize_hook() void {}
export fn __mbrlen() void {}
export fn __mbrtowc() void {}
export fn __mbsnrtowcs_chk() void {}
export fn __mbsrtowcs_chk() void {}
export fn __mbstowcs_chk() void {}
export fn __memalign_hook() void {}
export fn __memcpy_chk() void {}
export fn __memmove_chk() void {}
export fn __mempcpy() void {}
export fn __mempcpy_chk() void {}
export fn __mempcpy_small() void {}
export fn __memset_chk() void {}
export fn __merge_grp() void {}
export fn __mktemp() void {}
export fn __mmap() void {}
export fn __monstartup() void {}
export fn __morecore() void {}
export fn __mprotect() void {}
export fn __munmap() void {}
export fn __nanosleep() void {}
export fn __nanosleep_nocancel() void {}
export fn __netlink_assert_response() void {}
export fn __newlocale() void {}
export fn __nl_langinfo_l() void {}
export fn __nss_configure_lookup() void {}
export fn __nss_database_lookup() void {}
export fn __nss_disable_nscd() void {}
export fn __nss_group_lookup() void {}
export fn __nss_group_lookup2() void {}
export fn __nss_hash() void {}
export fn __nss_hostname_digits_dots() void {}
export fn __nss_hosts_lookup() void {}
export fn __nss_hosts_lookup2() void {}
export fn __nss_lookup() void {}
export fn __nss_lookup_function() void {}
export fn __nss_next() void {}
export fn __nss_next2() void {}
export fn __nss_passwd_lookup() void {}
export fn __nss_passwd_lookup2() void {}
export fn __nss_services_lookup2() void {}
export fn __obstack_printf_chk() void {}
export fn __obstack_vprintf_chk() void {}
export fn __open() void {}
export fn __open64() void {}
export fn __open64_2() void {}
export fn __open64_nocancel() void {}
export fn __open_2() void {}
export fn __open_catalog() void {}
export fn __open_nocancel() void {}
export fn __openat64_2() void {}
export fn __openat_2() void {}
export fn __overflow() void {}
export fn __pause_nocancel() void {}
export fn __pipe() void {}
export fn __poll() void {}
export fn __poll_chk() void {}
export fn __posix_getopt() void {}
export fn __ppoll_chk() void {}
export fn __pread64() void {}
export fn __pread64_chk() void {}
export fn __pread_chk() void {}
export fn __printf_chk() void {}
export fn __printf_fp() void {}
export fn __profile_frequency() void {}
export fn __progname() void {}
export fn __progname_full() void {}
export fn __ptsname_r_chk() void {}
export fn __pwrite64() void {}
export fn __rawmemchr() void {}
export fn __rcmd_errstr() void {}
export fn __read() void {}
export fn __read_chk() void {}
export fn __read_nocancel() void {}
export fn __readlink_chk() void {}
export fn __readlinkat_chk() void {}
export fn __realloc_hook() void {}
export fn __realpath_chk() void {}
export fn __recv() void {}
export fn __recv_chk() void {}
export fn __recvfrom_chk() void {}
export fn __register_atfork() void {}
export fn __res_iclose() void {}
export fn __res_init() void {}
export fn __res_nclose() void {}
export fn __res_ninit() void {}
export fn __res_randomid() void {}
export fn __res_state() void {}
export fn __resolv_context_get() void {}
export fn __resolv_context_get_override() void {}
export fn __resolv_context_get_preinit() void {}
export fn __resolv_context_put() void {}
export fn __resp() void {}
export fn __rpc_thread_createerr() void {}
export fn __rpc_thread_svc_fdset() void {}
export fn __rpc_thread_svc_max_pollfd() void {}
export fn __rpc_thread_svc_pollfd() void {}
export fn __sbrk() void {}
export fn __sched_cpualloc() void {}
export fn __sched_cpucount() void {}
export fn __sched_cpufree() void {}
export fn __sched_get_priority_max() void {}
export fn __sched_get_priority_min() void {}
export fn __sched_getparam() void {}
export fn __sched_getscheduler() void {}
export fn __sched_setscheduler() void {}
export fn __sched_yield() void {}
export fn __secure_getenv() void {}
export fn __select() void {}
export fn __send() void {}
export fn __sendmmsg() void {}
export fn __setmntent() void {}
export fn __setpgid() void {}
export fn __sigaction() void {}
export fn __sigaddset() void {}
export fn __sigdelset() void {}
export fn __sigismember() void {}
export fn __signbit() void {}
export fn __signbitf() void {}
export fn __signbitl() void {}
export fn __sigpause() void {}
export fn __sigsetjmp() void {}
export fn __sigsuspend() void {}
export fn __sigtimedwait() void {}
export fn __snprintf() void {}
export fn __snprintf_chk() void {}
export fn __socket() void {}
export fn __sprintf_chk() void {}
export fn __stack_chk_fail() void {}
export fn __statfs() void {}
export fn __stpcpy() void {}
export fn __stpcpy_chk() void {}
export fn __stpcpy_small() void {}
export fn __stpncpy() void {}
export fn __stpncpy_chk() void {}
export fn __strcasecmp() void {}
export fn __strcasecmp_l() void {}
export fn __strcasestr() void {}
export fn __strcat_chk() void {}
export fn __strcoll_l() void {}
export fn __strcpy_chk() void {}
export fn __strcpy_small() void {}
export fn __strcspn_c1() void {}
export fn __strcspn_c2() void {}
export fn __strcspn_c3() void {}
export fn __strdup() void {}
export fn __strerror_r() void {}
export fn __strfmon_l() void {}
export fn __strftime_l() void {}
export fn __strncasecmp_l() void {}
export fn __strncat_chk() void {}
export fn __strncpy_chk() void {}
export fn __strndup() void {}
export fn __strpbrk_c2() void {}
export fn __strpbrk_c3() void {}
export fn __strsep_1c() void {}
export fn __strsep_2c() void {}
export fn __strsep_3c() void {}
export fn __strsep_g() void {}
export fn __strspn_c1() void {}
export fn __strspn_c2() void {}
export fn __strspn_c3() void {}
export fn __strtod_internal() void {}
export fn __strtod_l() void {}
export fn __strtod_nan() void {}
export fn __strtof128_internal() void {}
export fn __strtof128_nan() void {}
export fn __strtof_internal() void {}
export fn __strtof_l() void {}
export fn __strtof_nan() void {}
export fn __strtok_r() void {}
export fn __strtok_r_1c() void {}
export fn __strtol_internal() void {}
export fn __strtol_l() void {}
export fn __strtold_internal() void {}
export fn __strtold_l() void {}
export fn __strtold_nan() void {}
export fn __strtoll_internal() void {}
export fn __strtoll_l() void {}
export fn __strtoul_internal() void {}
export fn __strtoul_l() void {}
export fn __strtoull_internal() void {}
export fn __strtoull_l() void {}
export fn __strverscmp() void {}
export fn __strxfrm_l() void {}
export fn __swprintf_chk() void {}
export fn __sysconf() void {}
export fn __sysctl() void {}
export fn __syslog_chk() void {}
export fn __sysv_signal() void {}
export fn __tdelete() void {}
export fn __tfind() void {}
export fn __timezone() void {}
export fn __toascii_l() void {}
export fn __tolower_l() void {}
export fn __toupper_l() void {}
export fn __towctrans() void {}
export fn __towctrans_l() void {}
export fn __towlower_l() void {}
export fn __towupper_l() void {}
export fn __tsearch() void {}
export fn __ttyname_r_chk() void {}
export fn __twalk() void {}
export fn __tzname() void {}
export fn __uflow() void {}
export fn __underflow() void {}
export fn __uselocale() void {}
export fn __vasprintf_chk() void {}
export fn __vdprintf_chk() void {}
export fn __vfork() void {}
export fn __vfprintf_chk() void {}
export fn __vfscanf() void {}
export fn __vfwprintf_chk() void {}
export fn __vprintf_chk() void {}
export fn __vsnprintf() void {}
export fn __vsnprintf_chk() void {}
export fn __vsprintf_chk() void {}
export fn __vsscanf() void {}
export fn __vswprintf_chk() void {}
export fn __vsyslog_chk() void {}
export fn __vwprintf_chk() void {}
export fn __wait() void {}
export fn __waitpid() void {}
export fn __wcpcpy_chk() void {}
export fn __wcpncpy_chk() void {}
export fn __wcrtomb_chk() void {}
export fn __wcscasecmp_l() void {}
export fn __wcscat_chk() void {}
export fn __wcscoll_l() void {}
export fn __wcscpy_chk() void {}
export fn __wcsftime_l() void {}
export fn __wcsncasecmp_l() void {}
export fn __wcsncat_chk() void {}
export fn __wcsncpy_chk() void {}
export fn __wcsnrtombs_chk() void {}
export fn __wcsrtombs_chk() void {}
export fn __wcstod_internal() void {}
export fn __wcstod_l() void {}
export fn __wcstof128_internal() void {}
export fn __wcstof_internal() void {}
export fn __wcstof_l() void {}
export fn __wcstol_internal() void {}
export fn __wcstol_l() void {}
export fn __wcstold_internal() void {}
export fn __wcstold_l() void {}
export fn __wcstoll_internal() void {}
export fn __wcstoll_l() void {}
export fn __wcstombs_chk() void {}
export fn __wcstoul_internal() void {}
export fn __wcstoul_l() void {}
export fn __wcstoull_internal() void {}
export fn __wcstoull_l() void {}
export fn __wcsxfrm_l() void {}
export fn __wctomb_chk() void {}
export fn __wctrans_l() void {}
export fn __wctype_l() void {}
export fn __wmemcpy_chk() void {}
export fn __wmemmove_chk() void {}
export fn __wmempcpy_chk() void {}
export fn __wmemset_chk() void {}
export fn __woverflow() void {}
export fn __wprintf_chk() void {}
export fn __write() void {}
export fn __write_nocancel() void {}
export fn __wuflow() void {}
export fn __wunderflow() void {}
export fn __xmknod() void {}
export fn __xmknodat() void {}
export fn __xpg_basename() void {}
export fn __xpg_sigpause() void {}
export fn __xpg_strerror_r() void {}
export fn __xstat() void {}
export fn __xstat64() void {}
export fn _authenticate() void {}
export fn _dl_addr() void {}
export fn _dl_catch_error() void {}
export fn _dl_catch_exception() void {}
export fn _dl_mcount_wrapper() void {}
export fn _dl_mcount_wrapper_check() void {}
export fn _dl_open_hook() void {}
export fn _dl_open_hook2() void {}
export fn _dl_signal_error() void {}
export fn _dl_signal_exception() void {}
export fn _dl_sym() void {}
export fn _dl_vsym() void {}
export fn _environ() void {}
export fn _exit() void {}
export fn _flushlbf() void {}
export fn _itoa_lower_digits() void {}
export fn _libc_intl_domainname() void {}
export fn _longjmp() void {}
export fn _mcleanup() void {}
export fn _mcount() void {}
export fn _nl_default_dirname() void {}
export fn _nl_domain_bindings() void {}
export fn _nl_msg_cat_cntr() void {}
export fn _nss_files_parse_grent() void {}
export fn _nss_files_parse_pwent() void {}
export fn _nss_files_parse_sgent() void {}
export fn _nss_files_parse_spent() void {}
export fn _null_auth() void {}
export fn _obstack() void {}
export fn _obstack_allocated_p() void {}
export fn _obstack_begin() void {}
export fn _obstack_begin_1() void {}
export fn _obstack_free() void {}
export fn _obstack_memory_used() void {}
export fn _obstack_newchunk() void {}
export fn _res() void {}
export fn _res_hconf() void {}
export fn _rpc_dtablesize() void {}
export fn _seterr_reply() void {}
export fn _setjmp() void {}
export fn _sys_errlist() void {}
export fn _sys_nerr() void {}
export fn _sys_siglist() void {}
export fn _tolower() void {}
export fn _toupper() void {}
export fn a64l() void {}
export fn abort() void {}
export fn abs() void {}
export fn accept() void {}
export fn accept4() void {}
export fn access() void {}
export fn acct() void {}
export fn addmntent() void {}
export fn addseverity() void {}
export fn adjtime() void {}
export fn adjtimex() void {}
export fn advance() void {}
export fn alarm() void {}
export fn aligned_alloc() void {}
export fn alphasort() void {}
export fn alphasort64() void {}
export fn argp_err_exit_status() void {}
export fn argp_error() void {}
export fn argp_failure() void {}
export fn argp_help() void {}
export fn argp_parse() void {}
export fn argp_program_bug_address() void {}
export fn argp_program_version() void {}
export fn argp_program_version_hook() void {}
export fn argp_state_help() void {}
export fn argp_usage() void {}
export fn argz_add() void {}
export fn argz_add_sep() void {}
export fn argz_append() void {}
export fn argz_count() void {}
export fn argz_create() void {}
export fn argz_create_sep() void {}
export fn argz_delete() void {}
export fn argz_extract() void {}
export fn argz_insert() void {}
export fn argz_next() void {}
export fn argz_replace() void {}
export fn argz_stringify() void {}
export fn asctime() void {}
export fn asctime_r() void {}
export fn asprintf() void {}
export fn atof() void {}
export fn atoi() void {}
export fn atol() void {}
export fn atoll() void {}
export fn authdes_create() void {}
export fn authdes_getucred() void {}
export fn authdes_pk_create() void {}
export fn authnone_create() void {}
export fn authunix_create() void {}
export fn authunix_create_default() void {}
export fn backtrace() void {}
export fn backtrace_symbols() void {}
export fn backtrace_symbols_fd() void {}
export fn basename() void {}
export fn bcmp() void {}
export fn bcopy() void {}
export fn bdflush() void {}
export fn bind() void {}
export fn bind_textdomain_codeset() void {}
export fn bindresvport() void {}
export fn bindtextdomain() void {}
export fn brk() void {}
export fn bsd_signal() void {}
export fn bsearch() void {}
export fn btowc() void {}
export fn bzero() void {}
export fn c16rtomb() void {}
export fn c32rtomb() void {}
export fn calloc() void {}
export fn callrpc() void {}
export fn canonicalize_file_name() void {}
export fn capget() void {}
export fn capset() void {}
export fn catclose() void {}
export fn catgets() void {}
export fn catopen() void {}
export fn cbc_crypt() void {}
export fn cfgetispeed() void {}
export fn cfgetospeed() void {}
export fn cfmakeraw() void {}
export fn cfree() void {}
export fn cfsetispeed() void {}
export fn cfsetospeed() void {}
export fn cfsetspeed() void {}
export fn chdir() void {}
export fn chflags() void {}
export fn chmod() void {}
export fn chown() void {}
export fn chroot() void {}
export fn clearenv() void {}
export fn clearerr() void {}
export fn clearerr_unlocked() void {}
export fn clnt_broadcast() void {}
export fn clnt_create() void {}
export fn clnt_pcreateerror() void {}
export fn clnt_perrno() void {}
export fn clnt_perror() void {}
export fn clnt_spcreateerror() void {}
export fn clnt_sperrno() void {}
export fn clnt_sperror() void {}
export fn clntraw_create() void {}
export fn clnttcp_create() void {}
export fn clntudp_bufcreate() void {}
export fn clntudp_create() void {}
export fn clntunix_create() void {}
export fn clock() void {}
export fn clock_adjtime() void {}
export fn clock_getcpuclockid() void {}
export fn clock_getres() void {}
export fn clock_gettime() void {}
export fn clock_nanosleep() void {}
export fn clock_settime() void {}
export fn clone() void {}
export fn close() void {}
export fn closedir() void {}
export fn closelog() void {}
export fn confstr() void {}
export fn connect() void {}
export fn copy_file_range() void {}
export fn copysign() void {}
export fn copysignf() void {}
export fn copysignl() void {}
export fn creat() void {}
export fn creat64() void {}
export fn create_module() void {}
export fn ctermid() void {}
export fn ctime() void {}
export fn ctime_r() void {}
export fn cuserid() void {}
export fn daemon() void {}
export fn daylight() void {}
export fn dcgettext() void {}
export fn dcngettext() void {}
export fn delete_module() void {}
export fn des_setparity() void {}
export fn dgettext() void {}
export fn difftime() void {}
export fn dirfd() void {}
export fn dirname() void {}
export fn div() void {}
export fn dl_iterate_phdr() void {}
export fn dngettext() void {}
export fn dprintf() void {}
export fn drand48() void {}
export fn drand48_r() void {}
export fn dup() void {}
export fn dup2() void {}
export fn dup3() void {}
export fn duplocale() void {}
export fn dysize() void {}
export fn eaccess() void {}
export fn ecb_crypt() void {}
export fn ecvt() void {}
export fn ecvt_r() void {}
export fn endaliasent() void {}
export fn endfsent() void {}
export fn endgrent() void {}
export fn endhostent() void {}
export fn endmntent() void {}
export fn endnetent() void {}
export fn endnetgrent() void {}
export fn endprotoent() void {}
export fn endpwent() void {}
export fn endrpcent() void {}
export fn endservent() void {}
export fn endsgent() void {}
export fn endspent() void {}
export fn endttyent() void {}
export fn endusershell() void {}
export fn endutent() void {}
export fn endutxent() void {}
export fn environ() void {}
export fn envz_add() void {}
export fn envz_entry() void {}
export fn envz_get() void {}
export fn envz_merge() void {}
export fn envz_remove() void {}
export fn envz_strip() void {}
export fn epoll_create() void {}
export fn epoll_create1() void {}
export fn epoll_ctl() void {}
export fn epoll_pwait() void {}
export fn epoll_wait() void {}
export fn erand48() void {}
export fn erand48_r() void {}
export fn err() void {}
export fn errno() void {}
export fn error_at_line() void {}
export fn error_message_count() void {}
export fn error_one_per_line() void {}
export fn error_print_progname() void {}
export fn errx() void {}
export fn ether_aton() void {}
export fn ether_aton_r() void {}
export fn ether_hostton() void {}
export fn ether_line() void {}
export fn ether_ntoa() void {}
export fn ether_ntoa_r() void {}
export fn ether_ntohost() void {}
export fn euidaccess() void {}
export fn eventfd() void {}
export fn eventfd_read() void {}
export fn eventfd_write() void {}
export fn execl() void {}
export fn execle() void {}
export fn execlp() void {}
export fn execv() void {}
export fn execve() void {}
export fn execvp() void {}
export fn execvpe() void {}
export fn exit() void {}
export fn explicit_bzero() void {}
export fn faccessat() void {}
export fn fallocate() void {}
export fn fallocate64() void {}
export fn fanotify_init() void {}
export fn fanotify_mark() void {}
export fn fattach() void {}
export fn fchdir() void {}
export fn fchflags() void {}
export fn fchmod() void {}
export fn fchmodat() void {}
export fn fchown() void {}
export fn fchownat() void {}
export fn fclose() void {}
export fn fcloseall() void {}
export fn fcntl() void {}
export fn fcntl64() void {}
export fn fcvt() void {}
export fn fcvt_r() void {}
export fn fdatasync() void {}
export fn fdetach() void {}
export fn fdopen() void {}
export fn fdopendir() void {}
export fn feof() void {}
export fn feof_unlocked() void {}
export fn ferror() void {}
export fn ferror_unlocked() void {}
export fn fexecve() void {}
export fn fflush() void {}
export fn fflush_unlocked() void {}
export fn ffs() void {}
export fn ffsl() void {}
export fn ffsll() void {}
export fn fgetc() void {}
export fn fgetc_unlocked() void {}
export fn fgetgrent() void {}
export fn fgetgrent_r() void {}
export fn fgetpos() void {}
export fn fgetpos64() void {}
export fn fgetpwent() void {}
export fn fgetpwent_r() void {}
export fn fgets() void {}
export fn fgets_unlocked() void {}
export fn fgetsgent() void {}
export fn fgetsgent_r() void {}
export fn fgetspent() void {}
export fn fgetspent_r() void {}
export fn fgetwc() void {}
export fn fgetwc_unlocked() void {}
export fn fgetws() void {}
export fn fgetws_unlocked() void {}
export fn fgetxattr() void {}
export fn fileno() void {}
export fn fileno_unlocked() void {}
export fn finite() void {}
export fn finitef() void {}
export fn finitel() void {}
export fn flistxattr() void {}
export fn flock() void {}
export fn flockfile() void {}
export fn fmemopen() void {}
export fn fmtmsg() void {}
export fn fnmatch() void {}
export fn fopen() void {}
export fn fopen64() void {}
export fn fopencookie() void {}
export fn fork() void {}
export fn fpathconf() void {}
export fn fprintf() void {}
export fn fputc() void {}
export fn fputc_unlocked() void {}
export fn fputs() void {}
export fn fputs_unlocked() void {}
export fn fputwc() void {}
export fn fputwc_unlocked() void {}
export fn fputws() void {}
export fn fputws_unlocked() void {}
export fn fread() void {}
export fn fread_unlocked() void {}
export fn free() void {}
export fn freeaddrinfo() void {}
export fn freeifaddrs() void {}
export fn freelocale() void {}
export fn fremovexattr() void {}
export fn freopen() void {}
export fn freopen64() void {}
export fn frexp() void {}
export fn frexpf() void {}
export fn frexpl() void {}
export fn fscanf() void {}
export fn fseek() void {}
export fn fseeko() void {}
export fn fseeko64() void {}
export fn fsetpos() void {}
export fn fsetpos64() void {}
export fn fsetxattr() void {}
export fn fstatfs() void {}
export fn fstatfs64() void {}
export fn fstatvfs() void {}
export fn fstatvfs64() void {}
export fn fsync() void {}
export fn ftell() void {}
export fn ftello() void {}
export fn ftello64() void {}
export fn ftime() void {}
export fn ftok() void {}
export fn ftruncate() void {}
export fn ftruncate64() void {}
export fn ftrylockfile() void {}
export fn fts64_children() void {}
export fn fts64_close() void {}
export fn fts64_open() void {}
export fn fts64_read() void {}
export fn fts64_set() void {}
export fn fts_children() void {}
export fn fts_close() void {}
export fn fts_open() void {}
export fn fts_read() void {}
export fn fts_set() void {}
export fn ftw() void {}
export fn ftw64() void {}
export fn funlockfile() void {}
export fn futimens() void {}
export fn futimes() void {}
export fn futimesat() void {}
export fn fwide() void {}
export fn fwprintf() void {}
export fn fwrite() void {}
export fn fwrite_unlocked() void {}
export fn fwscanf() void {}
export fn gai_strerror() void {}
export fn gcvt() void {}
export fn get_avphys_pages() void {}
export fn get_current_dir_name() void {}
export fn get_kernel_syms() void {}
export fn get_myaddress() void {}
export fn get_nprocs() void {}
export fn get_nprocs_conf() void {}
export fn get_phys_pages() void {}
export fn getaddrinfo() void {}
export fn getaliasbyname() void {}
export fn getaliasbyname_r() void {}
export fn getaliasent() void {}
export fn getaliasent_r() void {}
export fn getauxval() void {}
export fn getc() void {}
export fn getc_unlocked() void {}
export fn getchar() void {}
export fn getchar_unlocked() void {}
export fn getcontext() void {}
export fn getcpu() void {}
export fn getcwd() void {}
export fn getdate() void {}
export fn getdate_err() void {}
export fn getdate_r() void {}
export fn getdelim() void {}
export fn getdirentries() void {}
export fn getdirentries64() void {}
export fn getdomainname() void {}
export fn getdtablesize() void {}
export fn getegid() void {}
export fn getentropy() void {}
export fn getenv() void {}
export fn geteuid() void {}
export fn getfsent() void {}
export fn getfsfile() void {}
export fn getfsspec() void {}
export fn getgid() void {}
export fn getgrent() void {}
export fn getgrent_r() void {}
export fn getgrgid() void {}
export fn getgrgid_r() void {}
export fn getgrnam() void {}
export fn getgrnam_r() void {}
export fn getgrouplist() void {}
export fn getgroups() void {}
export fn gethostbyaddr() void {}
export fn gethostbyaddr_r() void {}
export fn gethostbyname() void {}
export fn gethostbyname2() void {}
export fn gethostbyname2_r() void {}
export fn gethostbyname_r() void {}
export fn gethostent() void {}
export fn gethostent_r() void {}
export fn gethostid() void {}
export fn gethostname() void {}
export fn getifaddrs() void {}
export fn getipv4sourcefilter() void {}
export fn getitimer() void {}
export fn getline() void {}
export fn getloadavg() void {}
export fn getlogin() void {}
export fn getlogin_r() void {}
export fn getmntent() void {}
export fn getmntent_r() void {}
export fn getmsg() void {}
export fn getnameinfo() void {}
export fn getnetbyaddr() void {}
export fn getnetbyaddr_r() void {}
export fn getnetbyname() void {}
export fn getnetbyname_r() void {}
export fn getnetent() void {}
export fn getnetent_r() void {}
export fn getnetgrent() void {}
export fn getnetgrent_r() void {}
export fn getnetname() void {}
export fn getopt() void {}
export fn getopt_long() void {}
export fn getopt_long_only() void {}
export fn getpagesize() void {}
export fn getpass() void {}
export fn getpeername() void {}
export fn getpgid() void {}
export fn getpgrp() void {}
export fn getpid() void {}
export fn getpmsg() void {}
export fn getppid() void {}
export fn getpriority() void {}
export fn getprotobyname() void {}
export fn getprotobyname_r() void {}
export fn getprotobynumber() void {}
export fn getprotobynumber_r() void {}
export fn getprotoent() void {}
export fn getprotoent_r() void {}
export fn getpt() void {}
export fn getpublickey() void {}
export fn getpw() void {}
export fn getpwent() void {}
export fn getpwent_r() void {}
export fn getpwnam() void {}
export fn getpwnam_r() void {}
export fn getpwuid() void {}
export fn getpwuid_r() void {}
export fn getrandom() void {}
export fn getresgid() void {}
export fn getresuid() void {}
export fn getrlimit() void {}
export fn getrlimit64() void {}
export fn getrpcbyname() void {}
export fn getrpcbyname_r() void {}
export fn getrpcbynumber() void {}
export fn getrpcbynumber_r() void {}
export fn getrpcent() void {}
export fn getrpcent_r() void {}
export fn getrpcport() void {}
export fn getrusage() void {}
export fn gets() void {}
export fn getsecretkey() void {}
export fn getservbyname() void {}
export fn getservbyname_r() void {}
export fn getservbyport() void {}
export fn getservbyport_r() void {}
export fn getservent() void {}
export fn getservent_r() void {}
export fn getsgent() void {}
export fn getsgent_r() void {}
export fn getsgnam() void {}
export fn getsgnam_r() void {}
export fn getsid() void {}
export fn getsockname() void {}
export fn getsockopt() void {}
export fn getsourcefilter() void {}
export fn getspent() void {}
export fn getspent_r() void {}
export fn getspnam() void {}
export fn getspnam_r() void {}
export fn getsubopt() void {}
export fn gettext() void {}
export fn gettimeofday() void {}
export fn getttyent() void {}
export fn getttynam() void {}
export fn getuid() void {}
export fn getusershell() void {}
export fn getutent() void {}
export fn getutent_r() void {}
export fn getutid() void {}
export fn getutid_r() void {}
export fn getutline() void {}
export fn getutline_r() void {}
export fn getutmp() void {}
export fn getutmpx() void {}
export fn getutxent() void {}
export fn getutxid() void {}
export fn getutxline() void {}
export fn getw() void {}
export fn getwc() void {}
export fn getwc_unlocked() void {}
export fn getwchar() void {}
export fn getwchar_unlocked() void {}
export fn getwd() void {}
export fn getxattr() void {}
export fn glob() void {}
export fn glob64() void {}
export fn glob_pattern_p() void {}
export fn globfree() void {}
export fn globfree64() void {}
export fn gmtime() void {}
export fn gmtime_r() void {}
export fn gnu_dev_major() void {}
export fn gnu_dev_makedev() void {}
export fn gnu_dev_minor() void {}
export fn gnu_get_libc_release() void {}
export fn gnu_get_libc_version() void {}
export fn grantpt() void {}
export fn group_member() void {}
export fn gsignal() void {}
export fn gtty() void {}
export fn h_errlist() void {}
export fn h_nerr() void {}
export fn hasmntopt() void {}
export fn hcreate() void {}
export fn hcreate_r() void {}
export fn hdestroy() void {}
export fn hdestroy_r() void {}
export fn herror() void {}
export fn host2netname() void {}
export fn hsearch() void {}
export fn hsearch_r() void {}
export fn hstrerror() void {}
export fn htonl() void {}
export fn htons() void {}
export fn iconv() void {}
export fn iconv_close() void {}
export fn iconv_open() void {}
export fn if_freenameindex() void {}
export fn if_indextoname() void {}
export fn if_nameindex() void {}
export fn if_nametoindex() void {}
export fn imaxabs() void {}
export fn imaxdiv() void {}
export fn in6addr_any() void {}
export fn in6addr_loopback() void {}
export fn index() void {}
export fn inet6_opt_append() void {}
export fn inet6_opt_find() void {}
export fn inet6_opt_finish() void {}
export fn inet6_opt_get_val() void {}
export fn inet6_opt_init() void {}
export fn inet6_opt_next() void {}
export fn inet6_opt_set_val() void {}
export fn inet6_option_alloc() void {}
export fn inet6_option_append() void {}
export fn inet6_option_find() void {}
export fn inet6_option_init() void {}
export fn inet6_option_next() void {}
export fn inet6_option_space() void {}
export fn inet6_rth_add() void {}
export fn inet6_rth_getaddr() void {}
export fn inet6_rth_init() void {}
export fn inet6_rth_reverse() void {}
export fn inet6_rth_segments() void {}
export fn inet6_rth_space() void {}
export fn inet_addr() void {}
export fn inet_aton() void {}
export fn inet_lnaof() void {}
export fn inet_makeaddr() void {}
export fn inet_netof() void {}
export fn inet_network() void {}
export fn inet_nsap_addr() void {}
export fn inet_nsap_ntoa() void {}
export fn inet_ntoa() void {}
export fn inet_ntop() void {}
export fn inet_pton() void {}
export fn init_module() void {}
export fn initgroups() void {}
export fn initstate() void {}
export fn initstate_r() void {}
export fn innetgr() void {}
export fn inotify_add_watch() void {}
export fn inotify_init() void {}
export fn inotify_init1() void {}
export fn inotify_rm_watch() void {}
export fn insque() void {}
export fn ioctl() void {}
export fn ioperm() void {}
export fn iopl() void {}
export fn iruserok() void {}
export fn iruserok_af() void {}
export fn isalnum() void {}
export fn isalnum_l() void {}
export fn isalpha() void {}
export fn isalpha_l() void {}
export fn isascii() void {}
export fn isastream() void {}
export fn isatty() void {}
export fn isblank() void {}
export fn isblank_l() void {}
export fn iscntrl() void {}
export fn iscntrl_l() void {}
export fn isctype() void {}
export fn isdigit() void {}
export fn isdigit_l() void {}
export fn isfdtype() void {}
export fn isgraph() void {}
export fn isgraph_l() void {}
export fn isinf() void {}
export fn isinff() void {}
export fn isinfl() void {}
export fn islower() void {}
export fn islower_l() void {}
export fn isnan() void {}
export fn isnanf() void {}
export fn isnanl() void {}
export fn isprint() void {}
export fn isprint_l() void {}
export fn ispunct() void {}
export fn ispunct_l() void {}
export fn isspace() void {}
export fn isspace_l() void {}
export fn isupper() void {}
export fn isupper_l() void {}
export fn iswalnum() void {}
export fn iswalnum_l() void {}
export fn iswalpha() void {}
export fn iswalpha_l() void {}
export fn iswblank() void {}
export fn iswblank_l() void {}
export fn iswcntrl() void {}
export fn iswcntrl_l() void {}
export fn iswctype() void {}
export fn iswctype_l() void {}
export fn iswdigit() void {}
export fn iswdigit_l() void {}
export fn iswgraph() void {}
export fn iswgraph_l() void {}
export fn iswlower() void {}
export fn iswlower_l() void {}
export fn iswprint() void {}
export fn iswprint_l() void {}
export fn iswpunct() void {}
export fn iswpunct_l() void {}
export fn iswspace() void {}
export fn iswspace_l() void {}
export fn iswupper() void {}
export fn iswupper_l() void {}
export fn iswxdigit() void {}
export fn iswxdigit_l() void {}
export fn isxdigit() void {}
export fn isxdigit_l() void {}
export fn jrand48() void {}
export fn jrand48_r() void {}
export fn key_decryptsession() void {}
export fn key_decryptsession_pk() void {}
export fn key_encryptsession() void {}
export fn key_encryptsession_pk() void {}
export fn key_gendes() void {}
export fn key_get_conv() void {}
export fn key_secretkey_is_set() void {}
export fn key_setnet() void {}
export fn key_setsecret() void {}
export fn kill() void {}
export fn killpg() void {}
export fn klogctl() void {}
export fn l64a() void {}
export fn labs() void {}
export fn lchmod() void {}
export fn lchown() void {}
export fn lckpwdf() void {}
export fn lcong48() void {}
export fn lcong48_r() void {}
export fn ldexp() void {}
export fn ldexpf() void {}
export fn ldexpl() void {}
export fn ldiv() void {}
export fn lfind() void {}
export fn lgetxattr() void {}
export fn link() void {}
export fn linkat() void {}
export fn listen() void {}
export fn listxattr() void {}
export fn llabs() void {}
export fn lldiv() void {}
export fn llistxattr() void {}
export fn llseek() void {}
export fn loc1() void {}
export fn loc2() void {}
export fn localeconv() void {}
export fn localtime() void {}
export fn localtime_r() void {}
export fn lockf() void {}
export fn lockf64() void {}
export fn locs() void {}
export fn longjmp() void {}
export fn lrand48() void {}
export fn lrand48_r() void {}
export fn lremovexattr() void {}
export fn lsearch() void {}
export fn lseek() void {}
export fn lseek64() void {}
export fn lsetxattr() void {}
export fn lutimes() void {}
export fn madvise() void {}
export fn makecontext() void {}
export fn mallinfo() void {}
export fn malloc() void {}
export fn malloc_get_state() void {}
export fn malloc_info() void {}
export fn malloc_set_state() void {}
export fn malloc_stats() void {}
export fn malloc_trim() void {}
export fn malloc_usable_size() void {}
export fn mallopt() void {}
export fn mallwatch() void {}
export fn mblen() void {}
export fn mbrlen() void {}
export fn mbrtoc16() void {}
export fn mbrtoc32() void {}
export fn mbrtowc() void {}
export fn mbsinit() void {}
export fn mbsnrtowcs() void {}
export fn mbsrtowcs() void {}
export fn mbstowcs() void {}
export fn mbtowc() void {}
export fn mcheck() void {}
export fn mcheck_check_all() void {}
export fn mcheck_pedantic() void {}
export fn mcount() void {}
export fn memalign() void {}
export fn memccpy() void {}
export fn memchr() void {}
export fn memcmp() void {}
export fn memcpy() void {}
export fn memfd_create() void {}
export fn memfrob() void {}
export fn memmem() void {}
export fn memmove() void {}
export fn mempcpy() void {}
export fn memrchr() void {}
export fn memset() void {}
export fn mincore() void {}
export fn mkdir() void {}
export fn mkdirat() void {}
export fn mkdtemp() void {}
export fn mkfifo() void {}
export fn mkfifoat() void {}
export fn mkostemp() void {}
export fn mkostemp64() void {}
export fn mkostemps() void {}
export fn mkostemps64() void {}
export fn mkstemp() void {}
export fn mkstemp64() void {}
export fn mkstemps() void {}
export fn mkstemps64() void {}
export fn mktemp() void {}
export fn mktime() void {}
export fn mlock() void {}
export fn mlock2() void {}
export fn mlockall() void {}
export fn mmap() void {}
export fn mmap64() void {}
export fn modf() void {}
export fn modff() void {}
export fn modfl() void {}
export fn modify_ldt() void {}
export fn moncontrol() void {}
export fn monstartup() void {}
export fn mount() void {}
export fn mprobe() void {}
export fn mprotect() void {}
export fn mrand48() void {}
export fn mrand48_r() void {}
export fn mremap() void {}
export fn msgctl() void {}
export fn msgget() void {}
export fn msgrcv() void {}
export fn msgsnd() void {}
export fn msync() void {}
export fn mtrace() void {}
export fn munlock() void {}
export fn munlockall() void {}
export fn munmap() void {}
export fn muntrace() void {}
export fn name_to_handle_at() void {}
export fn nanosleep() void {}
export fn netname2host() void {}
export fn netname2user() void {}
export fn newlocale() void {}
export fn nfsservctl() void {}
export fn nftw() void {}
export fn nftw64() void {}
export fn ngettext() void {}
export fn nice() void {}
export fn nl_langinfo() void {}
export fn nl_langinfo_l() void {}
export fn nrand48() void {}
export fn nrand48_r() void {}
export fn ntohl() void {}
export fn ntohs() void {}
export fn ntp_adjtime() void {}
export fn ntp_gettime() void {}
export fn ntp_gettimex() void {}
export fn obstack_alloc_failed_handler() void {}
export fn obstack_exit_failure() void {}
export fn obstack_free() void {}
export fn obstack_printf() void {}
export fn obstack_vprintf() void {}
export fn on_exit() void {}
export fn open() void {}
export fn open64() void {}
export fn open_by_handle_at() void {}
export fn open_memstream() void {}
export fn open_wmemstream() void {}
export fn openat() void {}
export fn openat64() void {}
export fn opendir() void {}
export fn openlog() void {}
export fn optarg() void {}
export fn opterr() void {}
export fn optind() void {}
export fn optopt() void {}
export fn parse_printf_format() void {}
export fn passwd2des() void {}
export fn pathconf() void {}
export fn pause() void {}
export fn pclose() void {}
export fn perror() void {}
export fn personality() void {}
export fn pipe() void {}
export fn pipe2() void {}
export fn pivot_root() void {}
export fn pkey_alloc() void {}
export fn pkey_free() void {}
export fn pkey_get() void {}
export fn pkey_mprotect() void {}
export fn pkey_set() void {}
export fn pmap_getmaps() void {}
export fn pmap_getport() void {}
export fn pmap_rmtcall() void {}
export fn pmap_set() void {}
export fn pmap_unset() void {}
export fn poll() void {}
export fn popen() void {}
export fn posix_fadvise() void {}
export fn posix_fadvise64() void {}
export fn posix_fallocate() void {}
export fn posix_fallocate64() void {}
export fn posix_madvise() void {}
export fn posix_memalign() void {}
export fn posix_openpt() void {}
export fn posix_spawn() void {}
export fn posix_spawn_file_actions_addchdir_np() void {}
export fn posix_spawn_file_actions_addclose() void {}
export fn posix_spawn_file_actions_adddup2() void {}
export fn posix_spawn_file_actions_addfchdir_np() void {}
export fn posix_spawn_file_actions_addopen() void {}
export fn posix_spawn_file_actions_destroy() void {}
export fn posix_spawn_file_actions_init() void {}
export fn posix_spawnattr_destroy() void {}
export fn posix_spawnattr_getflags() void {}
export fn posix_spawnattr_getpgroup() void {}
export fn posix_spawnattr_getschedparam() void {}
export fn posix_spawnattr_getschedpolicy() void {}
export fn posix_spawnattr_getsigdefault() void {}
export fn posix_spawnattr_getsigmask() void {}
export fn posix_spawnattr_init() void {}
export fn posix_spawnattr_setflags() void {}
export fn posix_spawnattr_setpgroup() void {}
export fn posix_spawnattr_setschedparam() void {}
export fn posix_spawnattr_setschedpolicy() void {}
export fn posix_spawnattr_setsigdefault() void {}
export fn posix_spawnattr_setsigmask() void {}
export fn posix_spawnp() void {}
export fn ppoll() void {}
export fn prctl() void {}
export fn pread() void {}
export fn pread64() void {}
export fn preadv() void {}
export fn preadv2() void {}
export fn preadv64() void {}
export fn preadv64v2() void {}
export fn printf() void {}
export fn printf_size() void {}
export fn printf_size_info() void {}
export fn prlimit() void {}
export fn prlimit64() void {}
export fn process_vm_readv() void {}
export fn process_vm_writev() void {}
export fn profil() void {}
export fn program_invocation_name() void {}
export fn program_invocation_short_name() void {}
export fn pselect() void {}
export fn psiginfo() void {}
export fn psignal() void {}
export fn pthread_attr_destroy() void {}
export fn pthread_attr_getdetachstate() void {}
export fn pthread_attr_getinheritsched() void {}
export fn pthread_attr_getschedparam() void {}
export fn pthread_attr_getschedpolicy() void {}
export fn pthread_attr_getscope() void {}
export fn pthread_attr_init() void {}
export fn pthread_attr_setdetachstate() void {}
export fn pthread_attr_setinheritsched() void {}
export fn pthread_attr_setschedparam() void {}
export fn pthread_attr_setschedpolicy() void {}
export fn pthread_attr_setscope() void {}
export fn pthread_cond_broadcast() void {}
export fn pthread_cond_destroy() void {}
export fn pthread_cond_init() void {}
export fn pthread_cond_signal() void {}
export fn pthread_cond_timedwait() void {}
export fn pthread_cond_wait() void {}
export fn pthread_condattr_destroy() void {}
export fn pthread_condattr_init() void {}
export fn pthread_equal() void {}
export fn pthread_exit() void {}
export fn pthread_getschedparam() void {}
export fn pthread_mutex_destroy() void {}
export fn pthread_mutex_init() void {}
export fn pthread_mutex_lock() void {}
export fn pthread_mutex_unlock() void {}
export fn pthread_self() void {}
export fn pthread_setcancelstate() void {}
export fn pthread_setcanceltype() void {}
export fn pthread_setschedparam() void {}
export fn ptrace() void {}
export fn ptsname() void {}
export fn ptsname_r() void {}
export fn putc() void {}
export fn putc_unlocked() void {}
export fn putchar() void {}
export fn putchar_unlocked() void {}
export fn putenv() void {}
export fn putgrent() void {}
export fn putmsg() void {}
export fn putpmsg() void {}
export fn putpwent() void {}
export fn puts() void {}
export fn putsgent() void {}
export fn putspent() void {}
export fn pututline() void {}
export fn pututxline() void {}
export fn putw() void {}
export fn putwc() void {}
export fn putwc_unlocked() void {}
export fn putwchar() void {}
export fn putwchar_unlocked() void {}
export fn pvalloc() void {}
export fn pwrite() void {}
export fn pwrite64() void {}
export fn pwritev() void {}
export fn pwritev2() void {}
export fn pwritev64() void {}
export fn pwritev64v2() void {}
export fn qecvt() void {}
export fn qecvt_r() void {}
export fn qfcvt() void {}
export fn qfcvt_r() void {}
export fn qgcvt() void {}
export fn qsort() void {}
export fn qsort_r() void {}
export fn query_module() void {}
export fn quick_exit() void {}
export fn quotactl() void {}
export fn raise() void {}
export fn rand() void {}
export fn rand_r() void {}
export fn random() void {}
export fn random_r() void {}
export fn rawmemchr() void {}
export fn rcmd() void {}
export fn rcmd_af() void {}
export fn re_comp() void {}
export fn re_compile_fastmap() void {}
export fn re_compile_pattern() void {}
export fn re_exec() void {}
export fn re_match() void {}
export fn re_match_2() void {}
export fn re_max_failures() void {}
export fn re_search() void {}
export fn re_search_2() void {}
export fn re_set_registers() void {}
export fn re_set_syntax() void {}
export fn re_syntax_options() void {}
export fn read() void {}
export fn readahead() void {}
export fn readdir() void {}
export fn readdir64() void {}
export fn readdir64_r() void {}
export fn readdir_r() void {}
export fn readlink() void {}
export fn readlinkat() void {}
export fn readv() void {}
export fn realloc() void {}
export fn reallocarray() void {}
export fn realpath() void {}
export fn reboot() void {}
export fn recv() void {}
export fn recvfrom() void {}
export fn recvmmsg() void {}
export fn recvmsg() void {}
export fn regcomp() void {}
export fn regerror() void {}
export fn regexec() void {}
export fn regfree() void {}
export fn register_printf_function() void {}
export fn register_printf_modifier() void {}
export fn register_printf_specifier() void {}
export fn register_printf_type() void {}
export fn registerrpc() void {}
export fn remap_file_pages() void {}
export fn remove() void {}
export fn removexattr() void {}
export fn remque() void {}
export fn rename() void {}
export fn renameat() void {}
export fn renameat2() void {}
export fn revoke() void {}
export fn rewind() void {}
export fn rewinddir() void {}
export fn rexec() void {}
export fn rexec_af() void {}
export fn rexecoptions() void {}
export fn rindex() void {}
export fn rmdir() void {}
export fn rpc_createerr() void {}
export fn rpmatch() void {}
export fn rresvport() void {}
export fn rresvport_af() void {}
export fn rtime() void {}
export fn ruserok() void {}
export fn ruserok_af() void {}
export fn ruserpass() void {}
export fn sbrk() void {}
export fn scalbn() void {}
export fn scalbnf() void {}
export fn scalbnl() void {}
export fn scandir() void {}
export fn scandir64() void {}
export fn scandirat() void {}
export fn scandirat64() void {}
export fn scanf() void {}
export fn sched_get_priority_max() void {}
export fn sched_get_priority_min() void {}
export fn sched_getaffinity() void {}
export fn sched_getcpu() void {}
export fn sched_getparam() void {}
export fn sched_getscheduler() void {}
export fn sched_rr_get_interval() void {}
export fn sched_setaffinity() void {}
export fn sched_setparam() void {}
export fn sched_setscheduler() void {}
export fn sched_yield() void {}
export fn secure_getenv() void {}
export fn seed48() void {}
export fn seed48_r() void {}
export fn seekdir() void {}
export fn select() void {}
export fn semctl() void {}
export fn semget() void {}
export fn semop() void {}
export fn semtimedop() void {}
export fn send() void {}
export fn sendfile() void {}
export fn sendfile64() void {}
export fn sendmmsg() void {}
export fn sendmsg() void {}
export fn sendto() void {}
export fn setaliasent() void {}
export fn setbuf() void {}
export fn setbuffer() void {}
export fn setcontext() void {}
export fn setdomainname() void {}
export fn setegid() void {}
export fn setenv() void {}
export fn seteuid() void {}
export fn setfsent() void {}
export fn setfsgid() void {}
export fn setfsuid() void {}
export fn setgid() void {}
export fn setgrent() void {}
export fn setgroups() void {}
export fn sethostent() void {}
export fn sethostid() void {}
export fn sethostname() void {}
export fn setipv4sourcefilter() void {}
export fn setitimer() void {}
export fn setjmp() void {}
export fn setlinebuf() void {}
export fn setlocale() void {}
export fn setlogin() void {}
export fn setlogmask() void {}
export fn setmntent() void {}
export fn setnetent() void {}
export fn setnetgrent() void {}
export fn setns() void {}
export fn setpgid() void {}
export fn setpgrp() void {}
export fn setpriority() void {}
export fn setprotoent() void {}
export fn setpwent() void {}
export fn setregid() void {}
export fn setresgid() void {}
export fn setresuid() void {}
export fn setreuid() void {}
export fn setrlimit() void {}
export fn setrlimit64() void {}
export fn setrpcent() void {}
export fn setservent() void {}
export fn setsgent() void {}
export fn setsid() void {}
export fn setsockopt() void {}
export fn setsourcefilter() void {}
export fn setspent() void {}
export fn setstate() void {}
export fn setstate_r() void {}
export fn settimeofday() void {}
export fn setttyent() void {}
export fn setuid() void {}
export fn setusershell() void {}
export fn setutent() void {}
export fn setutxent() void {}
export fn setvbuf() void {}
export fn setxattr() void {}
export fn sgetsgent() void {}
export fn sgetsgent_r() void {}
export fn sgetspent() void {}
export fn sgetspent_r() void {}
export fn shmat() void {}
export fn shmctl() void {}
export fn shmdt() void {}
export fn shmget() void {}
export fn shutdown() void {}
export fn sigaction() void {}
export fn sigaddset() void {}
export fn sigaltstack() void {}
export fn sigandset() void {}
export fn sigblock() void {}
export fn sigdelset() void {}
export fn sigemptyset() void {}
export fn sigfillset() void {}
export fn siggetmask() void {}
export fn sighold() void {}
export fn sigignore() void {}
export fn siginterrupt() void {}
export fn sigisemptyset() void {}
export fn sigismember() void {}
export fn siglongjmp() void {}
export fn signal() void {}
export fn signalfd() void {}
export fn sigorset() void {}
export fn sigpause() void {}
export fn sigpending() void {}
export fn sigprocmask() void {}
export fn sigqueue() void {}
export fn sigrelse() void {}
export fn sigreturn() void {}
export fn sigset() void {}
export fn sigsetmask() void {}
export fn sigstack() void {}
export fn sigsuspend() void {}
export fn sigtimedwait() void {}
export fn sigvec() void {}
export fn sigwait() void {}
export fn sigwaitinfo() void {}
export fn sleep() void {}
export fn snprintf() void {}
export fn sockatmark() void {}
export fn socket() void {}
export fn socketpair() void {}
export fn splice() void {}
export fn sprintf() void {}
export fn sprofil() void {}
export fn srand() void {}
export fn srand48() void {}
export fn srand48_r() void {}
export fn srandom() void {}
export fn srandom_r() void {}
export fn sscanf() void {}
export fn ssignal() void {}
export fn sstk() void {}
export fn statfs() void {}
export fn statfs64() void {}
export fn statvfs() void {}
export fn statvfs64() void {}
export fn statx() void {}
export fn stderr() void {}
export fn stdin() void {}
export fn stdout() void {}
export fn step() void {}
export fn stime() void {}
export fn stpcpy() void {}
export fn stpncpy() void {}
export fn strcasecmp() void {}
export fn strcasecmp_l() void {}
export fn strcasestr() void {}
export fn strcat() void {}
export fn strchr() void {}
export fn strchrnul() void {}
export fn strcmp() void {}
export fn strcoll() void {}
export fn strcoll_l() void {}
export fn strcpy() void {}
export fn strcspn() void {}
export fn strdup() void {}
export fn strerror() void {}
export fn strerror_l() void {}
export fn strerror_r() void {}
export fn strfmon() void {}
export fn strfmon_l() void {}
export fn strfromd() void {}
export fn strfromf() void {}
export fn strfromf128() void {}
export fn strfromf32() void {}
export fn strfromf32x() void {}
export fn strfromf64() void {}
export fn strfromf64x() void {}
export fn strfroml() void {}
export fn strfry() void {}
export fn strftime() void {}
export fn strftime_l() void {}
export fn strlen() void {}
export fn strncasecmp() void {}
export fn strncasecmp_l() void {}
export fn strncat() void {}
export fn strncmp() void {}
export fn strncpy() void {}
export fn strndup() void {}
export fn strnlen() void {}
export fn strpbrk() void {}
export fn strptime() void {}
export fn strptime_l() void {}
export fn strrchr() void {}
export fn strsep() void {}
export fn strsignal() void {}
export fn strspn() void {}
export fn strstr() void {}
export fn strtod() void {}
export fn strtod_l() void {}
export fn strtof() void {}
export fn strtof128() void {}
export fn strtof128_l() void {}
export fn strtof32() void {}
export fn strtof32_l() void {}
export fn strtof32x() void {}
export fn strtof32x_l() void {}
export fn strtof64() void {}
export fn strtof64_l() void {}
export fn strtof64x() void {}
export fn strtof64x_l() void {}
export fn strtof_l() void {}
export fn strtoimax() void {}
export fn strtok() void {}
export fn strtok_r() void {}
export fn strtol() void {}
export fn strtol_l() void {}
export fn strtold() void {}
export fn strtold_l() void {}
export fn strtoll() void {}
export fn strtoll_l() void {}
export fn strtoq() void {}
export fn strtoul() void {}
export fn strtoul_l() void {}
export fn strtoull() void {}
export fn strtoull_l() void {}
export fn strtoumax() void {}
export fn strtouq() void {}
export fn strverscmp() void {}
export fn strxfrm() void {}
export fn strxfrm_l() void {}
export fn stty() void {}
export fn svc_exit() void {}
export fn svc_fdset() void {}
export fn svc_getreq() void {}
export fn svc_getreq_common() void {}
export fn svc_getreq_poll() void {}
export fn svc_getreqset() void {}
export fn svc_max_pollfd() void {}
export fn svc_pollfd() void {}
export fn svc_register() void {}
export fn svc_run() void {}
export fn svc_sendreply() void {}
export fn svc_unregister() void {}
export fn svcauthdes_stats() void {}
export fn svcerr_auth() void {}
export fn svcerr_decode() void {}
export fn svcerr_noproc() void {}
export fn svcerr_noprog() void {}
export fn svcerr_progvers() void {}
export fn svcerr_systemerr() void {}
export fn svcerr_weakauth() void {}
export fn svcfd_create() void {}
export fn svcraw_create() void {}
export fn svctcp_create() void {}
export fn svcudp_bufcreate() void {}
export fn svcudp_create() void {}
export fn svcudp_enablecache() void {}
export fn svcunix_create() void {}
export fn svcunixfd_create() void {}
export fn swab() void {}
export fn swapcontext() void {}
export fn swapoff() void {}
export fn swapon() void {}
export fn swprintf() void {}
export fn swscanf() void {}
export fn symlink() void {}
export fn symlinkat() void {}
export fn sync() void {}
export fn sync_file_range() void {}
export fn syncfs() void {}
export fn sys_errlist() void {}
export fn sys_nerr() void {}
export fn sys_sigabbrev() void {}
export fn sys_siglist() void {}
export fn syscall() void {}
export fn sysconf() void {}
export fn sysctl() void {}
export fn sysinfo() void {}
export fn syslog() void {}
export fn system() void {}
export fn sysv_signal() void {}
export fn tcdrain() void {}
export fn tcflow() void {}
export fn tcflush() void {}
export fn tcgetattr() void {}
export fn tcgetpgrp() void {}
export fn tcgetsid() void {}
export fn tcsendbreak() void {}
export fn tcsetattr() void {}
export fn tcsetpgrp() void {}
export fn tdelete() void {}
export fn tdestroy() void {}
export fn tee() void {}
export fn telldir() void {}
export fn tempnam() void {}
export fn textdomain() void {}
export fn tfind() void {}
export fn thrd_current() void {}
export fn thrd_equal() void {}
export fn thrd_sleep() void {}
export fn thrd_yield() void {}
export fn time() void {}
export fn timegm() void {}
export fn timelocal() void {}
export fn timerfd_create() void {}
export fn timerfd_gettime() void {}
export fn timerfd_settime() void {}
export fn times() void {}
export fn timespec_get() void {}
export fn timezone() void {}
export fn tmpfile() void {}
export fn tmpfile64() void {}
export fn tmpnam() void {}
export fn tmpnam_r() void {}
export fn toascii() void {}
export fn tolower() void {}
export fn tolower_l() void {}
export fn toupper() void {}
export fn toupper_l() void {}
export fn towctrans() void {}
export fn towctrans_l() void {}
export fn towlower() void {}
export fn towlower_l() void {}
export fn towupper() void {}
export fn towupper_l() void {}
export fn tr_break() void {}
export fn truncate() void {}
export fn truncate64() void {}
export fn tsearch() void {}
export fn ttyname() void {}
export fn ttyname_r() void {}
export fn ttyslot() void {}
export fn twalk() void {}
export fn tzname() void {}
export fn tzset() void {}
export fn ualarm() void {}
export fn ulckpwdf() void {}
export fn ulimit() void {}
export fn umask() void {}
export fn umount() void {}
export fn umount2() void {}
export fn uname() void {}
export fn ungetc() void {}
export fn ungetwc() void {}
export fn unlink() void {}
export fn unlinkat() void {}
export fn unlockpt() void {}
export fn unsetenv() void {}
export fn unshare() void {}
export fn updwtmp() void {}
export fn updwtmpx() void {}
export fn uselib() void {}
export fn uselocale() void {}
export fn user2netname() void {}
export fn usleep() void {}
export fn ustat() void {}
export fn utime() void {}
export fn utimensat() void {}
export fn utimes() void {}
export fn utmpname() void {}
export fn utmpxname() void {}
export fn valloc() void {}
export fn vasprintf() void {}
export fn vdprintf() void {}
export fn verr() void {}
export fn verrx() void {}
export fn versionsort() void {}
export fn versionsort64() void {}
export fn vfork() void {}
export fn vfprintf() void {}
export fn vfscanf() void {}
export fn vfwprintf() void {}
export fn vfwscanf() void {}
export fn vhangup() void {}
export fn vlimit() void {}
export fn vmsplice() void {}
export fn vprintf() void {}
export fn vscanf() void {}
export fn vsnprintf() void {}
export fn vsprintf() void {}
export fn vsscanf() void {}
export fn vswprintf() void {}
export fn vswscanf() void {}
export fn vsyslog() void {}
export fn vtimes() void {}
export fn vwarn() void {}
export fn vwarnx() void {}
export fn vwprintf() void {}
export fn vwscanf() void {}
export fn wait() void {}
export fn wait3() void {}
export fn wait4() void {}
export fn waitid() void {}
export fn waitpid() void {}
export fn warn() void {}
export fn warnx() void {}
export fn wcpcpy() void {}
export fn wcpncpy() void {}
export fn wcrtomb() void {}
export fn wcscasecmp() void {}
export fn wcscasecmp_l() void {}
export fn wcscat() void {}
export fn wcschr() void {}
export fn wcschrnul() void {}
export fn wcscmp() void {}
export fn wcscoll() void {}
export fn wcscoll_l() void {}
export fn wcscpy() void {}
export fn wcscspn() void {}
export fn wcsdup() void {}
export fn wcsftime() void {}
export fn wcsftime_l() void {}
export fn wcslen() void {}
export fn wcsncasecmp() void {}
export fn wcsncasecmp_l() void {}
export fn wcsncat() void {}
export fn wcsncmp() void {}
export fn wcsncpy() void {}
export fn wcsnlen() void {}
export fn wcsnrtombs() void {}
export fn wcspbrk() void {}
export fn wcsrchr() void {}
export fn wcsrtombs() void {}
export fn wcsspn() void {}
export fn wcsstr() void {}
export fn wcstod() void {}
export fn wcstod_l() void {}
export fn wcstof() void {}
export fn wcstof128() void {}
export fn wcstof128_l() void {}
export fn wcstof32() void {}
export fn wcstof32_l() void {}
export fn wcstof32x() void {}
export fn wcstof32x_l() void {}
export fn wcstof64() void {}
export fn wcstof64_l() void {}
export fn wcstof64x() void {}
export fn wcstof64x_l() void {}
export fn wcstof_l() void {}
export fn wcstoimax() void {}
export fn wcstok() void {}
export fn wcstol() void {}
export fn wcstol_l() void {}
export fn wcstold() void {}
export fn wcstold_l() void {}
export fn wcstoll() void {}
export fn wcstoll_l() void {}
export fn wcstombs() void {}
export fn wcstoq() void {}
export fn wcstoul() void {}
export fn wcstoul_l() void {}
export fn wcstoull() void {}
export fn wcstoull_l() void {}
export fn wcstoumax() void {}
export fn wcstouq() void {}
export fn wcswcs() void {}
export fn wcswidth() void {}
export fn wcsxfrm() void {}
export fn wcsxfrm_l() void {}
export fn wctob() void {}
export fn wctomb() void {}
export fn wctrans() void {}
export fn wctrans_l() void {}
export fn wctype() void {}
export fn wctype_l() void {}
export fn wcwidth() void {}
export fn wmemchr() void {}
export fn wmemcmp() void {}
export fn wmemcpy() void {}
export fn wmemmove() void {}
export fn wmempcpy() void {}
export fn wmemset() void {}
export fn wordexp() void {}
export fn wordfree() void {}
export fn wprintf() void {}
export fn write() void {}
export fn writev() void {}
export fn wscanf() void {}
export fn xdecrypt() void {}
export fn xdr_accepted_reply() void {}
export fn xdr_array() void {}
export fn xdr_authdes_cred() void {}
export fn xdr_authdes_verf() void {}
export fn xdr_authunix_parms() void {}
export fn xdr_bool() void {}
export fn xdr_bytes() void {}
export fn xdr_callhdr() void {}
export fn xdr_callmsg() void {}
export fn xdr_char() void {}
export fn xdr_cryptkeyarg() void {}
export fn xdr_cryptkeyarg2() void {}
export fn xdr_cryptkeyres() void {}
export fn xdr_des_block() void {}
export fn xdr_double() void {}
export fn xdr_enum() void {}
export fn xdr_float() void {}
export fn xdr_free() void {}
export fn xdr_getcredres() void {}
export fn xdr_hyper() void {}
export fn xdr_int() void {}
export fn xdr_int16_t() void {}
export fn xdr_int32_t() void {}
export fn xdr_int64_t() void {}
export fn xdr_int8_t() void {}
export fn xdr_key_netstarg() void {}
export fn xdr_key_netstres() void {}
export fn xdr_keybuf() void {}
export fn xdr_keystatus() void {}
export fn xdr_long() void {}
export fn xdr_longlong_t() void {}
export fn xdr_netnamestr() void {}
export fn xdr_netobj() void {}
export fn xdr_opaque() void {}
export fn xdr_opaque_auth() void {}
export fn xdr_pmap() void {}
export fn xdr_pmaplist() void {}
export fn xdr_pointer() void {}
export fn xdr_quad_t() void {}
export fn xdr_reference() void {}
export fn xdr_rejected_reply() void {}
export fn xdr_replymsg() void {}
export fn xdr_rmtcall_args() void {}
export fn xdr_rmtcallres() void {}
export fn xdr_short() void {}
export fn xdr_sizeof() void {}
export fn xdr_string() void {}
export fn xdr_u_char() void {}
export fn xdr_u_hyper() void {}
export fn xdr_u_int() void {}
export fn xdr_u_long() void {}
export fn xdr_u_longlong_t() void {}
export fn xdr_u_quad_t() void {}
export fn xdr_u_short() void {}
export fn xdr_uint16_t() void {}
export fn xdr_uint32_t() void {}
export fn xdr_uint64_t() void {}
export fn xdr_uint8_t() void {}
export fn xdr_union() void {}
export fn xdr_unixcred() void {}
export fn xdr_vector() void {}
export fn xdr_void() void {}
export fn xdr_wrapstring() void {}
export fn xdrmem_create() void {}
export fn xdrrec_create() void {}
export fn xdrrec_endofrecord() void {}
export fn xdrrec_eof() void {}
export fn xdrrec_skiprecord() void {}
export fn xdrstdio_create() void {}
export fn xencrypt() void {}
export fn xprt_register() void {}
export fn xprt_unregister() void {}
