// third_party/blink/public/mojom/indexeddb/indexeddb.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-params-data.h"
#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_BLINK_JUMBO_H_
#include "third_party/blink/renderer/modules/indexeddb/indexed_db_blink_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
namespace blink {
IDBKeyPath::IDBKeyPath()
    : data() {}

IDBKeyPath::IDBKeyPath(
    IDBKeyPathDataPtr data_in)
    : data(std::move(data_in)) {}

IDBKeyPath::~IDBKeyPath() = default;

void IDBKeyPath::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("data", base::trace_event::ValueToString(this->data, "<value of type IDBKeyPathDataPtr>"));
}

bool IDBKeyPath::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBKeyRange::IDBKeyRange()
    : lower(),
      upper(),
      lower_open(),
      upper_open() {}

IDBKeyRange::IDBKeyRange(
    ::std::unique_ptr<::blink::IDBKey> lower_in,
    ::std::unique_ptr<::blink::IDBKey> upper_in,
    bool lower_open_in,
    bool upper_open_in)
    : lower(std::move(lower_in)),
      upper(std::move(upper_in)),
      lower_open(std::move(lower_open_in)),
      upper_open(std::move(upper_open_in)) {}

IDBKeyRange::~IDBKeyRange() = default;

void IDBKeyRange::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("lower", base::trace_event::ValueToString(this->lower, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
  value->SetString("upper", base::trace_event::ValueToString(this->upper, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
  value->SetBoolean("lower_open", this->lower_open);
  value->SetBoolean("upper_open", this->upper_open);
}

bool IDBKeyRange::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBIndexMetadata::IDBIndexMetadata()
    : id(),
      name(),
      key_path(),
      unique(),
      multi_entry() {}

IDBIndexMetadata::IDBIndexMetadata(
    int64_t id_in,
    const ::WTF::String& name_in,
    const ::blink::IDBKeyPath& key_path_in,
    bool unique_in,
    bool multi_entry_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      key_path(std::move(key_path_in)),
      unique(std::move(unique_in)),
      multi_entry(std::move(multi_entry_in)) {}

IDBIndexMetadata::~IDBIndexMetadata() = default;

void IDBIndexMetadata::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("id", base::NumberToString(this->id));
  value->SetString("name", base::trace_event::ValueToString(this->name, "<value of type const ::WTF::String&>"));
  value->SetString("key_path", base::trace_event::ValueToString(this->key_path, "<value of type const ::blink::IDBKeyPath&>"));
  value->SetBoolean("unique", this->unique);
  value->SetBoolean("multi_entry", this->multi_entry);
}

bool IDBIndexMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBObjectStoreMetadata::IDBObjectStoreMetadata()
    : id(),
      name(),
      key_path(),
      auto_increment(),
      max_index_id(),
      indexes() {}

IDBObjectStoreMetadata::IDBObjectStoreMetadata(
    int64_t id_in,
    const ::WTF::String& name_in,
    const ::blink::IDBKeyPath& key_path_in,
    bool auto_increment_in,
    int64_t max_index_id_in,
    const WTF::HashMap<int64_t, ::scoped_refptr<::blink::IDBIndexMetadata>>& indexes_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      key_path(std::move(key_path_in)),
      auto_increment(std::move(auto_increment_in)),
      max_index_id(std::move(max_index_id_in)),
      indexes(std::move(indexes_in)) {}

IDBObjectStoreMetadata::~IDBObjectStoreMetadata() = default;

void IDBObjectStoreMetadata::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("id", base::NumberToString(this->id));
  value->SetString("name", base::trace_event::ValueToString(this->name, "<value of type const ::WTF::String&>"));
  value->SetString("key_path", base::trace_event::ValueToString(this->key_path, "<value of type const ::blink::IDBKeyPath&>"));
  value->SetBoolean("auto_increment", this->auto_increment);
  value->SetString("max_index_id", base::NumberToString(this->max_index_id));
  value->BeginDictionary("indexes");
  for (const auto& item0 : this->indexes) {
    value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type int64_t>"), base::trace_event::ValueToString(item0.value, "<value of type const ::scoped_refptr<::blink::IDBIndexMetadata>&>"));
  }
  value->EndDictionary();
}

bool IDBObjectStoreMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBDatabaseMetadata::IDBDatabaseMetadata()
    : id(),
      name(),
      version(),
      max_object_store_id(),
      object_stores(),
      was_cold_open() {}

IDBDatabaseMetadata::IDBDatabaseMetadata(
    int64_t id_in,
    const ::WTF::String& name_in,
    int64_t version_in,
    int64_t max_object_store_id_in,
    const WTF::HashMap<int64_t, ::scoped_refptr<::blink::IDBObjectStoreMetadata>>& object_stores_in,
    bool was_cold_open_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      version(std::move(version_in)),
      max_object_store_id(std::move(max_object_store_id_in)),
      object_stores(std::move(object_stores_in)),
      was_cold_open(std::move(was_cold_open_in)) {}

IDBDatabaseMetadata::~IDBDatabaseMetadata() = default;

void IDBDatabaseMetadata::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("id", base::NumberToString(this->id));
  value->SetString("name", base::trace_event::ValueToString(this->name, "<value of type const ::WTF::String&>"));
  value->SetString("version", base::NumberToString(this->version));
  value->SetString("max_object_store_id", base::NumberToString(this->max_object_store_id));
  value->BeginDictionary("object_stores");
  for (const auto& item0 : this->object_stores) {
    value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type int64_t>"), base::trace_event::ValueToString(item0.value, "<value of type const ::scoped_refptr<::blink::IDBObjectStoreMetadata>&>"));
  }
  value->EndDictionary();
  value->SetBoolean("was_cold_open", this->was_cold_open);
}

bool IDBDatabaseMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBNameAndVersion::IDBNameAndVersion()
    : name(),
      version() {}

IDBNameAndVersion::IDBNameAndVersion(
    const ::WTF::String& name_in,
    int64_t version_in)
    : name(std::move(name_in)),
      version(std::move(version_in)) {}

IDBNameAndVersion::~IDBNameAndVersion() = default;

void IDBNameAndVersion::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("name", base::trace_event::ValueToString(this->name, "<value of type const ::WTF::String&>"));
  value->SetString("version", base::NumberToString(this->version));
}

bool IDBNameAndVersion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBIndexKeys::IDBIndexKeys()
    : index_id(),
      index_keys() {}

IDBIndexKeys::IDBIndexKeys(
    int64_t index_id_in,
    WTF::Vector<::std::unique_ptr<::blink::IDBKey>> index_keys_in)
    : index_id(std::move(index_id_in)),
      index_keys(std::move(index_keys_in)) {}

IDBIndexKeys::~IDBIndexKeys() = default;

void IDBIndexKeys::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("index_id", base::NumberToString(this->index_id));
  value->BeginArray("index_keys");
  for (const auto& item0 : this->index_keys) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
  }
  value->EndArray();
}

bool IDBIndexKeys::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBFileInfo::IDBFileInfo()
    : name(),
      last_modified() {}

IDBFileInfo::IDBFileInfo(
    const ::WTF::String& name_in,
    ::base::Time last_modified_in)
    : name(std::move(name_in)),
      last_modified(std::move(last_modified_in)) {}

IDBFileInfo::~IDBFileInfo() = default;

void IDBFileInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("name", base::trace_event::ValueToString(this->name, "<value of type const ::WTF::String&>"));
  value->SetString("last_modified", base::trace_event::ValueToString(this->last_modified, "<value of type ::base::Time>"));
}

bool IDBFileInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBBlobInfo::IDBBlobInfo()
    : blob(),
      uuid(),
      mime_type(),
      size(),
      file() {}

IDBBlobInfo::IDBBlobInfo(
    ::mojo::PendingRemote<::blink::mojom::blink::Blob> blob_in,
    const WTF::String& uuid_in,
    const ::WTF::String& mime_type_in,
    int64_t size_in,
    IDBFileInfoPtr file_in)
    : blob(std::move(blob_in)),
      uuid(std::move(uuid_in)),
      mime_type(std::move(mime_type_in)),
      size(std::move(size_in)),
      file(std::move(file_in)) {}

IDBBlobInfo::~IDBBlobInfo() = default;

void IDBBlobInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("blob", this->blob.is_valid());
  value->SetString("uuid", this->uuid.Utf8());
  value->SetString("mime_type", base::trace_event::ValueToString(this->mime_type, "<value of type const ::WTF::String&>"));
  value->SetString("size", base::NumberToString(this->size));
  if (this->file.is_null()) {
    value->SetString("file", "nullptr");
  } else {
    value->BeginDictionary("file");
    this->file->AsValueInto(value);
    value->EndDictionary();
  }
}

bool IDBBlobInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBValue::IDBValue()
    : bits(),
      external_objects() {}

IDBValue::IDBValue(
    WTF::Vector<uint8_t> bits_in,
    WTF::Vector<IDBExternalObjectPtr> external_objects_in)
    : bits(std::move(bits_in)),
      external_objects(std::move(external_objects_in)) {}

IDBValue::~IDBValue() = default;

void IDBValue::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("bits");
  for (const auto& item0 : this->bits) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->BeginArray("external_objects");
  for (const auto& item0 : this->external_objects) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type IDBExternalObjectPtr>"));
  }
  value->EndArray();
}

bool IDBValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBReturnValue::IDBReturnValue()
    : value(),
      primary_key(),
      key_path() {}

IDBReturnValue::IDBReturnValue(
    ::std::unique_ptr<::blink::IDBValue> value_in,
    ::std::unique_ptr<::blink::IDBKey> primary_key_in,
    const ::blink::IDBKeyPath& key_path_in)
    : value(std::move(value_in)),
      primary_key(std::move(primary_key_in)),
      key_path(std::move(key_path_in)) {}

IDBReturnValue::~IDBReturnValue() = default;

void IDBReturnValue::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("value", base::trace_event::ValueToString(this->value, "<value of type ::std::unique_ptr<::blink::IDBValue>>"));
  value->SetString("primary_key", base::trace_event::ValueToString(this->primary_key, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
  value->SetString("key_path", base::trace_event::ValueToString(this->key_path, "<value of type const ::blink::IDBKeyPath&>"));
}

bool IDBReturnValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBObservation::IDBObservation()
    : object_store_id(),
      type(),
      key_range(),
      value() {}

IDBObservation::IDBObservation(
    int64_t object_store_id_in,
    IDBOperationType type_in,
    IDBKeyRangePtr key_range_in,
    base::Optional<::std::unique_ptr<::blink::IDBValue>> value_in)
    : object_store_id(std::move(object_store_id_in)),
      type(std::move(type_in)),
      key_range(std::move(key_range_in)),
      value(std::move(value_in)) {}

IDBObservation::~IDBObservation() = default;

void IDBObservation::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("object_store_id", base::NumberToString(this->object_store_id));
  value->SetString("type", base::trace_event::ValueToString(this->type));
  if (this->key_range.is_null()) {
    value->SetString("key_range", "nullptr");
  } else {
    value->BeginDictionary("key_range");
    this->key_range->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("value", base::trace_event::ValueToString(this->value, "<value of type base::Optional<::std::unique_ptr<::blink::IDBValue>>>"));
}

bool IDBObservation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBObserverTransaction::IDBObserverTransaction()
    : id(),
      scope() {}

IDBObserverTransaction::IDBObserverTransaction(
    int64_t id_in,
    WTF::Vector<int64_t> scope_in)
    : id(std::move(id_in)),
      scope(std::move(scope_in)) {}

IDBObserverTransaction::~IDBObserverTransaction() = default;

void IDBObserverTransaction::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("id", base::NumberToString(this->id));
  value->BeginArray("scope");
  for (const auto& item0 : this->scope) {
    value->AppendString(base::NumberToString(item0));
  }
  value->EndArray();
}

bool IDBObserverTransaction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBObserverChanges::IDBObserverChanges()
    : observation_index_map(),
      transaction_map(),
      observations() {}

IDBObserverChanges::IDBObserverChanges(
    const WTF::HashMap<int32_t, WTF::Vector<int32_t>>& observation_index_map_in,
    WTF::HashMap<int32_t, IDBObserverTransactionPtr> transaction_map_in,
    WTF::Vector<IDBObservationPtr> observations_in)
    : observation_index_map(std::move(observation_index_map_in)),
      transaction_map(std::move(transaction_map_in)),
      observations(std::move(observations_in)) {}

IDBObserverChanges::~IDBObserverChanges() = default;

void IDBObserverChanges::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginDictionary("observation_index_map");
  for (const auto& item0 : this->observation_index_map) {
    value->BeginArrayWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type int32_t>"));
    for (const auto& item1 : item0.value) {
      value->AppendInteger(item1);
    }
    value->EndArray();
  }
  value->EndDictionary();
  value->BeginDictionary("transaction_map");
  for (const auto& item0 : this->transaction_map) {
    if (item0.value.is_null()) {
      value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type int32_t>"), "nullptr");
    } else {
      value->BeginDictionaryWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type int32_t>"));
      item0.value->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndDictionary();
  value->BeginArray("observations");
  for (const auto& item0 : this->observations) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
}

bool IDBObserverChanges::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBError::IDBError()
    : error_code(),
      error_message() {}

IDBError::IDBError(
    IDBException error_code_in,
    const ::WTF::String& error_message_in)
    : error_code(std::move(error_code_in)),
      error_message(std::move(error_message_in)) {}

IDBError::~IDBError() = default;

void IDBError::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("error_code", base::trace_event::ValueToString(this->error_code));
  value->SetString("error_message", base::trace_event::ValueToString(this->error_message, "<value of type const ::WTF::String&>"));
}

bool IDBError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBCursorValue::IDBCursorValue()
    : keys(),
      primary_keys(),
      values() {}

IDBCursorValue::IDBCursorValue(
    WTF::Vector<::std::unique_ptr<::blink::IDBKey>> keys_in,
    WTF::Vector<::std::unique_ptr<::blink::IDBKey>> primary_keys_in,
    WTF::Vector<::std::unique_ptr<::blink::IDBValue>> values_in)
    : keys(std::move(keys_in)),
      primary_keys(std::move(primary_keys_in)),
      values(std::move(values_in)) {}

IDBCursorValue::~IDBCursorValue() = default;

void IDBCursorValue::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("keys");
  for (const auto& item0 : this->keys) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
  }
  value->EndArray();
  value->BeginArray("primary_keys");
  for (const auto& item0 : this->primary_keys) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
  }
  value->EndArray();
  value->BeginArray("values");
  for (const auto& item0 : this->values) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::std::unique_ptr<::blink::IDBValue>>"));
  }
  value->EndArray();
}

bool IDBCursorValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBPutParams::IDBPutParams()
    : value(),
      key(),
      index_keys() {}

IDBPutParams::IDBPutParams(
    ::std::unique_ptr<::blink::IDBValue> value_in,
    ::std::unique_ptr<::blink::IDBKey> key_in,
    WTF::Vector<::blink::IDBIndexKeys> index_keys_in)
    : value(std::move(value_in)),
      key(std::move(key_in)),
      index_keys(std::move(index_keys_in)) {}

IDBPutParams::~IDBPutParams() = default;

void IDBPutParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("value", base::trace_event::ValueToString(this->value, "<value of type ::std::unique_ptr<::blink::IDBValue>>"));
  value->SetString("key", base::trace_event::ValueToString(this->key, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
  value->BeginArray("index_keys");
  for (const auto& item0 : this->index_keys) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::blink::IDBIndexKeys>"));
  }
  value->EndArray();
}

bool IDBPutParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBDatabaseOpenCursorValue::IDBDatabaseOpenCursorValue()
    : cursor(),
      key(),
      primary_key(),
      value() {}

IDBDatabaseOpenCursorValue::IDBDatabaseOpenCursorValue(
    ::mojo::PendingAssociatedRemote<IDBCursor> cursor_in,
    ::std::unique_ptr<::blink::IDBKey> key_in,
    ::std::unique_ptr<::blink::IDBKey> primary_key_in,
    base::Optional<::std::unique_ptr<::blink::IDBValue>> value_in)
    : cursor(std::move(cursor_in)),
      key(std::move(key_in)),
      primary_key(std::move(primary_key_in)),
      value(std::move(value_in)) {}

IDBDatabaseOpenCursorValue::~IDBDatabaseOpenCursorValue() = default;

void IDBDatabaseOpenCursorValue::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("cursor", this->cursor.is_valid());
  value->SetString("key", base::trace_event::ValueToString(this->key, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
  value->SetString("primary_key", base::trace_event::ValueToString(this->primary_key, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
  value->SetString("value", base::trace_event::ValueToString(this->value, "<value of type base::Optional<::std::unique_ptr<::blink::IDBValue>>>"));
}

bool IDBDatabaseOpenCursorValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBKey::IDBKey() : tag_(Tag::KEY_ARRAY) {
  data_.key_array = new WTF::Vector<::std::unique_ptr<::blink::IDBKey>>;
}

IDBKey::~IDBKey() {
  DestroyActive();
}


void IDBKey::set_key_array(
    WTF::Vector<::std::unique_ptr<::blink::IDBKey>> key_array) {
  if (tag_ == Tag::KEY_ARRAY) {
    *(data_.key_array) = std::move(key_array);
  } else {
    DestroyActive();
    tag_ = Tag::KEY_ARRAY;
    data_.key_array = new WTF::Vector<::std::unique_ptr<::blink::IDBKey>>(
        std::move(key_array));
  }
}
void IDBKey::set_binary(
    WTF::Vector<uint8_t> binary) {
  if (tag_ == Tag::BINARY) {
    *(data_.binary) = std::move(binary);
  } else {
    DestroyActive();
    tag_ = Tag::BINARY;
    data_.binary = new WTF::Vector<uint8_t>(
        std::move(binary));
  }
}
void IDBKey::set_string(
    const ::WTF::String& string) {
  if (tag_ == Tag::STRING) {
    *(data_.string) = std::move(string);
  } else {
    DestroyActive();
    tag_ = Tag::STRING;
    data_.string = new ::WTF::String(
        std::move(string));
  }
}
void IDBKey::set_date(
    double date) {
  if (tag_ != Tag::DATE) {
    DestroyActive();
    tag_ = Tag::DATE;
  }
  data_.date = date;
}
void IDBKey::set_number(
    double number) {
  if (tag_ != Tag::NUMBER) {
    DestroyActive();
    tag_ = Tag::NUMBER;
  }
  data_.number = number;
}
void IDBKey::set_other_none(
    bool other_none) {
  if (tag_ != Tag::OTHER_NONE) {
    DestroyActive();
    tag_ = Tag::OTHER_NONE;
  }
  data_.other_none = other_none;
}

void IDBKey::DestroyActive() {
  switch (tag_) {

    case Tag::KEY_ARRAY:

      delete data_.key_array;
      break;
    case Tag::BINARY:

      delete data_.binary;
      break;
    case Tag::STRING:

      delete data_.string;
      break;
    case Tag::DATE:

      break;
    case Tag::NUMBER:

      break;
    case Tag::OTHER_NONE:

      break;
  }
}

bool IDBKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IDBKeyPathData::IDBKeyPathData() : tag_(Tag::STRING) {
  data_.string = new ::WTF::String;
}

IDBKeyPathData::~IDBKeyPathData() {
  DestroyActive();
}


void IDBKeyPathData::set_string(
    const ::WTF::String& string) {
  if (tag_ == Tag::STRING) {
    *(data_.string) = std::move(string);
  } else {
    DestroyActive();
    tag_ = Tag::STRING;
    data_.string = new ::WTF::String(
        std::move(string));
  }
}
void IDBKeyPathData::set_string_array(
    WTF::Vector<::WTF::String> string_array) {
  if (tag_ == Tag::STRING_ARRAY) {
    *(data_.string_array) = std::move(string_array);
  } else {
    DestroyActive();
    tag_ = Tag::STRING_ARRAY;
    data_.string_array = new WTF::Vector<::WTF::String>(
        std::move(string_array));
  }
}

void IDBKeyPathData::DestroyActive() {
  switch (tag_) {

    case Tag::STRING:

      delete data_.string;
      break;
    case Tag::STRING_ARRAY:

      delete data_.string_array;
      break;
  }
}

bool IDBKeyPathData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IDBExternalObject::IDBExternalObject() : tag_(Tag::BLOB_OR_FILE) {
  data_.blob_or_file = new IDBBlobInfoPtr;
}

IDBExternalObject::~IDBExternalObject() {
  DestroyActive();
}


void IDBExternalObject::set_blob_or_file(
    IDBBlobInfoPtr blob_or_file) {
  if (tag_ == Tag::BLOB_OR_FILE) {
    *(data_.blob_or_file) = std::move(blob_or_file);
  } else {
    DestroyActive();
    tag_ = Tag::BLOB_OR_FILE;
    data_.blob_or_file = new IDBBlobInfoPtr(
        std::move(blob_or_file));
  }
}
void IDBExternalObject::set_native_file_system_token(
    ::mojo::PendingRemote<::blink::mojom::blink::NativeFileSystemTransferToken> native_file_system_token) {
  if (tag_ == Tag::NATIVE_FILE_SYSTEM_TOKEN) {
    *(data_.native_file_system_token) = std::move(native_file_system_token);
  } else {
    DestroyActive();
    tag_ = Tag::NATIVE_FILE_SYSTEM_TOKEN;
    data_.native_file_system_token = new ::mojo::PendingRemote<::blink::mojom::blink::NativeFileSystemTransferToken>(
        std::move(native_file_system_token));
  }
}

void IDBExternalObject::DestroyActive() {
  switch (tag_) {

    case Tag::BLOB_OR_FILE:

      delete data_.blob_or_file;
      break;
    case Tag::NATIVE_FILE_SYSTEM_TOKEN:

      delete data_.native_file_system_token;
      break;
  }
}

bool IDBExternalObject::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IDBCursorResult::IDBCursorResult() : tag_(Tag::ERROR_RESULT) {
  data_.error_result = new IDBErrorPtr;
}

IDBCursorResult::~IDBCursorResult() {
  DestroyActive();
}


void IDBCursorResult::set_error_result(
    IDBErrorPtr error_result) {
  if (tag_ == Tag::ERROR_RESULT) {
    *(data_.error_result) = std::move(error_result);
  } else {
    DestroyActive();
    tag_ = Tag::ERROR_RESULT;
    data_.error_result = new IDBErrorPtr(
        std::move(error_result));
  }
}
void IDBCursorResult::set_empty(
    bool empty) {
  if (tag_ != Tag::EMPTY) {
    DestroyActive();
    tag_ = Tag::EMPTY;
  }
  data_.empty = empty;
}
void IDBCursorResult::set_values(
    IDBCursorValuePtr values) {
  if (tag_ == Tag::VALUES) {
    *(data_.values) = std::move(values);
  } else {
    DestroyActive();
    tag_ = Tag::VALUES;
    data_.values = new IDBCursorValuePtr(
        std::move(values));
  }
}

void IDBCursorResult::DestroyActive() {
  switch (tag_) {

    case Tag::ERROR_RESULT:

      delete data_.error_result;
      break;
    case Tag::EMPTY:

      break;
    case Tag::VALUES:

      delete data_.values;
      break;
  }
}

bool IDBCursorResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IDBTransactionPutResult::IDBTransactionPutResult() : tag_(Tag::ERROR_RESULT) {
  data_.error_result = new IDBErrorPtr;
}

IDBTransactionPutResult::~IDBTransactionPutResult() {
  DestroyActive();
}


void IDBTransactionPutResult::set_error_result(
    IDBErrorPtr error_result) {
  if (tag_ == Tag::ERROR_RESULT) {
    *(data_.error_result) = std::move(error_result);
  } else {
    DestroyActive();
    tag_ = Tag::ERROR_RESULT;
    data_.error_result = new IDBErrorPtr(
        std::move(error_result));
  }
}
void IDBTransactionPutResult::set_key(
    ::std::unique_ptr<::blink::IDBKey> key) {
  if (tag_ == Tag::KEY) {
    *(data_.key) = std::move(key);
  } else {
    DestroyActive();
    tag_ = Tag::KEY;
    data_.key = new ::std::unique_ptr<::blink::IDBKey>(
        std::move(key));
  }
}

void IDBTransactionPutResult::DestroyActive() {
  switch (tag_) {

    case Tag::ERROR_RESULT:

      delete data_.error_result;
      break;
    case Tag::KEY:

      delete data_.key;
      break;
  }
}

bool IDBTransactionPutResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IDBTransactionPutAllResult::IDBTransactionPutAllResult() : tag_(Tag::ERROR_RESULT) {
  data_.error_result = new IDBErrorPtr;
}

IDBTransactionPutAllResult::~IDBTransactionPutAllResult() {
  DestroyActive();
}


void IDBTransactionPutAllResult::set_error_result(
    IDBErrorPtr error_result) {
  if (tag_ == Tag::ERROR_RESULT) {
    *(data_.error_result) = std::move(error_result);
  } else {
    DestroyActive();
    tag_ = Tag::ERROR_RESULT;
    data_.error_result = new IDBErrorPtr(
        std::move(error_result));
  }
}
void IDBTransactionPutAllResult::set_keys(
    WTF::Vector<::std::unique_ptr<::blink::IDBKey>> keys) {
  if (tag_ == Tag::KEYS) {
    *(data_.keys) = std::move(keys);
  } else {
    DestroyActive();
    tag_ = Tag::KEYS;
    data_.keys = new WTF::Vector<::std::unique_ptr<::blink::IDBKey>>(
        std::move(keys));
  }
}

void IDBTransactionPutAllResult::DestroyActive() {
  switch (tag_) {

    case Tag::ERROR_RESULT:

      delete data_.error_result;
      break;
    case Tag::KEYS:

      delete data_.keys;
      break;
  }
}

bool IDBTransactionPutAllResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IDBDatabaseGetResult::IDBDatabaseGetResult() : tag_(Tag::ERROR_RESULT) {
  data_.error_result = new IDBErrorPtr;
}

IDBDatabaseGetResult::~IDBDatabaseGetResult() {
  DestroyActive();
}


void IDBDatabaseGetResult::set_error_result(
    IDBErrorPtr error_result) {
  if (tag_ == Tag::ERROR_RESULT) {
    *(data_.error_result) = std::move(error_result);
  } else {
    DestroyActive();
    tag_ = Tag::ERROR_RESULT;
    data_.error_result = new IDBErrorPtr(
        std::move(error_result));
  }
}
void IDBDatabaseGetResult::set_empty(
    bool empty) {
  if (tag_ != Tag::EMPTY) {
    DestroyActive();
    tag_ = Tag::EMPTY;
  }
  data_.empty = empty;
}
void IDBDatabaseGetResult::set_key(
    ::std::unique_ptr<::blink::IDBKey> key) {
  if (tag_ == Tag::KEY) {
    *(data_.key) = std::move(key);
  } else {
    DestroyActive();
    tag_ = Tag::KEY;
    data_.key = new ::std::unique_ptr<::blink::IDBKey>(
        std::move(key));
  }
}
void IDBDatabaseGetResult::set_value(
    IDBReturnValuePtr value) {
  if (tag_ == Tag::VALUE) {
    *(data_.value) = std::move(value);
  } else {
    DestroyActive();
    tag_ = Tag::VALUE;
    data_.value = new IDBReturnValuePtr(
        std::move(value));
  }
}

void IDBDatabaseGetResult::DestroyActive() {
  switch (tag_) {

    case Tag::ERROR_RESULT:

      delete data_.error_result;
      break;
    case Tag::EMPTY:

      break;
    case Tag::KEY:

      delete data_.key;
      break;
    case Tag::VALUE:

      delete data_.value;
      break;
  }
}

bool IDBDatabaseGetResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IDBDatabaseOpenCursorResult::IDBDatabaseOpenCursorResult() : tag_(Tag::ERROR_RESULT) {
  data_.error_result = new IDBErrorPtr;
}

IDBDatabaseOpenCursorResult::~IDBDatabaseOpenCursorResult() {
  DestroyActive();
}


void IDBDatabaseOpenCursorResult::set_error_result(
    IDBErrorPtr error_result) {
  if (tag_ == Tag::ERROR_RESULT) {
    *(data_.error_result) = std::move(error_result);
  } else {
    DestroyActive();
    tag_ = Tag::ERROR_RESULT;
    data_.error_result = new IDBErrorPtr(
        std::move(error_result));
  }
}
void IDBDatabaseOpenCursorResult::set_empty(
    bool empty) {
  if (tag_ != Tag::EMPTY) {
    DestroyActive();
    tag_ = Tag::EMPTY;
  }
  data_.empty = empty;
}
void IDBDatabaseOpenCursorResult::set_value(
    IDBDatabaseOpenCursorValuePtr value) {
  if (tag_ == Tag::VALUE) {
    *(data_.value) = std::move(value);
  } else {
    DestroyActive();
    tag_ = Tag::VALUE;
    data_.value = new IDBDatabaseOpenCursorValuePtr(
        std::move(value));
  }
}

void IDBDatabaseOpenCursorResult::DestroyActive() {
  switch (tag_) {

    case Tag::ERROR_RESULT:

      delete data_.error_result;
      break;
    case Tag::EMPTY:

      break;
    case Tag::VALUE:

      delete data_.value;
      break;
  }
}

bool IDBDatabaseOpenCursorResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char IDBCallbacks::Name_[] = "blink.mojom.IDBCallbacks";

IDBCallbacksProxy::IDBCallbacksProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBCallbacksProxy::Error(
    IDBException in_code, const ::WTF::String& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBCallbacks::Error", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("code", base::trace_event::ValueToString(in_code));
      raw_value->SetString("message", base::trace_event::ValueToString(in_message, "<value of type const ::WTF::String&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCallbacks_Error_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCallbacks_Error_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::IDBException>(
      in_code, &params->code);
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_message, buffer, &message_writer, &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in IDBCallbacks.Error request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCallbacks::Name_);
  message.set_method_name("Error");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBCallbacksProxy::SuccessNamesAndVersionsList(
    WTF::Vector<IDBNameAndVersionPtr> in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBCallbacks::SuccessNamesAndVersionsList", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("value");
      for (const auto& item0 : in_value) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCallbacks_SuccessNamesAndVersionsList_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCallbacks_SuccessNamesAndVersionsList_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->value)::BaseType::BufferWriter
      value_writer;
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBNameAndVersionDataView>>(
      in_value, buffer, &value_writer, &value_validate_params,
      &serialization_context);
  params->value.Set(
      value_writer.is_null() ? nullptr : value_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in IDBCallbacks.SuccessNamesAndVersionsList request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCallbacks::Name_);
  message.set_method_name("SuccessNamesAndVersionsList");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBCallbacksProxy::SuccessStringList(
    const WTF::Vector<::WTF::String>& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBCallbacks::SuccessStringList", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("value");
      for (const auto& item0 : in_value) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::WTF::String&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCallbacks_SuccessStringList_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCallbacks_SuccessStringList_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->value)::BaseType::BufferWriter
      value_writer;
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
      in_value, buffer, &value_writer, &value_validate_params,
      &serialization_context);
  params->value.Set(
      value_writer.is_null() ? nullptr : value_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in IDBCallbacks.SuccessStringList request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCallbacks::Name_);
  message.set_method_name("SuccessStringList");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBCallbacksProxy::Blocked(
    int64_t in_existing_version) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBCallbacks::Blocked", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("existing_version", base::NumberToString(in_existing_version));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCallbacks_Blocked_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCallbacks_Blocked_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->existing_version = in_existing_version;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCallbacks::Name_);
  message.set_method_name("Blocked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBCallbacksProxy::UpgradeNeeded(
    ::mojo::PendingAssociatedRemote<IDBDatabase> in_pending_database, int64_t in_old_version, IDBDataLoss in_data_loss, const WTF::String& in_data_loss_message, const ::blink::IDBDatabaseMetadata& in_db_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBCallbacks::UpgradeNeeded", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("pending_database", in_pending_database.is_valid());
      raw_value->SetString("old_version", base::NumberToString(in_old_version));
      raw_value->SetString("data_loss", base::trace_event::ValueToString(in_data_loss));
      raw_value->SetString("data_loss_message", in_data_loss_message.Utf8());
      raw_value->SetString("db_metadata", base::trace_event::ValueToString(in_db_metadata, "<value of type const ::blink::IDBDatabaseMetadata&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCallbacks_UpgradeNeeded_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCallbacks_UpgradeNeeded_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseAssociatedPtrInfoDataView>(
      in_pending_database, &params->pending_database, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pending_database),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid pending_database in IDBCallbacks.UpgradeNeeded request");
  params->old_version = in_old_version;
  mojo::internal::Serialize<::blink::mojom::IDBDataLoss>(
      in_data_loss, &params->data_loss);
  typename decltype(params->data_loss_message)::BaseType::BufferWriter
      data_loss_message_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_data_loss_message, buffer, &data_loss_message_writer, &serialization_context);
  params->data_loss_message.Set(
      data_loss_message_writer.is_null() ? nullptr : data_loss_message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data_loss_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data_loss_message in IDBCallbacks.UpgradeNeeded request");
  typename decltype(params->db_metadata)::BaseType::BufferWriter
      db_metadata_writer;
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseMetadataDataView>(
      in_db_metadata, buffer, &db_metadata_writer, &serialization_context);
  params->db_metadata.Set(
      db_metadata_writer.is_null() ? nullptr : db_metadata_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->db_metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null db_metadata in IDBCallbacks.UpgradeNeeded request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCallbacks::Name_);
  message.set_method_name("UpgradeNeeded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBCallbacksProxy::SuccessDatabase(
    ::mojo::PendingAssociatedRemote<IDBDatabase> in_pending_database, const ::blink::IDBDatabaseMetadata& in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBCallbacks::SuccessDatabase", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("pending_database", in_pending_database.is_valid());
      raw_value->SetString("metadata", base::trace_event::ValueToString(in_metadata, "<value of type const ::blink::IDBDatabaseMetadata&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCallbacks_SuccessDatabase_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCallbacks_SuccessDatabase_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseAssociatedPtrInfoDataView>(
      in_pending_database, &params->pending_database, &serialization_context);
  typename decltype(params->metadata)::BaseType::BufferWriter
      metadata_writer;
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseMetadataDataView>(
      in_metadata, buffer, &metadata_writer, &serialization_context);
  params->metadata.Set(
      metadata_writer.is_null() ? nullptr : metadata_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in IDBCallbacks.SuccessDatabase request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCallbacks::Name_);
  message.set_method_name("SuccessDatabase");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBCallbacksProxy::SuccessInteger(
    int64_t in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBCallbacks::SuccessInteger", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("value", base::NumberToString(in_value));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCallbacks_SuccessInteger_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCallbacks_SuccessInteger_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->value = in_value;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCallbacks::Name_);
  message.set_method_name("SuccessInteger");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBCallbacksProxy::Success(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::IDBCallbacks::Success");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCallbacks_Success_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCallbacks_Success_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCallbacks::Name_);
  message.set_method_name("Success");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool IDBCallbacksStubDispatch::Accept(
    IDBCallbacks* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kIDBCallbacks_Error_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBCallbacks::Error",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBCallbacks::Error");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBCallbacks_Error_Params_Data* params =
          reinterpret_cast<internal::IDBCallbacks_Error_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      IDBException p_code{};
      ::WTF::String p_message{};
      IDBCallbacks_Error_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCode(&p_code))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCallbacks::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Error(
std::move(p_code), 
std::move(p_message));
      return true;
    }
    case internal::kIDBCallbacks_SuccessNamesAndVersionsList_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBCallbacks::SuccessNamesAndVersionsList",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBCallbacks::SuccessNamesAndVersionsList");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBCallbacks_SuccessNamesAndVersionsList_Params_Data* params =
          reinterpret_cast<internal::IDBCallbacks_SuccessNamesAndVersionsList_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<IDBNameAndVersionPtr> p_value{};
      IDBCallbacks_SuccessNamesAndVersionsList_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCallbacks::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuccessNamesAndVersionsList(
std::move(p_value));
      return true;
    }
    case internal::kIDBCallbacks_SuccessStringList_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBCallbacks::SuccessStringList",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBCallbacks::SuccessStringList");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBCallbacks_SuccessStringList_Params_Data* params =
          reinterpret_cast<internal::IDBCallbacks_SuccessStringList_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::WTF::String> p_value{};
      IDBCallbacks_SuccessStringList_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCallbacks::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuccessStringList(
std::move(p_value));
      return true;
    }
    case internal::kIDBCallbacks_Blocked_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBCallbacks::Blocked",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBCallbacks::Blocked");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBCallbacks_Blocked_Params_Data* params =
          reinterpret_cast<internal::IDBCallbacks_Blocked_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_existing_version{};
      IDBCallbacks_Blocked_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_existing_version = input_data_view.existing_version();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCallbacks::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Blocked(
std::move(p_existing_version));
      return true;
    }
    case internal::kIDBCallbacks_UpgradeNeeded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBCallbacks::UpgradeNeeded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBCallbacks::UpgradeNeeded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBCallbacks_UpgradeNeeded_Params_Data* params =
          reinterpret_cast<internal::IDBCallbacks_UpgradeNeeded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<IDBDatabase> p_pending_database{};
      int64_t p_old_version{};
      IDBDataLoss p_data_loss{};
      WTF::String p_data_loss_message{};
      ::blink::IDBDatabaseMetadata p_db_metadata{};
      IDBCallbacks_UpgradeNeeded_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_pending_database =
            input_data_view.TakePendingDatabase<decltype(p_pending_database)>();
      }
      if (success)
        p_old_version = input_data_view.old_version();
      if (success && !input_data_view.ReadDataLoss(&p_data_loss))
        success = false;
      if (success && !input_data_view.ReadDataLossMessage(&p_data_loss_message))
        success = false;
      if (success && !input_data_view.ReadDbMetadata(&p_db_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCallbacks::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpgradeNeeded(
std::move(p_pending_database), 
std::move(p_old_version), 
std::move(p_data_loss), 
std::move(p_data_loss_message), 
std::move(p_db_metadata));
      return true;
    }
    case internal::kIDBCallbacks_SuccessDatabase_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBCallbacks::SuccessDatabase",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBCallbacks::SuccessDatabase");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBCallbacks_SuccessDatabase_Params_Data* params =
          reinterpret_cast<internal::IDBCallbacks_SuccessDatabase_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<IDBDatabase> p_pending_database{};
      ::blink::IDBDatabaseMetadata p_metadata{};
      IDBCallbacks_SuccessDatabase_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_pending_database =
            input_data_view.TakePendingDatabase<decltype(p_pending_database)>();
      }
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCallbacks::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuccessDatabase(
std::move(p_pending_database), 
std::move(p_metadata));
      return true;
    }
    case internal::kIDBCallbacks_SuccessInteger_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBCallbacks::SuccessInteger",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBCallbacks::SuccessInteger");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBCallbacks_SuccessInteger_Params_Data* params =
          reinterpret_cast<internal::IDBCallbacks_SuccessInteger_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_value{};
      IDBCallbacks_SuccessInteger_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCallbacks::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuccessInteger(
std::move(p_value));
      return true;
    }
    case internal::kIDBCallbacks_Success_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBCallbacks::Success",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBCallbacks::Success");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBCallbacks_Success_Params_Data* params =
          reinterpret_cast<internal::IDBCallbacks_Success_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      IDBCallbacks_Success_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCallbacks::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Success();
      return true;
    }
  }
  return false;
}

// static
bool IDBCallbacksStubDispatch::AcceptWithResponder(
    IDBCallbacks* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIDBCallbacks_Error_Name: {
      break;
    }
    case internal::kIDBCallbacks_SuccessNamesAndVersionsList_Name: {
      break;
    }
    case internal::kIDBCallbacks_SuccessStringList_Name: {
      break;
    }
    case internal::kIDBCallbacks_Blocked_Name: {
      break;
    }
    case internal::kIDBCallbacks_UpgradeNeeded_Name: {
      break;
    }
    case internal::kIDBCallbacks_SuccessDatabase_Name: {
      break;
    }
    case internal::kIDBCallbacks_SuccessInteger_Name: {
      break;
    }
    case internal::kIDBCallbacks_Success_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIDBCallbacksValidationInfo[] = {
    {internal::kIDBCallbacks_Error_Name,
     {&internal::IDBCallbacks_Error_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBCallbacks_SuccessNamesAndVersionsList_Name,
     {&internal::IDBCallbacks_SuccessNamesAndVersionsList_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBCallbacks_SuccessStringList_Name,
     {&internal::IDBCallbacks_SuccessStringList_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBCallbacks_Blocked_Name,
     {&internal::IDBCallbacks_Blocked_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBCallbacks_UpgradeNeeded_Name,
     {&internal::IDBCallbacks_UpgradeNeeded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBCallbacks_SuccessDatabase_Name,
     {&internal::IDBCallbacks_SuccessDatabase_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBCallbacks_SuccessInteger_Name,
     {&internal::IDBCallbacks_SuccessInteger_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBCallbacks_Success_Name,
     {&internal::IDBCallbacks_Success_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IDBCallbacksRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::IDBCallbacks::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIDBCallbacksValidationInfo);
}

const char IDBDatabaseCallbacks::Name_[] = "blink.mojom.IDBDatabaseCallbacks";

IDBDatabaseCallbacksProxy::IDBDatabaseCallbacksProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBDatabaseCallbacksProxy::ForcedClose(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::IDBDatabaseCallbacks::ForcedClose");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabaseCallbacks_ForcedClose_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabaseCallbacks_ForcedClose_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseCallbacks::Name_);
  message.set_method_name("ForcedClose");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseCallbacksProxy::VersionChange(
    int64_t in_old_version, int64_t in_new_version) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabaseCallbacks::VersionChange", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("old_version", base::NumberToString(in_old_version));
      raw_value->SetString("new_version", base::NumberToString(in_new_version));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabaseCallbacks_VersionChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabaseCallbacks_VersionChange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->old_version = in_old_version;
  params->new_version = in_new_version;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseCallbacks::Name_);
  message.set_method_name("VersionChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseCallbacksProxy::Abort(
    int64_t in_transaction_id, IDBException in_code, const ::WTF::String& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabaseCallbacks::Abort", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("code", base::trace_event::ValueToString(in_code));
      raw_value->SetString("message", base::trace_event::ValueToString(in_message, "<value of type const ::WTF::String&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabaseCallbacks_Abort_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabaseCallbacks_Abort_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  mojo::internal::Serialize<::blink::mojom::IDBException>(
      in_code, &params->code);
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_message, buffer, &message_writer, &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in IDBDatabaseCallbacks.Abort request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseCallbacks::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseCallbacksProxy::Complete(
    int64_t in_transaction_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabaseCallbacks::Complete", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabaseCallbacks_Complete_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabaseCallbacks_Complete_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseCallbacks::Name_);
  message.set_method_name("Complete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseCallbacksProxy::Changes(
    IDBObserverChangesPtr in_changes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabaseCallbacks::Changes", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_changes.is_null()) {
        raw_value->SetString("changes", "nullptr");
      } else {
        raw_value->BeginDictionary("changes");
        in_changes->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabaseCallbacks_Changes_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabaseCallbacks_Changes_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->changes)::BaseType::BufferWriter
      changes_writer;
  mojo::internal::Serialize<::blink::mojom::IDBObserverChangesDataView>(
      in_changes, buffer, &changes_writer, &serialization_context);
  params->changes.Set(
      changes_writer.is_null() ? nullptr : changes_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->changes.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null changes in IDBDatabaseCallbacks.Changes request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseCallbacks::Name_);
  message.set_method_name("Changes");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool IDBDatabaseCallbacksStubDispatch::Accept(
    IDBDatabaseCallbacks* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kIDBDatabaseCallbacks_ForcedClose_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabaseCallbacks::ForcedClose",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabaseCallbacks::ForcedClose");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabaseCallbacks_ForcedClose_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseCallbacks_ForcedClose_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      IDBDatabaseCallbacks_ForcedClose_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseCallbacks::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForcedClose();
      return true;
    }
    case internal::kIDBDatabaseCallbacks_VersionChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabaseCallbacks::VersionChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabaseCallbacks::VersionChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabaseCallbacks_VersionChange_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseCallbacks_VersionChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_old_version{};
      int64_t p_new_version{};
      IDBDatabaseCallbacks_VersionChange_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_old_version = input_data_view.old_version();
      if (success)
        p_new_version = input_data_view.new_version();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseCallbacks::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VersionChange(
std::move(p_old_version), 
std::move(p_new_version));
      return true;
    }
    case internal::kIDBDatabaseCallbacks_Abort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabaseCallbacks::Abort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabaseCallbacks::Abort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabaseCallbacks_Abort_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseCallbacks_Abort_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      IDBException p_code{};
      ::WTF::String p_message{};
      IDBDatabaseCallbacks_Abort_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success && !input_data_view.ReadCode(&p_code))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseCallbacks::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort(
std::move(p_transaction_id), 
std::move(p_code), 
std::move(p_message));
      return true;
    }
    case internal::kIDBDatabaseCallbacks_Complete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabaseCallbacks::Complete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabaseCallbacks::Complete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabaseCallbacks_Complete_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseCallbacks_Complete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      IDBDatabaseCallbacks_Complete_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseCallbacks::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Complete(
std::move(p_transaction_id));
      return true;
    }
    case internal::kIDBDatabaseCallbacks_Changes_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabaseCallbacks::Changes",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabaseCallbacks::Changes");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabaseCallbacks_Changes_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseCallbacks_Changes_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      IDBObserverChangesPtr p_changes{};
      IDBDatabaseCallbacks_Changes_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadChanges(&p_changes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseCallbacks::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Changes(
std::move(p_changes));
      return true;
    }
  }
  return false;
}

// static
bool IDBDatabaseCallbacksStubDispatch::AcceptWithResponder(
    IDBDatabaseCallbacks* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIDBDatabaseCallbacks_ForcedClose_Name: {
      break;
    }
    case internal::kIDBDatabaseCallbacks_VersionChange_Name: {
      break;
    }
    case internal::kIDBDatabaseCallbacks_Abort_Name: {
      break;
    }
    case internal::kIDBDatabaseCallbacks_Complete_Name: {
      break;
    }
    case internal::kIDBDatabaseCallbacks_Changes_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIDBDatabaseCallbacksValidationInfo[] = {
    {internal::kIDBDatabaseCallbacks_ForcedClose_Name,
     {&internal::IDBDatabaseCallbacks_ForcedClose_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabaseCallbacks_VersionChange_Name,
     {&internal::IDBDatabaseCallbacks_VersionChange_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabaseCallbacks_Abort_Name,
     {&internal::IDBDatabaseCallbacks_Abort_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabaseCallbacks_Complete_Name,
     {&internal::IDBDatabaseCallbacks_Complete_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabaseCallbacks_Changes_Name,
     {&internal::IDBDatabaseCallbacks_Changes_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IDBDatabaseCallbacksRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::IDBDatabaseCallbacks::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIDBDatabaseCallbacksValidationInfo);
}

const char IDBCursor::Name_[] = "blink.mojom.IDBCursor";

class IDBCursor_Advance_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBCursor_Advance_ForwardToCallback(
      IDBCursor::AdvanceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IDBCursor::AdvanceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IDBCursor_Advance_ForwardToCallback);
};

class IDBCursor_CursorContinue_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBCursor_CursorContinue_ForwardToCallback(
      IDBCursor::CursorContinueCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IDBCursor::CursorContinueCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IDBCursor_CursorContinue_ForwardToCallback);
};

class IDBCursor_Prefetch_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBCursor_Prefetch_ForwardToCallback(
      IDBCursor::PrefetchCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IDBCursor::PrefetchCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IDBCursor_Prefetch_ForwardToCallback);
};

IDBCursorProxy::IDBCursorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBCursorProxy::Advance(
    uint32_t in_count, AdvanceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBCursor::Advance", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("count", base::NumberToString(in_count));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCursor_Advance_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCursor_Advance_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->count = in_count;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("Advance");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBCursor_Advance_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IDBCursorProxy::CursorContinue(
    ::std::unique_ptr<::blink::IDBKey> in_key, ::std::unique_ptr<::blink::IDBKey> in_primary_key, CursorContinueCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBCursor::CursorContinue", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("key", base::trace_event::ValueToString(in_key, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
      raw_value->SetString("primary_key", base::trace_event::ValueToString(in_primary_key, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCursor_CursorContinue_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCursor_CursorContinue_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->key)::BufferWriter key_writer;
  key_writer.AllocateInline(buffer, &params->key);
  mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
      in_key, buffer, &key_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in IDBCursor.CursorContinue request");
  typename decltype(params->primary_key)::BufferWriter primary_key_writer;
  primary_key_writer.AllocateInline(buffer, &params->primary_key);
  mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
      in_primary_key, buffer, &primary_key_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->primary_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null primary_key in IDBCursor.CursorContinue request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("CursorContinue");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBCursor_CursorContinue_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IDBCursorProxy::Prefetch(
    int32_t in_count, PrefetchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBCursor::Prefetch", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("count", in_count);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCursor_Prefetch_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCursor_Prefetch_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->count = in_count;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("Prefetch");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBCursor_Prefetch_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IDBCursorProxy::PrefetchReset(
    int32_t in_used_prefetches, int32_t in_unused_prefetches) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBCursor::PrefetchReset", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("used_prefetches", in_used_prefetches);
      raw_value->SetInteger("unused_prefetches", in_unused_prefetches);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCursor_PrefetchReset_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCursor_PrefetchReset_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->used_prefetches = in_used_prefetches;
  params->unused_prefetches = in_unused_prefetches;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("PrefetchReset");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class IDBCursor_Advance_ProxyToResponder {
 public:
  static IDBCursor::AdvanceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IDBCursor_Advance_ProxyToResponder> proxy(
        new IDBCursor_Advance_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IDBCursor_Advance_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBCursor_Advance_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IDBCursor_Advance_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IDBCursor::AdvanceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBCursorResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IDBCursor_Advance_ProxyToResponder);
};

bool IDBCursor_Advance_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::IDBCursor::AdvanceCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IDBCursor_Advance_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBCursor_Advance_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  IDBCursorResultPtr p_result{};
  IDBCursor_Advance_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBCursor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void IDBCursor_Advance_ProxyToResponder::Run(
    IDBCursorResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::IDBCursor::AdvanceCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type IDBCursorResultPtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCursor_Advance_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCursor_Advance_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::blink::mojom::IDBCursorResultDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::IDBCursor::AdvanceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("Advance");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBCursor_CursorContinue_ProxyToResponder {
 public:
  static IDBCursor::CursorContinueCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IDBCursor_CursorContinue_ProxyToResponder> proxy(
        new IDBCursor_CursorContinue_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IDBCursor_CursorContinue_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBCursor_CursorContinue_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IDBCursor_CursorContinue_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IDBCursor::CursorContinueCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBCursorResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IDBCursor_CursorContinue_ProxyToResponder);
};

bool IDBCursor_CursorContinue_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::IDBCursor::CursorContinueCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IDBCursor_CursorContinue_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBCursor_CursorContinue_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  IDBCursorResultPtr p_result{};
  IDBCursor_CursorContinue_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBCursor::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void IDBCursor_CursorContinue_ProxyToResponder::Run(
    IDBCursorResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::IDBCursor::CursorContinueCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type IDBCursorResultPtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCursor_CursorContinue_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCursor_CursorContinue_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::blink::mojom::IDBCursorResultDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::IDBCursor::CursorContinueCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("CursorContinue");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBCursor_Prefetch_ProxyToResponder {
 public:
  static IDBCursor::PrefetchCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IDBCursor_Prefetch_ProxyToResponder> proxy(
        new IDBCursor_Prefetch_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IDBCursor_Prefetch_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBCursor_Prefetch_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IDBCursor_Prefetch_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IDBCursor::PrefetchCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBCursorResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IDBCursor_Prefetch_ProxyToResponder);
};

bool IDBCursor_Prefetch_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::IDBCursor::PrefetchCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IDBCursor_Prefetch_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBCursor_Prefetch_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  IDBCursorResultPtr p_result{};
  IDBCursor_Prefetch_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBCursor::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void IDBCursor_Prefetch_ProxyToResponder::Run(
    IDBCursorResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::IDBCursor::PrefetchCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type IDBCursorResultPtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBCursor_Prefetch_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBCursor_Prefetch_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::blink::mojom::IDBCursorResultDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::IDBCursor::PrefetchCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("Prefetch");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IDBCursorStubDispatch::Accept(
    IDBCursor* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kIDBCursor_Advance_Name: {
      break;
    }
    case internal::kIDBCursor_CursorContinue_Name: {
      break;
    }
    case internal::kIDBCursor_Prefetch_Name: {
      break;
    }
    case internal::kIDBCursor_PrefetchReset_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBCursor::PrefetchReset",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBCursor::PrefetchReset");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBCursor_PrefetchReset_Params_Data* params =
          reinterpret_cast<internal::IDBCursor_PrefetchReset_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_used_prefetches{};
      int32_t p_unused_prefetches{};
      IDBCursor_PrefetchReset_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_used_prefetches = input_data_view.used_prefetches();
      if (success)
        p_unused_prefetches = input_data_view.unused_prefetches();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCursor::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrefetchReset(
std::move(p_used_prefetches), 
std::move(p_unused_prefetches));
      return true;
    }
  }
  return false;
}

// static
bool IDBCursorStubDispatch::AcceptWithResponder(
    IDBCursor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIDBCursor_Advance_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBCursor::Advance",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBCursor::Advance");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IDBCursor_Advance_Params_Data* params =
          reinterpret_cast<
              internal::IDBCursor_Advance_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_count{};
      IDBCursor_Advance_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_count = input_data_view.count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCursor::Name_, 0, false);
        return false;
      }
      IDBCursor::AdvanceCallback callback =
          IDBCursor_Advance_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Advance(
std::move(p_count), std::move(callback));
      return true;
    }
    case internal::kIDBCursor_CursorContinue_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBCursor::CursorContinue",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBCursor::CursorContinue");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IDBCursor_CursorContinue_Params_Data* params =
          reinterpret_cast<
              internal::IDBCursor_CursorContinue_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::std::unique_ptr<::blink::IDBKey> p_key{};
      ::std::unique_ptr<::blink::IDBKey> p_primary_key{};
      IDBCursor_CursorContinue_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadPrimaryKey(&p_primary_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCursor::Name_, 1, false);
        return false;
      }
      IDBCursor::CursorContinueCallback callback =
          IDBCursor_CursorContinue_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CursorContinue(
std::move(p_key), 
std::move(p_primary_key), std::move(callback));
      return true;
    }
    case internal::kIDBCursor_Prefetch_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBCursor::Prefetch",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBCursor::Prefetch");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IDBCursor_Prefetch_Params_Data* params =
          reinterpret_cast<
              internal::IDBCursor_Prefetch_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_count{};
      IDBCursor_Prefetch_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_count = input_data_view.count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCursor::Name_, 2, false);
        return false;
      }
      IDBCursor::PrefetchCallback callback =
          IDBCursor_Prefetch_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Prefetch(
std::move(p_count), std::move(callback));
      return true;
    }
    case internal::kIDBCursor_PrefetchReset_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIDBCursorValidationInfo[] = {
    {internal::kIDBCursor_Advance_Name,
     {&internal::IDBCursor_Advance_Params_Data::Validate,
      &internal::IDBCursor_Advance_ResponseParams_Data::Validate}},
    {internal::kIDBCursor_CursorContinue_Name,
     {&internal::IDBCursor_CursorContinue_Params_Data::Validate,
      &internal::IDBCursor_CursorContinue_ResponseParams_Data::Validate}},
    {internal::kIDBCursor_Prefetch_Name,
     {&internal::IDBCursor_Prefetch_Params_Data::Validate,
      &internal::IDBCursor_Prefetch_ResponseParams_Data::Validate}},
    {internal::kIDBCursor_PrefetchReset_Name,
     {&internal::IDBCursor_PrefetchReset_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IDBCursorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::IDBCursor::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIDBCursorValidationInfo);
}

bool IDBCursorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::IDBCursor::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kIDBCursorValidationInfo);

}
const char IDBTransaction::Name_[] = "blink.mojom.IDBTransaction";

class IDBTransaction_Put_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBTransaction_Put_ForwardToCallback(
      IDBTransaction::PutCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IDBTransaction::PutCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IDBTransaction_Put_ForwardToCallback);
};

class IDBTransaction_PutAll_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBTransaction_PutAll_ForwardToCallback(
      IDBTransaction::PutAllCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IDBTransaction::PutAllCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IDBTransaction_PutAll_ForwardToCallback);
};

IDBTransactionProxy::IDBTransactionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBTransactionProxy::CreateObjectStore(
    int64_t in_object_store_id, const ::WTF::String& in_name, const ::blink::IDBKeyPath& in_key_path, bool in_auto_increment) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBTransaction::CreateObjectStore", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->SetString("name", base::trace_event::ValueToString(in_name, "<value of type const ::WTF::String&>"));
      raw_value->SetString("key_path", base::trace_event::ValueToString(in_key_path, "<value of type const ::blink::IDBKeyPath&>"));
      raw_value->SetBoolean("auto_increment", in_auto_increment);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBTransaction_CreateObjectStore_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBTransaction_CreateObjectStore_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->object_store_id = in_object_store_id;
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in IDBTransaction.CreateObjectStore request");
  typename decltype(params->key_path)::BaseType::BufferWriter
      key_path_writer;
  mojo::internal::Serialize<::blink::mojom::IDBKeyPathDataView>(
      in_key_path, buffer, &key_path_writer, &serialization_context);
  params->key_path.Set(
      key_path_writer.is_null() ? nullptr : key_path_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_path in IDBTransaction.CreateObjectStore request");
  params->auto_increment = in_auto_increment;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("CreateObjectStore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBTransactionProxy::DeleteObjectStore(
    int64_t in_object_store_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBTransaction::DeleteObjectStore", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBTransaction_DeleteObjectStore_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBTransaction_DeleteObjectStore_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->object_store_id = in_object_store_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("DeleteObjectStore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBTransactionProxy::Put(
    int64_t in_object_store_id, ::std::unique_ptr<::blink::IDBValue> in_value, ::std::unique_ptr<::blink::IDBKey> in_key, IDBPutMode in_mode, WTF::Vector<::blink::IDBIndexKeys> in_index_keys, PutCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBTransaction::Put", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->SetString("value", base::trace_event::ValueToString(in_value, "<value of type ::std::unique_ptr<::blink::IDBValue>>"));
      raw_value->SetString("key", base::trace_event::ValueToString(in_key, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
      raw_value->SetString("mode", base::trace_event::ValueToString(in_mode));
      raw_value->BeginArray("index_keys");
      for (const auto& item0 : in_index_keys) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::blink::IDBIndexKeys>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBTransaction_Put_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBTransaction_Put_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->object_store_id = in_object_store_id;
  typename decltype(params->value)::BaseType::BufferWriter
      value_writer;
  mojo::internal::Serialize<::blink::mojom::IDBValueDataView>(
      in_value, buffer, &value_writer, &serialization_context);
  params->value.Set(
      value_writer.is_null() ? nullptr : value_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in IDBTransaction.Put request");
  typename decltype(params->key)::BufferWriter key_writer;
  key_writer.AllocateInline(buffer, &params->key);
  mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
      in_key, buffer, &key_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in IDBTransaction.Put request");
  mojo::internal::Serialize<::blink::mojom::IDBPutMode>(
      in_mode, &params->mode);
  typename decltype(params->index_keys)::BaseType::BufferWriter
      index_keys_writer;
  const mojo::internal::ContainerValidateParams index_keys_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBIndexKeysDataView>>(
      in_index_keys, buffer, &index_keys_writer, &index_keys_validate_params,
      &serialization_context);
  params->index_keys.Set(
      index_keys_writer.is_null() ? nullptr : index_keys_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->index_keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null index_keys in IDBTransaction.Put request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("Put");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBTransaction_Put_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IDBTransactionProxy::PutAll(
    int64_t in_object_store_id, WTF::Vector<IDBPutParamsPtr> in_put_params, PutAllCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBTransaction::PutAll", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->BeginArray("put_params");
      for (const auto& item0 : in_put_params) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBTransaction_PutAll_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBTransaction_PutAll_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->object_store_id = in_object_store_id;
  typename decltype(params->put_params)::BaseType::BufferWriter
      put_params_writer;
  const mojo::internal::ContainerValidateParams put_params_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBPutParamsDataView>>(
      in_put_params, buffer, &put_params_writer, &put_params_validate_params,
      &serialization_context);
  params->put_params.Set(
      put_params_writer.is_null() ? nullptr : put_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->put_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null put_params in IDBTransaction.PutAll request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("PutAll");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBTransaction_PutAll_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IDBTransactionProxy::Commit(
    int64_t in_num_errors_handled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBTransaction::Commit", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("num_errors_handled", base::NumberToString(in_num_errors_handled));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBTransaction_Commit_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBTransaction_Commit_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->num_errors_handled = in_num_errors_handled;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("Commit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class IDBTransaction_Put_ProxyToResponder {
 public:
  static IDBTransaction::PutCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IDBTransaction_Put_ProxyToResponder> proxy(
        new IDBTransaction_Put_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IDBTransaction_Put_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBTransaction_Put_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IDBTransaction_Put_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IDBTransaction::PutCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBTransactionPutResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IDBTransaction_Put_ProxyToResponder);
};

bool IDBTransaction_Put_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::IDBTransaction::PutCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IDBTransaction_Put_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBTransaction_Put_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  IDBTransactionPutResultPtr p_result{};
  IDBTransaction_Put_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBTransaction::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void IDBTransaction_Put_ProxyToResponder::Run(
    IDBTransactionPutResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::IDBTransaction::PutCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type IDBTransactionPutResultPtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBTransaction_Put_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBTransaction_Put_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::blink::mojom::IDBTransactionPutResultDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::IDBTransaction::PutCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("Put");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBTransaction_PutAll_ProxyToResponder {
 public:
  static IDBTransaction::PutAllCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IDBTransaction_PutAll_ProxyToResponder> proxy(
        new IDBTransaction_PutAll_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IDBTransaction_PutAll_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBTransaction_PutAll_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IDBTransaction_PutAll_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IDBTransaction::PutAllCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBTransactionPutAllResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IDBTransaction_PutAll_ProxyToResponder);
};

bool IDBTransaction_PutAll_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::IDBTransaction::PutAllCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IDBTransaction_PutAll_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBTransaction_PutAll_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  IDBTransactionPutAllResultPtr p_result{};
  IDBTransaction_PutAll_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBTransaction::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void IDBTransaction_PutAll_ProxyToResponder::Run(
    IDBTransactionPutAllResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::IDBTransaction::PutAllCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type IDBTransactionPutAllResultPtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBTransaction_PutAll_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBTransaction_PutAll_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::blink::mojom::IDBTransactionPutAllResultDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::IDBTransaction::PutAllCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("PutAll");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IDBTransactionStubDispatch::Accept(
    IDBTransaction* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kIDBTransaction_CreateObjectStore_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBTransaction::CreateObjectStore",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBTransaction::CreateObjectStore");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBTransaction_CreateObjectStore_Params_Data* params =
          reinterpret_cast<internal::IDBTransaction_CreateObjectStore_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_object_store_id{};
      ::WTF::String p_name{};
      ::blink::IDBKeyPath p_key_path{};
      bool p_auto_increment{};
      IDBTransaction_CreateObjectStore_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadKeyPath(&p_key_path))
        success = false;
      if (success)
        p_auto_increment = input_data_view.auto_increment();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBTransaction::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateObjectStore(
std::move(p_object_store_id), 
std::move(p_name), 
std::move(p_key_path), 
std::move(p_auto_increment));
      return true;
    }
    case internal::kIDBTransaction_DeleteObjectStore_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBTransaction::DeleteObjectStore",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBTransaction::DeleteObjectStore");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBTransaction_DeleteObjectStore_Params_Data* params =
          reinterpret_cast<internal::IDBTransaction_DeleteObjectStore_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_object_store_id{};
      IDBTransaction_DeleteObjectStore_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBTransaction::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteObjectStore(
std::move(p_object_store_id));
      return true;
    }
    case internal::kIDBTransaction_Put_Name: {
      break;
    }
    case internal::kIDBTransaction_PutAll_Name: {
      break;
    }
    case internal::kIDBTransaction_Commit_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBTransaction::Commit",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBTransaction::Commit");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBTransaction_Commit_Params_Data* params =
          reinterpret_cast<internal::IDBTransaction_Commit_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_num_errors_handled{};
      IDBTransaction_Commit_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_num_errors_handled = input_data_view.num_errors_handled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBTransaction::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Commit(
std::move(p_num_errors_handled));
      return true;
    }
  }
  return false;
}

// static
bool IDBTransactionStubDispatch::AcceptWithResponder(
    IDBTransaction* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIDBTransaction_CreateObjectStore_Name: {
      break;
    }
    case internal::kIDBTransaction_DeleteObjectStore_Name: {
      break;
    }
    case internal::kIDBTransaction_Put_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBTransaction::Put",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBTransaction::Put");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IDBTransaction_Put_Params_Data* params =
          reinterpret_cast<
              internal::IDBTransaction_Put_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_object_store_id{};
      ::std::unique_ptr<::blink::IDBValue> p_value{};
      ::std::unique_ptr<::blink::IDBKey> p_key{};
      IDBPutMode p_mode{};
      WTF::Vector<::blink::IDBIndexKeys> p_index_keys{};
      IDBTransaction_Put_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (success && !input_data_view.ReadIndexKeys(&p_index_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBTransaction::Name_, 2, false);
        return false;
      }
      IDBTransaction::PutCallback callback =
          IDBTransaction_Put_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Put(
std::move(p_object_store_id), 
std::move(p_value), 
std::move(p_key), 
std::move(p_mode), 
std::move(p_index_keys), std::move(callback));
      return true;
    }
    case internal::kIDBTransaction_PutAll_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBTransaction::PutAll",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBTransaction::PutAll");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IDBTransaction_PutAll_Params_Data* params =
          reinterpret_cast<
              internal::IDBTransaction_PutAll_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_object_store_id{};
      WTF::Vector<IDBPutParamsPtr> p_put_params{};
      IDBTransaction_PutAll_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success && !input_data_view.ReadPutParams(&p_put_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBTransaction::Name_, 3, false);
        return false;
      }
      IDBTransaction::PutAllCallback callback =
          IDBTransaction_PutAll_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PutAll(
std::move(p_object_store_id), 
std::move(p_put_params), std::move(callback));
      return true;
    }
    case internal::kIDBTransaction_Commit_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIDBTransactionValidationInfo[] = {
    {internal::kIDBTransaction_CreateObjectStore_Name,
     {&internal::IDBTransaction_CreateObjectStore_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBTransaction_DeleteObjectStore_Name,
     {&internal::IDBTransaction_DeleteObjectStore_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBTransaction_Put_Name,
     {&internal::IDBTransaction_Put_Params_Data::Validate,
      &internal::IDBTransaction_Put_ResponseParams_Data::Validate}},
    {internal::kIDBTransaction_PutAll_Name,
     {&internal::IDBTransaction_PutAll_Params_Data::Validate,
      &internal::IDBTransaction_PutAll_ResponseParams_Data::Validate}},
    {internal::kIDBTransaction_Commit_Name,
     {&internal::IDBTransaction_Commit_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IDBTransactionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::IDBTransaction::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIDBTransactionValidationInfo);
}

bool IDBTransactionResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::IDBTransaction::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kIDBTransactionValidationInfo);

}
const char IDBDatabaseGetAllResultSink::Name_[] = "blink.mojom.IDBDatabaseGetAllResultSink";

IDBDatabaseGetAllResultSinkProxy::IDBDatabaseGetAllResultSinkProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBDatabaseGetAllResultSinkProxy::ReceiveValues(
    WTF::Vector<IDBReturnValuePtr> in_values) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabaseGetAllResultSink::ReceiveValues", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("values");
      for (const auto& item0 : in_values) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabaseGetAllResultSink_ReceiveValues_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabaseGetAllResultSink_ReceiveValues_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->values)::BaseType::BufferWriter
      values_writer;
  const mojo::internal::ContainerValidateParams values_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBReturnValueDataView>>(
      in_values, buffer, &values_writer, &values_validate_params,
      &serialization_context);
  params->values.Set(
      values_writer.is_null() ? nullptr : values_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->values.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null values in IDBDatabaseGetAllResultSink.ReceiveValues request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseGetAllResultSink::Name_);
  message.set_method_name("ReceiveValues");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseGetAllResultSinkProxy::ReceiveKeys(
    WTF::Vector<::std::unique_ptr<::blink::IDBKey>> in_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabaseGetAllResultSink::ReceiveKeys", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("keys");
      for (const auto& item0 : in_keys) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabaseGetAllResultSink_ReceiveKeys_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabaseGetAllResultSink_ReceiveKeys_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->keys)::BaseType::BufferWriter
      keys_writer;
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBKeyDataView>>(
      in_keys, buffer, &keys_writer, &keys_validate_params,
      &serialization_context);
  params->keys.Set(
      keys_writer.is_null() ? nullptr : keys_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keys in IDBDatabaseGetAllResultSink.ReceiveKeys request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseGetAllResultSink::Name_);
  message.set_method_name("ReceiveKeys");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseGetAllResultSinkProxy::OnError(
    IDBErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabaseGetAllResultSink::OnError", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_error.is_null()) {
        raw_value->SetString("error", "nullptr");
      } else {
        raw_value->BeginDictionary("error");
        in_error->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabaseGetAllResultSink_OnError_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabaseGetAllResultSink_OnError_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->error)::BaseType::BufferWriter
      error_writer;
  mojo::internal::Serialize<::blink::mojom::IDBErrorDataView>(
      in_error, buffer, &error_writer, &serialization_context);
  params->error.Set(
      error_writer.is_null() ? nullptr : error_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in IDBDatabaseGetAllResultSink.OnError request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseGetAllResultSink::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool IDBDatabaseGetAllResultSinkStubDispatch::Accept(
    IDBDatabaseGetAllResultSink* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kIDBDatabaseGetAllResultSink_ReceiveValues_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabaseGetAllResultSink::ReceiveValues",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabaseGetAllResultSink::ReceiveValues");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabaseGetAllResultSink_ReceiveValues_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseGetAllResultSink_ReceiveValues_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<IDBReturnValuePtr> p_values{};
      IDBDatabaseGetAllResultSink_ReceiveValues_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadValues(&p_values))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseGetAllResultSink::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReceiveValues(
std::move(p_values));
      return true;
    }
    case internal::kIDBDatabaseGetAllResultSink_ReceiveKeys_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabaseGetAllResultSink::ReceiveKeys",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabaseGetAllResultSink::ReceiveKeys");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabaseGetAllResultSink_ReceiveKeys_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseGetAllResultSink_ReceiveKeys_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::std::unique_ptr<::blink::IDBKey>> p_keys{};
      IDBDatabaseGetAllResultSink_ReceiveKeys_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadKeys(&p_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseGetAllResultSink::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReceiveKeys(
std::move(p_keys));
      return true;
    }
    case internal::kIDBDatabaseGetAllResultSink_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabaseGetAllResultSink::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabaseGetAllResultSink::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabaseGetAllResultSink_OnError_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseGetAllResultSink_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      IDBErrorPtr p_error{};
      IDBDatabaseGetAllResultSink_OnError_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseGetAllResultSink::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_error));
      return true;
    }
  }
  return false;
}

// static
bool IDBDatabaseGetAllResultSinkStubDispatch::AcceptWithResponder(
    IDBDatabaseGetAllResultSink* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIDBDatabaseGetAllResultSink_ReceiveValues_Name: {
      break;
    }
    case internal::kIDBDatabaseGetAllResultSink_ReceiveKeys_Name: {
      break;
    }
    case internal::kIDBDatabaseGetAllResultSink_OnError_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIDBDatabaseGetAllResultSinkValidationInfo[] = {
    {internal::kIDBDatabaseGetAllResultSink_ReceiveValues_Name,
     {&internal::IDBDatabaseGetAllResultSink_ReceiveValues_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabaseGetAllResultSink_ReceiveKeys_Name,
     {&internal::IDBDatabaseGetAllResultSink_ReceiveKeys_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabaseGetAllResultSink_OnError_Name,
     {&internal::IDBDatabaseGetAllResultSink_OnError_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IDBDatabaseGetAllResultSinkRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::IDBDatabaseGetAllResultSink::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIDBDatabaseGetAllResultSinkValidationInfo);
}

const char IDBDatabase::Name_[] = "blink.mojom.IDBDatabase";

class IDBDatabase_Get_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBDatabase_Get_ForwardToCallback(
      IDBDatabase::GetCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IDBDatabase::GetCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IDBDatabase_Get_ForwardToCallback);
};

class IDBDatabase_GetAll_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBDatabase_GetAll_ForwardToCallback(
      IDBDatabase::GetAllCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IDBDatabase::GetAllCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IDBDatabase_GetAll_ForwardToCallback);
};

class IDBDatabase_OpenCursor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBDatabase_OpenCursor_ForwardToCallback(
      IDBDatabase::OpenCursorCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IDBDatabase::OpenCursorCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IDBDatabase_OpenCursor_ForwardToCallback);
};

IDBDatabaseProxy::IDBDatabaseProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBDatabaseProxy::RenameObjectStore(
    int64_t in_transaction_id, int64_t in_object_store_id, const ::WTF::String& in_new_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::RenameObjectStore", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->SetString("new_name", base::trace_event::ValueToString(in_new_name, "<value of type const ::WTF::String&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_RenameObjectStore_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_RenameObjectStore_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->object_store_id = in_object_store_id;
  typename decltype(params->new_name)::BaseType::BufferWriter
      new_name_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_new_name, buffer, &new_name_writer, &serialization_context);
  params->new_name.Set(
      new_name_writer.is_null() ? nullptr : new_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_name in IDBDatabase.RenameObjectStore request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("RenameObjectStore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::CreateTransaction(
    ::mojo::PendingAssociatedReceiver<IDBTransaction> in_transaction_receiver, int64_t in_transaction_id, const WTF::Vector<int64_t>& in_object_store_ids, IDBTransactionMode in_mode, IDBTransactionDurability in_durability) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::CreateTransaction", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("transaction_receiver", in_transaction_receiver.is_valid());
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->BeginArray("object_store_ids");
      for (const auto& item0 : in_object_store_ids) {
        raw_value->AppendString(base::NumberToString(item0));
      }
      raw_value->EndArray();
      raw_value->SetString("mode", base::trace_event::ValueToString(in_mode));
      raw_value->SetString("durability", base::trace_event::ValueToString(in_durability));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_CreateTransaction_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_CreateTransaction_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::IDBTransactionAssociatedRequestDataView>(
      in_transaction_receiver, &params->transaction_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->transaction_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid transaction_receiver in IDBDatabase.CreateTransaction request");
  params->transaction_id = in_transaction_id;
  typename decltype(params->object_store_ids)::BaseType::BufferWriter
      object_store_ids_writer;
  const mojo::internal::ContainerValidateParams object_store_ids_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
      in_object_store_ids, buffer, &object_store_ids_writer, &object_store_ids_validate_params,
      &serialization_context);
  params->object_store_ids.Set(
      object_store_ids_writer.is_null() ? nullptr : object_store_ids_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->object_store_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null object_store_ids in IDBDatabase.CreateTransaction request");
  mojo::internal::Serialize<::blink::mojom::IDBTransactionMode>(
      in_mode, &params->mode);
  mojo::internal::Serialize<::blink::mojom::IDBTransactionDurability>(
      in_durability, &params->durability);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("CreateTransaction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::Close(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::IDBDatabase::Close");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_Close_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_Close_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("Close");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::VersionChangeIgnored(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::IDBDatabase::VersionChangeIgnored");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_VersionChangeIgnored_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_VersionChangeIgnored_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("VersionChangeIgnored");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::AddObserver(
    int64_t in_transaction_id, int32_t in_observer_id, bool in_include_transaction, bool in_no_records, bool in_values, uint32_t in_operation_types) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::AddObserver", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetInteger("observer_id", in_observer_id);
      raw_value->SetBoolean("include_transaction", in_include_transaction);
      raw_value->SetBoolean("no_records", in_no_records);
      raw_value->SetBoolean("values", in_values);
      raw_value->SetString("operation_types", base::NumberToString(in_operation_types));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_AddObserver_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_AddObserver_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->observer_id = in_observer_id;
  params->include_transaction = in_include_transaction;
  params->no_records = in_no_records;
  params->values = in_values;
  params->operation_types = in_operation_types;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::RemoveObservers(
    const WTF::Vector<int32_t>& in_observers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::RemoveObservers", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("observers");
      for (const auto& item0 : in_observers) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_RemoveObservers_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_RemoveObservers_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->observers)::BaseType::BufferWriter
      observers_writer;
  const mojo::internal::ContainerValidateParams observers_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
      in_observers, buffer, &observers_writer, &observers_validate_params,
      &serialization_context);
  params->observers.Set(
      observers_writer.is_null() ? nullptr : observers_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->observers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null observers in IDBDatabase.RemoveObservers request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("RemoveObservers");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::Get(
    int64_t in_transaction_id, int64_t in_object_store_id, int64_t in_index_id, IDBKeyRangePtr in_key_range, bool in_key_only, GetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::Get", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->SetString("index_id", base::NumberToString(in_index_id));
      if (in_key_range.is_null()) {
        raw_value->SetString("key_range", "nullptr");
      } else {
        raw_value->BeginDictionary("key_range");
        in_key_range->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("key_only", in_key_only);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_Get_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_Get_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->object_store_id = in_object_store_id;
  params->index_id = in_index_id;
  typename decltype(params->key_range)::BaseType::BufferWriter
      key_range_writer;
  mojo::internal::Serialize<::blink::mojom::IDBKeyRangeDataView>(
      in_key_range, buffer, &key_range_writer, &serialization_context);
  params->key_range.Set(
      key_range_writer.is_null() ? nullptr : key_range_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_range.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_range in IDBDatabase.Get request");
  params->key_only = in_key_only;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("Get");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBDatabase_Get_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IDBDatabaseProxy::GetAll(
    int64_t in_transaction_id, int64_t in_object_store_id, int64_t in_index_id, IDBKeyRangePtr in_key_range, bool in_key_only, int64_t in_max_count, GetAllCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::GetAll", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->SetString("index_id", base::NumberToString(in_index_id));
      if (in_key_range.is_null()) {
        raw_value->SetString("key_range", "nullptr");
      } else {
        raw_value->BeginDictionary("key_range");
        in_key_range->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("key_only", in_key_only);
      raw_value->SetString("max_count", base::NumberToString(in_max_count));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_GetAll_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_GetAll_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->object_store_id = in_object_store_id;
  params->index_id = in_index_id;
  typename decltype(params->key_range)::BaseType::BufferWriter
      key_range_writer;
  mojo::internal::Serialize<::blink::mojom::IDBKeyRangeDataView>(
      in_key_range, buffer, &key_range_writer, &serialization_context);
  params->key_range.Set(
      key_range_writer.is_null() ? nullptr : key_range_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_range.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_range in IDBDatabase.GetAll request");
  params->key_only = in_key_only;
  params->max_count = in_max_count;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("GetAll");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBDatabase_GetAll_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IDBDatabaseProxy::SetIndexKeys(
    int64_t in_transaction_id, int64_t in_object_store_id, ::std::unique_ptr<::blink::IDBKey> in_primary_key, WTF::Vector<::blink::IDBIndexKeys> in_index_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::SetIndexKeys", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->SetString("primary_key", base::trace_event::ValueToString(in_primary_key, "<value of type ::std::unique_ptr<::blink::IDBKey>>"));
      raw_value->BeginArray("index_keys");
      for (const auto& item0 : in_index_keys) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::blink::IDBIndexKeys>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_SetIndexKeys_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_SetIndexKeys_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->object_store_id = in_object_store_id;
  typename decltype(params->primary_key)::BufferWriter primary_key_writer;
  primary_key_writer.AllocateInline(buffer, &params->primary_key);
  mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
      in_primary_key, buffer, &primary_key_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->primary_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null primary_key in IDBDatabase.SetIndexKeys request");
  typename decltype(params->index_keys)::BaseType::BufferWriter
      index_keys_writer;
  const mojo::internal::ContainerValidateParams index_keys_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBIndexKeysDataView>>(
      in_index_keys, buffer, &index_keys_writer, &index_keys_validate_params,
      &serialization_context);
  params->index_keys.Set(
      index_keys_writer.is_null() ? nullptr : index_keys_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->index_keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null index_keys in IDBDatabase.SetIndexKeys request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("SetIndexKeys");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::SetIndexesReady(
    int64_t in_transaction_id, int64_t in_object_store_id, const WTF::Vector<int64_t>& in_index_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::SetIndexesReady", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->BeginArray("index_ids");
      for (const auto& item0 : in_index_ids) {
        raw_value->AppendString(base::NumberToString(item0));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_SetIndexesReady_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_SetIndexesReady_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->object_store_id = in_object_store_id;
  typename decltype(params->index_ids)::BaseType::BufferWriter
      index_ids_writer;
  const mojo::internal::ContainerValidateParams index_ids_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
      in_index_ids, buffer, &index_ids_writer, &index_ids_validate_params,
      &serialization_context);
  params->index_ids.Set(
      index_ids_writer.is_null() ? nullptr : index_ids_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->index_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null index_ids in IDBDatabase.SetIndexesReady request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("SetIndexesReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::OpenCursor(
    int64_t in_transaction_id, int64_t in_object_store_id, int64_t in_index_id, IDBKeyRangePtr in_key_range, IDBCursorDirection in_direction, bool in_key_only, IDBTaskType in_task_type, OpenCursorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::OpenCursor", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->SetString("index_id", base::NumberToString(in_index_id));
      if (in_key_range.is_null()) {
        raw_value->SetString("key_range", "nullptr");
      } else {
        raw_value->BeginDictionary("key_range");
        in_key_range->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("direction", base::trace_event::ValueToString(in_direction));
      raw_value->SetBoolean("key_only", in_key_only);
      raw_value->SetString("task_type", base::trace_event::ValueToString(in_task_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_OpenCursor_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_OpenCursor_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->object_store_id = in_object_store_id;
  params->index_id = in_index_id;
  typename decltype(params->key_range)::BaseType::BufferWriter
      key_range_writer;
  mojo::internal::Serialize<::blink::mojom::IDBKeyRangeDataView>(
      in_key_range, buffer, &key_range_writer, &serialization_context);
  params->key_range.Set(
      key_range_writer.is_null() ? nullptr : key_range_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_range.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_range in IDBDatabase.OpenCursor request");
  mojo::internal::Serialize<::blink::mojom::IDBCursorDirection>(
      in_direction, &params->direction);
  params->key_only = in_key_only;
  mojo::internal::Serialize<::blink::mojom::IDBTaskType>(
      in_task_type, &params->task_type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("OpenCursor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBDatabase_OpenCursor_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IDBDatabaseProxy::Count(
    int64_t in_transaction_id, int64_t in_object_store_id, int64_t in_index_id, IDBKeyRangePtr in_key_range, ::mojo::PendingAssociatedRemote<IDBCallbacks> in_pending_callbacks) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::Count", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->SetString("index_id", base::NumberToString(in_index_id));
      if (in_key_range.is_null()) {
        raw_value->SetString("key_range", "nullptr");
      } else {
        raw_value->BeginDictionary("key_range");
        in_key_range->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("pending_callbacks", in_pending_callbacks.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_Count_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_Count_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->object_store_id = in_object_store_id;
  params->index_id = in_index_id;
  typename decltype(params->key_range)::BaseType::BufferWriter
      key_range_writer;
  mojo::internal::Serialize<::blink::mojom::IDBKeyRangeDataView>(
      in_key_range, buffer, &key_range_writer, &serialization_context);
  params->key_range.Set(
      key_range_writer.is_null() ? nullptr : key_range_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_range.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_range in IDBDatabase.Count request");
  mojo::internal::Serialize<::blink::mojom::IDBCallbacksAssociatedPtrInfoDataView>(
      in_pending_callbacks, &params->pending_callbacks, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pending_callbacks),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid pending_callbacks in IDBDatabase.Count request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("Count");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::DeleteRange(
    int64_t in_transaction_id, int64_t in_object_store_id, IDBKeyRangePtr in_key_range, ::mojo::PendingAssociatedRemote<IDBCallbacks> in_pending_callbacks) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::DeleteRange", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      if (in_key_range.is_null()) {
        raw_value->SetString("key_range", "nullptr");
      } else {
        raw_value->BeginDictionary("key_range");
        in_key_range->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("pending_callbacks", in_pending_callbacks.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_DeleteRange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_DeleteRange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->object_store_id = in_object_store_id;
  typename decltype(params->key_range)::BaseType::BufferWriter
      key_range_writer;
  mojo::internal::Serialize<::blink::mojom::IDBKeyRangeDataView>(
      in_key_range, buffer, &key_range_writer, &serialization_context);
  params->key_range.Set(
      key_range_writer.is_null() ? nullptr : key_range_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_range.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_range in IDBDatabase.DeleteRange request");
  mojo::internal::Serialize<::blink::mojom::IDBCallbacksAssociatedPtrInfoDataView>(
      in_pending_callbacks, &params->pending_callbacks, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pending_callbacks),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid pending_callbacks in IDBDatabase.DeleteRange request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("DeleteRange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::GetKeyGeneratorCurrentNumber(
    int64_t in_transaction_id, int64_t in_object_store_id, ::mojo::PendingAssociatedRemote<IDBCallbacks> in_pending_callbacks) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::GetKeyGeneratorCurrentNumber", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->SetBoolean("pending_callbacks", in_pending_callbacks.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_GetKeyGeneratorCurrentNumber_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->object_store_id = in_object_store_id;
  mojo::internal::Serialize<::blink::mojom::IDBCallbacksAssociatedPtrInfoDataView>(
      in_pending_callbacks, &params->pending_callbacks, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pending_callbacks),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid pending_callbacks in IDBDatabase.GetKeyGeneratorCurrentNumber request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("GetKeyGeneratorCurrentNumber");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::Clear(
    int64_t in_transaction_id, int64_t in_object_store_id, ::mojo::PendingAssociatedRemote<IDBCallbacks> in_pending_callbacks) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::Clear", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->SetBoolean("pending_callbacks", in_pending_callbacks.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_Clear_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_Clear_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->object_store_id = in_object_store_id;
  mojo::internal::Serialize<::blink::mojom::IDBCallbacksAssociatedPtrInfoDataView>(
      in_pending_callbacks, &params->pending_callbacks, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pending_callbacks),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid pending_callbacks in IDBDatabase.Clear request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("Clear");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::CreateIndex(
    int64_t in_transaction_id, int64_t in_object_store_id, int64_t in_index_id, const ::WTF::String& in_name, const ::blink::IDBKeyPath& in_key_path, bool in_unique, bool in_multi_entry) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::CreateIndex", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->SetString("index_id", base::NumberToString(in_index_id));
      raw_value->SetString("name", base::trace_event::ValueToString(in_name, "<value of type const ::WTF::String&>"));
      raw_value->SetString("key_path", base::trace_event::ValueToString(in_key_path, "<value of type const ::blink::IDBKeyPath&>"));
      raw_value->SetBoolean("unique", in_unique);
      raw_value->SetBoolean("multi_entry", in_multi_entry);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_CreateIndex_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_CreateIndex_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->object_store_id = in_object_store_id;
  params->index_id = in_index_id;
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in IDBDatabase.CreateIndex request");
  typename decltype(params->key_path)::BaseType::BufferWriter
      key_path_writer;
  mojo::internal::Serialize<::blink::mojom::IDBKeyPathDataView>(
      in_key_path, buffer, &key_path_writer, &serialization_context);
  params->key_path.Set(
      key_path_writer.is_null() ? nullptr : key_path_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_path in IDBDatabase.CreateIndex request");
  params->unique = in_unique;
  params->multi_entry = in_multi_entry;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("CreateIndex");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::DeleteIndex(
    int64_t in_transaction_id, int64_t in_object_store_id, int64_t in_index_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::DeleteIndex", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->SetString("index_id", base::NumberToString(in_index_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_DeleteIndex_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_DeleteIndex_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->object_store_id = in_object_store_id;
  params->index_id = in_index_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("DeleteIndex");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::RenameIndex(
    int64_t in_transaction_id, int64_t in_object_store_id, int64_t in_index_id, const ::WTF::String& in_new_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::RenameIndex", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      raw_value->SetString("object_store_id", base::NumberToString(in_object_store_id));
      raw_value->SetString("index_id", base::NumberToString(in_index_id));
      raw_value->SetString("new_name", base::trace_event::ValueToString(in_new_name, "<value of type const ::WTF::String&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_RenameIndex_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_RenameIndex_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  params->object_store_id = in_object_store_id;
  params->index_id = in_index_id;
  typename decltype(params->new_name)::BaseType::BufferWriter
      new_name_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_new_name, buffer, &new_name_writer, &serialization_context);
  params->new_name.Set(
      new_name_writer.is_null() ? nullptr : new_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_name in IDBDatabase.RenameIndex request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("RenameIndex");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBDatabaseProxy::Abort(
    int64_t in_transaction_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBDatabase::Abort", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_Abort_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_Abort_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transaction_id = in_transaction_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class IDBDatabase_Get_ProxyToResponder {
 public:
  static IDBDatabase::GetCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IDBDatabase_Get_ProxyToResponder> proxy(
        new IDBDatabase_Get_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IDBDatabase_Get_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBDatabase_Get_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IDBDatabase_Get_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IDBDatabase::GetCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBDatabaseGetResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IDBDatabase_Get_ProxyToResponder);
};

bool IDBDatabase_Get_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::IDBDatabase::GetCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IDBDatabase_Get_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBDatabase_Get_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  IDBDatabaseGetResultPtr p_result{};
  IDBDatabase_Get_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBDatabase::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void IDBDatabase_Get_ProxyToResponder::Run(
    IDBDatabaseGetResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::IDBDatabase::GetCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type IDBDatabaseGetResultPtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_Get_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_Get_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseGetResultDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::IDBDatabase::GetCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("Get");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBDatabase_GetAll_ProxyToResponder {
 public:
  static IDBDatabase::GetAllCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IDBDatabase_GetAll_ProxyToResponder> proxy(
        new IDBDatabase_GetAll_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IDBDatabase_GetAll_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBDatabase_GetAll_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IDBDatabase_GetAll_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IDBDatabase::GetAllCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingReceiver<IDBDatabaseGetAllResultSink> in_receiver);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IDBDatabase_GetAll_ProxyToResponder);
};

bool IDBDatabase_GetAll_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::IDBDatabase::GetAllCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IDBDatabase_GetAll_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBDatabase_GetAll_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::mojo::PendingReceiver<IDBDatabaseGetAllResultSink> p_receiver{};
  IDBDatabase_GetAll_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success) {
    p_receiver =
        input_data_view.TakeReceiver<decltype(p_receiver)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBDatabase::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_receiver));
  return true;
}

void IDBDatabase_GetAll_ProxyToResponder::Run(
    ::mojo::PendingReceiver<IDBDatabaseGetAllResultSink> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::IDBDatabase::GetAllCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_GetAll_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_GetAll_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::IDBDatabaseGetAllResultSinkInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::IDBDatabase::GetAllCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("GetAll");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBDatabase_OpenCursor_ProxyToResponder {
 public:
  static IDBDatabase::OpenCursorCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IDBDatabase_OpenCursor_ProxyToResponder> proxy(
        new IDBDatabase_OpenCursor_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IDBDatabase_OpenCursor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBDatabase_OpenCursor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IDBDatabase_OpenCursor_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IDBDatabase::OpenCursorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBDatabaseOpenCursorResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IDBDatabase_OpenCursor_ProxyToResponder);
};

bool IDBDatabase_OpenCursor_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::IDBDatabase::OpenCursorCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IDBDatabase_OpenCursor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBDatabase_OpenCursor_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  IDBDatabaseOpenCursorResultPtr p_result{};
  IDBDatabase_OpenCursor_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBDatabase::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void IDBDatabase_OpenCursor_ProxyToResponder::Run(
    IDBDatabaseOpenCursorResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::IDBDatabase::OpenCursorCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type IDBDatabaseOpenCursorResultPtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBDatabase_OpenCursor_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBDatabase_OpenCursor_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseOpenCursorResultDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::IDBDatabase::OpenCursorCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("OpenCursor");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IDBDatabaseStubDispatch::Accept(
    IDBDatabase* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kIDBDatabase_RenameObjectStore_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::RenameObjectStore",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::RenameObjectStore");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_RenameObjectStore_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_RenameObjectStore_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      ::WTF::String p_new_name{};
      IDBDatabase_RenameObjectStore_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success && !input_data_view.ReadNewName(&p_new_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenameObjectStore(
std::move(p_transaction_id), 
std::move(p_object_store_id), 
std::move(p_new_name));
      return true;
    }
    case internal::kIDBDatabase_CreateTransaction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::CreateTransaction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::CreateTransaction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_CreateTransaction_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_CreateTransaction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedReceiver<IDBTransaction> p_transaction_receiver{};
      int64_t p_transaction_id{};
      WTF::Vector<int64_t> p_object_store_ids{};
      IDBTransactionMode p_mode{};
      IDBTransactionDurability p_durability{};
      IDBDatabase_CreateTransaction_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_transaction_receiver =
            input_data_view.TakeTransactionReceiver<decltype(p_transaction_receiver)>();
      }
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success && !input_data_view.ReadObjectStoreIds(&p_object_store_ids))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (success && !input_data_view.ReadDurability(&p_durability))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTransaction(
std::move(p_transaction_receiver), 
std::move(p_transaction_id), 
std::move(p_object_store_ids), 
std::move(p_mode), 
std::move(p_durability));
      return true;
    }
    case internal::kIDBDatabase_Close_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::Close",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::Close");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_Close_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_Close_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      IDBDatabase_Close_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close();
      return true;
    }
    case internal::kIDBDatabase_VersionChangeIgnored_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::VersionChangeIgnored",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::VersionChangeIgnored");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_VersionChangeIgnored_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_VersionChangeIgnored_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      IDBDatabase_VersionChangeIgnored_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VersionChangeIgnored();
      return true;
    }
    case internal::kIDBDatabase_AddObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::AddObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::AddObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_AddObserver_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_AddObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int32_t p_observer_id{};
      bool p_include_transaction{};
      bool p_no_records{};
      bool p_values{};
      uint32_t p_operation_types{};
      IDBDatabase_AddObserver_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_observer_id = input_data_view.observer_id();
      if (success)
        p_include_transaction = input_data_view.include_transaction();
      if (success)
        p_no_records = input_data_view.no_records();
      if (success)
        p_values = input_data_view.values();
      if (success)
        p_operation_types = input_data_view.operation_types();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(
std::move(p_transaction_id), 
std::move(p_observer_id), 
std::move(p_include_transaction), 
std::move(p_no_records), 
std::move(p_values), 
std::move(p_operation_types));
      return true;
    }
    case internal::kIDBDatabase_RemoveObservers_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::RemoveObservers",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::RemoveObservers");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_RemoveObservers_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_RemoveObservers_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<int32_t> p_observers{};
      IDBDatabase_RemoveObservers_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadObservers(&p_observers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveObservers(
std::move(p_observers));
      return true;
    }
    case internal::kIDBDatabase_Get_Name: {
      break;
    }
    case internal::kIDBDatabase_GetAll_Name: {
      break;
    }
    case internal::kIDBDatabase_SetIndexKeys_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::SetIndexKeys",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::SetIndexKeys");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_SetIndexKeys_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_SetIndexKeys_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      ::std::unique_ptr<::blink::IDBKey> p_primary_key{};
      WTF::Vector<::blink::IDBIndexKeys> p_index_keys{};
      IDBDatabase_SetIndexKeys_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success && !input_data_view.ReadPrimaryKey(&p_primary_key))
        success = false;
      if (success && !input_data_view.ReadIndexKeys(&p_index_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIndexKeys(
std::move(p_transaction_id), 
std::move(p_object_store_id), 
std::move(p_primary_key), 
std::move(p_index_keys));
      return true;
    }
    case internal::kIDBDatabase_SetIndexesReady_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::SetIndexesReady",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::SetIndexesReady");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_SetIndexesReady_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_SetIndexesReady_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      WTF::Vector<int64_t> p_index_ids{};
      IDBDatabase_SetIndexesReady_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success && !input_data_view.ReadIndexIds(&p_index_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIndexesReady(
std::move(p_transaction_id), 
std::move(p_object_store_id), 
std::move(p_index_ids));
      return true;
    }
    case internal::kIDBDatabase_OpenCursor_Name: {
      break;
    }
    case internal::kIDBDatabase_Count_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::Count",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::Count");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_Count_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_Count_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      int64_t p_index_id{};
      IDBKeyRangePtr p_key_range{};
      ::mojo::PendingAssociatedRemote<IDBCallbacks> p_pending_callbacks{};
      IDBDatabase_Count_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success)
        p_index_id = input_data_view.index_id();
      if (success && !input_data_view.ReadKeyRange(&p_key_range))
        success = false;
      if (success) {
        p_pending_callbacks =
            input_data_view.TakePendingCallbacks<decltype(p_pending_callbacks)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Count(
std::move(p_transaction_id), 
std::move(p_object_store_id), 
std::move(p_index_id), 
std::move(p_key_range), 
std::move(p_pending_callbacks));
      return true;
    }
    case internal::kIDBDatabase_DeleteRange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::DeleteRange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::DeleteRange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_DeleteRange_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_DeleteRange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      IDBKeyRangePtr p_key_range{};
      ::mojo::PendingAssociatedRemote<IDBCallbacks> p_pending_callbacks{};
      IDBDatabase_DeleteRange_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success && !input_data_view.ReadKeyRange(&p_key_range))
        success = false;
      if (success) {
        p_pending_callbacks =
            input_data_view.TakePendingCallbacks<decltype(p_pending_callbacks)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteRange(
std::move(p_transaction_id), 
std::move(p_object_store_id), 
std::move(p_key_range), 
std::move(p_pending_callbacks));
      return true;
    }
    case internal::kIDBDatabase_GetKeyGeneratorCurrentNumber_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::GetKeyGeneratorCurrentNumber",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::GetKeyGeneratorCurrentNumber");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      ::mojo::PendingAssociatedRemote<IDBCallbacks> p_pending_callbacks{};
      IDBDatabase_GetKeyGeneratorCurrentNumber_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success) {
        p_pending_callbacks =
            input_data_view.TakePendingCallbacks<decltype(p_pending_callbacks)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetKeyGeneratorCurrentNumber(
std::move(p_transaction_id), 
std::move(p_object_store_id), 
std::move(p_pending_callbacks));
      return true;
    }
    case internal::kIDBDatabase_Clear_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::Clear",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::Clear");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_Clear_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_Clear_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      ::mojo::PendingAssociatedRemote<IDBCallbacks> p_pending_callbacks{};
      IDBDatabase_Clear_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success) {
        p_pending_callbacks =
            input_data_view.TakePendingCallbacks<decltype(p_pending_callbacks)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clear(
std::move(p_transaction_id), 
std::move(p_object_store_id), 
std::move(p_pending_callbacks));
      return true;
    }
    case internal::kIDBDatabase_CreateIndex_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::CreateIndex",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::CreateIndex");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_CreateIndex_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_CreateIndex_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      int64_t p_index_id{};
      ::WTF::String p_name{};
      ::blink::IDBKeyPath p_key_path{};
      bool p_unique{};
      bool p_multi_entry{};
      IDBDatabase_CreateIndex_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success)
        p_index_id = input_data_view.index_id();
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadKeyPath(&p_key_path))
        success = false;
      if (success)
        p_unique = input_data_view.unique();
      if (success)
        p_multi_entry = input_data_view.multi_entry();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateIndex(
std::move(p_transaction_id), 
std::move(p_object_store_id), 
std::move(p_index_id), 
std::move(p_name), 
std::move(p_key_path), 
std::move(p_unique), 
std::move(p_multi_entry));
      return true;
    }
    case internal::kIDBDatabase_DeleteIndex_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::DeleteIndex",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::DeleteIndex");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_DeleteIndex_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_DeleteIndex_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      int64_t p_index_id{};
      IDBDatabase_DeleteIndex_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success)
        p_index_id = input_data_view.index_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteIndex(
std::move(p_transaction_id), 
std::move(p_object_store_id), 
std::move(p_index_id));
      return true;
    }
    case internal::kIDBDatabase_RenameIndex_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::RenameIndex",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::RenameIndex");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_RenameIndex_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_RenameIndex_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      int64_t p_index_id{};
      ::WTF::String p_new_name{};
      IDBDatabase_RenameIndex_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success)
        p_index_id = input_data_view.index_id();
      if (success && !input_data_view.ReadNewName(&p_new_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenameIndex(
std::move(p_transaction_id), 
std::move(p_object_store_id), 
std::move(p_index_id), 
std::move(p_new_name));
      return true;
    }
    case internal::kIDBDatabase_Abort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::Abort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::Abort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBDatabase_Abort_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_Abort_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      IDBDatabase_Abort_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort(
std::move(p_transaction_id));
      return true;
    }
  }
  return false;
}

// static
bool IDBDatabaseStubDispatch::AcceptWithResponder(
    IDBDatabase* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIDBDatabase_RenameObjectStore_Name: {
      break;
    }
    case internal::kIDBDatabase_CreateTransaction_Name: {
      break;
    }
    case internal::kIDBDatabase_Close_Name: {
      break;
    }
    case internal::kIDBDatabase_VersionChangeIgnored_Name: {
      break;
    }
    case internal::kIDBDatabase_AddObserver_Name: {
      break;
    }
    case internal::kIDBDatabase_RemoveObservers_Name: {
      break;
    }
    case internal::kIDBDatabase_Get_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::Get",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::Get");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IDBDatabase_Get_Params_Data* params =
          reinterpret_cast<
              internal::IDBDatabase_Get_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      int64_t p_index_id{};
      IDBKeyRangePtr p_key_range{};
      bool p_key_only{};
      IDBDatabase_Get_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success)
        p_index_id = input_data_view.index_id();
      if (success && !input_data_view.ReadKeyRange(&p_key_range))
        success = false;
      if (success)
        p_key_only = input_data_view.key_only();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 6, false);
        return false;
      }
      IDBDatabase::GetCallback callback =
          IDBDatabase_Get_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Get(
std::move(p_transaction_id), 
std::move(p_object_store_id), 
std::move(p_index_id), 
std::move(p_key_range), 
std::move(p_key_only), std::move(callback));
      return true;
    }
    case internal::kIDBDatabase_GetAll_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::GetAll",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::GetAll");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IDBDatabase_GetAll_Params_Data* params =
          reinterpret_cast<
              internal::IDBDatabase_GetAll_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      int64_t p_index_id{};
      IDBKeyRangePtr p_key_range{};
      bool p_key_only{};
      int64_t p_max_count{};
      IDBDatabase_GetAll_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success)
        p_index_id = input_data_view.index_id();
      if (success && !input_data_view.ReadKeyRange(&p_key_range))
        success = false;
      if (success)
        p_key_only = input_data_view.key_only();
      if (success)
        p_max_count = input_data_view.max_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 7, false);
        return false;
      }
      IDBDatabase::GetAllCallback callback =
          IDBDatabase_GetAll_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAll(
std::move(p_transaction_id), 
std::move(p_object_store_id), 
std::move(p_index_id), 
std::move(p_key_range), 
std::move(p_key_only), 
std::move(p_max_count), std::move(callback));
      return true;
    }
    case internal::kIDBDatabase_SetIndexKeys_Name: {
      break;
    }
    case internal::kIDBDatabase_SetIndexesReady_Name: {
      break;
    }
    case internal::kIDBDatabase_OpenCursor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBDatabase::OpenCursor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBDatabase::OpenCursor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IDBDatabase_OpenCursor_Params_Data* params =
          reinterpret_cast<
              internal::IDBDatabase_OpenCursor_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      int64_t p_index_id{};
      IDBKeyRangePtr p_key_range{};
      IDBCursorDirection p_direction{};
      bool p_key_only{};
      IDBTaskType p_task_type{};
      IDBDatabase_OpenCursor_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success)
        p_index_id = input_data_view.index_id();
      if (success && !input_data_view.ReadKeyRange(&p_key_range))
        success = false;
      if (success && !input_data_view.ReadDirection(&p_direction))
        success = false;
      if (success)
        p_key_only = input_data_view.key_only();
      if (success && !input_data_view.ReadTaskType(&p_task_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 10, false);
        return false;
      }
      IDBDatabase::OpenCursorCallback callback =
          IDBDatabase_OpenCursor_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenCursor(
std::move(p_transaction_id), 
std::move(p_object_store_id), 
std::move(p_index_id), 
std::move(p_key_range), 
std::move(p_direction), 
std::move(p_key_only), 
std::move(p_task_type), std::move(callback));
      return true;
    }
    case internal::kIDBDatabase_Count_Name: {
      break;
    }
    case internal::kIDBDatabase_DeleteRange_Name: {
      break;
    }
    case internal::kIDBDatabase_GetKeyGeneratorCurrentNumber_Name: {
      break;
    }
    case internal::kIDBDatabase_Clear_Name: {
      break;
    }
    case internal::kIDBDatabase_CreateIndex_Name: {
      break;
    }
    case internal::kIDBDatabase_DeleteIndex_Name: {
      break;
    }
    case internal::kIDBDatabase_RenameIndex_Name: {
      break;
    }
    case internal::kIDBDatabase_Abort_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIDBDatabaseValidationInfo[] = {
    {internal::kIDBDatabase_RenameObjectStore_Name,
     {&internal::IDBDatabase_RenameObjectStore_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_CreateTransaction_Name,
     {&internal::IDBDatabase_CreateTransaction_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_Close_Name,
     {&internal::IDBDatabase_Close_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_VersionChangeIgnored_Name,
     {&internal::IDBDatabase_VersionChangeIgnored_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_AddObserver_Name,
     {&internal::IDBDatabase_AddObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_RemoveObservers_Name,
     {&internal::IDBDatabase_RemoveObservers_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_Get_Name,
     {&internal::IDBDatabase_Get_Params_Data::Validate,
      &internal::IDBDatabase_Get_ResponseParams_Data::Validate}},
    {internal::kIDBDatabase_GetAll_Name,
     {&internal::IDBDatabase_GetAll_Params_Data::Validate,
      &internal::IDBDatabase_GetAll_ResponseParams_Data::Validate}},
    {internal::kIDBDatabase_SetIndexKeys_Name,
     {&internal::IDBDatabase_SetIndexKeys_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_SetIndexesReady_Name,
     {&internal::IDBDatabase_SetIndexesReady_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_OpenCursor_Name,
     {&internal::IDBDatabase_OpenCursor_Params_Data::Validate,
      &internal::IDBDatabase_OpenCursor_ResponseParams_Data::Validate}},
    {internal::kIDBDatabase_Count_Name,
     {&internal::IDBDatabase_Count_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_DeleteRange_Name,
     {&internal::IDBDatabase_DeleteRange_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_GetKeyGeneratorCurrentNumber_Name,
     {&internal::IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_Clear_Name,
     {&internal::IDBDatabase_Clear_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_CreateIndex_Name,
     {&internal::IDBDatabase_CreateIndex_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_DeleteIndex_Name,
     {&internal::IDBDatabase_DeleteIndex_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_RenameIndex_Name,
     {&internal::IDBDatabase_RenameIndex_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBDatabase_Abort_Name,
     {&internal::IDBDatabase_Abort_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IDBDatabaseRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::IDBDatabase::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIDBDatabaseValidationInfo);
}

bool IDBDatabaseResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::IDBDatabase::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kIDBDatabaseValidationInfo);

}
const char IDBFactory::Name_[] = "blink.mojom.IDBFactory";

class IDBFactory_AbortTransactionsAndCompactDatabase_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBFactory_AbortTransactionsAndCompactDatabase_ForwardToCallback(
      IDBFactory::AbortTransactionsAndCompactDatabaseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IDBFactory::AbortTransactionsAndCompactDatabaseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IDBFactory_AbortTransactionsAndCompactDatabase_ForwardToCallback);
};

class IDBFactory_AbortTransactionsForDatabase_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBFactory_AbortTransactionsForDatabase_ForwardToCallback(
      IDBFactory::AbortTransactionsForDatabaseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IDBFactory::AbortTransactionsForDatabaseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IDBFactory_AbortTransactionsForDatabase_ForwardToCallback);
};

IDBFactoryProxy::IDBFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBFactoryProxy::GetDatabaseInfo(
    ::mojo::PendingAssociatedRemote<IDBCallbacks> in_pending_callbacks) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBFactory::GetDatabaseInfo", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("pending_callbacks", in_pending_callbacks.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBFactory_GetDatabaseInfo_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBFactory_GetDatabaseInfo_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::IDBCallbacksAssociatedPtrInfoDataView>(
      in_pending_callbacks, &params->pending_callbacks, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pending_callbacks),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid pending_callbacks in IDBFactory.GetDatabaseInfo request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactory::Name_);
  message.set_method_name("GetDatabaseInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBFactoryProxy::GetDatabaseNames(
    ::mojo::PendingAssociatedRemote<IDBCallbacks> in_pending_callbacks) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBFactory::GetDatabaseNames", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("pending_callbacks", in_pending_callbacks.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBFactory_GetDatabaseNames_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBFactory_GetDatabaseNames_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::IDBCallbacksAssociatedPtrInfoDataView>(
      in_pending_callbacks, &params->pending_callbacks, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pending_callbacks),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid pending_callbacks in IDBFactory.GetDatabaseNames request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactory::Name_);
  message.set_method_name("GetDatabaseNames");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBFactoryProxy::Open(
    ::mojo::PendingAssociatedRemote<IDBCallbacks> in_pending_callbacks, ::mojo::PendingAssociatedRemote<IDBDatabaseCallbacks> in_database_callbacks, const ::WTF::String& in_name, int64_t in_version, ::mojo::PendingAssociatedReceiver<IDBTransaction> in_version_change_transaction_receiver, int64_t in_transaction_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBFactory::Open", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("pending_callbacks", in_pending_callbacks.is_valid());
      raw_value->SetBoolean("database_callbacks", in_database_callbacks.is_valid());
      raw_value->SetString("name", base::trace_event::ValueToString(in_name, "<value of type const ::WTF::String&>"));
      raw_value->SetString("version", base::NumberToString(in_version));
      raw_value->SetBoolean("version_change_transaction_receiver", in_version_change_transaction_receiver.is_valid());
      raw_value->SetString("transaction_id", base::NumberToString(in_transaction_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBFactory_Open_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBFactory_Open_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::IDBCallbacksAssociatedPtrInfoDataView>(
      in_pending_callbacks, &params->pending_callbacks, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pending_callbacks),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid pending_callbacks in IDBFactory.Open request");
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseCallbacksAssociatedPtrInfoDataView>(
      in_database_callbacks, &params->database_callbacks, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->database_callbacks),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid database_callbacks in IDBFactory.Open request");
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in IDBFactory.Open request");
  params->version = in_version;
  mojo::internal::Serialize<::blink::mojom::IDBTransactionAssociatedRequestDataView>(
      in_version_change_transaction_receiver, &params->version_change_transaction_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->version_change_transaction_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid version_change_transaction_receiver in IDBFactory.Open request");
  params->transaction_id = in_transaction_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactory::Name_);
  message.set_method_name("Open");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBFactoryProxy::DeleteDatabase(
    ::mojo::PendingAssociatedRemote<IDBCallbacks> in_pending_callbacks, const ::WTF::String& in_name, bool in_force_close) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::IDBFactory::DeleteDatabase", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("pending_callbacks", in_pending_callbacks.is_valid());
      raw_value->SetString("name", base::trace_event::ValueToString(in_name, "<value of type const ::WTF::String&>"));
      raw_value->SetBoolean("force_close", in_force_close);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBFactory_DeleteDatabase_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBFactory_DeleteDatabase_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::IDBCallbacksAssociatedPtrInfoDataView>(
      in_pending_callbacks, &params->pending_callbacks, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pending_callbacks),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid pending_callbacks in IDBFactory.DeleteDatabase request");
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in IDBFactory.DeleteDatabase request");
  params->force_close = in_force_close;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactory::Name_);
  message.set_method_name("DeleteDatabase");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IDBFactoryProxy::AbortTransactionsAndCompactDatabase(
    AbortTransactionsAndCompactDatabaseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::IDBFactory::AbortTransactionsAndCompactDatabase");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBFactory_AbortTransactionsAndCompactDatabase_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBFactory_AbortTransactionsAndCompactDatabase_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactory::Name_);
  message.set_method_name("AbortTransactionsAndCompactDatabase");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBFactory_AbortTransactionsAndCompactDatabase_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IDBFactoryProxy::AbortTransactionsForDatabase(
    AbortTransactionsForDatabaseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::IDBFactory::AbortTransactionsForDatabase");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBFactory_AbortTransactionsForDatabase_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBFactory_AbortTransactionsForDatabase_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactory::Name_);
  message.set_method_name("AbortTransactionsForDatabase");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBFactory_AbortTransactionsForDatabase_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class IDBFactory_AbortTransactionsAndCompactDatabase_ProxyToResponder {
 public:
  static IDBFactory::AbortTransactionsAndCompactDatabaseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IDBFactory_AbortTransactionsAndCompactDatabase_ProxyToResponder> proxy(
        new IDBFactory_AbortTransactionsAndCompactDatabase_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IDBFactory_AbortTransactionsAndCompactDatabase_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBFactory_AbortTransactionsAndCompactDatabase_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IDBFactory_AbortTransactionsAndCompactDatabase_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IDBFactory::AbortTransactionsAndCompactDatabaseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IDBFactory_AbortTransactionsAndCompactDatabase_ProxyToResponder);
};

bool IDBFactory_AbortTransactionsAndCompactDatabase_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::IDBFactory::AbortTransactionsAndCompactDatabaseCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IDBFactory_AbortTransactionsAndCompactDatabase_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBFactory_AbortTransactionsAndCompactDatabase_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  IDBStatus p_status{};
  IDBFactory_AbortTransactionsAndCompactDatabase_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBFactory::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void IDBFactory_AbortTransactionsAndCompactDatabase_ProxyToResponder::Run(
    IDBStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::IDBFactory::AbortTransactionsAndCompactDatabaseCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("status", base::trace_event::ValueToString(in_status));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBFactory_AbortTransactionsAndCompactDatabase_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBFactory_AbortTransactionsAndCompactDatabase_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::IDBStatus>(
      in_status, &params->status);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::IDBFactory::AbortTransactionsAndCompactDatabaseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactory::Name_);
  message.set_method_name("AbortTransactionsAndCompactDatabase");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBFactory_AbortTransactionsForDatabase_ProxyToResponder {
 public:
  static IDBFactory::AbortTransactionsForDatabaseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IDBFactory_AbortTransactionsForDatabase_ProxyToResponder> proxy(
        new IDBFactory_AbortTransactionsForDatabase_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IDBFactory_AbortTransactionsForDatabase_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBFactory_AbortTransactionsForDatabase_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IDBFactory_AbortTransactionsForDatabase_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IDBFactory::AbortTransactionsForDatabaseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IDBFactory_AbortTransactionsForDatabase_ProxyToResponder);
};

bool IDBFactory_AbortTransactionsForDatabase_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::IDBFactory::AbortTransactionsForDatabaseCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IDBFactory_AbortTransactionsForDatabase_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBFactory_AbortTransactionsForDatabase_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  IDBStatus p_status{};
  IDBFactory_AbortTransactionsForDatabase_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBFactory::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void IDBFactory_AbortTransactionsForDatabase_ProxyToResponder::Run(
    IDBStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::IDBFactory::AbortTransactionsForDatabaseCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("status", base::trace_event::ValueToString(in_status));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIDBFactory_AbortTransactionsForDatabase_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::IDBFactory_AbortTransactionsForDatabase_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::IDBStatus>(
      in_status, &params->status);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::IDBFactory::AbortTransactionsForDatabaseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactory::Name_);
  message.set_method_name("AbortTransactionsForDatabase");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IDBFactoryStubDispatch::Accept(
    IDBFactory* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kIDBFactory_GetDatabaseInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBFactory::GetDatabaseInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBFactory::GetDatabaseInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBFactory_GetDatabaseInfo_Params_Data* params =
          reinterpret_cast<internal::IDBFactory_GetDatabaseInfo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<IDBCallbacks> p_pending_callbacks{};
      IDBFactory_GetDatabaseInfo_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_pending_callbacks =
            input_data_view.TakePendingCallbacks<decltype(p_pending_callbacks)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDatabaseInfo(
std::move(p_pending_callbacks));
      return true;
    }
    case internal::kIDBFactory_GetDatabaseNames_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBFactory::GetDatabaseNames",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBFactory::GetDatabaseNames");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBFactory_GetDatabaseNames_Params_Data* params =
          reinterpret_cast<internal::IDBFactory_GetDatabaseNames_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<IDBCallbacks> p_pending_callbacks{};
      IDBFactory_GetDatabaseNames_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_pending_callbacks =
            input_data_view.TakePendingCallbacks<decltype(p_pending_callbacks)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDatabaseNames(
std::move(p_pending_callbacks));
      return true;
    }
    case internal::kIDBFactory_Open_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBFactory::Open",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBFactory::Open");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBFactory_Open_Params_Data* params =
          reinterpret_cast<internal::IDBFactory_Open_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<IDBCallbacks> p_pending_callbacks{};
      ::mojo::PendingAssociatedRemote<IDBDatabaseCallbacks> p_database_callbacks{};
      ::WTF::String p_name{};
      int64_t p_version{};
      ::mojo::PendingAssociatedReceiver<IDBTransaction> p_version_change_transaction_receiver{};
      int64_t p_transaction_id{};
      IDBFactory_Open_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_pending_callbacks =
            input_data_view.TakePendingCallbacks<decltype(p_pending_callbacks)>();
      }
      if (success) {
        p_database_callbacks =
            input_data_view.TakeDatabaseCallbacks<decltype(p_database_callbacks)>();
      }
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success)
        p_version = input_data_view.version();
      if (success) {
        p_version_change_transaction_receiver =
            input_data_view.TakeVersionChangeTransactionReceiver<decltype(p_version_change_transaction_receiver)>();
      }
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactory::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Open(
std::move(p_pending_callbacks), 
std::move(p_database_callbacks), 
std::move(p_name), 
std::move(p_version), 
std::move(p_version_change_transaction_receiver), 
std::move(p_transaction_id));
      return true;
    }
    case internal::kIDBFactory_DeleteDatabase_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBFactory::DeleteDatabase",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBFactory::DeleteDatabase");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IDBFactory_DeleteDatabase_Params_Data* params =
          reinterpret_cast<internal::IDBFactory_DeleteDatabase_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<IDBCallbacks> p_pending_callbacks{};
      ::WTF::String p_name{};
      bool p_force_close{};
      IDBFactory_DeleteDatabase_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_pending_callbacks =
            input_data_view.TakePendingCallbacks<decltype(p_pending_callbacks)>();
      }
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success)
        p_force_close = input_data_view.force_close();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactory::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteDatabase(
std::move(p_pending_callbacks), 
std::move(p_name), 
std::move(p_force_close));
      return true;
    }
    case internal::kIDBFactory_AbortTransactionsAndCompactDatabase_Name: {
      break;
    }
    case internal::kIDBFactory_AbortTransactionsForDatabase_Name: {
      break;
    }
  }
  return false;
}

// static
bool IDBFactoryStubDispatch::AcceptWithResponder(
    IDBFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIDBFactory_GetDatabaseInfo_Name: {
      break;
    }
    case internal::kIDBFactory_GetDatabaseNames_Name: {
      break;
    }
    case internal::kIDBFactory_Open_Name: {
      break;
    }
    case internal::kIDBFactory_DeleteDatabase_Name: {
      break;
    }
    case internal::kIDBFactory_AbortTransactionsAndCompactDatabase_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBFactory::AbortTransactionsAndCompactDatabase",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBFactory::AbortTransactionsAndCompactDatabase");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IDBFactory_AbortTransactionsAndCompactDatabase_Params_Data* params =
          reinterpret_cast<
              internal::IDBFactory_AbortTransactionsAndCompactDatabase_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      IDBFactory_AbortTransactionsAndCompactDatabase_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactory::Name_, 4, false);
        return false;
      }
      IDBFactory::AbortTransactionsAndCompactDatabaseCallback callback =
          IDBFactory_AbortTransactionsAndCompactDatabase_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AbortTransactionsAndCompactDatabase(std::move(callback));
      return true;
    }
    case internal::kIDBFactory_AbortTransactionsForDatabase_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::IDBFactory::AbortTransactionsForDatabase",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::IDBFactory::AbortTransactionsForDatabase");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IDBFactory_AbortTransactionsForDatabase_Params_Data* params =
          reinterpret_cast<
              internal::IDBFactory_AbortTransactionsForDatabase_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      IDBFactory_AbortTransactionsForDatabase_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactory::Name_, 5, false);
        return false;
      }
      IDBFactory::AbortTransactionsForDatabaseCallback callback =
          IDBFactory_AbortTransactionsForDatabase_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AbortTransactionsForDatabase(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIDBFactoryValidationInfo[] = {
    {internal::kIDBFactory_GetDatabaseInfo_Name,
     {&internal::IDBFactory_GetDatabaseInfo_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBFactory_GetDatabaseNames_Name,
     {&internal::IDBFactory_GetDatabaseNames_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBFactory_Open_Name,
     {&internal::IDBFactory_Open_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBFactory_DeleteDatabase_Name,
     {&internal::IDBFactory_DeleteDatabase_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIDBFactory_AbortTransactionsAndCompactDatabase_Name,
     {&internal::IDBFactory_AbortTransactionsAndCompactDatabase_Params_Data::Validate,
      &internal::IDBFactory_AbortTransactionsAndCompactDatabase_ResponseParams_Data::Validate}},
    {internal::kIDBFactory_AbortTransactionsForDatabase_Name,
     {&internal::IDBFactory_AbortTransactionsForDatabase_Params_Data::Validate,
      &internal::IDBFactory_AbortTransactionsForDatabase_ResponseParams_Data::Validate}},
};

bool IDBFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::IDBFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIDBFactoryValidationInfo);
}

bool IDBFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::IDBFactory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kIDBFactoryValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::IDBKeyPath::DataView, ::blink::mojom::blink::IDBKeyPathPtr>::Read(
    ::blink::mojom::blink::IDBKeyPath::DataView input,
    ::blink::mojom::blink::IDBKeyPathPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBKeyPathPtr result(::blink::mojom::blink::IDBKeyPath::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBKeyRange::DataView, ::blink::mojom::blink::IDBKeyRangePtr>::Read(
    ::blink::mojom::blink::IDBKeyRange::DataView input,
    ::blink::mojom::blink::IDBKeyRangePtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBKeyRangePtr result(::blink::mojom::blink::IDBKeyRange::New());
  
      if (success && !input.ReadLower(&result->lower))
        success = false;
      if (success && !input.ReadUpper(&result->upper))
        success = false;
      if (success)
        result->lower_open = input.lower_open();
      if (success)
        result->upper_open = input.upper_open();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBIndexMetadata::DataView, ::blink::mojom::blink::IDBIndexMetadataPtr>::Read(
    ::blink::mojom::blink::IDBIndexMetadata::DataView input,
    ::blink::mojom::blink::IDBIndexMetadataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBIndexMetadataPtr result(::blink::mojom::blink::IDBIndexMetadata::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadKeyPath(&result->key_path))
        success = false;
      if (success)
        result->unique = input.unique();
      if (success)
        result->multi_entry = input.multi_entry();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBObjectStoreMetadata::DataView, ::blink::mojom::blink::IDBObjectStoreMetadataPtr>::Read(
    ::blink::mojom::blink::IDBObjectStoreMetadata::DataView input,
    ::blink::mojom::blink::IDBObjectStoreMetadataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBObjectStoreMetadataPtr result(::blink::mojom::blink::IDBObjectStoreMetadata::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadKeyPath(&result->key_path))
        success = false;
      if (success)
        result->auto_increment = input.auto_increment();
      if (success)
        result->max_index_id = input.max_index_id();
      if (success && !input.ReadIndexes(&result->indexes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBDatabaseMetadata::DataView, ::blink::mojom::blink::IDBDatabaseMetadataPtr>::Read(
    ::blink::mojom::blink::IDBDatabaseMetadata::DataView input,
    ::blink::mojom::blink::IDBDatabaseMetadataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBDatabaseMetadataPtr result(::blink::mojom::blink::IDBDatabaseMetadata::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->version = input.version();
      if (success)
        result->max_object_store_id = input.max_object_store_id();
      if (success && !input.ReadObjectStores(&result->object_stores))
        success = false;
      if (success)
        result->was_cold_open = input.was_cold_open();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBNameAndVersion::DataView, ::blink::mojom::blink::IDBNameAndVersionPtr>::Read(
    ::blink::mojom::blink::IDBNameAndVersion::DataView input,
    ::blink::mojom::blink::IDBNameAndVersionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBNameAndVersionPtr result(::blink::mojom::blink::IDBNameAndVersion::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->version = input.version();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBIndexKeys::DataView, ::blink::mojom::blink::IDBIndexKeysPtr>::Read(
    ::blink::mojom::blink::IDBIndexKeys::DataView input,
    ::blink::mojom::blink::IDBIndexKeysPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBIndexKeysPtr result(::blink::mojom::blink::IDBIndexKeys::New());
  
      if (success)
        result->index_id = input.index_id();
      if (success && !input.ReadIndexKeys(&result->index_keys))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBFileInfo::DataView, ::blink::mojom::blink::IDBFileInfoPtr>::Read(
    ::blink::mojom::blink::IDBFileInfo::DataView input,
    ::blink::mojom::blink::IDBFileInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBFileInfoPtr result(::blink::mojom::blink::IDBFileInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadLastModified(&result->last_modified))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBBlobInfo::DataView, ::blink::mojom::blink::IDBBlobInfoPtr>::Read(
    ::blink::mojom::blink::IDBBlobInfo::DataView input,
    ::blink::mojom::blink::IDBBlobInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBBlobInfoPtr result(::blink::mojom::blink::IDBBlobInfo::New());
  
      if (success) {
        result->blob =
            input.TakeBlob<decltype(result->blob)>();
      }
      if (success && !input.ReadUuid(&result->uuid))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success)
        result->size = input.size();
      if (success && !input.ReadFile(&result->file))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBValue::DataView, ::blink::mojom::blink::IDBValuePtr>::Read(
    ::blink::mojom::blink::IDBValue::DataView input,
    ::blink::mojom::blink::IDBValuePtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBValuePtr result(::blink::mojom::blink::IDBValue::New());
  
      if (success && !input.ReadBits(&result->bits))
        success = false;
      if (success && !input.ReadExternalObjects(&result->external_objects))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBReturnValue::DataView, ::blink::mojom::blink::IDBReturnValuePtr>::Read(
    ::blink::mojom::blink::IDBReturnValue::DataView input,
    ::blink::mojom::blink::IDBReturnValuePtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBReturnValuePtr result(::blink::mojom::blink::IDBReturnValue::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadPrimaryKey(&result->primary_key))
        success = false;
      if (success && !input.ReadKeyPath(&result->key_path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBObservation::DataView, ::blink::mojom::blink::IDBObservationPtr>::Read(
    ::blink::mojom::blink::IDBObservation::DataView input,
    ::blink::mojom::blink::IDBObservationPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBObservationPtr result(::blink::mojom::blink::IDBObservation::New());
  
      if (success)
        result->object_store_id = input.object_store_id();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadKeyRange(&result->key_range))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBObserverTransaction::DataView, ::blink::mojom::blink::IDBObserverTransactionPtr>::Read(
    ::blink::mojom::blink::IDBObserverTransaction::DataView input,
    ::blink::mojom::blink::IDBObserverTransactionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBObserverTransactionPtr result(::blink::mojom::blink::IDBObserverTransaction::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadScope(&result->scope))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBObserverChanges::DataView, ::blink::mojom::blink::IDBObserverChangesPtr>::Read(
    ::blink::mojom::blink::IDBObserverChanges::DataView input,
    ::blink::mojom::blink::IDBObserverChangesPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBObserverChangesPtr result(::blink::mojom::blink::IDBObserverChanges::New());
  
      if (success && !input.ReadObservationIndexMap(&result->observation_index_map))
        success = false;
      if (success && !input.ReadTransactionMap(&result->transaction_map))
        success = false;
      if (success && !input.ReadObservations(&result->observations))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBError::DataView, ::blink::mojom::blink::IDBErrorPtr>::Read(
    ::blink::mojom::blink::IDBError::DataView input,
    ::blink::mojom::blink::IDBErrorPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBErrorPtr result(::blink::mojom::blink::IDBError::New());
  
      if (success && !input.ReadErrorCode(&result->error_code))
        success = false;
      if (success && !input.ReadErrorMessage(&result->error_message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBCursorValue::DataView, ::blink::mojom::blink::IDBCursorValuePtr>::Read(
    ::blink::mojom::blink::IDBCursorValue::DataView input,
    ::blink::mojom::blink::IDBCursorValuePtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBCursorValuePtr result(::blink::mojom::blink::IDBCursorValue::New());
  
      if (success && !input.ReadKeys(&result->keys))
        success = false;
      if (success && !input.ReadPrimaryKeys(&result->primary_keys))
        success = false;
      if (success && !input.ReadValues(&result->values))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBPutParams::DataView, ::blink::mojom::blink::IDBPutParamsPtr>::Read(
    ::blink::mojom::blink::IDBPutParams::DataView input,
    ::blink::mojom::blink::IDBPutParamsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBPutParamsPtr result(::blink::mojom::blink::IDBPutParams::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadIndexKeys(&result->index_keys))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBDatabaseOpenCursorValue::DataView, ::blink::mojom::blink::IDBDatabaseOpenCursorValuePtr>::Read(
    ::blink::mojom::blink::IDBDatabaseOpenCursorValue::DataView input,
    ::blink::mojom::blink::IDBDatabaseOpenCursorValuePtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBDatabaseOpenCursorValuePtr result(::blink::mojom::blink::IDBDatabaseOpenCursorValue::New());
  
      if (success) {
        result->cursor =
            input.TakeCursor<decltype(result->cursor)>();
      }
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadPrimaryKey(&result->primary_key))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBKey::DataView, ::blink::mojom::blink::IDBKeyPtr>::Read(
    ::blink::mojom::blink::IDBKey::DataView input,
    ::blink::mojom::blink::IDBKeyPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBKey;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::KEY_ARRAY: {
      WTF::Vector<::std::unique_ptr<::blink::IDBKey>> result_key_array;
      if (!input.ReadKeyArray(&result_key_array))
        return false;

      *output = UnionType::NewKeyArray(
          std::move(result_key_array));
      break;
    }
    case Tag::BINARY: {
      WTF::Vector<uint8_t> result_binary;
      if (!input.ReadBinary(&result_binary))
        return false;

      *output = UnionType::NewBinary(
          std::move(result_binary));
      break;
    }
    case Tag::STRING: {
      ::WTF::String result_string;
      if (!input.ReadString(&result_string))
        return false;

      *output = UnionType::NewString(
          std::move(result_string));
      break;
    }
    case Tag::DATE: {
      *output = UnionType::NewDate(input.date());
      break;
    }
    case Tag::NUMBER: {
      *output = UnionType::NewNumber(input.number());
      break;
    }
    case Tag::OTHER_NONE: {
      *output = UnionType::NewOtherNone(input.other_none());
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBKeyPathData::DataView, ::blink::mojom::blink::IDBKeyPathDataPtr>::Read(
    ::blink::mojom::blink::IDBKeyPathData::DataView input,
    ::blink::mojom::blink::IDBKeyPathDataPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBKeyPathData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::STRING: {
      ::WTF::String result_string;
      if (!input.ReadString(&result_string))
        return false;

      *output = UnionType::NewString(
          std::move(result_string));
      break;
    }
    case Tag::STRING_ARRAY: {
      WTF::Vector<::WTF::String> result_string_array;
      if (!input.ReadStringArray(&result_string_array))
        return false;

      *output = UnionType::NewStringArray(
          std::move(result_string_array));
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBExternalObject::DataView, ::blink::mojom::blink::IDBExternalObjectPtr>::Read(
    ::blink::mojom::blink::IDBExternalObject::DataView input,
    ::blink::mojom::blink::IDBExternalObjectPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBExternalObject;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::BLOB_OR_FILE: {
      ::blink::mojom::blink::IDBBlobInfoPtr result_blob_or_file;
      if (!input.ReadBlobOrFile(&result_blob_or_file))
        return false;

      *output = UnionType::NewBlobOrFile(
          std::move(result_blob_or_file));
      break;
    }
    case Tag::NATIVE_FILE_SYSTEM_TOKEN: {
      *output = UnionType::NewNativeFileSystemToken(
          input.TakeNativeFileSystemToken<::mojo::PendingRemote<::blink::mojom::blink::NativeFileSystemTransferToken>>());
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBCursorResult::DataView, ::blink::mojom::blink::IDBCursorResultPtr>::Read(
    ::blink::mojom::blink::IDBCursorResult::DataView input,
    ::blink::mojom::blink::IDBCursorResultPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBCursorResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::ERROR_RESULT: {
      ::blink::mojom::blink::IDBErrorPtr result_error_result;
      if (!input.ReadErrorResult(&result_error_result))
        return false;

      *output = UnionType::NewErrorResult(
          std::move(result_error_result));
      break;
    }
    case Tag::EMPTY: {
      *output = UnionType::NewEmpty(input.empty());
      break;
    }
    case Tag::VALUES: {
      ::blink::mojom::blink::IDBCursorValuePtr result_values;
      if (!input.ReadValues(&result_values))
        return false;

      *output = UnionType::NewValues(
          std::move(result_values));
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBTransactionPutResult::DataView, ::blink::mojom::blink::IDBTransactionPutResultPtr>::Read(
    ::blink::mojom::blink::IDBTransactionPutResult::DataView input,
    ::blink::mojom::blink::IDBTransactionPutResultPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBTransactionPutResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::ERROR_RESULT: {
      ::blink::mojom::blink::IDBErrorPtr result_error_result;
      if (!input.ReadErrorResult(&result_error_result))
        return false;

      *output = UnionType::NewErrorResult(
          std::move(result_error_result));
      break;
    }
    case Tag::KEY: {
      ::std::unique_ptr<::blink::IDBKey> result_key;
      if (!input.ReadKey(&result_key))
        return false;

      *output = UnionType::NewKey(
          std::move(result_key));
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBTransactionPutAllResult::DataView, ::blink::mojom::blink::IDBTransactionPutAllResultPtr>::Read(
    ::blink::mojom::blink::IDBTransactionPutAllResult::DataView input,
    ::blink::mojom::blink::IDBTransactionPutAllResultPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBTransactionPutAllResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::ERROR_RESULT: {
      ::blink::mojom::blink::IDBErrorPtr result_error_result;
      if (!input.ReadErrorResult(&result_error_result))
        return false;

      *output = UnionType::NewErrorResult(
          std::move(result_error_result));
      break;
    }
    case Tag::KEYS: {
      WTF::Vector<::std::unique_ptr<::blink::IDBKey>> result_keys;
      if (!input.ReadKeys(&result_keys))
        return false;

      *output = UnionType::NewKeys(
          std::move(result_keys));
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBDatabaseGetResult::DataView, ::blink::mojom::blink::IDBDatabaseGetResultPtr>::Read(
    ::blink::mojom::blink::IDBDatabaseGetResult::DataView input,
    ::blink::mojom::blink::IDBDatabaseGetResultPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBDatabaseGetResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::ERROR_RESULT: {
      ::blink::mojom::blink::IDBErrorPtr result_error_result;
      if (!input.ReadErrorResult(&result_error_result))
        return false;

      *output = UnionType::NewErrorResult(
          std::move(result_error_result));
      break;
    }
    case Tag::EMPTY: {
      *output = UnionType::NewEmpty(input.empty());
      break;
    }
    case Tag::KEY: {
      ::std::unique_ptr<::blink::IDBKey> result_key;
      if (!input.ReadKey(&result_key))
        return false;

      *output = UnionType::NewKey(
          std::move(result_key));
      break;
    }
    case Tag::VALUE: {
      ::blink::mojom::blink::IDBReturnValuePtr result_value;
      if (!input.ReadValue(&result_value))
        return false;

      *output = UnionType::NewValue(
          std::move(result_value));
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBDatabaseOpenCursorResult::DataView, ::blink::mojom::blink::IDBDatabaseOpenCursorResultPtr>::Read(
    ::blink::mojom::blink::IDBDatabaseOpenCursorResult::DataView input,
    ::blink::mojom::blink::IDBDatabaseOpenCursorResultPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBDatabaseOpenCursorResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::ERROR_RESULT: {
      ::blink::mojom::blink::IDBErrorPtr result_error_result;
      if (!input.ReadErrorResult(&result_error_result))
        return false;

      *output = UnionType::NewErrorResult(
          std::move(result_error_result));
      break;
    }
    case Tag::EMPTY: {
      *output = UnionType::NewEmpty(input.empty());
      break;
    }
    case Tag::VALUE: {
      ::blink::mojom::blink::IDBDatabaseOpenCursorValuePtr result_value;
      if (!input.ReadValue(&result_value))
        return false;

      *output = UnionType::NewValue(
          std::move(result_value));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif