/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.jakartaee.Converter;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.Info;
import org.apache.tomcat.jakartaee.StringManager;

public class ManifestConverter
implements Converter {
    private static final Logger logger = Logger.getLogger(ManifestConverter.class.getCanonicalName());
    private static final StringManager sm = StringManager.getManager(ManifestConverter.class);

    @Override
    public boolean accepts(String filename) {
        return "META-INF/MANIFEST.MF".equals(filename);
    }

    @Override
    public void convert(String path, InputStream src, OutputStream dest, EESpecProfile profile) throws IOException {
        Manifest srcManifest = new Manifest(src);
        Manifest destManifest = new Manifest(srcManifest);
        boolean result = false;
        result |= this.removeSignatures(destManifest);
        if (result |= this.updateValues(destManifest, profile)) {
            destManifest.write(dest);
        } else {
            srcManifest.write(dest);
        }
    }

    private boolean removeSignatures(Manifest manifest) {
        boolean removedSignatures = manifest.getMainAttributes().remove(Attributes.Name.SIGNATURE_VERSION) != null;
        ArrayList<String> signatureEntries = new ArrayList<String>();
        Map<String, Attributes> manifestAttributeEntries = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : manifestAttributeEntries.entrySet()) {
            if (!this.isCryptoSignatureEntry(entry.getValue())) continue;
            String entryName = entry.getKey();
            signatureEntries.add(entryName);
            logger.log(Level.FINE, sm.getString("migration.removeSignature", entryName));
            removedSignatures = true;
        }
        for (String string : signatureEntries) {
            manifestAttributeEntries.remove(string);
        }
        return removedSignatures;
    }

    private boolean isCryptoSignatureEntry(Attributes attributes) {
        for (Object attributeKey : attributes.keySet()) {
            if (!attributeKey.toString().endsWith("-Digest")) continue;
            return true;
        }
        return false;
    }

    private boolean updateValues(Manifest manifest, EESpecProfile profile) {
        boolean result = false;
        result |= this.updateValues(manifest.getMainAttributes(), profile);
        for (Attributes attributes : manifest.getEntries().values()) {
            result |= this.updateValues(attributes, profile);
        }
        return result;
    }

    private boolean updateValues(Attributes attributes, EESpecProfile profile) {
        boolean result = false;
        if (attributes.containsKey(Attributes.Name.IMPLEMENTATION_VERSION)) {
            String newValue = attributes.get(Attributes.Name.IMPLEMENTATION_VERSION) + "-" + Info.getVersion();
            attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, newValue);
            result = true;
        }
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String newValue = profile.convert((String)entry.getValue());
            if (newValue == entry.getValue()) continue;
            entry.setValue(newValue);
            result = true;
        }
        return result;
    }
}

