/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.net.InetAddress;
import java.util.regex.Pattern;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.ajp.AjpProcessor;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractAjpProtocol<S>
extends AbstractProtocol<S> {
    protected static final StringManager sm = StringManager.getManager(AbstractAjpProtocol.class);
    protected boolean ajpFlush = true;
    private boolean tomcatAuthentication = true;
    private boolean tomcatAuthorization = false;
    private String secret = null;
    private boolean secretRequired = true;
    private Pattern allowedRequestAttributesPattern;
    private int packetSize = 8192;

    public AbstractAjpProtocol(AbstractEndpoint<S, ?> abstractEndpoint) {
        super(abstractEndpoint);
        this.setConnectionTimeout(-1);
        this.getEndpoint().setUseSendfile(false);
        this.getEndpoint().setAddress(InetAddress.getLoopbackAddress());
        AbstractProtocol.ConnectionHandler connectionHandler = new AbstractProtocol.ConnectionHandler(this);
        this.setHandler(connectionHandler);
        this.getEndpoint().setHandler(connectionHandler);
    }

    @Override
    protected String getProtocolName() {
        return "Ajp";
    }

    @Override
    protected AbstractEndpoint<S, ?> getEndpoint() {
        return super.getEndpoint();
    }

    @Override
    protected UpgradeProtocol getNegotiatedProtocol(String string) {
        return null;
    }

    @Override
    protected UpgradeProtocol getUpgradeProtocol(String string) {
        return null;
    }

    public boolean getAjpFlush() {
        return this.ajpFlush;
    }

    public void setAjpFlush(boolean bl) {
        this.ajpFlush = bl;
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean bl) {
        this.tomcatAuthentication = bl;
    }

    public boolean getTomcatAuthorization() {
        return this.tomcatAuthorization;
    }

    public void setTomcatAuthorization(boolean bl) {
        this.tomcatAuthorization = bl;
    }

    public void setSecret(String string) {
        this.secret = string;
    }

    protected String getSecret() {
        return this.secret;
    }

    @Deprecated
    public void setRequiredSecret(String string) {
        this.setSecret(string);
    }

    @Deprecated
    protected String getRequiredSecret() {
        return this.getSecret();
    }

    public void setSecretRequired(boolean bl) {
        this.secretRequired = bl;
    }

    public boolean getSecretRequired() {
        return this.secretRequired;
    }

    public void setAllowedRequestAttributesPattern(String string) {
        this.allowedRequestAttributesPattern = Pattern.compile(string);
    }

    public String getAllowedRequestAttributesPattern() {
        return this.allowedRequestAttributesPattern.pattern();
    }

    protected Pattern getAllowedRequestAttributesPatternInternal() {
        return this.allowedRequestAttributesPattern;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(int n) {
        this.packetSize = n < 8192 ? 8192 : n;
    }

    @Override
    public void addSslHostConfig(SSLHostConfig sSLHostConfig) {
        this.getLog().warn((Object)sm.getString("ajpprotocol.noSSL", new Object[]{sSLHostConfig.getHostName()}));
    }

    @Override
    public SSLHostConfig[] findSslHostConfigs() {
        return new SSLHostConfig[0];
    }

    @Override
    public void addUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        this.getLog().warn((Object)sm.getString("ajpprotocol.noUpgrade", new Object[]{upgradeProtocol.getClass().getName()}));
    }

    @Override
    public UpgradeProtocol[] findUpgradeProtocols() {
        return new UpgradeProtocol[0];
    }

    @Override
    protected Processor createProcessor() {
        AjpProcessor ajpProcessor = new AjpProcessor(this.getPacketSize(), this.getEndpoint());
        ajpProcessor.setAdapter(this.getAdapter());
        ajpProcessor.setAjpFlush(this.getAjpFlush());
        ajpProcessor.setTomcatAuthentication(this.getTomcatAuthentication());
        ajpProcessor.setTomcatAuthorization(this.getTomcatAuthorization());
        ajpProcessor.setSecret(this.secret);
        ajpProcessor.setKeepAliveTimeout(this.getKeepAliveTimeout());
        ajpProcessor.setClientCertProvider(this.getClientCertProvider());
        ajpProcessor.setSendReasonPhrase(this.getSendReasonPhrase());
        ajpProcessor.setAllowedRequestAttributesPattern(this.getAllowedRequestAttributesPatternInternal());
        return ajpProcessor;
    }

    @Override
    protected Processor createUpgradeProcessor(SocketWrapperBase<?> socketWrapperBase, UpgradeToken upgradeToken) {
        throw new IllegalStateException(sm.getString("ajpprotocol.noUpgradeHandler", new Object[]{upgradeToken.getHttpUpgradeHandler().getClass().getName()}));
    }

    @Override
    public void start() throws Exception {
        String string;
        if (this.getSecretRequired() && ((string = this.getSecret()) == null || string.length() == 0)) {
            throw new IllegalArgumentException(sm.getString("ajpprotocol.noSecret"));
        }
        super.start();
    }
}

