/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.console.r.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import org.graalvm.visualvm.heapviewer.console.r.engine.ClassIDArray;
import org.graalvm.visualvm.heapviewer.console.r.engine.InstancesArray;
import org.graalvm.visualvm.heapviewer.console.r.engine.InstancesSizeArray;
import org.graalvm.visualvm.heapviewer.console.r.engine.NamesArray;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;

public class REngine {
    private static final Logger LOGGER = Logger.getLogger(REngine.class.getName());
    private static Boolean supported;
    private AtomicBoolean cancelled;
    private final Heap heap;
    private Context rContext;
    private Value javaToDf;
    private ROut outStream;

    public static synchronized boolean isSupported() {
        if (supported == null) {
            try {
                Context c = Context.newBuilder((String[])new String[]{"R"}).allowAllAccess(true).build();
                c.eval("R", (CharSequence)"invisible(42)");
                supported = Boolean.TRUE;
            }
            catch (Exception e) {
                supported = Boolean.FALSE;
            }
            catch (NoClassDefFoundError e) {
                supported = Boolean.FALSE;
            }
        }
        return supported;
    }

    public REngine(Heap h) {
        this.heap = h;
        this.initRContext();
    }

    private void initRContext() {
        this.cancelled = new AtomicBoolean(false);
        this.outStream = new ROut();
        this.rContext = Context.newBuilder((String[])new String[]{"R"}).allowAllAccess(true).out((OutputStream)this.outStream).build();
        String javaToDfSrc = "function(c1, c2, c3, c4) {    data.frame(ClassName=as.vector(c1, 'character'),              ClassId=as.vector(c2, 'character'),              Instances=as.vector(c3, 'integer'),              InstancesSize=as.vector(c4, 'integer'),stringsAsFactors = F)}";
        this.javaToDf = this.rContext.eval("R", (CharSequence)javaToDfSrc);
        List classes = this.heap.getAllClasses();
        this.exportSymbol(this.rContext, "HeapClasses", this.javaToDf.execute(new Object[]{new NamesArray(classes), new ClassIDArray(classes), new InstancesArray(classes), new InstancesSizeArray(classes)}));
        this.rContext.eval("R", (CharSequence)"HeapClasses <- import('HeapClasses');");
        this.exportSymbol(this.rContext, "heap", this.heap);
        this.rContext.eval("R", (CharSequence)"heap <- import('heap');");
        this.rContext.eval("R", (CharSequence)"options(width=256)");
    }

    private void exportSymbol(Context ctx, String name, Object value) {
        ctx.getPolyglotBindings().putMember(name, value);
    }

    public synchronized void cancelQuery() {
        this.cancelled.set(true);
    }

    public synchronized boolean isCancelled() {
        return this.cancelled.get();
    }

    public void executeQuery(String rQuery, ObjectVisitor objectVisitor) {
        if (this.rContext == null) {
            this.initRContext();
        }
        this.cancelled.set(false);
        this.outStream.setVisitor(objectVisitor);
        this.rContext.eval("R", (CharSequence)rQuery);
    }

    public Context getContext() {
        return this.rContext;
    }

    private static class ROut
    extends OutputStream {
        private ObjectVisitor visitor;
        private StringBuilder output = new StringBuilder();

        private ROut() {
        }

        @Override
        public void write(int b) throws IOException {
            if (b == 10) {
                this.visitor.visit(this.output.toString());
                this.output = new StringBuilder();
            } else {
                this.output.append((char)b);
            }
        }

        private void setVisitor(ObjectVisitor objectVisitor) {
            this.visitor = objectVisitor;
        }
    }

    public static interface ObjectVisitor {
        public static final ObjectVisitor DEFAULT = new ObjectVisitor(){

            @Override
            public boolean visit(Object o) {
                if (o != null && LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(o.toString());
                }
                return true;
            }
        };

        public boolean visit(Object var1);
    }
}

