/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.charts.xy;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.plaf.LabelUI;
import org.graalvm.visualvm.charts.swing.RotateLabelUI;
import org.graalvm.visualvm.charts.xy.ColorIcon;
import org.graalvm.visualvm.charts.xy.SimpleXYChart;
import org.graalvm.visualvm.charts.xy.XYAxisComponent;
import org.graalvm.visualvm.charts.xy.XYBackground;
import org.graalvm.visualvm.charts.xy.XYDecimalMarksPainter;
import org.graalvm.visualvm.charts.xy.XYPainter;
import org.graalvm.visualvm.charts.xy.XYPaintersModel;
import org.graalvm.visualvm.charts.xy.XYPercentMarksPainter;
import org.graalvm.visualvm.charts.xy.XYSelectionOverlay;
import org.graalvm.visualvm.charts.xy.XYStorage;
import org.graalvm.visualvm.charts.xy.XYTooltipModel;
import org.graalvm.visualvm.charts.xy.XYTooltipOverlay;
import org.graalvm.visualvm.charts.xy.XYTooltipPainter;
import org.graalvm.visualvm.lib.charts.ChartComponent;
import org.graalvm.visualvm.lib.charts.ChartContext;
import org.graalvm.visualvm.lib.charts.ChartDecorator;
import org.graalvm.visualvm.lib.charts.ChartItem;
import org.graalvm.visualvm.lib.charts.ChartItemChange;
import org.graalvm.visualvm.lib.charts.ItemPainter;
import org.graalvm.visualvm.lib.charts.ItemsModel;
import org.graalvm.visualvm.lib.charts.PaintersModel;
import org.graalvm.visualvm.lib.charts.Timeline;
import org.graalvm.visualvm.lib.charts.axis.AxisMarksComputer;
import org.graalvm.visualvm.lib.charts.axis.AxisMarksPainter;
import org.graalvm.visualvm.lib.charts.axis.BitsPerSecMarksPainter;
import org.graalvm.visualvm.lib.charts.axis.BytesMarksPainter;
import org.graalvm.visualvm.lib.charts.axis.TimeAxisUtils;
import org.graalvm.visualvm.lib.charts.axis.TimeMarksPainter;
import org.graalvm.visualvm.lib.charts.axis.TimelineMarksComputer;
import org.graalvm.visualvm.lib.charts.swing.CrossBorderLayout;
import org.graalvm.visualvm.lib.charts.swing.LongRect;
import org.graalvm.visualvm.lib.charts.swing.Utils;
import org.graalvm.visualvm.lib.charts.xy.BytesXYItemMarksComputer;
import org.graalvm.visualvm.lib.charts.xy.DecimalXYItemMarksComputer;
import org.graalvm.visualvm.lib.charts.xy.XYItem;
import org.graalvm.visualvm.lib.charts.xy.XYItemPainter;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItem;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItemsModel;
import org.graalvm.visualvm.uisupport.HTMLTextArea;
import org.graalvm.visualvm.uisupport.TransparentToolBar;
import org.graalvm.visualvm.uisupport.UISupport;
import org.graalvm.visualvm.uisupport.VerticalLayout;
import org.openide.util.NbBundle;

public class SimpleXYChartUtils {
    public static final int TYPE_DECIMAL = 0;
    public static final int TYPE_BYTES = 1;
    public static final int TYPE_PERCENT = 2;
    public static final int TYPE_BITS_PER_SEC = 3;
    private static final NumberFormat DECIMAL_FORMATTER = NumberFormat.getNumberInstance();
    private static final NumberFormat PERCENT_FORMATTER;
    private static final int DEFAULT_BUFFER_STEP;
    private static final Color AXIS_FONT_COLOR;
    private static final Color BACKGROUND_COLOR;
    private static final int VALUES_SPACING;
    private static final int TIMELINE_SPACING;
    private static int LEGEND_HEIGHT;
    private static final int DETAILS_HEIGHT_THRESHOLD;
    private static final Map<String, Format> FORMATS;
    private static final Color HEAP_LIMIT_FILL_COLOR;

    public static XYStorage createStorage(int valuesBuffer) {
        return new XYStorage(valuesBuffer, DEFAULT_BUFFER_STEP);
    }

    public static SynchronousXYItemsModel createItemsModel(XYStorage storage, String[] itemNames, long minValue, long maxValue) {
        SynchronousXYItem[] items = new SynchronousXYItem[itemNames.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = storage.addItem(itemNames[i], minValue, maxValue);
        }
        return new SynchronousXYItemsModel((Timeline)storage, items);
    }

    public static XYPaintersModel createPaintersModel(float[] lineWidths, Color[] lineColors, Color[] fillColors1, Color[] fillColors2, ItemsModel itemsModel) {
        ChartItem[] items = new ChartItem[itemsModel.getItemsCount()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = itemsModel.getItem(i);
        }
        ItemPainter[] painters = new ItemPainter[items.length];
        for (int i = 0; i < painters.length; ++i) {
            painters[i] = XYPainter.absolutePainter((lineWidths == null ? null : Float.valueOf(lineWidths[i])).floatValue(), lineColors == null ? null : lineColors[i], fillColors1 == null ? null : fillColors1[i], fillColors2 == null ? null : fillColors2[i]);
        }
        return new XYPaintersModel(items, painters);
    }

    public static JComponent createChartUI(String chartTitle, String xAxisDescription, String yAxisDescription, int chartType, Color[] itemColors, long initialYMargin, boolean hideItems, boolean legendVisible, boolean supportsZooming, double chartFactor, NumberFormat customFormat, XYStorage storage, SynchronousXYItemsModel itemsModel, XYPaintersModel paintersModel, long limitYValue) {
        JPanel chartContainer;
        Object vComputer;
        XYItemPainter painter;
        SynchronousXYItem item;
        final boolean hasAxisLabel = xAxisDescription != null || yAxisDescription != null;
        final XYStorage _storage = storage;
        SimpleXYChart chart = new SimpleXYChart(itemsModel, (PaintersModel)paintersModel){

            protected void itemsChanged(List<ChartItemChange> itemChanges) {
                if (_storage.isFull()) {
                    this.updateChart();
                } else {
                    super.itemsChanged(itemChanges);
                }
            }

            public void setBounds(int x, int y, int w, int h) {
                super.setBounds(x, y, w, h);
                JScrollBar scroller = (JScrollBar)this.getClientProperty("scroller");
                if (scroller != null) {
                    int xpos = this.getX() - 1;
                    if (hasAxisLabel) {
                        xpos += this.getParent().getX();
                    }
                    scroller.setBounds(xpos, 0, this.getWidth() + 1, scroller.getHeight());
                }
            }
        };
        chart.setFitsHeight(true);
        chart.setFitsWidth(true);
        chart.setBottomBased(true);
        chart.setViewInsets(new Insets(10, 0, 0, 0));
        chart.setInitialDataBounds(new LongRect(System.currentTimeMillis(), 0L, 2500L, initialYMargin));
        chart.addPreDecorator(new XYBackground());
        if (limitYValue != 0L) {
            chart.addPreDecorator(SimpleXYChartUtils.createMaxHeapDecorator(limitYValue));
        }
        TimelineMarksComputer hComputer = new TimelineMarksComputer(storage, chart.getChartContext(), 0){

            protected int getMinMarksDistance() {
                return TIMELINE_SPACING;
            }
        };
        XYAxisComponent hAxis = new XYAxisComponent((ChartComponent)chart, (AxisMarksComputer)hComputer, SimpleXYChartUtils.customizeMarksPainter((AxisMarksPainter.Abstract)new TimeMarksPainter()), 5, 2);
        XYAxisComponent vAxis = null;
        if (chartType == 2) {
            item = itemsModel.getItem(0);
            painter = (XYItemPainter)paintersModel.getPainter((ChartItem)item);
            vComputer = new DecimalXYItemMarksComputer((XYItem)item, painter, chart.getChartContext(), 1){

                protected int getMinMarksDistance() {
                    return VALUES_SPACING;
                }
            };
            vAxis = new XYAxisComponent((ChartComponent)chart, (AxisMarksComputer)vComputer, SimpleXYChartUtils.customizeMarksPainter((AxisMarksPainter.Abstract)new XYPercentMarksPainter(0L, 100L, chartFactor)), 7, 2);
        } else if (chartType == 1) {
            item = itemsModel.getItem(0);
            painter = (XYItemPainter)paintersModel.getPainter((ChartItem)item);
            vComputer = new BytesXYItemMarksComputer((XYItem)item, painter, chart.getChartContext(), 1){

                protected int getMinMarksDistance() {
                    return VALUES_SPACING;
                }
            };
            vAxis = new XYAxisComponent((ChartComponent)chart, (AxisMarksComputer)vComputer, SimpleXYChartUtils.customizeMarksPainter((AxisMarksPainter.Abstract)new BytesMarksPainter()), 7, 2);
        } else if (chartType == 3) {
            item = itemsModel.getItem(0);
            painter = (XYItemPainter)paintersModel.getPainter((ChartItem)item);
            vComputer = new BytesXYItemMarksComputer((XYItem)item, painter, chart.getChartContext(), 1){

                protected int getMinMarksDistance() {
                    return VALUES_SPACING;
                }
            };
            vAxis = new XYAxisComponent((ChartComponent)chart, (AxisMarksComputer)vComputer, SimpleXYChartUtils.customizeMarksPainter((AxisMarksPainter.Abstract)new BitsPerSecMarksPainter()), 7, 2);
        } else {
            item = itemsModel.getItem(0);
            painter = (XYItemPainter)paintersModel.getPainter((ChartItem)item);
            vComputer = new DecimalXYItemMarksComputer((XYItem)item, painter, chart.getChartContext(), 1){

                protected int getMinMarksDistance() {
                    return VALUES_SPACING;
                }
            };
            NumberFormat format = customFormat != null ? customFormat : DECIMAL_FORMATTER;
            vAxis = new XYAxisComponent((ChartComponent)chart, (AxisMarksComputer)vComputer, SimpleXYChartUtils.customizeMarksPainter((AxisMarksPainter.Abstract)new XYDecimalMarksPainter(chartFactor, format)), 7, 2);
        }
        XYTooltipPainter tooltipPainter = new XYTooltipPainter(SimpleXYChartUtils.createTooltipModel(chartType, itemColors, chartFactor, customFormat, storage, itemsModel));
        chart.addOverlayComponent(new XYTooltipOverlay((ChartComponent)chart, tooltipPainter));
        chart.getSelectionModel().setHoverMode(102);
        XYSelectionOverlay selectionOverlay = new XYSelectionOverlay();
        chart.addOverlayComponent(selectionOverlay);
        selectionOverlay.registerChart((ChartComponent)chart);
        chart.getSelectionModel().setMoveMode(1);
        JPanel chartPanel = new JPanel((LayoutManager)new CrossBorderLayout());
        chartPanel.add((Component)((Object)chart), new Integer[]{0});
        chartPanel.add((Component)((Object)hAxis), new Integer[]{5, 6});
        chartPanel.add((Component)((Object)vAxis), new Integer[]{7, 6});
        JPanel jPanel = chartContainer = hasAxisLabel ? new JPanel(new BorderLayout()) : chartPanel;
        if (hasAxisLabel) {
            chartPanel.setOpaque(false);
            if (xAxisDescription != null) {
                chartContainer.add((Component)SimpleXYChartUtils.createXAxisLabel(xAxisDescription), "South");
            }
            if (yAxisDescription != null) {
                chartContainer.add((Component)SimpleXYChartUtils.createYAxisLabel(yAxisDescription), "West");
            }
            chartContainer.add((Component)chartPanel, "Center");
        }
        chartContainer.setBackground(BACKGROUND_COLOR);
        JPanel captionPanel = new JPanel(new BorderLayout());
        captionPanel.setBackground(BACKGROUND_COLOR);
        if (chartTitle != null) {
            captionPanel.add((Component)SimpleXYChartUtils.createTitleLabel(chartTitle), "North");
        }
        JPanel sidePanel = new JPanel((LayoutManager)new VerticalLayout(false));
        sidePanel.setOpaque(false);
        sidePanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 10));
        JComponent legendPanel = SimpleXYChartUtils.createLegendPanel(itemColors, hideItems, itemsModel, paintersModel);
        legendPanel.setVisible(legendVisible);
        JPanel scrollerPanel = new JPanel(null){

            @Override
            public Dimension getPreferredSize() {
                Component c;
                Component component = c = this.getComponentCount() > 0 ? this.getComponent(0) : null;
                if (c != null && c.isVisible()) {
                    Dimension size = c.getSize();
                    size.width += c.getX();
                    return size;
                }
                return new Dimension();
            }
        };
        scrollerPanel.setOpaque(false);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setOpaque(false);
        bottomPanel.add((Component)scrollerPanel, "North");
        bottomPanel.add((Component)legendPanel, "South");
        JPanel chartView = new JPanel(new BorderLayout());
        chartView.setBackground(BACKGROUND_COLOR);
        chartView.add((Component)captionPanel, "North");
        chartView.add((Component)chartContainer, "Center");
        chartView.add((Component)sidePanel, "East");
        chartView.add((Component)bottomPanel, "South");
        chartView.putClientProperty("chart", (Object)chart);
        chartView.putClientProperty("sidePanel", sidePanel);
        chartView.putClientProperty("legendPanel", legendPanel);
        chartView.putClientProperty("scrollerPanel", scrollerPanel);
        if (supportsZooming) {
            SimpleXYChartUtils.setZoomingEnabled(chartView, supportsZooming);
        }
        return chartView;
    }

    public static DetailsHandle createDetailsArea(final String[] detailsItems, JComponent chartContainer) {
        final HTMLTextArea detailsArea = new HTMLTextArea();
        detailsArea.setBorder(BorderFactory.createEmptyBorder(8, 10, 0, 10));
        detailsArea.setText(SimpleXYChartUtils.createDetailsString(detailsItems, null));
        BorderLayout containerLayout = (BorderLayout)chartContainer.getLayout();
        JComponent containerNorth = (JComponent)containerLayout.getLayoutComponent("North");
        containerNorth.add((Component)detailsArea, "Center");
        final JComponent containerCenter = (JComponent)containerLayout.getLayoutComponent("Center");
        containerCenter.setBorder(BorderFactory.createEmptyBorder(6, 10, 0, 0));
        chartContainer.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                boolean visible = e.getComponent().getHeight() > DETAILS_HEIGHT_THRESHOLD;
                detailsArea.setVisible(visible);
                containerCenter.setBorder(BorderFactory.createEmptyBorder(visible ? 6 : 10, 10, 0, 0));
            }
        });
        return new DetailsHandle(){

            @Override
            public void updateDetails(String[] details) {
                try {
                    int selStart = detailsArea.getSelectionStart();
                    int selEnd = detailsArea.getSelectionEnd();
                    detailsArea.setText(SimpleXYChartUtils.createDetailsString(detailsItems, details));
                    detailsArea.select(selStart, selEnd);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    public static JComponent createLegendPanel(Color[] itemColors, boolean hideItems, SynchronousXYItemsModel itemsModel, final XYPaintersModel paintersModel) {
        JPanel legendPanel = new JPanel(new FlowLayout(3, hideItems ? 5 : 10, 0));
        legendPanel.setBackground(BACKGROUND_COLOR);
        for (int i = 0; i < itemColors.length; ++i) {
            SynchronousXYItem item = itemsModel.getItem(i);
            ColorIcon icon = new ColorIcon(itemColors[i], Color.DARK_GRAY, 10, 10);
            JComponent legendItem = null;
            if (hideItems) {
                final XYPainter painter = (XYPainter)paintersModel.getPainter((ChartItem)item);
                legendItem = new IconCheckBox(item.getName(), icon, painter.isPainting()){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension ps = super.getPreferredSize();
                        ps.height = SimpleXYChartUtils.getLegendHeight();
                        return ps;
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        painter.setPainting(this.isSelected());
                        paintersModel.painterChanged((ItemPainter)painter);
                    }
                };
            } else {
                legendItem = new JLabel(item.getName(), icon, 0){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension ps = super.getPreferredSize();
                        ps.height = SimpleXYChartUtils.getLegendHeight();
                        return ps;
                    }
                };
            }
            legendItem.setOpaque(false);
            legendPanel.add(legendItem);
        }
        JPanel legendContainer = new JPanel(new FlowLayout(4, 0, 0));
        legendContainer.setOpaque(true);
        legendContainer.setBackground(BACKGROUND_COLOR);
        legendContainer.setBorder(BorderFactory.createMatteBorder(0, 10, 0, 0, BACKGROUND_COLOR));
        legendContainer.add(legendPanel);
        return legendContainer;
    }

    public static void setZoomingEnabled(JComponent chartUI, boolean enabled) {
        SimpleXYChart chart = (SimpleXYChart)((Object)chartUI.getClientProperty("chart"));
        if (chart.isZoomingEnabled() == enabled) {
            return;
        }
        chart.setZoomingEnabled(enabled);
        JPanel sidePanel = (JPanel)chartUI.getClientProperty("sidePanel");
        JPanel scrollerPanel = (JPanel)chartUI.getClientProperty("scrollerPanel");
        if (enabled) {
            TransparentToolBar toolbar = new TransparentToolBar(false);
            for (Action action : chart.getActions()) {
                toolbar.addItem(action);
            }
            sidePanel.add((Component)toolbar);
            JScrollBar scroller = chart.getScroller();
            scroller.setSize(scroller.getPreferredSize());
            scrollerPanel.add(scroller);
            chart.putClientProperty("scroller", scroller);
        } else {
            sidePanel.removeAll();
            scrollerPanel.removeAll();
            chart.putClientProperty("scroller", null);
        }
        sidePanel.setVisible(enabled);
        chartUI.doLayout();
        chartUI.repaint();
    }

    public static void setLegendVisible(JComponent chartUI, boolean visible) {
        JPanel legendPanel = (JPanel)chartUI.getClientProperty("legendPanel");
        legendPanel.setVisible(visible);
        chartUI.doLayout();
        chartUI.repaint();
    }

    public static XYTooltipModel createTooltipModel(final int chartType, final Color[] itemColors, final double chartFactor, final NumberFormat customFormat, final XYStorage storage, final SynchronousXYItemsModel itemsModel) {
        return new XYTooltipModel(){

            @Override
            public String getTimeValue(long timestamp) {
                int timestamps = storage.getTimestampsCount();
                if (timestamps == 0) {
                    return SimpleXYChartUtils.formatTime(timestamp, timestamp, timestamp);
                }
                return SimpleXYChartUtils.formatTime(timestamp, storage.getTimestamp(0), storage.getTimestamp(timestamps - 1));
            }

            @Override
            public int getRowsCount() {
                return itemsModel.getItemsCount();
            }

            @Override
            public String getRowName(int index) {
                return itemsModel.getItem(index).getName();
            }

            @Override
            public Color getRowColor(int index) {
                return itemColors[index];
            }

            @Override
            public String getRowValue(int index, long itemValue) {
                double value = (double)itemValue * chartFactor;
                switch (chartType) {
                    case 1: {
                        return SimpleXYChartUtils.formatBytes((long)value);
                    }
                    case 2: {
                        return SimpleXYChartUtils.formatPercent(value);
                    }
                    case 3: {
                        return SimpleXYChartUtils.formatBitsPerSec((long)value);
                    }
                }
                return SimpleXYChartUtils.formatDecimal(value, customFormat);
            }
        };
    }

    public static AxisMarksPainter customizeMarksPainter(AxisMarksPainter.Abstract painter) {
        painter.setForeground(AXIS_FONT_COLOR);
        painter.setFont(SimpleXYChartUtils.smallerFont(painter.getFont()));
        return painter;
    }

    public static String formatDecimal(double value) {
        return DECIMAL_FORMATTER.format(value);
    }

    public static String formatDecimal(double value, NumberFormat format) {
        return format != null ? format.format(value) : SimpleXYChartUtils.formatDecimal(value);
    }

    public static String formatBytes(long value) {
        String bytesFormat = NbBundle.getMessage(SimpleXYChartUtils.class, (String)"SimpleXYChartUtils_BytesFormat");
        return MessageFormat.format(bytesFormat, SimpleXYChartUtils.formatDecimal(value));
    }

    public static String formatBitsPerSec(long value) {
        String bpsFormat = NbBundle.getMessage(SimpleXYChartUtils.class, (String)"SimpleXYChartUtils_BitsPerSecFormat");
        return MessageFormat.format(bpsFormat, SimpleXYChartUtils.formatDecimal(value));
    }

    public static String formatPercent(double value) {
        return PERCENT_FORMATTER.format(value / 100.0);
    }

    public static String formatTime(long timestamp, long startTime, long endTime) {
        String formatString = TimeAxisUtils.getFormatString((long)1000L, (long)startTime, (long)endTime);
        return SimpleXYChartUtils.getFormat(formatString).format(new Date(timestamp));
    }

    public static Font smallerFont(Font font) {
        return new Font(font.getName(), font.getStyle(), font.getSize() - 2);
    }

    public static Font boldFont(Font font) {
        return new Font(font.getName(), 1, font.getSize());
    }

    private static String createDetailsString(String[] detailsItems, String[] values) {
        StringBuilder sb = new StringBuilder();
        String itemFormat = NbBundle.getMessage(SimpleXYChartUtils.class, (String)"SimpleXYChartUtils_DetailsItemFormat");
        sb.append("<table border='0' cellpadding='0' cellspacing='3' width='100%'>");
        sb.append("<tr>");
        for (int i = 0; i < detailsItems.length; ++i) {
            if (detailsItems.length == 1) {
                sb.append("<td><nobr>");
            } else {
                sb.append("<td width='50%'><nobr>");
            }
            sb.append(MessageFormat.format(itemFormat, detailsItems[i], values == null ? "" : values[i]));
            sb.append("</nobr></td>");
            if (i % 2 != 1 || i + 1 >= detailsItems.length) continue;
            sb.append("</tr><tr>");
        }
        sb.append("</tr>");
        sb.append("</table>");
        return sb.toString();
    }

    private static synchronized Format getFormat(String formatString) {
        Format format = FORMATS.get(formatString);
        if (format == null) {
            format = new SimpleDateFormat(formatString);
            FORMATS.put(formatString, format);
        }
        return format;
    }

    private static synchronized int getLegendHeight() {
        if (LEGEND_HEIGHT == -1) {
            LEGEND_HEIGHT = Math.max(new JLabel((String)"X").getPreferredSize().height, new JCheckBox((String)"X").getPreferredSize().height);
        }
        return LEGEND_HEIGHT;
    }

    private static JLabel createTitleLabel(String text) {
        JLabel label = SimpleXYChartUtils.createRotatedLabel(text, RotateLabelUI.R0);
        label.setBorder(BorderFactory.createEmptyBorder(8, 3, 0, 3));
        label.setFont(SimpleXYChartUtils.boldFont(label.getFont()));
        return label;
    }

    private static JLabel createXAxisLabel(String text) {
        JLabel label = SimpleXYChartUtils.createRotatedLabel(text, RotateLabelUI.R0);
        label.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return label;
    }

    private static JLabel createYAxisLabel(String text) {
        JLabel label = SimpleXYChartUtils.createRotatedLabel(text, RotateLabelUI.R270);
        label.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return label;
    }

    private static JLabel createRotatedLabel(String text, final LabelUI labelUI) {
        return new JLabel(text, 0){

            @Override
            public void updateUI() {
                if (this.getUI() != labelUI) {
                    this.setUI(labelUI);
                }
            }
        };
    }

    private static ChartDecorator createMaxHeapDecorator(final long limitYValue) {
        return new ChartDecorator(){

            public void paint(Graphics2D g, Rectangle dirtyArea, ChartContext context) {
                int limitHeight = Utils.checkedInt((double)context.getViewY((double)limitYValue));
                if (limitHeight <= context.getViewportHeight()) {
                    g.setColor(HEAP_LIMIT_FILL_COLOR);
                    if (context.isBottomBased()) {
                        g.fillRect(0, 0, context.getViewportWidth(), limitHeight);
                    } else {
                        g.fillRect(0, limitHeight, context.getViewportWidth(), context.getViewportHeight() - limitHeight);
                    }
                }
            }
        };
    }

    static {
        DECIMAL_FORMATTER.setGroupingUsed(true);
        DECIMAL_FORMATTER.setMaximumFractionDigits(2);
        PERCENT_FORMATTER = NumberFormat.getPercentInstance();
        PERCENT_FORMATTER.setMinimumFractionDigits(1);
        PERCENT_FORMATTER.setMaximumIntegerDigits(3);
        DEFAULT_BUFFER_STEP = 50;
        AXIS_FONT_COLOR = !UISupport.isDarkResultsBackground() ? new Color(90, 90, 90) : new Color(165, 165, 165);
        BACKGROUND_COLOR = UISupport.getDefaultBackground();
        VALUES_SPACING = Math.max(new TimeMarksPainter().getFont().getSize(), 15) + 10;
        TIMELINE_SPACING = 80;
        LEGEND_HEIGHT = -1;
        DETAILS_HEIGHT_THRESHOLD = 180;
        FORMATS = new HashMap<String, Format>();
        HEAP_LIMIT_FILL_COLOR = !UISupport.isDarkResultsBackground() ? new Color(220, 220, 220) : new Color(100, 100, 100);
    }

    private static class IconCheckBox
    extends JCheckBox {
        private static final int CHECKBOX_OFFSET = IconCheckBox.getCheckBoxOffset();
        private final JCheckBox renderer;

        IconCheckBox(String text, Icon icon, boolean selected) {
            this.renderer = new JCheckBox(text, icon){

                @Override
                public boolean hasFocus() {
                    return this.hasFocus();
                }
            };
            this.renderer.setOpaque(false);
            this.renderer.setBorderPainted(false);
            this.setSelected(selected);
            this.setBorderPainted(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.translate(this.renderer.getX(), this.renderer.getY());
            this.renderer.paint(g);
            g.translate(-this.renderer.getX(), -this.renderer.getY());
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            Dimension d = super.getPreferredSize();
            this.renderer.setBounds(d.width - CHECKBOX_OFFSET, 0, width - d.width + CHECKBOX_OFFSET, height);
            super.setBounds(x, y, width, height);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width += this.renderer.getPreferredSize().width - CHECKBOX_OFFSET;
            return d;
        }

        private static int getCheckBoxOffset() {
            if (UISupport.isWindowsLookAndFeel()) {
                return 3;
            }
            if (UISupport.isNimbusLookAndFeel()) {
                return -3;
            }
            if (UISupport.isMetalLookAndFeel()) {
                return 3;
            }
            if (UISupport.isAquaLookAndFeel()) {
                return 6;
            }
            return 0;
        }
    }

    public static interface DetailsHandle {
        public void updateDetails(String[] var1);
    }
}

