/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.general;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.plugin.manipulators.general.ui.MergeNodeDuplicatesUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.general.PluginGeneralActionsManipulator;
import org.gephi.datalab.spi.rows.merge.AttributeRowsMergeStrategy;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Table;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class MergeNodeDuplicates
implements PluginGeneralActionsManipulator {
    public static final String DELETE_MERGED_NODES_SAVED_PREFERENCES = "MergeNodeDuplicates_DeleteMergedNodes";
    public static final String CASE_SENSITIVE_SAVED_PREFERENCES = "MergeNodeDuplicates_CaseSensitive";
    private List<List<Node>> duplicateGroups;
    private boolean deleteMergedNodes;
    private boolean caseSensitive;
    private Column[] columns;
    private AttributeRowsMergeStrategy[] mergeStrategies;

    public void execute() {
        Graph graph = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraph();
        GraphElementsController gec = (GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class);
        for (List<Node> nodes : this.duplicateGroups) {
            gec.mergeNodes(graph, nodes.toArray(new Node[0]), nodes.get(0), this.columns, this.mergeStrategies, this.deleteMergedNodes);
        }
        NbPreferences.forModule(MergeNodeDuplicates.class).putBoolean(DELETE_MERGED_NODES_SAVED_PREFERENCES, this.deleteMergedNodes);
        NbPreferences.forModule(MergeNodeDuplicates.class).putBoolean(CASE_SENSITIVE_SAVED_PREFERENCES, this.caseSensitive);
    }

    public String getName() {
        return NbBundle.getMessage(MergeNodeDuplicates.class, (String)"MergeNodeDuplicates.name");
    }

    public String getDescription() {
        return "MergeNodeDuplicates.description";
    }

    public boolean canExecute() {
        return ((GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class)).getNodesCount() > 0;
    }

    public ManipulatorUI getUI() {
        Table nodeTable = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable();
        ArrayList<Column> columnsList = new ArrayList<Column>();
        for (Column column : nodeTable) {
            if (column.isReadOnly()) continue;
            columnsList.add(column);
        }
        this.columns = columnsList.toArray(new Column[0]);
        this.mergeStrategies = new AttributeRowsMergeStrategy[this.columns.length];
        this.deleteMergedNodes = NbPreferences.forModule(MergeNodeDuplicates.class).getBoolean(DELETE_MERGED_NODES_SAVED_PREFERENCES, true);
        this.caseSensitive = NbPreferences.forModule(MergeNodeDuplicates.class).getBoolean(CASE_SENSITIVE_SAVED_PREFERENCES, true);
        return new MergeNodeDuplicatesUI();
    }

    public int getType() {
        return 100;
    }

    public int getPosition() {
        return 0;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"org/gephi/datalab/plugin/manipulators/resources/merge.png", (boolean)true);
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public boolean isDeleteMergedNodes() {
        return this.deleteMergedNodes;
    }

    public void setDeleteMergedNodes(boolean deleteMergedNodes) {
        this.deleteMergedNodes = deleteMergedNodes;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public List<List<Node>> getDuplicateGroups() {
        return this.duplicateGroups;
    }

    public void setDuplicateGroups(List<List<Node>> duplicateGroups) {
        this.duplicateGroups = duplicateGroups;
    }

    public AttributeRowsMergeStrategy[] getMergeStrategies() {
        return this.mergeStrategies;
    }

    public void setMergeStrategies(AttributeRowsMergeStrategy[] mergeStrategies) {
        this.mergeStrategies = mergeStrategies;
    }
}

