/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TableObserver;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ColumnStore;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.TableLockImpl;
import org.gephi.graph.impl.TableObserverImpl;

public class TableImpl<T extends Element>
implements Collection<Column>,
Table {
    protected final ColumnStore<T> store;

    public TableImpl(Class<T> elementType, boolean indexed) {
        this(null, elementType, indexed);
    }

    public TableImpl(GraphStore graphStore, Class<T> elementType, boolean indexed) {
        this.store = new ColumnStore<T>(graphStore, elementType, indexed);
    }

    @Override
    public Column addColumn(String id, Class type) {
        return this.addColumn(id, null, type, Origin.DATA, null, true);
    }

    @Override
    public Column addColumn(String id, Class type, Origin origin) {
        return this.addColumn(id, null, type, origin, null, true);
    }

    @Override
    public Column addColumn(String id, String title, Class type, Object defaultValue) {
        return this.addColumn(id, title, type, Origin.DATA, defaultValue, true);
    }

    @Override
    public Column addColumn(String id, String title, Class type, Origin origin, Object defaultValue, boolean indexed) {
        this.checkValidId(id);
        this.checkSupportedTypes(type);
        this.checkDefaultValue(defaultValue, type);
        type = AttributeUtils.getStandardizedType(type);
        if (defaultValue != null) {
            defaultValue = AttributeUtils.standardizeValue(defaultValue);
        }
        if (title == null || title.isEmpty()) {
            title = id;
        }
        id = id.toLowerCase();
        if (indexed && this.store.indexStore == null) {
            indexed = false;
        }
        ColumnImpl column = new ColumnImpl(this, id, type, title, defaultValue, origin, indexed, false);
        this.store.addColumn(column);
        return column;
    }

    @Override
    public boolean add(Column column) {
        this.store.checkNonNullColumnObject(column);
        this.store.addColumn(column);
        return true;
    }

    @Override
    public int countColumns() {
        return this.store.size();
    }

    @Override
    public int countColumns(Origin origin) {
        return this.store.size(origin);
    }

    @Override
    public int size() {
        return this.countColumns();
    }

    @Override
    public boolean isEmpty() {
        return this.countColumns() == 0;
    }

    @Override
    public Iterator<Column> iterator() {
        return this.store.iterator();
    }

    @Override
    public void doBreak() {
        this.store.doBreak();
    }

    @Override
    public Column[] toArray() {
        return this.store.toArray();
    }

    @Override
    public <K> K[] toArray(K[] array) {
        this.store.checkNonNullObject(array);
        ColumnImpl[] columns = this.store.toArray();
        if (array.length < this.size()) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size());
        }
        for (int i = 0; i < columns.length; ++i) {
            array[i] = columns[i];
        }
        return array;
    }

    @Override
    public List<Column> toList() {
        return this.store.toList();
    }

    @Override
    public Column getColumn(int index) {
        return this.store.getColumnByIndex(index);
    }

    @Override
    public ColumnImpl getColumn(String id) {
        return this.store.getColumn(id.toLowerCase());
    }

    @Override
    public boolean hasColumn(String id) {
        return this.store.hasColumn(id.toLowerCase());
    }

    @Override
    public boolean contains(Object o) {
        this.store.checkNonNullColumnObject(o);
        ColumnImpl column = (ColumnImpl)o;
        return this.hasColumn(column.getId());
    }

    @Override
    public void removeColumn(Column column) {
        this.store.removeColumn(column);
    }

    @Override
    public void removeColumn(String id) {
        this.store.removeColumn(id.toLowerCase());
    }

    @Override
    public boolean remove(Object o) {
        this.store.checkNonNullColumnObject(o);
        this.removeColumn((ColumnImpl)o);
        return true;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This method from Collection isn't implemented");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("This method from Collection isn't implemented");
    }

    @Override
    public boolean addAll(Collection<? extends Column> c) {
        throw new UnsupportedOperationException("This method from Collection isn't implemented");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("This method from Collection isn't implemented");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("This method from Collection isn't implemented");
    }

    @Override
    public TableObserver createTableObserver(boolean withDiff) {
        return this.store.createTableObserver(this, withDiff);
    }

    @Override
    public Class getElementClass() {
        return this.store.elementType;
    }

    @Override
    public Graph getGraph() {
        return this.store.graphStore;
    }

    @Override
    public boolean isNodeTable() {
        return Node.class.equals(this.store.elementType);
    }

    @Override
    public boolean isEdgeTable() {
        return Edge.class.equals(this.store.elementType);
    }

    @Override
    public TableLockImpl getLock() {
        return this.store.lock;
    }

    public void destroyTableObserver(TableObserver observer) {
        this.checkableTableObserver(observer);
        this.store.destroyTablesObserver((TableObserverImpl)observer);
    }

    public boolean deepEquals(TableImpl<T> obj) {
        if (obj == null) {
            return false;
        }
        return this.store == obj.store || this.store != null && this.store.deepEquals(obj.store);
    }

    public int deepHashCode() {
        int hash = 3;
        hash = 71 * hash + (this.store != null ? this.store.deepHashCode() : 0);
        return hash;
    }

    private void checkValidId(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (id.isEmpty()) {
            throw new IllegalArgumentException("The column id can't be empty.");
        }
        if (this.store.hasColumn(id.toLowerCase())) {
            throw new IllegalArgumentException("The column '" + id + "' already existing in the table");
        }
    }

    private void checkSupportedTypes(Class type) {
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unknown type " + type.getName());
        }
    }

    private void checkCollection(Collection<?> collection) {
        if (collection == this) {
            throw new IllegalArgumentException("Can't pass itself");
        }
    }

    private void checkDefaultValue(Object defaultValue, Class type) {
        if (defaultValue != null && defaultValue.getClass() != type) {
            throw new IllegalArgumentException("The default value type cannot be cast to the type");
        }
    }

    private void checkableTableObserver(TableObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        if (!(observer instanceof TableObserverImpl)) {
            throw new ClassCastException("The observer should be a TableObserverImpl instance");
        }
        if (((TableObserverImpl)observer).table != this) {
            throw new RuntimeException("The observer doesn't belong to this table");
        }
    }
}

