/*
* THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
*
* Copyright (C) 2018 Apple Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1. Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
* THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "config.h"
#include "WebPreferences.h"

#include "WebPreferencesDefinitions.h"
#include "WebPreferencesKeys.h"

namespace WebKit {

const Vector<RefPtr<API::Object>>& WebPreferences::internalDebugFeatures()
{
    static NeverDestroyed<Vector<RefPtr<API::Object>>> features(std::initializer_list<RefPtr<API::Object>> {
        API::InternalDebugFeature::create("ARIA Reflection", "AriaReflectionEnabled", "ARIA Reflection support", DEFAULT_VALUE_FOR_AriaReflectionEnabled, false),
#if USE(CORE_IMAGE)
        API::InternalDebugFeature::create("Accelerated Filter Rendering", "AcceleratedFiltersEnabled", "Accelerated CSS and SVG filter rendering", DEFAULT_VALUE_FOR_AcceleratedFiltersEnabled, false),
#endif
        API::InternalDebugFeature::create("Accessibility support for display: contents elements", "CSSDisplayContentsAXSupportEnabled", "Enable work-in-progress accessibility support for display: contents elements", DEFAULT_VALUE_FOR_CSSDisplayContentsAXSupportEnabled, false),
#if PLATFORM(IOS_FAMILY)
        API::InternalDebugFeature::create("Allow Viewport Shrink to Fit Content", "AllowViewportShrinkToFitContent", "Allow the viewport shrink to fit content heuristic when appropriate", DEFAULT_VALUE_FOR_AllowViewportShrinkToFitContent, false),
#endif
#if ENABLE(APPLE_PAY_REMOTE_UI)
        API::InternalDebugFeature::create("Apple Pay Remote UI", "ApplePayRemoteUIEnabled", "Enable Apple Pay Remote UI", DEFAULT_VALUE_FOR_ApplePayRemoteUIEnabled, false),
#endif
        API::InternalDebugFeature::create("Async Frame Scrolling", "AsyncFrameScrollingEnabled", "Perform frame scrolling off the main thread", DEFAULT_VALUE_FOR_AsyncFrameScrollingEnabled, false),
        API::InternalDebugFeature::create("Async Overflow Scrolling", "AsyncOverflowScrollingEnabled", "Perform overflow scrolling off the main thread", DEFAULT_VALUE_FOR_AsyncOverflowScrollingEnabled, false),
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        API::InternalDebugFeature::create("CG Display Lists: DOM Rendering", "UseCGDisplayListsForDOMRendering", "Use CG Display Lists for DOM rendering", DEFAULT_VALUE_FOR_UseCGDisplayListsForDOMRendering, false),
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        API::InternalDebugFeature::create("CG Display Lists: Replay for Testing", "ReplayCGDisplayListsIntoBackingStore", "Replay CG Display Lists into layer contents for testing", DEFAULT_VALUE_FOR_ReplayCGDisplayListsIntoBackingStore, false),
#endif
        API::InternalDebugFeature::create("CSS Logical Properties and Values", "CSSLogicalEnabled", "Enable CSS Logical Properties and Values", DEFAULT_VALUE_FOR_CSSLogicalEnabled, false),
        API::InternalDebugFeature::create("CSSOM View Scrolling API", "CSSOMViewScrollingAPIEnabled", "Implement standard behavior for scrollLeft, scrollTop, scrollWidth, scrollHeight, scrollTo, scrollBy and scrollingElement.", DEFAULT_VALUE_FOR_CSSOMViewScrollingAPIEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("Capture audio in UI Process", "CaptureAudioInUIProcessEnabled", "Enable audio capture in UI Process", DEFAULT_VALUE_FOR_CaptureAudioInUIProcessEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("Capture video in UI Process", "CaptureVideoInUIProcessEnabled", "Enable video capture in UI Process", DEFAULT_VALUE_FOR_CaptureVideoInUIProcessEnabled, false),
#endif
#if ENABLE(INPUT_TYPE_COLOR)
        API::InternalDebugFeature::create("Color Inputs", "InputTypeColorEnabled", "Enable input elements of type color", DEFAULT_VALUE_FOR_InputTypeColorEnabled, false),
#endif
        API::InternalDebugFeature::create("Cookie Consent API", "CookieConsentAPIEnabled", "Enable cookie consent API", DEFAULT_VALUE_FOR_CookieConsentAPIEnabled, false),
        API::InternalDebugFeature::create("DOM Paste Access Requests", "DOMPasteAccessRequestsEnabled", "Enable DOM Paste Access Requests", DEFAULT_VALUE_FOR_DOMPasteAccessRequestsEnabled, false),
#if PLATFORM(IOS_FAMILY)
        API::InternalDebugFeature::create("DTTZ also when root", "ZoomOnDoubleTapWhenRoot", "Double taps zoom, even if we dispatched a click on the root nodes", DEFAULT_VALUE_FOR_ZoomOnDoubleTapWhenRoot, false),
#endif
#if PLATFORM(IOS_FAMILY)
        API::InternalDebugFeature::create("DTTZ always", "AlwaysZoomOnDoubleTap", "Double taps zoom, even if we dispatched a click anywhere", DEFAULT_VALUE_FOR_AlwaysZoomOnDoubleTap, false),
#endif
#if ENABLE(DATALIST_ELEMENT)
        API::InternalDebugFeature::create("DataList Element", "DataListElementEnabled", "Enable datalist elements", DEFAULT_VALUE_FOR_DataListElementEnabled, false),
#endif
#if ENABLE(INPUT_TYPE_DATE)
        API::InternalDebugFeature::create("Date Input", "InputTypeDateEnabled", "Enable input elements of type date", DEFAULT_VALUE_FOR_InputTypeDateEnabled, false),
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
        API::InternalDebugFeature::create("Date/Time inputs have editable components", "DateTimeInputsEditableComponentsEnabled", "Enable multiple editable components in date/time inputs", DEFAULT_VALUE_FOR_DateTimeInputsEditableComponentsEnabled, false),
#endif
        API::InternalDebugFeature::create("Enable ICE Candidate Filtering", "ICECandidateFilteringEnabled", "Enable ICE Candidate Filtering", DEFAULT_VALUE_FOR_ICECandidateFilteringEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("Enable Mock Capture Devices", "MockCaptureDevicesEnabled", "Enable Mock Capture Devices", DEFAULT_VALUE_FOR_MockCaptureDevicesEnabled, false),
#endif
        API::InternalDebugFeature::create("Enable PDF.js viewer", "PdfJSViewerEnabled", "Enable PDF.js viewer", DEFAULT_VALUE_FOR_PdfJSViewerEnabled, false),
        API::InternalDebugFeature::create("Enter Key Hint", "EnterKeyHintEnabled", "Enable the enterKeyHint HTML attribute", DEFAULT_VALUE_FOR_EnterKeyHintEnabled, false),
        API::InternalDebugFeature::create("EventHandler driven smooth keyboard scrolling", "EventHandlerDrivenSmoothKeyboardScrollingEnabled", "Enable EventHandler driven smooth keyboard scrolling", DEFAULT_VALUE_FOR_EventHandlerDrivenSmoothKeyboardScrollingEnabled, false),
#if PLATFORM(IOS_FAMILY)
        API::InternalDebugFeature::create("Fast clicks beat DTTZ", "PreferFasterClickOverDoubleTap", "Prefer a faster click over a double tap", DEFAULT_VALUE_FOR_PreferFasterClickOverDoubleTap, false),
#endif
#if PLATFORM(IOS_FAMILY)
        API::InternalDebugFeature::create("Fast clicks", "FasterClicksEnabled", "Support faster clicks on zoomable pages", DEFAULT_VALUE_FOR_FasterClicksEnabled, false),
#endif
        API::InternalDebugFeature::create("Filter HTTP Response for Web Processes", "RestrictedHTTPResponseAccess", "Enable HTTP Response filtering for Web Processes", DEFAULT_VALUE_FOR_RestrictedHTTPResponseAccess, false),
        API::InternalDebugFeature::create("Frame flattening", "FrameFlatteningEnabled", "Enable frame flattening, which adjusts the height of an iframe to fit its contents", DEFAULT_VALUE_FOR_FrameFlatteningEnabled, false),
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        API::InternalDebugFeature::create("Full next-generation layout (LFC)", "LayoutFormattingContextEnabled", "Enable full next-generation layout (LFC)", DEFAULT_VALUE_FOR_LayoutFormattingContextEnabled, false),
#endif
#if ENABLE(FULLSCREEN_API)
        API::InternalDebugFeature::create("Fullscreen API", "FullScreenEnabled", "Fullscreen API", DEFAULT_VALUE_FOR_FullScreenEnabled, EXPERIMENTAL_FULLSCREEN_API_HIDDEN),
#endif
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("GPU Process: Audio Capture", "CaptureAudioInGPUProcessEnabled", "Enable audio capture in GPU Process", DEFAULT_VALUE_FOR_CaptureAudioInGPUProcessEnabled, false),
#endif
#if ENABLE(GPU_PROCESS) && !(PLATFORM(GTK) || PLATFORM(WPE))
        API::InternalDebugFeature::create("GPU Process: Canvas Rendering", "UseGPUProcessForCanvasRenderingEnabled", "Enable canvas rendering in GPU Process", DEFAULT_VALUE_FOR_UseGPUProcessForCanvasRenderingEnabled, false),
#endif
#if ENABLE(GPU_PROCESS) && !USE(GSTREAMER)
        API::InternalDebugFeature::create("GPU Process: Media", "UseGPUProcessForMediaEnabled", "Do all media loading and playback in the GPU Process", DEFAULT_VALUE_FOR_UseGPUProcessForMediaEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("GPU Process: Video Capture", "CaptureVideoInGPUProcessEnabled", "Enable video capture in GPU Process", DEFAULT_VALUE_FOR_CaptureVideoInGPUProcessEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::InternalDebugFeature::create("GPU Process: WebRTC Platform Codecs", "WebRTCPlatformCodecsInGPUProcessEnabled", "Enable WebRTC Platform Codecs in GPU Process", DEFAULT_VALUE_FOR_WebRTCPlatformCodecsInGPUProcessEnabled, false),
#endif
#if ENABLE(IPC_TESTING_API)
        API::InternalDebugFeature::create("IPC Testing API", "IPCTestingAPIEnabled", "Enable IPC Testing API for JavaScript", DEFAULT_VALUE_FOR_IPCTestingAPIEnabled, false),
#endif
#if ENABLE(TEXT_AUTOSIZING)
        API::InternalDebugFeature::create("Idempotent Text Autosizing", "TextAutosizingUsesIdempotentMode", "Use idempotent text autosizing mode", DEFAULT_VALUE_FOR_TextAutosizingUsesIdempotentMode, false),
#endif
#if ENABLE(IMAGE_ANALYSIS)
        API::InternalDebugFeature::create("Image analysis markup", "ImageAnalysisMarkupEnabled", "Enable image analysis markup", DEFAULT_VALUE_FOR_ImageAnalysisMarkupEnabled, false),
#endif
#if ENABLE(IMAGE_ANALYSIS)
        API::InternalDebugFeature::create("Image analysis queue", "ImageAnalysisQueueEnabled", "Enable image analysis queue", DEFAULT_VALUE_FOR_ImageAnalysisQueueEnabled, false),
#endif
#if ENABLE(IMAGE_ANALYSIS)
        API::InternalDebugFeature::create("Inline Text Selection in Images", "PreferInlineTextSelectionInImages", "Prefer inline text selection in images over using the context menu", DEFAULT_VALUE_FOR_PreferInlineTextSelectionInImages, false),
#endif
#if ENABLE(LAYER_BASED_SVG_ENGINE)
        API::InternalDebugFeature::create("Layer-based SVG Engine (LBSE)", "LayerBasedSVGEngineEnabled", "Enable next-generation layer-based SVG Engine (LBSE)", DEFAULT_VALUE_FOR_LayerBasedSVGEngineEnabled, false),
#endif
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
        API::InternalDebugFeature::create("Legacy -webkit-overflow-scrolling property", "LegacyOverflowScrollingTouchEnabled", "Support the legacy -webkit-overflow-scrolling CSS property", DEFAULT_VALUE_FOR_LegacyOverflowScrollingTouchEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("Limit Media Capture to Secure Sites", "MediaCaptureRequiresSecureConnection", "Limit Media Capture to Secure Sites", DEFAULT_VALUE_FOR_MediaCaptureRequiresSecureConnection, false),
#endif
        API::InternalDebugFeature::create("Live Ranges in Selection", "LiveRangeSelectionEnabled", "Live range behavior for ranges in the Selection object", DEFAULT_VALUE_FOR_LiveRangeSelectionEnabled, false),
        API::InternalDebugFeature::create("Momentum Scrolling Animator", "MomentumScrollingAnimatorEnabled", "Generate momentum events in WebKit instead of using those delivered by the system", DEFAULT_VALUE_FOR_MomentumScrollingAnimatorEnabled, false),
#if ENABLE(INPUT_TYPE_MONTH)
        API::InternalDebugFeature::create("Month Input", "InputTypeMonthEnabled", "Enable input elements of type month", DEFAULT_VALUE_FOR_InputTypeMonthEnabled, false),
#endif
#if ENABLE(TOUCH_EVENTS)
        API::InternalDebugFeature::create("Mouse events simulation", "MouseEventsSimulationEnabled", "Enable mouse events dispatch along with touch events on iOS", DEFAULT_VALUE_FOR_MouseEventsSimulationEnabled, false),
#endif
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        API::InternalDebugFeature::create("Next-generation line layout integration (LFC)", "LayoutFormattingContextIntegrationEnabled", "Enable next-generation line layout integration (LFC)", DEFAULT_VALUE_FOR_LayoutFormattingContextIntegrationEnabled, false),
#endif
#if ENABLE(NOTIFICATION_EVENT)
        API::InternalDebugFeature::create("NotificationEvent support", "NotificationEventEnabled", "NotificationEvent and ServiceWorkerRegistration.showNotification() support", DEFAULT_VALUE_FOR_NotificationEventEnabled, false),
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
        API::InternalDebugFeature::create("OffscreenCanvas in Workers", "OffscreenCanvasInWorkersEnabled", "Support for the OffscreenCanvas APIs in Workers", DEFAULT_VALUE_FOR_OffscreenCanvasInWorkersEnabled, false),
#endif
#if ENABLE(OFFSCREEN_CANVAS)
        API::InternalDebugFeature::create("OffscreenCanvas", "OffscreenCanvasEnabled", "Support for the OffscreenCanvas APIs", DEFAULT_VALUE_FOR_OffscreenCanvasEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("Require a user gesture for speaker selection", "SpeakerSelectionRequiresUserGesture", "Require a user gesture for speaker selection", DEFAULT_VALUE_FOR_SpeakerSelectionRequiresUserGesture, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::InternalDebugFeature::create("Require focus to start getUserMedia", "GetUserMediaRequiresFocus", "Require focus to start getUserMedia", DEFAULT_VALUE_FOR_GetUserMediaRequiresFocus, false),
#endif
        API::InternalDebugFeature::create("Resource Load Scheduling", "ResourceLoadSchedulingEnabled", "Network process side priority and visibility based resource load scheduling", DEFAULT_VALUE_FOR_ResourceLoadSchedulingEnabled, false),
        API::InternalDebugFeature::create("Scroll Performance Testing Enabled", "ScrollingPerformanceTestingEnabled", "Enable behaviors used by scrolling performance tests", DEFAULT_VALUE_FOR_ScrollingPerformanceTestingEnabled, false),
        API::InternalDebugFeature::create("Secure Context Checks", "SecureContextChecksEnabled", "Allow access to HTTPS-only Web APIs over HTTP", DEFAULT_VALUE_FOR_SecureContextChecksEnabled, false),
        API::InternalDebugFeature::create("Selection Flipping", "SelectionFlippingEnabled", "Enable Selection Flipping", DEFAULT_VALUE_FOR_SelectionFlippingEnabled, false),
#if ENABLE(SERVICE_WORKER)
        API::InternalDebugFeature::create("Service Workers", "ServiceWorkersEnabled", "Enable Service Workers", DEFAULT_VALUE_FOR_ServiceWorkersEnabled, false),
#endif
        API::InternalDebugFeature::create("Simple line layout", "SimpleLineLayoutEnabled", "Enable simple line layout path (SLL)", DEFAULT_VALUE_FOR_SimpleLineLayoutEnabled, false),
#if ENABLE(IMAGE_ANALYSIS)
        API::InternalDebugFeature::create("Text Recognition Enhancements", "TextRecognitionEnhancementsEnabled", "Enable Text Recognition Enhancements", DEFAULT_VALUE_FOR_TextRecognitionEnhancementsEnabled, false),
#endif
#if ENABLE(INPUT_TYPE_TIME)
        API::InternalDebugFeature::create("Time Input", "InputTypeTimeEnabled", "Enable input elements of type time", DEFAULT_VALUE_FOR_InputTypeTimeEnabled, false),
#endif
        API::InternalDebugFeature::create("UndoManager DOM API", "UndoManagerAPIEnabled", "Enable the UndoManager DOM API", DEFAULT_VALUE_FOR_UndoManagerAPIEnabled, false),
        API::InternalDebugFeature::create("Upgrade known hosts to HTTPS", "UpgradeKnownHostsToHTTPSEnabled", "Upgrade known hosts to HTTPS", DEFAULT_VALUE_FOR_UpgradeKnownHostsToHTTPSEnabled, false),
#if ENABLE(ARKIT_INLINE_PREVIEW)
        API::InternalDebugFeature::create("Use ARKit for <model>", "UseARKitForModel", "Use ARKit for <model>", DEFAULT_VALUE_FOR_UseARKitForModel, false),
#endif
#if HAVE(SCENEKIT)
        API::InternalDebugFeature::create("Use SceneKit for <model>", "UseSceneKitForModel", "Use SceneKit for <model>", DEFAULT_VALUE_FOR_UseSceneKitForModel, false),
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        API::InternalDebugFeature::create("Use iTunes AVOutputContext", "UseiTunesAVOutputContext", "Use iTunes AVOutputContext", DEFAULT_VALUE_FOR_UseiTunesAVOutputContext, false),
#endif
        API::InternalDebugFeature::create("Web API Statistics", "WebAPIStatisticsEnabled", "Enable Web API Statistics", DEFAULT_VALUE_FOR_WebAPIStatisticsEnabled, false),
#if ENABLE(WEB_RTC)
        API::InternalDebugFeature::create("WebRTC DTMF", "WebRTCDTMFEnabled", "Enable WebRTC DTMF", DEFAULT_VALUE_FOR_WebRTCDTMFEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::InternalDebugFeature::create("WebRTC H264 Hardware encoder", "WebRTCH264HardwareEncoderEnabled", "Enable H264 Hardware encoder", DEFAULT_VALUE_FOR_WebRTCH264HardwareEncoderEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::InternalDebugFeature::create("WebRTC H264 Simulcast", "WebRTCH264SimulcastEnabled", "Enable WebRTC H264 Simulcast", DEFAULT_VALUE_FOR_WebRTCH264SimulcastEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::InternalDebugFeature::create("WebRTC Remote Video Frame", "WebRTCRemoteVideoFrameEnabled", "Enable WebRTC Remote Video Frame", DEFAULT_VALUE_FOR_WebRTCRemoteVideoFrameEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::InternalDebugFeature::create("WebRTC mDNS ICE candidates", "WebRTCMDNSICECandidatesEnabled", "Enable WebRTC mDNS ICE candidates", DEFAULT_VALUE_FOR_WebRTCMDNSICECandidatesEnabled, false),
#endif
#if ENABLE(INPUT_TYPE_WEEK)
        API::InternalDebugFeature::create("Week Input", "InputTypeWeekEnabled", "Enable input elements of type week", DEFAULT_VALUE_FOR_InputTypeWeekEnabled, false),
#endif
        API::InternalDebugFeature::create("[ITP Live-On] 1 Hour Timeout For Non-Cookie Data Removal", "IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled", "Remove all non-cookie website data after just one hour of no user interaction when Intelligent Tracking Prevention is enabled", DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled, false),
        API::InternalDebugFeature::create("[ITP Repro] 30 Second Timeout For Non-Cookie Data Removal", "IsFirstPartyWebsiteDataRemovalReproTestingEnabled", "Remove all non-cookie website data after just 30 seconds of no user interaction when Intelligent Tracking Prevention is enabled", DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalReproTestingEnabled, false),
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
        API::InternalDebugFeature::create("datetime-local Inputs", "InputTypeDateTimeLocalEnabled", "Enable input elements of type datetime-local", DEFAULT_VALUE_FOR_InputTypeDateTimeLocalEnabled, false),
#endif
#if ENABLE(IOS_FORM_CONTROL_REFRESH)
        API::InternalDebugFeature::create("iOS Form Control Refresh", "IOSFormControlRefreshEnabled", "Enable the new appearance for form controls on iOS", DEFAULT_VALUE_FOR_IOSFormControlRefreshEnabled, false),
#endif
        API::InternalDebugFeature::create("lh / rlh units", "LineHeightUnitsEnabled", "Enable the lh and lhr units", DEFAULT_VALUE_FOR_LineHeightUnitsEnabled, false),
    });

    return features;
}

bool WebPreferences::isFeatureEnabled(const API::InternalDebugFeature& feature) const
{
    struct FeatureGetterMapping {
        const char* name;
        bool (WebPreferences::*function) () const;
    };

    static FeatureGetterMapping getters[] = {
        { "AriaReflectionEnabled", &WebPreferences::ariaReflectionEnabled },
#if USE(CORE_IMAGE)
        { "AcceleratedFiltersEnabled", &WebPreferences::acceleratedFiltersEnabled },
#endif
        { "CSSDisplayContentsAXSupportEnabled", &WebPreferences::cssDisplayContentsAXSupportEnabled },
#if PLATFORM(IOS_FAMILY)
        { "AllowViewportShrinkToFitContent", &WebPreferences::allowViewportShrinkToFitContent },
#endif
#if ENABLE(APPLE_PAY_REMOTE_UI)
        { "ApplePayRemoteUIEnabled", &WebPreferences::applePayRemoteUIEnabled },
#endif
        { "AsyncFrameScrollingEnabled", &WebPreferences::asyncFrameScrollingEnabled },
        { "AsyncOverflowScrollingEnabled", &WebPreferences::asyncOverflowScrollingEnabled },
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        { "UseCGDisplayListsForDOMRendering", &WebPreferences::useCGDisplayListsForDOMRendering },
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        { "ReplayCGDisplayListsIntoBackingStore", &WebPreferences::replayCGDisplayListsIntoBackingStore },
#endif
        { "CSSLogicalEnabled", &WebPreferences::cssLogicalEnabled },
        { "CSSOMViewScrollingAPIEnabled", &WebPreferences::cssOMViewScrollingAPIEnabled },
#if ENABLE(MEDIA_STREAM)
        { "CaptureAudioInUIProcessEnabled", &WebPreferences::captureAudioInUIProcessEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureVideoInUIProcessEnabled", &WebPreferences::captureVideoInUIProcessEnabled },
#endif
#if ENABLE(INPUT_TYPE_COLOR)
        { "InputTypeColorEnabled", &WebPreferences::inputTypeColorEnabled },
#endif
        { "CookieConsentAPIEnabled", &WebPreferences::cookieConsentAPIEnabled },
        { "DOMPasteAccessRequestsEnabled", &WebPreferences::domPasteAccessRequestsEnabled },
#if PLATFORM(IOS_FAMILY)
        { "ZoomOnDoubleTapWhenRoot", &WebPreferences::zoomOnDoubleTapWhenRoot },
#endif
#if PLATFORM(IOS_FAMILY)
        { "AlwaysZoomOnDoubleTap", &WebPreferences::alwaysZoomOnDoubleTap },
#endif
#if ENABLE(DATALIST_ELEMENT)
        { "DataListElementEnabled", &WebPreferences::dataListElementEnabled },
#endif
#if ENABLE(INPUT_TYPE_DATE)
        { "InputTypeDateEnabled", &WebPreferences::inputTypeDateEnabled },
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
        { "DateTimeInputsEditableComponentsEnabled", &WebPreferences::dateTimeInputsEditableComponentsEnabled },
#endif
        { "ICECandidateFilteringEnabled", &WebPreferences::iceCandidateFilteringEnabled },
#if ENABLE(MEDIA_STREAM)
        { "MockCaptureDevicesEnabled", &WebPreferences::mockCaptureDevicesEnabled },
#endif
        { "PdfJSViewerEnabled", &WebPreferences::pdfJSViewerEnabled },
        { "EnterKeyHintEnabled", &WebPreferences::enterKeyHintEnabled },
        { "EventHandlerDrivenSmoothKeyboardScrollingEnabled", &WebPreferences::eventHandlerDrivenSmoothKeyboardScrollingEnabled },
#if PLATFORM(IOS_FAMILY)
        { "PreferFasterClickOverDoubleTap", &WebPreferences::preferFasterClickOverDoubleTap },
#endif
#if PLATFORM(IOS_FAMILY)
        { "FasterClicksEnabled", &WebPreferences::fasterClicksEnabled },
#endif
        { "RestrictedHTTPResponseAccess", &WebPreferences::restrictedHTTPResponseAccess },
        { "FrameFlatteningEnabled", &WebPreferences::frameFlatteningEnabled },
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        { "LayoutFormattingContextEnabled", &WebPreferences::layoutFormattingContextEnabled },
#endif
#if ENABLE(FULLSCREEN_API)
        { "FullScreenEnabled", &WebPreferences::fullScreenEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureAudioInGPUProcessEnabled", &WebPreferences::captureAudioInGPUProcessEnabled },
#endif
#if ENABLE(GPU_PROCESS) && !(PLATFORM(GTK) || PLATFORM(WPE))
        { "UseGPUProcessForCanvasRenderingEnabled", &WebPreferences::useGPUProcessForCanvasRenderingEnabled },
#endif
#if ENABLE(GPU_PROCESS) && !USE(GSTREAMER)
        { "UseGPUProcessForMediaEnabled", &WebPreferences::useGPUProcessForMediaEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureVideoInGPUProcessEnabled", &WebPreferences::captureVideoInGPUProcessEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformCodecsInGPUProcessEnabled", &WebPreferences::webRTCPlatformCodecsInGPUProcessEnabled },
#endif
#if ENABLE(IPC_TESTING_API)
        { "IPCTestingAPIEnabled", &WebPreferences::ipcTestingAPIEnabled },
#endif
#if ENABLE(TEXT_AUTOSIZING)
        { "TextAutosizingUsesIdempotentMode", &WebPreferences::textAutosizingUsesIdempotentMode },
#endif
#if ENABLE(IMAGE_ANALYSIS)
        { "ImageAnalysisMarkupEnabled", &WebPreferences::imageAnalysisMarkupEnabled },
#endif
#if ENABLE(IMAGE_ANALYSIS)
        { "ImageAnalysisQueueEnabled", &WebPreferences::imageAnalysisQueueEnabled },
#endif
#if ENABLE(IMAGE_ANALYSIS)
        { "PreferInlineTextSelectionInImages", &WebPreferences::preferInlineTextSelectionInImages },
#endif
#if ENABLE(LAYER_BASED_SVG_ENGINE)
        { "LayerBasedSVGEngineEnabled", &WebPreferences::layerBasedSVGEngineEnabled },
#endif
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
        { "LegacyOverflowScrollingTouchEnabled", &WebPreferences::legacyOverflowScrollingTouchEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "MediaCaptureRequiresSecureConnection", &WebPreferences::mediaCaptureRequiresSecureConnection },
#endif
        { "LiveRangeSelectionEnabled", &WebPreferences::liveRangeSelectionEnabled },
        { "MomentumScrollingAnimatorEnabled", &WebPreferences::momentumScrollingAnimatorEnabled },
#if ENABLE(INPUT_TYPE_MONTH)
        { "InputTypeMonthEnabled", &WebPreferences::inputTypeMonthEnabled },
#endif
#if ENABLE(TOUCH_EVENTS)
        { "MouseEventsSimulationEnabled", &WebPreferences::mouseEventsSimulationEnabled },
#endif
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        { "LayoutFormattingContextIntegrationEnabled", &WebPreferences::layoutFormattingContextIntegrationEnabled },
#endif
#if ENABLE(NOTIFICATION_EVENT)
        { "NotificationEventEnabled", &WebPreferences::notificationEventEnabled },
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
        { "OffscreenCanvasInWorkersEnabled", &WebPreferences::offscreenCanvasInWorkersEnabled },
#endif
#if ENABLE(OFFSCREEN_CANVAS)
        { "OffscreenCanvasEnabled", &WebPreferences::offscreenCanvasEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "SpeakerSelectionRequiresUserGesture", &WebPreferences::speakerSelectionRequiresUserGesture },
#endif
#if ENABLE(MEDIA_STREAM)
        { "GetUserMediaRequiresFocus", &WebPreferences::getUserMediaRequiresFocus },
#endif
        { "ResourceLoadSchedulingEnabled", &WebPreferences::resourceLoadSchedulingEnabled },
        { "ScrollingPerformanceTestingEnabled", &WebPreferences::scrollingPerformanceTestingEnabled },
        { "SecureContextChecksEnabled", &WebPreferences::secureContextChecksEnabled },
        { "SelectionFlippingEnabled", &WebPreferences::selectionFlippingEnabled },
#if ENABLE(SERVICE_WORKER)
        { "ServiceWorkersEnabled", &WebPreferences::serviceWorkersEnabled },
#endif
        { "SimpleLineLayoutEnabled", &WebPreferences::simpleLineLayoutEnabled },
#if ENABLE(IMAGE_ANALYSIS)
        { "TextRecognitionEnhancementsEnabled", &WebPreferences::textRecognitionEnhancementsEnabled },
#endif
#if ENABLE(INPUT_TYPE_TIME)
        { "InputTypeTimeEnabled", &WebPreferences::inputTypeTimeEnabled },
#endif
        { "UndoManagerAPIEnabled", &WebPreferences::undoManagerAPIEnabled },
        { "UpgradeKnownHostsToHTTPSEnabled", &WebPreferences::upgradeKnownHostsToHTTPSEnabled },
#if ENABLE(ARKIT_INLINE_PREVIEW)
        { "UseARKitForModel", &WebPreferences::useARKitForModel },
#endif
#if HAVE(SCENEKIT)
        { "UseSceneKitForModel", &WebPreferences::useSceneKitForModel },
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        { "UseiTunesAVOutputContext", &WebPreferences::useiTunesAVOutputContext },
#endif
        { "WebAPIStatisticsEnabled", &WebPreferences::webAPIStatisticsEnabled },
#if ENABLE(WEB_RTC)
        { "WebRTCDTMFEnabled", &WebPreferences::webRTCDTMFEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264HardwareEncoderEnabled", &WebPreferences::webRTCH264HardwareEncoderEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264SimulcastEnabled", &WebPreferences::webRTCH264SimulcastEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCRemoteVideoFrameEnabled", &WebPreferences::webRTCRemoteVideoFrameEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCMDNSICECandidatesEnabled", &WebPreferences::webRTCMDNSICECandidatesEnabled },
#endif
#if ENABLE(INPUT_TYPE_WEEK)
        { "InputTypeWeekEnabled", &WebPreferences::inputTypeWeekEnabled },
#endif
        { "IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled", &WebPreferences::isFirstPartyWebsiteDataRemovalLiveOnTestingEnabled },
        { "IsFirstPartyWebsiteDataRemovalReproTestingEnabled", &WebPreferences::isFirstPartyWebsiteDataRemovalReproTestingEnabled },
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
        { "InputTypeDateTimeLocalEnabled", &WebPreferences::inputTypeDateTimeLocalEnabled },
#endif
#if ENABLE(IOS_FORM_CONTROL_REFRESH)
        { "IOSFormControlRefreshEnabled", &WebPreferences::iOSFormControlRefreshEnabled },
#endif
        { "LineHeightUnitsEnabled", &WebPreferences::lineHeightUnitsEnabled },
    };

    const String& key = feature.key();

    for (auto& getter : getters) {
        if (key == getter.name)
            return (this->*getter.function)();
    }

    return false;
}

void WebPreferences::setFeatureEnabled(const API::InternalDebugFeature& feature, bool value)
{
    setInternalDebugFeatureEnabledForKey(feature.key(), value);
}

void WebPreferences::setInternalDebugFeatureEnabledForKey(const String& key, bool value)
{
    struct FeatureSetterMapping {
        const char* name;
        void (WebPreferences::*function) (const bool&);
    };

    static FeatureSetterMapping setters[] = {
        { "AriaReflectionEnabled", &WebPreferences::setAriaReflectionEnabled },
#if USE(CORE_IMAGE)
        { "AcceleratedFiltersEnabled", &WebPreferences::setAcceleratedFiltersEnabled },
#endif
        { "CSSDisplayContentsAXSupportEnabled", &WebPreferences::setCSSDisplayContentsAXSupportEnabled },
#if PLATFORM(IOS_FAMILY)
        { "AllowViewportShrinkToFitContent", &WebPreferences::setAllowViewportShrinkToFitContent },
#endif
#if ENABLE(APPLE_PAY_REMOTE_UI)
        { "ApplePayRemoteUIEnabled", &WebPreferences::setApplePayRemoteUIEnabled },
#endif
        { "AsyncFrameScrollingEnabled", &WebPreferences::setAsyncFrameScrollingEnabled },
        { "AsyncOverflowScrollingEnabled", &WebPreferences::setAsyncOverflowScrollingEnabled },
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        { "UseCGDisplayListsForDOMRendering", &WebPreferences::setUseCGDisplayListsForDOMRendering },
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        { "ReplayCGDisplayListsIntoBackingStore", &WebPreferences::setReplayCGDisplayListsIntoBackingStore },
#endif
        { "CSSLogicalEnabled", &WebPreferences::setCSSLogicalEnabled },
        { "CSSOMViewScrollingAPIEnabled", &WebPreferences::setCSSOMViewScrollingAPIEnabled },
#if ENABLE(MEDIA_STREAM)
        { "CaptureAudioInUIProcessEnabled", &WebPreferences::setCaptureAudioInUIProcessEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureVideoInUIProcessEnabled", &WebPreferences::setCaptureVideoInUIProcessEnabled },
#endif
#if ENABLE(INPUT_TYPE_COLOR)
        { "InputTypeColorEnabled", &WebPreferences::setInputTypeColorEnabled },
#endif
        { "CookieConsentAPIEnabled", &WebPreferences::setCookieConsentAPIEnabled },
        { "DOMPasteAccessRequestsEnabled", &WebPreferences::setDOMPasteAccessRequestsEnabled },
#if PLATFORM(IOS_FAMILY)
        { "ZoomOnDoubleTapWhenRoot", &WebPreferences::setZoomOnDoubleTapWhenRoot },
#endif
#if PLATFORM(IOS_FAMILY)
        { "AlwaysZoomOnDoubleTap", &WebPreferences::setAlwaysZoomOnDoubleTap },
#endif
#if ENABLE(DATALIST_ELEMENT)
        { "DataListElementEnabled", &WebPreferences::setDataListElementEnabled },
#endif
#if ENABLE(INPUT_TYPE_DATE)
        { "InputTypeDateEnabled", &WebPreferences::setInputTypeDateEnabled },
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
        { "DateTimeInputsEditableComponentsEnabled", &WebPreferences::setDateTimeInputsEditableComponentsEnabled },
#endif
        { "ICECandidateFilteringEnabled", &WebPreferences::setICECandidateFilteringEnabled },
#if ENABLE(MEDIA_STREAM)
        { "MockCaptureDevicesEnabled", &WebPreferences::setMockCaptureDevicesEnabled },
#endif
        { "PdfJSViewerEnabled", &WebPreferences::setPdfJSViewerEnabled },
        { "EnterKeyHintEnabled", &WebPreferences::setEnterKeyHintEnabled },
        { "EventHandlerDrivenSmoothKeyboardScrollingEnabled", &WebPreferences::setEventHandlerDrivenSmoothKeyboardScrollingEnabled },
#if PLATFORM(IOS_FAMILY)
        { "PreferFasterClickOverDoubleTap", &WebPreferences::setPreferFasterClickOverDoubleTap },
#endif
#if PLATFORM(IOS_FAMILY)
        { "FasterClicksEnabled", &WebPreferences::setFasterClicksEnabled },
#endif
        { "RestrictedHTTPResponseAccess", &WebPreferences::setRestrictedHTTPResponseAccess },
        { "FrameFlatteningEnabled", &WebPreferences::setFrameFlatteningEnabled },
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        { "LayoutFormattingContextEnabled", &WebPreferences::setLayoutFormattingContextEnabled },
#endif
#if ENABLE(FULLSCREEN_API)
        { "FullScreenEnabled", &WebPreferences::setFullScreenEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureAudioInGPUProcessEnabled", &WebPreferences::setCaptureAudioInGPUProcessEnabled },
#endif
#if ENABLE(GPU_PROCESS) && !(PLATFORM(GTK) || PLATFORM(WPE))
        { "UseGPUProcessForCanvasRenderingEnabled", &WebPreferences::setUseGPUProcessForCanvasRenderingEnabled },
#endif
#if ENABLE(GPU_PROCESS) && !USE(GSTREAMER)
        { "UseGPUProcessForMediaEnabled", &WebPreferences::setUseGPUProcessForMediaEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "CaptureVideoInGPUProcessEnabled", &WebPreferences::setCaptureVideoInGPUProcessEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformCodecsInGPUProcessEnabled", &WebPreferences::setWebRTCPlatformCodecsInGPUProcessEnabled },
#endif
#if ENABLE(IPC_TESTING_API)
        { "IPCTestingAPIEnabled", &WebPreferences::setIPCTestingAPIEnabled },
#endif
#if ENABLE(TEXT_AUTOSIZING)
        { "TextAutosizingUsesIdempotentMode", &WebPreferences::setTextAutosizingUsesIdempotentMode },
#endif
#if ENABLE(IMAGE_ANALYSIS)
        { "ImageAnalysisMarkupEnabled", &WebPreferences::setImageAnalysisMarkupEnabled },
#endif
#if ENABLE(IMAGE_ANALYSIS)
        { "ImageAnalysisQueueEnabled", &WebPreferences::setImageAnalysisQueueEnabled },
#endif
#if ENABLE(IMAGE_ANALYSIS)
        { "PreferInlineTextSelectionInImages", &WebPreferences::setPreferInlineTextSelectionInImages },
#endif
#if ENABLE(LAYER_BASED_SVG_ENGINE)
        { "LayerBasedSVGEngineEnabled", &WebPreferences::setLayerBasedSVGEngineEnabled },
#endif
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
        { "LegacyOverflowScrollingTouchEnabled", &WebPreferences::setLegacyOverflowScrollingTouchEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "MediaCaptureRequiresSecureConnection", &WebPreferences::setMediaCaptureRequiresSecureConnection },
#endif
        { "LiveRangeSelectionEnabled", &WebPreferences::setLiveRangeSelectionEnabled },
        { "MomentumScrollingAnimatorEnabled", &WebPreferences::setMomentumScrollingAnimatorEnabled },
#if ENABLE(INPUT_TYPE_MONTH)
        { "InputTypeMonthEnabled", &WebPreferences::setInputTypeMonthEnabled },
#endif
#if ENABLE(TOUCH_EVENTS)
        { "MouseEventsSimulationEnabled", &WebPreferences::setMouseEventsSimulationEnabled },
#endif
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        { "LayoutFormattingContextIntegrationEnabled", &WebPreferences::setLayoutFormattingContextIntegrationEnabled },
#endif
#if ENABLE(NOTIFICATION_EVENT)
        { "NotificationEventEnabled", &WebPreferences::setNotificationEventEnabled },
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
        { "OffscreenCanvasInWorkersEnabled", &WebPreferences::setOffscreenCanvasInWorkersEnabled },
#endif
#if ENABLE(OFFSCREEN_CANVAS)
        { "OffscreenCanvasEnabled", &WebPreferences::setOffscreenCanvasEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "SpeakerSelectionRequiresUserGesture", &WebPreferences::setSpeakerSelectionRequiresUserGesture },
#endif
#if ENABLE(MEDIA_STREAM)
        { "GetUserMediaRequiresFocus", &WebPreferences::setGetUserMediaRequiresFocus },
#endif
        { "ResourceLoadSchedulingEnabled", &WebPreferences::setResourceLoadSchedulingEnabled },
        { "ScrollingPerformanceTestingEnabled", &WebPreferences::setScrollingPerformanceTestingEnabled },
        { "SecureContextChecksEnabled", &WebPreferences::setSecureContextChecksEnabled },
        { "SelectionFlippingEnabled", &WebPreferences::setSelectionFlippingEnabled },
#if ENABLE(SERVICE_WORKER)
        { "ServiceWorkersEnabled", &WebPreferences::setServiceWorkersEnabled },
#endif
        { "SimpleLineLayoutEnabled", &WebPreferences::setSimpleLineLayoutEnabled },
#if ENABLE(IMAGE_ANALYSIS)
        { "TextRecognitionEnhancementsEnabled", &WebPreferences::setTextRecognitionEnhancementsEnabled },
#endif
#if ENABLE(INPUT_TYPE_TIME)
        { "InputTypeTimeEnabled", &WebPreferences::setInputTypeTimeEnabled },
#endif
        { "UndoManagerAPIEnabled", &WebPreferences::setUndoManagerAPIEnabled },
        { "UpgradeKnownHostsToHTTPSEnabled", &WebPreferences::setUpgradeKnownHostsToHTTPSEnabled },
#if ENABLE(ARKIT_INLINE_PREVIEW)
        { "UseARKitForModel", &WebPreferences::setUseARKitForModel },
#endif
#if HAVE(SCENEKIT)
        { "UseSceneKitForModel", &WebPreferences::setUseSceneKitForModel },
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        { "UseiTunesAVOutputContext", &WebPreferences::setUseiTunesAVOutputContext },
#endif
        { "WebAPIStatisticsEnabled", &WebPreferences::setWebAPIStatisticsEnabled },
#if ENABLE(WEB_RTC)
        { "WebRTCDTMFEnabled", &WebPreferences::setWebRTCDTMFEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264HardwareEncoderEnabled", &WebPreferences::setWebRTCH264HardwareEncoderEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264SimulcastEnabled", &WebPreferences::setWebRTCH264SimulcastEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCRemoteVideoFrameEnabled", &WebPreferences::setWebRTCRemoteVideoFrameEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCMDNSICECandidatesEnabled", &WebPreferences::setWebRTCMDNSICECandidatesEnabled },
#endif
#if ENABLE(INPUT_TYPE_WEEK)
        { "InputTypeWeekEnabled", &WebPreferences::setInputTypeWeekEnabled },
#endif
        { "IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled", &WebPreferences::setIsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled },
        { "IsFirstPartyWebsiteDataRemovalReproTestingEnabled", &WebPreferences::setIsFirstPartyWebsiteDataRemovalReproTestingEnabled },
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
        { "InputTypeDateTimeLocalEnabled", &WebPreferences::setInputTypeDateTimeLocalEnabled },
#endif
#if ENABLE(IOS_FORM_CONTROL_REFRESH)
        { "IOSFormControlRefreshEnabled", &WebPreferences::setIOSFormControlRefreshEnabled },
#endif
        { "LineHeightUnitsEnabled", &WebPreferences::setLineHeightUnitsEnabled },
    };

    for (auto& setter : setters) {
        if (key == setter.name) {
            (this->*setter.function)(value);
            return;
        }
    }
}

void WebPreferences::resetAllInternalDebugFeatures()
{
    UpdateBatch batch(*this);
    setAriaReflectionEnabled(DEFAULT_VALUE_FOR_AriaReflectionEnabled);
#if USE(CORE_IMAGE)
    setAcceleratedFiltersEnabled(DEFAULT_VALUE_FOR_AcceleratedFiltersEnabled);
#endif
    setCSSDisplayContentsAXSupportEnabled(DEFAULT_VALUE_FOR_CSSDisplayContentsAXSupportEnabled);
#if PLATFORM(IOS_FAMILY)
    setAllowViewportShrinkToFitContent(DEFAULT_VALUE_FOR_AllowViewportShrinkToFitContent);
#endif
#if ENABLE(APPLE_PAY_REMOTE_UI)
    setApplePayRemoteUIEnabled(DEFAULT_VALUE_FOR_ApplePayRemoteUIEnabled);
#endif
    setAsyncFrameScrollingEnabled(DEFAULT_VALUE_FOR_AsyncFrameScrollingEnabled);
    setAsyncOverflowScrollingEnabled(DEFAULT_VALUE_FOR_AsyncOverflowScrollingEnabled);
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
    setUseCGDisplayListsForDOMRendering(DEFAULT_VALUE_FOR_UseCGDisplayListsForDOMRendering);
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
    setReplayCGDisplayListsIntoBackingStore(DEFAULT_VALUE_FOR_ReplayCGDisplayListsIntoBackingStore);
#endif
    setCSSLogicalEnabled(DEFAULT_VALUE_FOR_CSSLogicalEnabled);
    setCSSOMViewScrollingAPIEnabled(DEFAULT_VALUE_FOR_CSSOMViewScrollingAPIEnabled);
#if ENABLE(MEDIA_STREAM)
    setCaptureAudioInUIProcessEnabled(DEFAULT_VALUE_FOR_CaptureAudioInUIProcessEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setCaptureVideoInUIProcessEnabled(DEFAULT_VALUE_FOR_CaptureVideoInUIProcessEnabled);
#endif
#if ENABLE(INPUT_TYPE_COLOR)
    setInputTypeColorEnabled(DEFAULT_VALUE_FOR_InputTypeColorEnabled);
#endif
    setCookieConsentAPIEnabled(DEFAULT_VALUE_FOR_CookieConsentAPIEnabled);
    setDOMPasteAccessRequestsEnabled(DEFAULT_VALUE_FOR_DOMPasteAccessRequestsEnabled);
#if PLATFORM(IOS_FAMILY)
    setZoomOnDoubleTapWhenRoot(DEFAULT_VALUE_FOR_ZoomOnDoubleTapWhenRoot);
#endif
#if PLATFORM(IOS_FAMILY)
    setAlwaysZoomOnDoubleTap(DEFAULT_VALUE_FOR_AlwaysZoomOnDoubleTap);
#endif
#if ENABLE(DATALIST_ELEMENT)
    setDataListElementEnabled(DEFAULT_VALUE_FOR_DataListElementEnabled);
#endif
#if ENABLE(INPUT_TYPE_DATE)
    setInputTypeDateEnabled(DEFAULT_VALUE_FOR_InputTypeDateEnabled);
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
    setDateTimeInputsEditableComponentsEnabled(DEFAULT_VALUE_FOR_DateTimeInputsEditableComponentsEnabled);
#endif
    setICECandidateFilteringEnabled(DEFAULT_VALUE_FOR_ICECandidateFilteringEnabled);
#if ENABLE(MEDIA_STREAM)
    setMockCaptureDevicesEnabled(DEFAULT_VALUE_FOR_MockCaptureDevicesEnabled);
#endif
    setPdfJSViewerEnabled(DEFAULT_VALUE_FOR_PdfJSViewerEnabled);
    setEnterKeyHintEnabled(DEFAULT_VALUE_FOR_EnterKeyHintEnabled);
    setEventHandlerDrivenSmoothKeyboardScrollingEnabled(DEFAULT_VALUE_FOR_EventHandlerDrivenSmoothKeyboardScrollingEnabled);
#if PLATFORM(IOS_FAMILY)
    setPreferFasterClickOverDoubleTap(DEFAULT_VALUE_FOR_PreferFasterClickOverDoubleTap);
#endif
#if PLATFORM(IOS_FAMILY)
    setFasterClicksEnabled(DEFAULT_VALUE_FOR_FasterClicksEnabled);
#endif
    setRestrictedHTTPResponseAccess(DEFAULT_VALUE_FOR_RestrictedHTTPResponseAccess);
    setFrameFlatteningEnabled(DEFAULT_VALUE_FOR_FrameFlatteningEnabled);
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
    setLayoutFormattingContextEnabled(DEFAULT_VALUE_FOR_LayoutFormattingContextEnabled);
#endif
#if ENABLE(FULLSCREEN_API)
    setFullScreenEnabled(DEFAULT_VALUE_FOR_FullScreenEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setCaptureAudioInGPUProcessEnabled(DEFAULT_VALUE_FOR_CaptureAudioInGPUProcessEnabled);
#endif
#if ENABLE(GPU_PROCESS) && !(PLATFORM(GTK) || PLATFORM(WPE))
    setUseGPUProcessForCanvasRenderingEnabled(DEFAULT_VALUE_FOR_UseGPUProcessForCanvasRenderingEnabled);
#endif
#if ENABLE(GPU_PROCESS) && !USE(GSTREAMER)
    setUseGPUProcessForMediaEnabled(DEFAULT_VALUE_FOR_UseGPUProcessForMediaEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setCaptureVideoInGPUProcessEnabled(DEFAULT_VALUE_FOR_CaptureVideoInGPUProcessEnabled);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCPlatformCodecsInGPUProcessEnabled(DEFAULT_VALUE_FOR_WebRTCPlatformCodecsInGPUProcessEnabled);
#endif
#if ENABLE(IPC_TESTING_API)
    setIPCTestingAPIEnabled(DEFAULT_VALUE_FOR_IPCTestingAPIEnabled);
#endif
#if ENABLE(TEXT_AUTOSIZING)
    setTextAutosizingUsesIdempotentMode(DEFAULT_VALUE_FOR_TextAutosizingUsesIdempotentMode);
#endif
#if ENABLE(IMAGE_ANALYSIS)
    setImageAnalysisMarkupEnabled(DEFAULT_VALUE_FOR_ImageAnalysisMarkupEnabled);
#endif
#if ENABLE(IMAGE_ANALYSIS)
    setImageAnalysisQueueEnabled(DEFAULT_VALUE_FOR_ImageAnalysisQueueEnabled);
#endif
#if ENABLE(IMAGE_ANALYSIS)
    setPreferInlineTextSelectionInImages(DEFAULT_VALUE_FOR_PreferInlineTextSelectionInImages);
#endif
#if ENABLE(LAYER_BASED_SVG_ENGINE)
    setLayerBasedSVGEngineEnabled(DEFAULT_VALUE_FOR_LayerBasedSVGEngineEnabled);
#endif
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
    setLegacyOverflowScrollingTouchEnabled(DEFAULT_VALUE_FOR_LegacyOverflowScrollingTouchEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setMediaCaptureRequiresSecureConnection(DEFAULT_VALUE_FOR_MediaCaptureRequiresSecureConnection);
#endif
    setLiveRangeSelectionEnabled(DEFAULT_VALUE_FOR_LiveRangeSelectionEnabled);
    setMomentumScrollingAnimatorEnabled(DEFAULT_VALUE_FOR_MomentumScrollingAnimatorEnabled);
#if ENABLE(INPUT_TYPE_MONTH)
    setInputTypeMonthEnabled(DEFAULT_VALUE_FOR_InputTypeMonthEnabled);
#endif
#if ENABLE(TOUCH_EVENTS)
    setMouseEventsSimulationEnabled(DEFAULT_VALUE_FOR_MouseEventsSimulationEnabled);
#endif
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
    setLayoutFormattingContextIntegrationEnabled(DEFAULT_VALUE_FOR_LayoutFormattingContextIntegrationEnabled);
#endif
#if ENABLE(NOTIFICATION_EVENT)
    setNotificationEventEnabled(DEFAULT_VALUE_FOR_NotificationEventEnabled);
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
    setOffscreenCanvasInWorkersEnabled(DEFAULT_VALUE_FOR_OffscreenCanvasInWorkersEnabled);
#endif
#if ENABLE(OFFSCREEN_CANVAS)
    setOffscreenCanvasEnabled(DEFAULT_VALUE_FOR_OffscreenCanvasEnabled);
#endif
#if ENABLE(MEDIA_STREAM)
    setSpeakerSelectionRequiresUserGesture(DEFAULT_VALUE_FOR_SpeakerSelectionRequiresUserGesture);
#endif
#if ENABLE(MEDIA_STREAM)
    setGetUserMediaRequiresFocus(DEFAULT_VALUE_FOR_GetUserMediaRequiresFocus);
#endif
    setResourceLoadSchedulingEnabled(DEFAULT_VALUE_FOR_ResourceLoadSchedulingEnabled);
    setScrollingPerformanceTestingEnabled(DEFAULT_VALUE_FOR_ScrollingPerformanceTestingEnabled);
    setSecureContextChecksEnabled(DEFAULT_VALUE_FOR_SecureContextChecksEnabled);
    setSelectionFlippingEnabled(DEFAULT_VALUE_FOR_SelectionFlippingEnabled);
#if ENABLE(SERVICE_WORKER)
    setServiceWorkersEnabled(DEFAULT_VALUE_FOR_ServiceWorkersEnabled);
#endif
    setSimpleLineLayoutEnabled(DEFAULT_VALUE_FOR_SimpleLineLayoutEnabled);
#if ENABLE(IMAGE_ANALYSIS)
    setTextRecognitionEnhancementsEnabled(DEFAULT_VALUE_FOR_TextRecognitionEnhancementsEnabled);
#endif
#if ENABLE(INPUT_TYPE_TIME)
    setInputTypeTimeEnabled(DEFAULT_VALUE_FOR_InputTypeTimeEnabled);
#endif
    setUndoManagerAPIEnabled(DEFAULT_VALUE_FOR_UndoManagerAPIEnabled);
    setUpgradeKnownHostsToHTTPSEnabled(DEFAULT_VALUE_FOR_UpgradeKnownHostsToHTTPSEnabled);
#if ENABLE(ARKIT_INLINE_PREVIEW)
    setUseARKitForModel(DEFAULT_VALUE_FOR_UseARKitForModel);
#endif
#if HAVE(SCENEKIT)
    setUseSceneKitForModel(DEFAULT_VALUE_FOR_UseSceneKitForModel);
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    setUseiTunesAVOutputContext(DEFAULT_VALUE_FOR_UseiTunesAVOutputContext);
#endif
    setWebAPIStatisticsEnabled(DEFAULT_VALUE_FOR_WebAPIStatisticsEnabled);
#if ENABLE(WEB_RTC)
    setWebRTCDTMFEnabled(DEFAULT_VALUE_FOR_WebRTCDTMFEnabled);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCH264HardwareEncoderEnabled(DEFAULT_VALUE_FOR_WebRTCH264HardwareEncoderEnabled);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCH264SimulcastEnabled(DEFAULT_VALUE_FOR_WebRTCH264SimulcastEnabled);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCRemoteVideoFrameEnabled(DEFAULT_VALUE_FOR_WebRTCRemoteVideoFrameEnabled);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCMDNSICECandidatesEnabled(DEFAULT_VALUE_FOR_WebRTCMDNSICECandidatesEnabled);
#endif
#if ENABLE(INPUT_TYPE_WEEK)
    setInputTypeWeekEnabled(DEFAULT_VALUE_FOR_InputTypeWeekEnabled);
#endif
    setIsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled(DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled);
    setIsFirstPartyWebsiteDataRemovalReproTestingEnabled(DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalReproTestingEnabled);
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
    setInputTypeDateTimeLocalEnabled(DEFAULT_VALUE_FOR_InputTypeDateTimeLocalEnabled);
#endif
#if ENABLE(IOS_FORM_CONTROL_REFRESH)
    setIOSFormControlRefreshEnabled(DEFAULT_VALUE_FOR_IOSFormControlRefreshEnabled);
#endif
    setLineHeightUnitsEnabled(DEFAULT_VALUE_FOR_LineHeightUnitsEnabled);
}

}
