// third_party/blink/public/mojom/mediastream/media_stream.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "media/capture/mojom/video_capture_types.mojom-blink.h"
#include "media/mojo/mojom/audio_parameters.mojom-blink.h"
#include "media/mojo/mojom/display_media_information.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_BLINK_JUMBO_H_
#endif


namespace blink {
namespace mojom {
namespace blink {


void MediaStreamDeviceObserverInterceptorForTesting::OnDeviceStopped(const WTF::String& label, const ::blink::MediaStreamDevice& device) {
  GetForwardingInterface()->OnDeviceStopped(std::move(label), std::move(device));
}
void MediaStreamDeviceObserverInterceptorForTesting::OnDeviceChanged(const WTF::String& label, const ::blink::MediaStreamDevice& old_device, const ::blink::MediaStreamDevice& new_device) {
  GetForwardingInterface()->OnDeviceChanged(std::move(label), std::move(old_device), std::move(new_device));
}
MediaStreamDeviceObserverAsyncWaiter::MediaStreamDeviceObserverAsyncWaiter(
    MediaStreamDeviceObserver* proxy) : proxy_(proxy) {}

MediaStreamDeviceObserverAsyncWaiter::~MediaStreamDeviceObserverAsyncWaiter() = default;




void MediaStreamDispatcherHostInterceptorForTesting::GenerateStream(int32_t request_id, const ::blink::StreamControls& controls, bool user_gesture, StreamSelectionInfoPtr audio_stream_selection_info, GenerateStreamCallback callback) {
  GetForwardingInterface()->GenerateStream(std::move(request_id), std::move(controls), std::move(user_gesture), std::move(audio_stream_selection_info), std::move(callback));
}
void MediaStreamDispatcherHostInterceptorForTesting::CancelRequest(int32_t request_id) {
  GetForwardingInterface()->CancelRequest(std::move(request_id));
}
void MediaStreamDispatcherHostInterceptorForTesting::StopStreamDevice(const WTF::String& device_id, const base::Optional<::base::UnguessableToken>& session_id) {
  GetForwardingInterface()->StopStreamDevice(std::move(device_id), std::move(session_id));
}
void MediaStreamDispatcherHostInterceptorForTesting::OpenDevice(int32_t request_id, const WTF::String& device_id, MediaStreamType type, OpenDeviceCallback callback) {
  GetForwardingInterface()->OpenDevice(std::move(request_id), std::move(device_id), std::move(type), std::move(callback));
}
void MediaStreamDispatcherHostInterceptorForTesting::CloseDevice(const WTF::String& label) {
  GetForwardingInterface()->CloseDevice(std::move(label));
}
void MediaStreamDispatcherHostInterceptorForTesting::SetCapturingLinkSecured(const base::Optional<::base::UnguessableToken>& session_id, MediaStreamType type, bool is_secure) {
  GetForwardingInterface()->SetCapturingLinkSecured(std::move(session_id), std::move(type), std::move(is_secure));
}
void MediaStreamDispatcherHostInterceptorForTesting::OnStreamStarted(const WTF::String& label) {
  GetForwardingInterface()->OnStreamStarted(std::move(label));
}
MediaStreamDispatcherHostAsyncWaiter::MediaStreamDispatcherHostAsyncWaiter(
    MediaStreamDispatcherHost* proxy) : proxy_(proxy) {}

MediaStreamDispatcherHostAsyncWaiter::~MediaStreamDispatcherHostAsyncWaiter() = default;

void MediaStreamDispatcherHostAsyncWaiter::GenerateStream(
    int32_t request_id, const ::blink::StreamControls& controls, bool user_gesture, StreamSelectionInfoPtr audio_stream_selection_info, MediaStreamRequestResult* out_result, WTF::String* out_label, WTF::Vector<::blink::MediaStreamDevice>* out_audio_devices, WTF::Vector<::blink::MediaStreamDevice>* out_video_devices, bool* out_pan_tilt_zoom_allowed) {
  base::RunLoop loop;
  proxy_->GenerateStream(std::move(request_id),std::move(controls),std::move(user_gesture),std::move(audio_stream_selection_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             MediaStreamRequestResult* out_result
,
             WTF::String* out_label
,
             WTF::Vector<::blink::MediaStreamDevice>* out_audio_devices
,
             WTF::Vector<::blink::MediaStreamDevice>* out_video_devices
,
             bool* out_pan_tilt_zoom_allowed
,
             MediaStreamRequestResult result,
             const WTF::String& label,
             const WTF::Vector<::blink::MediaStreamDevice>& audio_devices,
             const WTF::Vector<::blink::MediaStreamDevice>& video_devices,
             bool pan_tilt_zoom_allowed) {*out_result = std::move(result);*out_label = std::move(label);*out_audio_devices = std::move(audio_devices);*out_video_devices = std::move(video_devices);*out_pan_tilt_zoom_allowed = std::move(pan_tilt_zoom_allowed);
            loop->Quit();
          },
          &loop,
          out_result,
          out_label,
          out_audio_devices,
          out_video_devices,
          out_pan_tilt_zoom_allowed));
  loop.Run();
}
void MediaStreamDispatcherHostAsyncWaiter::OpenDevice(
    int32_t request_id, const WTF::String& device_id, MediaStreamType type, bool* out_success, WTF::String* out_label, ::blink::MediaStreamDevice* out_device) {
  base::RunLoop loop;
  proxy_->OpenDevice(std::move(request_id),std::move(device_id),std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             WTF::String* out_label
,
             ::blink::MediaStreamDevice* out_device
,
             bool success,
             const WTF::String& label,
             const ::blink::MediaStreamDevice& device) {*out_success = std::move(success);*out_label = std::move(label);*out_device = std::move(device);
            loop->Quit();
          },
          &loop,
          out_success,
          out_label,
          out_device));
  loop.Run();
}



void MediaStreamTrackMetricsHostInterceptorForTesting::AddTrack(uint64_t id, bool is_audio, bool is_remote) {
  GetForwardingInterface()->AddTrack(std::move(id), std::move(is_audio), std::move(is_remote));
}
void MediaStreamTrackMetricsHostInterceptorForTesting::RemoveTrack(uint64_t id) {
  GetForwardingInterface()->RemoveTrack(std::move(id));
}
MediaStreamTrackMetricsHostAsyncWaiter::MediaStreamTrackMetricsHostAsyncWaiter(
    MediaStreamTrackMetricsHost* proxy) : proxy_(proxy) {}

MediaStreamTrackMetricsHostAsyncWaiter::~MediaStreamTrackMetricsHostAsyncWaiter() = default;






}  // namespace blink
}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif