/* rygel-searchable-container.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-searchable-container.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>

#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelSearchableContainerSimpleSearchData RygelSearchableContainerSimpleSearchData;
typedef struct _RygelSearchableContainerFindObjectData RygelSearchableContainerFindObjectData;
typedef struct _RygelSearchableContainerSearchInChildrenData RygelSearchableContainerSearchInChildrenData;

struct _RygelSearchableContainerSimpleSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelSearchableContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	guint total_matches;
	RygelMediaObjects* result;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp0_;
	gint count;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	RygelMediaObjects* children;
	RygelMediaObjects* _tmp7_;
	guint limit;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp8_;
	gint _child_size;
	RygelMediaObjects* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _child_index;
	gint _tmp12_;
	gint _tmp13_;
	RygelMediaObject* child;
	RygelMediaObjects* _tmp14_;
	gpointer _tmp15_;
	gboolean _tmp16_;
	RygelMediaObject* _tmp17_;
	RygelMediaObjects* _tmp18_;
	RygelMediaObject* _tmp19_;
	gboolean _tmp20_;
	RygelMediaObjects* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gboolean _tmp24_;
	RygelMediaObjects* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	guint _tmp28_;
	RygelMediaObjects* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	guint child_limit;
	RygelMediaObjects* child_results;
	RygelMediaObjects* _tmp32_;
	RygelMediaObjects* _tmp33_;
	RygelMediaObjects* _tmp34_;
	RygelMediaObjects* _tmp35_;
	RygelMediaObjects* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	RygelMediaObjects* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	RygelMediaObjects* _tmp42_;
	gboolean _tmp43_;
	RygelMediaObjects* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gboolean _tmp47_;
	guint stop;
	gboolean _tmp48_;
	RygelMediaObjects* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	RygelMediaObjects* _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	RygelMediaObjects* _tmp55_;
	GeeList* _tmp56_;
	RygelMediaObjects* _tmp57_;
	GError* _inner_error0_;
};

struct _RygelSearchableContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelSearchableContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guint total_matches;
	RygelMediaObjects* results;
	guint _tmp3_;
	RygelMediaObjects* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_;
	GError* _inner_error0_;
};

struct _RygelSearchableContainerSearchInChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelSearchableContainer* self;
	RygelSearchExpression* expression;
	RygelMediaObjects* children;
	guint limit;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _child_list;
	gint _child_size;
	RygelMediaObjects* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _child_index;
	gint _tmp4_;
	gint _tmp5_;
	RygelMediaObject* child;
	RygelMediaObjects* _tmp6_;
	gpointer _tmp7_;
	RygelMediaObject* _tmp8_;
	RygelSearchableContainer* container;
	RygelMediaObject* _tmp9_;
	RygelSearchableContainer* _tmp10_;
	guint tmp;
	RygelMediaObjects* child_result;
	RygelSearchableContainer* _tmp11_;
	guint _tmp12_;
	RygelMediaObjects* _tmp13_;
	RygelMediaObjects* _tmp14_;
	RygelMediaObjects* _tmp15_;
	gboolean _tmp16_;
	RygelMediaObjects* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GError* _inner_error0_;
};

static void rygel_searchable_container_simple_search_data_free (gpointer _data);
static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_);
VALA_EXTERN void rygel_media_container_check_search_expression (RygelMediaContainer* self,
                                                    RygelSearchExpression* expression);
static void rygel_searchable_container_simple_search_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self,
                                                    RygelSearchExpression* expression,
                                                    RygelMediaObjects* children,
                                                    guint limit,
                                                    const gchar* sort_criteria,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static RygelMediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self,
                                                                         GAsyncResult* _res_,
                                                                         GError** error);
static void rygel_searchable_container_find_object_data_free (gpointer _data);
static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_);
static void rygel_searchable_container_find_object_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void rygel_searchable_container_search_in_children_data_free (gpointer _data);
static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_);
static void rygel_searchable_container_search_in_children_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
VALA_EXTERN void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self,
                                                             GUPnPDIDLLiteContainer* didl_container);
static GType rygel_searchable_container_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
rygel_searchable_container_search (RygelSearchableContainer* self,
                                   RygelSearchExpression* expression,
                                   guint offset,
                                   guint max_count,
                                   const gchar* sort_criteria,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	RygelSearchableContainerIface* _iface_;
	_iface_ = RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->search) {
		_iface_->search (self, expression, offset, max_count, sort_criteria, cancellable, _callback_, _user_data_);
	}
}

RygelMediaObjects*
rygel_searchable_container_search_finish (RygelSearchableContainer* self,
                                          GAsyncResult* _res_,
                                          guint* total_matches,
                                          GError** error)
{
	RygelSearchableContainerIface* _iface_;
	_iface_ = RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->search_finish) {
		return _iface_->search_finish (self, _res_, total_matches, error);
	}
	return NULL;
}

static void
rygel_searchable_container_simple_search_data_free (gpointer _data)
{
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchableContainerSimpleSearchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}

void
rygel_searchable_container_simple_search (RygelSearchableContainer* self,
                                          RygelSearchExpression* expression,
                                          guint offset,
                                          guint max_count,
                                          const gchar* sort_criteria,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	RygelSearchableContainerSimpleSearchData* _data_;
	RygelSearchableContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (sort_criteria != NULL);
	_data_ = g_slice_new0 (RygelSearchableContainerSimpleSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_searchable_container_simple_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _rygel_search_expression_ref0 (expression);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp1_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp2_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	rygel_searchable_container_simple_search_co (_data_);
}

RygelMediaObjects*
rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self,
                                                 GAsyncResult* _res_,
                                                 guint* total_matches,
                                                 GError** error)
{
	RygelMediaObjects* result;
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Utility method that retrieves all children and recursively searches for
     * all media objects that satisfy the given search expression in this
     * container.
     *
     * @param expression the search expression or `null` for wildcard
     * @param offset zero-based index of the first object to return
     * @param max_count maximum number of objects to return
     * @param total_matches sets it to the actual number of objects that satisfy
     *                      the given search expression. If it is not possible
     *                      to compute this value (in a timely mannger), it is
     *                      set to '0'.
     * @param cancellable optional cancellable for this operation
     *
     * @return A list of media objects.
     */
static void
rygel_searchable_container_simple_search_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_searchable_container_simple_search_co (_data_);
}

static gboolean
rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_media_objects_new ();
	_data_->_result_ = _data_->_tmp0_;
	_data_->_tmp1_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->count = _data_->_tmp2_;
	rygel_media_container_check_search_expression ((RygelMediaContainer*) _data_->self, _data_->expression);
	_data_->_tmp3_ = rygel_media_container_get_create_mode_enabled ((RygelMediaContainer*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_) {
		_data_->_tmp5_ = rygel_media_container_get_all_child_count ((RygelMediaContainer*) _data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->count = _data_->_tmp6_;
	}
	_data_->_state_ = 1;
	rygel_media_container_get_children ((RygelMediaContainer*) _data_->self, (guint) 0, (guint) _data_->count, _data_->sort_criteria, _data_->cancellable, rygel_searchable_container_simple_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = rygel_media_container_get_children_finish ((RygelMediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->children = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_result_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->max_count > ((guint) 0)) {
		_data_->limit = _data_->offset + _data_->max_count;
	} else {
		_data_->limit = (guint) 0;
	}
	{
		_data_->_tmp8_ = _data_->children;
		_data_->_child_list = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->_child_list;
		_data_->_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_child_size = _data_->_tmp11_;
		_data_->_child_index = -1;
		while (TRUE) {
			_data_->_child_index = _data_->_child_index + 1;
			_data_->_tmp12_ = _data_->_child_index;
			_data_->_tmp13_ = _data_->_child_size;
			if (!(_data_->_tmp12_ < _data_->_tmp13_)) {
				break;
			}
			_data_->_tmp14_ = _data_->_child_list;
			_data_->_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp14_, _data_->_child_index);
			_data_->child = (RygelMediaObject*) _data_->_tmp15_;
			if (_data_->expression == NULL) {
				_data_->_tmp16_ = TRUE;
			} else {
				_data_->_tmp17_ = _data_->child;
				_data_->_tmp16_ = rygel_search_expression_satisfied_by (_data_->expression, _data_->_tmp17_);
			}
			if (_data_->_tmp16_) {
				_data_->_tmp18_ = _data_->_result_;
				_data_->_tmp19_ = _data_->child;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp18_, _data_->_tmp19_);
			}
			if (_data_->limit > ((guint) 0)) {
				_data_->_tmp21_ = _data_->_result_;
				_data_->_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp21_);
				_data_->_tmp23_ = _data_->_tmp22_;
				_data_->_tmp20_ = ((guint) _data_->_tmp23_) >= _data_->limit;
			} else {
				_data_->_tmp20_ = FALSE;
			}
			if (_data_->_tmp20_) {
				_g_object_unref0 (_data_->child);
				break;
			}
			_g_object_unref0 (_data_->child);
		}
	}
	if (_data_->limit == ((guint) 0)) {
		_data_->_tmp24_ = TRUE;
	} else {
		_data_->_tmp25_ = _data_->_result_;
		_data_->_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp25_);
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp24_ = ((guint) _data_->_tmp27_) < _data_->limit;
	}
	if (_data_->_tmp24_) {
		if (_data_->limit == ((guint) 0)) {
			_data_->_tmp28_ = (guint) 0;
		} else {
			_data_->_tmp29_ = _data_->_result_;
			_data_->_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_data_->_tmp28_ = _data_->limit - _data_->_tmp31_;
		}
		_data_->child_limit = _data_->_tmp28_;
		_data_->_tmp32_ = _data_->children;
		_data_->_state_ = 2;
		rygel_searchable_container_search_in_children (_data_->self, _data_->expression, _data_->_tmp32_, _data_->child_limit, _data_->sort_criteria, _data_->cancellable, rygel_searchable_container_simple_search_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp33_ = rygel_searchable_container_search_in_children_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->child_results = _data_->_tmp33_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->children);
			_g_object_unref0 (_data_->_result_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp34_ = _data_->_result_;
		_data_->_tmp35_ = _data_->child_results;
		gee_array_list_add_all ((GeeArrayList*) _data_->_tmp34_, (GeeCollection*) _data_->_tmp35_);
		_g_object_unref0 (_data_->child_results);
	}
	if (_data_->max_count > ((guint) 0)) {
		_data_->total_matches = (guint) 0;
	} else {
		_data_->_tmp36_ = _data_->_result_;
		_data_->_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp36_);
		_data_->_tmp38_ = _data_->_tmp37_;
		_data_->total_matches = (guint) _data_->_tmp38_;
	}
	_data_->_tmp39_ = _data_->_result_;
	_data_->_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp39_);
	_data_->_tmp41_ = _data_->_tmp40_;
	if (_data_->offset >= ((guint) _data_->_tmp41_)) {
		_data_->_tmp42_ = rygel_media_objects_new ();
		_data_->result = _data_->_tmp42_;
		_g_object_unref0 (_data_->children);
		_g_object_unref0 (_data_->_result_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp44_ = _data_->_result_;
	_data_->_tmp45_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp44_);
	_data_->_tmp46_ = _data_->_tmp45_;
	if (_data_->_tmp46_ > 0) {
		if (_data_->max_count > ((guint) 0)) {
			_data_->_tmp47_ = TRUE;
		} else {
			_data_->_tmp47_ = _data_->offset > ((guint) 0);
		}
		_data_->_tmp43_ = _data_->_tmp47_;
	} else {
		_data_->_tmp43_ = FALSE;
	}
	if (_data_->_tmp43_) {
		if (_data_->max_count != ((guint) 0)) {
			_data_->_tmp49_ = _data_->_result_;
			_data_->_tmp50_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp49_);
			_data_->_tmp51_ = _data_->_tmp50_;
			_data_->_tmp48_ = (_data_->offset + _data_->max_count) <= ((guint) _data_->_tmp51_);
		} else {
			_data_->_tmp48_ = FALSE;
		}
		if (_data_->_tmp48_) {
			_data_->stop = _data_->offset + _data_->max_count;
		} else {
			_data_->_tmp52_ = _data_->_result_;
			_data_->_tmp53_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp52_);
			_data_->_tmp54_ = _data_->_tmp53_;
			_data_->stop = (guint) _data_->_tmp54_;
		}
		_data_->_tmp55_ = _data_->_result_;
		_data_->_tmp56_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp55_, (gint) _data_->offset, (gint) _data_->stop);
		_data_->_tmp57_ = RYGEL_IS_MEDIA_OBJECTS (_data_->_tmp56_) ? ((RygelMediaObjects*) _data_->_tmp56_) : NULL;
		if (_data_->_tmp57_ == NULL) {
			_g_object_unref0 (_data_->_tmp56_);
		}
		_data_->result = _data_->_tmp57_;
		_g_object_unref0 (_data_->children);
		_g_object_unref0 (_data_->_result_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_result_;
	_g_object_unref0 (_data_->children);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_searchable_container_find_object_data_free (gpointer _data)
{
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchableContainerFindObjectData, _data_);
}

void
rygel_searchable_container_find_object (RygelSearchableContainer* self,
                                        const gchar* id,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	RygelSearchableContainerFindObjectData* _data_;
	RygelSearchableContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (id != NULL);
	_data_ = g_slice_new0 (RygelSearchableContainerFindObjectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_searchable_container_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_searchable_container_find_object_co (_data_);
}

RygelMediaObject*
rygel_searchable_container_find_object_finish (RygelSearchableContainer* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	RygelMediaObject* result;
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Recursively searches for media object with the given id in this
     * container.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     * @param callback function to call when result is ready
     *
     * @return the found media object.
     */
static void
rygel_searchable_container_find_object_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_searchable_container_find_object_co (_data_);
}

static gboolean
rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_relational_expression_new ();
	_data_->expression = _data_->_tmp0_;
	((RygelSearchExpression*) _data_->expression)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EQ);
	_data_->_tmp1_ = g_strdup ("@id");
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand1);
	((RygelSearchExpression*) _data_->expression)->operand1 = _data_->_tmp1_;
	_data_->_tmp2_ = g_strdup (_data_->id);
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand2);
	((RygelSearchExpression*) _data_->expression)->operand2 = _data_->_tmp2_;
	_data_->_tmp3_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_search (_data_->self, (RygelSearchExpression*) _data_->expression, (guint) 0, (guint) 1, "", _data_->cancellable, rygel_searchable_container_find_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = rygel_searchable_container_search_finish (_data_->self, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error0_);
	_data_->total_matches = _data_->_tmp3_;
	_data_->results = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_rygel_search_expression_unref0 (_data_->expression);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->results);
	_data_->_tmp6_ = _data_->_tmp5_;
	if (_data_->_tmp6_ > 0) {
		_data_->_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _data_->results, 0);
		_data_->result = (RygelMediaObject*) _data_->_tmp7_;
		_g_object_unref0 (_data_->results);
		_rygel_search_expression_unref0 (_data_->expression);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->result = NULL;
		_g_object_unref0 (_data_->results);
		_rygel_search_expression_unref0 (_data_->expression);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
rygel_searchable_container_search_in_children_data_free (gpointer _data)
{
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_object_unref0 (_data_->children);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchableContainerSearchInChildrenData, _data_);
}

static void
rygel_searchable_container_search_in_children (RygelSearchableContainer* self,
                                               RygelSearchExpression* expression,
                                               RygelMediaObjects* children,
                                               guint limit,
                                               const gchar* sort_criteria,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	RygelSearchableContainerSearchInChildrenData* _data_;
	RygelSearchableContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelMediaObjects* _tmp2_;
	gchar* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (children != NULL);
	g_return_if_fail (sort_criteria != NULL);
	_data_ = g_slice_new0 (RygelSearchableContainerSearchInChildrenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_searchable_container_search_in_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _rygel_search_expression_ref0 (expression);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp1_;
	_tmp2_ = _g_object_ref0 (children);
	_g_object_unref0 (_data_->children);
	_data_->children = _tmp2_;
	_data_->limit = limit;
	_tmp3_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_searchable_container_search_in_children_co (_data_);
}

static RygelMediaObjects*
rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	RygelMediaObjects* result;
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_searchable_container_search_in_children_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_searchable_container_search_in_children_co (_data_);
}

static gboolean
rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_media_objects_new ();
	_data_->_result_ = _data_->_tmp0_;
	{
		_data_->_child_list = _data_->children;
		_data_->_tmp1_ = _data_->_child_list;
		_data_->_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_child_size = _data_->_tmp3_;
		_data_->_child_index = -1;
		while (TRUE) {
			_data_->_child_index = _data_->_child_index + 1;
			_data_->_tmp4_ = _data_->_child_index;
			_data_->_tmp5_ = _data_->_child_size;
			if (!(_data_->_tmp4_ < _data_->_tmp5_)) {
				break;
			}
			_data_->_tmp6_ = _data_->_child_list;
			_data_->_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp6_, _data_->_child_index);
			_data_->child = (RygelMediaObject*) _data_->_tmp7_;
			_data_->_tmp8_ = _data_->child;
			if (RYGEL_IS_SEARCHABLE_CONTAINER (_data_->_tmp8_)) {
				_data_->_tmp9_ = _data_->child;
				_data_->_tmp10_ = _g_object_ref0 (RYGEL_IS_SEARCHABLE_CONTAINER (_data_->_tmp9_) ? ((RygelSearchableContainer*) _data_->_tmp9_) : NULL);
				_data_->container = _data_->_tmp10_;
				_data_->_tmp11_ = _data_->container;
				_data_->_tmp12_ = 0U;
				_data_->_state_ = 1;
				rygel_searchable_container_search (_data_->_tmp11_, _data_->expression, (guint) 0, _data_->limit, _data_->sort_criteria, _data_->cancellable, rygel_searchable_container_search_in_children_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp13_ = rygel_searchable_container_search_finish (_data_->_tmp11_, _data_->_res_, &_data_->_tmp12_, &_data_->_inner_error0_);
				_data_->tmp = _data_->_tmp12_;
				_data_->child_result = _data_->_tmp13_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->container);
					_g_object_unref0 (_data_->child);
					_g_object_unref0 (_data_->_result_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp14_ = _data_->_result_;
				_data_->_tmp15_ = _data_->child_result;
				gee_array_list_add_all ((GeeArrayList*) _data_->_tmp14_, (GeeCollection*) _data_->_tmp15_);
				_g_object_unref0 (_data_->child_result);
				_g_object_unref0 (_data_->container);
			}
			if (_data_->limit > ((guint) 0)) {
				_data_->_tmp17_ = _data_->_result_;
				_data_->_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp17_);
				_data_->_tmp19_ = _data_->_tmp18_;
				_data_->_tmp16_ = ((guint) _data_->_tmp19_) >= _data_->limit;
			} else {
				_data_->_tmp16_ = FALSE;
			}
			if (_data_->_tmp16_) {
				_g_object_unref0 (_data_->child);
				break;
			}
			_g_object_unref0 (_data_->child);
		}
	}
	_data_->result = _data_->_result_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self,
                                                        GUPnPDIDLLiteContainer* didl_container)
{
	g_return_if_fail (didl_container != NULL);
	{
		GeeArrayList* _search_class_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _search_class_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _search_class_index = 0;
		_tmp0_ = rygel_searchable_container_get_search_classes (self);
		_tmp1_ = _tmp0_;
		_search_class_list = _tmp1_;
		_tmp2_ = _search_class_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_search_class_size = _tmp4_;
		_search_class_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* search_class = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			const gchar* _tmp9_;
			_search_class_index = _search_class_index + 1;
			_tmp5_ = _search_class_index;
			_tmp6_ = _search_class_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _search_class_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _search_class_index);
			search_class = (gchar*) _tmp8_;
			_tmp9_ = search_class;
			gupnp_didl_lite_container_add_search_class (didl_container, _tmp9_);
			_g_free0 (search_class);
		}
	}
}

GeeArrayList*
rygel_searchable_container_get_search_classes (RygelSearchableContainer* self)
{
	RygelSearchableContainerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->get_search_classes) {
		return _iface_->get_search_classes (self);
	}
	return NULL;
}

void
rygel_searchable_container_set_search_classes (RygelSearchableContainer* self,
                                               GeeArrayList* value)
{
	RygelSearchableContainerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->set_search_classes) {
		_iface_->set_search_classes (self, value);
	}
}

static void
rygel_searchable_container_default_init (RygelSearchableContainerIface * iface,
                                         gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

/**
 * The base class for searchable containers.
 *
 * Classes that implement this interface can, for instance:
 *
 *  # Allow backends to implement a UPnP Search call using native searching (such as SQL or SPARQL queries).
 *  # Implement searching via the naïve default implementation provided by rygel_searchable_container_simple_search(), which does a recursive tree walk.
 *
 * The search_classes property lists what information this container may be searched
 * for. It is mapped to upnp:searchClass (with includeDerived assumed to be false),
 */
static GType
rygel_searchable_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelSearchableContainerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_searchable_container_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType rygel_searchable_container_type_id;
	rygel_searchable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelSearchableContainer", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (rygel_searchable_container_type_id, RYGEL_TYPE_MEDIA_CONTAINER);
	return rygel_searchable_container_type_id;
}

GType
rygel_searchable_container_get_type (void)
{
	static volatile gsize rygel_searchable_container_type_id__once = 0;
	if (g_once_init_enter (&rygel_searchable_container_type_id__once)) {
		GType rygel_searchable_container_type_id;
		rygel_searchable_container_type_id = rygel_searchable_container_get_type_once ();
		g_once_init_leave (&rygel_searchable_container_type_id__once, rygel_searchable_container_type_id);
	}
	return rygel_searchable_container_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

