/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

public class SizeSequence {
    private static int[] emptyArray = new int[0];
    private int[] a = emptyArray;

    public SizeSequence() {
    }

    public SizeSequence(int numEntries) {
        this(numEntries, 0);
    }

    public SizeSequence(int numEntries, int value) {
        this();
        this.insertEntries(0, numEntries, value);
    }

    public SizeSequence(int[] sizes) {
        this();
        this.setSizes(sizes);
    }

    void setSizes(int length, int size) {
        if (this.a.length != length) {
            this.a = new int[length];
        }
        this.setSizes(0, length, size);
    }

    private int setSizes(int from, int to, int size) {
        if (to <= from) {
            return 0;
        }
        int m = (from + to) / 2;
        this.a[m] = size + this.setSizes(from, m, size);
        return this.a[m] + this.setSizes(m + 1, to, size);
    }

    public void setSizes(int[] sizes) {
        if (this.a.length != sizes.length) {
            this.a = new int[sizes.length];
        }
        this.setSizes(0, this.a.length, sizes);
    }

    private int setSizes(int from, int to, int[] sizes) {
        if (to <= from) {
            return 0;
        }
        int m = (from + to) / 2;
        this.a[m] = sizes[m] + this.setSizes(from, m, sizes);
        return this.a[m] + this.setSizes(m + 1, to, sizes);
    }

    public int[] getSizes() {
        int n = this.a.length;
        int[] sizes = new int[n];
        this.getSizes(0, n, sizes);
        return sizes;
    }

    private int getSizes(int from, int to, int[] sizes) {
        if (to <= from) {
            return 0;
        }
        int m = (from + to) / 2;
        sizes[m] = this.a[m] - this.getSizes(from, m, sizes);
        return this.a[m] + this.getSizes(m + 1, to, sizes);
    }

    public int getPosition(int index) {
        return this.getPosition(0, this.a.length, index);
    }

    private int getPosition(int from, int to, int index) {
        if (to <= from) {
            return 0;
        }
        int m = (from + to) / 2;
        if (index <= m) {
            return this.getPosition(from, m, index);
        }
        return this.a[m] + this.getPosition(m + 1, to, index);
    }

    public int getIndex(int position) {
        return this.getIndex(0, this.a.length, position);
    }

    private int getIndex(int from, int to, int position) {
        if (to <= from) {
            return from;
        }
        int m = (from + to) / 2;
        int pivot = this.a[m];
        if (position < pivot) {
            return this.getIndex(from, m, position);
        }
        return this.getIndex(m + 1, to, position - pivot);
    }

    public int getSize(int index) {
        return this.getPosition(index + 1) - this.getPosition(index);
    }

    public void setSize(int index, int size) {
        this.changeSize(0, this.a.length, index, size - this.getSize(index));
    }

    private void changeSize(int from, int to, int index, int delta) {
        if (to <= from) {
            return;
        }
        int m = (from + to) / 2;
        if (index <= m) {
            int n = m;
            this.a[n] = this.a[n] + delta;
            this.changeSize(from, m, index, delta);
        } else {
            this.changeSize(m + 1, to, index, delta);
        }
    }

    public void insertEntries(int start, int length, int value) {
        int i;
        int[] sizes = this.getSizes();
        int end = start + length;
        int n = this.a.length + length;
        this.a = new int[n];
        for (i = 0; i < start; ++i) {
            this.a[i] = sizes[i];
        }
        for (i = start; i < end; ++i) {
            this.a[i] = value;
        }
        for (i = end; i < n; ++i) {
            this.a[i] = sizes[i - length];
        }
        this.setSizes(this.a);
    }

    public void removeEntries(int start, int length) {
        int i;
        int[] sizes = this.getSizes();
        int end = start + length;
        int n = this.a.length - length;
        this.a = new int[n];
        for (i = 0; i < start; ++i) {
            this.a[i] = sizes[i];
        }
        for (i = start; i < n; ++i) {
            this.a[i] = sizes[i + length];
        }
        this.setSizes(this.a);
    }
}

