/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.tomcat.dbcp.pool2.impl.CallStack;

public class ThrowableCallStack
implements CallStack {
    private final String messageFormat;
    private final DateFormat dateFormat;
    private volatile Snapshot snapshot;

    public ThrowableCallStack(String string, boolean bl) {
        this.messageFormat = string;
        this.dateFormat = bl ? new SimpleDateFormat(string) : null;
    }

    @Override
    public void clear() {
        this.snapshot = null;
    }

    @Override
    public void fillInStackTrace() {
        this.snapshot = new Snapshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean printStackTrace(PrintWriter printWriter) {
        String string;
        Snapshot snapshot = this.snapshot;
        if (snapshot == null) {
            return false;
        }
        if (this.dateFormat == null) {
            string = this.messageFormat;
        } else {
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                string = this.dateFormat.format(snapshot.timestampMillis);
            }
        }
        printWriter.println(string);
        snapshot.printStackTrace(printWriter);
        return true;
    }

    private static class Snapshot
    extends Throwable {
        private static final long serialVersionUID = 1L;
        private final long timestampMillis = System.currentTimeMillis();

        private Snapshot() {
        }
    }
}

