/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CrawlerSessionManagerValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(CrawlerSessionManagerValve.class);
    private final Map<String, String> clientIdSessionId = new ConcurrentHashMap<String, String>();
    private final Map<String, String> sessionIdClientId = new ConcurrentHashMap<String, String>();
    private String crawlerUserAgents = ".*[bB]ot.*|.*Yahoo! Slurp.*|.*Feedfetcher-Google.*";
    private Pattern uaPattern = null;
    private String crawlerIps = null;
    private Pattern ipPattern = null;
    private int sessionInactiveInterval = 60;
    private boolean isHostAware = true;
    private boolean isContextAware = true;

    public CrawlerSessionManagerValve() {
        super(true);
    }

    public void setCrawlerUserAgents(String string) {
        this.crawlerUserAgents = string;
        this.uaPattern = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public String getCrawlerUserAgents() {
        return this.crawlerUserAgents;
    }

    public void setCrawlerIps(String string) {
        this.crawlerIps = string;
        this.ipPattern = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public String getCrawlerIps() {
        return this.crawlerIps;
    }

    public void setSessionInactiveInterval(int n) {
        this.sessionInactiveInterval = n;
    }

    public int getSessionInactiveInterval() {
        return this.sessionInactiveInterval;
    }

    public Map<String, String> getClientIpSessionId() {
        return this.clientIdSessionId;
    }

    public boolean isHostAware() {
        return this.isHostAware;
    }

    public void setHostAware(boolean bl) {
        this.isHostAware = bl;
    }

    public boolean isContextAware() {
        return this.isContextAware;
    }

    public void setContextAware(boolean bl) {
        this.isContextAware = bl;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.uaPattern = Pattern.compile(this.crawlerUserAgents);
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        HttpSession httpSession;
        boolean bl = false;
        String string = null;
        String string2 = request.getRemoteAddr();
        String string3 = this.getClientIdentifier(request.getHost(), request.getContext(), string2);
        if (log.isDebugEnabled()) {
            log.debug((Object)(request.hashCode() + ": ClientIdentifier=" + string3 + ", RequestedSessionId=" + request.getRequestedSessionId()));
        }
        if (request.getSession(false) == null) {
            httpSession = request.getHeaders("user-agent");
            String string4 = null;
            if (httpSession.hasMoreElements()) {
                string4 = httpSession.nextElement();
            }
            if (string4 != null && !httpSession.hasMoreElements()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(request.hashCode() + ": UserAgent=" + string4));
                }
                if (this.uaPattern.matcher(string4).matches()) {
                    bl = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(request.hashCode() + ": Bot found. UserAgent=" + string4));
                    }
                }
            }
            if (this.ipPattern != null && this.ipPattern.matcher(string2).matches()) {
                bl = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(request.hashCode() + ": Bot found. IP=" + string2));
                }
            }
            if (bl && (string = this.clientIdSessionId.get(string3)) != null) {
                request.setRequestedSessionId(string);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(request.hashCode() + ": SessionID=" + string));
                }
            }
        }
        this.getNext().invoke(request, response);
        if (bl) {
            if (string == null) {
                httpSession = request.getSession(false);
                if (httpSession != null) {
                    this.clientIdSessionId.put(string3, httpSession.getId());
                    this.sessionIdClientId.put(httpSession.getId(), string3);
                    httpSession.setAttribute(this.getClass().getName(), (Object)new CrawlerHttpSessionBindingListener(this.clientIdSessionId, string3));
                    httpSession.setMaxInactiveInterval(this.sessionInactiveInterval);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(request.hashCode() + ": New bot session. SessionID=" + httpSession.getId()));
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)(request.hashCode() + ": Bot session accessed. SessionID=" + string));
            }
        }
    }

    private String getClientIdentifier(Host host, Context context, String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (this.isHostAware) {
            stringBuilder.append('-').append(host.getName());
        }
        if (this.isContextAware && context != null) {
            stringBuilder.append(context.getName());
        }
        return stringBuilder.toString();
    }

    private static class CrawlerHttpSessionBindingListener
    implements HttpSessionBindingListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final transient Map<String, String> clientIdSessionId;
        private final transient String clientIdentifier;

        private CrawlerHttpSessionBindingListener(Map<String, String> map, String string) {
            this.clientIdSessionId = map;
            this.clientIdentifier = string;
        }

        public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
            if (this.clientIdentifier != null && this.clientIdSessionId != null) {
                this.clientIdSessionId.remove(this.clientIdentifier, httpSessionBindingEvent.getSession().getId());
            }
        }
    }
}

