/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.label.GoodsLabel;
import net.sf.freecol.client.gui.label.ProductionLabel;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.ConstructionPanel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropListener;
import net.sf.freecol.client.gui.panel.DropTarget;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.InPortPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.client.gui.panel.QuickActionMenu;
import net.sf.freecol.client.gui.panel.UnitPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.tooltip.RebelToolTip;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;

public final class ColonyPanel
extends PortPanel
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(ColonyPanel.class.getName());
    public static final int SCROLL_AREA_HEIGHT = 40;
    public static final int SCROLL_SPEED = 40;
    private JButton unloadButton = Utility.localizedButton("unload");
    private JButton fillButton = Utility.localizedButton("load");
    private JButton warehouseButton = Utility.localizedButton("colonyPanel.warehouse");
    private JButton buildQueueButton = Utility.localizedButton("colonyPanel.buildQueue");
    private JButton colonyUnitsButton = Utility.localizedButton("colonyPanel.colonyUnits");
    private JButton setGoodsButton = null;
    private JButton traceWorkButton = null;
    private Colony colony;
    private transient MouseListener releaseListener = null;
    private final JComboBox<Colony> nameBox = new JComboBox();
    private JPanel netProductionPanel = null;
    private JScrollPane buildingsScroll = null;
    private BuildingsPanel buildingsPanel = null;
    private JScrollPane cargoScroll = null;
    private ConstructionPanel constructionPanel = null;
    private JScrollPane inPortScroll = null;
    private JScrollPane outsideColonyScroll = null;
    private OutsideColonyPanel outsideColonyPanel = null;
    private PopulationPanel populationPanel = null;
    private JScrollPane tilesScroll = null;
    private TilesPanel tilesPanel = null;
    private JScrollPane warehouseScroll = null;
    private WarehousePanel warehousePanel = null;
    private final ActionListener unloadCmd = ae -> {
        Unit unit = this.getSelectedUnit();
        if (unit == null || !unit.isCarrier()) {
            return;
        }
        for (Goods goods : unit.getGoodsList()) {
            this.igc().unloadCargo(goods, false);
        }
        for (Unit u : unit.getUnitList()) {
            this.igc().leaveShip(u);
        }
        this.cargoPanel.update();
        this.updateOutsideColonyPanel();
        this.unloadButton.setEnabled(false);
        this.fillButton.setEnabled(false);
    };
    private final ActionListener warehouseCmd = ae -> {
        if (this.getGUI().showWarehouseDialog(this.getColony())) {
            this.updateWarehousePanel();
        }
    };
    private final ActionListener buildQueueCmd = ae -> {
        this.getGUI().showBuildQueuePanel(this.getColony());
        this.updateConstructionPanel();
    };
    private final ActionListener fillCmd = ae -> {
        Unit unit = this.getSelectedUnit();
        if (unit == null || !unit.isCarrier()) {
            return;
        }
        Colony colony = this.getColony();
        for (Goods goods : unit.getCompactGoodsList()) {
            GoodsType type = goods.getType();
            int space = unit.getLoadableAmount(type);
            int count = colony.getGoodsCount(type);
            if (space <= 0 || count <= 0) continue;
            int n = Math.min(space, count);
            this.igc().loadCargo(new Goods(goods.getGame(), colony, type, n), unit);
        }
    };
    private final ActionListener colonyUnitsCmd = ae -> this.generateColonyUnitsMenu();
    private final ActionListener setGoodsCmd = ae -> {
        DebugUtils.setColonyGoods(this.getFreeColClient(), this.colony);
        this.updateWarehousePanel();
        this.updateProduction();
    };
    private final ActionListener occupationCmd = ae -> this.colony.setOccupationTrace(!this.colony.getOccupationTrace());

    public ColonyPanel(FreeColClient freeColClient, Colony colony) {
        super(freeColClient, (LayoutManager)new MigLayout());
        this.getMigLayout().setLayoutConstraints("fill, wrap 2, insets 2");
        this.getMigLayout().setColumnConstraints("[" + this.getTilesScrollGuiScaledDimension().width + "px!][fill]");
        this.getMigLayout().setRowConstraints("[growprio 100,shrinkprio 10][]0[]0[][growprio 150,shrinkprio 50][][]");
        Player player = this.getMyPlayer();
        this.editable = colony.getOwner().getId().equals(player.getId());
        if (this.editable && FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            this.setGoodsButton = Utility.localizedButton("colonyPanel.setGoods");
            this.traceWorkButton = Utility.localizedButton("colonyPanel.traceWork");
        }
        ComponentInputMap closeIM = new ComponentInputMap(this.okButton);
        ((InputMap)closeIM).put(KeyStroke.getKeyStroke(27, 0, false), "pressed");
        ((InputMap)closeIM).put(KeyStroke.getKeyStroke(27, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.okButton, 2, closeIM);
        this.okButton.setText(Messages.message("close"));
        ComponentInputMap unloadIM = new ComponentInputMap(this.unloadButton);
        ((InputMap)unloadIM).put(KeyStroke.getKeyStroke(85, 0, false), "pressed");
        ((InputMap)unloadIM).put(KeyStroke.getKeyStroke(85, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.unloadButton, 2, unloadIM);
        ComponentInputMap fillIM = new ComponentInputMap(this.fillButton);
        ((InputMap)fillIM).put(KeyStroke.getKeyStroke(76, 0, false), "pressed");
        ((InputMap)fillIM).put(KeyStroke.getKeyStroke(76, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.fillButton, 2, fillIM);
        ComponentInputMap warehouseIM = new ComponentInputMap(this.warehouseButton);
        ((InputMap)warehouseIM).put(KeyStroke.getKeyStroke(87, 0, false), "pressed");
        ((InputMap)warehouseIM).put(KeyStroke.getKeyStroke(87, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.warehouseButton, 2, warehouseIM);
        ComponentInputMap buildQueueIM = new ComponentInputMap(this.buildQueueButton);
        ((InputMap)buildQueueIM).put(KeyStroke.getKeyStroke(66, 0, false), "pressed");
        ((InputMap)buildQueueIM).put(KeyStroke.getKeyStroke(66, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.buildQueueButton, 2, buildQueueIM);
        ComponentInputMap colonyUnitsIM = new ComponentInputMap(this.colonyUnitsButton);
        ((InputMap)colonyUnitsIM).put(KeyStroke.getKeyStroke(67, 0, false), "pressed");
        ((InputMap)colonyUnitsIM).put(KeyStroke.getKeyStroke(67, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.colonyUnitsButton, 2, colonyUnitsIM);
        this.defaultTransferHandler = new DefaultTransferHandler(freeColClient, this);
        this.pressListener = new DragListener(freeColClient, this);
        this.releaseListener = new DropListener();
        this.selectedUnitLabel = null;
        StringBuilder sb = new StringBuilder(32);
        String compat = colony.getName();
        if (this.editable) {
            for (Colony c : player.getColonyList()) {
                this.nameBox.addItem(c);
                sb.append(c.getName());
            }
        } else {
            this.nameBox.addItem(colony);
            sb.append(colony.getName());
        }
        Font nameBoxFont = FontLibrary.getScaledFont("header-plain-big", compat);
        this.nameBox.setFont(nameBoxFont);
        this.nameBox.setBorder(BorderFactory.createEmptyBorder());
        this.nameBox.setSelectedItem(colony);
        this.nameBox.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "selectPrevious2");
        this.nameBox.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "selectNext2");
        this.netProductionPanel = new JPanel();
        this.netProductionPanel.setOpaque(false);
        this.buildingsPanel = new BuildingsPanel();
        this.buildingsScroll = new JScrollPane(this.buildingsPanel, 20, 30);
        this.buildingsScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.buildingsScroll.getViewport().setOpaque(false);
        this.buildingsPanel.setOpaque(false);
        this.buildingsScroll.setBorder(Utility.ETCHED_BORDER);
        this.cargoPanel = new ColonyCargoPanel(freeColClient);
        this.cargoScroll = new JScrollPane(this.cargoPanel, 20, 30);
        this.cargoScroll.setBorder(Utility.ETCHED_BORDER);
        this.constructionPanel = new ConstructionPanel(freeColClient, colony, true);
        this.inPortPanel = new ColonyInPortPanel();
        this.inPortScroll = new JScrollPane(this.inPortPanel);
        this.inPortScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.inPortScroll.setBorder(Utility.ETCHED_BORDER);
        this.outsideColonyPanel = new OutsideColonyPanel();
        this.outsideColonyScroll = new JScrollPane(this.outsideColonyPanel, 20, 31);
        this.outsideColonyScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.outsideColonyScroll.setBorder(Utility.ETCHED_BORDER);
        this.populationPanel = new PopulationPanel();
        this.tilesPanel = new TilesPanel();
        this.tilesScroll = new JScrollPane(this.tilesPanel, 20, 30);
        this.tilesScroll.setBorder(Utility.BEVEL_BORDER);
        this.warehousePanel = new WarehousePanel();
        this.warehouseScroll = new JScrollPane(this.warehousePanel, 21, 30);
        this.warehouseScroll.setBorder(Utility.ETCHED_BORDER);
        ComponentInputMap nameIM = new ComponentInputMap(this.nameBox);
        ((InputMap)nameIM).put(KeyStroke.getKeyStroke("LEFT"), "selectPrevious2");
        ((InputMap)nameIM).put(KeyStroke.getKeyStroke("RIGHT"), "selectNext2");
        SwingUtilities.replaceUIInputMap(this.nameBox, 2, nameIM);
        this.initialize(colony);
        this.getGUI().restoreSavedSize(this, new Dimension(1050, 725));
    }

    private synchronized void setColony(Colony colony) {
        this.colony = colony;
    }

    private Dimension getTilesScrollGuiScaledDimension() {
        int tilesScrollWidth = 3 * this.getImageLibrary().getTileSize().width;
        int tilesScrollHeight = 3 * this.getImageLibrary().getTileSize().height;
        return new Dimension(tilesScrollWidth, tilesScrollHeight);
    }

    private void initialize(Colony colony) {
        this.cleanup();
        this.setColony(colony);
        this.addPropertyChangeListeners();
        this.addMouseListeners();
        this.setTransferHandlers(this.isEditable());
        this.unloadButton.addActionListener(this.unloadCmd);
        this.fillButton.addActionListener(this.fillCmd);
        this.warehouseButton.addActionListener(this.warehouseCmd);
        this.buildQueueButton.addActionListener(this.buildQueueCmd);
        this.colonyUnitsButton.addActionListener(this.colonyUnitsCmd);
        if (this.setGoodsButton != null) {
            this.setGoodsButton.addActionListener(this.setGoodsCmd);
        }
        if (this.traceWorkButton != null) {
            this.traceWorkButton.addActionListener(this.occupationCmd);
        }
        this.unloadButton.setEnabled(this.isEditable());
        this.fillButton.setEnabled(this.isEditable());
        this.warehouseButton.setEnabled(this.isEditable());
        this.buildQueueButton.setEnabled(this.isEditable());
        this.colonyUnitsButton.setEnabled(this.isEditable());
        if (this.setGoodsButton != null) {
            this.setGoodsButton.setEnabled(this.isEditable());
        }
        if (this.traceWorkButton != null) {
            this.traceWorkButton.setEnabled(this.isEditable());
        }
        GUI gui = this.getGUI();
        this.nameBox.setEnabled(this.isEditable());
        this.nameBox.addActionListener(ae -> {
            Colony newColony = (Colony)this.nameBox.getSelectedItem();
            this.closeColonyPanel();
            gui.showColonyPanel(newColony, null);
        });
        this.updateNetProductionPanel();
        this.buildingsPanel.initialize();
        this.cargoPanel.initialize();
        this.constructionPanel.initialize();
        this.inPortPanel.initialize();
        this.outsideColonyPanel.initialize();
        this.populationPanel.initialize();
        this.tilesPanel.initialize();
        this.warehousePanel.initialize();
        this.add(this.nameBox, "height 42:, grow");
        int tmp = (int)((float)ImageLibrary.ICON_SIZE.height * this.getImageLibrary().getScaleFactor());
        Dimension tilesScrollDimension = this.getTilesScrollGuiScaledDimension();
        this.add((Component)this.netProductionPanel, "grow, height " + (tmp + 10) + ":" + (tmp + 10) + ":" + (2 * tmp + 10));
        this.add((Component)this.tilesScroll, "width " + tilesScrollDimension.width + "px!, height " + tilesScrollDimension.height + "px!, top");
        this.add((Component)this.buildingsScroll, "span 1 3, grow");
        this.add((Component)this.populationPanel, "grow");
        this.add((Component)this.constructionPanel, "grow, top");
        this.add((Component)this.inPortScroll, "span, split 3, grow, sg, height 60:121:");
        this.add((Component)this.cargoScroll, "grow, sg, height 60:121:");
        this.add((Component)this.outsideColonyScroll, "grow, sg, height 60:121:");
        this.add((Component)this.warehouseScroll, "span, height 40:60:, growx");
        int buttonFields = 6;
        if (this.setGoodsButton != null) {
            ++buttonFields;
        }
        if (this.traceWorkButton != null) {
            ++buttonFields;
        }
        this.add((Component)this.unloadButton, "span, split " + Integer.toString(buttonFields) + ", align center");
        this.add(this.fillButton);
        this.add(this.warehouseButton);
        this.add(this.buildQueueButton);
        this.add(this.colonyUnitsButton);
        if (this.setGoodsButton != null) {
            this.add(this.setGoodsButton);
        }
        if (this.traceWorkButton != null) {
            this.add(this.traceWorkButton);
        }
        this.add((Component)this.okButton, "gapbefore push");
        this.update();
    }

    private void cleanup() {
        this.unloadButton.removeActionListener(this.unloadCmd);
        this.fillButton.removeActionListener(this.fillCmd);
        this.warehouseButton.removeActionListener(this.warehouseCmd);
        this.buildQueueButton.removeActionListener(this.buildQueueCmd);
        this.colonyUnitsButton.removeActionListener(this.colonyUnitsCmd);
        if (this.setGoodsButton != null) {
            this.setGoodsButton.removeActionListener(this.setGoodsCmd);
        }
        if (this.traceWorkButton != null) {
            this.traceWorkButton.removeActionListener(this.occupationCmd);
        }
        this.removePropertyChangeListeners();
        if (this.getSelectedUnit() != null) {
            this.getSelectedUnit().removePropertyChangeListener(this);
        }
        this.removeMouseListeners();
        for (MouseListener listener : this.getMouseListeners()) {
            this.removeMouseListener(listener);
        }
        this.setTransferHandlers(false);
        this.buildingsPanel.cleanup();
        this.cargoPanel.cleanup();
        this.constructionPanel.cleanup();
        this.inPortPanel.cleanup();
        this.outsideColonyPanel.cleanup();
        this.populationPanel.cleanup();
        this.tilesPanel.cleanup();
        this.warehousePanel.cleanup();
        this.removeAll();
    }

    private void addMouseListeners() {
        if (this.isEditable()) {
            this.cargoPanel.addMouseListener(this.releaseListener);
            this.inPortPanel.addMouseListener(this.releaseListener);
            this.outsideColonyPanel.addMouseListener(this.releaseListener);
            this.warehousePanel.addMouseListener(this.releaseListener);
        }
    }

    private void removeMouseListeners() {
        this.cargoPanel.removeMouseListener(this.releaseListener);
        this.inPortPanel.removeMouseListener(this.releaseListener);
        this.outsideColonyPanel.removeMouseListener(this.releaseListener);
        this.warehousePanel.removeMouseListener(this.releaseListener);
    }

    private void setTransferHandlers(boolean enable) {
        DefaultTransferHandler dth = enable ? this.defaultTransferHandler : null;
        this.cargoPanel.setTransferHandler(dth);
        this.inPortPanel.setTransferHandler(dth);
        this.outsideColonyPanel.setTransferHandler(dth);
        this.warehousePanel.setTransferHandler(dth);
    }

    private void addPropertyChangeListeners() {
        Colony colony = this.getColony();
        if (colony != null) {
            colony.addPropertyChangeListener(this);
            colony.getGoodsContainer().addPropertyChangeListener(this);
            colony.getTile().addPropertyChangeListener(this);
        }
    }

    private void removePropertyChangeListeners() {
        Colony colony = this.getColony();
        if (colony != null) {
            colony.removePropertyChangeListener(this);
            colony.getGoodsContainer().removePropertyChangeListener(this);
            colony.getTile().removePropertyChangeListener(this);
        }
    }

    private void updateProduction() {
        Colony colony = this.getColony();
        if (colony == null) {
            return;
        }
        for (WorkLocation wl : colony.getCurrentWorkLocationsList()) {
            boolean change = false;
            boolean check = wl.getProductionType() == null;
            for (Unit unit : CollectionUtils.transform(wl.getUnits(), u -> check || !wl.produces(u.getWorkType()))) {
                GoodsType workType = wl.getWorkFor(unit);
                if (workType == null || workType == unit.getWorkType()) continue;
                change |= this.igc().changeWorkType(unit, workType);
            }
            if (!change) continue;
            wl.updateProductionType();
        }
        this.updateTilesPanel();
        this.updateBuildingsPanel();
        this.updateNetProductionPanel();
        this.updateConstructionPanel();
    }

    public void update() {
        this.buildingsPanel.update();
        this.constructionPanel.update();
        this.inPortPanel.update();
        this.updateNetProductionPanel();
        this.outsideColonyPanel.update();
        this.populationPanel.update();
        this.tilesPanel.update();
        this.warehousePanel.update();
    }

    private void updateCarrierButtons() {
        Unit unit;
        Colony colony = this.getColony();
        this.unloadButton.setEnabled(false);
        this.fillButton.setEnabled(false);
        if (this.selectedUnitLabel != null && this.isEditable() && (unit = this.selectedUnitLabel.getUnit()) != null && unit.isCarrier() && unit.hasCargo()) {
            this.unloadButton.setEnabled(true);
            for (Goods goods : unit.getCompactGoodsList()) {
                if (colony.getGoodsCount(goods.getType()) <= 0) continue;
                this.fillButton.setEnabled(true);
                break;
            }
        }
    }

    private void generateColonyUnitsMenu() {
        int lastIndex;
        FreeColClient freeColClient = this.getFreeColClient();
        ImageLibrary lib = this.getImageLibrary();
        Colony colony = this.getColony();
        JPopupMenu colonyUnitsMenu = new JPopupMenu(Messages.message("colonyPanel.colonyUnits"));
        ImageIcon unitIcon = null;
        QuickActionMenu unitMenu = new QuickActionMenu(freeColClient, this);
        Tile colonyTile = colony.getTile();
        int unitNumber = 0;
        JMenuItem subMenu = null;
        for (Unit unit : colony.getUnitList()) {
            WorkLocation wl = unit.getWorkLocation();
            GoodsType goodsType = unit.getWorkType();
            Unit student = unit.getStudent();
            unitIcon = new ImageIcon(lib.getSmallerUnitImage(unit));
            StringBuilder sb = new StringBuilder(64);
            String prodLabel = Messages.message("colonyPanel.producing");
            if (student != null) {
                sb.append(unit.getDescription()).append(' ').append(prodLabel).append(' ').append(Messages.getName(unit.getType().getSkillTaught())).append(' ').append(unit.getTurnsOfTraining()).append('/').append(unit.getNeededTurnsOfTraining());
            } else if (wl != null && goodsType != null) {
                int producing = wl.getProductionOf(unit, goodsType);
                sb.append(unit.getDescription()).append(' ').append(prodLabel).append(' ').append(producing).append(' ').append(Messages.message(StringTemplate.template(goodsType).addAmount("%amount%", producing)));
            } else {
                sb.append(unit.getDescription()).append(' ').append(prodLabel).append(' ').append(Messages.message("nothing"));
            }
            String menuTitle = sb.toString();
            subMenu = new JMenuItem(menuTitle, unitIcon);
            subMenu.addActionListener(ae -> {
                unitMenu.addMenuItems(new UnitLabel(freeColClient, unit));
                this.getGUI().showPopupMenu(unitMenu, 0, 0);
            });
            ++unitNumber;
            colonyUnitsMenu.add(subMenu);
        }
        colonyUnitsMenu.addSeparator();
        for (Unit unit : colonyTile.getUnitList()) {
            String menuTitle;
            if (unit.isCarrier()) {
                unitIcon = new ImageIcon(lib.getSmallerUnitImage(unit));
                menuTitle = unit.getDescription() + " " + Messages.message("colonyPanel.inPort");
                subMenu = new JMenuItem(menuTitle, unitIcon);
                subMenu.addActionListener(ae -> {
                    unitMenu.addMenuItems(new UnitLabel(freeColClient, unit));
                    this.getGUI().showPopupMenu(unitMenu, 0, 0);
                });
                ++unitNumber;
                colonyUnitsMenu.add(subMenu);
                for (Unit innerUnit : unit.getUnitList()) {
                    unitIcon = new ImageIcon(lib.getSmallerUnitImage(innerUnit));
                    menuTitle = innerUnit.getDescription() + " " + Messages.message("cargoOnCarrier") + " " + unit.getDescription();
                    subMenu = new JMenuItem(menuTitle, unitIcon);
                    subMenu.addActionListener(ae -> {
                        unitMenu.addMenuItems(new UnitLabel(freeColClient, innerUnit));
                        this.getGUI().showPopupMenu(unitMenu, 0, 0);
                    });
                    ++unitNumber;
                    colonyUnitsMenu.add(subMenu);
                }
                continue;
            }
            if (unit.isOnCarrier()) continue;
            unitIcon = new ImageIcon(lib.getSmallerUnitImage(unit));
            menuTitle = unit.getDescription() + " " + Messages.message("colonyPanel.outsideColony");
            subMenu = new JMenuItem(menuTitle, unitIcon);
            subMenu.addActionListener(ae -> {
                unitMenu.addMenuItems(new UnitLabel(freeColClient, unit));
                this.getGUI().showPopupMenu(unitMenu, 0, 0);
            });
            ++unitNumber;
            colonyUnitsMenu.add(subMenu);
        }
        colonyUnitsMenu.addSeparator();
        int elements = colonyUnitsMenu.getSubElements().length;
        if (elements > 0 && colonyUnitsMenu.getComponent(lastIndex = colonyUnitsMenu.getComponentCount() - 1) instanceof JPopupMenu.Separator) {
            colonyUnitsMenu.remove(lastIndex);
        }
        this.getGUI().showPopupMenu(colonyUnitsMenu, 0, 0);
    }

    private boolean tryWork(Unit unit, WorkLocation wl) {
        GoodsType workType = wl.getWorkFor(unit);
        this.igc().work(unit, wl);
        if (unit.getLocation() != wl) {
            return false;
        }
        if (workType != null && workType != unit.getWorkType()) {
            this.igc().changeWorkType(unit, workType);
        }
        return true;
    }

    public final synchronized Colony getColony() {
        return this.colony;
    }

    public final TilesPanel getTilesPanel() {
        return this.tilesPanel;
    }

    public final WarehousePanel getWarehousePanel() {
        return this.warehousePanel;
    }

    @Override
    public void setSelectedUnitLabel(UnitLabel unitLabel) {
        if (this.selectedUnitLabel != unitLabel) {
            this.inPortPanel.removePropertyChangeListeners();
            if (this.selectedUnitLabel != null) {
                this.selectedUnitLabel.setSelected(false);
                this.selectedUnitLabel.getUnit().removePropertyChangeListener(this);
            }
            super.setSelectedUnitLabel(unitLabel);
            if (unitLabel == null) {
                this.cargoPanel.setCarrier(null);
            } else {
                this.cargoPanel.setCarrier(unitLabel.getUnit());
                unitLabel.setSelected(true);
                unitLabel.getUnit().addPropertyChangeListener(this);
            }
            this.inPortPanel.addPropertyChangeListeners();
        }
        this.updateCarrierButtons();
        this.inPortPanel.revalidate();
        this.inPortPanel.repaint();
    }

    @Override
    public boolean setSelectedUnit(Unit unit) {
        return unit.isCarrier() ? this.inPortPanel.setSelectedUnit(unit) : super.setSelectedUnit(unit);
    }

    private void updateBuildingsPanel() {
        this.buildingsPanel.update();
    }

    private void updateConstructionPanel() {
        this.constructionPanel.update();
    }

    private void updateInPortPanel() {
        this.inPortPanel.update();
    }

    private void updateNetProductionPanel() {
        FreeColClient freeColClient = this.getFreeColClient();
        Colony colony = this.getColony();
        Specification spec = colony.getSpecification();
        colony.invalidateCache();
        this.netProductionPanel.removeAll();
        for (GoodsType goodsType : spec.getGoodsTypeList()) {
            int amount = colony.getAdjustedNetProductionOf(goodsType);
            if (amount == 0) continue;
            AbstractGoods ag = new AbstractGoods(goodsType, amount);
            this.netProductionPanel.add(new ProductionLabel(freeColClient, ag));
        }
        this.netProductionPanel.revalidate();
        this.netProductionPanel.repaint();
    }

    private void updateOutsideColonyPanel() {
        this.outsideColonyPanel.update();
    }

    private void updatePopulationPanel() {
        this.populationPanel.update();
    }

    private void updateTilesPanel() {
        this.tilesPanel.update();
    }

    private void updateWarehousePanel() {
        this.warehousePanel.update();
    }

    public void closeColonyPanel() {
        Colony colony = this.getColony();
        Player player = this.getMyPlayer();
        boolean abandon = false;
        if (player.owns(colony)) {
            if (colony.getUnitCount() == 0) {
                String key;
                String string = key = player.isRebel() && player.getNumberOfPorts() == 1 && colony.isConnectedPort() ? "abandonColony.lastPort.text" : "abandonColony.text";
                if (!this.getGUI().confirm(null, StringTemplate.key(key), colony, "abandonColony.yes", "abandonColony.no")) {
                    return;
                }
                abandon = true;
            } else {
                int required;
                BuildableType buildable = colony.getCurrentlyBuilding();
                if (buildable != null && (required = buildable.getRequiredPopulation()) > colony.getUnitCount() && !this.getGUI().confirm(null, (StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("colonyPanel.reducePopulation").addName("%colony%", colony.getName())).addAmount("%number%", required)).addNamed("%buildable%", buildable), colony, "ok", "cancel")) {
                    return;
                }
            }
        }
        this.cleanup();
        this.getGUI().removeComponent(this);
        this.igc().closeColony(colony, abandon);
    }

    @Override
    public List<Unit> getUnitList() {
        return CollectionUtils.sort(this.colony.getTile().getUnits());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if ("OK".equals(ae.getActionCommand())) {
            this.closeColonyPanel();
        } else {
            super.actionPerformed(ae);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Colony colony = this.getColony();
        if (!this.isShowing() || colony == null) {
            return;
        }
        String property = event.getPropertyName();
        logger.finest(colony.getName() + " change " + property + ": " + event.getOldValue() + " -> " + event.getNewValue());
        if (property == null) {
            logger.warning("Null property change");
        } else if ("CARGO_CHANGE".equals(property)) {
            this.cargoPanel.update();
            this.updateInPortPanel();
        } else if (Colony.ColonyChangeEvent.POPULATION_CHANGE.toString().equals(property)) {
            this.updatePopulationPanel();
            this.updateNetProductionPanel();
        } else if (Colony.ColonyChangeEvent.BONUS_CHANGE.toString().equals(property)) {
            ModelMessage msg;
            if (colony.getUnitCount() > 0 && (msg = colony.checkForGovMgtChangeMessage()) != null) {
                this.getGUI().showInformationPanel((FreeColObject)colony, msg);
            }
            this.updatePopulationPanel();
        } else if (Colony.ColonyChangeEvent.BUILD_QUEUE_CHANGE.toString().equals(property)) {
            this.updateProduction();
        } else if (Colony.ColonyChangeEvent.UNIT_TYPE_CHANGE.toString().equals(property)) {
            FreeColGameObject object = (FreeColGameObject)event.getSource();
            UnitType oldType = (UnitType)event.getOldValue();
            UnitType newType = (UnitType)event.getNewValue();
            this.getGUI().showInformationPanel((FreeColObject)object, (StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("colonyPanel.unitChange").addName("%colony%", colony.getName())).addNamed("%oldType%", oldType)).addNamed("%newType%", newType));
            this.updateTilesPanel();
        } else if (property.startsWith("model.goods.")) {
            this.updateWarehousePanel();
            this.updateProduction();
        } else if ("TILE_UNIT_CHANGE".equals(property)) {
            this.updateOutsideColonyPanel();
            this.updateInPortPanel();
            this.updatePopulationPanel();
            this.updateWarehousePanel();
        } else if ("MOVE_CHANGE".equals(property)) {
            this.updateOutsideColonyPanel();
        } else {
            logger.warning("Unknown property change event: " + event.getPropertyName());
        }
    }

    @Override
    public void removeNotify() {
        if (this.colony == null) {
            return;
        }
        this.colony.setOccupationTrace(false);
        this.colony = null;
        super.removeNotify();
        this.unloadButton = null;
        this.fillButton = null;
        this.warehouseButton = null;
        this.buildQueueButton = null;
        this.colonyUnitsButton = null;
        this.setGoodsButton = null;
        this.traceWorkButton = null;
        this.netProductionPanel = null;
        this.buildingsPanel = null;
        this.buildingsScroll = null;
        this.cargoScroll = null;
        this.constructionPanel = null;
        this.inPortScroll = null;
        this.outsideColonyPanel = null;
        this.outsideColonyScroll = null;
        this.populationPanel = null;
        this.tilesPanel = null;
        this.tilesScroll = null;
        this.warehousePanel = null;
        this.warehouseScroll = null;
        this.releaseListener = null;
    }

    public final class TilesPanel
    extends JPanel {
        private final Tile[][] tiles = new Tile[3][3];
        private FreeColPanel cachedPanel = null;
        private WorkLocation bestLocation = null;

        public TilesPanel() {
            this.setBackground(Color.BLACK);
            this.setBorder(null);
            this.setLayout(null);
        }

        public void initialize() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony == null) {
                return;
            }
            this.cleanup();
            Tile tile = colony.getTile();
            this.tiles[0][0] = tile.getNeighbourOrNull(Direction.N);
            this.tiles[0][1] = tile.getNeighbourOrNull(Direction.NE);
            this.tiles[0][2] = tile.getNeighbourOrNull(Direction.E);
            this.tiles[1][0] = tile.getNeighbourOrNull(Direction.NW);
            this.tiles[1][1] = tile;
            this.tiles[1][2] = tile.getNeighbourOrNull(Direction.SE);
            this.tiles[2][0] = tile.getNeighbourOrNull(Direction.W);
            this.tiles[2][1] = tile.getNeighbourOrNull(Direction.SW);
            this.tiles[2][2] = tile.getNeighbourOrNull(Direction.S);
            int layer = 2;
            for (int x = 0; x < this.tiles.length; ++x) {
                for (int y = 0; y < this.tiles[x].length; ++y) {
                    if (this.tiles[x][y] == null) {
                        logger.warning("Null tile for " + ColonyPanel.this.getColony() + " at " + x + "," + y);
                        continue;
                    }
                    ColonyTile colonyTile = colony.getColonyTile(this.tiles[x][y]);
                    if (colonyTile == null) {
                        logger.warning("Null colony tile for " + ColonyPanel.this.getColony() + " on " + this.tiles[x][y] + " at " + x + "," + y);
                        CollectionUtils.dump("TILES", colony.getColonyTiles());
                        continue;
                    }
                    ASingleTilePanel aSTP = new ASingleTilePanel(colonyTile, x, y);
                    aSTP.initialize();
                    this.add((Component)aSTP, (Object)layer++);
                }
            }
            this.update();
        }

        public void cleanup() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleTilePanel)) continue;
                ((ASingleTilePanel)component).cleanup();
            }
            this.removeAll();
        }

        public void update() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleTilePanel)) continue;
                ((ASingleTilePanel)component).update();
            }
            this.repaint();
        }

        public void showPoorProduction(WorkLocation best, StringTemplate template) {
            if (this.bestLocation == best) {
                return;
            }
            if (this.cachedPanel != null) {
                ColonyPanel.this.getGUI().removeComponent(this.cachedPanel);
            }
            this.cachedPanel = ColonyPanel.this.getGUI().showInformationPanel((FreeColObject)best, template);
            this.bestLocation = best;
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                ColonyPanel.this.getGUI().displayColonyTiles((Graphics2D)g, this.tiles, colony);
            }
        }

        public final class ASingleTilePanel
        extends JPanel
        implements DropTarget,
        PropertyChangeListener {
            private final ColonyTile colonyTile;

            public ASingleTilePanel(ColonyTile colonyTile, int x, int y) {
                this.colonyTile = colonyTile;
                this.setLayout(new FlowLayout(1, 0, 0));
                this.setOpaque(false);
                Dimension size = ColonyPanel.this.getImageLibrary().getTileSize();
                this.setSize(size);
                this.setLocation((2 - x + y) * size.width / 2, (x + y) * size.height / 2);
            }

            public void initialize() {
                if (ColonyPanel.this.isEditable()) {
                    this.cleanup();
                    this.addMouseListener(ColonyPanel.this.pressListener);
                    this.addMouseListener(ColonyPanel.this.releaseListener);
                    this.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    this.addPropertyChangeListeners();
                }
            }

            public void cleanup() {
                this.removeMouseListener(ColonyPanel.this.pressListener);
                this.removeMouseListener(ColonyPanel.this.releaseListener);
                this.setTransferHandler(null);
                this.removePropertyChangeListeners();
                this.removeAll();
            }

            private void addPropertyChangeListeners() {
                if (this.colonyTile != null) {
                    this.colonyTile.addPropertyChangeListener(this);
                }
            }

            private void removePropertyChangeListeners() {
                if (this.colonyTile != null) {
                    this.colonyTile.removePropertyChangeListener(this);
                }
            }

            public void update() {
                this.removeAll();
                if (this.colonyTile == null) {
                    logger.warning("Update of " + ColonyPanel.this.getColony() + " null colony tile.");
                    return;
                }
                FreeColClient fcc = ColonyPanel.this.getFreeColClient();
                UnitLabel label = null;
                for (Unit unit : this.colonyTile.getUnitList()) {
                    label = new UnitLabel(fcc, unit, false, false);
                    if (ColonyPanel.this.isEditable()) {
                        label.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                        label.addMouseListener(ColonyPanel.this.pressListener);
                    }
                    super.add(label);
                }
                this.updateDescriptionLabel(label);
                if (this.colonyTile.isColonyCenterTile()) {
                    this.setLayout(new GridLayout(2, 1));
                    ProductionInfo info = ColonyPanel.this.colony.getProductionInfo(this.colonyTile);
                    if (info != null) {
                        for (AbstractGoods ag : info.getProduction()) {
                            ProductionLabel productionLabel = new ProductionLabel(fcc, ag);
                            productionLabel.addMouseListener(ColonyPanel.this.pressListener);
                            this.add(productionLabel);
                        }
                    }
                }
            }

            public ColonyTile getColonyTile() {
                return this.colonyTile;
            }

            private void updateDescriptionLabel(UnitLabel unitLabel) {
                String tileMsg = Messages.message(this.colonyTile.getLabel());
                if (unitLabel == null) {
                    this.setToolTipText(tileMsg);
                } else {
                    Unit unit = unitLabel.getUnit();
                    unitLabel.setDescriptionLabel(tileMsg + " [" + unit.getDescription(Unit.UnitLabelType.NATIONAL) + "]");
                }
            }

            private boolean tryWork(Unit unit) {
                WorkLocation best;
                UnitLocation.NoAddReason reason;
                Colony colony = ColonyPanel.this.getColony();
                Tile tile = this.colonyTile.getWorkTile();
                Player player = unit.getOwner();
                if (tile.getOwningSettlement() != colony) {
                    Player.NoClaimReason claim = player.canClaimForSettlementReason(tile);
                    switch (claim) {
                        case NONE: 
                        case NATIVES: {
                            if (ColonyPanel.this.igc().claimTile(tile, colony) && tile.getOwningSettlement() == colony) {
                                logger.info("Colony " + colony.getName() + " claims tile " + tile + " with unit " + unit.getId());
                                break;
                            }
                            logger.warning("Colony " + colony.getName() + " did not claim " + tile + " with unit " + unit.getId());
                            return false;
                        }
                        default: {
                            ColonyPanel.this.getGUI().showInformationPanel((FreeColObject)tile, claim.getDescriptionKey());
                            return false;
                        }
                    }
                    if (tile.getOwningSettlement() != colony) {
                        throw new RuntimeException("Claim failed: " + claim);
                    }
                }
                if ((reason = this.colonyTile.getNoAddReason(unit)) != UnitLocation.NoAddReason.NONE) {
                    ColonyPanel.this.getGUI().showInformationPanel((FreeColObject)this.colonyTile, StringTemplate.template(reason.getDescriptionKey()));
                    return false;
                }
                if (!ColonyPanel.this.tryWork(unit, this.colonyTile)) {
                    return false;
                }
                GoodsType workType = unit.getWorkType();
                if (workType != null && ColonyPanel.this.getClientOptions().getBoolean("model.option.guiShowNotBestTile") && (best = colony.getWorkLocationFor(unit, workType)) != null && this.colonyTile != best && this.colonyTile.getPotentialProduction(workType, unit.getType()) < best.getPotentialProduction(workType, unit.getType())) {
                    Object template = ((StringTemplate)((StringTemplate)StringTemplate.template("colonyPanel.notBestTile").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL))).addNamed("%goods%", workType)).addStringTemplate("%tile%", best.getLabel());
                    TilesPanel.this.showPoorProduction(best, (StringTemplate)template);
                }
                return true;
            }

            @Override
            public boolean accepts(Unit unit) {
                return unit.isPerson();
            }

            @Override
            public Component add(Component comp, boolean editState) {
                if (editState) {
                    if (comp instanceof UnitLabel) {
                        UnitLabel label = (UnitLabel)comp;
                        if (!this.tryWork(label.getUnit())) {
                            return null;
                        }
                        label.setSmall(false);
                    } else {
                        logger.warning("An invalid component was dropped on this ASingleTilePanel.");
                        return null;
                    }
                }
                this.update();
                return comp;
            }

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getPropertyName();
                logger.finest(this.colonyTile.getId() + " change " + property + ": " + event.getOldValue() + " -> " + event.getNewValue());
                ColonyPanel.this.updateProduction();
            }

            @Override
            public boolean contains(int px, int py) {
                int dy;
                int w = this.getWidth();
                int h = this.getHeight();
                int dx = Math.abs(w / 2 - px);
                return dx + w * (dy = Math.abs(h / 2 - py)) / h <= w / 2;
            }
        }
    }

    public final class BuildingsPanel
    extends MigPanel {
        private final MouseAdapter buildQueueListener;

        public BuildingsPanel() {
            super("BuildingsPanelUI", new MigLayout("fill, wrap 4, insets 0, gap 0:10:10:push"));
            this.buildQueueListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ColonyPanel.this.getGUI().showBuildQueuePanel(ColonyPanel.this.getColony());
                }
            };
        }

        public void initialize() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony == null) {
                return;
            }
            this.cleanup();
            for (Building building : CollectionUtils.sort(colony.getBuildings())) {
                ASingleBuildingPanel aSBP = new ASingleBuildingPanel(building);
                aSBP.initialize();
                this.add(aSBP);
            }
            this.update();
        }

        public void cleanup() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleBuildingPanel)) continue;
                ((ASingleBuildingPanel)component).cleanup();
            }
            this.removeAll();
        }

        public void update() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleBuildingPanel)) continue;
                ((ASingleBuildingPanel)component).update();
            }
            this.repaint();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.removeAll();
            this.setLayout(null);
        }

        public final class ASingleBuildingPanel
        extends BuildingPanel
        implements DropTarget {
            public ASingleBuildingPanel(Building building) {
                super(ColonyPanel.this.getFreeColClient(), building);
                this.setOpaque(false);
            }

            @Override
            public void initialize() {
                if (ColonyPanel.this.isEditable()) {
                    super.initialize();
                    this.addMouseListener(ColonyPanel.this.releaseListener);
                    this.addMouseListener(BuildingsPanel.this.buildQueueListener);
                    this.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                }
            }

            @Override
            protected void cleanup() {
                super.cleanup();
                this.removeMouseListener(ColonyPanel.this.releaseListener);
                this.removeMouseListener(BuildingsPanel.this.buildQueueListener);
                this.setTransferHandler(null);
                this.removeAll();
            }

            @Override
            public void update() {
                super.update();
                if (ColonyPanel.this.isEditable()) {
                    for (UnitLabel unitLabel : this.getUnitLabels()) {
                        unitLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                        unitLabel.addMouseListener(ColonyPanel.this.pressListener);
                    }
                }
            }

            private boolean tryWork(Unit unit) {
                Building building = this.getBuilding();
                UnitLocation.NoAddReason reason = building.getNoAddReason(unit);
                if (reason != UnitLocation.NoAddReason.NONE) {
                    ColonyPanel.this.getGUI().showInformationPanel((FreeColObject)building, reason.getDescriptionKey());
                    return false;
                }
                return ColonyPanel.this.tryWork(unit, building);
            }

            @Override
            public boolean accepts(Goods goods) {
                return false;
            }

            @Override
            public boolean accepts(GoodsType goodsType) {
                return false;
            }

            @Override
            public boolean accepts(Unit unit) {
                return unit.isPerson();
            }

            @Override
            public Component add(Component comp, boolean editState) {
                if (editState) {
                    if (comp instanceof UnitLabel) {
                        if (!this.tryWork(((UnitLabel)comp).getUnit())) {
                            return null;
                        }
                    } else {
                        logger.warning("An invalid component was dropped on this ASingleBuildingPanel.");
                        return null;
                    }
                    this.update();
                }
                return null;
            }

            @Override
            public int suggested(GoodsType type) {
                return -1;
            }

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                super.propertyChange(event);
                ColonyPanel.this.updateProduction();
            }
        }
    }

    public final class WarehousePanel
    extends MigPanel
    implements DropTarget,
    PropertyChangeListener {
        public WarehousePanel() {
            super("WarehousePanelUI", new MigLayout("fill, gap push, insets 0"));
        }

        public void initialize() {
            this.cleanup();
            this.addPropertyChangeListeners();
            this.update();
        }

        public void cleanup() {
            this.removePropertyChangeListeners();
            this.removeAll();
        }

        private void addPropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getGoodsContainer().addPropertyChangeListener(this);
            }
        }

        private void removePropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getGoodsContainer().removePropertyChangeListener(this);
            }
        }

        public void update() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony == null) {
                return;
            }
            this.removeAll();
            ClientOptions options = ColonyPanel.this.getClientOptions();
            int threshold = FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) ? 1 : options.getInteger("model.option.guiMinNumberToDisplayGoods");
            Game game = colony.getGame();
            Specification spec = colony.getSpecification();
            for (GoodsType goodsType : spec.getStorableGoodsTypeList()) {
                int count = colony.getGoodsCount(goodsType);
                if (count < threshold) continue;
                Goods goods = new Goods(game, colony, goodsType, count);
                GoodsLabel goodsLabel = new GoodsLabel(ColonyPanel.this.getFreeColClient(), goods);
                if (ColonyPanel.this.isEditable()) {
                    goodsLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    goodsLabel.addMouseListener(ColonyPanel.this.pressListener);
                }
                this.add((Component)goodsLabel, "alignx center");
            }
            ColonyPanel.this.updateProduction();
            this.revalidate();
            this.repaint();
        }

        @Override
        public boolean accepts(Goods goods) {
            return true;
        }

        @Override
        public boolean accepts(GoodsType goodsType) {
            return false;
        }

        @Override
        public boolean accepts(Unit unit) {
            return false;
        }

        @Override
        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (!(comp instanceof GoodsLabel)) {
                    logger.warning("Invalid component: " + comp);
                    return null;
                }
                comp.getParent().remove(comp);
                return comp;
            }
            return this.add(comp);
        }

        @Override
        public int suggested(GoodsType type) {
            Colony colony = ColonyPanel.this.getColony();
            return colony.getWarehouseCapacity() - colony.getGoodsCount(type);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null && event != null) {
                logger.finest(colony.getName() + "-warehouse change " + event.getPropertyName() + ": " + event.getOldValue() + " -> " + event.getNewValue());
            }
            this.update();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.removeAll();
            this.setLayout(null);
        }
    }

    public final class ColonyInPortPanel
    extends InPortPanel {
        public ColonyInPortPanel() {
            super(new MigLayout("wrap 3, fill, insets 0"), ColonyPanel.this, null, ColonyPanel.this.isEditable());
            this.setBorder(Utility.localizedBorder("colonyPanel.inPort"));
        }

        @Override
        public void initialize() {
            super.initialize();
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                this.setName(colony.getName() + " - " + Messages.message("port"));
            }
        }

        @Override
        protected void addPropertyChangeListeners() {
            Unit selected = ColonyPanel.this.getSelectedUnit();
            if (selected != null) {
                selected.addPropertyChangeListener("CARGO_CHANGE", this);
            }
        }

        @Override
        protected void removePropertyChangeListeners() {
            Unit selected = ColonyPanel.this.getSelectedUnit();
            if (selected != null) {
                selected.removePropertyChangeListener("CARGO_CHANGE", this);
            }
        }

        @Override
        public boolean accepts(Unit unit) {
            return unit.isCarrier();
        }

        @Override
        public void selectLabel() {
            this.removePropertyChangeListeners();
            super.selectLabel();
            this.addPropertyChangeListeners();
        }
    }

    public final class OutsideColonyPanel
    extends UnitPanel
    implements DropTarget {
        public OutsideColonyPanel() {
            super("OutsideColonyPanelUI", new MigLayout("wrap 3, fill, insets 0"), ColonyPanel.this, null, ColonyPanel.this.isEditable());
            this.setBorder(Utility.localizedBorder("colonyPanel.outsideColony"));
        }

        @Override
        public void initialize() {
            super.initialize();
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                this.setName(colony.getName() + " - " + Messages.message("port"));
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.removeAll();
        }

        @Override
        protected void addPropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getTile().addPropertyChangeListener("TILE_UNIT_CHANGE", this);
            }
        }

        @Override
        protected void removePropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getTile().removePropertyChangeListener("TILE_UNIT_CHANGE", this);
            }
        }

        @Override
        public boolean accepts(Goods goods) {
            return false;
        }

        @Override
        public boolean accepts(GoodsType goodsType) {
            return false;
        }

        @Override
        public boolean accepts(Unit unit) {
            return !unit.isCarrier();
        }

        @Override
        public void selectLabel() {
        }

        @Override
        public Component add(Component comp, boolean editState) {
            Container oldParent = comp.getParent();
            if (editState) {
                if (comp instanceof UnitLabel) {
                    UnitLabel unitLabel = (UnitLabel)comp;
                    Unit unit = unitLabel.getUnit();
                    if (!unit.isOnCarrier()) {
                        ColonyPanel.this.igc().putOutsideColony(unit);
                    }
                    if (unit.getColony() == null) {
                        ColonyPanel.this.closeColonyPanel();
                        return null;
                    }
                    if (!unit.isOnTile() && !unit.isOnCarrier()) {
                        return null;
                    }
                    oldParent.remove(comp);
                    this.initialize();
                    return comp;
                }
                logger.warning("Invalid component: " + comp);
                return null;
            }
            ((UnitLabel)comp).setSmall(false);
            return this.add(comp);
        }

        @Override
        public int suggested(GoodsType type) {
            return -1;
        }
    }

    public final class PopulationPanel
    extends MigPanel {
        private final JLabel rebelShield;
        private final JLabel rebelLabel;
        private final JLabel bonusLabel;
        private final JLabel royalistLabel;
        private final JLabel royalistShield;
        private final JLabel rebelMemberLabel;
        private final JLabel popLabel;
        private final JLabel royalistMemberLabel;

        public PopulationPanel() {
            super("PopulationPanelUI", new MigLayout("wrap 5, fill, insets 0", "[][]:push[center]:push[right][]"));
            this.rebelShield = new JLabel();
            this.rebelLabel = new JLabel();
            this.bonusLabel = new JLabel();
            this.royalistLabel = new JLabel();
            this.royalistShield = new JLabel();
            this.rebelMemberLabel = new JLabel();
            this.popLabel = new JLabel();
            this.royalistMemberLabel = new JLabel();
            this.setOpaque(false);
            this.setToolTipText(" ");
        }

        public void initialize() {
            this.cleanup();
            this.update();
        }

        public void cleanup() {
        }

        public void update() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony == null) {
                return;
            }
            ImageLibrary lib = ColonyPanel.this.getImageLibrary();
            Font font = FontLibrary.getScaledFont("normal-plain-smaller", null);
            int uc = colony.getUnitCount();
            int solPercent = colony.getSoL();
            int rebels = Colony.calculateRebels(uc, solPercent);
            Nation nation = colony.getOwner().getNation();
            int grow = colony.getPreferredSizeChange();
            int bonus = colony.getProductionBonus();
            this.removeAll();
            this.rebelShield.setIcon(new ImageIcon(lib.getSmallerNationImage(nation)));
            this.add((Component)this.rebelShield, "bottom");
            Object t = StringTemplate.template("colonyPanel.rebelLabel").addAmount("%number%", rebels);
            this.rebelLabel.setText(Messages.message(t));
            this.rebelLabel.setFont(font);
            this.add((Component)this.rebelLabel, "split 2, flowy");
            this.rebelMemberLabel.setText(solPercent + "%");
            this.rebelMemberLabel.setFont(font);
            this.add(this.rebelMemberLabel);
            t = StringTemplate.template("colonyPanel.populationLabel").addAmount("%number%", uc);
            this.popLabel.setText(Messages.message(t));
            this.popLabel.setFont(font);
            this.add((Component)this.popLabel, "split 2, flowy");
            String growth = grow == 0 ? "" : "(" + (grow >= 10 ? Messages.message("many") : String.valueOf(grow)) + ")";
            t = ((StringTemplate)StringTemplate.template("colonyPanel.bonusLabel").addAmount("%number%", bonus)).addName("%extra%", growth);
            this.bonusLabel.setText(Messages.message(t));
            this.bonusLabel.setFont(font);
            this.add(this.bonusLabel);
            t = StringTemplate.template("colonyPanel.royalistLabel").addAmount("%number%", uc - rebels);
            this.royalistLabel.setText(Messages.message(t));
            this.royalistLabel.setFont(font);
            this.add((Component)this.royalistLabel, "split 2, flowy");
            this.royalistMemberLabel.setText(colony.getTory() + "%");
            this.royalistMemberLabel.setFont(font);
            this.add(this.royalistMemberLabel);
            Nation other = colony.getOwner().isREF() ? nation.getRebelNation() : nation.getREFNation();
            try {
                this.royalistShield.setIcon(new ImageIcon(lib.getSmallerNationImage(other)));
                this.add((Component)this.royalistShield, "bottom");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Shield: " + nation + "/" + other, e);
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        public JToolTip createToolTip() {
            RebelToolTip toolTip = new RebelToolTip(ColonyPanel.this.getFreeColClient(), ColonyPanel.this.getColony());
            return toolTip;
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.removeAll();
            this.setLayout(null);
        }
    }

    public final class ColonyCargoPanel
    extends CargoPanel {
        public ColonyCargoPanel(FreeColClient freeColClient) {
            super(freeColClient, true);
        }

        @Override
        public void update() {
            super.update();
            ColonyPanel.this.updateCarrierButtons();
            ColonyPanel.this.updatePopulationPanel();
        }
    }
}

