/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class Frame
implements Component {
    private final List<? extends CharSequence> name;
    private final ISkinParam skinParam;
    private final Rose rose = new Rose();

    @Override
    public Style[] getUsedStyles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StyleSignatureBasic getStyleSignature() {
        throw new UnsupportedOperationException();
    }

    public Frame(List<? extends CharSequence> name, ISkinParam skinParam) {
        this.name = name;
        this.skinParam = skinParam;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        HColor lineColor = this.rose.getHtmlColor(this.skinParam, ColorParam.packageBorder);
        ug = ug.apply(lineColor);
        ug = ug.apply(new HColorNone().bg());
        ug.apply(new UStroke(1.4)).draw(new URectangle(dimensionToUse.getWidth(), dimensionToUse.getHeight()));
        TextBlock textBlock = this.createTextBloc();
        textBlock.drawU(ug.apply(new UTranslate(2.0, 2.0)));
        Dimension2D textDim = this.getTextDim(ug.getStringBounder());
        double x = textDim.getWidth() + 6.0;
        double y = textDim.getHeight() + 6.0;
        UPolygon poly = new UPolygon();
        poly.addPoint(x, 0.0);
        poly.addPoint(x, y - 6.0);
        poly.addPoint(x - 6.0, y);
        poly.addPoint(0.0, y);
        poly.addPoint(0.0, 0.0);
        ug.apply(new UStroke(1.4)).draw(poly);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Dimension2D dim = this.getTextDim(stringBounder);
        return dim.getHeight() + 8.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        Dimension2D dim = this.getTextDim(stringBounder);
        return dim.getWidth() + 8.0;
    }

    public Dimension2D getTextDim(StringBounder stringBounder) {
        TextBlock bloc = this.createTextBloc();
        return bloc.calculateDimension(stringBounder);
    }

    private TextBlock createTextBloc() {
        UFont font = this.skinParam.getFont(null, false, FontParam.PACKAGE);
        HColor textColor = this.skinParam.getFontHtmlColor(null, FontParam.PACKAGE);
        throw new UnsupportedOperationException();
    }

    @Override
    public final Dimension2D getPreferredDimension(StringBounder stringBounder) {
        double w = this.getPreferredWidth(stringBounder);
        double h = this.getPreferredHeight(stringBounder);
        return new Dimension2DDouble(w, h);
    }
}

