/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.sf.sdedit.ui.components.TextArea;
import net.sf.sdedit.ui.impl.DiagramTextTab;

public class FilterCommandField
extends JTextField
implements ActionListener,
KeyListener,
Runnable {
    private static final long serialVersionUID = 6277977346048865956L;
    private ArrayList<String> history;
    private int historyPointer;
    private String currentText;
    private String homeDir;
    private boolean first;
    private Process process;
    private String text;
    private boolean selection;
    private TextArea textArea;
    private final DiagramTextTab tab;

    public FilterCommandField(DiagramTextTab tab) {
        this.tab = tab;
        this.addActionListener(this);
        this.addKeyListener(this);
        this.history = new ArrayList();
        this.historyPointer = 0;
        this.currentText = null;
        this.homeDir = System.getProperty("user.home");
        this.first = true;
    }

    public void reset() {
        this.currentText = null;
        if (this.first) {
            this.setText("<enter filter command>");
            this.selectAll();
            this.first = false;
        } else {
            this.setText("");
        }
        this.historyPointer = this.history.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String command) throws IOException {
        this.history.add(command);
        if (this.homeDir != null && !this.homeDir.equals("")) {
            command = command.replaceAll("~", this.homeDir);
        }
        this.selection = true;
        if (this.tab == null) {
            return;
        }
        this.textArea = this.tab.getTextArea();
        this.text = this.tab.getTextArea().getSelectedText();
        if (this.text == null) {
            this.selection = false;
            this.text = this.tab.getTextArea().getText();
        }
        FilterCommandField filterCommandField = this;
        synchronized (filterCommandField) {
            this.process = Runtime.getRuntime().exec(command);
            this.changeBackground(Color.RED);
        }
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            OutputStreamWriter osw = new OutputStreamWriter(new BufferedOutputStream(this.process.getOutputStream()));
            PrintWriter writer = new PrintWriter(osw);
            writer.print(this.text);
            writer.flush();
            writer.close();
            StringBuffer output = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                output.append(line + "\n");
                line = reader.readLine();
            }
            StringBuffer errors = new StringBuffer();
            line = errorReader.readLine();
            while (line != null) {
                errors.append(line + "\n");
                line = errorReader.readLine();
            }
            reader.close();
            errorReader.close();
            final String result = output.toString().trim();
            String error = errors.toString().trim();
            if (!error.equals("")) {
                this.tab.get_UI().errorMessage(null, null, "The filter command returned an error:\n" + error);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (FilterCommandField.this.selection) {
                            FilterCommandField.this.textArea.replaceSelection(result);
                        } else {
                            FilterCommandField.this.textArea.setText(result);
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            FilterCommandField filterCommandField = this;
            synchronized (filterCommandField) {
                if (this.process != null) {
                    this.tab.get_UI().errorMessage(e, null, null);
                }
            }
        }
        finally {
            FilterCommandField filterCommandField = this;
            synchronized (filterCommandField) {
                this.process = null;
                this.changeBackground(Color.WHITE);
            }
            this.tab.leaveFilterMode();
        }
    }

    private void changeBackground(final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FilterCommandField.this.setBackground(color);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.process != null) {
            return;
        }
        String command = this.getText().trim();
        if (command.equals("")) {
            return;
        }
        try {
            this.execute(command);
        }
        catch (IOException ex) {
            this.tab.get_UI().errorMessage(ex, null, null);
        }
    }

    private void useHistory(int direction) {
        if (this.historyPointer == this.history.size() && direction > 0) {
            return;
        }
        if (this.historyPointer == 0 && direction < 0) {
            return;
        }
        this.historyPointer += direction;
        if (this.historyPointer == this.history.size()) {
            this.setText(this.currentText);
            this.currentText = null;
        } else {
            if (this.currentText == null) {
                this.currentText = this.getText();
            }
            this.setText(this.history.get(this.historyPointer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            this.useHistory(-1);
        } else if (e.getKeyCode() == 40) {
            this.useHistory(1);
        } else if (e.getKeyCode() == 27) {
            FilterCommandField filterCommandField = this;
            synchronized (filterCommandField) {
                if (this.process != null) {
                    this.process.destroy();
                    this.process = null;
                } else {
                    this.tab.leaveFilterMode();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

