/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.List;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.validate.ListScope;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.checkerframework.checker.nullness.qual.Nullable;

class WithScope
extends ListScope {
    private final SqlWithItem withItem;

    WithScope(SqlValidatorScope parent, SqlWithItem withItem) {
        super(parent);
        this.withItem = withItem;
    }

    @Override
    public SqlNode getNode() {
        return this.withItem;
    }

    @Override
    public @Nullable SqlValidatorNamespace getTableNamespace(List<String> names) {
        if (names.size() == 1 && names.get(0).equals(this.withItem.name.getSimple())) {
            return this.validator.getNamespace(this.withItem);
        }
        return super.getTableNamespace(names);
    }

    @Override
    public void resolveTable(List<String> names, SqlNameMatcher nameMatcher, SqlValidatorScope.Path path, SqlValidatorScope.Resolved resolved) {
        if (names.size() == 1 && names.equals(this.withItem.name.names)) {
            SqlValidatorNamespace ns = this.validator.getNamespaceOrThrow(this.withItem);
            SqlValidatorScope.Step path2 = path.plus(ns.getRowType(), 0, names.get(0), StructKind.FULLY_QUALIFIED);
            resolved.found(ns, false, null, path2, null);
            return;
        }
        super.resolveTable(names, nameMatcher, path, resolved);
    }
}

