/* This file is automatically generated by Lemon from input grammar
** source file "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon". */
/* protobuf_lang_parser.lemon
 *
 * C Protocol Buffers Language (PBL) Parser (for *.proto files)
 * Copyright 2020, Huang Qiangxiong <qiangxiong.huang@qq.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

/* This parser is mainly to get MESSAGE, ENUM, and FIELD information from *.proto files.
 * There are two formats of *.proto files:
 * 1) Protocol Buffers Version 3 Language Specification:
 *      https://developers.google.com/protocol-buffers/docs/reference/proto3-spec
 * 2) Protocol Buffers Version 2 Language Specification:
 *      https://developers.google.com/protocol-buffers/docs/reference/proto2-spec
 * There are some errors about 'proto', 'option' (value) and 'reserved' (fieldName) definitions on that sites.
 * This parser is created because Wireshark is mainly implemented in plain ANSI C but the offical
 * Protocol Buffers Language parser is implemented in C++.
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <glib.h>
#include <assert.h>
#include <wsutil/file_util.h>
#include "protobuf_lang_tree.h"
#include "protobuf_lang_parser.h"
#include "protobuf_lang_scanner_lex.h"

#define NAME_TO_BE_SET "<NAME_TO_BE_SET>"
#define NEED_NOT_NAME "<NEED_NOT_NAME>"

static void *ProtobufLangParserAlloc(void *(*mallocProc)(size_t));
static void ProtobufLangParser(void *yyp, int yymajor, protobuf_lang_token_t *yyminor, protobuf_lang_state_t *state);
static void ProtobufLangParserFree(void *p, void (*freeProc)(void*));

/* Error handling function for parser */
void protobuf_lang_error(void* yyscanner, protobuf_lang_state_t *state, const char *msg);

/* Extended error handling function */
void pbl_parser_error(protobuf_lang_state_t *state, const char *fmt, ...);

/* It's just the approximate line number which is gotten when a grammar rule is reduced
   by the parser (lemon). That might be overridden by the lineno argument of
   pbl_set_node_name() later. */
#define CUR_LINENO (protobuf_lang_get_lineno(state->scanner))

#line 77 "./protobuf_lang_parser.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols.
***************** Begin token definitions *************************************/
#ifndef PT_IDENT
#define PT_IDENT                        1
#define PT_SYNTAX                       2
#define PT_IMPORT                       3
#define PT_WEAK                         4
#define PT_PUBLIC                       5
#define PT_PACKAGE                      6
#define PT_OPTION                       7
#define PT_REQUIRED                     8
#define PT_OPTIONAL                     9
#define PT_REPEATED                    10
#define PT_ONEOF                       11
#define PT_MAP                         12
#define PT_RESERVED                    13
#define PT_ENUM                        14
#define PT_GROUP                       15
#define PT_EXTEND                      16
#define PT_EXTENSIONS                  17
#define PT_MESSAGE                     18
#define PT_SERVICE                     19
#define PT_RPC                         20
#define PT_STREAM                      21
#define PT_RETURNS                     22
#define PT_TO                          23
#define PT_ASSIGN                      24
#define PT_SEMICOLON                   25
#define PT_LPAREN                      26
#define PT_RPAREN                      27
#define PT_DOT                         28
#define PT_LCURLY                      29
#define PT_RCURLY                      30
#define PT_STRLIT                      31
#define PT_LBRACKET                    32
#define PT_RBRACKET                    33
#define PT_EQUAL                       34
#define PT_NOTEQUAL                    35
#define PT_NOTEQUAL2                   36
#define PT_GEQUAL                      37
#define PT_LEQUAL                      38
#define PT_ASSIGN_PLUS                 39
#define PT_PLUS                        40
#define PT_MINUS                       41
#define PT_MULTIPLY                    42
#define PT_DIV                         43
#define PT_LOGIC_OR                    44
#define PT_OR                          45
#define PT_LOGIC_AND                   46
#define PT_AND                         47
#define PT_NOT                         48
#define PT_NEG                         49
#define PT_XOR                         50
#define PT_SHL                         51
#define PT_SHR                         52
#define PT_PERCENT                     53
#define PT_DOLLAR                      54
#define PT_COND                        55
#define PT_COMMA                       56
#define PT_COLON                       57
#define PT_LESS                        58
#define PT_GREATER                     59
#define PT_DECIMALLIT                  60
#define PT_OCTALLIT                    61
#define PT_HEXLIT                      62
#endif
/**************** End token definitions ***************************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ProtobufLangParserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ProtobufLangParserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ProtobufLangParserARG_SDECL     A static variable declaration for the %extra_argument
**    ProtobufLangParserARG_PDECL     A parameter declaration for the %extra_argument
**    ProtobufLangParserARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ProtobufLangParserARG_STORE     Code to store %extra_argument into yypParser
**    ProtobufLangParserARG_FETCH     Code to extract %extra_argument from yypParser
**    ProtobufLangParserCTX_*         As ProtobufLangParserARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 126
#define YYACTIONTYPE unsigned short int
#define ProtobufLangParserTOKENTYPE  protobuf_lang_token_t* 
typedef union {
  int yyinit;
  ProtobufLangParserTOKENTYPE yy0;
  int yy4;
  protobuf_lang_token_t* yy140;
  gchar* yy148;
  pbl_node_t* yy205;
  guint64 yy246;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ProtobufLangParserARG_SDECL  protobuf_lang_state_t *state ;
#define ProtobufLangParserARG_PDECL , protobuf_lang_state_t *state 
#define ProtobufLangParserARG_PARAM ,state 
#define ProtobufLangParserARG_FETCH  protobuf_lang_state_t *state =yypParser->state ;
#define ProtobufLangParserARG_STORE yypParser->state =state ;
#define ProtobufLangParserCTX_SDECL
#define ProtobufLangParserCTX_PDECL
#define ProtobufLangParserCTX_PARAM
#define ProtobufLangParserCTX_FETCH
#define ProtobufLangParserCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             152
#define YYNRULE              181
#define YYNRULE_WITH_ACTION  77
#define YYNTOKEN             63
#define YY_MAX_SHIFT         151
#define YY_MIN_SHIFTREDUCE   316
#define YY_MAX_SHIFTREDUCE   496
#define YY_ERROR_ACTION      497
#define YY_ACCEPT_ACTION     498
#define YY_NO_ACTION         499
#define YY_MIN_REDUCE        500
#define YY_MAX_REDUCE        680
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (477)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   139,  496,  525,  496,  141,  545,   90,  545,   92,  545,
 /*    10 */   129,  545,  131,  545,   94,  545,   96,   59,  103,  509,
 /*    20 */    88,  544,   88,   46,  420,  437,  410,  411,  438,   84,
 /*    30 */   403,  406,  412,  413,  414,  415,  416,  417,  418,  419,
 /*    40 */   421,  422,  423,  424,  425,  426,  427,  428,  429,  430,
 /*    50 */   431,  432,  433,  434,  435,  436,  439,  440,  441,  442,
 /*    60 */   382,  383,  384,  496,  511,   35,   35,   29,   29,   22,
 /*    70 */   357,  358,  359,   56,  124,   12,   61,   57,   51,   21,
 /*    80 */    62,  530,   87,  653,  654,  648,  649,  494,  496,  496,
 /*    90 */   531,   86,  367,   89,  547,   22,  357,  358,  359,   56,
 /*   100 */   124,   12,   61,   57,   51,   21,   62,  475,  643,  644,
 /*   110 */    35,  146,   29,  494,  146,  496,  549,  569,  368,  641,
 /*   120 */   569,   22,  357,  358,  359,   56,  124,   12,   61,   57,
 /*   130 */    51,   21,   62,  122,  496,   42,   60,  544,   38,  494,
 /*   140 */   544,  357,  358,  359,  328,  503,  503,  139,   57,  391,
 /*   150 */   546,  570,  503,  516,  570,  503,  496,  514,  494,  515,
 /*   160 */   666,  550,  527,  377,  642,  503,   73,   74,  518,  663,
 /*   170 */   519,  517,  631,  579,  580,  581,  582,  496,  382,  383,
 /*   180 */   384,   71,  633,  635,  382,  383,  384,   67,  632,  634,
 /*   190 */    72,   22,  496,  391,  665,  496,  127,   55,   61,  137,
 /*   200 */    51,  544,   62,   50,  496,   84,   58,  391,   22,  494,
 /*   210 */    22,  357,  358,  359,  130,   48,   34,   33,   57,  555,
 /*   220 */    42,   60,   29,   29,  130,  544,  494,   22,  494,  146,
 /*   230 */   526,  467,  657,  369,  148,  569,  382,  383,  384,  139,
 /*   240 */    49,   45,  563,  656,  658,  494,  496,  106,   91,  547,
 /*   250 */   344,  106,   22,  108,  118,  565,  564,  142,   12,   98,
 /*   260 */    97,   98,  118,   66,   65,  391,   71,   29,  669,  570,
 /*   270 */   494,   29,   29,   32,   32,  336,  466,    4,  522,  147,
 /*   280 */    75,   29,   29,  382,  383,  384,  589,   29,   29,   64,
 /*   290 */    32,   32,  496,  496,  113,  128,  565,   93,  547,  637,
 /*   300 */   638,  128,  496,  498,  151,   63,  636,   95,  547,  382,
 /*   310 */   383,  384,  574,  496,  548,    8,   29,   71,   32,   70,
 /*   320 */   592,   22,  573,   99,   99,    9,   29,   71,  496,   70,
 /*   330 */   593,  123,   29,  591,  560,   32,   10,  102,   71,  494,
 /*   340 */    70,  640,  117,  116,  462,  565,  572,  104,   47,  565,
 /*   350 */    85,  117,  382,  383,  384,  105,  571,  565,    4,  138,
 /*   360 */   107,  111,  565,  565,  112,  119,  565,  565,  121,  126,
 /*   370 */   120,  132,  134,  136,  126,  121,  143,  134,  136,  143,
 /*   380 */   144,  132,  144,  317,  461,  150,  125,  375,   76,  392,
 /*   390 */   373,  355,  145,   19,   13,  353,  133,   14,   15,  477,
 /*   400 */   135,  476,   16,  510,  140,  322,  321,  320,  149,   19,
 /*   410 */   100,  392,  392,  392,  101,    6,    7,   36,    5,   19,
 /*   420 */    11,    1,   68,   19,    2,    3,   37,   20,  352,   43,
 /*   430 */    69,   18,   38,   44,  109,  351,  349,   39,  114,   77,
 /*   440 */   110,  350,  348,   40,   52,  115,   41,  374,   78,   24,
 /*   450 */    53,   54,  372,   25,   58,   79,   26,   80,   27,   81,
 /*   460 */   356,   28,  392,  354,   30,   31,  339,   23,   17,  578,
 /*   470 */   577,  400,  399,   82,   83,  324,  323,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   103,    1,  103,    1,  105,  103,  104,  103,  104,  103,
 /*    10 */   104,  103,  104,  103,  104,  103,  104,   65,    2,   69,
 /*    20 */   123,   69,  125,   21,   24,   25,   26,   27,   28,   29,
 /*    30 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*    40 */    40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
 /*    50 */    50,   51,   52,   53,   54,   55,   56,   57,   58,   59,
 /*    60 */    60,   61,   62,    1,  114,   69,   70,   69,   70,    7,
 /*    70 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*    80 */    18,   84,   85,  111,  112,  111,  112,   25,    1,    1,
 /*    90 */    93,   94,   30,   95,   96,    7,    8,    9,   10,   11,
 /*   100 */    12,   13,   14,   15,   16,   17,   18,   25,  111,  112,
 /*   110 */   114,   63,  114,   25,   63,    1,   68,   69,   30,   68,
 /*   120 */    69,    7,    8,    9,   10,   11,   12,   13,   14,   15,
 /*   130 */    16,   17,   18,   65,    1,   64,   65,   69,   56,   25,
 /*   140 */    69,    8,    9,   10,   30,   81,   82,  103,   15,   31,
 /*   150 */   103,  103,   88,   82,  103,   91,    1,   86,   25,   88,
 /*   160 */    69,  113,  103,   30,  113,  101,    4,    5,   97,  125,
 /*   170 */    99,  100,  101,  109,  110,  111,  112,    1,   60,   61,
 /*   180 */    62,   26,  111,  112,   60,   61,   62,    3,  117,  118,
 /*   190 */     6,    7,    1,   31,  103,    1,   64,   65,   14,   63,
 /*   200 */    16,   69,   18,   19,    1,   29,   15,   31,    7,   25,
 /*   210 */     7,    8,    9,   10,   69,   21,   40,   41,   15,   87,
 /*   220 */    64,   65,   69,   70,   79,   69,   25,    7,   25,   63,
 /*   230 */   103,   30,  100,   30,   68,   69,   60,   61,   62,  103,
 /*   240 */    20,   21,   86,  111,  112,   25,    1,   69,   95,   96,
 /*   250 */    30,   73,    7,   67,   69,   69,  100,   69,   13,  123,
 /*   260 */   124,  125,   77,   40,   41,   31,   26,  114,  112,  103,
 /*   270 */    25,   69,   70,   69,   70,   30,   25,   80,   90,  113,
 /*   280 */    29,   69,   70,   60,   61,   62,   69,   69,   70,   40,
 /*   290 */    69,   70,    1,    1,   67,   69,   69,   95,   96,  111,
 /*   300 */   112,   75,    1,  106,  107,  108,  118,   95,   96,   60,
 /*   310 */    61,   62,   69,    1,   96,   24,  114,   26,  114,   28,
 /*   320 */   103,    7,   69,  119,  120,   24,  114,   26,    1,   28,
 /*   330 */   113,   66,  114,  116,   69,  114,   24,   63,   26,   25,
 /*   340 */    28,  120,   69,   67,   30,   69,  103,   67,   21,   69,
 /*   350 */    63,   78,   60,   61,   62,   67,  103,   69,   80,   63,
 /*   360 */    67,   67,   69,   69,   67,   67,   69,   69,   69,   69,
 /*   370 */    33,   69,   69,   69,   74,   76,   69,   74,   74,   72,
 /*   380 */    69,   79,   71,   25,   25,  107,   33,   25,   29,   31,
 /*   390 */    25,   25,   69,   56,   32,   25,   33,   32,   32,   25,
 /*   400 */    33,   25,   32,  114,   33,   25,   25,   25,   69,   56,
 /*   410 */    63,   31,   31,   31,   63,  102,   92,  122,   98,   56,
 /*   420 */    89,   83,   24,   56,   83,   83,  121,   56,   27,   56,
 /*   430 */    56,  115,   56,   26,   22,   27,   27,   26,   22,   29,
 /*   440 */    27,   27,   27,   26,   59,   27,   26,   25,   29,   24,
 /*   450 */    56,   58,   25,   24,   15,   29,   24,   29,   24,   29,
 /*   460 */    25,   24,   31,   25,   24,   23,   25,   24,   32,    0,
 /*   470 */     0,   25,   25,   29,   29,   27,   25,  126,  126,  126,
 /*   480 */   126,  126,  126,  126,  126,  126,  126,  126,  126,  126,
 /*   490 */   126,  126,  126,  126,  126,  126,  126,  126,  126,  126,
 /*   500 */   126,  126,  126,  126,  126,  126,  126,  126,  126,  126,
 /*   510 */   126,  126,  126,  126,  126,  126,  126,  126,  126,  126,
 /*   520 */   126,  126,  126,  126,  126,  126,  126,  126,  126,  126,
 /*   530 */   126,  126,  126,  126,  126,  126,  126,  126,  126,  126,
};
#define YY_SHIFT_COUNT    (151)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (470)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */    16,   62,   88,  114,  184,  203,  133,  220,  176,  176,
 /*    10 */   176,  245,  118,  155,  155,  155,  155,  155,    0,  155,
 /*    20 */   155,  124,  155,  223,  249,  249,  249,  249,  249,  291,
 /*    30 */   249,  292,  301,  292,  292,  312,  201,  314,  124,    2,
 /*    40 */   194,  327,  191,   87,   87,   87,   87,   87,   87,   87,
 /*    50 */    87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
 /*    60 */    87,   87,   87,  477,  124,  124,  124,  162,  234,  234,
 /*    70 */   240,   87,   87,  234,  234,  477,  477,  477,  477,  477,
 /*    80 */   477,  477,  477,  477,  477,  358,  251,  359,   82,  337,
 /*    90 */   362,  353,  365,  363,  366,  367,  370,  374,  376,  371,
 /*   100 */   380,  381,  382,  398,  401,  373,  407,  408,  409,  411,
 /*   110 */   412,  413,  414,  415,  417,  416,  418,  420,  410,  419,
 /*   120 */   422,  425,  385,  394,  393,  427,  429,  439,  426,  428,
 /*   130 */   432,  430,  434,  435,  437,  438,  440,  431,  431,  442,
 /*   140 */   441,  436,  443,  444,  445,  448,  431,  446,  447,  451,
 /*   150 */   469,  470,
};
#define YY_REDUCE_COUNT (84)
#define YY_REDUCE_MIN   (-103)
#define YY_REDUCE_MAX   (351)
static const short yy_reduce_ofst[] = {
 /*     0 */   197,   71,   71,   71,   64,  132,  156,   -3,   48,   51,
 /*    10 */   166,  188,  136,   -2,  153,  202,  212,  204,  217,  218,
 /*    20 */   221, -103,   -4, -101,  -98,  -96,  -94,  -92,  -90,  -50,
 /*    30 */   -88,   91,  -50,  243,  253,  -50,  -28,  -26,   44,  186,
 /*    40 */   227,  276,  -48,  280,  288,  178,  293,  294,  297,  273,
 /*    50 */   185,  298,  299,   68,  265,  300,  226,  145,  302,  303,
 /*    60 */   304,  307,  311,  278,   47,   59,  127,  274,  287,  296,
 /*    70 */   289,  323,  339,  347,  351,  295,  305,  324,  313,  320,
 /*    80 */   338,  341,  331,  342,  316,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   502,  497,  497,  497,  500,  497,  497,  497,  497,  497,
 /*    10 */   497,  497,  497,  497,  497,  497,  497,  497,  497,  497,
 /*    20 */   497,  497,  497,  497,  497,  497,  497,  497,  497,  497,
 /*    30 */   497,  497,  497,  497,  497,  497,  497,  497,  497,  497,
 /*    40 */   497,  497,  497,  497,  497,  497,  497,  497,  497,  497,
 /*    50 */   497,  497,  497,  497,  497,  497,  497,  497,  497,  497,
 /*    60 */   497,  497,  497,  502,  497,  497,  497,  497,  497,  497,
 /*    70 */   497,  497,  497,  497,  497,  652,  647,  529,  562,  554,
 /*    80 */   513,  513,  521,  513,  588,  497,  497,  497,  497,  497,
 /*    90 */   497,  497,  497,  497,  497,  497,  497,  497,  497,  497,
 /*   100 */   497,  497,  497,  497,  497,  497,  497,  497,  497,  497,
 /*   110 */   497,  497,  497,  497,  497,  497,  497,  497,  497,  497,
 /*   120 */   497,  497,  497,  497,  497,  497,  497,  497,  497,  497,
 /*   130 */   497,  497,  497,  497,  497,  497,  497,  667,  668,  664,
 /*   140 */   497,  524,  497,  497,  497,  497,  679,  497,  497,  497,
 /*   150 */   497,  497,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.
** If a construct like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*   PT_IDENT => nothing */
    1,  /*  PT_SYNTAX => PT_IDENT */
    1,  /*  PT_IMPORT => PT_IDENT */
    1,  /*    PT_WEAK => PT_IDENT */
    1,  /*  PT_PUBLIC => PT_IDENT */
    1,  /* PT_PACKAGE => PT_IDENT */
    1,  /*  PT_OPTION => PT_IDENT */
    1,  /* PT_REQUIRED => PT_IDENT */
    1,  /* PT_OPTIONAL => PT_IDENT */
    1,  /* PT_REPEATED => PT_IDENT */
    1,  /*   PT_ONEOF => PT_IDENT */
    1,  /*     PT_MAP => PT_IDENT */
    1,  /* PT_RESERVED => PT_IDENT */
    1,  /*    PT_ENUM => PT_IDENT */
    1,  /*   PT_GROUP => PT_IDENT */
    1,  /*  PT_EXTEND => PT_IDENT */
    1,  /* PT_EXTENSIONS => PT_IDENT */
    1,  /* PT_MESSAGE => PT_IDENT */
    1,  /* PT_SERVICE => PT_IDENT */
    1,  /*     PT_RPC => PT_IDENT */
    1,  /*  PT_STREAM => PT_IDENT */
    1,  /* PT_RETURNS => PT_IDENT */
    1,  /*      PT_TO => PT_IDENT */
    0,  /*  PT_ASSIGN => nothing */
    0,  /* PT_SEMICOLON => nothing */
    0,  /*  PT_LPAREN => nothing */
    0,  /*  PT_RPAREN => nothing */
    0,  /*     PT_DOT => nothing */
    0,  /*  PT_LCURLY => nothing */
    0,  /*  PT_RCURLY => nothing */
    0,  /*  PT_STRLIT => nothing */
    0,  /* PT_LBRACKET => nothing */
    0,  /* PT_RBRACKET => nothing */
    0,  /*   PT_EQUAL => nothing */
    0,  /* PT_NOTEQUAL => nothing */
    0,  /* PT_NOTEQUAL2 => nothing */
    0,  /*  PT_GEQUAL => nothing */
    0,  /*  PT_LEQUAL => nothing */
    0,  /* PT_ASSIGN_PLUS => nothing */
    0,  /*    PT_PLUS => nothing */
    0,  /*   PT_MINUS => nothing */
    0,  /* PT_MULTIPLY => nothing */
    0,  /*     PT_DIV => nothing */
    0,  /* PT_LOGIC_OR => nothing */
    0,  /*      PT_OR => nothing */
    0,  /* PT_LOGIC_AND => nothing */
    0,  /*     PT_AND => nothing */
    0,  /*     PT_NOT => nothing */
    0,  /*     PT_NEG => nothing */
    0,  /*     PT_XOR => nothing */
    0,  /*     PT_SHL => nothing */
    0,  /*     PT_SHR => nothing */
    0,  /* PT_PERCENT => nothing */
    0,  /*  PT_DOLLAR => nothing */
    0,  /*    PT_COND => nothing */
    0,  /*   PT_COMMA => nothing */
    0,  /*   PT_COLON => nothing */
    0,  /*    PT_LESS => nothing */
    0,  /* PT_GREATER => nothing */
    0,  /* PT_DECIMALLIT => nothing */
    0,  /* PT_OCTALLIT => nothing */
    0,  /*  PT_HEXLIT => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ProtobufLangParserARG_SDECL                /* A place to hold %extra_argument */
  ProtobufLangParserCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
#include <assert.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ProtobufLangParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  /*    0 */ "$",
  /*    1 */ "PT_IDENT",
  /*    2 */ "PT_SYNTAX",
  /*    3 */ "PT_IMPORT",
  /*    4 */ "PT_WEAK",
  /*    5 */ "PT_PUBLIC",
  /*    6 */ "PT_PACKAGE",
  /*    7 */ "PT_OPTION",
  /*    8 */ "PT_REQUIRED",
  /*    9 */ "PT_OPTIONAL",
  /*   10 */ "PT_REPEATED",
  /*   11 */ "PT_ONEOF",
  /*   12 */ "PT_MAP",
  /*   13 */ "PT_RESERVED",
  /*   14 */ "PT_ENUM",
  /*   15 */ "PT_GROUP",
  /*   16 */ "PT_EXTEND",
  /*   17 */ "PT_EXTENSIONS",
  /*   18 */ "PT_MESSAGE",
  /*   19 */ "PT_SERVICE",
  /*   20 */ "PT_RPC",
  /*   21 */ "PT_STREAM",
  /*   22 */ "PT_RETURNS",
  /*   23 */ "PT_TO",
  /*   24 */ "PT_ASSIGN",
  /*   25 */ "PT_SEMICOLON",
  /*   26 */ "PT_LPAREN",
  /*   27 */ "PT_RPAREN",
  /*   28 */ "PT_DOT",
  /*   29 */ "PT_LCURLY",
  /*   30 */ "PT_RCURLY",
  /*   31 */ "PT_STRLIT",
  /*   32 */ "PT_LBRACKET",
  /*   33 */ "PT_RBRACKET",
  /*   34 */ "PT_EQUAL",
  /*   35 */ "PT_NOTEQUAL",
  /*   36 */ "PT_NOTEQUAL2",
  /*   37 */ "PT_GEQUAL",
  /*   38 */ "PT_LEQUAL",
  /*   39 */ "PT_ASSIGN_PLUS",
  /*   40 */ "PT_PLUS",
  /*   41 */ "PT_MINUS",
  /*   42 */ "PT_MULTIPLY",
  /*   43 */ "PT_DIV",
  /*   44 */ "PT_LOGIC_OR",
  /*   45 */ "PT_OR",
  /*   46 */ "PT_LOGIC_AND",
  /*   47 */ "PT_AND",
  /*   48 */ "PT_NOT",
  /*   49 */ "PT_NEG",
  /*   50 */ "PT_XOR",
  /*   51 */ "PT_SHL",
  /*   52 */ "PT_SHR",
  /*   53 */ "PT_PERCENT",
  /*   54 */ "PT_DOLLAR",
  /*   55 */ "PT_COND",
  /*   56 */ "PT_COMMA",
  /*   57 */ "PT_COLON",
  /*   58 */ "PT_LESS",
  /*   59 */ "PT_GREATER",
  /*   60 */ "PT_DECIMALLIT",
  /*   61 */ "PT_OCTALLIT",
  /*   62 */ "PT_HEXLIT",
  /*   63 */ "strLit",
  /*   64 */ "label",
  /*   65 */ "type",
  /*   66 */ "keyType",
  /*   67 */ "messageType",
  /*   68 */ "constant",
  /*   69 */ "exIdent",
  /*   70 */ "optionName",
  /*   71 */ "messageName",
  /*   72 */ "enumName",
  /*   73 */ "streamName",
  /*   74 */ "fieldName",
  /*   75 */ "oneofName",
  /*   76 */ "mapName",
  /*   77 */ "serviceName",
  /*   78 */ "rpcName",
  /*   79 */ "groupName",
  /*   80 */ "protoBody",
  /*   81 */ "topLevelDef",
  /*   82 */ "message",
  /*   83 */ "messageBody",
  /*   84 */ "rpc",
  /*   85 */ "rpcDecl",
  /*   86 */ "field",
  /*   87 */ "oneofField",
  /*   88 */ "enum",
  /*   89 */ "enumBody",
  /*   90 */ "enumField",
  /*   91 */ "service",
  /*   92 */ "serviceBody",
  /*   93 */ "stream",
  /*   94 */ "streamDecl",
  /*   95 */ "fieldOptions",
  /*   96 */ "fieldOption",
  /*   97 */ "oneof",
  /*   98 */ "oneofBody",
  /*   99 */ "mapField",
  /*  100 */ "group",
  /*  101 */ "extend",
  /*  102 */ "extendBody",
  /*  103 */ "intLit",
  /*  104 */ "fieldNumber",
  /*  105 */ "enumNumber",
  /*  106 */ "proto",
  /*  107 */ "wholeProtoBody",
  /*  108 */ "syntax",
  /*  109 */ "import",
  /*  110 */ "package",
  /*  111 */ "option",
  /*  112 */ "emptyStatement",
  /*  113 */ "customOptionValue",
  /*  114 */ "extIdentInParentheses",
  /*  115 */ "customOptionBody",
  /*  116 */ "symbolsWithoutCurly",
  /*  117 */ "extensions",
  /*  118 */ "reserved",
  /*  119 */ "enumValueOptions",
  /*  120 */ "enumValueOption",
  /*  121 */ "rpcBody",
  /*  122 */ "streamBody",
  /*  123 */ "ranges",
  /*  124 */ "quoteFieldNames",
  /*  125 */ "range",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "wholeProtoBody ::= protoBody",
 /*   1 */ "syntax ::= PT_SYNTAX PT_ASSIGN strLit PT_SEMICOLON",
 /*   2 */ "protoBody ::=",
 /*   3 */ "protoBody ::= protoBody topLevelDef",
 /*   4 */ "import ::= PT_IMPORT strLit PT_SEMICOLON",
 /*   5 */ "import ::= PT_IMPORT PT_PUBLIC strLit PT_SEMICOLON",
 /*   6 */ "import ::= PT_IMPORT PT_WEAK strLit PT_SEMICOLON",
 /*   7 */ "package ::= PT_PACKAGE exIdent PT_SEMICOLON",
 /*   8 */ "extIdentInParentheses ::= PT_LPAREN exIdent PT_RPAREN",
 /*   9 */ "optionName ::= optionName exIdent",
 /*  10 */ "optionName ::= optionName PT_DOT extIdentInParentheses",
 /*  11 */ "optionName ::= optionName extIdentInParentheses",
 /*  12 */ "message ::= PT_MESSAGE messageName PT_LCURLY messageBody PT_RCURLY",
 /*  13 */ "messageBody ::=",
 /*  14 */ "messageBody ::= messageBody field",
 /*  15 */ "messageBody ::= messageBody enum",
 /*  16 */ "messageBody ::= messageBody message",
 /*  17 */ "messageBody ::= messageBody group",
 /*  18 */ "messageBody ::= messageBody oneof",
 /*  19 */ "messageBody ::= messageBody mapField",
 /*  20 */ "enum ::= PT_ENUM enumName PT_LCURLY enumBody PT_RCURLY",
 /*  21 */ "enumBody ::=",
 /*  22 */ "enumBody ::= enumBody enumField",
 /*  23 */ "enumField ::= exIdent PT_ASSIGN enumNumber PT_LBRACKET enumValueOptions PT_RBRACKET PT_SEMICOLON",
 /*  24 */ "enumField ::= exIdent PT_ASSIGN enumNumber",
 /*  25 */ "enumNumber ::= intLit",
 /*  26 */ "enumNumber ::= PT_PLUS intLit",
 /*  27 */ "enumNumber ::= PT_MINUS intLit",
 /*  28 */ "service ::= PT_SERVICE serviceName PT_LCURLY serviceBody PT_RCURLY",
 /*  29 */ "serviceBody ::=",
 /*  30 */ "serviceBody ::= serviceBody rpc",
 /*  31 */ "serviceBody ::= serviceBody stream",
 /*  32 */ "rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN",
 /*  33 */ "rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN",
 /*  34 */ "rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN",
 /*  35 */ "rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN",
 /*  36 */ "streamDecl ::= PT_STREAM streamName PT_LPAREN messageType PT_COMMA messageType PT_RPAREN",
 /*  37 */ "field ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON",
 /*  38 */ "field ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON",
 /*  39 */ "field ::= label type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON",
 /*  40 */ "field ::= label type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON",
 /*  41 */ "label ::= PT_REQUIRED",
 /*  42 */ "label ::= PT_OPTIONAL",
 /*  43 */ "label ::= PT_REPEATED",
 /*  44 */ "type ::= exIdent",
 /*  45 */ "fieldNumber ::= intLit",
 /*  46 */ "fieldNumber ::= PT_PLUS intLit",
 /*  47 */ "fieldOptions ::= fieldOption",
 /*  48 */ "fieldOptions ::= fieldOptions PT_COMMA fieldOption",
 /*  49 */ "fieldOption ::= optionName PT_ASSIGN constant",
 /*  50 */ "fieldOption ::= optionName PT_ASSIGN customOptionValue",
 /*  51 */ "group ::= PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY",
 /*  52 */ "group ::= label PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY",
 /*  53 */ "oneof ::= PT_ONEOF oneofName PT_LCURLY oneofBody PT_RCURLY",
 /*  54 */ "oneofBody ::=",
 /*  55 */ "oneofBody ::= oneofBody oneofField",
 /*  56 */ "oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON",
 /*  57 */ "oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON",
 /*  58 */ "mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON",
 /*  59 */ "mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_SEMICOLON",
 /*  60 */ "keyType ::= exIdent",
 /*  61 */ "extend ::= PT_EXTEND messageType PT_LCURLY extendBody PT_RCURLY",
 /*  62 */ "extendBody ::=",
 /*  63 */ "extendBody ::= extendBody field",
 /*  64 */ "extendBody ::= extendBody group",
 /*  65 */ "messageType ::= exIdent",
 /*  66 */ "intLit ::= PT_DECIMALLIT",
 /*  67 */ "intLit ::= PT_OCTALLIT",
 /*  68 */ "intLit ::= PT_HEXLIT",
 /*  69 */ "constant ::= exIdent",
 /*  70 */ "constant ::= intLit",
 /*  71 */ "constant ::= PT_PLUS intLit",
 /*  72 */ "constant ::= PT_MINUS intLit",
 /*  73 */ "constant ::= PT_PLUS exIdent",
 /*  74 */ "constant ::= PT_MINUS exIdent",
 /*  75 */ "strLit ::= PT_STRLIT",
 /*  76 */ "strLit ::= strLit PT_STRLIT",
 /*  77 */ "proto ::= wholeProtoBody",
 /*  78 */ "proto ::= syntax wholeProtoBody",
 /*  79 */ "protoBody ::= protoBody import",
 /*  80 */ "protoBody ::= protoBody package",
 /*  81 */ "protoBody ::= protoBody option",
 /*  82 */ "protoBody ::= protoBody emptyStatement",
 /*  83 */ "option ::= PT_OPTION optionName PT_ASSIGN constant PT_SEMICOLON",
 /*  84 */ "option ::= PT_OPTION optionName PT_ASSIGN customOptionValue PT_SEMICOLON",
 /*  85 */ "optionName ::= exIdent",
 /*  86 */ "optionName ::= extIdentInParentheses",
 /*  87 */ "customOptionValue ::= PT_LCURLY customOptionBody PT_RCURLY",
 /*  88 */ "customOptionBody ::=",
 /*  89 */ "customOptionBody ::= customOptionBody exIdent",
 /*  90 */ "customOptionBody ::= customOptionBody PT_STRLIT",
 /*  91 */ "customOptionBody ::= customOptionBody symbolsWithoutCurly",
 /*  92 */ "customOptionBody ::= customOptionBody intLit",
 /*  93 */ "customOptionBody ::= customOptionBody customOptionValue",
 /*  94 */ "symbolsWithoutCurly ::= PT_LPAREN",
 /*  95 */ "symbolsWithoutCurly ::= PT_RPAREN",
 /*  96 */ "symbolsWithoutCurly ::= PT_LBRACKET",
 /*  97 */ "symbolsWithoutCurly ::= PT_RBRACKET",
 /*  98 */ "symbolsWithoutCurly ::= PT_EQUAL",
 /*  99 */ "symbolsWithoutCurly ::= PT_NOTEQUAL",
 /* 100 */ "symbolsWithoutCurly ::= PT_NOTEQUAL2",
 /* 101 */ "symbolsWithoutCurly ::= PT_GEQUAL",
 /* 102 */ "symbolsWithoutCurly ::= PT_LEQUAL",
 /* 103 */ "symbolsWithoutCurly ::= PT_ASSIGN_PLUS",
 /* 104 */ "symbolsWithoutCurly ::= PT_ASSIGN",
 /* 105 */ "symbolsWithoutCurly ::= PT_PLUS",
 /* 106 */ "symbolsWithoutCurly ::= PT_MINUS",
 /* 107 */ "symbolsWithoutCurly ::= PT_MULTIPLY",
 /* 108 */ "symbolsWithoutCurly ::= PT_DIV",
 /* 109 */ "symbolsWithoutCurly ::= PT_LOGIC_OR",
 /* 110 */ "symbolsWithoutCurly ::= PT_OR",
 /* 111 */ "symbolsWithoutCurly ::= PT_LOGIC_AND",
 /* 112 */ "symbolsWithoutCurly ::= PT_AND",
 /* 113 */ "symbolsWithoutCurly ::= PT_NOT",
 /* 114 */ "symbolsWithoutCurly ::= PT_NEG",
 /* 115 */ "symbolsWithoutCurly ::= PT_XOR",
 /* 116 */ "symbolsWithoutCurly ::= PT_SHL",
 /* 117 */ "symbolsWithoutCurly ::= PT_SHR",
 /* 118 */ "symbolsWithoutCurly ::= PT_PERCENT",
 /* 119 */ "symbolsWithoutCurly ::= PT_DOLLAR",
 /* 120 */ "symbolsWithoutCurly ::= PT_COND",
 /* 121 */ "symbolsWithoutCurly ::= PT_SEMICOLON",
 /* 122 */ "symbolsWithoutCurly ::= PT_DOT",
 /* 123 */ "symbolsWithoutCurly ::= PT_COMMA",
 /* 124 */ "symbolsWithoutCurly ::= PT_COLON",
 /* 125 */ "symbolsWithoutCurly ::= PT_LESS",
 /* 126 */ "symbolsWithoutCurly ::= PT_GREATER",
 /* 127 */ "topLevelDef ::= message",
 /* 128 */ "topLevelDef ::= enum",
 /* 129 */ "topLevelDef ::= extend",
 /* 130 */ "topLevelDef ::= service",
 /* 131 */ "messageBody ::= messageBody extend",
 /* 132 */ "messageBody ::= messageBody extensions",
 /* 133 */ "messageBody ::= messageBody option",
 /* 134 */ "messageBody ::= messageBody reserved",
 /* 135 */ "messageBody ::= messageBody emptyStatement",
 /* 136 */ "enumBody ::= enumBody reserved",
 /* 137 */ "enumBody ::= enumBody option",
 /* 138 */ "enumBody ::= enumBody emptyStatement",
 /* 139 */ "enumValueOptions ::= enumValueOption",
 /* 140 */ "enumValueOptions ::= enumValueOptions PT_COMMA enumValueOption",
 /* 141 */ "enumValueOption ::= optionName PT_ASSIGN constant",
 /* 142 */ "enumValueOption ::= optionName PT_ASSIGN customOptionValue",
 /* 143 */ "serviceBody ::= serviceBody option",
 /* 144 */ "serviceBody ::= serviceBody emptyStatement",
 /* 145 */ "rpc ::= rpcDecl PT_SEMICOLON",
 /* 146 */ "rpc ::= rpcDecl PT_LCURLY rpcBody PT_RCURLY",
 /* 147 */ "rpcBody ::=",
 /* 148 */ "rpcBody ::= rpcBody option",
 /* 149 */ "rpcBody ::= rpcBody emptyStatement",
 /* 150 */ "stream ::= streamDecl PT_SEMICOLON",
 /* 151 */ "stream ::= streamDecl PT_LCURLY streamBody PT_RCURLY",
 /* 152 */ "streamBody ::=",
 /* 153 */ "streamBody ::= streamBody option",
 /* 154 */ "streamBody ::= streamBody emptyStatement",
 /* 155 */ "groupName ::= exIdent",
 /* 156 */ "oneofBody ::= oneofBody option",
 /* 157 */ "oneofBody ::= oneofBody group",
 /* 158 */ "oneofBody ::= oneofBody emptyStatement",
 /* 159 */ "extensions ::= PT_EXTENSIONS ranges PT_SEMICOLON",
 /* 160 */ "reserved ::= PT_RESERVED ranges PT_SEMICOLON",
 /* 161 */ "reserved ::= PT_RESERVED quoteFieldNames PT_SEMICOLON",
 /* 162 */ "ranges ::= range",
 /* 163 */ "ranges ::= ranges PT_COMMA range",
 /* 164 */ "range ::= intLit",
 /* 165 */ "range ::= intLit PT_TO intLit",
 /* 166 */ "range ::= intLit PT_TO exIdent",
 /* 167 */ "quoteFieldNames ::= strLit",
 /* 168 */ "quoteFieldNames ::= quoteFieldNames PT_COMMA strLit",
 /* 169 */ "extendBody ::= extendBody emptyStatement",
 /* 170 */ "messageName ::= exIdent",
 /* 171 */ "enumName ::= exIdent",
 /* 172 */ "streamName ::= exIdent",
 /* 173 */ "fieldName ::= exIdent",
 /* 174 */ "oneofName ::= exIdent",
 /* 175 */ "mapName ::= exIdent",
 /* 176 */ "serviceName ::= exIdent",
 /* 177 */ "rpcName ::= exIdent",
 /* 178 */ "emptyStatement ::= PT_SEMICOLON",
 /* 179 */ "constant ::= strLit",
 /* 180 */ "exIdent ::= PT_IDENT",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0;
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ProtobufLangParserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
static void ProtobufLangParserInit(void *yypRawParser ProtobufLangParserCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ProtobufLangParserCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef ProtobufLangParser_ENGINEALWAYSONSTACK
/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to ProtobufLangParser and ProtobufLangParserFree.
*/
void *ProtobufLangParserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ProtobufLangParserCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ProtobufLangParserCTX_STORE
    ProtobufLangParserInit(yypParser ProtobufLangParserCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* ProtobufLangParser_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ProtobufLangParserARG_FETCH
  ProtobufLangParserCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* TERMINAL Destructor */
    case 1: /* PT_IDENT */
    case 2: /* PT_SYNTAX */
    case 3: /* PT_IMPORT */
    case 4: /* PT_WEAK */
    case 5: /* PT_PUBLIC */
    case 6: /* PT_PACKAGE */
    case 7: /* PT_OPTION */
    case 8: /* PT_REQUIRED */
    case 9: /* PT_OPTIONAL */
    case 10: /* PT_REPEATED */
    case 11: /* PT_ONEOF */
    case 12: /* PT_MAP */
    case 13: /* PT_RESERVED */
    case 14: /* PT_ENUM */
    case 15: /* PT_GROUP */
    case 16: /* PT_EXTEND */
    case 17: /* PT_EXTENSIONS */
    case 18: /* PT_MESSAGE */
    case 19: /* PT_SERVICE */
    case 20: /* PT_RPC */
    case 21: /* PT_STREAM */
    case 22: /* PT_RETURNS */
    case 23: /* PT_TO */
    case 24: /* PT_ASSIGN */
    case 25: /* PT_SEMICOLON */
    case 26: /* PT_LPAREN */
    case 27: /* PT_RPAREN */
    case 28: /* PT_DOT */
    case 29: /* PT_LCURLY */
    case 30: /* PT_RCURLY */
    case 31: /* PT_STRLIT */
    case 32: /* PT_LBRACKET */
    case 33: /* PT_RBRACKET */
    case 34: /* PT_EQUAL */
    case 35: /* PT_NOTEQUAL */
    case 36: /* PT_NOTEQUAL2 */
    case 37: /* PT_GEQUAL */
    case 38: /* PT_LEQUAL */
    case 39: /* PT_ASSIGN_PLUS */
    case 40: /* PT_PLUS */
    case 41: /* PT_MINUS */
    case 42: /* PT_MULTIPLY */
    case 43: /* PT_DIV */
    case 44: /* PT_LOGIC_OR */
    case 45: /* PT_OR */
    case 46: /* PT_LOGIC_AND */
    case 47: /* PT_AND */
    case 48: /* PT_NOT */
    case 49: /* PT_NEG */
    case 50: /* PT_XOR */
    case 51: /* PT_SHL */
    case 52: /* PT_SHR */
    case 53: /* PT_PERCENT */
    case 54: /* PT_DOLLAR */
    case 55: /* PT_COND */
    case 56: /* PT_COMMA */
    case 57: /* PT_COLON */
    case 58: /* PT_LESS */
    case 59: /* PT_GREATER */
    case 60: /* PT_DECIMALLIT */
    case 61: /* PT_OCTALLIT */
    case 62: /* PT_HEXLIT */
{
#line 58 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"

    /* We manage memory allocated for token values by ourself */
    (void) state; /* Mark unused, similar to Q_UNUSED */
    (void) (yypminor->yy0); /* Mark unused, similar to Q_UNUSED */

#line 1144 "./protobuf_lang_parser.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
static void ProtobufLangParserFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef ProtobufLangParser_ENGINEALWAYSONSTACK
/*
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ProtobufLangParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ProtobufLangParserFinalize(p);
  (*freeProc)(p);
}
#endif /* ProtobufLangParser_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ProtobufLangParserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ProtobufLangParserCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<(int)(sizeof(yy_action)/sizeof(yy_action[0])) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ProtobufLangParserARG_FETCH
   ProtobufLangParserCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ProtobufLangParserARG_STORE /* Suppress warning about unused %extra_argument var */
   ProtobufLangParserCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ProtobufLangParserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   107,  /* (0) wholeProtoBody ::= protoBody */
   108,  /* (1) syntax ::= PT_SYNTAX PT_ASSIGN strLit PT_SEMICOLON */
    80,  /* (2) protoBody ::= */
    80,  /* (3) protoBody ::= protoBody topLevelDef */
   109,  /* (4) import ::= PT_IMPORT strLit PT_SEMICOLON */
   109,  /* (5) import ::= PT_IMPORT PT_PUBLIC strLit PT_SEMICOLON */
   109,  /* (6) import ::= PT_IMPORT PT_WEAK strLit PT_SEMICOLON */
   110,  /* (7) package ::= PT_PACKAGE exIdent PT_SEMICOLON */
   114,  /* (8) extIdentInParentheses ::= PT_LPAREN exIdent PT_RPAREN */
    70,  /* (9) optionName ::= optionName exIdent */
    70,  /* (10) optionName ::= optionName PT_DOT extIdentInParentheses */
    70,  /* (11) optionName ::= optionName extIdentInParentheses */
    82,  /* (12) message ::= PT_MESSAGE messageName PT_LCURLY messageBody PT_RCURLY */
    83,  /* (13) messageBody ::= */
    83,  /* (14) messageBody ::= messageBody field */
    83,  /* (15) messageBody ::= messageBody enum */
    83,  /* (16) messageBody ::= messageBody message */
    83,  /* (17) messageBody ::= messageBody group */
    83,  /* (18) messageBody ::= messageBody oneof */
    83,  /* (19) messageBody ::= messageBody mapField */
    88,  /* (20) enum ::= PT_ENUM enumName PT_LCURLY enumBody PT_RCURLY */
    89,  /* (21) enumBody ::= */
    89,  /* (22) enumBody ::= enumBody enumField */
    90,  /* (23) enumField ::= exIdent PT_ASSIGN enumNumber PT_LBRACKET enumValueOptions PT_RBRACKET PT_SEMICOLON */
    90,  /* (24) enumField ::= exIdent PT_ASSIGN enumNumber */
   105,  /* (25) enumNumber ::= intLit */
   105,  /* (26) enumNumber ::= PT_PLUS intLit */
   105,  /* (27) enumNumber ::= PT_MINUS intLit */
    91,  /* (28) service ::= PT_SERVICE serviceName PT_LCURLY serviceBody PT_RCURLY */
    92,  /* (29) serviceBody ::= */
    92,  /* (30) serviceBody ::= serviceBody rpc */
    92,  /* (31) serviceBody ::= serviceBody stream */
    85,  /* (32) rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN */
    85,  /* (33) rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN */
    85,  /* (34) rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN */
    85,  /* (35) rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN */
    94,  /* (36) streamDecl ::= PT_STREAM streamName PT_LPAREN messageType PT_COMMA messageType PT_RPAREN */
    86,  /* (37) field ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
    86,  /* (38) field ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
    86,  /* (39) field ::= label type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
    86,  /* (40) field ::= label type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
    64,  /* (41) label ::= PT_REQUIRED */
    64,  /* (42) label ::= PT_OPTIONAL */
    64,  /* (43) label ::= PT_REPEATED */
    65,  /* (44) type ::= exIdent */
   104,  /* (45) fieldNumber ::= intLit */
   104,  /* (46) fieldNumber ::= PT_PLUS intLit */
    95,  /* (47) fieldOptions ::= fieldOption */
    95,  /* (48) fieldOptions ::= fieldOptions PT_COMMA fieldOption */
    96,  /* (49) fieldOption ::= optionName PT_ASSIGN constant */
    96,  /* (50) fieldOption ::= optionName PT_ASSIGN customOptionValue */
   100,  /* (51) group ::= PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY */
   100,  /* (52) group ::= label PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY */
    97,  /* (53) oneof ::= PT_ONEOF oneofName PT_LCURLY oneofBody PT_RCURLY */
    98,  /* (54) oneofBody ::= */
    98,  /* (55) oneofBody ::= oneofBody oneofField */
    87,  /* (56) oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
    87,  /* (57) oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
    99,  /* (58) mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
    99,  /* (59) mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_SEMICOLON */
    66,  /* (60) keyType ::= exIdent */
   101,  /* (61) extend ::= PT_EXTEND messageType PT_LCURLY extendBody PT_RCURLY */
   102,  /* (62) extendBody ::= */
   102,  /* (63) extendBody ::= extendBody field */
   102,  /* (64) extendBody ::= extendBody group */
    67,  /* (65) messageType ::= exIdent */
   103,  /* (66) intLit ::= PT_DECIMALLIT */
   103,  /* (67) intLit ::= PT_OCTALLIT */
   103,  /* (68) intLit ::= PT_HEXLIT */
    68,  /* (69) constant ::= exIdent */
    68,  /* (70) constant ::= intLit */
    68,  /* (71) constant ::= PT_PLUS intLit */
    68,  /* (72) constant ::= PT_MINUS intLit */
    68,  /* (73) constant ::= PT_PLUS exIdent */
    68,  /* (74) constant ::= PT_MINUS exIdent */
    63,  /* (75) strLit ::= PT_STRLIT */
    63,  /* (76) strLit ::= strLit PT_STRLIT */
   106,  /* (77) proto ::= wholeProtoBody */
   106,  /* (78) proto ::= syntax wholeProtoBody */
    80,  /* (79) protoBody ::= protoBody import */
    80,  /* (80) protoBody ::= protoBody package */
    80,  /* (81) protoBody ::= protoBody option */
    80,  /* (82) protoBody ::= protoBody emptyStatement */
   111,  /* (83) option ::= PT_OPTION optionName PT_ASSIGN constant PT_SEMICOLON */
   111,  /* (84) option ::= PT_OPTION optionName PT_ASSIGN customOptionValue PT_SEMICOLON */
    70,  /* (85) optionName ::= exIdent */
    70,  /* (86) optionName ::= extIdentInParentheses */
   113,  /* (87) customOptionValue ::= PT_LCURLY customOptionBody PT_RCURLY */
   115,  /* (88) customOptionBody ::= */
   115,  /* (89) customOptionBody ::= customOptionBody exIdent */
   115,  /* (90) customOptionBody ::= customOptionBody PT_STRLIT */
   115,  /* (91) customOptionBody ::= customOptionBody symbolsWithoutCurly */
   115,  /* (92) customOptionBody ::= customOptionBody intLit */
   115,  /* (93) customOptionBody ::= customOptionBody customOptionValue */
   116,  /* (94) symbolsWithoutCurly ::= PT_LPAREN */
   116,  /* (95) symbolsWithoutCurly ::= PT_RPAREN */
   116,  /* (96) symbolsWithoutCurly ::= PT_LBRACKET */
   116,  /* (97) symbolsWithoutCurly ::= PT_RBRACKET */
   116,  /* (98) symbolsWithoutCurly ::= PT_EQUAL */
   116,  /* (99) symbolsWithoutCurly ::= PT_NOTEQUAL */
   116,  /* (100) symbolsWithoutCurly ::= PT_NOTEQUAL2 */
   116,  /* (101) symbolsWithoutCurly ::= PT_GEQUAL */
   116,  /* (102) symbolsWithoutCurly ::= PT_LEQUAL */
   116,  /* (103) symbolsWithoutCurly ::= PT_ASSIGN_PLUS */
   116,  /* (104) symbolsWithoutCurly ::= PT_ASSIGN */
   116,  /* (105) symbolsWithoutCurly ::= PT_PLUS */
   116,  /* (106) symbolsWithoutCurly ::= PT_MINUS */
   116,  /* (107) symbolsWithoutCurly ::= PT_MULTIPLY */
   116,  /* (108) symbolsWithoutCurly ::= PT_DIV */
   116,  /* (109) symbolsWithoutCurly ::= PT_LOGIC_OR */
   116,  /* (110) symbolsWithoutCurly ::= PT_OR */
   116,  /* (111) symbolsWithoutCurly ::= PT_LOGIC_AND */
   116,  /* (112) symbolsWithoutCurly ::= PT_AND */
   116,  /* (113) symbolsWithoutCurly ::= PT_NOT */
   116,  /* (114) symbolsWithoutCurly ::= PT_NEG */
   116,  /* (115) symbolsWithoutCurly ::= PT_XOR */
   116,  /* (116) symbolsWithoutCurly ::= PT_SHL */
   116,  /* (117) symbolsWithoutCurly ::= PT_SHR */
   116,  /* (118) symbolsWithoutCurly ::= PT_PERCENT */
   116,  /* (119) symbolsWithoutCurly ::= PT_DOLLAR */
   116,  /* (120) symbolsWithoutCurly ::= PT_COND */
   116,  /* (121) symbolsWithoutCurly ::= PT_SEMICOLON */
   116,  /* (122) symbolsWithoutCurly ::= PT_DOT */
   116,  /* (123) symbolsWithoutCurly ::= PT_COMMA */
   116,  /* (124) symbolsWithoutCurly ::= PT_COLON */
   116,  /* (125) symbolsWithoutCurly ::= PT_LESS */
   116,  /* (126) symbolsWithoutCurly ::= PT_GREATER */
    81,  /* (127) topLevelDef ::= message */
    81,  /* (128) topLevelDef ::= enum */
    81,  /* (129) topLevelDef ::= extend */
    81,  /* (130) topLevelDef ::= service */
    83,  /* (131) messageBody ::= messageBody extend */
    83,  /* (132) messageBody ::= messageBody extensions */
    83,  /* (133) messageBody ::= messageBody option */
    83,  /* (134) messageBody ::= messageBody reserved */
    83,  /* (135) messageBody ::= messageBody emptyStatement */
    89,  /* (136) enumBody ::= enumBody reserved */
    89,  /* (137) enumBody ::= enumBody option */
    89,  /* (138) enumBody ::= enumBody emptyStatement */
   119,  /* (139) enumValueOptions ::= enumValueOption */
   119,  /* (140) enumValueOptions ::= enumValueOptions PT_COMMA enumValueOption */
   120,  /* (141) enumValueOption ::= optionName PT_ASSIGN constant */
   120,  /* (142) enumValueOption ::= optionName PT_ASSIGN customOptionValue */
    92,  /* (143) serviceBody ::= serviceBody option */
    92,  /* (144) serviceBody ::= serviceBody emptyStatement */
    84,  /* (145) rpc ::= rpcDecl PT_SEMICOLON */
    84,  /* (146) rpc ::= rpcDecl PT_LCURLY rpcBody PT_RCURLY */
   121,  /* (147) rpcBody ::= */
   121,  /* (148) rpcBody ::= rpcBody option */
   121,  /* (149) rpcBody ::= rpcBody emptyStatement */
    93,  /* (150) stream ::= streamDecl PT_SEMICOLON */
    93,  /* (151) stream ::= streamDecl PT_LCURLY streamBody PT_RCURLY */
   122,  /* (152) streamBody ::= */
   122,  /* (153) streamBody ::= streamBody option */
   122,  /* (154) streamBody ::= streamBody emptyStatement */
    79,  /* (155) groupName ::= exIdent */
    98,  /* (156) oneofBody ::= oneofBody option */
    98,  /* (157) oneofBody ::= oneofBody group */
    98,  /* (158) oneofBody ::= oneofBody emptyStatement */
   117,  /* (159) extensions ::= PT_EXTENSIONS ranges PT_SEMICOLON */
   118,  /* (160) reserved ::= PT_RESERVED ranges PT_SEMICOLON */
   118,  /* (161) reserved ::= PT_RESERVED quoteFieldNames PT_SEMICOLON */
   123,  /* (162) ranges ::= range */
   123,  /* (163) ranges ::= ranges PT_COMMA range */
   125,  /* (164) range ::= intLit */
   125,  /* (165) range ::= intLit PT_TO intLit */
   125,  /* (166) range ::= intLit PT_TO exIdent */
   124,  /* (167) quoteFieldNames ::= strLit */
   124,  /* (168) quoteFieldNames ::= quoteFieldNames PT_COMMA strLit */
   102,  /* (169) extendBody ::= extendBody emptyStatement */
    71,  /* (170) messageName ::= exIdent */
    72,  /* (171) enumName ::= exIdent */
    73,  /* (172) streamName ::= exIdent */
    74,  /* (173) fieldName ::= exIdent */
    75,  /* (174) oneofName ::= exIdent */
    76,  /* (175) mapName ::= exIdent */
    77,  /* (176) serviceName ::= exIdent */
    78,  /* (177) rpcName ::= exIdent */
   112,  /* (178) emptyStatement ::= PT_SEMICOLON */
    68,  /* (179) constant ::= strLit */
    69,  /* (180) exIdent ::= PT_IDENT */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -1,  /* (0) wholeProtoBody ::= protoBody */
   -4,  /* (1) syntax ::= PT_SYNTAX PT_ASSIGN strLit PT_SEMICOLON */
    0,  /* (2) protoBody ::= */
   -2,  /* (3) protoBody ::= protoBody topLevelDef */
   -3,  /* (4) import ::= PT_IMPORT strLit PT_SEMICOLON */
   -4,  /* (5) import ::= PT_IMPORT PT_PUBLIC strLit PT_SEMICOLON */
   -4,  /* (6) import ::= PT_IMPORT PT_WEAK strLit PT_SEMICOLON */
   -3,  /* (7) package ::= PT_PACKAGE exIdent PT_SEMICOLON */
   -3,  /* (8) extIdentInParentheses ::= PT_LPAREN exIdent PT_RPAREN */
   -2,  /* (9) optionName ::= optionName exIdent */
   -3,  /* (10) optionName ::= optionName PT_DOT extIdentInParentheses */
   -2,  /* (11) optionName ::= optionName extIdentInParentheses */
   -5,  /* (12) message ::= PT_MESSAGE messageName PT_LCURLY messageBody PT_RCURLY */
    0,  /* (13) messageBody ::= */
   -2,  /* (14) messageBody ::= messageBody field */
   -2,  /* (15) messageBody ::= messageBody enum */
   -2,  /* (16) messageBody ::= messageBody message */
   -2,  /* (17) messageBody ::= messageBody group */
   -2,  /* (18) messageBody ::= messageBody oneof */
   -2,  /* (19) messageBody ::= messageBody mapField */
   -5,  /* (20) enum ::= PT_ENUM enumName PT_LCURLY enumBody PT_RCURLY */
    0,  /* (21) enumBody ::= */
   -2,  /* (22) enumBody ::= enumBody enumField */
   -7,  /* (23) enumField ::= exIdent PT_ASSIGN enumNumber PT_LBRACKET enumValueOptions PT_RBRACKET PT_SEMICOLON */
   -3,  /* (24) enumField ::= exIdent PT_ASSIGN enumNumber */
   -1,  /* (25) enumNumber ::= intLit */
   -2,  /* (26) enumNumber ::= PT_PLUS intLit */
   -2,  /* (27) enumNumber ::= PT_MINUS intLit */
   -5,  /* (28) service ::= PT_SERVICE serviceName PT_LCURLY serviceBody PT_RCURLY */
    0,  /* (29) serviceBody ::= */
   -2,  /* (30) serviceBody ::= serviceBody rpc */
   -2,  /* (31) serviceBody ::= serviceBody stream */
   -9,  /* (32) rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN */
  -10,  /* (33) rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN */
  -10,  /* (34) rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN */
  -11,  /* (35) rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN */
   -7,  /* (36) streamDecl ::= PT_STREAM streamName PT_LPAREN messageType PT_COMMA messageType PT_RPAREN */
   -5,  /* (37) field ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
   -8,  /* (38) field ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
   -6,  /* (39) field ::= label type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
   -9,  /* (40) field ::= label type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
   -1,  /* (41) label ::= PT_REQUIRED */
   -1,  /* (42) label ::= PT_OPTIONAL */
   -1,  /* (43) label ::= PT_REPEATED */
   -1,  /* (44) type ::= exIdent */
   -1,  /* (45) fieldNumber ::= intLit */
   -2,  /* (46) fieldNumber ::= PT_PLUS intLit */
   -1,  /* (47) fieldOptions ::= fieldOption */
   -3,  /* (48) fieldOptions ::= fieldOptions PT_COMMA fieldOption */
   -3,  /* (49) fieldOption ::= optionName PT_ASSIGN constant */
   -3,  /* (50) fieldOption ::= optionName PT_ASSIGN customOptionValue */
   -7,  /* (51) group ::= PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY */
   -8,  /* (52) group ::= label PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY */
   -5,  /* (53) oneof ::= PT_ONEOF oneofName PT_LCURLY oneofBody PT_RCURLY */
    0,  /* (54) oneofBody ::= */
   -2,  /* (55) oneofBody ::= oneofBody oneofField */
   -8,  /* (56) oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
   -5,  /* (57) oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
  -13,  /* (58) mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
  -10,  /* (59) mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_SEMICOLON */
   -1,  /* (60) keyType ::= exIdent */
   -5,  /* (61) extend ::= PT_EXTEND messageType PT_LCURLY extendBody PT_RCURLY */
    0,  /* (62) extendBody ::= */
   -2,  /* (63) extendBody ::= extendBody field */
   -2,  /* (64) extendBody ::= extendBody group */
   -1,  /* (65) messageType ::= exIdent */
   -1,  /* (66) intLit ::= PT_DECIMALLIT */
   -1,  /* (67) intLit ::= PT_OCTALLIT */
   -1,  /* (68) intLit ::= PT_HEXLIT */
   -1,  /* (69) constant ::= exIdent */
   -1,  /* (70) constant ::= intLit */
   -2,  /* (71) constant ::= PT_PLUS intLit */
   -2,  /* (72) constant ::= PT_MINUS intLit */
   -2,  /* (73) constant ::= PT_PLUS exIdent */
   -2,  /* (74) constant ::= PT_MINUS exIdent */
   -1,  /* (75) strLit ::= PT_STRLIT */
   -2,  /* (76) strLit ::= strLit PT_STRLIT */
   -1,  /* (77) proto ::= wholeProtoBody */
   -2,  /* (78) proto ::= syntax wholeProtoBody */
   -2,  /* (79) protoBody ::= protoBody import */
   -2,  /* (80) protoBody ::= protoBody package */
   -2,  /* (81) protoBody ::= protoBody option */
   -2,  /* (82) protoBody ::= protoBody emptyStatement */
   -5,  /* (83) option ::= PT_OPTION optionName PT_ASSIGN constant PT_SEMICOLON */
   -5,  /* (84) option ::= PT_OPTION optionName PT_ASSIGN customOptionValue PT_SEMICOLON */
   -1,  /* (85) optionName ::= exIdent */
   -1,  /* (86) optionName ::= extIdentInParentheses */
   -3,  /* (87) customOptionValue ::= PT_LCURLY customOptionBody PT_RCURLY */
    0,  /* (88) customOptionBody ::= */
   -2,  /* (89) customOptionBody ::= customOptionBody exIdent */
   -2,  /* (90) customOptionBody ::= customOptionBody PT_STRLIT */
   -2,  /* (91) customOptionBody ::= customOptionBody symbolsWithoutCurly */
   -2,  /* (92) customOptionBody ::= customOptionBody intLit */
   -2,  /* (93) customOptionBody ::= customOptionBody customOptionValue */
   -1,  /* (94) symbolsWithoutCurly ::= PT_LPAREN */
   -1,  /* (95) symbolsWithoutCurly ::= PT_RPAREN */
   -1,  /* (96) symbolsWithoutCurly ::= PT_LBRACKET */
   -1,  /* (97) symbolsWithoutCurly ::= PT_RBRACKET */
   -1,  /* (98) symbolsWithoutCurly ::= PT_EQUAL */
   -1,  /* (99) symbolsWithoutCurly ::= PT_NOTEQUAL */
   -1,  /* (100) symbolsWithoutCurly ::= PT_NOTEQUAL2 */
   -1,  /* (101) symbolsWithoutCurly ::= PT_GEQUAL */
   -1,  /* (102) symbolsWithoutCurly ::= PT_LEQUAL */
   -1,  /* (103) symbolsWithoutCurly ::= PT_ASSIGN_PLUS */
   -1,  /* (104) symbolsWithoutCurly ::= PT_ASSIGN */
   -1,  /* (105) symbolsWithoutCurly ::= PT_PLUS */
   -1,  /* (106) symbolsWithoutCurly ::= PT_MINUS */
   -1,  /* (107) symbolsWithoutCurly ::= PT_MULTIPLY */
   -1,  /* (108) symbolsWithoutCurly ::= PT_DIV */
   -1,  /* (109) symbolsWithoutCurly ::= PT_LOGIC_OR */
   -1,  /* (110) symbolsWithoutCurly ::= PT_OR */
   -1,  /* (111) symbolsWithoutCurly ::= PT_LOGIC_AND */
   -1,  /* (112) symbolsWithoutCurly ::= PT_AND */
   -1,  /* (113) symbolsWithoutCurly ::= PT_NOT */
   -1,  /* (114) symbolsWithoutCurly ::= PT_NEG */
   -1,  /* (115) symbolsWithoutCurly ::= PT_XOR */
   -1,  /* (116) symbolsWithoutCurly ::= PT_SHL */
   -1,  /* (117) symbolsWithoutCurly ::= PT_SHR */
   -1,  /* (118) symbolsWithoutCurly ::= PT_PERCENT */
   -1,  /* (119) symbolsWithoutCurly ::= PT_DOLLAR */
   -1,  /* (120) symbolsWithoutCurly ::= PT_COND */
   -1,  /* (121) symbolsWithoutCurly ::= PT_SEMICOLON */
   -1,  /* (122) symbolsWithoutCurly ::= PT_DOT */
   -1,  /* (123) symbolsWithoutCurly ::= PT_COMMA */
   -1,  /* (124) symbolsWithoutCurly ::= PT_COLON */
   -1,  /* (125) symbolsWithoutCurly ::= PT_LESS */
   -1,  /* (126) symbolsWithoutCurly ::= PT_GREATER */
   -1,  /* (127) topLevelDef ::= message */
   -1,  /* (128) topLevelDef ::= enum */
   -1,  /* (129) topLevelDef ::= extend */
   -1,  /* (130) topLevelDef ::= service */
   -2,  /* (131) messageBody ::= messageBody extend */
   -2,  /* (132) messageBody ::= messageBody extensions */
   -2,  /* (133) messageBody ::= messageBody option */
   -2,  /* (134) messageBody ::= messageBody reserved */
   -2,  /* (135) messageBody ::= messageBody emptyStatement */
   -2,  /* (136) enumBody ::= enumBody reserved */
   -2,  /* (137) enumBody ::= enumBody option */
   -2,  /* (138) enumBody ::= enumBody emptyStatement */
   -1,  /* (139) enumValueOptions ::= enumValueOption */
   -3,  /* (140) enumValueOptions ::= enumValueOptions PT_COMMA enumValueOption */
   -3,  /* (141) enumValueOption ::= optionName PT_ASSIGN constant */
   -3,  /* (142) enumValueOption ::= optionName PT_ASSIGN customOptionValue */
   -2,  /* (143) serviceBody ::= serviceBody option */
   -2,  /* (144) serviceBody ::= serviceBody emptyStatement */
   -2,  /* (145) rpc ::= rpcDecl PT_SEMICOLON */
   -4,  /* (146) rpc ::= rpcDecl PT_LCURLY rpcBody PT_RCURLY */
    0,  /* (147) rpcBody ::= */
   -2,  /* (148) rpcBody ::= rpcBody option */
   -2,  /* (149) rpcBody ::= rpcBody emptyStatement */
   -2,  /* (150) stream ::= streamDecl PT_SEMICOLON */
   -4,  /* (151) stream ::= streamDecl PT_LCURLY streamBody PT_RCURLY */
    0,  /* (152) streamBody ::= */
   -2,  /* (153) streamBody ::= streamBody option */
   -2,  /* (154) streamBody ::= streamBody emptyStatement */
   -1,  /* (155) groupName ::= exIdent */
   -2,  /* (156) oneofBody ::= oneofBody option */
   -2,  /* (157) oneofBody ::= oneofBody group */
   -2,  /* (158) oneofBody ::= oneofBody emptyStatement */
   -3,  /* (159) extensions ::= PT_EXTENSIONS ranges PT_SEMICOLON */
   -3,  /* (160) reserved ::= PT_RESERVED ranges PT_SEMICOLON */
   -3,  /* (161) reserved ::= PT_RESERVED quoteFieldNames PT_SEMICOLON */
   -1,  /* (162) ranges ::= range */
   -3,  /* (163) ranges ::= ranges PT_COMMA range */
   -1,  /* (164) range ::= intLit */
   -3,  /* (165) range ::= intLit PT_TO intLit */
   -3,  /* (166) range ::= intLit PT_TO exIdent */
   -1,  /* (167) quoteFieldNames ::= strLit */
   -3,  /* (168) quoteFieldNames ::= quoteFieldNames PT_COMMA strLit */
   -2,  /* (169) extendBody ::= extendBody emptyStatement */
   -1,  /* (170) messageName ::= exIdent */
   -1,  /* (171) enumName ::= exIdent */
   -1,  /* (172) streamName ::= exIdent */
   -1,  /* (173) fieldName ::= exIdent */
   -1,  /* (174) oneofName ::= exIdent */
   -1,  /* (175) mapName ::= exIdent */
   -1,  /* (176) serviceName ::= exIdent */
   -1,  /* (177) rpcName ::= exIdent */
   -1,  /* (178) emptyStatement ::= PT_SEMICOLON */
   -1,  /* (179) constant ::= strLit */
   -1,  /* (180) exIdent ::= PT_IDENT */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ProtobufLangParserTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ProtobufLangParserCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ProtobufLangParserARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
  assert( yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* wholeProtoBody ::= protoBody */
#line 142 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
        /* set real package name */
        pbl_set_node_name(yymsp[0].minor.yy205, state->file->package_name_lineno, state->file->package_name);
        /* use the allocate mem of the name of the package node */
        state->file->package_name = pbl_get_node_name(yymsp[0].minor.yy205);
        /* put this file data into package tables */
        pbl_node_t* packnode = (pbl_node_t*)g_hash_table_lookup(state->pool->packages, state->file->package_name);
        if (packnode) {
            pbl_merge_children(packnode, yymsp[0].minor.yy205);
            pbl_free_node(yymsp[0].minor.yy205);
        } else {
            g_hash_table_insert(state->pool->packages, g_strdup(state->file->package_name), yymsp[0].minor.yy205);
        }
    }
#line 1906 "./protobuf_lang_parser.c"
        break;
      case 1: /* syntax ::= PT_SYNTAX PT_ASSIGN strLit PT_SEMICOLON */
{  yy_destructor(yypParser,2,&yymsp[-3].minor);
#line 160 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
        if (!strcmp(yymsp[-1].minor.yy148, "proto3")) {
            state->file->syntax_version = 3;
        } else if (!strcmp(yymsp[-1].minor.yy148, "proto2")) {
            state->file->syntax_version = 2;
        } else {
            pbl_parser_error(state, "Unrecognized syntax identifier [%s]. This parser only recognizes \"proto3\" or \"proto2\"!", yymsp[-1].minor.yy148);
            state->grammar_error = TRUE;
        }
    }
#line 1921 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,24,&yymsp[-2].minor);
  yy_destructor(yypParser,25,&yymsp[0].minor);
}
        break;
      case 2: /* protoBody ::= */
#line 171 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[1].minor.yy205 = pbl_create_node(state->file, CUR_LINENO, PBL_PACKAGE, NAME_TO_BE_SET); }
#line 1929 "./protobuf_lang_parser.c"
        break;
      case 3: /* protoBody ::= protoBody topLevelDef */
      case 14: /* messageBody ::= messageBody field */ yytestcase(yyruleno==14);
      case 15: /* messageBody ::= messageBody enum */ yytestcase(yyruleno==15);
      case 16: /* messageBody ::= messageBody message */ yytestcase(yyruleno==16);
      case 17: /* messageBody ::= messageBody group */ yytestcase(yyruleno==17);
      case 19: /* messageBody ::= messageBody mapField */ yytestcase(yyruleno==19);
      case 22: /* enumBody ::= enumBody enumField */ yytestcase(yyruleno==22);
      case 30: /* serviceBody ::= serviceBody rpc */ yytestcase(yyruleno==30);
      case 31: /* serviceBody ::= serviceBody stream */ yytestcase(yyruleno==31);
      case 55: /* oneofBody ::= oneofBody oneofField */ yytestcase(yyruleno==55);
      case 63: /* extendBody ::= extendBody field */ yytestcase(yyruleno==63);
      case 64: /* extendBody ::= extendBody group */ yytestcase(yyruleno==64);
#line 175 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy205 = yymsp[-1].minor.yy205; pbl_add_child(yylhsminor.yy205, yymsp[0].minor.yy205); }
#line 1945 "./protobuf_lang_parser.c"
  yymsp[-1].minor.yy205 = yylhsminor.yy205;
        break;
      case 4: /* import ::= PT_IMPORT strLit PT_SEMICOLON */
{  yy_destructor(yypParser,3,&yymsp[-2].minor);
#line 179 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ pbl_add_proto_file_to_be_parsed(state->pool, yymsp[-1].minor.yy148); }
#line 1952 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[0].minor);
}
        break;
      case 5: /* import ::= PT_IMPORT PT_PUBLIC strLit PT_SEMICOLON */
{  yy_destructor(yypParser,3,&yymsp[-3].minor);
#line 180 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ pbl_add_proto_file_to_be_parsed(state->pool, yymsp[-1].minor.yy148); }
#line 1960 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,5,&yymsp[-2].minor);
  yy_destructor(yypParser,25,&yymsp[0].minor);
}
        break;
      case 6: /* import ::= PT_IMPORT PT_WEAK strLit PT_SEMICOLON */
{  yy_destructor(yypParser,3,&yymsp[-3].minor);
#line 181 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ pbl_add_proto_file_to_be_parsed(state->pool, yymsp[-1].minor.yy148); }
#line 1969 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,4,&yymsp[-2].minor);
  yy_destructor(yypParser,25,&yymsp[0].minor);
}
        break;
      case 7: /* package ::= PT_PACKAGE exIdent PT_SEMICOLON */
{  yy_destructor(yypParser,6,&yymsp[-2].minor);
#line 185 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{   /* The memory of (yymsp[-1].minor.yy140) will be freed after parsing, but the package_name will
           be replaced by the new-allocated name of package node late */
        state->file->package_name = yymsp[-1].minor.yy140->v;
        state->file->package_name_lineno = yymsp[-1].minor.yy140->ln;
    }
#line 1982 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[0].minor);
}
        break;
      case 8: /* extIdentInParentheses ::= PT_LPAREN exIdent PT_RPAREN */
{  yy_destructor(yypParser,26,&yymsp[-2].minor);
#line 199 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-2].minor.yy0 = yymsp[-1].minor.yy140; yymsp[-2].minor.yy0->v = pbl_store_string_token(state, g_strconcat("(", yymsp[-1].minor.yy140->v, ")", NULL)); }
#line 1990 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,27,&yymsp[0].minor);
}
        break;
      case 9: /* optionName ::= optionName exIdent */
#line 203 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy140 = yymsp[-1].minor.yy140; yylhsminor.yy140->v = pbl_store_string_token(state, g_strconcat(yymsp[-1].minor.yy140->v, yymsp[0].minor.yy140->v, NULL)); }
#line 1997 "./protobuf_lang_parser.c"
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 10: /* optionName ::= optionName PT_DOT extIdentInParentheses */
#line 205 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy140 = yymsp[-2].minor.yy140; yylhsminor.yy140->v = pbl_store_string_token(state, g_strconcat(yymsp[-2].minor.yy140->v, ".", yymsp[0].minor.yy0->v, NULL)); }
#line 2003 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,28,&yymsp[-1].minor);
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 11: /* optionName ::= optionName extIdentInParentheses */
#line 207 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy140 = yymsp[-1].minor.yy140; yylhsminor.yy140->v = pbl_store_string_token(state, g_strconcat(yymsp[-1].minor.yy140->v, ".", yymsp[0].minor.yy0->v, NULL)); }
#line 2010 "./protobuf_lang_parser.c"
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 12: /* message ::= PT_MESSAGE messageName PT_LCURLY messageBody PT_RCURLY */
{  yy_destructor(yypParser,18,&yymsp[-4].minor);
#line 287 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-4].minor.yy205 = yymsp[-1].minor.yy205; pbl_set_node_name(yymsp[-4].minor.yy205, yymsp[-3].minor.yy140->ln, yymsp[-3].minor.yy140->v); }
#line 2017 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,29,&yymsp[-2].minor);
  yy_destructor(yypParser,30,&yymsp[0].minor);
}
        break;
      case 13: /* messageBody ::= */
      case 62: /* extendBody ::= */ yytestcase(yyruleno==62);
#line 291 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[1].minor.yy205 = pbl_create_node(state->file, CUR_LINENO, PBL_MESSAGE, NAME_TO_BE_SET); }
#line 2026 "./protobuf_lang_parser.c"
        break;
      case 18: /* messageBody ::= messageBody oneof */
#line 299 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy205 = yymsp[-1].minor.yy205; pbl_merge_children(yylhsminor.yy205, yymsp[0].minor.yy205); pbl_free_node(yymsp[0].minor.yy205); }
#line 2031 "./protobuf_lang_parser.c"
  yymsp[-1].minor.yy205 = yylhsminor.yy205;
        break;
      case 20: /* enum ::= PT_ENUM enumName PT_LCURLY enumBody PT_RCURLY */
{  yy_destructor(yypParser,14,&yymsp[-4].minor);
#line 306 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-4].minor.yy205 = yymsp[-1].minor.yy205; pbl_set_node_name(yymsp[-4].minor.yy205, yymsp[-3].minor.yy140->ln, yymsp[-3].minor.yy140->v); }
#line 2038 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,29,&yymsp[-2].minor);
  yy_destructor(yypParser,30,&yymsp[0].minor);
}
        break;
      case 21: /* enumBody ::= */
#line 310 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[1].minor.yy205 = pbl_create_node(state->file, CUR_LINENO, PBL_ENUM, NAME_TO_BE_SET); }
#line 2046 "./protobuf_lang_parser.c"
        break;
      case 23: /* enumField ::= exIdent PT_ASSIGN enumNumber PT_LBRACKET enumValueOptions PT_RBRACKET PT_SEMICOLON */
#line 318 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy205 = pbl_create_enum_value_node(state->file, yymsp[-6].minor.yy140->ln, yymsp[-6].minor.yy140->v, yymsp[-4].minor.yy4); }
#line 2051 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,24,&yymsp[-5].minor);
  yy_destructor(yypParser,32,&yymsp[-3].minor);
  yy_destructor(yypParser,33,&yymsp[-1].minor);
  yy_destructor(yypParser,25,&yymsp[0].minor);
  yymsp[-6].minor.yy205 = yylhsminor.yy205;
        break;
      case 24: /* enumField ::= exIdent PT_ASSIGN enumNumber */
#line 320 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy205 = pbl_create_enum_value_node(state->file, yymsp[-2].minor.yy140->ln, yymsp[-2].minor.yy140->v, yymsp[0].minor.yy4); }
#line 2061 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,24,&yymsp[-1].minor);
  yymsp[-2].minor.yy205 = yylhsminor.yy205;
        break;
      case 25: /* enumNumber ::= intLit */
      case 45: /* fieldNumber ::= intLit */ yytestcase(yyruleno==45);
#line 323 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy4 = (int)yymsp[0].minor.yy246; }
#line 2069 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy4 = yylhsminor.yy4;
        break;
      case 26: /* enumNumber ::= PT_PLUS intLit */
      case 46: /* fieldNumber ::= PT_PLUS intLit */ yytestcase(yyruleno==46);
{  yy_destructor(yypParser,40,&yymsp[-1].minor);
#line 324 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-1].minor.yy4 = (int)yymsp[0].minor.yy246; }
#line 2077 "./protobuf_lang_parser.c"
}
        break;
      case 27: /* enumNumber ::= PT_MINUS intLit */
{  yy_destructor(yypParser,41,&yymsp[-1].minor);
#line 325 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-1].minor.yy4 = -(int)yymsp[0].minor.yy246; }
#line 2084 "./protobuf_lang_parser.c"
}
        break;
      case 28: /* service ::= PT_SERVICE serviceName PT_LCURLY serviceBody PT_RCURLY */
{  yy_destructor(yypParser,19,&yymsp[-4].minor);
#line 339 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-4].minor.yy205 = yymsp[-1].minor.yy205; pbl_set_node_name(yymsp[-4].minor.yy205, yymsp[-3].minor.yy140->ln, yymsp[-3].minor.yy140->v); }
#line 2091 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,29,&yymsp[-2].minor);
  yy_destructor(yypParser,30,&yymsp[0].minor);
}
        break;
      case 29: /* serviceBody ::= */
#line 341 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[1].minor.yy205 = pbl_create_node(state->file, CUR_LINENO, PBL_SERVICE, NAME_TO_BE_SET); }
#line 2099 "./protobuf_lang_parser.c"
        break;
      case 32: /* rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN */
{  yy_destructor(yypParser,20,&yymsp[-8].minor);
#line 353 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-8].minor.yy205 = pbl_create_method_node(state->file, yymsp[-7].minor.yy140->ln, yymsp[-7].minor.yy140->v, yymsp[-5].minor.yy148, FALSE, yymsp[-1].minor.yy148, FALSE); }
#line 2105 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,26,&yymsp[-6].minor);
  yy_destructor(yypParser,27,&yymsp[-4].minor);
  yy_destructor(yypParser,22,&yymsp[-3].minor);
  yy_destructor(yypParser,26,&yymsp[-2].minor);
  yy_destructor(yypParser,27,&yymsp[0].minor);
}
        break;
      case 33: /* rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN */
{  yy_destructor(yypParser,20,&yymsp[-9].minor);
#line 355 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-9].minor.yy205 = pbl_create_method_node(state->file, yymsp[-8].minor.yy140->ln, yymsp[-8].minor.yy140->v, yymsp[-5].minor.yy148, TRUE, yymsp[-1].minor.yy148, FALSE); }
#line 2117 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,26,&yymsp[-7].minor);
  yy_destructor(yypParser,21,&yymsp[-6].minor);
  yy_destructor(yypParser,27,&yymsp[-4].minor);
  yy_destructor(yypParser,22,&yymsp[-3].minor);
  yy_destructor(yypParser,26,&yymsp[-2].minor);
  yy_destructor(yypParser,27,&yymsp[0].minor);
}
        break;
      case 34: /* rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN */
{  yy_destructor(yypParser,20,&yymsp[-9].minor);
#line 357 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-9].minor.yy205 = pbl_create_method_node(state->file, yymsp[-8].minor.yy140->ln, yymsp[-8].minor.yy140->v, yymsp[-6].minor.yy148, FALSE, yymsp[-1].minor.yy148, TRUE); }
#line 2130 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,26,&yymsp[-7].minor);
  yy_destructor(yypParser,27,&yymsp[-5].minor);
  yy_destructor(yypParser,22,&yymsp[-4].minor);
  yy_destructor(yypParser,26,&yymsp[-3].minor);
  yy_destructor(yypParser,21,&yymsp[-2].minor);
  yy_destructor(yypParser,27,&yymsp[0].minor);
}
        break;
      case 35: /* rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN */
{  yy_destructor(yypParser,20,&yymsp[-10].minor);
#line 359 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-10].minor.yy205 = pbl_create_method_node(state->file, yymsp[-9].minor.yy140->ln, yymsp[-9].minor.yy140->v, yymsp[-6].minor.yy148, TRUE, yymsp[-1].minor.yy148, TRUE); }
#line 2143 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,26,&yymsp[-8].minor);
  yy_destructor(yypParser,21,&yymsp[-7].minor);
  yy_destructor(yypParser,27,&yymsp[-5].minor);
  yy_destructor(yypParser,22,&yymsp[-4].minor);
  yy_destructor(yypParser,26,&yymsp[-3].minor);
  yy_destructor(yypParser,21,&yymsp[-2].minor);
  yy_destructor(yypParser,27,&yymsp[0].minor);
}
        break;
      case 36: /* streamDecl ::= PT_STREAM streamName PT_LPAREN messageType PT_COMMA messageType PT_RPAREN */
{  yy_destructor(yypParser,21,&yymsp[-6].minor);
#line 371 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-6].minor.yy205 = pbl_create_method_node(state->file, yymsp[-5].minor.yy140->ln, yymsp[-5].minor.yy140->v, yymsp[-3].minor.yy148, TRUE, yymsp[-1].minor.yy148, TRUE); }
#line 2157 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,26,&yymsp[-4].minor);
  yy_destructor(yypParser,56,&yymsp[-2].minor);
  yy_destructor(yypParser,27,&yymsp[0].minor);
}
        break;
      case 37: /* field ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
      case 57: /* oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */ yytestcase(yyruleno==57);
#line 381 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy205 = pbl_create_field_node(state->file, yymsp[-3].minor.yy140->ln, NULL, yymsp[-4].minor.yy148, yymsp[-3].minor.yy140->v, yymsp[-1].minor.yy4, NULL); }
#line 2167 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,24,&yymsp[-2].minor);
  yy_destructor(yypParser,25,&yymsp[0].minor);
  yymsp[-4].minor.yy205 = yylhsminor.yy205;
        break;
      case 38: /* field ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
      case 56: /* oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */ yytestcase(yyruleno==56);
#line 383 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy205 = pbl_create_field_node(state->file, yymsp[-6].minor.yy140->ln, NULL, yymsp[-7].minor.yy148, yymsp[-6].minor.yy140->v, yymsp[-4].minor.yy4, yymsp[-2].minor.yy205); }
#line 2176 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,24,&yymsp[-5].minor);
  yy_destructor(yypParser,32,&yymsp[-3].minor);
  yy_destructor(yypParser,33,&yymsp[-1].minor);
  yy_destructor(yypParser,25,&yymsp[0].minor);
  yymsp[-7].minor.yy205 = yylhsminor.yy205;
        break;
      case 39: /* field ::= label type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
#line 385 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy205 = pbl_create_field_node(state->file, yymsp[-3].minor.yy140->ln, yymsp[-5].minor.yy148, yymsp[-4].minor.yy148, yymsp[-3].minor.yy140->v, yymsp[-1].minor.yy4, NULL); }
#line 2186 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,24,&yymsp[-2].minor);
  yy_destructor(yypParser,25,&yymsp[0].minor);
  yymsp[-5].minor.yy205 = yylhsminor.yy205;
        break;
      case 40: /* field ::= label type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
#line 387 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy205 = pbl_create_field_node(state->file, yymsp[-6].minor.yy140->ln, yymsp[-8].minor.yy148, yymsp[-7].minor.yy148, yymsp[-6].minor.yy140->v, yymsp[-4].minor.yy4, yymsp[-2].minor.yy205); }
#line 2194 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,24,&yymsp[-5].minor);
  yy_destructor(yypParser,32,&yymsp[-3].minor);
  yy_destructor(yypParser,33,&yymsp[-1].minor);
  yy_destructor(yypParser,25,&yymsp[0].minor);
  yymsp[-8].minor.yy205 = yylhsminor.yy205;
        break;
      case 41: /* label ::= PT_REQUIRED */
      case 42: /* label ::= PT_OPTIONAL */ yytestcase(yyruleno==42);
      case 43: /* label ::= PT_REPEATED */ yytestcase(yyruleno==43);
#line 390 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy148 = yymsp[0].minor.yy0->v; }
#line 2206 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 44: /* type ::= exIdent */
      case 60: /* keyType ::= exIdent */ yytestcase(yyruleno==60);
      case 65: /* messageType ::= exIdent */ yytestcase(yyruleno==65);
      case 69: /* constant ::= exIdent */ yytestcase(yyruleno==69);
#line 398 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy148 = yymsp[0].minor.yy140->v; }
#line 2215 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 47: /* fieldOptions ::= fieldOption */
#line 406 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy205 = pbl_create_node(state->file, CUR_LINENO, PBL_OPTIONS, NEED_NOT_NAME); pbl_add_child(yylhsminor.yy205, yymsp[0].minor.yy205); }
#line 2221 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy205 = yylhsminor.yy205;
        break;
      case 48: /* fieldOptions ::= fieldOptions PT_COMMA fieldOption */
#line 408 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy205 = yymsp[-2].minor.yy205; pbl_add_child(yylhsminor.yy205, yymsp[0].minor.yy205); }
#line 2227 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,56,&yymsp[-1].minor);
  yymsp[-2].minor.yy205 = yylhsminor.yy205;
        break;
      case 49: /* fieldOption ::= optionName PT_ASSIGN constant */
#line 413 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy205 = pbl_create_option_node(state->file, yymsp[-2].minor.yy140->ln, yymsp[-2].minor.yy140->v, yymsp[0].minor.yy148); }
#line 2234 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,24,&yymsp[-1].minor);
  yymsp[-2].minor.yy205 = yylhsminor.yy205;
        break;
      case 50: /* fieldOption ::= optionName PT_ASSIGN customOptionValue */
#line 415 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy205 = pbl_create_option_node(state->file, yymsp[-2].minor.yy140->ln, yymsp[-2].minor.yy140->v, pbl_store_string_token(state, g_strdup("{ ... }"))); }
#line 2241 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,24,&yymsp[-1].minor);
  yymsp[-2].minor.yy205 = yylhsminor.yy205;
        break;
      case 51: /* group ::= PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY */
{  yy_destructor(yypParser,15,&yymsp[-6].minor);
#line 420 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-6].minor.yy205 = yymsp[-1].minor.yy205; pbl_set_node_name(yymsp[-6].minor.yy205, yymsp[-5].minor.yy140->ln, yymsp[-5].minor.yy140->v); }
#line 2249 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,24,&yymsp[-4].minor);
  yy_destructor(yypParser,29,&yymsp[-2].minor);
  yy_destructor(yypParser,30,&yymsp[0].minor);
}
        break;
      case 52: /* group ::= label PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY */
#line 422 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-7].minor.yy205 = yymsp[-1].minor.yy205; pbl_set_node_name(yymsp[-7].minor.yy205, yymsp[-5].minor.yy140->ln, yymsp[-5].minor.yy140->v); }
#line 2258 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,15,&yymsp[-6].minor);
  yy_destructor(yypParser,24,&yymsp[-4].minor);
  yy_destructor(yypParser,29,&yymsp[-2].minor);
  yy_destructor(yypParser,30,&yymsp[0].minor);
        break;
      case 53: /* oneof ::= PT_ONEOF oneofName PT_LCURLY oneofBody PT_RCURLY */
{  yy_destructor(yypParser,11,&yymsp[-4].minor);
#line 429 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-4].minor.yy205 = yymsp[-1].minor.yy205; pbl_set_node_name(yymsp[-4].minor.yy205, yymsp[-3].minor.yy140->ln, yymsp[-3].minor.yy140->v); }
#line 2268 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,29,&yymsp[-2].minor);
  yy_destructor(yypParser,30,&yymsp[0].minor);
}
        break;
      case 54: /* oneofBody ::= */
#line 431 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[1].minor.yy205 = pbl_create_node(state->file, CUR_LINENO, PBL_ONEOF, NAME_TO_BE_SET); }
#line 2276 "./protobuf_lang_parser.c"
        break;
      case 58: /* mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
{  yy_destructor(yypParser,12,&yymsp[-12].minor);
#line 445 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
        yymsp[-12].minor.yy205 = pbl_create_map_field_node(state->file, yymsp[-6].minor.yy140->ln, yymsp[-6].minor.yy140->v, yymsp[-4].minor.yy4, yymsp[-2].minor.yy205);
        pbl_add_child(yymsp[-12].minor.yy205, pbl_create_field_node(state->file, yymsp[-6].minor.yy140->ln, NULL, yymsp[-10].minor.yy148, "key", 1, NULL)); /* add key field */
        pbl_add_child(yymsp[-12].minor.yy205, pbl_create_field_node(state->file, yymsp[-6].minor.yy140->ln, NULL, yymsp[-8].minor.yy148, "value", 2, NULL)); /* add value field */
    }
#line 2286 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,58,&yymsp[-11].minor);
  yy_destructor(yypParser,56,&yymsp[-9].minor);
  yy_destructor(yypParser,59,&yymsp[-7].minor);
  yy_destructor(yypParser,24,&yymsp[-5].minor);
  yy_destructor(yypParser,32,&yymsp[-3].minor);
  yy_destructor(yypParser,33,&yymsp[-1].minor);
  yy_destructor(yypParser,25,&yymsp[0].minor);
}
        break;
      case 59: /* mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_SEMICOLON */
{  yy_destructor(yypParser,12,&yymsp[-9].minor);
#line 451 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
        yymsp[-9].minor.yy205 = pbl_create_map_field_node(state->file, yymsp[-3].minor.yy140->ln, yymsp[-3].minor.yy140->v, yymsp[-1].minor.yy4, NULL);
        pbl_add_child(yymsp[-9].minor.yy205, pbl_create_field_node(state->file, yymsp[-3].minor.yy140->ln, NULL, yymsp[-7].minor.yy148, "key", 1, NULL)); /* add key field */
        pbl_add_child(yymsp[-9].minor.yy205, pbl_create_field_node(state->file, yymsp[-3].minor.yy140->ln, NULL, yymsp[-5].minor.yy148, "value", 2, NULL)); /* add value field */
    }
#line 2304 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,58,&yymsp[-8].minor);
  yy_destructor(yypParser,56,&yymsp[-6].minor);
  yy_destructor(yypParser,59,&yymsp[-4].minor);
  yy_destructor(yypParser,24,&yymsp[-2].minor);
  yy_destructor(yypParser,25,&yymsp[0].minor);
}
        break;
      case 61: /* extend ::= PT_EXTEND messageType PT_LCURLY extendBody PT_RCURLY */
{  yy_destructor(yypParser,16,&yymsp[-4].minor);
#line 488 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-4].minor.yy205 = NULL; pbl_free_node(yymsp[-1].minor.yy205); }
#line 2316 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,29,&yymsp[-2].minor);
  yy_destructor(yypParser,30,&yymsp[0].minor);
}
        break;
      case 66: /* intLit ::= PT_DECIMALLIT */
#line 511 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy246 = g_ascii_strtoull(yymsp[0].minor.yy0->v, NULL, 10); }
#line 2324 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy246 = yylhsminor.yy246;
        break;
      case 67: /* intLit ::= PT_OCTALLIT */
#line 512 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy246 = g_ascii_strtoull(yymsp[0].minor.yy0->v+1, NULL, 8); }
#line 2330 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy246 = yylhsminor.yy246;
        break;
      case 68: /* intLit ::= PT_HEXLIT */
#line 513 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy246 = g_ascii_strtoull(yymsp[0].minor.yy0->v+2, NULL, 16); }
#line 2336 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy246 = yylhsminor.yy246;
        break;
      case 70: /* constant ::= intLit */
#line 521 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy148 = pbl_store_string_token(state, g_strdup_printf("%" G_GUINT64_FORMAT, yymsp[0].minor.yy246)); }
#line 2342 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 71: /* constant ::= PT_PLUS intLit */
{  yy_destructor(yypParser,40,&yymsp[-1].minor);
#line 522 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-1].minor.yy148 = pbl_store_string_token(state, g_strdup_printf("%" G_GUINT64_FORMAT, yymsp[0].minor.yy246)); }
#line 2349 "./protobuf_lang_parser.c"
}
        break;
      case 72: /* constant ::= PT_MINUS intLit */
{  yy_destructor(yypParser,41,&yymsp[-1].minor);
#line 523 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-1].minor.yy148 = pbl_store_string_token(state, g_strdup_printf("-%" G_GUINT64_FORMAT, yymsp[0].minor.yy246)); }
#line 2356 "./protobuf_lang_parser.c"
}
        break;
      case 73: /* constant ::= PT_PLUS exIdent */
{  yy_destructor(yypParser,40,&yymsp[-1].minor);
#line 524 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-1].minor.yy148 = pbl_store_string_token(state, g_strconcat("+", yymsp[0].minor.yy140->v, NULL)); }
#line 2363 "./protobuf_lang_parser.c"
}
        break;
      case 74: /* constant ::= PT_MINUS exIdent */
{  yy_destructor(yypParser,41,&yymsp[-1].minor);
#line 525 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yymsp[-1].minor.yy148 = pbl_store_string_token(state, g_strconcat("-", yymsp[0].minor.yy140->v, NULL)); }
#line 2370 "./protobuf_lang_parser.c"
}
        break;
      case 75: /* strLit ::= PT_STRLIT */
#line 529 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy148 = pbl_store_string_token(state, g_strndup(yymsp[0].minor.yy0->v + 1, strlen(yymsp[0].minor.yy0->v) - 2)); }
#line 2376 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 76: /* strLit ::= strLit PT_STRLIT */
#line 531 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{ gchar *v = g_strndup(yymsp[0].minor.yy0->v + 1, strlen(yymsp[0].minor.yy0->v) - 2); yylhsminor.yy148 = pbl_store_string_token(state, g_strconcat(yymsp[-1].minor.yy148, v, NULL)); g_free(v); }
#line 2382 "./protobuf_lang_parser.c"
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 83: /* option ::= PT_OPTION optionName PT_ASSIGN constant PT_SEMICOLON */
      case 84: /* option ::= PT_OPTION optionName PT_ASSIGN customOptionValue PT_SEMICOLON */ yytestcase(yyruleno==84);
{  yy_destructor(yypParser,7,&yymsp[-4].minor);
#line 193 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2391 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,24,&yymsp[-2].minor);
  yy_destructor(yypParser,25,&yymsp[0].minor);
}
        break;
      case 87: /* customOptionValue ::= PT_LCURLY customOptionBody PT_RCURLY */
{  yy_destructor(yypParser,29,&yymsp[-2].minor);
#line 214 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2401 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,30,&yymsp[0].minor);
}
        break;
      case 90: /* customOptionBody ::= customOptionBody PT_STRLIT */
#line 239 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2409 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,31,&yymsp[0].minor);
        break;
      case 94: /* symbolsWithoutCurly ::= PT_LPAREN */
{  yy_destructor(yypParser,26,&yymsp[0].minor);
#line 244 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2417 "./protobuf_lang_parser.c"
}
        break;
      case 95: /* symbolsWithoutCurly ::= PT_RPAREN */
{  yy_destructor(yypParser,27,&yymsp[0].minor);
#line 245 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2425 "./protobuf_lang_parser.c"
}
        break;
      case 96: /* symbolsWithoutCurly ::= PT_LBRACKET */
{  yy_destructor(yypParser,32,&yymsp[0].minor);
#line 246 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2433 "./protobuf_lang_parser.c"
}
        break;
      case 97: /* symbolsWithoutCurly ::= PT_RBRACKET */
{  yy_destructor(yypParser,33,&yymsp[0].minor);
#line 247 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2441 "./protobuf_lang_parser.c"
}
        break;
      case 98: /* symbolsWithoutCurly ::= PT_EQUAL */
{  yy_destructor(yypParser,34,&yymsp[0].minor);
#line 248 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2449 "./protobuf_lang_parser.c"
}
        break;
      case 99: /* symbolsWithoutCurly ::= PT_NOTEQUAL */
{  yy_destructor(yypParser,35,&yymsp[0].minor);
#line 249 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2457 "./protobuf_lang_parser.c"
}
        break;
      case 100: /* symbolsWithoutCurly ::= PT_NOTEQUAL2 */
{  yy_destructor(yypParser,36,&yymsp[0].minor);
#line 250 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2465 "./protobuf_lang_parser.c"
}
        break;
      case 101: /* symbolsWithoutCurly ::= PT_GEQUAL */
{  yy_destructor(yypParser,37,&yymsp[0].minor);
#line 251 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2473 "./protobuf_lang_parser.c"
}
        break;
      case 102: /* symbolsWithoutCurly ::= PT_LEQUAL */
{  yy_destructor(yypParser,38,&yymsp[0].minor);
#line 252 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2481 "./protobuf_lang_parser.c"
}
        break;
      case 103: /* symbolsWithoutCurly ::= PT_ASSIGN_PLUS */
{  yy_destructor(yypParser,39,&yymsp[0].minor);
#line 253 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2489 "./protobuf_lang_parser.c"
}
        break;
      case 104: /* symbolsWithoutCurly ::= PT_ASSIGN */
{  yy_destructor(yypParser,24,&yymsp[0].minor);
#line 254 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2497 "./protobuf_lang_parser.c"
}
        break;
      case 105: /* symbolsWithoutCurly ::= PT_PLUS */
{  yy_destructor(yypParser,40,&yymsp[0].minor);
#line 255 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2505 "./protobuf_lang_parser.c"
}
        break;
      case 106: /* symbolsWithoutCurly ::= PT_MINUS */
{  yy_destructor(yypParser,41,&yymsp[0].minor);
#line 256 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2513 "./protobuf_lang_parser.c"
}
        break;
      case 107: /* symbolsWithoutCurly ::= PT_MULTIPLY */
{  yy_destructor(yypParser,42,&yymsp[0].minor);
#line 257 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2521 "./protobuf_lang_parser.c"
}
        break;
      case 108: /* symbolsWithoutCurly ::= PT_DIV */
{  yy_destructor(yypParser,43,&yymsp[0].minor);
#line 258 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2529 "./protobuf_lang_parser.c"
}
        break;
      case 109: /* symbolsWithoutCurly ::= PT_LOGIC_OR */
{  yy_destructor(yypParser,44,&yymsp[0].minor);
#line 259 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2537 "./protobuf_lang_parser.c"
}
        break;
      case 110: /* symbolsWithoutCurly ::= PT_OR */
{  yy_destructor(yypParser,45,&yymsp[0].minor);
#line 260 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2545 "./protobuf_lang_parser.c"
}
        break;
      case 111: /* symbolsWithoutCurly ::= PT_LOGIC_AND */
{  yy_destructor(yypParser,46,&yymsp[0].minor);
#line 261 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2553 "./protobuf_lang_parser.c"
}
        break;
      case 112: /* symbolsWithoutCurly ::= PT_AND */
{  yy_destructor(yypParser,47,&yymsp[0].minor);
#line 262 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2561 "./protobuf_lang_parser.c"
}
        break;
      case 113: /* symbolsWithoutCurly ::= PT_NOT */
{  yy_destructor(yypParser,48,&yymsp[0].minor);
#line 263 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2569 "./protobuf_lang_parser.c"
}
        break;
      case 114: /* symbolsWithoutCurly ::= PT_NEG */
{  yy_destructor(yypParser,49,&yymsp[0].minor);
#line 264 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2577 "./protobuf_lang_parser.c"
}
        break;
      case 115: /* symbolsWithoutCurly ::= PT_XOR */
{  yy_destructor(yypParser,50,&yymsp[0].minor);
#line 265 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2585 "./protobuf_lang_parser.c"
}
        break;
      case 116: /* symbolsWithoutCurly ::= PT_SHL */
{  yy_destructor(yypParser,51,&yymsp[0].minor);
#line 266 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2593 "./protobuf_lang_parser.c"
}
        break;
      case 117: /* symbolsWithoutCurly ::= PT_SHR */
{  yy_destructor(yypParser,52,&yymsp[0].minor);
#line 267 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2601 "./protobuf_lang_parser.c"
}
        break;
      case 118: /* symbolsWithoutCurly ::= PT_PERCENT */
{  yy_destructor(yypParser,53,&yymsp[0].minor);
#line 268 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2609 "./protobuf_lang_parser.c"
}
        break;
      case 119: /* symbolsWithoutCurly ::= PT_DOLLAR */
{  yy_destructor(yypParser,54,&yymsp[0].minor);
#line 269 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2617 "./protobuf_lang_parser.c"
}
        break;
      case 120: /* symbolsWithoutCurly ::= PT_COND */
{  yy_destructor(yypParser,55,&yymsp[0].minor);
#line 270 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2625 "./protobuf_lang_parser.c"
}
        break;
      case 121: /* symbolsWithoutCurly ::= PT_SEMICOLON */
      case 178: /* emptyStatement ::= PT_SEMICOLON */ yytestcase(yyruleno==178);
{  yy_destructor(yypParser,25,&yymsp[0].minor);
#line 271 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2634 "./protobuf_lang_parser.c"
}
        break;
      case 122: /* symbolsWithoutCurly ::= PT_DOT */
{  yy_destructor(yypParser,28,&yymsp[0].minor);
#line 272 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2642 "./protobuf_lang_parser.c"
}
        break;
      case 123: /* symbolsWithoutCurly ::= PT_COMMA */
{  yy_destructor(yypParser,56,&yymsp[0].minor);
#line 273 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2650 "./protobuf_lang_parser.c"
}
        break;
      case 124: /* symbolsWithoutCurly ::= PT_COLON */
{  yy_destructor(yypParser,57,&yymsp[0].minor);
#line 274 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2658 "./protobuf_lang_parser.c"
}
        break;
      case 125: /* symbolsWithoutCurly ::= PT_LESS */
{  yy_destructor(yypParser,58,&yymsp[0].minor);
#line 275 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2666 "./protobuf_lang_parser.c"
}
        break;
      case 126: /* symbolsWithoutCurly ::= PT_GREATER */
{  yy_destructor(yypParser,59,&yymsp[0].minor);
#line 276 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2674 "./protobuf_lang_parser.c"
}
        break;
      case 140: /* enumValueOptions ::= enumValueOptions PT_COMMA enumValueOption */
      case 163: /* ranges ::= ranges PT_COMMA range */ yytestcase(yyruleno==163);
      case 168: /* quoteFieldNames ::= quoteFieldNames PT_COMMA strLit */ yytestcase(yyruleno==168);
#line 329 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2683 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,56,&yymsp[-1].minor);
        break;
      case 141: /* enumValueOption ::= optionName PT_ASSIGN constant */
      case 142: /* enumValueOption ::= optionName PT_ASSIGN customOptionValue */ yytestcase(yyruleno==142);
#line 333 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2691 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,24,&yymsp[-1].minor);
        break;
      case 145: /* rpc ::= rpcDecl PT_SEMICOLON */
      case 150: /* stream ::= streamDecl PT_SEMICOLON */ yytestcase(yyruleno==150);
#line 348 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2699 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[0].minor);
        break;
      case 146: /* rpc ::= rpcDecl PT_LCURLY rpcBody PT_RCURLY */
      case 151: /* stream ::= streamDecl PT_LCURLY streamBody PT_RCURLY */ yytestcase(yyruleno==151);
#line 349 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2707 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,29,&yymsp[-2].minor);
  yy_destructor(yypParser,30,&yymsp[0].minor);
        break;
      case 159: /* extensions ::= PT_EXTENSIONS ranges PT_SEMICOLON */
{  yy_destructor(yypParser,17,&yymsp[-2].minor);
#line 462 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2716 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[0].minor);
}
        break;
      case 160: /* reserved ::= PT_RESERVED ranges PT_SEMICOLON */
      case 161: /* reserved ::= PT_RESERVED quoteFieldNames PT_SEMICOLON */ yytestcase(yyruleno==161);
{  yy_destructor(yypParser,13,&yymsp[-2].minor);
#line 465 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2726 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[0].minor);
}
        break;
      case 165: /* range ::= intLit PT_TO intLit */
      case 166: /* range ::= intLit PT_TO exIdent */ yytestcase(yyruleno==166);
#line 474 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2735 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,23,&yymsp[-1].minor);
        break;
      case 180: /* exIdent ::= PT_IDENT */
{  yy_destructor(yypParser,1,&yymsp[0].minor);
#line 527 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"
{
}
#line 2743 "./protobuf_lang_parser.c"
}
        break;
      default:
      /* (77) proto ::= wholeProtoBody */ yytestcase(yyruleno==77);
      /* (78) proto ::= syntax wholeProtoBody */ yytestcase(yyruleno==78);
      /* (79) protoBody ::= protoBody import */ yytestcase(yyruleno==79);
      /* (80) protoBody ::= protoBody package */ yytestcase(yyruleno==80);
      /* (81) protoBody ::= protoBody option */ yytestcase(yyruleno==81);
      /* (82) protoBody ::= protoBody emptyStatement */ yytestcase(yyruleno==82);
      /* (85) optionName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=85);
      /* (86) optionName ::= extIdentInParentheses (OPTIMIZED OUT) */ assert(yyruleno!=86);
      /* (88) customOptionBody ::= */ yytestcase(yyruleno==88);
      /* (89) customOptionBody ::= customOptionBody exIdent */ yytestcase(yyruleno==89);
      /* (91) customOptionBody ::= customOptionBody symbolsWithoutCurly */ yytestcase(yyruleno==91);
      /* (92) customOptionBody ::= customOptionBody intLit */ yytestcase(yyruleno==92);
      /* (93) customOptionBody ::= customOptionBody customOptionValue */ yytestcase(yyruleno==93);
      /* (127) topLevelDef ::= message (OPTIMIZED OUT) */ assert(yyruleno!=127);
      /* (128) topLevelDef ::= enum (OPTIMIZED OUT) */ assert(yyruleno!=128);
      /* (129) topLevelDef ::= extend (OPTIMIZED OUT) */ assert(yyruleno!=129);
      /* (130) topLevelDef ::= service (OPTIMIZED OUT) */ assert(yyruleno!=130);
      /* (131) messageBody ::= messageBody extend */ yytestcase(yyruleno==131);
      /* (132) messageBody ::= messageBody extensions */ yytestcase(yyruleno==132);
      /* (133) messageBody ::= messageBody option */ yytestcase(yyruleno==133);
      /* (134) messageBody ::= messageBody reserved */ yytestcase(yyruleno==134);
      /* (135) messageBody ::= messageBody emptyStatement */ yytestcase(yyruleno==135);
      /* (136) enumBody ::= enumBody reserved */ yytestcase(yyruleno==136);
      /* (137) enumBody ::= enumBody option */ yytestcase(yyruleno==137);
      /* (138) enumBody ::= enumBody emptyStatement */ yytestcase(yyruleno==138);
      /* (139) enumValueOptions ::= enumValueOption (OPTIMIZED OUT) */ assert(yyruleno!=139);
      /* (143) serviceBody ::= serviceBody option */ yytestcase(yyruleno==143);
      /* (144) serviceBody ::= serviceBody emptyStatement */ yytestcase(yyruleno==144);
      /* (147) rpcBody ::= */ yytestcase(yyruleno==147);
      /* (148) rpcBody ::= rpcBody option */ yytestcase(yyruleno==148);
      /* (149) rpcBody ::= rpcBody emptyStatement */ yytestcase(yyruleno==149);
      /* (152) streamBody ::= */ yytestcase(yyruleno==152);
      /* (153) streamBody ::= streamBody option */ yytestcase(yyruleno==153);
      /* (154) streamBody ::= streamBody emptyStatement */ yytestcase(yyruleno==154);
      /* (155) groupName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=155);
      /* (156) oneofBody ::= oneofBody option */ yytestcase(yyruleno==156);
      /* (157) oneofBody ::= oneofBody group */ yytestcase(yyruleno==157);
      /* (158) oneofBody ::= oneofBody emptyStatement */ yytestcase(yyruleno==158);
      /* (162) ranges ::= range (OPTIMIZED OUT) */ assert(yyruleno!=162);
      /* (164) range ::= intLit */ yytestcase(yyruleno==164);
      /* (167) quoteFieldNames ::= strLit */ yytestcase(yyruleno==167);
      /* (169) extendBody ::= extendBody emptyStatement */ yytestcase(yyruleno==169);
      /* (170) messageName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=170);
      /* (171) enumName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=171);
      /* (172) streamName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=172);
      /* (173) fieldName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=173);
      /* (174) oneofName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=174);
      /* (175) mapName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=175);
      /* (176) serviceName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=176);
      /* (177) rpcName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=177);
      /* (179) constant ::= strLit */ yytestcase(yyruleno==179);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ProtobufLangParserARG_FETCH
  ProtobufLangParserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
#line 69 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"

    pbl_parser_error(state, "Parse Error");
    state->grammar_error = TRUE;
#line 2843 "./protobuf_lang_parser.c"
/************ End %parse_failure code *****************************************/
  ProtobufLangParserARG_STORE /* Suppress warning about unused %extra_argument variable */
  ProtobufLangParserCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor _U_,               /* The major type of the error token */
  ProtobufLangParserTOKENTYPE yyminor         /* The minor type of the error token */
){
  ProtobufLangParserARG_FETCH
  ProtobufLangParserCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 64 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"

    pbl_parser_error(state, "Syntax Error: unexpected token \"%s\"!", yyminor->v);
    state->grammar_error = TRUE;
#line 2866 "./protobuf_lang_parser.c"
/************ End %syntax_error code ******************************************/
  ProtobufLangParserARG_STORE /* Suppress warning about unused %extra_argument variable */
  ProtobufLangParserCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ProtobufLangParserARG_FETCH
  ProtobufLangParserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ProtobufLangParserARG_STORE /* Suppress warning about unused %extra_argument variable */
  ProtobufLangParserCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ProtobufLangParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void ProtobufLangParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ProtobufLangParserTOKENTYPE yyminor       /* The value for the token */
  ProtobufLangParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ProtobufLangParserCTX_FETCH
  ProtobufLangParserARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ProtobufLangParserCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

#if 0
/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ProtobufLangParserFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
#endif
#line 533 "/build/wireshark/src/wireshark-3.6.6/epan/protobuf_lang_parser.lemon"


void
protobuf_lang_error(void* yyscanner, protobuf_lang_state_t *state, const char *msg)
{
    int lineno;
    void(*error_cb)(const char *format, ...);
    const char* filepath = (state && state->file) ?
                            state->file->filename : "UNKNOWN";

    error_cb = (state && state->pool->error_cb) ?
                state->pool->error_cb : pbl_printf;

    lineno = yyscanner ? protobuf_lang_get_lineno(yyscanner) : -1;

    if (lineno > -1) {
        error_cb("Protobuf: Parsing file [%s:%d] failed: %s\n", filepath, lineno, msg);
    } else {
        error_cb("Protobuf: Parsing file [%s] failed: %s\n", filepath, msg);
    }
}

void
pbl_parser_error(protobuf_lang_state_t *state, const char *fmt, ...)
{
    char* msg;
    void* scanner;
    va_list ap;
    va_start(ap, fmt);
    msg = g_strdup_vprintf(fmt, ap);
    scanner = state ? state->scanner : NULL;
    protobuf_lang_error(scanner, state, msg);
    va_end(ap);
    g_free(msg);
}

static void
pbl_clear_state(protobuf_lang_state_t *state, pbl_descriptor_pool_t* pool)
{
    if (state == NULL) {
        return;
    }

    state->pool = NULL;
    state->file = NULL;
    state->grammar_error = FALSE;
    state->tmp_token = NULL;

    if (state->scanner) {
        protobuf_lang_lex_destroy(state->scanner);
        state->scanner = NULL;
    }

    if (state->pParser) {
        ProtobufLangParserFree(state->pParser, g_free);
        state->pParser = NULL;
    }

    if (state->lex_string_tokens) {
        g_slist_free_full(state->lex_string_tokens, g_free);
        state->lex_string_tokens = NULL;
    }

    if (state->lex_struct_tokens) {
        g_slist_free_full(state->lex_struct_tokens, g_free);
        state->lex_struct_tokens = NULL;
    }

    if (pool) {
        pool->parser_state = NULL;
    }
}

static void
pbl_reinit_state(protobuf_lang_state_t *state, pbl_descriptor_pool_t* pool, const char* filepath)
{
    if (state == NULL) {
        return;
    }
    pbl_clear_state(state, pool);

    state->pool = pool;
    state->file = (pbl_file_descriptor_t*) g_hash_table_lookup(pool->proto_files, filepath);
    state->pParser = ProtobufLangParserAlloc(g_malloc);

    if (pool) {
        pool->parser_state = state;
    }
}

int run_pbl_parser(pbl_descriptor_pool_t* pool)
{
    protobuf_lang_state_t state = {0};
    yyscan_t scanner;
    GSList* it;
    FILE * fp;
    int status = 0;
    int token_id;
    const char* filepath;

    it = pool->proto_files_to_be_parsed;
    while (it) {
        filepath = (const char*) it->data;
        /* reinit state and scanner */
        pbl_reinit_state(&state, pool, filepath);
        scanner = NULL;

        /* Note that filepath is absolute path in proto_files */
        fp = ws_fopen(filepath, "r");
        if (fp == NULL) {
            pbl_parser_error(&state, "File does not exists!");
            status = -1;
            goto finish;
        }

        status = protobuf_lang_lex_init(&scanner);
        if (status != 0) {
            pbl_parser_error(&state, "Initialize Protocol Buffers Language scanner failed!\n");
            fclose(fp);
            goto finish;
        }

        /* associate the parser state with the lexical analyzer state */
        protobuf_lang_set_extra(&state, scanner);
        state.scanner = scanner;

        protobuf_lang_restart(fp, scanner);
        /* uncomment the next line for debugging */
        /* ProtobufLangParserTrace(stdout, ">>>"); */
        while (!state.grammar_error && (token_id = protobuf_lang_lex(scanner))) {
            /* state.tmp_token contains token string value and lineno information */
            ProtobufLangParser(state.pParser, token_id, state.tmp_token, &state);
        }
        fclose(fp);

        if (state.grammar_error) {
            status = -2;
            goto finish;
        } else {
            ProtobufLangParser(state.pParser, 0, NULL, &state);
        }

        /* remove the parsed file from list */
        pool->proto_files_to_be_parsed = it = g_slist_delete_link(pool->proto_files_to_be_parsed, it);
    }

finish:
    pbl_clear_state(&state, pool);
    return status;
}

#line 3253 "./protobuf_lang_parser.c"
