// generated by Fast Light User Interface Designer (fluid) version 1.0308

#include "SUBnoteUI.h"
// SubNoteUI.cc
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2015-2022, Will Godfrey & others

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is derivative of ZynAddSubFX original code


#include "MasterUI.h"
#include "Misc/SynthHelper.h"
    using synth::getDetune;

void SUBnoteharmonic::cb_mag_i(PSlider* o, void*) {
  //
        int x = 0;
        if (Fl::event_button() != 3)
            x = lrint(o->value());
        else
        {
            if (n == 0)
                x = 127;
            o->value(x);
        }

        send_data(0, TOPLEVEL::insert::harmonicAmplitude, n, x, TOPLEVEL::type::Integer);
}
void SUBnoteharmonic::cb_mag(PSlider* o, void* v) {
  ((SUBnoteharmonic*)(o->parent()->user_data()))->cb_mag_i(o,v);
}

void SUBnoteharmonic::cb_bw_i(PSlider* o, void*) {
  //
        int x = 64;
        if (Fl::event_button() != 3)
            x = 64 + lrint(o->value());
        else
            o->value(0);

        send_data(0, TOPLEVEL::insert::harmonicPhaseBandwidth, n, x, TOPLEVEL::type::Integer);
}
void SUBnoteharmonic::cb_bw(PSlider* o, void* v) {
  ((SUBnoteharmonic*)(o->parent()->user_data()))->cb_bw_i(o,v);
}

Fl_Group* SUBnoteharmonic::make_window() {
  { harmonic = new Fl_Group(0, 0, 50, 300);
    harmonic->box(FL_NO_BOX);
    harmonic->color(FL_BACKGROUND_COLOR);
    harmonic->selection_color(FL_BACKGROUND_COLOR);
    harmonic->labeltype(FL_NO_LABEL);
    harmonic->labelfont(0);
    harmonic->labelsize(14);
    harmonic->labelcolor(FL_FOREGROUND_COLOR);
    harmonic->user_data((void*)(this));
    harmonic->align(Fl_Align(FL_ALIGN_TOP));
    harmonic->when(FL_WHEN_RELEASE);
    { PSlider* o = mag = new PSlider(0, 2, 15, 131);
      mag->tooltip("Harmonic\'s magnitude");
      mag->type(4);
      mag->box(FL_FLAT_BOX);
      mag->color(FL_BACKGROUND_COLOR);
      mag->selection_color(FL_BACKGROUND_COLOR);
      mag->labeltype(FL_NORMAL_LABEL);
      mag->labelfont(0);
      mag->labelsize(14);
      mag->labelcolor(FL_FOREGROUND_COLOR);
      mag->minimum(127);
      mag->maximum(0);
      mag->step(1);
      mag->value(127);
      mag->callback((Fl_Callback*)cb_mag);
      mag->align(Fl_Align(FL_ALIGN_BOTTOM));
      mag->when(FL_WHEN_CHANGED);
      o->value(pars->Phmag[n]);
      o->setValueType(VC_SubHarmonicMagnitude); o->useCustomTip(true);
    } // PSlider* mag
    { PSlider* o = bw = new PSlider(0, 166, 15, 128);
      bw->tooltip("Harmonic\'s bandwidth multiplier");
      bw->type(4);
      bw->box(FL_FLAT_BOX);
      bw->color(FL_BACKGROUND_COLOR);
      bw->selection_color(FL_BACKGROUND_COLOR);
      bw->labeltype(FL_NORMAL_LABEL);
      bw->labelfont(0);
      bw->labelsize(14);
      bw->labelcolor(FL_FOREGROUND_COLOR);
      bw->minimum(63);
      bw->maximum(-64);
      bw->step(1);
      bw->callback((Fl_Callback*)cb_bw);
      bw->align(Fl_Align(FL_ALIGN_BOTTOM));
      bw->when(FL_WHEN_CHANGED);
      o->setValueType(VC_SubBandwidthRel);
      o->useCustomTip(true);
      o->value(pars->Phrelbw[n] - 64);
    } // PSlider* bw
    { Fl_Box* o = h_dash = new Fl_Box(16, 227, 10, 3);
      h_dash->box(FL_FLAT_BOX);
      h_dash->color(FL_DARK3);
      if (n+1==MAX_SUB_HARMONICS) o->hide();
    } // Fl_Box* h_dash
    { Fl_Box* o = h_num = new Fl_Box(0, 142, 15, 15, "01");
      h_num->labelfont(1);
      h_num->labelsize(12);
      h_num->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
      char tmp[12];snprintf(tmp,12,"%d",n+1);o->label(strdup(tmp));
    } // Fl_Box* h_num
    harmonic->end();
    harmonic->resizable(harmonic);
  } // Fl_Group* harmonic
  return harmonic;
}

SUBnoteharmonic::SUBnoteharmonic(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  n=0;
}

void SUBnoteharmonic::send_data(int action, int insert, int control, float value, int type) {
  //
          type |= TOPLEVEL::type::Write;
          collect_data(synth, value, action, type, control, npart, kititem, 1, insert);
}

void SUBnoteharmonic::init(SUBnoteParameters *pars_, int n_, int npart_, int kititem_) {
  //
      pars=pars_;
      synth = pars->getSynthEngine();
      n=n_;
      npart = npart_;
      kititem = kititem_;
      make_window();
      harmonic->show();
      end();
}

void SUBnoteharmonic::refresh() {
  //
      mag->value(pars->Phmag[n]);
      bw->value(pars->Phrelbw[n] - 64);
}

SUBnoteharmonic::~SUBnoteharmonic() {
  //
      harmonic->hide();
      hide();
}

void SUBnoteUI::cb_SUBparameters_i(Fl_Double_Window* o, void*) {
  //
    if (subSeen)
        saveWin(synth,o->w(), SUBparameters->h(),o->x(), o->y(), false, "SubSynth");
    subSeen = false;
    o->hide();
}
void SUBnoteUI::cb_SUBparameters(Fl_Double_Window* o, void* v) {
  ((SUBnoteUI*)(o->user_data()))->cb_SUBparameters_i(o,v);
}

void SUBnoteUI::cb_vol_i(WidgetPDial* o, void*) {
  //
          send_data (0, SUBSYNTH::control::volume, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_vol(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_vol_i(o,v);
}

void SUBnoteUI::cb_vsns_i(WidgetPDial* o, void*) {
  //
          send_data (0, SUBSYNTH::control::velocitySense, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_vsns(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_vsns_i(o,v);
}

void SUBnoteUI::cb_pan_i(WidgetPDial* o, void*) {
  //
          send_data (0, SUBSYNTH::control::panning, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_pan(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_pan_i(o,v);
}

void SUBnoteUI::cb_panwidth_i(WidgetPDial* o, void*) {
  //
          send_data (0, SUBSYNTH::control::randomWidth, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_panwidth(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_panwidth_i(o,v);
}

void SUBnoteUI::cb_randompan_i(Fl_Check_Button2* o, void*) {
  //
        int tmp = o->value();
        if (tmp == 0)
            panwidth->deactivate();
        else
            panwidth->activate();
        send_data(0, SUBSYNTH::control::enableRandomPan, tmp, TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_randompan(Fl_Check_Button2* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_randompan_i(o,v);
}

void SUBnoteUI::cb_freqee_i(Fl_Check_Button2* o, void*) {
  //
          if (o->value() == 0)
              freqenvelopegroup->deactivate();
          else
              freqenvelopegroup->activate();
          o->show();
          freqsettingsui->redraw();
          send_data (0, SUBSYNTH::control::enableFrequencyEnvelope, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_freqee(Fl_Check_Button2* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_freqee_i(o,v);
}

void SUBnoteUI::cb_octave_i(Fl_Counter* o, void*) {
  //
          send_data (0, SUBSYNTH::control::octave, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_octave(Fl_Counter* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_octave_i(o,v);
}

void SUBnoteUI::cb_bend_i(WidgetPDial* o, void*) {
  //
          send_data(0, SUBSYNTH::control::pitchBendAdjustment, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_bend(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_bend_i(o,v);
}

void SUBnoteUI::cb_offset_i(WidgetPDial* o, void*) {
  //
          send_data(0, SUBSYNTH::control::pitchBendOffset, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_offset(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_offset_i(o,v);
}

void SUBnoteUI::cb_hz440_i(Fl_Check_Button2* o, void*) {
  //
          int x = (int) o->value();

          if (x == 0)
              fixedfreqetdial->deactivate();
          else
              fixedfreqetdial->activate();
          send_data (0, SUBSYNTH::control::baseFrequencyAs440Hz, x, TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_hz440(Fl_Check_Button2* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_hz440_i(o,v);
}

void SUBnoteUI::cb_fixedfreqetdial_i(WidgetPDial* o, void*) {
  //
          send_data (0, SUBSYNTH::control::equalTemperVariation, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_fixedfreqetdial(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_fixedfreqetdial_i(o,v);
}

void SUBnoteUI::cb_detune_i(mwheel_slider_rev* o, void*) {
  //
          send_data (TOPLEVEL::action::forceUpdate, SUBSYNTH::control::detuneFrequency, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_detune(mwheel_slider_rev* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_detune_i(o,v);
}

void SUBnoteUI::cb_detunevalueoutput_i(Fl_Value_Output* o, void*) {
  o->value(getDetune(pars->PDetuneType,0,pars->PDetune));
}
void SUBnoteUI::cb_detunevalueoutput(Fl_Value_Output* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_detunevalueoutput_i(o,v);
}

void SUBnoteUI::cb_detunetype_i(Fl_Choice* o, void*) {
  //

          send_data (TOPLEVEL::action::forceUpdate, SUBSYNTH::control::detuneType, o->value() + 1, TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_detunetype(Fl_Choice* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_detunetype_i(o,v);
}

void SUBnoteUI::cb_coarsedet_i(Fl_Counter* o, void*) {
  //
          int k = (int) o->value();
          if (k < 0)
              k += 1024;

          send_data (0, SUBSYNTH::control::coarseDetune, k, TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_coarsedet(Fl_Counter* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_coarsedet_i(o,v);
}

void SUBnoteUI::cb_bwee_i(Fl_Check_Button2* o, void*) {
  //
          if (o->value() == 0)
              bandwidthenvelopegroup->deactivate();
          else
              bandwidthenvelopegroup->activate();
          o->show();
          bandwidthsettingsui->redraw();
          send_data (0, SUBSYNTH::control::enableBandwidthEnvelope, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_bwee(Fl_Check_Button2* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_bwee_i(o,v);
}

void SUBnoteUI::cb_bandwidth_i(mwheel_val_slider_rev* o, void*) {
  //
          send_data (0, SUBSYNTH::control::bandwidth, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_bandwidth(mwheel_val_slider_rev* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_bandwidth_i(o,v);
}

void SUBnoteUI::cb_bwidthscale_i(mwheel_val_slider_rev* o, void*) {
  //
          send_data (0, SUBSYNTH::control::bandwidthScale, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_bwidthscale(mwheel_val_slider_rev* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_bwidthscale_i(o,v);
}

void SUBnoteUI::cb_spreadpar1_i(WidgetPDial* o, void*) {
  //
          send_data (TOPLEVEL::action::forceUpdate, SUBSYNTH::control::overtoneParameter1, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_spreadpar1(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_spreadpar1_i(o,v);
}

void SUBnoteUI::cb_spreadpar2_i(WidgetPDial* o, void*) {
  //
          send_data (0, SUBSYNTH::control::overtoneParameter2, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_spreadpar2(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_spreadpar2_i(o,v);
}

void SUBnoteUI::cb_spreadpar3_i(WidgetPDial* o, void*) {
  //
          send_data (0, SUBSYNTH::control::overtoneForceHarmonics, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_spreadpar3(WidgetPDial* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_spreadpar3_i(o,v);
}

void SUBnoteUI::cb_spreadtype_i(Fl_Choice* o, void*) {
  //
          send_data (TOPLEVEL::action::forceUpdate, SUBSYNTH::control::overtonePosition, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_spreadtype(Fl_Choice* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_spreadtype_i(o,v);
}

void SUBnoteUI::cb_filtere_i(Fl_Check_Button2* o, void*) {
  //
        if (o->value() == 0)
            globalfiltergroup->deactivate();
        else
            globalfiltergroup->activate();
        o->show();
        globalfiltergroup->redraw();
        send_data (0, SUBSYNTH::control::enableFilter, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_filtere(Fl_Check_Button2* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_filtere_i(o,v);
}

void SUBnoteUI::cb_filterstages_i(Fl_Counter* o, void*) {
  //
          send_data (0, SUBSYNTH::control::filterStages, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_filterstages(Fl_Counter* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_filterstages_i(o,v);
}

void SUBnoteUI::cb_magtype_i(Fl_Choice* o, void*) {
  //
          send_data (0, SUBSYNTH::control::magType, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_magtype(Fl_Choice* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_magtype_i(o,v);
}

void SUBnoteUI::cb_start_i(Fl_Choice* o, void*) {
  //
          send_data (0, SUBSYNTH::control::startPosition, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_start(Fl_Choice* o, void* v) {
  ((SUBnoteUI*)(o->parent()->parent()->user_data()))->cb_start_i(o,v);
}

void SUBnoteUI::cb_stereo_i(Fl_Check_Button2* o, void*) {
  //
        send_data (0, SUBSYNTH::control::stereo, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_stereo(Fl_Check_Button2* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_stereo_i(o,v);
}

void SUBnoteUI::cb_subClear_i(Fl_Button* o, void*) {
  //
        send_data (TOPLEVEL::action::forceUpdate, SUBSYNTH::control::clearHarmonics, o->value(), TOPLEVEL::type::Integer);
}
void SUBnoteUI::cb_subClear(Fl_Button* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_subClear_i(o,v);
}

void SUBnoteUI::cb_subCopy_i(Fl_Button*, void*) {
  synth->getGuiMaster()->getPresetsUi()->copy(pars);
}
void SUBnoteUI::cb_subCopy(Fl_Button* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_subCopy_i(o,v);
}

void SUBnoteUI::cb_subPaste_i(Fl_Button*, void*) {
  synth->getGuiMaster()->getPresetsUi()->paste(pars,this);
}
void SUBnoteUI::cb_subPaste(Fl_Button* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_subPaste_i(o,v);
}

void SUBnoteUI::cb_subClose_i(Fl_Button*, void*) {
  //
        saveWin(synth, SUBparameters->w(), SUBparameters->h(), SUBparameters->x(), SUBparameters->y(), false, "SubSynth");
        subSeen = false;
        SUBparameters->hide();
        if ((Fl::event_button() == 3))
        {
            if (synth->getGuiMaster()->partui->partKitOn)
                synth->getGuiMaster()->partui->instrumentkitlist->show();
            else
                synth->getGuiMaster()->partui->instrumenteditwindow->show();
        };
}
void SUBnoteUI::cb_subClose(Fl_Button* o, void* v) {
  ((SUBnoteUI*)(o->parent()->user_data()))->cb_subClose_i(o,v);
}

Fl_Double_Window* SUBnoteUI::make_window() {
// randompan MUST be placed after panwidth
  { Fl_Double_Window* o = SUBparameters = new Fl_Double_Window(735, 470, "SUBsynth Parameters");
    SUBparameters->callback((Fl_Callback*)cb_SUBparameters, (void*)(this));
    { frame = new Fl_Scroll(5, 140, 435, 326);
      frame->type(1);
      frame->box(FL_THIN_UP_BOX);
      frame->when(FL_WHEN_CHANGED);
      { Fl_Pack* o = harmonics = new Fl_Pack(4, 148, 435, 290);
        harmonics->type(1);
        new Fl_Box(0,0,9,o->h());
        for (int i=0;i<MAX_SUB_HARMONICS;i++){h[i]=new SUBnoteharmonic(0,0,20,o->h(),"");h[i]->init(pars, i, npart, kititem);}
        new Fl_Box(0,0,3,o->h());
        harmonics->end();
        Fl_Group::current()->resizable(harmonics);
      } // Fl_Pack* harmonics
      frame->end();
    } // Fl_Scroll* frame
    { Fl_Box* o = new Fl_Box(10, 6, 205, 60);
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_CYAN);
    } // Fl_Box* o
    { ampgrp = new Fl_Group(5, 6, 215, 135, "AMPLITUDE");
      ampgrp->box(FL_THIN_UP_FRAME);
      ampgrp->labelfont(1);
      ampgrp->labelsize(11);
      ampgrp->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { WidgetPDial* o = vol = new WidgetPDial(20, 20, 29, 29, "Volume");
        vol->tooltip("Volume");
        vol->box(FL_ROUND_UP_BOX);
        vol->color(FL_BACKGROUND_COLOR);
        vol->selection_color(FL_INACTIVE_COLOR);
        vol->labeltype(FL_NORMAL_LABEL);
        vol->labelfont(0);
        vol->labelsize(10);
        vol->labelcolor(FL_FOREGROUND_COLOR);
        vol->maximum(127);
        vol->step(1);
        vol->callback((Fl_Callback*)cb_vol);
        vol->align(Fl_Align(FL_ALIGN_BOTTOM_RIGHT));
        vol->when(FL_WHEN_CHANGED);
        o->setValueType(VC_InstrumentVolume);
        o->value(pars->PVolume);
      } // WidgetPDial* vol
      { WidgetPDial* o = vsns = new WidgetPDial(66, 20, 29, 29, "Vel Sens");
        vsns->tooltip("Velocity sensing");
        vsns->box(FL_ROUND_UP_BOX);
        vsns->color(FL_BACKGROUND_COLOR);
        vsns->selection_color(FL_INACTIVE_COLOR);
        vsns->labeltype(FL_NORMAL_LABEL);
        vsns->labelfont(0);
        vsns->labelsize(10);
        vsns->labelcolor(FL_FOREGROUND_COLOR);
        vsns->maximum(127);
        vsns->step(1);
        vsns->callback((Fl_Callback*)cb_vsns);
        vsns->align(Fl_Align(FL_ALIGN_BOTTOM));
        vsns->when(FL_WHEN_CHANGED);
        o->value(pars->PAmpVelocityScaleFunction);
        o->setValueType(VC_AmpVelocitySense);
      } // WidgetPDial* vsns
      { WidgetPDial* o = pan = new WidgetPDial(118, 20, 29, 29, "Pan");
        pan->tooltip("Panning");
        pan->box(FL_ROUND_UP_BOX);
        pan->color(FL_BACKGROUND_COLOR);
        pan->selection_color(FL_INACTIVE_COLOR);
        pan->labeltype(FL_NORMAL_LABEL);
        pan->labelfont(0);
        pan->labelsize(10);
        pan->labelcolor(FL_FOREGROUND_COLOR);
        pan->maximum(127);
        pan->step(1);
        pan->callback((Fl_Callback*)cb_pan);
        pan->align(Fl_Align(FL_ALIGN_BOTTOM));
        pan->when(FL_WHEN_CHANGED);
        o->setValueType(VC_PanningStd);
        o->value(pars->PPanning);
      } // WidgetPDial* pan
      { EnvelopeUI* o = ampenv = new EnvelopeUI(10, 65, 205, 70, "SUBsynth - Amplitude Envelope");
        ampenv->box(FL_FLAT_BOX);
        ampenv->color((Fl_Color)51);
        ampenv->selection_color(FL_BACKGROUND_COLOR);
        ampenv->labeltype(FL_NORMAL_LABEL);
        ampenv->labelfont(0);
        ampenv->labelsize(14);
        ampenv->labelcolor(FL_FOREGROUND_COLOR);
        ampenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        ampenv->when(FL_WHEN_RELEASE);
        o->init(pars->AmpEnvelope, npart, kititem, 1, 0);
        ampenv->end();
      } // EnvelopeUI* ampenv
      { WidgetPDial* o = panwidth = new WidgetPDial(178, 20, 29, 29, "Width");
        panwidth->tooltip("Random Width");
        panwidth->box(FL_ROUND_UP_BOX);
        panwidth->color(FL_BACKGROUND_COLOR);
        panwidth->selection_color(FL_INACTIVE_COLOR);
        panwidth->labeltype(FL_NORMAL_LABEL);
        panwidth->labelfont(0);
        panwidth->labelsize(10);
        panwidth->labelcolor(FL_FOREGROUND_COLOR);
        panwidth->maximum(63);
        panwidth->step(1);
        panwidth->value(63);
        panwidth->callback((Fl_Callback*)cb_panwidth);
        panwidth->align(Fl_Align(FL_ALIGN_BOTTOM));
        panwidth->when(FL_WHEN_CHANGED);
        o->setValueType(VC_PanningRandom);
        o->value(pars->PWidth);
      } // WidgetPDial* panwidth
      { Fl_Check_Button2* o = randompan = new Fl_Check_Button2(155, 31, 15, 15, "Rand");
        randompan->tooltip("Enable random panning");
        randompan->box(FL_NO_BOX);
        randompan->down_box(FL_DOWN_BOX);
        randompan->color((Fl_Color)48);
        randompan->selection_color(FL_FOREGROUND_COLOR);
        randompan->labeltype(FL_NORMAL_LABEL);
        randompan->labelfont(0);
        randompan->labelsize(11);
        randompan->labelcolor(FL_FOREGROUND_COLOR);
        randompan->callback((Fl_Callback*)cb_randompan);
        randompan->align(Fl_Align(FL_ALIGN_TOP));
        randompan->when(FL_WHEN_RELEASE);
        o->value(pars->PRandom);
        if (o->value() == 0) panwidth->deactivate(); else panwidth->activate();
      } // Fl_Check_Button2* randompan
      { Fl_Box* o = new Fl_Box(108, 22, 4, 37);
        o->box(FL_THIN_DOWN_FRAME);
      } // Fl_Box* o
      ampgrp->end();
    } // Fl_Group* ampgrp
    { freqsettingsui = new Fl_Group(440, 5, 290, 135, "FREQUENCY");
      freqsettingsui->box(FL_THIN_UP_FRAME);
      freqsettingsui->labelfont(1);
      freqsettingsui->labelsize(11);
      freqsettingsui->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { EnvelopeUI* o = freqenvelopegroup = new EnvelopeUI(445, 65, 205, 70, "SUBsynth - Frequency Envelope");
        freqenvelopegroup->box(FL_FLAT_BOX);
        freqenvelopegroup->color((Fl_Color)51);
        freqenvelopegroup->selection_color(FL_BACKGROUND_COLOR);
        freqenvelopegroup->labeltype(FL_NORMAL_LABEL);
        freqenvelopegroup->labelfont(0);
        freqenvelopegroup->labelsize(14);
        freqenvelopegroup->labelcolor(FL_FOREGROUND_COLOR);
        freqenvelopegroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        freqenvelopegroup->when(FL_WHEN_RELEASE);
        o->init(pars->FreqEnvelope, npart, kititem, 1, 1);
        if (pars->PFreqEnvelopeEnabled == 0) o->deactivate();
        freqenvelopegroup->end();
      } // EnvelopeUI* freqenvelopegroup
      { Fl_Check_Button2* o = freqee = new Fl_Check_Button2(445, 67, 34, 12, "On");
        freqee->box(FL_THIN_UP_BOX);
        freqee->down_box(FL_DOWN_BOX);
        freqee->color((Fl_Color)237);
        freqee->selection_color(FL_FOREGROUND_COLOR);
        freqee->labeltype(FL_NORMAL_LABEL);
        freqee->labelfont(1);
        freqee->labelsize(10);
        freqee->labelcolor(FL_FOREGROUND_COLOR);
        freqee->callback((Fl_Callback*)cb_freqee);
        freqee->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        freqee->when(FL_WHEN_RELEASE);
        o->value(pars->PFreqEnvelopeEnabled);
      } // Fl_Check_Button2* freqee
      { Fl_Counter* o = octave = new Fl_Counter(446, 18, 45, 15, "Octave");
        octave->tooltip("Octave");
        octave->type(1);
        octave->color((Fl_Color)237);
        octave->selection_color(FL_FOREGROUND_COLOR);
        octave->labelsize(10);
        octave->minimum(-8);
        octave->maximum(7);
        octave->step(1);
        octave->textfont(1);
        octave->textsize(11);
        octave->callback((Fl_Callback*)cb_octave);
        octave->align(Fl_Align(FL_ALIGN_TOP));
        int k=pars->PCoarseDetune/1024;if (k>=8) k-=16;
        o->value(k);
      } // Fl_Counter* octave
      { WidgetPDial* o = bend = new WidgetPDial(500, 21, 20, 20, "Bend");
        bend->tooltip("Pitch bend range scaling");
        bend->box(FL_ROUND_UP_BOX);
        bend->color(FL_BACKGROUND_COLOR);
        bend->selection_color(FL_INACTIVE_COLOR);
        bend->labeltype(FL_NORMAL_LABEL);
        bend->labelfont(0);
        bend->labelsize(10);
        bend->labelcolor(FL_FOREGROUND_COLOR);
        bend->maximum(127);
        bend->step(1);
        bend->callback((Fl_Callback*)cb_bend);
        bend->align(Fl_Align(FL_ALIGN_RIGHT));
        bend->when(FL_WHEN_CHANGED);
        o->value(pars->PBendAdjust);
        o->setValueType(VC_PitchBend);
      } // WidgetPDial* bend
      { WidgetPDial* o = offset = new WidgetPDial(558, 21, 20, 20, "Offset");
        offset->tooltip("Offset of the frequency in Hz.");
        offset->box(FL_ROUND_UP_BOX);
        offset->color(FL_BACKGROUND_COLOR);
        offset->selection_color(FL_INACTIVE_COLOR);
        offset->labeltype(FL_NORMAL_LABEL);
        offset->labelfont(0);
        offset->labelsize(10);
        offset->labelcolor(FL_FOREGROUND_COLOR);
        offset->maximum(127);
        offset->step(1);
        offset->callback((Fl_Callback*)cb_offset);
        offset->align(Fl_Align(FL_ALIGN_RIGHT));
        offset->when(FL_WHEN_CHANGED);
        o->value(pars->POffsetHz);
        o->setValueType(VC_FreqOffsetHz);
      } // WidgetPDial* offset
      { Fl_Check_Button2* o = hz440 = new Fl_Check_Button2(620, 24, 48, 15, "440Hz");
        hz440->tooltip("set the base frequency to 440Hz");
        hz440->box(FL_NO_BOX);
        hz440->down_box(FL_DOWN_BOX);
        hz440->color(FL_BACKGROUND_COLOR);
        hz440->selection_color(FL_FOREGROUND_COLOR);
        hz440->labeltype(FL_NORMAL_LABEL);
        hz440->labelfont(1);
        hz440->labelsize(10);
        hz440->labelcolor(FL_FOREGROUND_COLOR);
        hz440->callback((Fl_Callback*)cb_hz440);
        hz440->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        hz440->when(FL_WHEN_RELEASE);
        o->value(pars->Pfixedfreq);
      } // Fl_Check_Button2* hz440
      { WidgetPDial* o = fixedfreqetdial = new WidgetPDial(675, 21, 20, 20, "Eq.T.");
        fixedfreqetdial->tooltip("How the frequency varies according to the keyboard (leftmost for fixed freque\
ncy)");
        fixedfreqetdial->box(FL_ROUND_UP_BOX);
        fixedfreqetdial->color(FL_BACKGROUND_COLOR);
        fixedfreqetdial->selection_color(FL_INACTIVE_COLOR);
        fixedfreqetdial->labeltype(FL_NORMAL_LABEL);
        fixedfreqetdial->labelfont(0);
        fixedfreqetdial->labelsize(10);
        fixedfreqetdial->labelcolor(FL_FOREGROUND_COLOR);
        fixedfreqetdial->maximum(127);
        fixedfreqetdial->step(1);
        fixedfreqetdial->callback((Fl_Callback*)cb_fixedfreqetdial);
        fixedfreqetdial->align(Fl_Align(FL_ALIGN_RIGHT));
        fixedfreqetdial->when(FL_WHEN_CHANGED);
        o->value(pars->PfixedfreqET);
        if (pars->Pfixedfreq==0) o->deactivate();
        o->setValueType(VC_FixedFreqET);
      } // WidgetPDial* fixedfreqetdial
      { mwheel_slider_rev* o = detune = new mwheel_slider_rev(491, 47, 234, 15);
        detune->tooltip("Fine Detune (cents)");
        detune->type(5);
        detune->box(FL_THIN_DOWN_BOX);
        detune->color(FL_BACKGROUND_COLOR);
        detune->selection_color(FL_BACKGROUND_COLOR);
        detune->labeltype(FL_NORMAL_LABEL);
        detune->labelfont(0);
        detune->labelsize(14);
        detune->labelcolor(FL_FOREGROUND_COLOR);
        detune->minimum(-8192);
        detune->maximum(8191);
        detune->step(1);
        detune->callback((Fl_Callback*)cb_detune);
        detune->align(Fl_Align(FL_ALIGN_BOTTOM));
        detune->when(FL_WHEN_CHANGED);
        o->value(pars->PDetune-8192);
      } // mwheel_slider_rev* detune
      { Fl_Value_Output* o = detunevalueoutput = new Fl_Value_Output(445, 47, 45, 15, "Detune");
        detunevalueoutput->labelsize(10);
        detunevalueoutput->minimum(-5000);
        detunevalueoutput->maximum(5000);
        detunevalueoutput->textfont(1);
        detunevalueoutput->textsize(10);
        detunevalueoutput->callback((Fl_Callback*)cb_detunevalueoutput);
        detunevalueoutput->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->step(0.01, 1);
        o->value(getDetune(pars->PDetuneType,0,pars->PDetune));
      } // Fl_Value_Output* detunevalueoutput
      { Fl_Choice* o = detunetype = new Fl_Choice(655, 78, 70, 15, "Detune Type");
        detunetype->down_box(FL_BORDER_BOX);
        detunetype->labelsize(10);
        detunetype->textfont(1);
        detunetype->textsize(10);
        detunetype->callback((Fl_Callback*)cb_detunetype);
        detunetype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->add("L35cents");o->add("L10cents");o->add("E100cents");o->add("E1200cents");
        o->value(pars->PDetuneType - 1);
      } // Fl_Choice* detunetype
      { Fl_Counter* o = coarsedet = new Fl_Counter(658, 111, 60, 20, "Coarse Det.");
        coarsedet->tooltip("Coarse Detune");
        coarsedet->labelsize(10);
        coarsedet->minimum(-64);
        coarsedet->maximum(63);
        coarsedet->step(1);
        coarsedet->textfont(1);
        coarsedet->textsize(11);
        coarsedet->callback((Fl_Callback*)cb_coarsedet);
        coarsedet->align(Fl_Align(FL_ALIGN_TOP));
        int k=pars->PCoarseDetune%1024;if (k>=512) k-=1024;
        o->value(k);
        o->lstep(10);
      } // Fl_Counter* coarsedet
      freqsettingsui->end();
    } // Fl_Group* freqsettingsui
    { Fl_Box* o = new Fl_Box(440, 406, 65, 35);
      o->box(FL_THIN_UP_FRAME);
    } // Fl_Box* o
    { bandwidthsettingsui = new Fl_Group(220, 5, 220, 135, "BANDWIDTH");
      bandwidthsettingsui->box(FL_THIN_UP_FRAME);
      bandwidthsettingsui->labelfont(1);
      bandwidthsettingsui->labelsize(11);
      bandwidthsettingsui->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { EnvelopeUI* o = bandwidthenvelopegroup = new EnvelopeUI(225, 65, 210, 70, "SUBsynth - BandWidth Envelope");
        bandwidthenvelopegroup->box(FL_FLAT_BOX);
        bandwidthenvelopegroup->color((Fl_Color)51);
        bandwidthenvelopegroup->selection_color(FL_BACKGROUND_COLOR);
        bandwidthenvelopegroup->labeltype(FL_NORMAL_LABEL);
        bandwidthenvelopegroup->labelfont(0);
        bandwidthenvelopegroup->labelsize(14);
        bandwidthenvelopegroup->labelcolor(FL_FOREGROUND_COLOR);
        bandwidthenvelopegroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        bandwidthenvelopegroup->when(FL_WHEN_RELEASE);
        o->init(pars->BandWidthEnvelope, npart, kititem, 1, 3);
        if (pars->PBandWidthEnvelopeEnabled==0) o->deactivate();
        bandwidthenvelopegroup->end();
      } // EnvelopeUI* bandwidthenvelopegroup
      { Fl_Check_Button2* o = bwee = new Fl_Check_Button2(225, 67, 34, 12, "On");
        bwee->box(FL_THIN_UP_BOX);
        bwee->down_box(FL_DOWN_BOX);
        bwee->color((Fl_Color)237);
        bwee->selection_color(FL_FOREGROUND_COLOR);
        bwee->labeltype(FL_NORMAL_LABEL);
        bwee->labelfont(1);
        bwee->labelsize(10);
        bwee->labelcolor(FL_FOREGROUND_COLOR);
        bwee->callback((Fl_Callback*)cb_bwee);
        bwee->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        bwee->when(FL_WHEN_RELEASE);
        o->value(pars->PBandWidthEnvelopeEnabled);
      } // Fl_Check_Button2* bwee
      { mwheel_val_slider_rev* o = bandwidth = new mwheel_val_slider_rev(225, 40, 115, 15, "Bandwidth");
        bandwidth->tooltip("Base bandwidth, approximate");
        bandwidth->type(5);
        bandwidth->box(FL_THIN_DOWN_BOX);
        bandwidth->color(FL_BACKGROUND_COLOR);
        bandwidth->selection_color(FL_BACKGROUND_COLOR);
        bandwidth->labeltype(FL_NORMAL_LABEL);
        bandwidth->labelfont(0);
        bandwidth->labelsize(10);
        bandwidth->labelcolor(FL_FOREGROUND_COLOR);
        bandwidth->maximum(127);
        bandwidth->step(1);
        bandwidth->callback((Fl_Callback*)cb_bandwidth);
        bandwidth->align(Fl_Align(FL_ALIGN_TOP));
        bandwidth->when(FL_WHEN_CHANGED);
        o->setValueType(VC_SubBandwidth);
        o->useCustomTip(true);
        o->value(pars->Pbandwidth);
      } // mwheel_val_slider_rev* bandwidth
      { mwheel_val_slider_rev* o = bwidthscale = new mwheel_val_slider_rev(344, 40, 90, 15, "Bandwidth Scale");
        bwidthscale->tooltip("Freq-dep. bw. scaling");
        bwidthscale->type(5);
        bwidthscale->box(FL_THIN_DOWN_BOX);
        bwidthscale->color(FL_BACKGROUND_COLOR);
        bwidthscale->selection_color(FL_BACKGROUND_COLOR);
        bwidthscale->labeltype(FL_NORMAL_LABEL);
        bwidthscale->labelfont(0);
        bwidthscale->labelsize(10);
        bwidthscale->labelcolor(FL_FOREGROUND_COLOR);
        bwidthscale->minimum(-64);
        bwidthscale->maximum(63);
        bwidthscale->step(1);
        bwidthscale->callback((Fl_Callback*)cb_bwidthscale);
        bwidthscale->align(Fl_Align(FL_ALIGN_TOP));
        bwidthscale->when(FL_WHEN_CHANGED);
        o->setValueType(VC_SubBandwidthScale); o->setGraphicsType(VC_SubBandwidthScale);
        o->useCustomTip(true);
        o->value(pars->Pbwscale-64);
      } // mwheel_val_slider_rev* bwidthscale
      bandwidthsettingsui->end();
    } // Fl_Group* bandwidthsettingsui
    { spreadGroup = new Fl_Group(440, 140, 290, 81, "OVERTONES");
      spreadGroup->box(FL_THIN_UP_FRAME);
      spreadGroup->labelfont(1);
      spreadGroup->labelsize(11);
      spreadGroup->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { WidgetPDial* o = spreadpar1 = new WidgetPDial(570, 166, 30, 30, "Par1");
        spreadpar1->box(FL_ROUND_UP_BOX);
        spreadpar1->color(FL_BACKGROUND_COLOR);
        spreadpar1->selection_color(FL_INACTIVE_COLOR);
        spreadpar1->labeltype(FL_NORMAL_LABEL);
        spreadpar1->labelfont(0);
        spreadpar1->labelsize(10);
        spreadpar1->labelcolor(FL_FOREGROUND_COLOR);
        spreadpar1->maximum(255);
        spreadpar1->step(1);
        spreadpar1->callback((Fl_Callback*)cb_spreadpar1);
        spreadpar1->align(Fl_Align(FL_ALIGN_BOTTOM));
        spreadpar1->when(FL_WHEN_CHANGED);
        o->value(pars->POvertoneSpread.par1);
      } // WidgetPDial* spreadpar1
      { WidgetPDial* o = spreadpar2 = new WidgetPDial(625, 166, 30, 30, "Par2");
        spreadpar2->box(FL_ROUND_UP_BOX);
        spreadpar2->color(FL_BACKGROUND_COLOR);
        spreadpar2->selection_color(FL_INACTIVE_COLOR);
        spreadpar2->labeltype(FL_NORMAL_LABEL);
        spreadpar2->labelfont(0);
        spreadpar2->labelsize(10);
        spreadpar2->labelcolor(FL_FOREGROUND_COLOR);
        spreadpar2->maximum(255);
        spreadpar2->step(1);
        spreadpar2->callback((Fl_Callback*)cb_spreadpar2);
        spreadpar2->align(Fl_Align(FL_ALIGN_BOTTOM));
        spreadpar2->when(FL_WHEN_CHANGED);
        o->value(pars->POvertoneSpread.par2);
      } // WidgetPDial* spreadpar2
      { WidgetPDial* o = spreadpar3 = new WidgetPDial(680, 166, 30, 30, "ForceH");
        spreadpar3->tooltip("Move towards closest harmonic");
        spreadpar3->box(FL_ROUND_UP_BOX);
        spreadpar3->color(FL_BACKGROUND_COLOR);
        spreadpar3->selection_color(FL_INACTIVE_COLOR);
        spreadpar3->labeltype(FL_NORMAL_LABEL);
        spreadpar3->labelfont(0);
        spreadpar3->labelsize(10);
        spreadpar3->labelcolor(FL_FOREGROUND_COLOR);
        spreadpar3->maximum(255);
        spreadpar3->step(1);
        spreadpar3->callback((Fl_Callback*)cb_spreadpar3);
        spreadpar3->align(Fl_Align(FL_ALIGN_BOTTOM));
        spreadpar3->when(FL_WHEN_CHANGED);
        o->value(pars->POvertoneSpread.par3);
        o->setValueType(VC_percent255);
      } // WidgetPDial* spreadpar3
      spreadGroup->end();
    } // Fl_Group* spreadGroup
    { Fl_Choice* o = spreadtype = new Fl_Choice(460, 171, 87, 20, "Overtone Positions");
      spreadtype->down_box(FL_BORDER_BOX);
      spreadtype->labelsize(11);
      spreadtype->textfont(1);
      spreadtype->textsize(11);
      spreadtype->callback((Fl_Callback*)cb_spreadtype);
      spreadtype->align(Fl_Align(FL_ALIGN_BOTTOM));
      o->add("Harmonic");o->add("ShiftU");o->add("ShiftL");o->add("PowerU");o->add("PowerL");o->add("Sine");o->add("Power");o->add("Shift");
      o->value(pars->POvertoneSpread.type);
      if (int(o->value()) > 0) {spreadGroup->activate(); if (int(o->value()) < 7) spreadpar2->activate(); else spreadpar2->deactivate();} else spreadGroup->deactivate();
    } // Fl_Choice* spreadtype
    { Fl_Group* o = globalfiltergroup = new Fl_Group(440, 221, 290, 185, " FILTER ");
      globalfiltergroup->box(FL_THIN_UP_FRAME);
      globalfiltergroup->labelfont(1);
      globalfiltergroup->labelsize(11);
      globalfiltergroup->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { EnvelopeUI* o = filterenv = new EnvelopeUI(447, 328, 275, 70, "SUBsynth - Filter Envelope");
        filterenv->box(FL_FLAT_BOX);
        filterenv->color((Fl_Color)51);
        filterenv->selection_color(FL_BACKGROUND_COLOR);
        filterenv->labeltype(FL_NORMAL_LABEL);
        filterenv->labelfont(0);
        filterenv->labelsize(14);
        filterenv->labelcolor(FL_FOREGROUND_COLOR);
        filterenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        filterenv->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalFilterEnvelope, npart, kititem, 1, 2);
        filterenv->end();
      } // EnvelopeUI* filterenv
      { FilterUI* o = filterui = new FilterUI(447, 246, 275, 75, "SUBsynth - Filter");
        filterui->box(FL_FLAT_BOX);
        filterui->color(FL_LIGHT1);
        filterui->selection_color(FL_BACKGROUND_COLOR);
        filterui->labeltype(FL_NORMAL_LABEL);
        filterui->labelfont(0);
        filterui->labelsize(14);
        filterui->labelcolor(FL_FOREGROUND_COLOR);
        filterui->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        filterui->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalFilter,&pars->PGlobalFilterVelocityScale,&pars->PGlobalFilterVelocityScaleFunction, npart, kititem, 1);
        filterui->end();
      } // FilterUI* filterui
      if (pars->PGlobalFilterEnabled==0) o->deactivate();
      globalfiltergroup->end();
    } // Fl_Group* globalfiltergroup
    { Fl_Check_Button2* o = filtere = new Fl_Check_Button2(446, 227, 36, 13, "On");
      filtere->box(FL_THIN_UP_BOX);
      filtere->down_box(FL_DOWN_BOX);
      filtere->color((Fl_Color)237);
      filtere->selection_color(FL_FOREGROUND_COLOR);
      filtere->labeltype(FL_NORMAL_LABEL);
      filtere->labelfont(1);
      filtere->labelsize(10);
      filtere->labelcolor(FL_FOREGROUND_COLOR);
      filtere->callback((Fl_Callback*)cb_filtere);
      filtere->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      filtere->when(FL_WHEN_RELEASE);
      o->value(pars->PGlobalFilterEnabled);
    } // Fl_Check_Button2* filtere
    { Fl_Group* o = new Fl_Group(504, 406, 226, 35);
      o->box(FL_THIN_UP_FRAME);
      { Fl_Counter* o = filterstages = new Fl_Counter(520, 421, 45, 15, "Filter Stages");
        filterstages->tooltip("How many times the noise is filtered");
        filterstages->type(1);
        filterstages->labelfont(1);
        filterstages->labelsize(10);
        filterstages->minimum(1);
        filterstages->maximum(5);
        filterstages->step(1);
        filterstages->value(1);
        filterstages->textsize(10);
        filterstages->callback((Fl_Callback*)cb_filterstages);
        filterstages->align(Fl_Align(FL_ALIGN_TOP));
        o->value(pars->Pnumstages);
      } // Fl_Counter* filterstages
      { Fl_Choice* o = magtype = new Fl_Choice(590, 421, 65, 15, "Mag.Type");
        magtype->down_box(FL_BORDER_BOX);
        magtype->labelfont(1);
        magtype->labelsize(10);
        magtype->textfont(1);
        magtype->textsize(11);
        magtype->callback((Fl_Callback*)cb_magtype);
        magtype->align(Fl_Align(FL_ALIGN_TOP));
        o->add("Linear");o->add("-40dB");o->add("-60dB");o->add("-80dB");o->add("-100dB");
        o->value(pars->Phmagtype);
      } // Fl_Choice* magtype
      { Fl_Choice* o = start = new Fl_Choice(670, 421, 50, 15, "Start");
        start->down_box(FL_BORDER_BOX);
        start->labelfont(1);
        start->labelsize(10);
        start->textfont(1);
        start->textsize(11);
        start->callback((Fl_Callback*)cb_start);
        start->align(Fl_Align(FL_ALIGN_TOP));
        o->add("Zero");o->add("Rnd");o->add("Max.");
        o->value(pars->Pstart);
      } // Fl_Choice* start
      o->end();
    } // Fl_Group* o
    { Fl_Box* o = new Fl_Box(441, 414, 16, 17);
      o->box(FL_THIN_UP_BOX);
      o->color((Fl_Color)237);
    } // Fl_Box* o
    { Fl_Check_Button2* o = stereo = new Fl_Check_Button2(442, 415, 59, 15, " Stereo");
      stereo->box(FL_NO_BOX);
      stereo->down_box(FL_DOWN_BOX);
      stereo->color((Fl_Color)237);
      stereo->selection_color(FL_FOREGROUND_COLOR);
      stereo->labeltype(FL_NORMAL_LABEL);
      stereo->labelfont(1);
      stereo->labelsize(10);
      stereo->labelcolor(FL_FOREGROUND_COLOR);
      stereo->callback((Fl_Callback*)cb_stereo);
      stereo->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      stereo->when(FL_WHEN_RELEASE);
      o->value(pars->Pstereo);
    } // Fl_Check_Button2* stereo
    { subClear = new Fl_Button(445, 446, 70, 20, "Clear");
      subClear->tooltip("Clear the harmonics");
      subClear->box(FL_THIN_UP_BOX);
      subClear->labelfont(1);
      subClear->labelsize(11);
      subClear->callback((Fl_Callback*)cb_subClear);
    } // Fl_Button* subClear
    { subCopy = new Fl_Button(540, 449, 25, 15, "C");
      subCopy->box(FL_THIN_UP_BOX);
      subCopy->color((Fl_Color)179);
      subCopy->labelfont(1);
      subCopy->labelsize(11);
      subCopy->labelcolor(FL_BACKGROUND2_COLOR);
      subCopy->callback((Fl_Callback*)cb_subCopy);
    } // Fl_Button* subCopy
    { subPaste = new Fl_Button(576, 449, 25, 15, "P");
      subPaste->box(FL_THIN_UP_BOX);
      subPaste->color((Fl_Color)179);
      subPaste->labelfont(1);
      subPaste->labelsize(11);
      subPaste->labelcolor(FL_BACKGROUND2_COLOR);
      subPaste->callback((Fl_Callback*)cb_subPaste);
    } // Fl_Button* subPaste
    { subClose = new Fl_Button(625, 446, 105, 20, "Close");
      subClose->tooltip("Right click: also reopen previous");
      subClose->box(FL_THIN_UP_BOX);
      subClose->labelfont(1);
      subClose->labelsize(11);
      subClose->callback((Fl_Callback*)cb_subClose);
    } // Fl_Button* subClose
    o->copy_label(synth->getGuiMaster()->setPartWindowTitle("SubSynth").c_str());
    subDW = o->w();subDH=o->h();
    SUBparameters->size_range(subDW, subDH, 0, 0, 0, 0, 1);
    SUBparameters->end();
    SUBparameters->resizable(SUBparameters);
  } // Fl_Double_Window* SUBparameters
  return SUBparameters;
}

void SUBnoteUI::refresh() {
  //
      for (int i = 0; i < MAX_SUB_HARMONICS; ++i)
          h[i]->refresh();
      vol->value(pars->PVolume);
      vsns->value(pars->PAmpVelocityScaleFunction);
      pan->value(pars->PPanning);
  
      bandwidth->value(pars->Pbandwidth);
      bwidthscale->value(pars->Pbwscale-64);
      bwee->value(pars->PBandWidthEnvelopeEnabled);
      if (pars->PBandWidthEnvelopeEnabled == 0)
          bandwidthenvelopegroup->deactivate();
      else
          bandwidthenvelopegroup->activate();
      bwee->show();
      bandwidthsettingsui->redraw();
  
      detunevalueoutput->value(getDetune(pars->PDetuneType,0,pars->PDetune));
      freqee->value(pars->PFreqEnvelopeEnabled);
      if (pars->PFreqEnvelopeEnabled == 0)
          freqenvelopegroup->deactivate();
      else
          freqenvelopegroup->activate();
      freqee->show();
      freqsettingsui->redraw();
  
      detune->value(pars->PDetune - 8192);
      hz440->value(pars->Pfixedfreq);
  
      fixedfreqetdial->value(pars->PfixedfreqET);
  
      int k = pars->PCoarseDetune / 1024;
      if (k >= 8)
          k -= 16;
      octave->value(k);
  
      detunetype->value(pars->PDetuneType - 1);
  
      k = pars->PCoarseDetune % 1024;
      if (k >= 512)
          k -= 1024;
      coarsedet->value(k);
  
      filtere->value(pars->PGlobalFilterEnabled);
      if (pars->PGlobalFilterEnabled == 0)
          globalfiltergroup->deactivate();
      else
          globalfiltergroup->activate();
      filtere->show();
      globalfiltergroup->redraw();
  
      stereo->value(pars->Pstereo);
      filterstages->value(pars->Pnumstages);
      magtype->value(pars->Phmagtype);
      start->value(pars->Pstart);
  
      ampenv->refresh();
      bandwidthenvelopegroup->refresh();
      freqenvelopegroup->refresh();
      filterui->refresh();
      filterenv->refresh();
}

void SUBnoteUI::Showsub() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;
      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "SubSynth");
      if (fetchW < subDW || fetchH < subDH)
      {
          fetchW = subDW;
          fetchH = subDH;
      }
      checkSane(fetchX, fetchY, fetchW, fetchH, subDW, subDH);
  
      SUBparameters->resize(fetchX, fetchY, fetchW, fetchH);
      SUBparameters->show();
      lastsubW = 0;
      subSeen = true;
}

void SUBnoteUI::subRtext() {
  //
      ampenv->wincheck();
      bandwidthenvelopegroup->wincheck();
      filterenv->wincheck();
      freqenvelopegroup->wincheck();
  
      if (filterui->formantparswindow->visible())
          filterui->formantRtext();
  
      if (!SUBparameters->visible())
          return;
  
      if(SUBparameters->w() == lastsubW)
           return;
  
      lastsubW = SUBparameters->w();
  
      float dScale = SUBparameters->w() / float(subDW);
      if (dScale < 0.2f)
          dScale = 0.2f;
  
      ampenv->envRtext(dScale);
      bandwidthenvelopegroup->envRtext(dScale);
      filterenv->envRtext(dScale);
      freqenvelopegroup->envRtext(dScale);
  
      filterui->filterRtext(dScale);
  
      int size = int(10 * dScale);
      int size11 = int(11 * dScale);
      frame->scroll_to(0, 0);
      frame->size(int(435 * dScale), int(326 * dScale));
      frame->scrollbar_size(12 * dScale);
      harmonics->size(int(435 * dScale), int(275 * dScale * 1.1));
  
      for (int i=0;i<MAX_SUB_HARMONICS;i++)
      {
          h[i]->size(20 * dScale, 275 * dScale * 1.1);
          h[i]->h_num->labelsize(int(12 * dScale));
          h[i]->h_dash->size(int(10 * dScale), int(3 * dScale));
      }
  
      ampgrp->labelsize(size11);
      vol->labelsize(size);
      vsns->labelsize(size);
      pan->labelsize(size);
      panwidth->labelsize(size);
      randompan->labelsize(size11);
  
      freqsettingsui->labelsize(size11);
      freqee->labelsize(size);
      octave->labelsize(size);
          octave->textsize(size11);
      bend->labelsize(size);
      offset->labelsize(size);
      hz440->labelsize(size);
      fixedfreqetdial->labelsize(size);
      detunevalueoutput->labelsize(size);
          detunevalueoutput->textsize(size);
      detunetype->labelsize(size);
          detunetype->textsize(size);
      coarsedet->labelsize(size);
          coarsedet->textsize(size11);
  
      bandwidthsettingsui->labelsize(size11);
      bwee->labelsize(size);
      bandwidth->labelsize(size);
           bandwidth->textsize(size);
      bwidthscale->labelsize(size);
          bwidthscale->textsize(size);
  
      spreadGroup->labelsize(size11);
      spreadpar1->labelsize(size);
      spreadpar2->labelsize(size);
      spreadpar3->labelsize(size);
      spreadtype->labelsize(size11);
          spreadtype->textsize(size11);
  
      globalfiltergroup->labelsize(size11);
      filtere->labelsize(size);
      filterstages->labelsize(size);
          filterstages->textsize(size11);
      magtype->labelsize(size);
          magtype->textsize(size11);
      start->labelsize(size);
          start->textsize(size11);
  
      stereo->labelsize(size);
      subClear->labelsize(size11);
      subCopy->labelsize(size11);
      subPaste->labelsize(size11);
      subClose->labelsize(size11);
  
      SUBparameters->redraw();
}

void SUBnoteUI::send_data(int action, int control, float value, int type) {
  //
          type |= TOPLEVEL::type::Write;
          collect_data(synth, value, action, type, control, npart, kititem, 1);
}

void SUBnoteUI::returns_update(CommandBlock *getData) {
  //
      float value = getData->data.value;
      unsigned char control = getData->data.control;
      unsigned char insert = getData->data.insert;
      bool val_bool = _SYS_::F2B(value);
      if (insert == TOPLEVEL::insert::harmonicAmplitude)
      {
          h[control]->mag->value((int) value);
          return;
      }
      if (insert == TOPLEVEL::insert::harmonicPhaseBandwidth)
      {
          h[control]->bw->value((int)value - 64);
          return;
      }
  
      switch(control)
      {
          case SUBSYNTH::control::volume:
              vol->value(value);
              break;
  
          case SUBSYNTH::control::velocitySense:
              vsns->value(value);
              break;
  
          case SUBSYNTH::control::panning:
              pan->value(value);
              break;
          case SUBSYNTH::control::enableRandomPan:
              randompan->value(val_bool);
              if (val_bool)
                  panwidth->activate();
              else
                  panwidth->deactivate();
              break;
          case SUBSYNTH::control::randomWidth:
              panwidth->value(value);
              break;
  
          case SUBSYNTH::control::bandwidth:
              bandwidth->value(value);
              break;
  
          case SUBSYNTH::control::bandwidthScale:
              bwidthscale->value(value);
              break;
  
          case SUBSYNTH::control::enableBandwidthEnvelope:
              bwee->value(val_bool);
              if (val_bool)
                  bandwidthenvelopegroup->activate();
              else
                  bandwidthenvelopegroup->deactivate();
              bwee->show();
              break;
  
          case SUBSYNTH::control::detuneFrequency:
              detune->value(value);
              detunevalueoutput->do_callback();
              break;
  
          case SUBSYNTH::control::equalTemperVariation:
              fixedfreqetdial->value(value);
              break;
  
          case SUBSYNTH::control::baseFrequencyAs440Hz:
              hz440->value(_SYS_::F2B(value));
              if (value == 0)
                  fixedfreqetdial->deactivate();
              else
                  fixedfreqetdial->activate();
              break;
  
          case SUBSYNTH::control::octave:
              octave->value(lrint(value));
              break;
  
          case SUBSYNTH::control::detuneType:
              detunetype->value(value - 1);
              break;
  
          case SUBSYNTH::control::coarseDetune:
              coarsedet->value(value);
              break;
  
          case SUBSYNTH::control::pitchBendAdjustment:
              bend->value(value);
              break;
  
          case SUBSYNTH::control::pitchBendOffset:
              offset->value(value);
              break;
  
          case SUBSYNTH::control::enableFrequencyEnvelope:
              freqee->value(value);
              if (val_bool)
                  freqenvelopegroup->activate();
              else
                  freqenvelopegroup->deactivate();
              freqee->show();
              break;
  
          case SUBSYNTH::control::overtoneParameter1:
              spreadpar1->value((unsigned int) value);
              break;
  
          case SUBSYNTH::control::overtoneParameter2:
              spreadpar2->value((unsigned int) value);
              break;
  
          case SUBSYNTH::control::overtoneForceHarmonics:
              spreadpar3->value((unsigned int) value);
              break;
  
          case SUBSYNTH::control::overtonePosition:
              spreadtype->value((int) value);
              if (spreadtype->value() > 0)
              {
                  spreadGroup->activate();
                  if (spreadtype->value() < 7)
                      spreadpar2->activate();
                  else
                      spreadpar2->deactivate();
              }
              else
                  spreadGroup->deactivate();
              break;
  
          case SUBSYNTH::control::enableFilter:
              filtere->value(val_bool);
              if (val_bool)
                  globalfiltergroup->activate();
              else
                  globalfiltergroup->deactivate();
              globalfiltergroup->redraw();
              break;
  
          case SUBSYNTH::control::filterStages:
              filterstages->value((int) value);
              break;
          case SUBSYNTH::control::magType:
              magtype->value((int) value);
              break;
  
          case SUBSYNTH::control::startPosition:
              start->value((int) value);
              break;
  
          case SUBSYNTH::control::clearHarmonics:
              for (int i = 0; i < MAX_SUB_HARMONICS; i++)
              {
                  h[i]->mag->value(0);
                  h[i]->bw->value(0);
              }
              h[0]->mag->value(127);
              break;
  
          case SUBSYNTH::control::stereo:
              stereo->value(val_bool);
              break;
      }
}

SUBnoteUI::SUBnoteUI(SUBnoteParameters *parameters, int npart_, int kititem_) {
  //
      pars = parameters;
      synth = pars->getSynthEngine();
      npart = npart_;
      kititem = kititem_;
      lastsubW = 0;
      subSeen = false;
      make_window();
}

SUBnoteUI::~SUBnoteUI() {
  //
      if (subSeen)
          saveWin(synth, SUBparameters->w(), SUBparameters->h(), SUBparameters->x(), SUBparameters->y(),  true, "SubSynth");
      subSeen = false;
      SUBparameters->hide();
      delete(SUBparameters);
}
