/* baobab-cellrenderers.c generated by valac 0.56.0, the Vala compiler
 * generated from baobab-cellrenderers.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "baobab.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <pango/pango.h>

#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
enum  {
	BAOBAB_CELL_RENDERER_NAME_0_PROPERTY,
	BAOBAB_CELL_RENDERER_NAME_STATE_PROPERTY,
	BAOBAB_CELL_RENDERER_NAME_DISPLAY_NAME_PROPERTY,
	BAOBAB_CELL_RENDERER_NAME_NAME_PROPERTY,
	BAOBAB_CELL_RENDERER_NAME_NUM_PROPERTIES
};
static GParamSpec* baobab_cell_renderer_name_properties[BAOBAB_CELL_RENDERER_NAME_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	BAOBAB_CELL_RENDERER_TABULAR_0_PROPERTY,
	BAOBAB_CELL_RENDERER_TABULAR_NUM_PROPERTIES
};
static GParamSpec* baobab_cell_renderer_tabular_properties[BAOBAB_CELL_RENDERER_TABULAR_NUM_PROPERTIES];
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
enum  {
	BAOBAB_CELL_RENDERER_SIZE_0_PROPERTY,
	BAOBAB_CELL_RENDERER_SIZE_STATE_PROPERTY,
	BAOBAB_CELL_RENDERER_SIZE_SIZE_PROPERTY,
	BAOBAB_CELL_RENDERER_SIZE_NUM_PROPERTIES
};
static GParamSpec* baobab_cell_renderer_size_properties[BAOBAB_CELL_RENDERER_SIZE_NUM_PROPERTIES];
enum  {
	BAOBAB_CELL_RENDERER_ITEMS_0_PROPERTY,
	BAOBAB_CELL_RENDERER_ITEMS_STATE_PROPERTY,
	BAOBAB_CELL_RENDERER_ITEMS_ITEMS_PROPERTY,
	BAOBAB_CELL_RENDERER_ITEMS_NUM_PROPERTIES
};
static GParamSpec* baobab_cell_renderer_items_properties[BAOBAB_CELL_RENDERER_ITEMS_NUM_PROPERTIES];
enum  {
	BAOBAB_CELL_RENDERER_TIME_0_PROPERTY,
	BAOBAB_CELL_RENDERER_TIME_TIME_PROPERTY,
	BAOBAB_CELL_RENDERER_TIME_NUM_PROPERTIES
};
static GParamSpec* baobab_cell_renderer_time_properties[BAOBAB_CELL_RENDERER_TIME_NUM_PROPERTIES];

struct _BaobabCellRendererNamePrivate {
	BaobabScannerState _state;
	gchar* _display_name;
};

struct _BaobabCellRendererSizePrivate {
	BaobabScannerState _state;
};

struct _BaobabCellRendererItemsPrivate {
	BaobabScannerState _state;
};

static gint BaobabCellRendererName_private_offset;
static gpointer baobab_cell_renderer_name_parent_class = NULL;
static gpointer baobab_cell_renderer_tabular_parent_class = NULL;
static gint BaobabCellRendererSize_private_offset;
static gpointer baobab_cell_renderer_size_parent_class = NULL;
static gint BaobabCellRendererItems_private_offset;
static gpointer baobab_cell_renderer_items_parent_class = NULL;
static gpointer baobab_cell_renderer_time_parent_class = NULL;

static void baobab_cell_renderer_name_real_snapshot (GtkCellRenderer* base,
                                              GtkSnapshot* snp,
                                              GtkWidget* widget,
                                              GdkRectangle* background_area,
                                              GdkRectangle* cell_area,
                                              GtkCellRendererState flags);
static void baobab_cell_renderer_name_finalize (GObject * obj);
static GType baobab_cell_renderer_name_get_type_once (void);
static void _vala_baobab_cell_renderer_name_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_baobab_cell_renderer_name_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static GObject * baobab_cell_renderer_tabular_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static GType baobab_cell_renderer_tabular_get_type_once (void);
static void baobab_cell_renderer_size_finalize (GObject * obj);
static GType baobab_cell_renderer_size_get_type_once (void);
static void _vala_baobab_cell_renderer_size_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_baobab_cell_renderer_size_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void baobab_cell_renderer_items_finalize (GObject * obj);
static GType baobab_cell_renderer_items_get_type_once (void);
static void _vala_baobab_cell_renderer_items_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_baobab_cell_renderer_items_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static GType baobab_cell_renderer_time_get_type_once (void);
static void _vala_baobab_cell_renderer_time_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

gchar*
baobab_format_name (const gchar* display_name,
                    const gchar* name)
{
	gchar* _tmp2_;
	gchar* result;
	if (display_name != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (display_name);
		result = _tmp0_;
		return result;
	}
	if (name != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_filename_display_name (name);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_strdup ("");
	result = _tmp2_;
	return result;
}

gchar*
baobab_format_items (gint items)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf (ngettext ("%d item", "%d items", (gulong) items), items);
	result = _tmp0_;
	return result;
}

gchar*
baobab_format_time_approximate (guint64 time)
{
	GDateTime* dt = NULL;
	GDateTime* _tmp1_;
	GDateTime* now = NULL;
	GDateTime* _tmp2_;
	GTimeSpan ts = 0LL;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	gulong years = 0UL;
	gchar* _tmp8_;
	gchar* result;
	if (time == ((guint64) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (_ ("Unknown"));
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_date_time_new_from_unix_local ((gint64) time);
	dt = _tmp1_;
	_tmp2_ = g_date_time_new_now_local ();
	now = _tmp2_;
	_tmp3_ = now;
	_tmp4_ = dt;
	ts = g_date_time_difference (_tmp3_, _tmp4_);
	if (ts < G_TIME_SPAN_DAY) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (_ ("Today"));
		result = _tmp5_;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (dt);
		return result;
	}
	if (ts < (31 * G_TIME_SPAN_DAY)) {
		gulong days = 0UL;
		gchar* _tmp6_;
		days = (gulong) (ts / G_TIME_SPAN_DAY);
		_tmp6_ = g_strdup_printf (ngettext ("%lu day", "%lu days", days), days);
		result = _tmp6_;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (dt);
		return result;
	}
	if (ts < (365 * G_TIME_SPAN_DAY)) {
		gulong months = 0UL;
		gchar* _tmp7_;
		months = (gulong) (ts / (31 * G_TIME_SPAN_DAY));
		_tmp7_ = g_strdup_printf (ngettext ("%lu month", "%lu months", months), months);
		result = _tmp7_;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (dt);
		return result;
	}
	years = (gulong) (ts / (365 * G_TIME_SPAN_DAY));
	_tmp8_ = g_strdup_printf (ngettext ("%lu year", "%lu years", years), years);
	result = _tmp8_;
	_g_date_time_unref0 (now);
	_g_date_time_unref0 (dt);
	return result;
}

static inline gpointer
baobab_cell_renderer_name_get_instance_private (BaobabCellRendererName* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabCellRendererName_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
baobab_cell_renderer_name_real_snapshot (GtkCellRenderer* base,
                                         GtkSnapshot* snp,
                                         GtkWidget* widget,
                                         GdkRectangle* background_area,
                                         GdkRectangle* cell_area,
                                         GtkCellRendererState flags)
{
	BaobabCellRendererName * self;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	BaobabScannerState _tmp3_;
	GdkRectangle _tmp6_;
	GdkRectangle _tmp7_;
	GtkStyleContext* _tmp8_;
	self = (BaobabCellRendererName*) base;
	g_return_if_fail (snp != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp0_ = gtk_widget_get_style_context (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	_tmp2_ = context;
	gtk_style_context_save (_tmp2_);
	_tmp3_ = self->priv->_state;
	switch (_tmp3_) {
		case BAOBAB_SCANNER_STATE_ERROR:
		{
			GtkStyleContext* _tmp4_;
			_tmp4_ = context;
			gtk_style_context_add_class (_tmp4_, "baobab-cell-error");
			break;
		}
		case BAOBAB_SCANNER_STATE_CHILD_ERROR:
		{
			GtkStyleContext* _tmp5_;
			_tmp5_ = context;
			gtk_style_context_add_class (_tmp5_, "baobab-cell-warning");
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp6_ = *background_area;
	_tmp7_ = *cell_area;
	GTK_CELL_RENDERER_CLASS (baobab_cell_renderer_name_parent_class)->snapshot ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_cell_renderer_text_get_type (), GtkCellRendererText), snp, widget, &_tmp6_, &_tmp7_, flags);
	_tmp8_ = context;
	gtk_style_context_restore (_tmp8_);
	_g_object_unref0 (context);
}

BaobabCellRendererName*
baobab_cell_renderer_name_construct (GType object_type)
{
	BaobabCellRendererName * self = NULL;
	self = (BaobabCellRendererName*) g_object_new (object_type, NULL);
	return self;
}

BaobabCellRendererName*
baobab_cell_renderer_name_new (void)
{
	return baobab_cell_renderer_name_construct (BAOBAB_TYPE_CELL_RENDERER_NAME);
}

BaobabScannerState
baobab_cell_renderer_name_get_state (BaobabCellRendererName* self)
{
	BaobabScannerState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
baobab_cell_renderer_name_set_state (BaobabCellRendererName* self,
                                     BaobabScannerState value)
{
	BaobabScannerState old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_cell_renderer_name_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, baobab_cell_renderer_name_properties[BAOBAB_CELL_RENDERER_NAME_STATE_PROPERTY]);
	}
}

const gchar*
baobab_cell_renderer_name_get_display_name (BaobabCellRendererName* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

void
baobab_cell_renderer_name_set_display_name (BaobabCellRendererName* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_cell_renderer_name_get_display_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_name);
		self->priv->_display_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, baobab_cell_renderer_name_properties[BAOBAB_CELL_RENDERER_NAME_DISPLAY_NAME_PROPERTY]);
	}
}

void
baobab_cell_renderer_name_set_name (BaobabCellRendererName* self,
                                    const gchar* value)
{
	gchar* escaped = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	BaobabScannerState _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = baobab_format_name (_tmp0_, value);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_markup_escape_text (_tmp2_, (gssize) -1);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	escaped = _tmp4_;
	_tmp5_ = self->priv->_state;
	switch (_tmp5_) {
		case BAOBAB_SCANNER_STATE_ERROR:
		{
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = escaped;
			_tmp7_ = g_strdup_printf ("<b>%s</b>", _tmp6_);
			_tmp8_ = _tmp7_;
			g_object_set ((GtkCellRendererText*) self, "markup", _tmp8_, NULL);
			_g_free0 (_tmp8_);
			break;
		}
		case BAOBAB_SCANNER_STATE_CHILD_ERROR:
		{
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = escaped;
			_tmp10_ = g_strdup_printf ("<b>%s</b>", _tmp9_);
			_tmp11_ = _tmp10_;
			g_object_set ((GtkCellRendererText*) self, "markup", _tmp11_, NULL);
			_g_free0 (_tmp11_);
			break;
		}
		default:
		{
			const gchar* _tmp12_;
			_tmp12_ = escaped;
			g_object_set ((GtkCellRendererText*) self, "markup", _tmp12_, NULL);
			break;
		}
	}
	_g_free0 (escaped);
	g_object_notify_by_pspec ((GObject *) self, baobab_cell_renderer_name_properties[BAOBAB_CELL_RENDERER_NAME_NAME_PROPERTY]);
}

static void
baobab_cell_renderer_name_class_init (BaobabCellRendererNameClass * klass,
                                      gpointer klass_data)
{
	baobab_cell_renderer_name_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabCellRendererName_private_offset);
	((GtkCellRendererClass *) klass)->snapshot = (void (*) (GtkCellRenderer*, GtkSnapshot*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) baobab_cell_renderer_name_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_cell_renderer_name_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_cell_renderer_name_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_cell_renderer_name_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_NAME_STATE_PROPERTY, baobab_cell_renderer_name_properties[BAOBAB_CELL_RENDERER_NAME_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", BAOBAB_SCANNER_TYPE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_NAME_DISPLAY_NAME_PROPERTY, baobab_cell_renderer_name_properties[BAOBAB_CELL_RENDERER_NAME_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_NAME_NAME_PROPERTY, baobab_cell_renderer_name_properties[BAOBAB_CELL_RENDERER_NAME_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
baobab_cell_renderer_name_instance_init (BaobabCellRendererName * self,
                                         gpointer klass)
{
	self->priv = baobab_cell_renderer_name_get_instance_private (self);
}

static void
baobab_cell_renderer_name_finalize (GObject * obj)
{
	BaobabCellRendererName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CELL_RENDERER_NAME, BaobabCellRendererName);
	_g_free0 (self->priv->_display_name);
	G_OBJECT_CLASS (baobab_cell_renderer_name_parent_class)->finalize (obj);
}

static GType
baobab_cell_renderer_name_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabCellRendererNameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_cell_renderer_name_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabCellRendererName), 0, (GInstanceInitFunc) baobab_cell_renderer_name_instance_init, NULL };
	GType baobab_cell_renderer_name_type_id;
	baobab_cell_renderer_name_type_id = g_type_register_static (gtk_cell_renderer_text_get_type (), "BaobabCellRendererName", &g_define_type_info, 0);
	BaobabCellRendererName_private_offset = g_type_add_instance_private (baobab_cell_renderer_name_type_id, sizeof (BaobabCellRendererNamePrivate));
	return baobab_cell_renderer_name_type_id;
}

GType
baobab_cell_renderer_name_get_type (void)
{
	static volatile gsize baobab_cell_renderer_name_type_id__once = 0;
	if (g_once_init_enter (&baobab_cell_renderer_name_type_id__once)) {
		GType baobab_cell_renderer_name_type_id;
		baobab_cell_renderer_name_type_id = baobab_cell_renderer_name_get_type_once ();
		g_once_init_leave (&baobab_cell_renderer_name_type_id__once, baobab_cell_renderer_name_type_id);
	}
	return baobab_cell_renderer_name_type_id__once;
}

static void
_vala_baobab_cell_renderer_name_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	BaobabCellRendererName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_NAME, BaobabCellRendererName);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_NAME_STATE_PROPERTY:
		g_value_set_enum (value, baobab_cell_renderer_name_get_state (self));
		break;
		case BAOBAB_CELL_RENDERER_NAME_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, baobab_cell_renderer_name_get_display_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_baobab_cell_renderer_name_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	BaobabCellRendererName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_NAME, BaobabCellRendererName);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_NAME_STATE_PROPERTY:
		baobab_cell_renderer_name_set_state (self, g_value_get_enum (value));
		break;
		case BAOBAB_CELL_RENDERER_NAME_DISPLAY_NAME_PROPERTY:
		baobab_cell_renderer_name_set_display_name (self, g_value_get_string (value));
		break;
		case BAOBAB_CELL_RENDERER_NAME_NAME_PROPERTY:
		baobab_cell_renderer_name_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

BaobabCellRendererTabular*
baobab_cell_renderer_tabular_construct (GType object_type)
{
	BaobabCellRendererTabular * self = NULL;
	self = (BaobabCellRendererTabular*) g_object_new (object_type, NULL);
	return self;
}

BaobabCellRendererTabular*
baobab_cell_renderer_tabular_new (void)
{
	return baobab_cell_renderer_tabular_construct (BAOBAB_TYPE_CELL_RENDERER_TABULAR);
}

static GObject *
baobab_cell_renderer_tabular_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BaobabCellRendererTabular * self;
	PangoAttrList* attrs = NULL;
	PangoAttrList* _tmp0_;
	PangoAttrList* _tmp1_;
	PangoAttrFontFeatures* _tmp2_;
	PangoAttrList* _tmp3_;
	parent_class = G_OBJECT_CLASS (baobab_cell_renderer_tabular_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CELL_RENDERER_TABULAR, BaobabCellRendererTabular);
	_tmp0_ = pango_attr_list_new ();
	attrs = _tmp0_;
	_tmp1_ = attrs;
	_tmp2_ = (PangoAttrFontFeatures*) pango_attr_font_features_new ("tnum=1");
	pango_attr_list_insert (_tmp1_, (PangoAttribute*) _tmp2_);
	_tmp3_ = attrs;
	g_object_set ((GtkCellRendererText*) self, "attributes", _tmp3_, NULL);
	_pango_attr_list_unref0 (attrs);
	return obj;
}

static void
baobab_cell_renderer_tabular_class_init (BaobabCellRendererTabularClass * klass,
                                         gpointer klass_data)
{
	baobab_cell_renderer_tabular_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = baobab_cell_renderer_tabular_constructor;
}

static void
baobab_cell_renderer_tabular_instance_init (BaobabCellRendererTabular * self,
                                            gpointer klass)
{
}

static GType
baobab_cell_renderer_tabular_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabCellRendererTabularClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_cell_renderer_tabular_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabCellRendererTabular), 0, (GInstanceInitFunc) baobab_cell_renderer_tabular_instance_init, NULL };
	GType baobab_cell_renderer_tabular_type_id;
	baobab_cell_renderer_tabular_type_id = g_type_register_static (gtk_cell_renderer_text_get_type (), "BaobabCellRendererTabular", &g_define_type_info, 0);
	return baobab_cell_renderer_tabular_type_id;
}

GType
baobab_cell_renderer_tabular_get_type (void)
{
	static volatile gsize baobab_cell_renderer_tabular_type_id__once = 0;
	if (g_once_init_enter (&baobab_cell_renderer_tabular_type_id__once)) {
		GType baobab_cell_renderer_tabular_type_id;
		baobab_cell_renderer_tabular_type_id = baobab_cell_renderer_tabular_get_type_once ();
		g_once_init_leave (&baobab_cell_renderer_tabular_type_id__once, baobab_cell_renderer_tabular_type_id);
	}
	return baobab_cell_renderer_tabular_type_id__once;
}

static inline gpointer
baobab_cell_renderer_size_get_instance_private (BaobabCellRendererSize* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabCellRendererSize_private_offset);
}

BaobabCellRendererSize*
baobab_cell_renderer_size_construct (GType object_type)
{
	BaobabCellRendererSize * self = NULL;
	self = (BaobabCellRendererSize*) baobab_cell_renderer_tabular_construct (object_type);
	return self;
}

BaobabCellRendererSize*
baobab_cell_renderer_size_new (void)
{
	return baobab_cell_renderer_size_construct (BAOBAB_TYPE_CELL_RENDERER_SIZE);
}

BaobabScannerState
baobab_cell_renderer_size_get_state (BaobabCellRendererSize* self)
{
	BaobabScannerState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
baobab_cell_renderer_size_set_state (BaobabCellRendererSize* self,
                                     BaobabScannerState value)
{
	BaobabScannerState old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_cell_renderer_size_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, baobab_cell_renderer_size_properties[BAOBAB_CELL_RENDERER_SIZE_STATE_PROPERTY]);
	}
}

void
baobab_cell_renderer_size_set_size (BaobabCellRendererSize* self,
                                    guint64 value)
{
	gchar* _tmp0_ = NULL;
	BaobabScannerState _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ != BAOBAB_SCANNER_STATE_ERROR) {
		gchar* _tmp2_;
		_tmp2_ = g_format_size_full (value, G_FORMAT_SIZE_DEFAULT);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	g_object_set ((GtkCellRendererText*) self, "text", _tmp0_, NULL);
	_g_free0 (_tmp0_);
	g_object_notify_by_pspec ((GObject *) self, baobab_cell_renderer_size_properties[BAOBAB_CELL_RENDERER_SIZE_SIZE_PROPERTY]);
}

static void
baobab_cell_renderer_size_class_init (BaobabCellRendererSizeClass * klass,
                                      gpointer klass_data)
{
	baobab_cell_renderer_size_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabCellRendererSize_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_cell_renderer_size_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_cell_renderer_size_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_cell_renderer_size_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_SIZE_STATE_PROPERTY, baobab_cell_renderer_size_properties[BAOBAB_CELL_RENDERER_SIZE_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", BAOBAB_SCANNER_TYPE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_SIZE_SIZE_PROPERTY, baobab_cell_renderer_size_properties[BAOBAB_CELL_RENDERER_SIZE_SIZE_PROPERTY] = g_param_spec_uint64 ("size", "size", "size", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
baobab_cell_renderer_size_instance_init (BaobabCellRendererSize * self,
                                         gpointer klass)
{
	self->priv = baobab_cell_renderer_size_get_instance_private (self);
}

static void
baobab_cell_renderer_size_finalize (GObject * obj)
{
	BaobabCellRendererSize * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CELL_RENDERER_SIZE, BaobabCellRendererSize);
	G_OBJECT_CLASS (baobab_cell_renderer_size_parent_class)->finalize (obj);
}

static GType
baobab_cell_renderer_size_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabCellRendererSizeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_cell_renderer_size_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabCellRendererSize), 0, (GInstanceInitFunc) baobab_cell_renderer_size_instance_init, NULL };
	GType baobab_cell_renderer_size_type_id;
	baobab_cell_renderer_size_type_id = g_type_register_static (BAOBAB_TYPE_CELL_RENDERER_TABULAR, "BaobabCellRendererSize", &g_define_type_info, 0);
	BaobabCellRendererSize_private_offset = g_type_add_instance_private (baobab_cell_renderer_size_type_id, sizeof (BaobabCellRendererSizePrivate));
	return baobab_cell_renderer_size_type_id;
}

GType
baobab_cell_renderer_size_get_type (void)
{
	static volatile gsize baobab_cell_renderer_size_type_id__once = 0;
	if (g_once_init_enter (&baobab_cell_renderer_size_type_id__once)) {
		GType baobab_cell_renderer_size_type_id;
		baobab_cell_renderer_size_type_id = baobab_cell_renderer_size_get_type_once ();
		g_once_init_leave (&baobab_cell_renderer_size_type_id__once, baobab_cell_renderer_size_type_id);
	}
	return baobab_cell_renderer_size_type_id__once;
}

static void
_vala_baobab_cell_renderer_size_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	BaobabCellRendererSize * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_SIZE, BaobabCellRendererSize);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_SIZE_STATE_PROPERTY:
		g_value_set_enum (value, baobab_cell_renderer_size_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_baobab_cell_renderer_size_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	BaobabCellRendererSize * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_SIZE, BaobabCellRendererSize);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_SIZE_STATE_PROPERTY:
		baobab_cell_renderer_size_set_state (self, g_value_get_enum (value));
		break;
		case BAOBAB_CELL_RENDERER_SIZE_SIZE_PROPERTY:
		baobab_cell_renderer_size_set_size (self, g_value_get_uint64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
baobab_cell_renderer_items_get_instance_private (BaobabCellRendererItems* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabCellRendererItems_private_offset);
}

BaobabCellRendererItems*
baobab_cell_renderer_items_construct (GType object_type)
{
	BaobabCellRendererItems * self = NULL;
	self = (BaobabCellRendererItems*) baobab_cell_renderer_tabular_construct (object_type);
	return self;
}

BaobabCellRendererItems*
baobab_cell_renderer_items_new (void)
{
	return baobab_cell_renderer_items_construct (BAOBAB_TYPE_CELL_RENDERER_ITEMS);
}

BaobabScannerState
baobab_cell_renderer_items_get_state (BaobabCellRendererItems* self)
{
	BaobabScannerState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
baobab_cell_renderer_items_set_state (BaobabCellRendererItems* self,
                                      BaobabScannerState value)
{
	BaobabScannerState old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_cell_renderer_items_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, baobab_cell_renderer_items_properties[BAOBAB_CELL_RENDERER_ITEMS_STATE_PROPERTY]);
	}
}

void
baobab_cell_renderer_items_set_items (BaobabCellRendererItems* self,
                                      gint value)
{
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (value >= 0) {
		BaobabScannerState _tmp2_;
		_tmp2_ = self->priv->_state;
		_tmp1_ = _tmp2_ != BAOBAB_SCANNER_STATE_ERROR;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp3_;
		_tmp3_ = baobab_format_items (value);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	g_object_set ((GtkCellRendererText*) self, "text", _tmp0_, NULL);
	_g_free0 (_tmp0_);
	g_object_notify_by_pspec ((GObject *) self, baobab_cell_renderer_items_properties[BAOBAB_CELL_RENDERER_ITEMS_ITEMS_PROPERTY]);
}

static void
baobab_cell_renderer_items_class_init (BaobabCellRendererItemsClass * klass,
                                       gpointer klass_data)
{
	baobab_cell_renderer_items_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabCellRendererItems_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_cell_renderer_items_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_cell_renderer_items_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_cell_renderer_items_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_ITEMS_STATE_PROPERTY, baobab_cell_renderer_items_properties[BAOBAB_CELL_RENDERER_ITEMS_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", BAOBAB_SCANNER_TYPE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_ITEMS_ITEMS_PROPERTY, baobab_cell_renderer_items_properties[BAOBAB_CELL_RENDERER_ITEMS_ITEMS_PROPERTY] = g_param_spec_int ("items", "items", "items", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
baobab_cell_renderer_items_instance_init (BaobabCellRendererItems * self,
                                          gpointer klass)
{
	self->priv = baobab_cell_renderer_items_get_instance_private (self);
}

static void
baobab_cell_renderer_items_finalize (GObject * obj)
{
	BaobabCellRendererItems * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CELL_RENDERER_ITEMS, BaobabCellRendererItems);
	G_OBJECT_CLASS (baobab_cell_renderer_items_parent_class)->finalize (obj);
}

static GType
baobab_cell_renderer_items_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabCellRendererItemsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_cell_renderer_items_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabCellRendererItems), 0, (GInstanceInitFunc) baobab_cell_renderer_items_instance_init, NULL };
	GType baobab_cell_renderer_items_type_id;
	baobab_cell_renderer_items_type_id = g_type_register_static (BAOBAB_TYPE_CELL_RENDERER_TABULAR, "BaobabCellRendererItems", &g_define_type_info, 0);
	BaobabCellRendererItems_private_offset = g_type_add_instance_private (baobab_cell_renderer_items_type_id, sizeof (BaobabCellRendererItemsPrivate));
	return baobab_cell_renderer_items_type_id;
}

GType
baobab_cell_renderer_items_get_type (void)
{
	static volatile gsize baobab_cell_renderer_items_type_id__once = 0;
	if (g_once_init_enter (&baobab_cell_renderer_items_type_id__once)) {
		GType baobab_cell_renderer_items_type_id;
		baobab_cell_renderer_items_type_id = baobab_cell_renderer_items_get_type_once ();
		g_once_init_leave (&baobab_cell_renderer_items_type_id__once, baobab_cell_renderer_items_type_id);
	}
	return baobab_cell_renderer_items_type_id__once;
}

static void
_vala_baobab_cell_renderer_items_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	BaobabCellRendererItems * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_ITEMS, BaobabCellRendererItems);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_ITEMS_STATE_PROPERTY:
		g_value_set_enum (value, baobab_cell_renderer_items_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_baobab_cell_renderer_items_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	BaobabCellRendererItems * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_ITEMS, BaobabCellRendererItems);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_ITEMS_STATE_PROPERTY:
		baobab_cell_renderer_items_set_state (self, g_value_get_enum (value));
		break;
		case BAOBAB_CELL_RENDERER_ITEMS_ITEMS_PROPERTY:
		baobab_cell_renderer_items_set_items (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

BaobabCellRendererTime*
baobab_cell_renderer_time_construct (GType object_type)
{
	BaobabCellRendererTime * self = NULL;
	self = (BaobabCellRendererTime*) g_object_new (object_type, NULL);
	return self;
}

BaobabCellRendererTime*
baobab_cell_renderer_time_new (void)
{
	return baobab_cell_renderer_time_construct (BAOBAB_TYPE_CELL_RENDERER_TIME);
}

void
baobab_cell_renderer_time_set_time (BaobabCellRendererTime* self,
                                    guint64 value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_format_time_approximate (value);
	_tmp1_ = _tmp0_;
	g_object_set ((GtkCellRendererText*) self, "text", _tmp1_, NULL);
	_g_free0 (_tmp1_);
	g_object_notify_by_pspec ((GObject *) self, baobab_cell_renderer_time_properties[BAOBAB_CELL_RENDERER_TIME_TIME_PROPERTY]);
}

static void
baobab_cell_renderer_time_class_init (BaobabCellRendererTimeClass * klass,
                                      gpointer klass_data)
{
	baobab_cell_renderer_time_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_cell_renderer_time_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CELL_RENDERER_TIME_TIME_PROPERTY, baobab_cell_renderer_time_properties[BAOBAB_CELL_RENDERER_TIME_TIME_PROPERTY] = g_param_spec_uint64 ("time", "time", "time", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
baobab_cell_renderer_time_instance_init (BaobabCellRendererTime * self,
                                         gpointer klass)
{
}

static GType
baobab_cell_renderer_time_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabCellRendererTimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_cell_renderer_time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabCellRendererTime), 0, (GInstanceInitFunc) baobab_cell_renderer_time_instance_init, NULL };
	GType baobab_cell_renderer_time_type_id;
	baobab_cell_renderer_time_type_id = g_type_register_static (gtk_cell_renderer_text_get_type (), "BaobabCellRendererTime", &g_define_type_info, 0);
	return baobab_cell_renderer_time_type_id;
}

GType
baobab_cell_renderer_time_get_type (void)
{
	static volatile gsize baobab_cell_renderer_time_type_id__once = 0;
	if (g_once_init_enter (&baobab_cell_renderer_time_type_id__once)) {
		GType baobab_cell_renderer_time_type_id;
		baobab_cell_renderer_time_type_id = baobab_cell_renderer_time_get_type_once ();
		g_once_init_leave (&baobab_cell_renderer_time_type_id__once, baobab_cell_renderer_time_type_id);
	}
	return baobab_cell_renderer_time_type_id__once;
}

static void
_vala_baobab_cell_renderer_time_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	BaobabCellRendererTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CELL_RENDERER_TIME, BaobabCellRendererTime);
	switch (property_id) {
		case BAOBAB_CELL_RENDERER_TIME_TIME_PROPERTY:
		baobab_cell_renderer_time_set_time (self, g_value_get_uint64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

