"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildAreaStyles = void 0;
var color_library_wrappers_1 = require("../../../../../common/color_library_wrappers");
var common_1 = require("../../../../../utils/common");
var texture_1 = require("../../../utils/texture");
function buildAreaStyles(ctx, imgCanvas, baseColor, themeAreaStyle, geometryStateStyle) {
    var fillOpacity = function (opacity, seriesOpacity) {
        if (seriesOpacity === void 0) { seriesOpacity = themeAreaStyle.opacity; }
        return opacity * seriesOpacity * geometryStateStyle.opacity;
    };
    var texture = texture_1.getTextureStyles(ctx, imgCanvas, baseColor, fillOpacity, themeAreaStyle.texture);
    var color = color_library_wrappers_1.stringToRGB(common_1.getColorFromVariant(baseColor, themeAreaStyle.fill), fillOpacity);
    return {
        color: color,
        texture: texture,
    };
}
exports.buildAreaStyles = buildAreaStyles;
//# sourceMappingURL=area.js.map