"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AggConfigOptions", {
  enumerable: true,
  get: function () {
    return _common.AggConfigOptions;
  }
});
Object.defineProperty(exports, "AggGroupLabels", {
  enumerable: true,
  get: function () {
    return _common.AggGroupLabels;
  }
});
Object.defineProperty(exports, "AggGroupName", {
  enumerable: true,
  get: function () {
    return _common.AggGroupName;
  }
});
Object.defineProperty(exports, "AggGroupNames", {
  enumerable: true,
  get: function () {
    return _common.AggGroupNames;
  }
});
Object.defineProperty(exports, "AggParam", {
  enumerable: true,
  get: function () {
    return _common.AggParam;
  }
});
Object.defineProperty(exports, "AggParamOption", {
  enumerable: true,
  get: function () {
    return _common.AggParamOption;
  }
});
Object.defineProperty(exports, "AggParamType", {
  enumerable: true,
  get: function () {
    return _common.AggParamType;
  }
});
Object.defineProperty(exports, "BUCKET_TYPES", {
  enumerable: true,
  get: function () {
    return _common.BUCKET_TYPES;
  }
});
Object.defineProperty(exports, "FieldDescriptor", {
  enumerable: true,
  get: function () {
    return _index_patterns.FieldDescriptor;
  }
});
Object.defineProperty(exports, "FieldFormatConfig", {
  enumerable: true,
  get: function () {
    return _common.FieldFormatConfig;
  }
});
Object.defineProperty(exports, "FieldFormatsGetConfigFn", {
  enumerable: true,
  get: function () {
    return _common.FieldFormatsGetConfigFn;
  }
});
Object.defineProperty(exports, "Filter", {
  enumerable: true,
  get: function () {
    return _common.Filter;
  }
});
Object.defineProperty(exports, "IAggConfig", {
  enumerable: true,
  get: function () {
    return _common.IAggConfig;
  }
});
Object.defineProperty(exports, "IAggConfigs", {
  enumerable: true,
  get: function () {
    return _common.IAggConfigs;
  }
});
Object.defineProperty(exports, "IAggType", {
  enumerable: true,
  get: function () {
    return _common.IAggType;
  }
});
Object.defineProperty(exports, "IFieldFormatsRegistry", {
  enumerable: true,
  get: function () {
    return _common.IFieldFormatsRegistry;
  }
});
Object.defineProperty(exports, "IFieldParamType", {
  enumerable: true,
  get: function () {
    return _common.IFieldParamType;
  }
});
Object.defineProperty(exports, "IFieldSubType", {
  enumerable: true,
  get: function () {
    return _common.IFieldSubType;
  }
});
Object.defineProperty(exports, "IFieldType", {
  enumerable: true,
  get: function () {
    return _common.IFieldType;
  }
});
Object.defineProperty(exports, "IMetricAggType", {
  enumerable: true,
  get: function () {
    return _common.IMetricAggType;
  }
});
Object.defineProperty(exports, "IOpenSearchSearchRequest", {
  enumerable: true,
  get: function () {
    return _common.IOpenSearchSearchRequest;
  }
});
Object.defineProperty(exports, "IOpenSearchSearchResponse", {
  enumerable: true,
  get: function () {
    return _common.IOpenSearchSearchResponse;
  }
});
Object.defineProperty(exports, "ISearchOptions", {
  enumerable: true,
  get: function () {
    return _common.ISearchOptions;
  }
});
Object.defineProperty(exports, "ISearchSetup", {
  enumerable: true,
  get: function () {
    return _search.ISearchSetup;
  }
});
Object.defineProperty(exports, "ISearchStart", {
  enumerable: true,
  get: function () {
    return _search.ISearchStart;
  }
});
Object.defineProperty(exports, "ISearchStrategy", {
  enumerable: true,
  get: function () {
    return _search.ISearchStrategy;
  }
});
Object.defineProperty(exports, "IndexPattern", {
  enumerable: true,
  get: function () {
    return _common.IndexPattern;
  }
});
Object.defineProperty(exports, "IndexPatternAttributes", {
  enumerable: true,
  get: function () {
    return _common.IndexPatternAttributes;
  }
});
Object.defineProperty(exports, "IndexPatternFieldDescriptor", {
  enumerable: true,
  get: function () {
    return _index_patterns.FieldDescriptor;
  }
});
Object.defineProperty(exports, "IndexPatternsFetcher", {
  enumerable: true,
  get: function () {
    return _index_patterns.IndexPatternsFetcher;
  }
});
Object.defineProperty(exports, "KueryNode", {
  enumerable: true,
  get: function () {
    return _common.KueryNode;
  }
});
Object.defineProperty(exports, "METRIC_TYPES", {
  enumerable: true,
  get: function () {
    return _common.METRIC_TYPES;
  }
});
Object.defineProperty(exports, "OPENSEARCH_FIELD_TYPES", {
  enumerable: true,
  get: function () {
    return _common.OPENSEARCH_FIELD_TYPES;
  }
});
Object.defineProperty(exports, "OPENSEARCH_SEARCH_STRATEGY", {
  enumerable: true,
  get: function () {
    return _common.OPENSEARCH_SEARCH_STRATEGY;
  }
});
Object.defineProperty(exports, "OSD_FIELD_TYPES", {
  enumerable: true,
  get: function () {
    return _common.OSD_FIELD_TYPES;
  }
});
Object.defineProperty(exports, "OpenSearchQueryConfig", {
  enumerable: true,
  get: function () {
    return _common.OpenSearchQueryConfig;
  }
});
Object.defineProperty(exports, "OpenSearchaggsExpressionFunctionDefinition", {
  enumerable: true,
  get: function () {
    return _common.OpenSearchaggsExpressionFunctionDefinition;
  }
});
Object.defineProperty(exports, "OptionedParamType", {
  enumerable: true,
  get: function () {
    return _common.OptionedParamType;
  }
});
Object.defineProperty(exports, "OptionedValueProp", {
  enumerable: true,
  get: function () {
    return _common.OptionedValueProp;
  }
});
Object.defineProperty(exports, "ParsedInterval", {
  enumerable: true,
  get: function () {
    return _common.ParsedInterval;
  }
});
Object.defineProperty(exports, "Plugin", {
  enumerable: true,
  get: function () {
    return _plugin.DataServerPlugin;
  }
});
Object.defineProperty(exports, "PluginSetup", {
  enumerable: true,
  get: function () {
    return _plugin.DataPluginSetup;
  }
});
Object.defineProperty(exports, "PluginStart", {
  enumerable: true,
  get: function () {
    return _plugin.DataPluginStart;
  }
});
Object.defineProperty(exports, "Query", {
  enumerable: true,
  get: function () {
    return _common.Query;
  }
});
Object.defineProperty(exports, "RefreshInterval", {
  enumerable: true,
  get: function () {
    return _common.RefreshInterval;
  }
});
Object.defineProperty(exports, "SearchUsage", {
  enumerable: true,
  get: function () {
    return _search.SearchUsage;
  }
});
Object.defineProperty(exports, "TabbedAggColumn", {
  enumerable: true,
  get: function () {
    return _common.TabbedAggColumn;
  }
});
Object.defineProperty(exports, "TabbedAggRow", {
  enumerable: true,
  get: function () {
    return _common.TabbedAggRow;
  }
});
Object.defineProperty(exports, "TabbedTable", {
  enumerable: true,
  get: function () {
    return _common.TabbedTable;
  }
});
Object.defineProperty(exports, "TimeRange", {
  enumerable: true,
  get: function () {
    return _common.TimeRange;
  }
});
Object.defineProperty(exports, "UI_SETTINGS", {
  enumerable: true,
  get: function () {
    return _common.UI_SETTINGS;
  }
});
Object.defineProperty(exports, "castOpenSearchToOsdFieldTypeName", {
  enumerable: true,
  get: function () {
    return _common.castOpenSearchToOsdFieldTypeName;
  }
});
exports.fieldFormats = exports.config = void 0;
Object.defineProperty(exports, "getAsyncOptions", {
  enumerable: true,
  get: function () {
    return _search.getAsyncOptions;
  }
});
Object.defineProperty(exports, "getDefaultSearchParams", {
  enumerable: true,
  get: function () {
    return _search.getDefaultSearchParams;
  }
});
Object.defineProperty(exports, "getShardTimeout", {
  enumerable: true,
  get: function () {
    return _search.getShardTimeout;
  }
});
Object.defineProperty(exports, "getTime", {
  enumerable: true,
  get: function () {
    return _common.getTime;
  }
});
Object.defineProperty(exports, "getTotalLoaded", {
  enumerable: true,
  get: function () {
    return _search.getTotalLoaded;
  }
});
exports.opensearchQuery = exports.opensearchKuery = exports.opensearchFilters = exports.indexPatterns = void 0;
Object.defineProperty(exports, "parseInterval", {
  enumerable: true,
  get: function () {
    return _common.parseInterval;
  }
});
exports.plugin = plugin;
exports.search = void 0;
Object.defineProperty(exports, "shimAbortSignal", {
  enumerable: true,
  get: function () {
    return _search.shimAbortSignal;
  }
});
Object.defineProperty(exports, "shimHitsTotal", {
  enumerable: true,
  get: function () {
    return _search.shimHitsTotal;
  }
});
Object.defineProperty(exports, "shouldReadFieldFromDocValues", {
  enumerable: true,
  get: function () {
    return _index_patterns.shouldReadFieldFromDocValues;
  }
});
Object.defineProperty(exports, "toSnakeCase", {
  enumerable: true,
  get: function () {
    return _search.toSnakeCase;
  }
});
Object.defineProperty(exports, "usageProvider", {
  enumerable: true,
  get: function () {
    return _search.usageProvider;
  }
});

var _config = require("../config");

var _plugin = require("./plugin");

var _common = require("../common");

var _field_formats = require("../common/field_formats");

var _index_patterns = require("./index_patterns");

var _search = require("./search");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Filter helper namespace:
 */
const opensearchFilters = {
  buildQueryFilter: _common.buildQueryFilter,
  buildCustomFilter: _common.buildCustomFilter,
  buildEmptyFilter: _common.buildEmptyFilter,
  buildExistsFilter: _common.buildExistsFilter,
  buildFilter: _common.buildFilter,
  buildPhraseFilter: _common.buildPhraseFilter,
  buildPhrasesFilter: _common.buildPhrasesFilter,
  buildRangeFilter: _common.buildRangeFilter,
  isFilterDisabled: _common.isFilterDisabled
};
/*
 * opensearchQuery and opensearchKuery:
 */

exports.opensearchFilters = opensearchFilters;
const opensearchKuery = {
  nodeTypes: _common.nodeTypes,
  fromKueryExpression: _common.fromKueryExpression,
  toOpenSearchQuery: _common.toOpenSearchQuery
};
exports.opensearchKuery = opensearchKuery;
const opensearchQuery = {
  buildQueryFromFilters: _common.buildQueryFromFilters,
  getOpenSearchQueryConfig: _common.getOpenSearchQueryConfig,
  buildOpenSearchQuery: _common.buildOpenSearchQuery
};
exports.opensearchQuery = opensearchQuery;
const fieldFormats = {
  FieldFormatsRegistry: _field_formats.FieldFormatsRegistry,
  FieldFormat: _field_formats.FieldFormat,
  BoolFormat: _field_formats.BoolFormat,
  BytesFormat: _field_formats.BytesFormat,
  ColorFormat: _field_formats.ColorFormat,
  DurationFormat: _field_formats.DurationFormat,
  IpFormat: _field_formats.IpFormat,
  NumberFormat: _field_formats.NumberFormat,
  PercentFormat: _field_formats.PercentFormat,
  RelativeDateFormat: _field_formats.RelativeDateFormat,
  SourceFormat: _field_formats.SourceFormat,
  StaticLookupFormat: _field_formats.StaticLookupFormat,
  UrlFormat: _field_formats.UrlFormat,
  StringFormat: _field_formats.StringFormat,
  TruncateFormat: _field_formats.TruncateFormat
};
exports.fieldFormats = fieldFormats;
const indexPatterns = {
  isFilterable: _common.isFilterable,
  isNestedField: _common.isNestedField
};
exports.indexPatterns = indexPatterns;
// Search namespace
const search = {
  aggs: {
    CidrMask: _common.CidrMask,
    dateHistogramInterval: _common.dateHistogramInterval,
    intervalOptions: _common.intervalOptions,
    InvalidOpenSearchCalendarIntervalError: _common.InvalidOpenSearchCalendarIntervalError,
    InvalidOpenSearchIntervalFormatError: _common.InvalidOpenSearchIntervalFormatError,
    Ipv4Address: _common.Ipv4Address,
    isNumberType: _common.isNumberType,
    isStringType: _common.isStringType,
    isType: _common.isType,
    isValidOpenSearchInterval: _common.isValidOpenSearchInterval,
    isValidInterval: _common.isValidInterval,
    parentPipelineType: _common.parentPipelineType,
    parseOpenSearchInterval: _common.parseOpenSearchInterval,
    parseInterval: _common.parseInterval,
    propFilter: _common.propFilter,
    siblingPipelineType: _common.siblingPipelineType,
    termsAggFilter: _common.termsAggFilter,
    toAbsoluteDates: _common.toAbsoluteDates
  },
  getRequestInspectorStats: _common.getRequestInspectorStats,
  getResponseInspectorStats: _common.getResponseInspectorStats,
  tabifyAggResponse: _common.tabifyAggResponse,
  tabifyGetColumns: _common.tabifyGetColumns
};
/**
 * Types to be shared externally
 * @public
 */

exports.search = search;

/**
 * Static code to be shared externally
 * @public
 */
function plugin(initializerContext) {
  return new _plugin.DataServerPlugin(initializerContext);
}

const config = {
  exposeToBrowser: {
    autocomplete: true,
    search: true
  },
  schema: _config.configSchema
};
exports.config = config;