"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callTokenEndpoint = callTokenEndpoint;
exports.composeLogoutUrl = composeLogoutUrl;
exports.getBaseRedirectUrl = getBaseRedirectUrl;
exports.parseTokenResponse = parseTokenResponse;

var _querystring = require("querystring");

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */
function parseTokenResponse(payload) {
  const payloadString = payload.toString();

  if (payloadString.trim()[0] === '{') {
    try {
      return JSON.parse(payloadString);
    } catch (error) {
      throw Error(`Invalid JSON payload: ${error}`);
    }
  }

  return (0, _querystring.parse)(payloadString);
}

function getBaseRedirectUrl(config, core) {
  var _config$openid;

  if ((_config$openid = config.openid) !== null && _config$openid !== void 0 && _config$openid.base_redirect_url) {
    const baseRedirectUrl = config.openid.base_redirect_url;
    return baseRedirectUrl.endsWith('/') ? baseRedirectUrl.slice(0, -1) : baseRedirectUrl;
  }

  const host = core.http.getServerInfo().hostname;
  const port = core.http.getServerInfo().port;
  const protocol = core.http.getServerInfo().protocol;

  if (core.http.basePath.serverBasePath) {
    return `${protocol}://${host}:${port}${core.http.basePath.serverBasePath}`;
  }

  return `${protocol}://${host}:${port}`;
}

async function callTokenEndpoint(tokenEndpoint, query, wreckClient) {
  var _tokenResponse$res;

  const tokenResponse = await wreckClient.post(tokenEndpoint, {
    payload: (0, _querystring.stringify)(query),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    }
  });

  if (!((_tokenResponse$res = tokenResponse.res) !== null && _tokenResponse$res !== void 0 && _tokenResponse$res.statusCode) || tokenResponse.res.statusCode < 200 || tokenResponse.res.statusCode > 299) {
    throw new Error(`Failed calling token endpoint: ${tokenResponse.res.statusCode} ${tokenResponse.res.statusMessage}`);
  }

  const tokenPayload = parseTokenResponse(tokenResponse.payload);
  return {
    idToken: tokenPayload.id_token,
    accessToken: tokenPayload.access_token,
    refreshToken: tokenPayload.refresh_token,
    expiresIn: tokenPayload.expires_in
  };
}

function composeLogoutUrl(customLogoutUrl, idpEndsessionEndpoint, additionalQueryParams) {
  const logoutEndpont = customLogoutUrl || idpEndsessionEndpoint;
  const logoutUrl = new URL(logoutEndpont);
  Object.keys(additionalQueryParams).forEach(key => {
    logoutUrl.searchParams.append(key, additionalQueryParams[key]);
  });
  return logoutUrl.toString();
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImhlbHBlci50cyJdLCJuYW1lcyI6WyJwYXJzZVRva2VuUmVzcG9uc2UiLCJwYXlsb2FkIiwicGF5bG9hZFN0cmluZyIsInRvU3RyaW5nIiwidHJpbSIsIkpTT04iLCJwYXJzZSIsImVycm9yIiwiRXJyb3IiLCJnZXRCYXNlUmVkaXJlY3RVcmwiLCJjb25maWciLCJjb3JlIiwib3BlbmlkIiwiYmFzZV9yZWRpcmVjdF91cmwiLCJiYXNlUmVkaXJlY3RVcmwiLCJlbmRzV2l0aCIsInNsaWNlIiwiaG9zdCIsImh0dHAiLCJnZXRTZXJ2ZXJJbmZvIiwiaG9zdG5hbWUiLCJwb3J0IiwicHJvdG9jb2wiLCJiYXNlUGF0aCIsInNlcnZlckJhc2VQYXRoIiwiY2FsbFRva2VuRW5kcG9pbnQiLCJ0b2tlbkVuZHBvaW50IiwicXVlcnkiLCJ3cmVja0NsaWVudCIsInRva2VuUmVzcG9uc2UiLCJwb3N0IiwiaGVhZGVycyIsInJlcyIsInN0YXR1c0NvZGUiLCJzdGF0dXNNZXNzYWdlIiwidG9rZW5QYXlsb2FkIiwiaWRUb2tlbiIsImlkX3Rva2VuIiwiYWNjZXNzVG9rZW4iLCJhY2Nlc3NfdG9rZW4iLCJyZWZyZXNoVG9rZW4iLCJyZWZyZXNoX3Rva2VuIiwiZXhwaXJlc0luIiwiZXhwaXJlc19pbiIsImNvbXBvc2VMb2dvdXRVcmwiLCJjdXN0b21Mb2dvdXRVcmwiLCJpZHBFbmRzZXNzaW9uRW5kcG9pbnQiLCJhZGRpdGlvbmFsUXVlcnlQYXJhbXMiLCJsb2dvdXRFbmRwb250IiwibG9nb3V0VXJsIiwiVVJMIiwiT2JqZWN0Iiwia2V5cyIsImZvckVhY2giLCJrZXkiLCJzZWFyY2hQYXJhbXMiLCJhcHBlbmQiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFnQkE7O0FBaEJBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFPTyxTQUFTQSxrQkFBVCxDQUE0QkMsT0FBNUIsRUFBNkM7QUFDbEQsUUFBTUMsYUFBYSxHQUFHRCxPQUFPLENBQUNFLFFBQVIsRUFBdEI7O0FBQ0EsTUFBSUQsYUFBYSxDQUFDRSxJQUFkLEdBQXFCLENBQXJCLE1BQTRCLEdBQWhDLEVBQXFDO0FBQ25DLFFBQUk7QUFDRixhQUFPQyxJQUFJLENBQUNDLEtBQUwsQ0FBV0osYUFBWCxDQUFQO0FBQ0QsS0FGRCxDQUVFLE9BQU9LLEtBQVAsRUFBYztBQUNkLFlBQU1DLEtBQUssQ0FBRSx5QkFBd0JELEtBQU0sRUFBaEMsQ0FBWDtBQUNEO0FBQ0Y7O0FBQ0QsU0FBTyx3QkFBTUwsYUFBTixDQUFQO0FBQ0Q7O0FBRU0sU0FBU08sa0JBQVQsQ0FBNEJDLE1BQTVCLEVBQThEQyxJQUE5RCxFQUF1RjtBQUFBOztBQUM1Rix3QkFBSUQsTUFBTSxDQUFDRSxNQUFYLDJDQUFJLGVBQWVDLGlCQUFuQixFQUFzQztBQUNwQyxVQUFNQyxlQUFlLEdBQUdKLE1BQU0sQ0FBQ0UsTUFBUCxDQUFjQyxpQkFBdEM7QUFDQSxXQUFPQyxlQUFlLENBQUNDLFFBQWhCLENBQXlCLEdBQXpCLElBQWdDRCxlQUFlLENBQUNFLEtBQWhCLENBQXNCLENBQXRCLEVBQXlCLENBQUMsQ0FBMUIsQ0FBaEMsR0FBK0RGLGVBQXRFO0FBQ0Q7O0FBRUQsUUFBTUcsSUFBSSxHQUFHTixJQUFJLENBQUNPLElBQUwsQ0FBVUMsYUFBVixHQUEwQkMsUUFBdkM7QUFDQSxRQUFNQyxJQUFJLEdBQUdWLElBQUksQ0FBQ08sSUFBTCxDQUFVQyxhQUFWLEdBQTBCRSxJQUF2QztBQUNBLFFBQU1DLFFBQVEsR0FBR1gsSUFBSSxDQUFDTyxJQUFMLENBQVVDLGFBQVYsR0FBMEJHLFFBQTNDOztBQUNBLE1BQUlYLElBQUksQ0FBQ08sSUFBTCxDQUFVSyxRQUFWLENBQW1CQyxjQUF2QixFQUF1QztBQUNyQyxXQUFRLEdBQUVGLFFBQVMsTUFBS0wsSUFBSyxJQUFHSSxJQUFLLEdBQUVWLElBQUksQ0FBQ08sSUFBTCxDQUFVSyxRQUFWLENBQW1CQyxjQUFlLEVBQXpFO0FBQ0Q7O0FBQ0QsU0FBUSxHQUFFRixRQUFTLE1BQUtMLElBQUssSUFBR0ksSUFBSyxFQUFyQztBQUNEOztBQUVNLGVBQWVJLGlCQUFmLENBQ0xDLGFBREssRUFFTEMsS0FGSyxFQUdMQyxXQUhLLEVBSW1CO0FBQUE7O0FBQ3hCLFFBQU1DLGFBQWEsR0FBRyxNQUFNRCxXQUFXLENBQUNFLElBQVosQ0FBaUJKLGFBQWpCLEVBQWdDO0FBQzFEekIsSUFBQUEsT0FBTyxFQUFFLDRCQUFVMEIsS0FBVixDQURpRDtBQUUxREksSUFBQUEsT0FBTyxFQUFFO0FBQ1Asc0JBQWdCO0FBRFQ7QUFGaUQsR0FBaEMsQ0FBNUI7O0FBTUEsTUFDRSx3QkFBQ0YsYUFBYSxDQUFDRyxHQUFmLCtDQUFDLG1CQUFtQkMsVUFBcEIsS0FDQUosYUFBYSxDQUFDRyxHQUFkLENBQWtCQyxVQUFsQixHQUErQixHQUQvQixJQUVBSixhQUFhLENBQUNHLEdBQWQsQ0FBa0JDLFVBQWxCLEdBQStCLEdBSGpDLEVBSUU7QUFDQSxVQUFNLElBQUl6QixLQUFKLENBQ0gsa0NBQWlDcUIsYUFBYSxDQUFDRyxHQUFkLENBQWtCQyxVQUFXLElBQUdKLGFBQWEsQ0FBQ0csR0FBZCxDQUFrQkUsYUFBYyxFQUQ5RixDQUFOO0FBR0Q7O0FBQ0QsUUFBTUMsWUFBaUIsR0FBR25DLGtCQUFrQixDQUFDNkIsYUFBYSxDQUFDNUIsT0FBZixDQUE1QztBQUNBLFNBQU87QUFDTG1DLElBQUFBLE9BQU8sRUFBRUQsWUFBWSxDQUFDRSxRQURqQjtBQUVMQyxJQUFBQSxXQUFXLEVBQUVILFlBQVksQ0FBQ0ksWUFGckI7QUFHTEMsSUFBQUEsWUFBWSxFQUFFTCxZQUFZLENBQUNNLGFBSHRCO0FBSUxDLElBQUFBLFNBQVMsRUFBRVAsWUFBWSxDQUFDUTtBQUpuQixHQUFQO0FBTUQ7O0FBRU0sU0FBU0MsZ0JBQVQsQ0FDTEMsZUFESyxFQUVMQyxxQkFGSyxFQUdMQyxxQkFISyxFQUlMO0FBQ0EsUUFBTUMsYUFBYSxHQUFHSCxlQUFlLElBQUlDLHFCQUF6QztBQUNBLFFBQU1HLFNBQVMsR0FBRyxJQUFJQyxHQUFKLENBQVFGLGFBQVIsQ0FBbEI7QUFDQUcsRUFBQUEsTUFBTSxDQUFDQyxJQUFQLENBQVlMLHFCQUFaLEVBQW1DTSxPQUFuQyxDQUE0Q0MsR0FBRCxJQUFTO0FBQ2xETCxJQUFBQSxTQUFTLENBQUNNLFlBQVYsQ0FBdUJDLE1BQXZCLENBQThCRixHQUE5QixFQUFtQ1AscUJBQXFCLENBQUNPLEdBQUQsQ0FBeEQ7QUFDRCxHQUZEO0FBR0EsU0FBT0wsU0FBUyxDQUFDOUMsUUFBVixFQUFQO0FBQ0QiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogICBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqXG4gKiAgIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuXG4gKiAgIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiAqICAgQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiAgIG9yIGluIHRoZSBcImxpY2Vuc2VcIiBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZFxuICogICBvbiBhbiBcIkFTIElTXCIgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXJcbiAqICAgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmdcbiAqICAgcGVybWlzc2lvbnMgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCB3cmVjayBmcm9tICdAaGFwaS93cmVjayc7XG5pbXBvcnQgeyBwYXJzZSwgc3RyaW5naWZ5IH0gZnJvbSAncXVlcnlzdHJpbmcnO1xuaW1wb3J0IHsgQ29yZVNldHVwIH0gZnJvbSAnb3BlbnNlYXJjaC1kYXNoYm9hcmRzL3NlcnZlcic7XG5pbXBvcnQgeyBTZWN1cml0eVBsdWdpbkNvbmZpZ1R5cGUgfSBmcm9tICcuLi8uLi8uLic7XG5cbmV4cG9ydCBmdW5jdGlvbiBwYXJzZVRva2VuUmVzcG9uc2UocGF5bG9hZDogQnVmZmVyKSB7XG4gIGNvbnN0IHBheWxvYWRTdHJpbmcgPSBwYXlsb2FkLnRvU3RyaW5nKCk7XG4gIGlmIChwYXlsb2FkU3RyaW5nLnRyaW0oKVswXSA9PT0gJ3snKSB7XG4gICAgdHJ5IHtcbiAgICAgIHJldHVybiBKU09OLnBhcnNlKHBheWxvYWRTdHJpbmcpO1xuICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICB0aHJvdyBFcnJvcihgSW52YWxpZCBKU09OIHBheWxvYWQ6ICR7ZXJyb3J9YCk7XG4gICAgfVxuICB9XG4gIHJldHVybiBwYXJzZShwYXlsb2FkU3RyaW5nKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGdldEJhc2VSZWRpcmVjdFVybChjb25maWc6IFNlY3VyaXR5UGx1Z2luQ29uZmlnVHlwZSwgY29yZTogQ29yZVNldHVwKTogc3RyaW5nIHtcbiAgaWYgKGNvbmZpZy5vcGVuaWQ/LmJhc2VfcmVkaXJlY3RfdXJsKSB7XG4gICAgY29uc3QgYmFzZVJlZGlyZWN0VXJsID0gY29uZmlnLm9wZW5pZC5iYXNlX3JlZGlyZWN0X3VybDtcbiAgICByZXR1cm4gYmFzZVJlZGlyZWN0VXJsLmVuZHNXaXRoKCcvJykgPyBiYXNlUmVkaXJlY3RVcmwuc2xpY2UoMCwgLTEpIDogYmFzZVJlZGlyZWN0VXJsO1xuICB9XG5cbiAgY29uc3QgaG9zdCA9IGNvcmUuaHR0cC5nZXRTZXJ2ZXJJbmZvKCkuaG9zdG5hbWU7XG4gIGNvbnN0IHBvcnQgPSBjb3JlLmh0dHAuZ2V0U2VydmVySW5mbygpLnBvcnQ7XG4gIGNvbnN0IHByb3RvY29sID0gY29yZS5odHRwLmdldFNlcnZlckluZm8oKS5wcm90b2NvbDtcbiAgaWYgKGNvcmUuaHR0cC5iYXNlUGF0aC5zZXJ2ZXJCYXNlUGF0aCkge1xuICAgIHJldHVybiBgJHtwcm90b2NvbH06Ly8ke2hvc3R9OiR7cG9ydH0ke2NvcmUuaHR0cC5iYXNlUGF0aC5zZXJ2ZXJCYXNlUGF0aH1gO1xuICB9XG4gIHJldHVybiBgJHtwcm90b2NvbH06Ly8ke2hvc3R9OiR7cG9ydH1gO1xufVxuXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gY2FsbFRva2VuRW5kcG9pbnQoXG4gIHRva2VuRW5kcG9pbnQ6IHN0cmluZyxcbiAgcXVlcnk6IGFueSxcbiAgd3JlY2tDbGllbnQ6IHR5cGVvZiB3cmVja1xuKTogUHJvbWlzZTxUb2tlblJlc3BvbnNlPiB7XG4gIGNvbnN0IHRva2VuUmVzcG9uc2UgPSBhd2FpdCB3cmVja0NsaWVudC5wb3N0KHRva2VuRW5kcG9pbnQsIHtcbiAgICBwYXlsb2FkOiBzdHJpbmdpZnkocXVlcnkpLFxuICAgIGhlYWRlcnM6IHtcbiAgICAgICdDb250ZW50LVR5cGUnOiAnYXBwbGljYXRpb24veC13d3ctZm9ybS11cmxlbmNvZGVkJyxcbiAgICB9LFxuICB9KTtcbiAgaWYgKFxuICAgICF0b2tlblJlc3BvbnNlLnJlcz8uc3RhdHVzQ29kZSB8fFxuICAgIHRva2VuUmVzcG9uc2UucmVzLnN0YXR1c0NvZGUgPCAyMDAgfHxcbiAgICB0b2tlblJlc3BvbnNlLnJlcy5zdGF0dXNDb2RlID4gMjk5XG4gICkge1xuICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgIGBGYWlsZWQgY2FsbGluZyB0b2tlbiBlbmRwb2ludDogJHt0b2tlblJlc3BvbnNlLnJlcy5zdGF0dXNDb2RlfSAke3Rva2VuUmVzcG9uc2UucmVzLnN0YXR1c01lc3NhZ2V9YFxuICAgICk7XG4gIH1cbiAgY29uc3QgdG9rZW5QYXlsb2FkOiBhbnkgPSBwYXJzZVRva2VuUmVzcG9uc2UodG9rZW5SZXNwb25zZS5wYXlsb2FkIGFzIEJ1ZmZlcik7XG4gIHJldHVybiB7XG4gICAgaWRUb2tlbjogdG9rZW5QYXlsb2FkLmlkX3Rva2VuLFxuICAgIGFjY2Vzc1Rva2VuOiB0b2tlblBheWxvYWQuYWNjZXNzX3Rva2VuLFxuICAgIHJlZnJlc2hUb2tlbjogdG9rZW5QYXlsb2FkLnJlZnJlc2hfdG9rZW4sXG4gICAgZXhwaXJlc0luOiB0b2tlblBheWxvYWQuZXhwaXJlc19pbixcbiAgfTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGNvbXBvc2VMb2dvdXRVcmwoXG4gIGN1c3RvbUxvZ291dFVybDogc3RyaW5nIHwgdW5kZWZpbmVkLFxuICBpZHBFbmRzZXNzaW9uRW5kcG9pbnQ6IHN0cmluZyB8IHVuZGVmaW5lZCxcbiAgYWRkaXRpb25hbFF1ZXJ5UGFyYW1zOiBhbnlcbikge1xuICBjb25zdCBsb2dvdXRFbmRwb250ID0gY3VzdG9tTG9nb3V0VXJsIHx8IGlkcEVuZHNlc3Npb25FbmRwb2ludDtcbiAgY29uc3QgbG9nb3V0VXJsID0gbmV3IFVSTChsb2dvdXRFbmRwb250ISk7XG4gIE9iamVjdC5rZXlzKGFkZGl0aW9uYWxRdWVyeVBhcmFtcykuZm9yRWFjaCgoa2V5KSA9PiB7XG4gICAgbG9nb3V0VXJsLnNlYXJjaFBhcmFtcy5hcHBlbmQoa2V5LCBhZGRpdGlvbmFsUXVlcnlQYXJhbXNba2V5XSBhcyBzdHJpbmcpO1xuICB9KTtcbiAgcmV0dXJuIGxvZ291dFVybC50b1N0cmluZygpO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIFRva2VuUmVzcG9uc2Uge1xuICBpZFRva2VuPzogc3RyaW5nO1xuICBhY2Nlc3NUb2tlbj86IHN0cmluZztcbiAgcmVmcmVzaFRva2VuPzogc3RyaW5nO1xuICBleHBpcmVzSW4/OiBudW1iZXI7XG59XG4iXX0=