/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.r;

import java.util.Map;
import javax.swing.Icon;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RType;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleLocalObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectFieldNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectReferenceNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleOpenNodeActionProvider;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleTypeNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;

public class RNodes
extends TruffleOpenNodeActionProvider<RObject, RType, RHeapFragment, RLanguage> {
    public boolean supportsView(HeapContext context, String viewID) {
        return RHeapFragment.isRHeap(context);
    }

    @Override
    protected boolean supportsNode(HeapViewerNode node) {
        return node instanceof RNode;
    }

    @Override
    protected RLanguage getLanguage() {
        return RLanguage.instance();
    }

    static String getLogicalValue(RObject object, String type) {
        return DetailsSupport.getDetailsString((Instance)object.getInstance());
    }

    private static String computeObjectName(TruffleObjectNode.InstanceBased<RObject> node) {
        if ("com.oracle.truffle.r.runtime.data.RLogical".equals(node.getInstance().getJavaClass().getName())) {
            String valueString = node.getLogicalValue();
            return "logical#" + valueString.substring(1, valueString.length() - 1);
        }
        String typeString = node.getTypeName();
        return typeString.substring(typeString.lastIndexOf(46) + 1) + "#" + node.getInstance().getInstanceNumber();
    }

    private static RObjectNode createCopy(TruffleObjectNode.InstanceBased<RObject> node) {
        return new RObjectNode((RObject)node.getTruffleObject(), node.getTypeName());
    }

    public static class RNodesRendererProvider
    extends HeapViewerRenderer.Provider {
        public boolean supportsView(HeapContext context, String viewID) {
            return true;
        }

        public void registerRenderers(Map<Class<? extends HeapViewerNode>, HeapViewerRenderer> renderers, HeapContext context) {
            RLanguage language = RLanguage.instance();
            Icon instanceIcon = language.createLanguageIcon(Icons.getIcon((String)"LanguageIcons.Instance"));
            Icon packageIcon = language.createLanguageIcon(Icons.getIcon((String)"LanguageIcons.Package"));
            Heap heap = context.getFragment().getHeap();
            renderers.put(RObjectNode.class, new TruffleObjectNode.Renderer(heap, instanceIcon));
            renderers.put(RTypeNode.class, new TruffleTypeNode.Renderer(packageIcon));
            renderers.put(RObjectFieldNode.class, new TruffleObjectFieldNode.Renderer(heap, instanceIcon));
            renderers.put(RObjectReferenceNode.class, new TruffleObjectReferenceNode.Renderer(heap, instanceIcon));
            renderers.put(RObjectAttributeReferenceNode.class, new TruffleObjectReferenceNode.Renderer(heap, instanceIcon, "attribute in"));
        }
    }

    static class RObjectAttributeReferenceNode
    extends TruffleObjectReferenceNode.InstanceBased<RObject>
    implements RNode {
        RObjectAttributeReferenceNode(RObject object, String type, FieldValue value) {
            super(object, type, value);
        }

        @Override
        protected String computeObjectName() {
            return RNodes.computeObjectName(this);
        }

        @Override
        protected String computeLogicalValue(RObject object, String type) {
            String logicalValue = RNodes.getLogicalValue(object, type);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type);
        }

        @Override
        public RObjectNode createCopy() {
            return RNodes.createCopy(this);
        }
    }

    static class RObjectReferenceNode
    extends TruffleObjectReferenceNode.InstanceBased<RObject>
    implements RNode {
        RObjectReferenceNode(RObject object, String type, FieldValue value) {
            super(object, type, value);
        }

        @Override
        protected String computeObjectName() {
            return RNodes.computeObjectName(this);
        }

        @Override
        protected String computeLogicalValue(RObject object, String type) {
            String logicalValue = RNodes.getLogicalValue(object, type);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type);
        }

        @Override
        public RObjectNode createCopy() {
            return RNodes.createCopy(this);
        }
    }

    static class RObjectFieldNode
    extends TruffleObjectFieldNode.InstanceBased<RObject>
    implements RNode {
        RObjectFieldNode(RObject object, String type, FieldValue field) {
            super(object, type, field);
        }

        @Override
        protected String computeObjectName() {
            return RNodes.computeObjectName(this);
        }

        @Override
        protected String computeLogicalValue(RObject object, String type) {
            String logicalValue = RNodes.getLogicalValue(object, type);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type);
        }

        @Override
        public RObjectNode createCopy() {
            return RNodes.createCopy(this);
        }
    }

    static class RTypeNode
    extends TruffleTypeNode<RObject, RType>
    implements RNode {
        RTypeNode(RType type) {
            super(type);
        }

        @Override
        public HeapViewerNode createNode(RObject object) {
            String type = ((RType)this.getType()).getName();
            return new RObjectNode(object, type);
        }

        @Override
        public TruffleTypeNode createCopy() {
            RTypeNode copy = new RTypeNode((RType)this.getType());
            this.setupCopy(copy);
            return copy;
        }

        protected void setupCopy(RTypeNode copy) {
            super.setupCopy(copy);
        }
    }

    static class RLocalObjectNode
    extends TruffleLocalObjectNode.InstanceBased<RObject>
    implements RNode {
        RLocalObjectNode(RObject object, String type) {
            super(object, type);
        }

        @Override
        protected String computeObjectName() {
            return RNodes.computeObjectName(this);
        }

        @Override
        protected String computeLogicalValue(RObject object, String type) {
            String logicalValue = RNodes.getLogicalValue(object, type);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type);
        }

        @Override
        public RObjectNode createCopy() {
            return RNodes.createCopy(this);
        }
    }

    static class RObjectNode
    extends TruffleObjectNode.InstanceBased<RObject>
    implements RNode {
        RObjectNode(RObject robject) {
            this(robject, robject.getType());
        }

        RObjectNode(RObject robject, String type) {
            super(robject, type);
        }

        @Override
        protected String computeObjectName() {
            return RNodes.computeObjectName(this);
        }

        @Override
        protected String computeLogicalValue(RObject object, String type) {
            String logicalValue = RNodes.getLogicalValue(object, type);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type);
        }

        public RObjectNode createCopy() {
            RObjectNode copy = RNodes.createCopy(this);
            this.setupCopy(copy);
            return copy;
        }

        protected void setupCopy(RObjectNode copy) {
            super.setupCopy(copy);
        }
    }

    static interface RNode {
    }
}

