/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DocumentLine;
import org.openide.text.Line;
import org.openide.text.LineVector;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableOpenSupportRedirector;

final class EditorSupportLineSet
extends DocumentLine.Set {
    private CloneableEditorSupport support;

    public EditorSupportLineSet(CloneableEditorSupport cloneableEditorSupport, StyledDocument styledDocument) {
        super(styledDocument, cloneableEditorSupport);
        this.support = cloneableEditorSupport;
    }

    @Override
    LineVector findLineVector() {
        return this.support.findLineVector();
    }

    @Override
    public Line createLine(int n) {
        PositionRef positionRef = new PositionRef(this.support.getPositionManager(), n, Position.Bias.Forward);
        return new SupportLine(this.support.getLookup(), positionRef, this.support);
    }

    private static final class COSHack {
        private static final Method redirectMethod;

        private COSHack() {
        }

        private static CloneableEditorSupport getCloneableEditorSupport(PositionRef positionRef) {
            CloneableEditorSupport cloneableEditorSupport = positionRef.getCloneableEditorSupport();
            if (cloneableEditorSupport == null || redirectMethod == null) {
                return cloneableEditorSupport;
            }
            try {
                Object object = redirectMethod.invoke(null, new Object[]{cloneableEditorSupport});
                if (object instanceof CloneableEditorSupport) {
                    return (CloneableEditorSupport)((Object)object);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return cloneableEditorSupport;
        }

        static {
            Method method = null;
            try {
                method = CloneableOpenSupportRedirector.class.getDeclaredMethod("findRedirect", CloneableOpenSupport.class);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            finally {
                redirectMethod = method;
            }
        }
    }

    static class Closed
    extends Line.Set
    implements ChangeListener {
        private CloneableEditorSupport support;
        private Line.Set delegate;

        public Closed(CloneableEditorSupport cloneableEditorSupport) {
            this.support = cloneableEditorSupport;
            cloneableEditorSupport.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)((Object)cloneableEditorSupport)));
        }

        @Override
        LineVector findLineVector() {
            return this.support.findLineVector();
        }

        @Override
        public List<? extends Line> getLines() {
            if (this.delegate != null) {
                return this.delegate.getLines();
            }
            return new ArrayList();
        }

        @Override
        public Line getOriginal(int n) throws IndexOutOfBoundsException {
            if (this.delegate != null) {
                return this.delegate.getOriginal(n);
            }
            return this.getCurrent(n);
        }

        @Override
        public Line getCurrent(int n) throws IndexOutOfBoundsException {
            return this.findLineVector().findOrCreateLine(n, new SupportLineCreator());
        }

        @Override
        public synchronized void stateChanged(ChangeEvent changeEvent) {
            if (this.delegate == null) {
                StyledDocument styledDocument = this.support.getDocument();
                if (styledDocument != null) {
                    this.delegate = new EditorSupportLineSet(this.support, styledDocument);
                }
            } else if (this.support.getDocument() == null) {
                this.delegate = null;
            }
        }

        private final class SupportLineCreator
        implements LineVector.LineCreator {
            private SupportLineCreator() {
            }

            @Override
            public Line createLine(int n) {
                PositionRef positionRef = new PositionRef(Closed.this.support.getPositionManager(), n, 0, Position.Bias.Forward);
                Lookup lookup = Closed.this.support.getLookup();
                SupportLine supportLine = new SupportLine(lookup, positionRef, Closed.this.support);
                supportLine.init();
                return supportLine;
            }
        }
    }

    private static final class SupportLine
    extends DocumentLine {
        static final long serialVersionUID = 7282223299866986051L;

        public SupportLine(Lookup lookup, PositionRef positionRef, CloneableEditorSupport cloneableEditorSupport) {
            super(lookup, positionRef);
        }

        @Override
        @Deprecated
        public void show(int n, int n2) {
            CloneableEditorSupport.Pane pane;
            CloneableEditorSupport cloneableEditorSupport = SupportLine.getCloneableEditorSupport(this.pos);
            if (n == 0 && !cloneableEditorSupport.isDocumentLoaded()) {
                return;
            }
            if (n == 4 || n == 5) {
                pane = cloneableEditorSupport.openReuse(this.pos, n2, n);
            } else {
                pane = cloneableEditorSupport.openAt(this.pos, n2);
                if (n == 3) {
                    pane.getComponent().toFront();
                }
            }
            if (n != 0 && n != 1) {
                pane.getComponent().requestActive();
            }
        }

        @Override
        public void show(Line.ShowOpenType showOpenType, Line.ShowVisibilityType showVisibilityType, int n) {
            CloneableEditorSupport cloneableEditorSupport = SupportLine.getCloneableEditorSupport(this.pos);
            if (showOpenType == Line.ShowOpenType.NONE && !cloneableEditorSupport.isDocumentLoaded()) {
                return;
            }
            CloneableEditorSupport.Pane pane = null;
            if (showOpenType == Line.ShowOpenType.REUSE || showOpenType == Line.ShowOpenType.REUSE_NEW) {
                pane = cloneableEditorSupport.openReuse(this.pos, n, showOpenType);
            } else if (showOpenType == Line.ShowOpenType.OPEN || showOpenType == Line.ShowOpenType.NONE) {
                pane = cloneableEditorSupport.openAt(this.pos, n);
            }
            if (pane != null) {
                if (showVisibilityType == Line.ShowVisibilityType.FRONT) {
                    pane.getComponent().requestVisible();
                    pane.getComponent().toFront();
                } else if (showVisibilityType == Line.ShowVisibilityType.FOCUS) {
                    pane.getComponent().requestActive();
                }
            }
        }

        @Override
        public Line.Part createPart(int n, int n2) {
            DocumentLine.Part part = new DocumentLine.Part(this, new PositionRef(SupportLine.getCloneableEditorSupport(this.pos).getPositionManager(), this.pos.getOffset() + n, Position.Bias.Forward), n2);
            this.addLinePart(part);
            return part;
        }

        @Override
        public String getDisplayName() {
            CloneableEditorSupport cloneableEditorSupport = SupportLine.getCloneableEditorSupport(this.pos);
            return cloneableEditorSupport.messageLine(this);
        }

        public String toString() {
            return "SupportLine@" + Integer.toHexString(System.identityHashCode(this)) + " at line: " + this.getLineNumber();
        }

        private static CloneableEditorSupport getCloneableEditorSupport(PositionRef positionRef) {
            return COSHack.getCloneableEditorSupport(positionRef);
        }
    }
}

