/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELException;
import jakarta.el.JreCompat;
import jakarta.el.Util;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ImportHandler {
    private static final boolean IS_SECURITY_ENABLED = System.getSecurityManager() != null;
    private static final Map<String, Set<String>> standardPackages = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> packageNames = new ConcurrentHashMap<String, Set<String>>();
    private Map<String, String> classNames = new ConcurrentHashMap<String, String>();
    private Map<String, Class<?>> clazzes = new ConcurrentHashMap();
    private Map<String, Class<?>> statics = new ConcurrentHashMap();

    public ImportHandler() {
        this.importPackage("java.lang");
    }

    public void importStatic(String string) throws ELException {
        int n;
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            throw new ELException(Util.message(null, "importHandler.invalidStaticName", string));
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        Class<?> clazz = this.findClass(string2, true);
        if (clazz == null) {
            throw new ELException(Util.message(null, "importHandler.invalidClassNameForStatic", string2, string));
        }
        boolean bl = false;
        for (Field accessibleObject : clazz.getFields()) {
            if (!accessibleObject.getName().equals(string3) || !Modifier.isStatic(n = accessibleObject.getModifiers()) || !Modifier.isPublic(n)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (AccessibleObject accessibleObject : clazz.getMethods()) {
                if (!((Method)accessibleObject).getName().equals(string3) || !Modifier.isStatic(n = ((Method)accessibleObject).getModifiers()) || !Modifier.isPublic(n)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            throw new ELException(Util.message(null, "importHandler.staticNotFound", string3, string2, string));
        }
        Class<?> clazz2 = this.statics.get(string3);
        if (clazz2 != null) {
            throw new ELException(Util.message(null, "importHandler.ambiguousStaticImport", string, clazz2.getName() + '.' + string3));
        }
        this.statics.put(string3, clazz);
    }

    public void importClass(String string) throws ELException {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            throw new ELException(Util.message(null, "importHandler.invalidClassName", string));
        }
        String string2 = string.substring(n + 1);
        String string3 = this.classNames.putIfAbsent(string2, string);
        if (string3 != null && !string3.equals(string)) {
            throw new ELException(Util.message(null, "importHandler.ambiguousImport", string, string3));
        }
    }

    public void importPackage(String string) {
        Set<String> set = standardPackages.get(string);
        if (set == null) {
            this.packageNames.put(string, Collections.emptySet());
        } else {
            this.packageNames.put(string, set);
        }
    }

    public Class<?> resolveClass(String string) {
        Object object;
        if (string == null || string.contains(".")) {
            return null;
        }
        Class<?> clazz = this.clazzes.get(string);
        if (clazz != null) {
            if (NotFound.class.equals(clazz)) {
                return null;
            }
            return clazz;
        }
        String string2 = this.classNames.get(string);
        if (string2 != null && (object = this.findClass(string2, true)) != null) {
            this.clazzes.put(string, (Class<?>)object);
            return object;
        }
        for (Map.Entry entry : this.packageNames.entrySet()) {
            Class<?> clazz2;
            if (!((Set)entry.getValue()).isEmpty() && !((Set)entry.getValue()).contains(string) || (clazz2 = this.findClass(string2 = (String)entry.getKey() + '.' + string, false)) == null) continue;
            if (clazz != null) {
                throw new ELException(Util.message(null, "importHandler.ambiguousImport", string2, clazz.getName()));
            }
            clazz = clazz2;
        }
        if (clazz == null) {
            this.clazzes.put(string, NotFound.class);
        } else {
            this.clazzes.put(string, clazz);
        }
        return clazz;
    }

    public Class<?> resolveStatic(String string) {
        return this.statics.get(string);
    }

    private Class<?> findClass(String string, boolean bl) {
        Class<?> clazz;
        ClassLoader classLoader = Util.getContextClassLoader();
        String string2 = string.replace('.', '/') + ".class";
        try {
            if (IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedResourceExists(classLoader, string2)) == false : classLoader.getResource(string2) == null) {
                return null;
            }
        }
        catch (ClassCircularityError classCircularityError) {
            // empty catch block
        }
        try {
            clazz = classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        JreCompat jreCompat = JreCompat.getInstance();
        int n = clazz.getModifiers();
        if (!Modifier.isPublic(n) || Modifier.isAbstract(n) || Modifier.isInterface(n) || !jreCompat.isExported(clazz)) {
            if (bl) {
                throw new ELException(Util.message(null, "importHandler.invalidClass", string));
            }
            return null;
        }
        return clazz;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("AsyncContext");
        hashSet.add("AsyncListener");
        hashSet.add("Filter");
        hashSet.add("FilterChain");
        hashSet.add("FilterConfig");
        hashSet.add("FilterRegistration");
        hashSet.add("FilterRegistration.Dynamic");
        hashSet.add("ReadListener");
        hashSet.add("Registration");
        hashSet.add("Registration.Dynamic");
        hashSet.add("RequestDispatcher");
        hashSet.add("Servlet");
        hashSet.add("ServletConfig");
        hashSet.add("ServletContainerInitializer");
        hashSet.add("ServletContext");
        hashSet.add("ServletContextAttributeListener");
        hashSet.add("ServletContextListener");
        hashSet.add("ServletRegistration");
        hashSet.add("ServletRegistration.Dynamic");
        hashSet.add("ServletRequest");
        hashSet.add("ServletRequestAttributeListener");
        hashSet.add("ServletRequestListener");
        hashSet.add("ServletResponse");
        hashSet.add("SessionCookieConfig");
        hashSet.add("SingleThreadModel");
        hashSet.add("WriteListener");
        hashSet.add("AsyncEvent");
        hashSet.add("GenericFilter");
        hashSet.add("GenericServlet");
        hashSet.add("HttpConstraintElement");
        hashSet.add("HttpMethodConstraintElement");
        hashSet.add("MultipartConfigElement");
        hashSet.add("ServletContextAttributeEvent");
        hashSet.add("ServletContextEvent");
        hashSet.add("ServletInputStream");
        hashSet.add("ServletOutputStream");
        hashSet.add("ServletRequestAttributeEvent");
        hashSet.add("ServletRequestEvent");
        hashSet.add("ServletRequestWrapper");
        hashSet.add("ServletResponseWrapper");
        hashSet.add("ServletSecurityElement");
        hashSet.add("DispatcherType");
        hashSet.add("SessionTrackingMode");
        hashSet.add("ServletException");
        hashSet.add("UnavailableException");
        standardPackages.put("jakarta.servlet", hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("HttpServletMapping");
        hashSet2.add("HttpServletRequest");
        hashSet2.add("HttpServletResponse");
        hashSet2.add("HttpSession");
        hashSet2.add("HttpSessionActivationListener");
        hashSet2.add("HttpSessionAttributeListener");
        hashSet2.add("HttpSessionBindingListener");
        hashSet2.add("HttpSessionContext");
        hashSet2.add("HttpSessionIdListener");
        hashSet2.add("HttpSessionListener");
        hashSet2.add("HttpUpgradeHandler");
        hashSet2.add("Part");
        hashSet2.add("PushBuilder");
        hashSet2.add("WebConnection");
        hashSet2.add("Cookie");
        hashSet2.add("HttpFilter");
        hashSet2.add("HttpServlet");
        hashSet2.add("HttpServletRequestWrapper");
        hashSet2.add("HttpServletResponseWrapper");
        hashSet2.add("HttpSessionBindingEvent");
        hashSet2.add("HttpSessionEvent");
        hashSet2.add("HttpUtils");
        hashSet2.add("MappingMatch");
        standardPackages.put("jakarta.servlet.http", hashSet2);
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.add("HttpJspPage");
        hashSet3.add("JspApplicationContext");
        hashSet3.add("JspPage");
        hashSet3.add("ErrorData");
        hashSet3.add("JspContext");
        hashSet3.add("JspEngineInfo");
        hashSet3.add("JspFactory");
        hashSet3.add("JspWriter");
        hashSet3.add("PageContext");
        hashSet3.add("Exceptions");
        hashSet3.add("JspException");
        hashSet3.add("JspTagException");
        hashSet3.add("SkipPageException");
        standardPackages.put("jakarta.servlet.jsp", hashSet3);
        HashSet<String> hashSet4 = new HashSet<String>();
        hashSet4.add("Appendable");
        hashSet4.add("AutoCloseable");
        hashSet4.add("CharSequence");
        hashSet4.add("Cloneable");
        hashSet4.add("Comparable");
        hashSet4.add("Iterable");
        hashSet4.add("ProcessHandle");
        hashSet4.add("ProcessHandle.Info");
        hashSet4.add("Readable");
        hashSet4.add("Runnable");
        hashSet4.add("StackWalker.StackFrame");
        hashSet4.add("System.Logger");
        hashSet4.add("Thread.Builder");
        hashSet4.add("Thread.Builder.OfPlatform");
        hashSet4.add("Thread.Builder.OfVirtual");
        hashSet4.add("Thread.UncaughtExceptionHandler");
        hashSet4.add("Boolean");
        hashSet4.add("Byte");
        hashSet4.add("Character");
        hashSet4.add("Character.Subset");
        hashSet4.add("Character.UnicodeBlock");
        hashSet4.add("Class");
        hashSet4.add("ClassLoader");
        hashSet4.add("ClassValue");
        hashSet4.add("Compiler");
        hashSet4.add("Double");
        hashSet4.add("Enum");
        hashSet4.add("Enum.EnumDesc");
        hashSet4.add("Float");
        hashSet4.add("InheritableThreadLocal");
        hashSet4.add("Integer");
        hashSet4.add("Long");
        hashSet4.add("Math");
        hashSet4.add("Module");
        hashSet4.add("ModuleLayer");
        hashSet4.add("ModuleLayer.Controller");
        hashSet4.add("Number");
        hashSet4.add("Object");
        hashSet4.add("Package");
        hashSet4.add("Process");
        hashSet4.add("ProcessBuilder");
        hashSet4.add("ProcessBuilder.Redirect");
        hashSet4.add("Record");
        hashSet4.add("Runtime");
        hashSet4.add("Runtime.Version");
        hashSet4.add("RuntimePermission");
        hashSet4.add("SecurityManager");
        hashSet4.add("Short");
        hashSet4.add("StackTraceElement");
        hashSet4.add("StackWalker");
        hashSet4.add("StrictMath");
        hashSet4.add("String");
        hashSet4.add("StringBuffer");
        hashSet4.add("StringBuilder");
        hashSet4.add("System");
        hashSet4.add("System.LoggerFinder");
        hashSet4.add("Thread");
        hashSet4.add("ThreadGroup");
        hashSet4.add("ThreadLocal");
        hashSet4.add("Throwable");
        hashSet4.add("Void");
        hashSet4.add("Character.UnicodeScript");
        hashSet4.add("ProcessBuilder.Redirect.Type");
        hashSet4.add("StackWalker.Option");
        hashSet4.add("System.Logger.Level");
        hashSet4.add("Thread.State");
        hashSet4.add("ArithmeticException");
        hashSet4.add("ArrayIndexOutOfBoundsException");
        hashSet4.add("ArrayStoreException");
        hashSet4.add("ClassCastException");
        hashSet4.add("ClassNotFoundException");
        hashSet4.add("CloneNotSupportedException");
        hashSet4.add("EnumConstantNotPresentException");
        hashSet4.add("Exception");
        hashSet4.add("IllegalAccessException");
        hashSet4.add("IllegalArgumentException");
        hashSet4.add("IllegalCallerException");
        hashSet4.add("IllegalMonitorStateException");
        hashSet4.add("IllegalStateException");
        hashSet4.add("IllegalThreadStateException");
        hashSet4.add("IndexOutOfBoundsException");
        hashSet4.add("InstantiationException");
        hashSet4.add("InterruptedException");
        hashSet4.add("LayerInstantiationException");
        hashSet4.add("NegativeArraySizeException");
        hashSet4.add("NoSuchFieldException");
        hashSet4.add("NoSuchMethodException");
        hashSet4.add("NullPointerException");
        hashSet4.add("NumberFormatException");
        hashSet4.add("ReflectiveOperationException");
        hashSet4.add("RuntimeException");
        hashSet4.add("SecurityException");
        hashSet4.add("StringIndexOutOfBoundsException");
        hashSet4.add("TypeNotPresentException");
        hashSet4.add("UnsupportedOperationException");
        hashSet4.add("WrongThreadException");
        hashSet4.add("AbstractMethodError");
        hashSet4.add("AssertionError");
        hashSet4.add("BootstrapMethodError");
        hashSet4.add("ClassCircularityError");
        hashSet4.add("ClassFormatError");
        hashSet4.add("Error");
        hashSet4.add("ExceptionInInitializerError");
        hashSet4.add("IllegalAccessError");
        hashSet4.add("IncompatibleClassChangeError");
        hashSet4.add("InstantiationError");
        hashSet4.add("InternalError");
        hashSet4.add("LinkageError");
        hashSet4.add("NoClassDefFoundError");
        hashSet4.add("NoSuchFieldError");
        hashSet4.add("NoSuchMethodError");
        hashSet4.add("OutOfMemoryError");
        hashSet4.add("StackOverflowError");
        hashSet4.add("ThreadDeath");
        hashSet4.add("UnknownError");
        hashSet4.add("UnsatisfiedLinkError");
        hashSet4.add("UnsupportedClassVersionError");
        hashSet4.add("VerifyError");
        hashSet4.add("VirtualMachineError");
        hashSet4.add("Deprecated");
        hashSet4.add("FunctionalInterface");
        hashSet4.add("Override");
        hashSet4.add("SafeVarargs");
        hashSet4.add("SuppressWarnings");
        standardPackages.put("java.lang", hashSet4);
    }

    private static class PrivilegedResourceExists
    implements PrivilegedAction<Boolean> {
        private final ClassLoader cl;
        private final String name;

        public PrivilegedResourceExists(ClassLoader classLoader, String string) {
            this.cl = classLoader;
            this.name = string;
        }

        @Override
        public Boolean run() {
            if (this.cl.getResource(this.name) == null) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }

    private static class NotFound {
        private NotFound() {
        }
    }
}

