/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.ui.HeapView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.graalvm.visualvm.uisupport.VerticalLayout;
import org.openide.util.Lookup;

public class SummaryView {
    private final String viewID;
    private final HeapContext context;
    private final HeapViewerActions actions;
    private final Collection<HeapViewerNodeAction.Provider> actionProviders;
    private List<HeapView> content;
    private JComponent component;
    private ProfilerToolbar toolbar;

    public SummaryView(String viewID, HeapContext context, HeapViewerActions actions) {
        this.viewID = viewID;
        this.context = context;
        this.actions = actions;
        this.actionProviders = new ArrayList<HeapViewerNodeAction.Provider>();
        for (HeapViewerNodeAction.Provider provider : Lookup.getDefault().lookupAll(HeapViewerNodeAction.Provider.class)) {
            if (!provider.supportsView(context, viewID)) continue;
            this.actionProviders.add(provider);
        }
        this.content = new ArrayList<HeapView>();
        Collection providers = Lookup.getDefault().lookupAll(ContentProvider.class);
        for (ContentProvider provider : providers) {
            HeapView summary = provider.createSummary(this.viewID, this.context, this.actions, this.actionProviders);
            if (summary == null) continue;
            this.content.add(summary);
        }
    }

    public JComponent getComponent() {
        if (this.component == null) {
            this.initUI();
        }
        return this.component;
    }

    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.toolbar;
    }

    protected HeapView createDefaultSummary() {
        return null;
    }

    protected void uiCreated(List<HeapView> views) {
    }

    private void initUI() {
        this.toolbar = ProfilerToolbar.create((boolean)false);
        JPanel p = new JPanel((LayoutManager)new VerticalLayout(false, 6));
        p.setOpaque(true);
        p.setBackground(UIUtils.getProfilerResultsBackground());
        HeapView defaultContent = this.createDefaultSummary();
        if (defaultContent != null) {
            this.content.add(0, defaultContent);
        }
        for (HeapView view : this.content) {
            p.add(new ContentContainer(view));
            ProfilerToolbar viewToolbar = view.getToolbar();
            if (viewToolbar == null) continue;
            this.toolbar.add(viewToolbar);
        }
        this.uiCreated(new ArrayList<HeapView>(this.content));
        this.component = new ScrollableContainer((JComponent)p);
        this.content.clear();
        this.content = null;
    }

    public static abstract class ContentProvider {
        public abstract HeapView createSummary(String var1, HeapContext var2, HeapViewerActions var3, Collection<HeapViewerNodeAction.Provider> var4);
    }

    private static class ContentContainer
    extends JPanel {
        ContentContainer(HeapView view) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
            this.add((Component)view.getComponent(), "Center");
        }
    }

    public static class SimpleTable
    extends ProfilerTable {
        private static final int COLUMN_MARGIN = 5;

        public SimpleTable(TableModel tm, int fillerColumn) {
            super(tm, false, false, null);
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(false);
            this.setIntercellSpacing(new Dimension());
            this.setRowSelectionAllowed(false);
            this.setColumnSelectionAllowed(false);
            this.setFitWidthColumn(fillerColumn);
        }

        public void setColumnRenderer(int column, ProfilerRenderer renderer, boolean fixedWidth) {
            super.setColumnRenderer(column, renderer);
            if (fixedWidth) {
                int w = 0;
                int rc = this.getRowCount();
                for (int row = 0; row < rc; ++row) {
                    renderer.setValue(this.getValueAt(row, column), column);
                    w = Math.max(w, renderer.getComponent().getPreferredSize().width);
                }
                this.setDefaultColumnWidth(column, w + 5);
            }
        }
    }
}

