/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.jfluid.ProfilerLogger;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.profiler.actions.Bundle;
import org.graalvm.visualvm.lib.profiler.actions.ProfilingAwareAction;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;

public final class InternalStatsAction
extends ProfilingAwareAction {
    private static final int[] enabledStates = new int[]{4};

    public InternalStatsAction() {
        this.putValue("Name", Bundle.LBL_InternalStatsAction());
        this.putValue("ShortDescription", Bundle.HINT_InternalStatsAction());
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        try {
            String stats = Profiler.getDefault().getTargetAppRunner().getInternalStats();
            HTMLTextArea textArea = new HTMLTextArea(stats);
            textArea.getAccessibleContext().setAccessibleName(Bundle.CAPTION_InternalStatisticsInstrHotswap());
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            p.add((Component)new JScrollPane((Component)textArea), "Center");
            DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)p, Bundle.CAPTION_InternalStatisticsInstrHotswap(), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null)).setVisible(true);
        }
        catch (ClientUtils.TargetAppOrVMTerminated e) {
            ProfilerDialogs.displayWarning((String)Bundle.MSG_NotAvailableNow(e.getMessage()));
            ProfilerLogger.log((String)e.getMessage());
        }
    }

    @Override
    protected int[] enabledStates() {
        return enabledStates;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public String getName() {
        return Bundle.LBL_InternalStatsAction();
    }
}

