/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.es;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_es extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Hora de \u00c1frica central",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Hora est\u00e1ndar de Mosc\u00fa",
               "MST",
               "Hora de verano de Mosc\u00fa",
               "MST",
               "Hora de Mosc\u00fa",
               "MT",
            };
        final String[] Japan = new String[] {
               "Hora est\u00e1ndar de Jap\u00f3n",
               "JST",
               "Hora de verano de Jap\u00f3n",
               "JDT",
               "Hora de Jap\u00f3n",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Hora est\u00e1ndar de Pakist\u00e1n",
               "PST",
               "Hora de verano de Pakist\u00e1n",
               "PST",
               "Hora de Pakist\u00e1n",
               "PT",
            };
        final String[] Hovd = new String[] {
               "Hora est\u00e1ndar de Hovd",
               "HST",
               "Hora de verano de Hovd",
               "HST",
               "Hora de Hovd",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Hora est\u00e1ndar de Magad\u00e1n",
               "MST",
               "Hora de verano de Magad\u00e1n",
               "MST",
               "Hora de Magad\u00e1n",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hora est\u00e1ndar de Australia centroccidental",
               "ACWST",
               "Hora de verano de Australia centroccidental",
               "ACWDT",
               "Hora de Australia centroccidental",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Hora est\u00e1ndar de Europa Central",
               "CEST",
               "Hora de verano de Europa Central",
               "CEST",
               "Hora de Europa Central",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Hora est\u00e1ndar de Sajal\u00edn",
               "SST",
               "Hora de verano de Sajal\u00edn",
               "SST",
               "Hora de Sajal\u00edn",
               "ST",
            };
        final String[] Paraguay = new String[] {
               "Hora est\u00e1ndar de Paraguay",
               "PST",
               "Hora de verano de Paraguay",
               "PST",
               "Hora de Paraguay",
               "PT",
            };
        final String[] Malaysia = new String[] {
               "Hora de Malasia",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] America_Eastern = new String[] {
               "Hora est\u00e1ndar oriental",
               "EST",
               "Hora de verano oriental",
               "EDT",
               "Hora oriental",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Hora est\u00e1ndar de Lord Howe",
               "LHST",
               "Hora de verano de Lord Howe",
               "LHDT",
               "Hora de Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Hora est\u00e1ndar de Nueva Zelanda",
               "NZST",
               "Hora de verano de Nueva Zelanda",
               "NZDT",
               "Hora de Nueva Zelanda",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Hora del Oc\u00e9ano \u00cdndico",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Hora est\u00e1ndar de Yakutsk",
               "YST",
               "Hora de verano de Yakutsk",
               "YST",
               "Hora de Yakutsk",
               "YT",
            };
        final String[] Africa_Eastern = new String[] {
               "Hora de \u00c1frica oriental",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Hora de Timor Oriental",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Marshall_Islands = new String[] {
               "Hora de las Islas Marshall",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Europe_Eastern = new String[] {
               "Hora est\u00e1ndar de Europa del Este",
               "EEST",
               "Hora de verano de Europa del Este",
               "EEST",
               "Hora de Europa del Este",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Hora est\u00e1ndar de Terranova",
               "NST",
               "Hora de verano de Terranova",
               "NDT",
               "Hora de Terranova",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Hora de Afganist\u00e1n",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Hong_Kong = new String[] {
               "Hora est\u00e1ndar de Hong Kong",
               "HKST",
               "Hora de verano de Hong Kong",
               "HKST",
               "Hora de Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Hora est\u00e1ndar de Argentina occidental",
               "WAST",
               "Hora de verano de Argentina occidental",
               "WAST",
               "Hora de Argentina occidental",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "Hora est\u00e1ndar del Atl\u00e1ntico",
               "AST",
               "Hora de verano del Atl\u00e1ntico",
               "ADT",
               "Hora del Atl\u00e1ntico",
               "AT",
            };
        final String[] Bolivia = new String[] {
               "Hora de Bolivia",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hora est\u00e1ndar de San Pedro y Miquel\u00f3n",
               "PMST",
               "Hora de verano de San Pedro y Miquel\u00f3n",
               "PMDT",
               "Hora de San Pedro y Miquel\u00f3n",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Hora de Indochina",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "Hora est\u00e1ndar de Yekaterinburgo",
               "YST",
               "Hora de verano de Yekaterinburgo",
               "YST",
               "Hora de Ekaterimburgo",
               "YT",
            };
        final String[] Israel = new String[] {
               "Hora est\u00e1ndar de Israel",
               "IST",
               "Hora de verano de Israel",
               "IDT",
               "Hora de Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Hora de Indonesia central",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "Hora de Sud\u00e1frica",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Uzbekistan = new String[] {
               "Hora est\u00e1ndar de Uzbekist\u00e1n",
               "UST",
               "Hora de verano de Uzbekist\u00e1n",
               "UST",
               "Hora de Uzbekist\u00e1n",
               "UT",
            };
        final String[] Omsk = new String[] {
               "Hora est\u00e1ndar de Omsk",
               "OST",
               "Hora de verano de Omsk",
               "OST",
               "Hora de Omsk",
               "OT",
            };
        final String[] Uruguay = new String[] {
               "Hora est\u00e1ndar de Uruguay",
               "UST",
               "Hora de verano de Uruguay",
               "UST",
               "Hora de Uruguay",
               "UT",
            };
        final String[] Nepal = new String[] {
               "Hora de Nepal",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Mongolia = new String[] {
               "Hora est\u00e1ndar de Ul\u00e1n Bator",
               "UBST",
               "Hora de verano de Ul\u00e1n Bator",
               "UBST",
               "Hora de Ul\u00e1n Bator",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Hora est\u00e1ndar central",
               "CST",
               "Hora de verano central",
               "CDT",
               "Hora central",
               "CT",
            };
        final String[] Novosibirsk = new String[] {
               "Hora est\u00e1ndar de Novosibirsk",
               "NST",
               "Hora de verano de Novosibirsk",
               "NST",
               "Hora de Novosibirsk",
               "NT",
            };
        final String[] Azores = new String[] {
               "Hora est\u00e1ndar de las Azores",
               "AST",
               "Hora de verano de las Azores",
               "AST",
               "Hora de las Azores",
               "AT",
            };
        final String[] Bhutan = new String[] {
               "Hora de But\u00e1n",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Suriname = new String[] {
               "Hora de Surinam",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hora est\u00e1ndar de Krasnoyarsk",
               "KST",
               "Hora de verano de Krasnoyarsk",
               "KST",
               "Hora de Krasnoyarsk",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Hora de Kazajist\u00e1n occidental",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Myanmar = new String[] {
               "Hora de Myanmar",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Amazon = new String[] {
               "Hora est\u00e1ndar del Amazonas",
               "AST",
               "Hora de verano del Amazonas",
               "AST",
               "Hora del Amazonas",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Hora de Kazajist\u00e1n oriental",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Argentina = new String[] {
               "Hora est\u00e1ndar de Argentina",
               "AST",
               "Hora de verano de Argentina",
               "AST",
               "Hora de Argentina",
               "AT",
            };
        final String[] Galapagos = new String[] {
               "Hora de Gal\u00e1pagos",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Island Time",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Hora de Macquarie",
               "MIT",
            };
        final String[] Venezuela = new String[] {
               "Hora de Venezuela",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hora est\u00e1ndar de Haw\u00e1i-Aleutianas",
               "HAST",
               "Hora de verano de Haw\u00e1i-Aleutianas",
               "HADT",
               "Hora de Haw\u00e1i-Aleutianas",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Hora est\u00e1ndar de Australia central",
               "ACST",
               "Hora de verano de Australia central",
               "ACDT",
               "Hora de Australia central",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "Hora est\u00e1ndar del Pac\u00edfico",
               "PST",
               "Hora de verano del Pac\u00edfico",
               "PDT",
               "Hora del Pac\u00edfico",
               "PT",
            };
        final String[] Turkmenistan = new String[] {
               "Hora est\u00e1ndar de Turkmenist\u00e1n",
               "TST",
               "Hora de verano de Turkmenist\u00e1n",
               "TST",
               "Hora de Turkmenist\u00e1n",
               "TT",
            };
        final String[] Europe_Western = new String[] {
               "Hora est\u00e1ndar de Europa Occidental",
               "WEST",
               "Hora de verano de Europa Occidental",
               "WEST",
               "Hora de Europa Occidental",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Hora est\u00e1ndar de Cabo Verde",
               "CVST",
               "Hora de verano de Cabo Verde",
               "CVST",
               "Hora de Cabo Verde",
               "CVT",
            };
        final String[] Guyana = new String[] {
               "Hora de la Guyana",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Samoa = new String[] {
               "Hora est\u00e1ndar de Samoa",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Azerbaijan = new String[] {
               "Hora est\u00e1ndar de Azerbaiy\u00e1n",
               "AST",
               "Hora de verano de Azerbaiy\u00e1n",
               "AST",
               "Hora de Azerbaiy\u00e1n",
               "AT",
            };
        final String[] Cuba = new String[] {
               "Hora est\u00e1ndar de Cuba",
               "CST",
               "Hora de verano de Cuba",
               "CDT",
               "Hora de Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Hora est\u00e1ndar de \u00c1frica occidental",
               "WAST",
               "Hora de verano de \u00c1frica occidental",
               "WAST",
               "Hora de \u00c1frica occidental",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Hora media de Greenwich",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Philippines = new String[] {
               "Hora est\u00e1ndar de Filipinas",
               "PST",
               "Hora de verano de Filipinas",
               "PST",
               "Hora de Filipinas",
               "PT",
            };
        final String[] South_Georgia = new String[] {
               "Hora de Georgia meridional",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Volgograd = new String[] {
               "Hora est\u00e1ndar de Volgogrado",
               "VST",
               "Hora de verano de Volgogrado",
               "VST",
               "Hora de Volgogrado",
               "VT",
            };
        final String[] Tajikistan = new String[] {
               "Hora de Tayikist\u00e1n",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Bangladesh = new String[] {
               "Hora de Bangladesh",
               "BST",
               "Bangladesh Summer Time",
               "BST",
               "Bangladesh Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "Hora est\u00e1ndar de Per\u00fa",
               "PST",
               "Hora de verano de Per\u00fa",
               "PST",
               "Hora de Per\u00fa",
               "PT",
            };
        final String[] Greenland_Western = new String[] {
               "Hora est\u00e1ndar de Groenlandia occidental",
               "WGST",
               "Hora de verano de Groenlandia occidental",
               "WGST",
               "Hora de Groenlandia occidental",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Hora de Ecuador",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "Hora est\u00e1ndar de Groenlandia oriental",
               "EGST",
               "Hora de verano de Groenlandia oriental",
               "EGST",
               "Hora de Groenlandia oriental",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Hora est\u00e1ndar del Golfo",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hora de Indonesia oriental",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "Hora est\u00e1ndar de Corea",
               "KST",
               "Hora de verano de Corea",
               "KDT",
               "Hora de Corea",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Hora est\u00e1ndar de Australia occidental",
               "AWST",
               "Hora de verano de Australia occidental",
               "AWDT",
               "Hora de Australia occidental",
               "WAT",
            };
        final String[] Kyrgystan = new String[] {
               "Hora de Kirguist\u00e1n",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Indonesia_Western = new String[] {
               "Hora de Indonesia occidental",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "Hora est\u00e1ndar de Australia oriental",
               "AEST",
               "Hora de verano de Australia oriental",
               "AEDT",
               "Hora de Australia oriental",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "Hora de la Guayana Francesa",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "Hora est\u00e1ndar de Colombia",
               "CST",
               "Hora de verano de Colombia",
               "CST",
               "Hora de Colombia",
               "CT",
            };
        final String[] Chile = new String[] {
               "Hora est\u00e1ndar de Chile",
               "CST",
               "Hora de verano de Chile",
               "CST",
               "Hora de Chile",
               "CT",
            };
        final String[] America_Mountain = new String[] {
               "Hora est\u00e1ndar de Monta\u00f1a",
               "MST",
               "Hora de verano de Monta\u00f1a",
               "MDT",
               "Hora de las Monta\u00f1as",
               "MT",
            };
        final String[] Arabian = new String[] {
               "Hora est\u00e1ndar de Arabia",
               "AST",
               "Hora de verano de Arabia",
               "ADT",
               "Hora de Arabia",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Hora est\u00e1ndar de Alaska",
               "AKST",
               "Hora de verano de Alaska",
               "AKDT",
               "Hora de Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Hora est\u00e1ndar de Vladivostok",
               "VST",
               "Hora de verano de Vladivostok",
               "VST",
               "Hora de Vladivostok",
               "VT",
            };
        final String[] Chamorro = new String[] {
               "Hora est\u00e1ndar de Chamorro",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Irkutsk = new String[] {
               "Hora est\u00e1ndar de Irkutsk",
               "IST",
               "Hora de verano de Irkutsk",
               "IST",
               "Hora de Irkutsk",
               "IT",
            };
        final String[] Georgia = new String[] {
               "Hora est\u00e1ndar de Georgia",
               "GST",
               "Hora de verano de Georgia",
               "GST",
               "Hora de Georgia",
               "GT",
            };
        final String[] Noronha = new String[] {
               "Hora est\u00e1ndar de Fernando de Noronha",
               "FNST",
               "Hora de verano de Fernando de Noronha",
               "FNST",
               "Hora de Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Hora est\u00e1ndar de Choibalsan",
               "CST",
               "Hora de verano de Choibalsan",
               "CST",
               "Hora de Choibalsan",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Hora est\u00e1ndar de Brasilia",
               "BST",
               "Hora de verano de Brasilia",
               "BST",
               "Hora de Brasilia",
               "BT",
            };
        final String[] China = new String[] {
               "Hora est\u00e1ndar de China",
               "CST",
               "Hora de verano de China",
               "CDT",
               "Hora de China",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Hora est\u00e1ndar de Armenia",
               "AST",
               "Hora de verano de Armenia",
               "AST",
               "Hora de Armenia",
               "AT",
            };
        final String[] India = new String[] {
               "Hora est\u00e1ndar de la India",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Europe/Kaliningrad", GMT },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Rainy_River", America_Central },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "America/Antigua", Atlantic },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Samoa },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Resolute", America_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
