/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.collections.SynchronizedQueue;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.compat.JrePlatform;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AbstractJsseEndpoint;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SendfileDataBase;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketProcessorBase;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.net.jsse.JSSESupport;

public class NioEndpoint
extends AbstractJsseEndpoint<NioChannel, SocketChannel> {
    private static final Log log = LogFactory.getLog(NioEndpoint.class);
    public static final int OP_REGISTER = 256;
    private volatile ServerSocketChannel serverSock = null;
    private volatile CountDownLatch stopLatch = null;
    private SynchronizedStack<PollerEvent> eventCache;
    private SynchronizedStack<NioChannel> nioChannels;
    private SocketAddress previousAcceptedSocketRemoteAddress = null;
    private long previousAcceptedSocketNanoTime = 0L;
    private boolean useInheritedChannel = false;
    private int pollerThreadPriority = 5;
    private long selectorTimeout = 1000L;
    private Poller poller = null;

    public void setUseInheritedChannel(boolean bl) {
        this.useInheritedChannel = bl;
    }

    public boolean getUseInheritedChannel() {
        return this.useInheritedChannel;
    }

    public void setPollerThreadPriority(int n) {
        this.pollerThreadPriority = n;
    }

    public int getPollerThreadPriority() {
        return this.pollerThreadPriority;
    }

    @Deprecated
    public void setPollerThreadCount(int n) {
    }

    @Deprecated
    public int getPollerThreadCount() {
        return 1;
    }

    public void setSelectorTimeout(long l) {
        this.selectorTimeout = l;
    }

    public long getSelectorTimeout() {
        return this.selectorTimeout;
    }

    @Deprecated
    public Poller getPoller0() {
        return this.poller;
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    public int getKeepAliveCount() {
        if (this.poller == null) {
            return 0;
        }
        return this.poller.getKeyCount();
    }

    @Override
    public void bind() throws Exception {
        this.initServerSocket();
        this.setStopLatch(new CountDownLatch(1));
        this.initialiseSsl();
    }

    protected void initServerSocket() throws Exception {
        if (this.getUseInheritedChannel()) {
            Channel channel = System.inheritedChannel();
            if (channel instanceof ServerSocketChannel) {
                this.serverSock = (ServerSocketChannel)channel;
            }
            if (this.serverSock == null) {
                throw new IllegalArgumentException(sm.getString("endpoint.init.bind.inherited"));
            }
        } else {
            this.serverSock = ServerSocketChannel.open();
            this.socketProperties.setProperties(this.serverSock.socket());
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.getAddress(), this.getPortWithOffset());
            this.serverSock.socket().bind(inetSocketAddress, this.getAcceptCount());
        }
        this.serverSock.configureBlocking(true);
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            if (this.socketProperties.getProcessorCache() != 0) {
                this.processorCache = new SynchronizedStack(128, this.socketProperties.getProcessorCache());
            }
            if (this.socketProperties.getEventCache() != 0) {
                this.eventCache = new SynchronizedStack(128, this.socketProperties.getEventCache());
            }
            if (this.socketProperties.getBufferPool() != 0) {
                this.nioChannels = new SynchronizedStack(128, this.socketProperties.getBufferPool());
            }
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.poller = new Poller();
            Thread thread = new Thread((Runnable)this.poller, this.getName() + "-Poller");
            thread.setPriority(this.threadPriority);
            thread.setDaemon(true);
            thread.start();
            this.startAcceptorThread();
        }
    }

    @Override
    public void stopInternal() {
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.acceptor.stop(10);
            if (this.poller != null) {
                this.poller.destroy();
                this.poller = null;
            }
            try {
                if (!this.getStopLatch().await(this.selectorTimeout + 100L, TimeUnit.MILLISECONDS)) {
                    log.warn((Object)sm.getString("endpoint.nio.stopLatchAwaitFail"));
                }
            }
            catch (InterruptedException interruptedException) {
                log.warn((Object)sm.getString("endpoint.nio.stopLatchAwaitInterrupted"), (Throwable)interruptedException);
            }
            this.shutdownExecutor();
            if (this.eventCache != null) {
                this.eventCache.clear();
                this.eventCache = null;
            }
            if (this.nioChannels != null) {
                NioChannel nioChannel;
                while ((nioChannel = (NioChannel)this.nioChannels.pop()) != null) {
                    nioChannel.free();
                }
                this.nioChannels = null;
            }
            if (this.processorCache != null) {
                this.processorCache.clear();
                this.processorCache = null;
            }
        }
    }

    @Override
    public void unbind() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy initiated for " + new InetSocketAddress(this.getAddress(), this.getPortWithOffset())));
        }
        if (this.running) {
            this.stop();
        }
        try {
            this.doCloseServerSocket();
        }
        catch (IOException iOException) {
            this.getLog().warn((Object)sm.getString("endpoint.serverSocket.closeFailed", new Object[]{this.getName()}), (Throwable)iOException);
        }
        this.destroySsl();
        super.unbind();
        if (this.getHandler() != null) {
            this.getHandler().recycle();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy completed for " + new InetSocketAddress(this.getAddress(), this.getPortWithOffset())));
        }
    }

    @Override
    protected void doCloseServerSocket() throws IOException {
        if (!this.getUseInheritedChannel() && this.serverSock != null) {
            this.serverSock.close();
        }
        this.serverSock = null;
    }

    protected SynchronizedStack<NioChannel> getNioChannels() {
        return this.nioChannels;
    }

    protected Poller getPoller() {
        return this.poller;
    }

    protected CountDownLatch getStopLatch() {
        return this.stopLatch;
    }

    protected void setStopLatch(CountDownLatch countDownLatch) {
        this.stopLatch = countDownLatch;
    }

    @Override
    protected boolean setSocketOptions(SocketChannel socketChannel) {
        Object object = null;
        try {
            Object object2;
            NioChannel nioChannel = null;
            if (this.nioChannels != null) {
                nioChannel = (NioChannel)this.nioChannels.pop();
            }
            if (nioChannel == null) {
                object2 = new SocketBufferHandler(this.socketProperties.getAppReadBufSize(), this.socketProperties.getAppWriteBufSize(), this.socketProperties.getDirectBuffer());
                nioChannel = this.isSSLEnabled() ? new SecureNioChannel((SocketBufferHandler)object2, this) : new NioChannel((SocketBufferHandler)object2);
            }
            object2 = new NioSocketWrapper(nioChannel, this);
            nioChannel.reset(socketChannel, (NioSocketWrapper)object2);
            this.connections.put(socketChannel, object2);
            object = object2;
            socketChannel.configureBlocking(false);
            this.socketProperties.setProperties(socketChannel.socket());
            ((SocketWrapperBase)object).setReadTimeout(this.getConnectionTimeout());
            ((SocketWrapperBase)object).setWriteTimeout(this.getConnectionTimeout());
            ((SocketWrapperBase)object).setKeepAliveLeft(this.getMaxKeepAliveRequests());
            this.poller.register((NioSocketWrapper)object);
            return true;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            try {
                log.error((Object)sm.getString("endpoint.socketOptionsError"), throwable);
            }
            catch (Throwable throwable2) {
                ExceptionUtils.handleThrowable((Throwable)throwable2);
            }
            if (object == null) {
                this.destroySocket(socketChannel);
            }
            return false;
        }
    }

    @Override
    protected void destroySocket(SocketChannel socketChannel) {
        block2: {
            this.countDownConnection();
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)sm.getString("endpoint.err.close"), (Throwable)iOException);
            }
        }
    }

    @Override
    protected NetworkChannel getServerSocket() {
        return this.serverSock;
    }

    @Override
    protected SocketChannel serverSocketAccept() throws Exception {
        SocketChannel socketChannel = this.serverSock.accept();
        if (!JrePlatform.IS_WINDOWS) {
            SocketAddress socketAddress = socketChannel.getRemoteAddress();
            long l = System.nanoTime();
            if (socketAddress.equals(this.previousAcceptedSocketRemoteAddress) && l - this.previousAcceptedSocketNanoTime < 1000L) {
                throw new IOException(sm.getString("endpoint.err.duplicateAccept"));
            }
            this.previousAcceptedSocketRemoteAddress = socketAddress;
            this.previousAcceptedSocketNanoTime = l;
        }
        return socketChannel;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected SocketProcessorBase<NioChannel> createSocketProcessor(SocketWrapperBase<NioChannel> socketWrapperBase, SocketEvent socketEvent) {
        return new SocketProcessor(socketWrapperBase, socketEvent);
    }

    public static class SendfileData
    extends SendfileDataBase {
        protected volatile FileChannel fchannel;

        public SendfileData(String string, long l, long l2) {
            super(string, l, l2);
        }
    }

    protected class SocketProcessor
    extends SocketProcessorBase<NioChannel> {
        public SocketProcessor(SocketWrapperBase<NioChannel> socketWrapperBase, SocketEvent socketEvent) {
            super(socketWrapperBase, socketEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRun() {
            Poller poller = NioEndpoint.this.poller;
            if (poller == null) {
                this.socketWrapper.close();
                return;
            }
            try {
                int n = -1;
                try {
                    if (((NioChannel)this.socketWrapper.getSocket()).isHandshakeComplete()) {
                        n = 0;
                    } else if (this.event == SocketEvent.STOP || this.event == SocketEvent.DISCONNECT || this.event == SocketEvent.ERROR) {
                        n = -1;
                    } else {
                        n = ((NioChannel)this.socketWrapper.getSocket()).handshake(this.event == SocketEvent.OPEN_READ, this.event == SocketEvent.OPEN_WRITE);
                        this.event = SocketEvent.OPEN_READ;
                    }
                }
                catch (IOException iOException) {
                    n = -1;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)AbstractEndpoint.sm.getString("endpoint.err.handshake"), (Throwable)iOException);
                    }
                }
                catch (CancelledKeyException cancelledKeyException) {
                    n = -1;
                }
                if (n == 0) {
                    AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.OPEN;
                    socketState = this.event == null ? NioEndpoint.this.getHandler().process(this.socketWrapper, SocketEvent.OPEN_READ) : NioEndpoint.this.getHandler().process(this.socketWrapper, this.event);
                    if (socketState == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        poller.cancelledKey(this.getSelectionKey(), this.socketWrapper);
                    }
                } else if (n == -1) {
                    NioEndpoint.this.getHandler().process(this.socketWrapper, SocketEvent.CONNECT_FAIL);
                    poller.cancelledKey(this.getSelectionKey(), this.socketWrapper);
                } else if (n == 1) {
                    this.socketWrapper.registerReadInterest();
                } else if (n == 4) {
                    this.socketWrapper.registerWriteInterest();
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                poller.cancelledKey(this.getSelectionKey(), this.socketWrapper);
            }
            catch (VirtualMachineError virtualMachineError) {
                ExceptionUtils.handleThrowable((Throwable)virtualMachineError);
            }
            catch (Throwable throwable) {
                log.error((Object)AbstractEndpoint.sm.getString("endpoint.processing.fail"), throwable);
                poller.cancelledKey(this.getSelectionKey(), this.socketWrapper);
            }
            finally {
                this.socketWrapper = null;
                this.event = null;
                if (NioEndpoint.this.running && NioEndpoint.this.processorCache != null) {
                    NioEndpoint.this.processorCache.push((Object)this);
                }
            }
        }

        private SelectionKey getSelectionKey() {
            if (JreCompat.isJre11Available()) {
                return null;
            }
            SocketChannel socketChannel = ((NioChannel)this.socketWrapper.getSocket()).getIOChannel();
            if (socketChannel == null) {
                return null;
            }
            return socketChannel.keyFor(NioEndpoint.this.poller.getSelector());
        }
    }

    public static class NioSocketWrapper
    extends SocketWrapperBase<NioChannel> {
        private final SynchronizedStack<NioChannel> nioChannels;
        private final Poller poller;
        private int interestOps = 0;
        private volatile SendfileData sendfileData = null;
        private volatile long lastRead;
        private volatile long lastWrite = this.lastRead = System.currentTimeMillis();
        private final Object readLock;
        private volatile boolean readBlocking = false;
        private final Object writeLock;
        private volatile boolean writeBlocking = false;

        public NioSocketWrapper(NioChannel nioChannel, NioEndpoint nioEndpoint) {
            super(nioChannel, nioEndpoint);
            this.nioChannels = nioEndpoint.getNioChannels();
            this.poller = nioEndpoint.getPoller();
            this.socketBufferHandler = nioChannel.getBufHandler();
            this.readLock = this.readPending == null ? new Object() : this.readPending;
            this.writeLock = this.writePending == null ? new Object() : this.writePending;
        }

        public Poller getPoller() {
            return this.poller;
        }

        public int interestOps() {
            return this.interestOps;
        }

        public int interestOps(int n) {
            this.interestOps = n;
            return n;
        }

        public boolean interestOpsHas(int n) {
            return (this.interestOps() & n) == n;
        }

        public void setSendfileData(SendfileData sendfileData) {
            this.sendfileData = sendfileData;
        }

        public SendfileData getSendfileData() {
            return this.sendfileData;
        }

        public void updateLastWrite() {
            this.lastWrite = System.currentTimeMillis();
        }

        public long getLastWrite() {
            return this.lastWrite;
        }

        public void updateLastRead() {
            this.lastRead = System.currentTimeMillis();
        }

        public long getLastRead() {
            return this.lastRead;
        }

        @Override
        public boolean isReadyForRead() throws IOException {
            this.socketBufferHandler.configureReadBufferForRead();
            if (this.socketBufferHandler.getReadBuffer().remaining() > 0) {
                return true;
            }
            this.fillReadBuffer(false);
            boolean bl = this.socketBufferHandler.getReadBuffer().position() > 0;
            return bl;
        }

        @Override
        public int read(boolean bl, byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.populateReadBuffer(byArray, n, n2);
            if (n3 > 0) {
                return n3;
            }
            n3 = this.fillReadBuffer(bl);
            this.updateLastRead();
            if (n3 > 0) {
                this.socketBufferHandler.configureReadBufferForRead();
                n3 = Math.min(n3, n2);
                this.socketBufferHandler.getReadBuffer().get(byArray, n, n3);
            }
            return n3;
        }

        @Override
        public int read(boolean bl, ByteBuffer byteBuffer) throws IOException {
            int n = this.populateReadBuffer(byteBuffer);
            if (n > 0) {
                return n;
            }
            int n2 = this.socketBufferHandler.getReadBuffer().capacity();
            if (byteBuffer.remaining() >= n2) {
                byteBuffer.limit(byteBuffer.position() + n2);
                n = this.fillReadBuffer(bl, byteBuffer);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Socket: [" + this + "], Read direct from socket: [" + n + "]"));
                }
                this.updateLastRead();
            } else {
                n = this.fillReadBuffer(bl);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Socket: [" + this + "], Read into buffer: [" + n + "]"));
                }
                this.updateLastRead();
                if (n > 0) {
                    n = this.populateReadBuffer(byteBuffer);
                }
            }
            return n;
        }

        @Override
        protected void doClose() {
            block13: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Calling [" + this.getEndpoint() + "].closeSocket([" + this + "])"));
                }
                try {
                    this.getEndpoint().connections.remove(((NioChannel)this.getSocket()).getIOChannel());
                    if (((NioChannel)this.getSocket()).isOpen()) {
                        ((NioChannel)this.getSocket()).close(true);
                    }
                    if (this.getEndpoint().running && (this.nioChannels == null || !this.nioChannels.push(this.getSocket()))) {
                        ((NioChannel)this.getSocket()).free();
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    if (log.isDebugEnabled()) {
                        log.error((Object)sm.getString("endpoint.debug.channelCloseFail"), throwable);
                    }
                }
                finally {
                    this.socketBufferHandler = SocketBufferHandler.EMPTY;
                    this.nonBlockingWriteBuffer.clear();
                    this.reset(NioChannel.CLOSED_NIO_CHANNEL);
                }
                try {
                    SendfileData sendfileData = this.getSendfileData();
                    if (sendfileData != null && sendfileData.fchannel != null && sendfileData.fchannel.isOpen()) {
                        sendfileData.fchannel.close();
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    if (!log.isDebugEnabled()) break block13;
                    log.error((Object)sm.getString("endpoint.sendfile.closeError"), throwable);
                }
            }
        }

        private int fillReadBuffer(boolean bl) throws IOException {
            this.socketBufferHandler.configureReadBufferForWrite();
            return this.fillReadBuffer(bl, this.socketBufferHandler.getReadBuffer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int fillReadBuffer(boolean bl, ByteBuffer byteBuffer) throws IOException {
            int n = 0;
            if (this.getSocket() == NioChannel.CLOSED_NIO_CHANNEL) {
                throw new ClosedChannelException();
            }
            if (bl) {
                long l = this.getReadTimeout();
                long l2 = 0L;
                do {
                    if (l2 > 0L) {
                        long l3 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
                        if (l3 == 0L) {
                            l3 = 1L;
                        }
                        if ((l -= l3) <= 0L) {
                            throw new SocketTimeoutException();
                        }
                    }
                    if ((n = ((NioChannel)this.getSocket()).read(byteBuffer)) == -1) {
                        throw new EOFException();
                    }
                    if (n != 0) continue;
                    if (!this.readBlocking) {
                        this.readBlocking = true;
                        this.registerReadInterest();
                    }
                    Object object = this.readLock;
                    synchronized (object) {
                        if (this.readBlocking) {
                            try {
                                if (l > 0L) {
                                    l2 = System.nanoTime();
                                    this.readLock.wait(l);
                                } else {
                                    this.readLock.wait();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                } while (n == 0);
            } else {
                n = ((NioChannel)this.getSocket()).read(byteBuffer);
                if (n == -1) {
                    throw new EOFException();
                }
            }
            return n;
        }

        @Override
        protected boolean flushNonBlocking() throws IOException {
            boolean bl = this.socketOrNetworkBufferHasDataLeft();
            if (bl) {
                this.doWrite(false);
                bl = this.socketOrNetworkBufferHasDataLeft();
            }
            if (!bl && !this.nonBlockingWriteBuffer.isEmpty() && !(bl = this.nonBlockingWriteBuffer.write(this, false)) && this.socketOrNetworkBufferHasDataLeft()) {
                this.doWrite(false);
                bl = this.socketOrNetworkBufferHasDataLeft();
            }
            return bl;
        }

        private boolean socketOrNetworkBufferHasDataLeft() {
            return !this.socketBufferHandler.isWriteBufferEmpty() || ((NioChannel)this.getSocket()).getOutboundRemaining() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(boolean bl, ByteBuffer byteBuffer) throws IOException {
            int n = 0;
            if (this.getSocket() == NioChannel.CLOSED_NIO_CHANNEL) {
                throw new ClosedChannelException();
            }
            if (bl) {
                if (this.previousIOException != null) {
                    throw new IOException(this.previousIOException);
                }
                long l = this.getWriteTimeout();
                long l2 = 0L;
                do {
                    if (l2 > 0L) {
                        long l3 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
                        if (l3 == 0L) {
                            l3 = 1L;
                        }
                        if ((l -= l3) <= 0L) {
                            this.previousIOException = new SocketTimeoutException();
                            throw this.previousIOException;
                        }
                    }
                    if ((n = ((NioChannel)this.getSocket()).write(byteBuffer)) == -1) {
                        throw new EOFException();
                    }
                    if (n == 0 && (byteBuffer.hasRemaining() || ((NioChannel)this.getSocket()).getOutboundRemaining() > 0)) {
                        this.writeBlocking = true;
                        this.registerWriteInterest();
                        Object object = this.writeLock;
                        synchronized (object) {
                            if (this.writeBlocking) {
                                try {
                                    if (l > 0L) {
                                        l2 = System.nanoTime();
                                        this.writeLock.wait(l);
                                    } else {
                                        this.writeLock.wait();
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                this.writeBlocking = false;
                            }
                        }
                    }
                    if (l2 <= 0L) continue;
                    l = this.getWriteTimeout();
                    l2 = 0L;
                } while (byteBuffer.hasRemaining() || ((NioChannel)this.getSocket()).getOutboundRemaining() > 0);
            } else {
                do {
                    if ((n = ((NioChannel)this.getSocket()).write(byteBuffer)) != -1) continue;
                    throw new EOFException();
                } while (n > 0 && byteBuffer.hasRemaining());
            }
            this.updateLastWrite();
        }

        @Override
        public void registerReadInterest() {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("endpoint.debug.registerRead", new Object[]{this}));
            }
            this.getPoller().add(this, 1);
        }

        @Override
        public void registerWriteInterest() {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("endpoint.debug.registerWrite", new Object[]{this}));
            }
            this.getPoller().add(this, 4);
        }

        @Override
        public SendfileDataBase createSendfileData(String string, long l, long l2) {
            return new SendfileData(string, l, l2);
        }

        @Override
        public SendfileState processSendfile(SendfileDataBase sendfileDataBase) {
            this.setSendfileData((SendfileData)sendfileDataBase);
            SelectionKey selectionKey = ((NioChannel)this.getSocket()).getIOChannel().keyFor(this.getPoller().getSelector());
            return this.getPoller().processSendfile(selectionKey, this, true);
        }

        @Override
        protected void populateRemoteAddr() {
            InetAddress inetAddress;
            SocketChannel socketChannel = ((NioChannel)this.getSocket()).getIOChannel();
            if (socketChannel != null && (inetAddress = socketChannel.socket().getInetAddress()) != null) {
                this.remoteAddr = inetAddress.getHostAddress();
            }
        }

        @Override
        protected void populateRemoteHost() {
            InetAddress inetAddress;
            SocketChannel socketChannel = ((NioChannel)this.getSocket()).getIOChannel();
            if (socketChannel != null && (inetAddress = socketChannel.socket().getInetAddress()) != null) {
                this.remoteHost = inetAddress.getHostName();
                if (this.remoteAddr == null) {
                    this.remoteAddr = inetAddress.getHostAddress();
                }
            }
        }

        @Override
        protected void populateRemotePort() {
            SocketChannel socketChannel = ((NioChannel)this.getSocket()).getIOChannel();
            if (socketChannel != null) {
                this.remotePort = socketChannel.socket().getPort();
            }
        }

        @Override
        protected void populateLocalName() {
            InetAddress inetAddress;
            SocketChannel socketChannel = ((NioChannel)this.getSocket()).getIOChannel();
            if (socketChannel != null && (inetAddress = socketChannel.socket().getLocalAddress()) != null) {
                this.localName = inetAddress.getHostName();
            }
        }

        @Override
        protected void populateLocalAddr() {
            InetAddress inetAddress;
            SocketChannel socketChannel = ((NioChannel)this.getSocket()).getIOChannel();
            if (socketChannel != null && (inetAddress = socketChannel.socket().getLocalAddress()) != null) {
                this.localAddr = inetAddress.getHostAddress();
            }
        }

        @Override
        protected void populateLocalPort() {
            SocketChannel socketChannel = ((NioChannel)this.getSocket()).getIOChannel();
            if (socketChannel != null) {
                this.localPort = socketChannel.socket().getLocalPort();
            }
        }

        @Override
        public SSLSupport getSslSupport(String string) {
            if (this.getSocket() instanceof SecureNioChannel) {
                SecureNioChannel secureNioChannel = (SecureNioChannel)this.getSocket();
                return secureNioChannel.getSSLSupport();
            }
            return null;
        }

        @Override
        public void doClientAuth(SSLSupport sSLSupport) throws IOException {
            SecureNioChannel secureNioChannel = (SecureNioChannel)this.getSocket();
            SSLEngine sSLEngine = secureNioChannel.getSslEngine();
            if (!sSLEngine.getNeedClientAuth()) {
                sSLEngine.setNeedClientAuth(true);
                secureNioChannel.rehandshake(this.getEndpoint().getConnectionTimeout());
                ((JSSESupport)sSLSupport).setSession(sSLEngine.getSession());
            }
        }

        @Override
        public void setAppReadBufHandler(ApplicationBufferHandler applicationBufferHandler) {
            ((NioChannel)this.getSocket()).setAppReadBufHandler(applicationBufferHandler);
        }

        @Override
        protected <A> SocketWrapperBase.OperationState<A> newOperationState(boolean bl, ByteBuffer[] byteBufferArray, int n, int n2, SocketWrapperBase.BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, SocketWrapperBase.CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler, Semaphore semaphore, SocketWrapperBase.VectoredIOCompletionHandler<A> vectoredIOCompletionHandler) {
            return new NioOperationState(bl, byteBufferArray, n, n2, blockingMode, l, timeUnit, a, completionCheck, completionHandler, semaphore, vectoredIOCompletionHandler);
        }

        private class NioOperationState<A>
        extends SocketWrapperBase.OperationState<A> {
            private volatile boolean inline;

            private NioOperationState(boolean bl, ByteBuffer[] byteBufferArray, int n, int n2, SocketWrapperBase.BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, SocketWrapperBase.CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler, Semaphore semaphore, SocketWrapperBase.VectoredIOCompletionHandler<A> vectoredIOCompletionHandler) {
                super(NioSocketWrapper.this, bl, byteBufferArray, n, n2, blockingMode, l, timeUnit, a, completionCheck, completionHandler, semaphore, vectoredIOCompletionHandler);
                this.inline = true;
            }

            @Override
            protected boolean isInline() {
                return this.inline;
            }

            @Override
            protected boolean hasOutboundRemaining() {
                return ((NioChannel)NioSocketWrapper.this.getSocket()).getOutboundRemaining() > 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                long l = 0L;
                if (NioSocketWrapper.this.getError() == null) {
                    try {
                        object = this;
                        synchronized (object) {
                            if (!this.completionDone) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Skip concurrent " + (this.read ? "read" : "write") + " notification"));
                                }
                                return;
                            }
                            if (this.read) {
                                if (!NioSocketWrapper.this.socketBufferHandler.isReadBufferEmpty()) {
                                    NioSocketWrapper.this.socketBufferHandler.configureReadBufferForRead();
                                    for (int i = 0; i < this.length && !NioSocketWrapper.this.socketBufferHandler.isReadBufferEmpty(); ++i) {
                                        l += (long)SocketWrapperBase.transfer(NioSocketWrapper.this.socketBufferHandler.getReadBuffer(), this.buffers[this.offset + i]);
                                    }
                                }
                                if (l == 0L) {
                                    l = ((NioChannel)NioSocketWrapper.this.getSocket()).read(this.buffers, this.offset, this.length);
                                    NioSocketWrapper.this.updateLastRead();
                                }
                            } else {
                                boolean bl = true;
                                if (NioSocketWrapper.this.socketOrNetworkBufferHasDataLeft()) {
                                    NioSocketWrapper.this.socketBufferHandler.configureWriteBufferForRead();
                                    do {
                                        l = ((NioChannel)NioSocketWrapper.this.getSocket()).write(NioSocketWrapper.this.socketBufferHandler.getWriteBuffer());
                                    } while (NioSocketWrapper.this.socketOrNetworkBufferHasDataLeft() && l > 0L);
                                    if (NioSocketWrapper.this.socketOrNetworkBufferHasDataLeft()) {
                                        bl = false;
                                    }
                                    if (l > 0L) {
                                        l = 0L;
                                    }
                                }
                                if (bl) {
                                    long l2 = 0L;
                                    do {
                                        if ((l2 = ((NioChannel)NioSocketWrapper.this.getSocket()).write(this.buffers, this.offset, this.length)) == -1L) {
                                            l = l2;
                                            continue;
                                        }
                                        l += l2;
                                    } while (l2 > 0L);
                                    NioSocketWrapper.this.updateLastWrite();
                                }
                            }
                            if (l != 0L || !SocketWrapperBase.buffersArrayHasRemaining(this.buffers, this.offset, this.length) && !NioSocketWrapper.this.socketOrNetworkBufferHasDataLeft()) {
                                this.completionDone = false;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        NioSocketWrapper.this.setError(iOException);
                    }
                }
                if (l > 0L || l == 0L && !SocketWrapperBase.buffersArrayHasRemaining(this.buffers, this.offset, this.length) && !NioSocketWrapper.this.socketOrNetworkBufferHasDataLeft()) {
                    this.completion.completed(l, this);
                } else if (l < 0L || NioSocketWrapper.this.getError() != null) {
                    object = NioSocketWrapper.this.getError();
                    if (object == null) {
                        object = new EOFException();
                    }
                    this.completion.failed((Throwable)object, this);
                } else {
                    this.inline = false;
                    if (this.read) {
                        NioSocketWrapper.this.registerReadInterest();
                    } else {
                        NioSocketWrapper.this.registerWriteInterest();
                    }
                }
            }
        }
    }

    public class Poller
    implements Runnable {
        private Selector selector;
        private final SynchronizedQueue<PollerEvent> events = new SynchronizedQueue();
        private volatile boolean close = false;
        private long nextExpiration = 0L;
        private AtomicLong wakeupCounter = new AtomicLong(0L);
        private volatile int keyCount = 0;

        public Poller() throws IOException {
            this.selector = Selector.open();
        }

        public int getKeyCount() {
            return this.keyCount;
        }

        public Selector getSelector() {
            return this.selector;
        }

        protected void destroy() {
            this.close = true;
            this.selector.wakeup();
        }

        private void addEvent(PollerEvent pollerEvent) {
            this.events.offer((Object)pollerEvent);
            if (this.wakeupCounter.incrementAndGet() == 0L) {
                this.selector.wakeup();
            }
        }

        private PollerEvent createPollerEvent(NioSocketWrapper nioSocketWrapper, int n) {
            PollerEvent pollerEvent = null;
            if (NioEndpoint.this.eventCache != null) {
                pollerEvent = (PollerEvent)NioEndpoint.this.eventCache.pop();
            }
            if (pollerEvent == null) {
                pollerEvent = new PollerEvent(nioSocketWrapper, n);
            } else {
                pollerEvent.reset(nioSocketWrapper, n);
            }
            return pollerEvent;
        }

        public void add(NioSocketWrapper nioSocketWrapper, int n) {
            PollerEvent pollerEvent = this.createPollerEvent(nioSocketWrapper, n);
            this.addEvent(pollerEvent);
            if (this.close) {
                NioEndpoint.this.processSocket(nioSocketWrapper, SocketEvent.STOP, false);
            }
        }

        public boolean events() {
            boolean bl = false;
            PollerEvent pollerEvent = null;
            int n = this.events.size();
            for (int i = 0; i < n && (pollerEvent = (PollerEvent)this.events.poll()) != null; ++i) {
                bl = true;
                NioSocketWrapper nioSocketWrapper = pollerEvent.getSocketWrapper();
                SocketChannel socketChannel = ((NioChannel)nioSocketWrapper.getSocket()).getIOChannel();
                int n2 = pollerEvent.getInterestOps();
                if (socketChannel == null) {
                    log.warn((Object)AbstractEndpoint.sm.getString("endpoint.nio.nullSocketChannel"));
                    nioSocketWrapper.close();
                } else if (n2 == 256) {
                    try {
                        socketChannel.register(this.getSelector(), 1, nioSocketWrapper);
                    }
                    catch (Exception exception) {
                        log.error((Object)AbstractEndpoint.sm.getString("endpoint.nio.registerFail"), (Throwable)exception);
                    }
                } else {
                    SelectionKey selectionKey = socketChannel.keyFor(this.getSelector());
                    if (selectionKey == null) {
                        nioSocketWrapper.close();
                    } else {
                        NioSocketWrapper nioSocketWrapper2 = (NioSocketWrapper)selectionKey.attachment();
                        if (nioSocketWrapper2 != null) {
                            try {
                                int n3 = selectionKey.interestOps() | n2;
                                nioSocketWrapper2.interestOps(n3);
                                selectionKey.interestOps(n3);
                            }
                            catch (CancelledKeyException cancelledKeyException) {
                                this.cancelledKey(selectionKey, nioSocketWrapper);
                            }
                        } else {
                            this.cancelledKey(selectionKey, nioSocketWrapper);
                        }
                    }
                }
                if (!NioEndpoint.this.running || NioEndpoint.this.eventCache == null) continue;
                pollerEvent.reset();
                NioEndpoint.this.eventCache.push((Object)pollerEvent);
            }
            return bl;
        }

        public void register(NioSocketWrapper nioSocketWrapper) {
            nioSocketWrapper.interestOps(1);
            PollerEvent pollerEvent = this.createPollerEvent(nioSocketWrapper, 256);
            this.addEvent(pollerEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelledKey(SelectionKey selectionKey, SocketWrapperBase<NioChannel> socketWrapperBase) {
            if (JreCompat.isJre11Available() && socketWrapperBase != null) {
                socketWrapperBase.close();
            } else {
                try {
                    if (selectionKey != null) {
                        selectionKey.attach(null);
                        if (selectionKey.isValid()) {
                            selectionKey.cancel();
                        }
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    if (log.isDebugEnabled()) {
                        log.error((Object)AbstractEndpoint.sm.getString("endpoint.debug.channelCloseFail"), throwable);
                    }
                }
                finally {
                    if (socketWrapperBase != null) {
                        socketWrapperBase.close();
                    }
                }
            }
        }

        @Override
        public void run() {
            while (true) {
                Iterator<SelectionKey> iterator;
                boolean bl;
                block8: {
                    bl = false;
                    try {
                        if (!this.close) {
                            bl = this.events();
                            this.keyCount = this.wakeupCounter.getAndSet(-1L) > 0L ? this.selector.selectNow() : this.selector.select(NioEndpoint.this.selectorTimeout);
                            this.wakeupCounter.set(0L);
                        }
                        if (this.close) {
                            this.events();
                            this.timeout(0, false);
                            try {
                                this.selector.close();
                            }
                            catch (IOException iOException) {
                                log.error((Object)AbstractEndpoint.sm.getString("endpoint.nio.selectorCloseFail"), (Throwable)iOException);
                            }
                            break;
                        }
                        if (this.keyCount != 0) break block8;
                        bl |= this.events();
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        log.error((Object)AbstractEndpoint.sm.getString("endpoint.nio.selectorLoopError"), throwable);
                        continue;
                    }
                }
                Iterator<SelectionKey> iterator2 = iterator = this.keyCount > 0 ? this.selector.selectedKeys().iterator() : null;
                while (iterator != null && iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    NioSocketWrapper nioSocketWrapper = (NioSocketWrapper)selectionKey.attachment();
                    if (nioSocketWrapper == null) continue;
                    this.processKey(selectionKey, nioSocketWrapper);
                }
                this.timeout(this.keyCount, bl);
            }
            NioEndpoint.this.getStopLatch().countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processKey(SelectionKey selectionKey, NioSocketWrapper nioSocketWrapper) {
            try {
                if (this.close) {
                    this.cancelledKey(selectionKey, nioSocketWrapper);
                } else if (selectionKey.isValid()) {
                    if (selectionKey.isReadable() || selectionKey.isWritable()) {
                        if (nioSocketWrapper.getSendfileData() != null) {
                            this.processSendfile(selectionKey, nioSocketWrapper, false);
                        } else {
                            Object object;
                            this.unreg(selectionKey, nioSocketWrapper, selectionKey.readyOps());
                            boolean bl = false;
                            if (selectionKey.isReadable()) {
                                if (nioSocketWrapper.readOperation != null) {
                                    if (!nioSocketWrapper.readOperation.process()) {
                                        bl = true;
                                    }
                                } else if (nioSocketWrapper.readBlocking) {
                                    object = nioSocketWrapper.readLock;
                                    synchronized (object) {
                                        nioSocketWrapper.readBlocking = false;
                                        nioSocketWrapper.readLock.notify();
                                    }
                                } else if (!NioEndpoint.this.processSocket(nioSocketWrapper, SocketEvent.OPEN_READ, true)) {
                                    bl = true;
                                }
                            }
                            if (!bl && selectionKey.isWritable()) {
                                if (nioSocketWrapper.writeOperation != null) {
                                    if (!nioSocketWrapper.writeOperation.process()) {
                                        bl = true;
                                    }
                                } else if (nioSocketWrapper.writeBlocking) {
                                    object = nioSocketWrapper.writeLock;
                                    synchronized (object) {
                                        nioSocketWrapper.writeBlocking = false;
                                        nioSocketWrapper.writeLock.notify();
                                    }
                                } else if (!NioEndpoint.this.processSocket(nioSocketWrapper, SocketEvent.OPEN_WRITE, true)) {
                                    bl = true;
                                }
                            }
                            if (bl) {
                                this.cancelledKey(selectionKey, nioSocketWrapper);
                            }
                        }
                    }
                } else {
                    this.cancelledKey(selectionKey, nioSocketWrapper);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                this.cancelledKey(selectionKey, nioSocketWrapper);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)AbstractEndpoint.sm.getString("endpoint.nio.keyProcessingError"), throwable);
            }
        }

        public SendfileState processSendfile(SelectionKey selectionKey, NioSocketWrapper nioSocketWrapper, boolean bl) {
            NioChannel nioChannel = null;
            try {
                Object object;
                this.unreg(selectionKey, nioSocketWrapper, selectionKey.readyOps());
                SendfileData sendfileData = nioSocketWrapper.getSendfileData();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Processing send file for: " + sendfileData.fileName));
                }
                if (sendfileData.fchannel == null) {
                    object = new File(sendfileData.fileName);
                    FileInputStream fileInputStream = new FileInputStream((File)object);
                    sendfileData.fchannel = fileInputStream.getChannel();
                }
                Object object2 = object = (nioChannel = (NioChannel)nioSocketWrapper.getSocket()) instanceof SecureNioChannel ? nioChannel : nioChannel.getIOChannel();
                if (nioChannel.getOutboundRemaining() > 0) {
                    if (nioChannel.flushOutbound()) {
                        nioSocketWrapper.updateLastWrite();
                    }
                } else {
                    long l = sendfileData.fchannel.transferTo(sendfileData.pos, sendfileData.length, (WritableByteChannel)object);
                    if (l > 0L) {
                        sendfileData.pos += l;
                        sendfileData.length -= l;
                        nioSocketWrapper.updateLastWrite();
                    } else if (sendfileData.fchannel.size() <= sendfileData.pos) {
                        throw new IOException(AbstractEndpoint.sm.getString("endpoint.sendfile.tooMuchData"));
                    }
                }
                if (sendfileData.length <= 0L && nioChannel.getOutboundRemaining() <= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Send file complete for: " + sendfileData.fileName));
                    }
                    nioSocketWrapper.setSendfileData(null);
                    try {
                        sendfileData.fchannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl) {
                        switch (sendfileData.keepAliveState) {
                            case NONE: {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Send file connection is being closed");
                                }
                                NioEndpoint.this.poller.cancelledKey(selectionKey, nioSocketWrapper);
                                break;
                            }
                            case PIPELINED: {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Connection is keep alive, processing pipe-lined data");
                                }
                                if (NioEndpoint.this.processSocket(nioSocketWrapper, SocketEvent.OPEN_READ, true)) break;
                                NioEndpoint.this.poller.cancelledKey(selectionKey, nioSocketWrapper);
                                break;
                            }
                            case OPEN: {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Connection is keep alive, registering back for OP_READ");
                                }
                                this.reg(selectionKey, nioSocketWrapper, 1);
                            }
                        }
                    }
                    return SendfileState.DONE;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OP_WRITE for sendfile: " + sendfileData.fileName));
                }
                if (bl) {
                    this.add(nioSocketWrapper, 4);
                } else {
                    this.reg(selectionKey, nioSocketWrapper, 4);
                }
                return SendfileState.PENDING;
            }
            catch (IOException iOException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to complete sendfile request:", (Throwable)iOException);
                }
                if (!bl && nioChannel != null) {
                    NioEndpoint.this.poller.cancelledKey(selectionKey, nioSocketWrapper);
                }
                return SendfileState.ERROR;
            }
            catch (Throwable throwable) {
                log.error((Object)AbstractEndpoint.sm.getString("endpoint.sendfile.error"), throwable);
                if (!bl && nioChannel != null) {
                    NioEndpoint.this.poller.cancelledKey(selectionKey, nioSocketWrapper);
                }
                return SendfileState.ERROR;
            }
        }

        protected void unreg(SelectionKey selectionKey, NioSocketWrapper nioSocketWrapper, int n) {
            this.reg(selectionKey, nioSocketWrapper, selectionKey.interestOps() & ~n);
        }

        protected void reg(SelectionKey selectionKey, NioSocketWrapper nioSocketWrapper, int n) {
            selectionKey.interestOps(n);
            nioSocketWrapper.interestOps(n);
        }

        protected void timeout(int n, boolean bl) {
            long l = System.currentTimeMillis();
            if (this.nextExpiration > 0L && (n > 0 || bl) && l < this.nextExpiration && !this.close) {
                return;
            }
            int n2 = 0;
            try {
                for (SelectionKey selectionKey : this.selector.keys()) {
                    ++n2;
                    NioSocketWrapper nioSocketWrapper = (NioSocketWrapper)selectionKey.attachment();
                    try {
                        long l2;
                        long l3;
                        if (nioSocketWrapper == null) {
                            this.cancelledKey(selectionKey, null);
                            continue;
                        }
                        if (this.close) {
                            selectionKey.interestOps(0);
                            nioSocketWrapper.interestOps(0);
                            this.cancelledKey(selectionKey, nioSocketWrapper);
                            continue;
                        }
                        if (!nioSocketWrapper.interestOpsHas(1) && !nioSocketWrapper.interestOpsHas(4)) continue;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (nioSocketWrapper.interestOpsHas(1)) {
                            l3 = l - nioSocketWrapper.getLastRead();
                            l2 = nioSocketWrapper.getReadTimeout();
                            if (l2 > 0L && l3 > l2) {
                                bl2 = true;
                            }
                        }
                        if (!bl2 && nioSocketWrapper.interestOpsHas(4)) {
                            l3 = l - nioSocketWrapper.getLastWrite();
                            l2 = nioSocketWrapper.getWriteTimeout();
                            if (l2 > 0L && l3 > l2) {
                                bl3 = true;
                            }
                        }
                        if (!bl2 && !bl3) continue;
                        selectionKey.interestOps(0);
                        nioSocketWrapper.interestOps(0);
                        nioSocketWrapper.setError(new SocketTimeoutException());
                        if (bl2 && nioSocketWrapper.readOperation != null) {
                            if (nioSocketWrapper.readOperation.process()) continue;
                            this.cancelledKey(selectionKey, nioSocketWrapper);
                            continue;
                        }
                        if (bl3 && nioSocketWrapper.writeOperation != null) {
                            if (nioSocketWrapper.writeOperation.process()) continue;
                            this.cancelledKey(selectionKey, nioSocketWrapper);
                            continue;
                        }
                        if (NioEndpoint.this.processSocket(nioSocketWrapper, SocketEvent.ERROR, true)) continue;
                        this.cancelledKey(selectionKey, nioSocketWrapper);
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        this.cancelledKey(selectionKey, nioSocketWrapper);
                    }
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                log.warn((Object)AbstractEndpoint.sm.getString("endpoint.nio.timeoutCme"), (Throwable)concurrentModificationException);
            }
            long l4 = this.nextExpiration;
            this.nextExpiration = System.currentTimeMillis() + NioEndpoint.this.socketProperties.getTimeoutInterval();
            if (log.isTraceEnabled()) {
                log.trace((Object)("timeout completed: keys processed=" + n2 + "; now=" + l + "; nextExpiration=" + l4 + "; keyCount=" + n + "; hasEvents=" + bl + "; eval=" + (l < l4 && (n > 0 || bl) && !this.close)));
            }
        }
    }

    public static class PollerEvent {
        private NioSocketWrapper socketWrapper;
        private int interestOps;

        public PollerEvent(NioSocketWrapper nioSocketWrapper, int n) {
            this.reset(nioSocketWrapper, n);
        }

        public void reset(NioSocketWrapper nioSocketWrapper, int n) {
            this.socketWrapper = nioSocketWrapper;
            this.interestOps = n;
        }

        public NioSocketWrapper getSocketWrapper() {
            return this.socketWrapper;
        }

        public int getInterestOps() {
            return this.interestOps;
        }

        public void reset() {
            this.reset(null, 0);
        }

        public String toString() {
            return "Poller event: socket [" + this.socketWrapper.getSocket() + "], socketWrapper [" + this.socketWrapper + "], interestOps [" + this.interestOps + "]";
        }
    }
}

