// Copyright 2015-2022 The Khronos Group Inc.
//
// SPDX-License-Identifier: Apache-2.0 OR MIT
//

// This header is generated from the Khronos Vulkan XML API Registry.

#ifndef VULKAN_STRUCTS_HPP
#define VULKAN_STRUCTS_HPP

namespace VULKAN_HPP_NAMESPACE
{
  //===============
  //=== STRUCTS ===
  //===============

  struct AabbPositionsKHR
  {
    using NativeType = VkAabbPositionsKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AabbPositionsKHR( float minX_ = {}, float minY_ = {}, float minZ_ = {}, float maxX_ = {}, float maxY_ = {}, float maxZ_ = {} ) VULKAN_HPP_NOEXCEPT
      : minX( minX_ )
      , minY( minY_ )
      , minZ( minZ_ )
      , maxX( maxX_ )
      , maxY( maxY_ )
      , maxZ( maxZ_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AabbPositionsKHR( AabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AabbPositionsKHR( VkAabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT : AabbPositionsKHR( *reinterpret_cast<AabbPositionsKHR const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AabbPositionsKHR & operator=( AabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AabbPositionsKHR & operator=( VkAabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AabbPositionsKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMinX( float minX_ ) VULKAN_HPP_NOEXCEPT
    {
      minX = minX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMinY( float minY_ ) VULKAN_HPP_NOEXCEPT
    {
      minY = minY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMinZ( float minZ_ ) VULKAN_HPP_NOEXCEPT
    {
      minZ = minZ_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMaxX( float maxX_ ) VULKAN_HPP_NOEXCEPT
    {
      maxX = maxX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMaxY( float maxY_ ) VULKAN_HPP_NOEXCEPT
    {
      maxY = maxY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMaxZ( float maxZ_ ) VULKAN_HPP_NOEXCEPT
    {
      maxZ = maxZ_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAabbPositionsKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAabbPositionsKHR *>( this );
    }

    explicit operator VkAabbPositionsKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAabbPositionsKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, float const &, float const &, float const &, float const &, float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( minX, minY, minZ, maxX, maxY, maxZ );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AabbPositionsKHR const & ) const = default;
#else
    bool operator==( AabbPositionsKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( minX == rhs.minX ) && ( minY == rhs.minY ) && ( minZ == rhs.minZ ) && ( maxX == rhs.maxX ) && ( maxY == rhs.maxY ) && ( maxZ == rhs.maxZ );
#  endif
    }

    bool operator!=( AabbPositionsKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float minX = {};
    float minY = {};
    float minZ = {};
    float maxX = {};
    float maxY = {};
    float maxZ = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AabbPositionsKHR ) == sizeof( VkAabbPositionsKHR ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AabbPositionsKHR>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AabbPositionsKHR>::value,
                            "AabbPositionsKHR is not nothrow_move_constructible!" );
  using AabbPositionsNV = AabbPositionsKHR;

  union DeviceOrHostAddressConstKHR
  {
    using NativeType = VkDeviceOrHostAddressConstKHR;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ = {} ) : deviceAddress( deviceAddress_ ) {}

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR( const void * hostAddress_ ) : hostAddress( hostAddress_ ) {}
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR & setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR & setHostAddress( const void * hostAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      hostAddress = hostAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkDeviceOrHostAddressConstKHR const &() const
    {
      return *reinterpret_cast<const VkDeviceOrHostAddressConstKHR *>( this );
    }

    operator VkDeviceOrHostAddressConstKHR &()
    {
      return *reinterpret_cast<VkDeviceOrHostAddressConstKHR *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress;
    const void *                        hostAddress;
#else
    VkDeviceAddress                                 deviceAddress;
    const void *                                    hostAddress;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct AccelerationStructureGeometryTrianglesDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryTrianglesDataKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryTrianglesDataKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryTrianglesDataKHR( VULKAN_HPP_NAMESPACE::Format                      vertexFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                                     VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData_   = {},
                                                     VULKAN_HPP_NAMESPACE::DeviceSize                  vertexStride_ = {},
                                                     uint32_t                                          maxVertex_    = {},
                                                     VULKAN_HPP_NAMESPACE::IndexType                   indexType_    = VULKAN_HPP_NAMESPACE::IndexType::eUint16,
                                                     VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR indexData_    = {},
                                                     VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR transformData_ = {},
                                                     const void *                                      pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , vertexFormat( vertexFormat_ )
      , vertexData( vertexData_ )
      , vertexStride( vertexStride_ )
      , maxVertex( maxVertex_ )
      , indexType( indexType_ )
      , indexData( indexData_ )
      , transformData( transformData_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryTrianglesDataKHR( AccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryTrianglesDataKHR( VkAccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryTrianglesDataKHR( *reinterpret_cast<AccelerationStructureGeometryTrianglesDataKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureGeometryTrianglesDataKHR & operator=( AccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryTrianglesDataKHR & operator=( VkAccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setVertexFormat( VULKAN_HPP_NAMESPACE::Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
                            setVertexData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
                            setVertexStride( VULKAN_HPP_NAMESPACE::DeviceSize vertexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexStride = vertexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setMaxVertex( uint32_t maxVertex_ ) VULKAN_HPP_NOEXCEPT
    {
      maxVertex = maxVertex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
                            setIndexData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & indexData_ ) VULKAN_HPP_NOEXCEPT
    {
      indexData = indexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
                            setTransformData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & transformData_ ) VULKAN_HPP_NOEXCEPT
    {
      transformData = transformData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureGeometryTrianglesDataKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryTrianglesDataKHR *>( this );
    }

    explicit operator VkAccelerationStructureGeometryTrianglesDataKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryTrianglesDataKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::IndexType const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, vertexFormat, vertexData, vertexStride, maxVertex, indexType, indexData, transformData );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType         = StructureType::eAccelerationStructureGeometryTrianglesDataKHR;
    const void *                                      pNext         = {};
    VULKAN_HPP_NAMESPACE::Format                      vertexFormat  = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData    = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                  vertexStride  = {};
    uint32_t                                          maxVertex     = {};
    VULKAN_HPP_NAMESPACE::IndexType                   indexType     = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR indexData     = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR transformData = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR ) ==
                              sizeof( VkAccelerationStructureGeometryTrianglesDataKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR>::value,
                            "AccelerationStructureGeometryTrianglesDataKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryTrianglesDataKHR>
  {
    using Type = AccelerationStructureGeometryTrianglesDataKHR;
  };

  struct AccelerationStructureGeometryAabbsDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryAabbsDataKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryAabbsDataKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR data_   = {},
                                                                       VULKAN_HPP_NAMESPACE::DeviceSize                  stride_ = {},
                                                                       const void *                                      pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , data( data_ )
      , stride( stride_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR( AccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryAabbsDataKHR( VkAccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryAabbsDataKHR( *reinterpret_cast<AccelerationStructureGeometryAabbsDataKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureGeometryAabbsDataKHR & operator=( AccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryAabbsDataKHR & operator=( VkAccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR &
                            setData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      data = data_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR & setStride( VULKAN_HPP_NAMESPACE::DeviceSize stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureGeometryAabbsDataKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryAabbsDataKHR *>( this );
    }

    explicit operator VkAccelerationStructureGeometryAabbsDataKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryAabbsDataKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, data, stride );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType  = StructureType::eAccelerationStructureGeometryAabbsDataKHR;
    const void *                                      pNext  = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR data   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                  stride = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR ) == sizeof( VkAccelerationStructureGeometryAabbsDataKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR>::value,
                            "AccelerationStructureGeometryAabbsDataKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryAabbsDataKHR>
  {
    using Type = AccelerationStructureGeometryAabbsDataKHR;
  };

  struct AccelerationStructureGeometryInstancesDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryInstancesDataKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryInstancesDataKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR( VULKAN_HPP_NAMESPACE::Bool32                      arrayOfPointers_ = {},
                                                                           VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR data_            = {},
                                                                           const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , arrayOfPointers( arrayOfPointers_ )
      , data( data_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryInstancesDataKHR( AccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryInstancesDataKHR( VkAccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryInstancesDataKHR( *reinterpret_cast<AccelerationStructureGeometryInstancesDataKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureGeometryInstancesDataKHR & operator=( AccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryInstancesDataKHR & operator=( VkAccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR &
                            setArrayOfPointers( VULKAN_HPP_NAMESPACE::Bool32 arrayOfPointers_ ) VULKAN_HPP_NOEXCEPT
    {
      arrayOfPointers = arrayOfPointers_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR &
                            setData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      data = data_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureGeometryInstancesDataKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryInstancesDataKHR *>( this );
    }

    explicit operator VkAccelerationStructureGeometryInstancesDataKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryInstancesDataKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, arrayOfPointers, data );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType           = StructureType::eAccelerationStructureGeometryInstancesDataKHR;
    const void *                                      pNext           = {};
    VULKAN_HPP_NAMESPACE::Bool32                      arrayOfPointers = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR data            = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR ) ==
                              sizeof( VkAccelerationStructureGeometryInstancesDataKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR>::value,
                            "AccelerationStructureGeometryInstancesDataKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryInstancesDataKHR>
  {
    using Type = AccelerationStructureGeometryInstancesDataKHR;
  };

  union AccelerationStructureGeometryDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryDataKHR;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR triangles_ = {} )
      : triangles( triangles_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR aabbs_ ) : aabbs( aabbs_ ) {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR instances_ )
      : instances( instances_ )
    {
    }
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR &
                            setTriangles( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR const & triangles_ ) VULKAN_HPP_NOEXCEPT
    {
      triangles = triangles_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR &
                            setAabbs( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR const & aabbs_ ) VULKAN_HPP_NOEXCEPT
    {
      aabbs = aabbs_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR &
                            setInstances( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR const & instances_ ) VULKAN_HPP_NOEXCEPT
    {
      instances = instances_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkAccelerationStructureGeometryDataKHR const &() const
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryDataKHR &()
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryDataKHR *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryTrianglesDataKHR triangles;
    VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryAabbsDataKHR     aabbs;
    VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryInstancesDataKHR instances;
#else
    VkAccelerationStructureGeometryTrianglesDataKHR triangles;
    VkAccelerationStructureGeometryAabbsDataKHR     aabbs;
    VkAccelerationStructureGeometryInstancesDataKHR instances;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct AccelerationStructureGeometryKHR
  {
    using NativeType = VkAccelerationStructureGeometryKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryKHR( VULKAN_HPP_NAMESPACE::GeometryTypeKHR geometryType_ = VULKAN_HPP_NAMESPACE::GeometryTypeKHR::eTriangles,
                                        VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryDataKHR geometry_ = {},
                                        VULKAN_HPP_NAMESPACE::GeometryFlagsKHR                     flags_    = {},
                                        const void *                                               pNext_    = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , geometryType( geometryType_ )
      , geometry( geometry_ )
      , flags( flags_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR( AccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryKHR( VkAccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryKHR( *reinterpret_cast<AccelerationStructureGeometryKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureGeometryKHR & operator=( AccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryKHR & operator=( VkAccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR & setGeometryType( VULKAN_HPP_NAMESPACE::GeometryTypeKHR geometryType_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryType = geometryType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR &
                            setGeometry( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryDataKHR const & geometry_ ) VULKAN_HPP_NOEXCEPT
    {
      geometry = geometry_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR & setFlags( VULKAN_HPP_NAMESPACE::GeometryFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureGeometryKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryKHR *>( this );
    }

    explicit operator VkAccelerationStructureGeometryKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::GeometryTypeKHR const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryDataKHR const &,
               VULKAN_HPP_NAMESPACE::GeometryFlagsKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, geometryType, geometry, flags );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                        sType        = StructureType::eAccelerationStructureGeometryKHR;
    const void *                                               pNext        = {};
    VULKAN_HPP_NAMESPACE::GeometryTypeKHR                      geometryType = VULKAN_HPP_NAMESPACE::GeometryTypeKHR::eTriangles;
    VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryDataKHR geometry     = {};
    VULKAN_HPP_NAMESPACE::GeometryFlagsKHR                     flags        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR ) == sizeof( VkAccelerationStructureGeometryKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR>::value,
                            "AccelerationStructureGeometryKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryKHR>
  {
    using Type = AccelerationStructureGeometryKHR;
  };

  union DeviceOrHostAddressKHR
  {
    using NativeType = VkDeviceOrHostAddressKHR;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ = {} ) : deviceAddress( deviceAddress_ ) {}

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR( void * hostAddress_ ) : hostAddress( hostAddress_ ) {}
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR & setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR & setHostAddress( void * hostAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      hostAddress = hostAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkDeviceOrHostAddressKHR const &() const
    {
      return *reinterpret_cast<const VkDeviceOrHostAddressKHR *>( this );
    }

    operator VkDeviceOrHostAddressKHR &()
    {
      return *reinterpret_cast<VkDeviceOrHostAddressKHR *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress;
    void *                              hostAddress;
#else
    VkDeviceAddress                                 deviceAddress;
    void *                                          hostAddress;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct AccelerationStructureBuildGeometryInfoKHR
  {
    using NativeType = VkAccelerationStructureBuildGeometryInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureBuildGeometryInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR                     type_  = VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR::eTopLevel,
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR               flags_ = {},
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR                mode_  = VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR::eBuild,
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                         srcAccelerationStructure_ = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                         dstAccelerationStructure_ = {},
      uint32_t                                                               geometryCount_            = {},
      const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR *         pGeometries_              = {},
      const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const * ppGeometries_             = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR                           scratchData_              = {},
      const void *                                                           pNext_                    = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , type( type_ )
      , flags( flags_ )
      , mode( mode_ )
      , srcAccelerationStructure( srcAccelerationStructure_ )
      , dstAccelerationStructure( dstAccelerationStructure_ )
      , geometryCount( geometryCount_ )
      , pGeometries( pGeometries_ )
      , ppGeometries( ppGeometries_ )
      , scratchData( scratchData_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR( AccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildGeometryInfoKHR( VkAccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureBuildGeometryInfoKHR( *reinterpret_cast<AccelerationStructureBuildGeometryInfoKHR const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureBuildGeometryInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR                                                                          type_,
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR                                                                    flags_,
      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR                                                                     mode_,
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                                                                              srcAccelerationStructure_,
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                                                                              dstAccelerationStructure_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR> const &         geometries_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const> const & pGeometries_ = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR                                                                                scratchData_ = {},
      const void *                                                                                                                pNext_       = nullptr )
      : pNext( pNext_ )
      , type( type_ )
      , flags( flags_ )
      , mode( mode_ )
      , srcAccelerationStructure( srcAccelerationStructure_ )
      , dstAccelerationStructure( dstAccelerationStructure_ )
      , geometryCount( static_cast<uint32_t>( !geometries_.empty() ? geometries_.size() : pGeometries_.size() ) )
      , pGeometries( geometries_.data() )
      , ppGeometries( pGeometries_.data() )
      , scratchData( scratchData_ )
    {
#    ifdef VULKAN_HPP_NO_EXCEPTIONS
      VULKAN_HPP_ASSERT( ( !geometries_.empty() + !pGeometries_.empty() ) <= 1 );
#    else
      if ( 1 < ( !geometries_.empty() + !pGeometries_.empty() ) )
      {
        throw LogicError(
          VULKAN_HPP_NAMESPACE_STRING
          "::AccelerationStructureBuildGeometryInfoKHR::AccelerationStructureBuildGeometryInfoKHR: 1 < ( !geometries_.empty() + !pGeometries_.empty() )" );
      }
#    endif /*VULKAN_HPP_NO_EXCEPTIONS*/
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureBuildGeometryInfoKHR & operator=( AccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildGeometryInfoKHR & operator=( VkAccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildGeometryInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setType( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
                            setFlags( VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
                            setMode( VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
                            setSrcAccelerationStructure( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR srcAccelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccelerationStructure = srcAccelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
                            setDstAccelerationStructure( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR dstAccelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccelerationStructure = dstAccelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setGeometryCount( uint32_t geometryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = geometryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
                            setPGeometries( const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * pGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      pGeometries = pGeometries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureBuildGeometryInfoKHR & setGeometries(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR> const & geometries_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = static_cast<uint32_t>( geometries_.size() );
      pGeometries   = geometries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
                            setPpGeometries( const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const * ppGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      ppGeometries = ppGeometries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureBuildGeometryInfoKHR &
      setPGeometries( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const> const & pGeometries_ )
        VULKAN_HPP_NOEXCEPT
    {
      geometryCount = static_cast<uint32_t>( pGeometries_.size() );
      ppGeometries  = pGeometries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
                            setScratchData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const & scratchData_ ) VULKAN_HPP_NOEXCEPT
    {
      scratchData = scratchData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureBuildGeometryInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureBuildGeometryInfoKHR *>( this );
    }

    explicit operator VkAccelerationStructureBuildGeometryInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureBuildGeometryInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR const &,
               VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR const &,
               VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const &,
               const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const * const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, type, flags, mode, srcAccelerationStructure, dstAccelerationStructure, geometryCount, pGeometries, ppGeometries, scratchData );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                                    sType = StructureType::eAccelerationStructureBuildGeometryInfoKHR;
    const void *                                                           pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR                     type  = VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR::eTopLevel;
    VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsKHR               flags = {};
    VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR                mode  = VULKAN_HPP_NAMESPACE::BuildAccelerationStructureModeKHR::eBuild;
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                         srcAccelerationStructure = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR                         dstAccelerationStructure = {};
    uint32_t                                                               geometryCount            = {};
    const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR *         pGeometries              = {};
    const VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryKHR * const * ppGeometries             = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR                           scratchData              = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureBuildGeometryInfoKHR ) == sizeof( VkAccelerationStructureBuildGeometryInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildGeometryInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildGeometryInfoKHR>::value,
                            "AccelerationStructureBuildGeometryInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureBuildGeometryInfoKHR>
  {
    using Type = AccelerationStructureBuildGeometryInfoKHR;
  };

  struct AccelerationStructureBuildRangeInfoKHR
  {
    using NativeType = VkAccelerationStructureBuildRangeInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildRangeInfoKHR( uint32_t primitiveCount_  = {},
                                                                 uint32_t primitiveOffset_ = {},
                                                                 uint32_t firstVertex_     = {},
                                                                 uint32_t transformOffset_ = {} ) VULKAN_HPP_NOEXCEPT
      : primitiveCount( primitiveCount_ )
      , primitiveOffset( primitiveOffset_ )
      , firstVertex( firstVertex_ )
      , transformOffset( transformOffset_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildRangeInfoKHR( AccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildRangeInfoKHR( VkAccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureBuildRangeInfoKHR( *reinterpret_cast<AccelerationStructureBuildRangeInfoKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureBuildRangeInfoKHR & operator=( AccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildRangeInfoKHR & operator=( VkAccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildRangeInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR & setPrimitiveCount( uint32_t primitiveCount_ ) VULKAN_HPP_NOEXCEPT
    {
      primitiveCount = primitiveCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR & setPrimitiveOffset( uint32_t primitiveOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      primitiveOffset = primitiveOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR & setFirstVertex( uint32_t firstVertex_ ) VULKAN_HPP_NOEXCEPT
    {
      firstVertex = firstVertex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR & setTransformOffset( uint32_t transformOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      transformOffset = transformOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureBuildRangeInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureBuildRangeInfoKHR *>( this );
    }

    explicit operator VkAccelerationStructureBuildRangeInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureBuildRangeInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( primitiveCount, primitiveOffset, firstVertex, transformOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureBuildRangeInfoKHR const & ) const = default;
#else
    bool                                            operator==( AccelerationStructureBuildRangeInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( primitiveCount == rhs.primitiveCount ) && ( primitiveOffset == rhs.primitiveOffset ) && ( firstVertex == rhs.firstVertex ) &&
             ( transformOffset == rhs.transformOffset );
#  endif
    }

    bool operator!=( AccelerationStructureBuildRangeInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t primitiveCount  = {};
    uint32_t primitiveOffset = {};
    uint32_t firstVertex     = {};
    uint32_t transformOffset = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureBuildRangeInfoKHR ) == sizeof( VkAccelerationStructureBuildRangeInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildRangeInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildRangeInfoKHR>::value,
                            "AccelerationStructureBuildRangeInfoKHR is not nothrow_move_constructible!" );

  struct AccelerationStructureBuildSizesInfoKHR
  {
    using NativeType = VkAccelerationStructureBuildSizesInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureBuildSizesInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildSizesInfoKHR( VULKAN_HPP_NAMESPACE::DeviceSize accelerationStructureSize_ = {},
                                                                 VULKAN_HPP_NAMESPACE::DeviceSize updateScratchSize_         = {},
                                                                 VULKAN_HPP_NAMESPACE::DeviceSize buildScratchSize_          = {},
                                                                 const void *                     pNext_                     = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , accelerationStructureSize( accelerationStructureSize_ )
      , updateScratchSize( updateScratchSize_ )
      , buildScratchSize( buildScratchSize_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildSizesInfoKHR( AccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildSizesInfoKHR( VkAccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureBuildSizesInfoKHR( *reinterpret_cast<AccelerationStructureBuildSizesInfoKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureBuildSizesInfoKHR & operator=( AccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildSizesInfoKHR & operator=( VkAccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildSizesInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildSizesInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildSizesInfoKHR &
                            setAccelerationStructureSize( VULKAN_HPP_NAMESPACE::DeviceSize accelerationStructureSize_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureSize = accelerationStructureSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildSizesInfoKHR &
                            setUpdateScratchSize( VULKAN_HPP_NAMESPACE::DeviceSize updateScratchSize_ ) VULKAN_HPP_NOEXCEPT
    {
      updateScratchSize = updateScratchSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildSizesInfoKHR &
                            setBuildScratchSize( VULKAN_HPP_NAMESPACE::DeviceSize buildScratchSize_ ) VULKAN_HPP_NOEXCEPT
    {
      buildScratchSize = buildScratchSize_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureBuildSizesInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureBuildSizesInfoKHR *>( this );
    }

    explicit operator VkAccelerationStructureBuildSizesInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureBuildSizesInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, accelerationStructureSize, updateScratchSize, buildScratchSize );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureBuildSizesInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureBuildSizesInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( accelerationStructureSize == rhs.accelerationStructureSize ) &&
             ( updateScratchSize == rhs.updateScratchSize ) && ( buildScratchSize == rhs.buildScratchSize );
#  endif
    }

    bool operator!=( AccelerationStructureBuildSizesInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                     = StructureType::eAccelerationStructureBuildSizesInfoKHR;
    const void *                        pNext                     = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    accelerationStructureSize = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    updateScratchSize         = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    buildScratchSize          = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureBuildSizesInfoKHR ) == sizeof( VkAccelerationStructureBuildSizesInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildSizesInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureBuildSizesInfoKHR>::value,
                            "AccelerationStructureBuildSizesInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureBuildSizesInfoKHR>
  {
    using Type = AccelerationStructureBuildSizesInfoKHR;
  };

  struct AccelerationStructureCreateInfoKHR
  {
    using NativeType = VkAccelerationStructureCreateInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureCreateInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureCreateFlagsKHR createFlags_   = {},
      VULKAN_HPP_NAMESPACE::Buffer                              buffer_        = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                          offset_        = {},
      VULKAN_HPP_NAMESPACE::DeviceSize                          size_          = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR        type_          = VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR::eTopLevel,
      VULKAN_HPP_NAMESPACE::DeviceAddress                       deviceAddress_ = {},
      const void *                                              pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , createFlags( createFlags_ )
      , buffer( buffer_ )
      , offset( offset_ )
      , size( size_ )
      , type( type_ )
      , deviceAddress( deviceAddress_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoKHR( AccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCreateInfoKHR( VkAccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureCreateInfoKHR( *reinterpret_cast<AccelerationStructureCreateInfoKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureCreateInfoKHR & operator=( AccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCreateInfoKHR & operator=( VkAccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR &
                            setCreateFlags( VULKAN_HPP_NAMESPACE::AccelerationStructureCreateFlagsKHR createFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      createFlags = createFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setType( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureCreateInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureCreateInfoKHR *>( this );
    }

    explicit operator VkAccelerationStructureCreateInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureCreateInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureCreateFlagsKHR const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, createFlags, buffer, offset, size, type, deviceAddress );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureCreateInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( createFlags == rhs.createFlags ) && ( buffer == rhs.buffer ) && ( offset == rhs.offset ) &&
             ( size == rhs.size ) && ( type == rhs.type ) && ( deviceAddress == rhs.deviceAddress );
#  endif
    }

    bool operator!=( AccelerationStructureCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                       sType         = StructureType::eAccelerationStructureCreateInfoKHR;
    const void *                                              pNext         = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureCreateFlagsKHR createFlags   = {};
    VULKAN_HPP_NAMESPACE::Buffer                              buffer        = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                          offset        = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                          size          = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR        type          = VULKAN_HPP_NAMESPACE::AccelerationStructureTypeKHR::eTopLevel;
    VULKAN_HPP_NAMESPACE::DeviceAddress                       deviceAddress = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoKHR ) == sizeof( VkAccelerationStructureCreateInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoKHR>::value,
                            "AccelerationStructureCreateInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureCreateInfoKHR>
  {
    using Type = AccelerationStructureCreateInfoKHR;
  };

  struct GeometryTrianglesNV
  {
    using NativeType = VkGeometryTrianglesNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eGeometryTrianglesNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryTrianglesNV( VULKAN_HPP_NAMESPACE::Buffer     vertexData_      = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize vertexOffset_    = {},
                                              uint32_t                         vertexCount_     = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize vertexStride_    = {},
                                              VULKAN_HPP_NAMESPACE::Format     vertexFormat_    = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                              VULKAN_HPP_NAMESPACE::Buffer     indexData_       = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize indexOffset_     = {},
                                              uint32_t                         indexCount_      = {},
                                              VULKAN_HPP_NAMESPACE::IndexType  indexType_       = VULKAN_HPP_NAMESPACE::IndexType::eUint16,
                                              VULKAN_HPP_NAMESPACE::Buffer     transformData_   = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize transformOffset_ = {},
                                              const void *                     pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , vertexData( vertexData_ )
      , vertexOffset( vertexOffset_ )
      , vertexCount( vertexCount_ )
      , vertexStride( vertexStride_ )
      , vertexFormat( vertexFormat_ )
      , indexData( indexData_ )
      , indexOffset( indexOffset_ )
      , indexCount( indexCount_ )
      , indexType( indexType_ )
      , transformData( transformData_ )
      , transformOffset( transformOffset_ )
    {
    }

    VULKAN_HPP_CONSTEXPR GeometryTrianglesNV( GeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryTrianglesNV( VkGeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT : GeometryTrianglesNV( *reinterpret_cast<GeometryTrianglesNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    GeometryTrianglesNV & operator=( GeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryTrianglesNV & operator=( VkGeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::GeometryTrianglesNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexData( VULKAN_HPP_NAMESPACE::Buffer vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexOffset( VULKAN_HPP_NAMESPACE::DeviceSize vertexOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexOffset = vertexOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexCount( uint32_t vertexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexCount = vertexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexStride( VULKAN_HPP_NAMESPACE::DeviceSize vertexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexStride = vertexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexFormat( VULKAN_HPP_NAMESPACE::Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setIndexData( VULKAN_HPP_NAMESPACE::Buffer indexData_ ) VULKAN_HPP_NOEXCEPT
    {
      indexData = indexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setIndexOffset( VULKAN_HPP_NAMESPACE::DeviceSize indexOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      indexOffset = indexOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setIndexCount( uint32_t indexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      indexCount = indexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setTransformData( VULKAN_HPP_NAMESPACE::Buffer transformData_ ) VULKAN_HPP_NOEXCEPT
    {
      transformData = transformData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setTransformOffset( VULKAN_HPP_NAMESPACE::DeviceSize transformOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      transformOffset = transformOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkGeometryTrianglesNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryTrianglesNV *>( this );
    }

    explicit operator VkGeometryTrianglesNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryTrianglesNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::IndexType const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       vertexData,
                       vertexOffset,
                       vertexCount,
                       vertexStride,
                       vertexFormat,
                       indexData,
                       indexOffset,
                       indexCount,
                       indexType,
                       transformData,
                       transformOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryTrianglesNV const & ) const = default;
#else
    bool operator==( GeometryTrianglesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( vertexData == rhs.vertexData ) && ( vertexOffset == rhs.vertexOffset ) &&
             ( vertexCount == rhs.vertexCount ) && ( vertexStride == rhs.vertexStride ) && ( vertexFormat == rhs.vertexFormat ) &&
             ( indexData == rhs.indexData ) && ( indexOffset == rhs.indexOffset ) && ( indexCount == rhs.indexCount ) && ( indexType == rhs.indexType ) &&
             ( transformData == rhs.transformData ) && ( transformOffset == rhs.transformOffset );
#  endif
    }

    bool operator!=( GeometryTrianglesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType           = StructureType::eGeometryTrianglesNV;
    const void *                        pNext           = {};
    VULKAN_HPP_NAMESPACE::Buffer        vertexData      = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    vertexOffset    = {};
    uint32_t                            vertexCount     = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    vertexStride    = {};
    VULKAN_HPP_NAMESPACE::Format        vertexFormat    = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::Buffer        indexData       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    indexOffset     = {};
    uint32_t                            indexCount      = {};
    VULKAN_HPP_NAMESPACE::IndexType     indexType       = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
    VULKAN_HPP_NAMESPACE::Buffer        transformData   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    transformOffset = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::GeometryTrianglesNV ) == sizeof( VkGeometryTrianglesNV ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::GeometryTrianglesNV>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::GeometryTrianglesNV>::value,
                            "GeometryTrianglesNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eGeometryTrianglesNV>
  {
    using Type = GeometryTrianglesNV;
  };

  struct GeometryAABBNV
  {
    using NativeType = VkGeometryAABBNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eGeometryAabbNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryAABBNV( VULKAN_HPP_NAMESPACE::Buffer     aabbData_ = {},
                                         uint32_t                         numAABBs_ = {},
                                         uint32_t                         stride_   = {},
                                         VULKAN_HPP_NAMESPACE::DeviceSize offset_   = {},
                                         const void *                     pNext_    = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , aabbData( aabbData_ )
      , numAABBs( numAABBs_ )
      , stride( stride_ )
      , offset( offset_ )
    {
    }

    VULKAN_HPP_CONSTEXPR GeometryAABBNV( GeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryAABBNV( VkGeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT : GeometryAABBNV( *reinterpret_cast<GeometryAABBNV const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    GeometryAABBNV & operator=( GeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryAABBNV & operator=( VkGeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::GeometryAABBNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setAabbData( VULKAN_HPP_NAMESPACE::Buffer aabbData_ ) VULKAN_HPP_NOEXCEPT
    {
      aabbData = aabbData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setNumAABBs( uint32_t numAABBs_ ) VULKAN_HPP_NOEXCEPT
    {
      numAABBs = numAABBs_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setStride( uint32_t stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkGeometryAABBNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryAABBNV *>( this );
    }

    explicit operator VkGeometryAABBNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryAABBNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, aabbData, numAABBs, stride, offset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryAABBNV const & ) const = default;
#else
    bool operator==( GeometryAABBNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( aabbData == rhs.aabbData ) && ( numAABBs == rhs.numAABBs ) && ( stride == rhs.stride ) &&
             ( offset == rhs.offset );
#  endif
    }

    bool operator!=( GeometryAABBNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType    = StructureType::eGeometryAabbNV;
    const void *                        pNext    = {};
    VULKAN_HPP_NAMESPACE::Buffer        aabbData = {};
    uint32_t                            numAABBs = {};
    uint32_t                            stride   = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    offset   = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::GeometryAABBNV ) == sizeof( VkGeometryAABBNV ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::GeometryAABBNV>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::GeometryAABBNV>::value,
                            "GeometryAABBNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eGeometryAabbNV>
  {
    using Type = GeometryAABBNV;
  };

  struct GeometryDataNV
  {
    using NativeType = VkGeometryDataNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryDataNV( VULKAN_HPP_NAMESPACE::GeometryTrianglesNV triangles_ = {},
                                         VULKAN_HPP_NAMESPACE::GeometryAABBNV      aabbs_     = {} ) VULKAN_HPP_NOEXCEPT
      : triangles( triangles_ )
      , aabbs( aabbs_ )
    {
    }

    VULKAN_HPP_CONSTEXPR GeometryDataNV( GeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryDataNV( VkGeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT : GeometryDataNV( *reinterpret_cast<GeometryDataNV const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    GeometryDataNV & operator=( GeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryDataNV & operator=( VkGeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::GeometryDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryDataNV & setTriangles( VULKAN_HPP_NAMESPACE::GeometryTrianglesNV const & triangles_ ) VULKAN_HPP_NOEXCEPT
    {
      triangles = triangles_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryDataNV & setAabbs( VULKAN_HPP_NAMESPACE::GeometryAABBNV const & aabbs_ ) VULKAN_HPP_NOEXCEPT
    {
      aabbs = aabbs_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkGeometryDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryDataNV *>( this );
    }

    explicit operator VkGeometryDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::GeometryTrianglesNV const &, VULKAN_HPP_NAMESPACE::GeometryAABBNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( triangles, aabbs );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryDataNV const & ) const = default;
#else
    bool operator==( GeometryDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( triangles == rhs.triangles ) && ( aabbs == rhs.aabbs );
#  endif
    }

    bool operator!=( GeometryDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::GeometryTrianglesNV triangles = {};
    VULKAN_HPP_NAMESPACE::GeometryAABBNV      aabbs     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::GeometryDataNV ) == sizeof( VkGeometryDataNV ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::GeometryDataNV>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::GeometryDataNV>::value,
                            "GeometryDataNV is not nothrow_move_constructible!" );

  struct GeometryNV
  {
    using NativeType = VkGeometryNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eGeometryNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryNV( VULKAN_HPP_NAMESPACE::GeometryTypeKHR  geometryType_ = VULKAN_HPP_NAMESPACE::GeometryTypeKHR::eTriangles,
                                     VULKAN_HPP_NAMESPACE::GeometryDataNV   geometry_     = {},
                                     VULKAN_HPP_NAMESPACE::GeometryFlagsKHR flags_        = {},
                                     const void *                           pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , geometryType( geometryType_ )
      , geometry( geometry_ )
      , flags( flags_ )
    {
    }

    VULKAN_HPP_CONSTEXPR GeometryNV( GeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryNV( VkGeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT : GeometryNV( *reinterpret_cast<GeometryNV const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    GeometryNV & operator=( GeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryNV & operator=( VkGeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::GeometryNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setGeometryType( VULKAN_HPP_NAMESPACE::GeometryTypeKHR geometryType_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryType = geometryType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setGeometry( VULKAN_HPP_NAMESPACE::GeometryDataNV const & geometry_ ) VULKAN_HPP_NOEXCEPT
    {
      geometry = geometry_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setFlags( VULKAN_HPP_NAMESPACE::GeometryFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkGeometryNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryNV *>( this );
    }

    explicit operator VkGeometryNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::GeometryTypeKHR const &,
               VULKAN_HPP_NAMESPACE::GeometryDataNV const &,
               VULKAN_HPP_NAMESPACE::GeometryFlagsKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, geometryType, geometry, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryNV const & ) const = default;
#else
    bool operator==( GeometryNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( geometryType == rhs.geometryType ) && ( geometry == rhs.geometry ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( GeometryNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType        = StructureType::eGeometryNV;
    const void *                           pNext        = {};
    VULKAN_HPP_NAMESPACE::GeometryTypeKHR  geometryType = VULKAN_HPP_NAMESPACE::GeometryTypeKHR::eTriangles;
    VULKAN_HPP_NAMESPACE::GeometryDataNV   geometry     = {};
    VULKAN_HPP_NAMESPACE::GeometryFlagsKHR flags        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::GeometryNV ) == sizeof( VkGeometryNV ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::GeometryNV>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::GeometryNV>::value, "GeometryNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eGeometryNV>
  {
    using Type = GeometryNV;
  };

  struct AccelerationStructureInfoNV
  {
    using NativeType = VkAccelerationStructureInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureInfoNV( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV       type_          = {},
                                                      VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV flags_         = {},
                                                      uint32_t                                                instanceCount_ = {},
                                                      uint32_t                                                geometryCount_ = {},
                                                      const VULKAN_HPP_NAMESPACE::GeometryNV *                pGeometries_   = {},
                                                      const void *                                            pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , type( type_ )
      , flags( flags_ )
      , instanceCount( instanceCount_ )
      , geometryCount( geometryCount_ )
      , pGeometries( pGeometries_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureInfoNV( AccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureInfoNV( VkAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureInfoNV( *reinterpret_cast<AccelerationStructureInfoNV const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureInfoNV( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV                                             type_,
                                 VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV                                       flags_,
                                 uint32_t                                                                                      instanceCount_,
                                 VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::GeometryNV> const & geometries_,
                                 const void *                                                                                  pNext_ = nullptr )
      : pNext( pNext_ )
      , type( type_ )
      , flags( flags_ )
      , instanceCount( instanceCount_ )
      , geometryCount( static_cast<uint32_t>( geometries_.size() ) )
      , pGeometries( geometries_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureInfoNV & operator=( AccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureInfoNV & operator=( VkAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setType( VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setFlags( VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setInstanceCount( uint32_t instanceCount_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCount = instanceCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setGeometryCount( uint32_t geometryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = geometryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setPGeometries( const VULKAN_HPP_NAMESPACE::GeometryNV * pGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      pGeometries = pGeometries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureInfoNV &
      setGeometries( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::GeometryNV> const & geometries_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = static_cast<uint32_t>( geometries_.size() );
      pGeometries   = geometries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureInfoNV *>( this );
    }

    explicit operator VkAccelerationStructureInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV const &,
               VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV const &,
               uint32_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::GeometryNV * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, type, flags, instanceCount, geometryCount, pGeometries );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( type == rhs.type ) && ( flags == rhs.flags ) && ( instanceCount == rhs.instanceCount ) &&
             ( geometryCount == rhs.geometryCount ) && ( pGeometries == rhs.pGeometries );
#  endif
    }

    bool operator!=( AccelerationStructureInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                     sType         = StructureType::eAccelerationStructureInfoNV;
    const void *                                            pNext         = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureTypeNV       type          = {};
    VULKAN_HPP_NAMESPACE::BuildAccelerationStructureFlagsNV flags         = {};
    uint32_t                                                instanceCount = {};
    uint32_t                                                geometryCount = {};
    const VULKAN_HPP_NAMESPACE::GeometryNV *                pGeometries   = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV ) == sizeof( VkAccelerationStructureInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV>::value,
                            "AccelerationStructureInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureInfoNV>
  {
    using Type = AccelerationStructureInfoNV;
  };

  struct AccelerationStructureCreateInfoNV
  {
    using NativeType = VkAccelerationStructureCreateInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureCreateInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoNV( VULKAN_HPP_NAMESPACE::DeviceSize                  compactedSize_ = {},
                                                            VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV info_          = {},
                                                            const void *                                      pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , compactedSize( compactedSize_ )
      , info( info_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoNV( AccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCreateInfoNV( VkAccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureCreateInfoNV( *reinterpret_cast<AccelerationStructureCreateInfoNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureCreateInfoNV & operator=( AccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCreateInfoNV & operator=( VkAccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoNV & setCompactedSize( VULKAN_HPP_NAMESPACE::DeviceSize compactedSize_ ) VULKAN_HPP_NOEXCEPT
    {
      compactedSize = compactedSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoNV & setInfo( VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV const & info_ ) VULKAN_HPP_NOEXCEPT
    {
      info = info_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureCreateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureCreateInfoNV *>( this );
    }

    explicit operator VkAccelerationStructureCreateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureCreateInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, compactedSize, info );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureCreateInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( compactedSize == rhs.compactedSize ) && ( info == rhs.info );
#  endif
    }

    bool operator!=( AccelerationStructureCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType         = StructureType::eAccelerationStructureCreateInfoNV;
    const void *                                      pNext         = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                  compactedSize = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureInfoNV info          = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoNV ) == sizeof( VkAccelerationStructureCreateInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureCreateInfoNV>::value,
                            "AccelerationStructureCreateInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureCreateInfoNV>
  {
    using Type = AccelerationStructureCreateInfoNV;
  };

  struct AccelerationStructureDeviceAddressInfoKHR
  {
    using NativeType = VkAccelerationStructureDeviceAddressInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureDeviceAddressInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureDeviceAddressInfoKHR( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR accelerationStructure_ = {},
                                                                    const void *                                   pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , accelerationStructure( accelerationStructure_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureDeviceAddressInfoKHR( AccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureDeviceAddressInfoKHR( VkAccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureDeviceAddressInfoKHR( *reinterpret_cast<AccelerationStructureDeviceAddressInfoKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureDeviceAddressInfoKHR & operator=( AccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureDeviceAddressInfoKHR & operator=( VkAccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureDeviceAddressInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureDeviceAddressInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureDeviceAddressInfoKHR &
                            setAccelerationStructure( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureDeviceAddressInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureDeviceAddressInfoKHR *>( this );
    }

    explicit operator VkAccelerationStructureDeviceAddressInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureDeviceAddressInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, accelerationStructure );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureDeviceAddressInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureDeviceAddressInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( accelerationStructure == rhs.accelerationStructure );
#  endif
    }

    bool operator!=( AccelerationStructureDeviceAddressInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType                 = StructureType::eAccelerationStructureDeviceAddressInfoKHR;
    const void *                                   pNext                 = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR accelerationStructure = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureDeviceAddressInfoKHR ) == sizeof( VkAccelerationStructureDeviceAddressInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureDeviceAddressInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureDeviceAddressInfoKHR>::value,
                            "AccelerationStructureDeviceAddressInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureDeviceAddressInfoKHR>
  {
    using Type = AccelerationStructureDeviceAddressInfoKHR;
  };

  struct AccelerationStructureGeometryMotionTrianglesDataNV
  {
    using NativeType = VkAccelerationStructureGeometryMotionTrianglesDataNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryMotionTrianglesDataNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryMotionTrianglesDataNV( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData_ = {},
                                                                                const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , vertexData( vertexData_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryMotionTrianglesDataNV( AccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryMotionTrianglesDataNV( VkAccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryMotionTrianglesDataNV( *reinterpret_cast<AccelerationStructureGeometryMotionTrianglesDataNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureGeometryMotionTrianglesDataNV &
      operator=( AccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryMotionTrianglesDataNV & operator=( VkAccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryMotionTrianglesDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryMotionTrianglesDataNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryMotionTrianglesDataNV &
                            setVertexData( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureGeometryMotionTrianglesDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryMotionTrianglesDataNV *>( this );
    }

    explicit operator VkAccelerationStructureGeometryMotionTrianglesDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryMotionTrianglesDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, vertexData );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType      = StructureType::eAccelerationStructureGeometryMotionTrianglesDataNV;
    const void *                                      pNext      = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR vertexData = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryMotionTrianglesDataNV ) ==
                              sizeof( VkAccelerationStructureGeometryMotionTrianglesDataNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryMotionTrianglesDataNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureGeometryMotionTrianglesDataNV>::value,
                            "AccelerationStructureGeometryMotionTrianglesDataNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryMotionTrianglesDataNV>
  {
    using Type = AccelerationStructureGeometryMotionTrianglesDataNV;
  };

  struct TransformMatrixKHR
  {
    using NativeType = VkTransformMatrixKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 TransformMatrixKHR( std::array<std::array<float, 4>, 3> const & matrix_ = {} ) VULKAN_HPP_NOEXCEPT : matrix( matrix_ ) {}

    VULKAN_HPP_CONSTEXPR_14 TransformMatrixKHR( TransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    TransformMatrixKHR( VkTransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT : TransformMatrixKHR( *reinterpret_cast<TransformMatrixKHR const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    TransformMatrixKHR & operator=( TransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    TransformMatrixKHR & operator=( VkTransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::TransformMatrixKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 TransformMatrixKHR & setMatrix( std::array<std::array<float, 4>, 3> matrix_ ) VULKAN_HPP_NOEXCEPT
    {
      matrix = matrix_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkTransformMatrixKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkTransformMatrixKHR *>( this );
    }

    explicit operator VkTransformMatrixKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkTransformMatrixKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ArrayWrapper2D<float, 3, 4> const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( matrix );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( TransformMatrixKHR const & ) const = default;
#else
    bool operator==( TransformMatrixKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( matrix == rhs.matrix );
#  endif
    }

    bool operator!=( TransformMatrixKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ArrayWrapper2D<float, 3, 4> matrix = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::TransformMatrixKHR ) == sizeof( VkTransformMatrixKHR ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::TransformMatrixKHR>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::TransformMatrixKHR>::value,
                            "TransformMatrixKHR is not nothrow_move_constructible!" );
  using TransformMatrixNV = TransformMatrixKHR;

  struct AccelerationStructureInstanceKHR
  {
    using NativeType = VkAccelerationStructureInstanceKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR( VULKAN_HPP_NAMESPACE::TransformMatrixKHR       transform_                              = {},
                                                              uint32_t                                       instanceCustomIndex_                    = {},
                                                              uint32_t                                       mask_                                   = {},
                                                              uint32_t                                       instanceShaderBindingTableRecordOffset_ = {},
                                                              VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_                                  = {},
                                                              uint64_t accelerationStructureReference_ = {} ) VULKAN_HPP_NOEXCEPT
      : transform( transform_ )
      , instanceCustomIndex( instanceCustomIndex_ )
      , mask( mask_ )
      , instanceShaderBindingTableRecordOffset( instanceShaderBindingTableRecordOffset_ )
      , flags( flags_ )
      , accelerationStructureReference( accelerationStructureReference_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR( AccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureInstanceKHR( VkAccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureInstanceKHR( *reinterpret_cast<AccelerationStructureInstanceKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureInstanceKHR & operator=( AccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureInstanceKHR & operator=( VkAccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR & setTransform( VULKAN_HPP_NAMESPACE::TransformMatrixKHR const & transform_ ) VULKAN_HPP_NOEXCEPT
    {
      transform = transform_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR & setInstanceCustomIndex( uint32_t instanceCustomIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCustomIndex = instanceCustomIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR & setMask( uint32_t mask_ ) VULKAN_HPP_NOEXCEPT
    {
      mask = mask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR &
                            setInstanceShaderBindingTableRecordOffset( uint32_t instanceShaderBindingTableRecordOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceShaderBindingTableRecordOffset = instanceShaderBindingTableRecordOffset_;
      return *this;
    }

    AccelerationStructureInstanceKHR & setFlags( VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = *reinterpret_cast<VkGeometryInstanceFlagsKHR *>( &flags_ );
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR & setAccelerationStructureReference( uint64_t accelerationStructureReference_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureReference = accelerationStructureReference_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureInstanceKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureInstanceKHR *>( this );
    }

    explicit operator VkAccelerationStructureInstanceKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureInstanceKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::TransformMatrixKHR const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VkGeometryInstanceFlagsKHR const &,
               uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( transform, instanceCustomIndex, mask, instanceShaderBindingTableRecordOffset, flags, accelerationStructureReference );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureInstanceKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureInstanceKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( transform == rhs.transform ) && ( instanceCustomIndex == rhs.instanceCustomIndex ) && ( mask == rhs.mask ) &&
             ( instanceShaderBindingTableRecordOffset == rhs.instanceShaderBindingTableRecordOffset ) && ( flags == rhs.flags ) &&
             ( accelerationStructureReference == rhs.accelerationStructureReference );
#  endif
    }

    bool operator!=( AccelerationStructureInstanceKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::TransformMatrixKHR transform = {};
    uint32_t                                 instanceCustomIndex : 24;
    uint32_t                                 mask : 8;
    uint32_t                                 instanceShaderBindingTableRecordOffset : 24;
    VkGeometryInstanceFlagsKHR               flags : 8;
    uint64_t                                 accelerationStructureReference = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR ) == sizeof( VkAccelerationStructureInstanceKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR>::value,
                            "AccelerationStructureInstanceKHR is not nothrow_move_constructible!" );
  using AccelerationStructureInstanceNV = AccelerationStructureInstanceKHR;

  struct AccelerationStructureMatrixMotionInstanceNV
  {
    using NativeType = VkAccelerationStructureMatrixMotionInstanceNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV( VULKAN_HPP_NAMESPACE::TransformMatrixKHR transformT0_                            = {},
                                                                         VULKAN_HPP_NAMESPACE::TransformMatrixKHR transformT1_                            = {},
                                                                         uint32_t                                 instanceCustomIndex_                    = {},
                                                                         uint32_t                                 mask_                                   = {},
                                                                         uint32_t                                 instanceShaderBindingTableRecordOffset_ = {},
                                                                         VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_                            = {},
                                                                         uint64_t accelerationStructureReference_ = {} ) VULKAN_HPP_NOEXCEPT
      : transformT0( transformT0_ )
      , transformT1( transformT1_ )
      , instanceCustomIndex( instanceCustomIndex_ )
      , mask( mask_ )
      , instanceShaderBindingTableRecordOffset( instanceShaderBindingTableRecordOffset_ )
      , flags( flags_ )
      , accelerationStructureReference( accelerationStructureReference_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureMatrixMotionInstanceNV( AccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMatrixMotionInstanceNV( VkAccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMatrixMotionInstanceNV( *reinterpret_cast<AccelerationStructureMatrixMotionInstanceNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureMatrixMotionInstanceNV & operator=( AccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMatrixMotionInstanceNV & operator=( VkAccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
                            setTransformT0( VULKAN_HPP_NAMESPACE::TransformMatrixKHR const & transformT0_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT0 = transformT0_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
                            setTransformT1( VULKAN_HPP_NAMESPACE::TransformMatrixKHR const & transformT1_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT1 = transformT1_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV & setInstanceCustomIndex( uint32_t instanceCustomIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCustomIndex = instanceCustomIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV & setMask( uint32_t mask_ ) VULKAN_HPP_NOEXCEPT
    {
      mask = mask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
                            setInstanceShaderBindingTableRecordOffset( uint32_t instanceShaderBindingTableRecordOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceShaderBindingTableRecordOffset = instanceShaderBindingTableRecordOffset_;
      return *this;
    }

    AccelerationStructureMatrixMotionInstanceNV & setFlags( VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = *reinterpret_cast<VkGeometryInstanceFlagsKHR *>( &flags_ );
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
                            setAccelerationStructureReference( uint64_t accelerationStructureReference_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureReference = accelerationStructureReference_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureMatrixMotionInstanceNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMatrixMotionInstanceNV *>( this );
    }

    explicit operator VkAccelerationStructureMatrixMotionInstanceNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMatrixMotionInstanceNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::TransformMatrixKHR const &,
               VULKAN_HPP_NAMESPACE::TransformMatrixKHR const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VkGeometryInstanceFlagsKHR const &,
               uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( transformT0, transformT1, instanceCustomIndex, mask, instanceShaderBindingTableRecordOffset, flags, accelerationStructureReference );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureMatrixMotionInstanceNV const & ) const = default;
#else
    bool operator==( AccelerationStructureMatrixMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( transformT0 == rhs.transformT0 ) && ( transformT1 == rhs.transformT1 ) && ( instanceCustomIndex == rhs.instanceCustomIndex ) &&
             ( mask == rhs.mask ) && ( instanceShaderBindingTableRecordOffset == rhs.instanceShaderBindingTableRecordOffset ) && ( flags == rhs.flags ) &&
             ( accelerationStructureReference == rhs.accelerationStructureReference );
#  endif
    }

    bool operator!=( AccelerationStructureMatrixMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::TransformMatrixKHR transformT0 = {};
    VULKAN_HPP_NAMESPACE::TransformMatrixKHR transformT1 = {};
    uint32_t                                 instanceCustomIndex : 24;
    uint32_t                                 mask : 8;
    uint32_t                                 instanceShaderBindingTableRecordOffset : 24;
    VkGeometryInstanceFlagsKHR               flags : 8;
    uint64_t                                 accelerationStructureReference = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV ) ==
                              sizeof( VkAccelerationStructureMatrixMotionInstanceNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV>::value,
                            "AccelerationStructureMatrixMotionInstanceNV is not nothrow_move_constructible!" );

  struct AccelerationStructureMemoryRequirementsInfoNV
  {
    using NativeType = VkAccelerationStructureMemoryRequirementsInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureMemoryRequirementsInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureMemoryRequirementsInfoNV(
      VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV type_ = VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV::eObject,
      VULKAN_HPP_NAMESPACE::AccelerationStructureNV                       accelerationStructure_ = {},
      const void *                                                        pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , type( type_ )
      , accelerationStructure( accelerationStructure_ )
    {
    }

    VULKAN_HPP_CONSTEXPR
      AccelerationStructureMemoryRequirementsInfoNV( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMemoryRequirementsInfoNV( VkAccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMemoryRequirementsInfoNV( *reinterpret_cast<AccelerationStructureMemoryRequirementsInfoNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureMemoryRequirementsInfoNV & operator=( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMemoryRequirementsInfoNV & operator=( VkAccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMemoryRequirementsInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMemoryRequirementsInfoNV &
                            setType( VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMemoryRequirementsInfoNV &
                            setAccelerationStructure( VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureMemoryRequirementsInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMemoryRequirementsInfoNV *>( this );
    }

    explicit operator VkAccelerationStructureMemoryRequirementsInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMemoryRequirementsInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, type, accelerationStructure );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureMemoryRequirementsInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( type == rhs.type ) && ( accelerationStructure == rhs.accelerationStructure );
#  endif
    }

    bool operator!=( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                                 sType = StructureType::eAccelerationStructureMemoryRequirementsInfoNV;
    const void *                                                        pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV type  = VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsTypeNV::eObject;
    VULKAN_HPP_NAMESPACE::AccelerationStructureNV                       accelerationStructure = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsInfoNV ) ==
                              sizeof( VkAccelerationStructureMemoryRequirementsInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureMemoryRequirementsInfoNV>::value,
                            "AccelerationStructureMemoryRequirementsInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureMemoryRequirementsInfoNV>
  {
    using Type = AccelerationStructureMemoryRequirementsInfoNV;
  };

  struct AccelerationStructureMotionInfoNV
  {
    using NativeType = VkAccelerationStructureMotionInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureMotionInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureMotionInfoNV( uint32_t                                                     maxInstances_ = {},
                                                            VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoFlagsNV flags_        = {},
                                                            const void *                                                 pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , maxInstances( maxInstances_ )
      , flags( flags_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureMotionInfoNV( AccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMotionInfoNV( VkAccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMotionInfoNV( *reinterpret_cast<AccelerationStructureMotionInfoNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureMotionInfoNV & operator=( AccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMotionInfoNV & operator=( VkAccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInfoNV & setMaxInstances( uint32_t maxInstances_ ) VULKAN_HPP_NOEXCEPT
    {
      maxInstances = maxInstances_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInfoNV &
                            setFlags( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoFlagsNV flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureMotionInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMotionInfoNV *>( this );
    }

    explicit operator VkAccelerationStructureMotionInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMotionInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoFlagsNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, maxInstances, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureMotionInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureMotionInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( maxInstances == rhs.maxInstances ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( AccelerationStructureMotionInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                          sType        = StructureType::eAccelerationStructureMotionInfoNV;
    const void *                                                 pNext        = {};
    uint32_t                                                     maxInstances = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoFlagsNV flags        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoNV ) == sizeof( VkAccelerationStructureMotionInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInfoNV>::value,
                            "AccelerationStructureMotionInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureMotionInfoNV>
  {
    using Type = AccelerationStructureMotionInfoNV;
  };

  struct SRTDataNV
  {
    using NativeType = VkSRTDataNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SRTDataNV( float sx_  = {},
                                    float a_   = {},
                                    float b_   = {},
                                    float pvx_ = {},
                                    float sy_  = {},
                                    float c_   = {},
                                    float pvy_ = {},
                                    float sz_  = {},
                                    float pvz_ = {},
                                    float qx_  = {},
                                    float qy_  = {},
                                    float qz_  = {},
                                    float qw_  = {},
                                    float tx_  = {},
                                    float ty_  = {},
                                    float tz_  = {} ) VULKAN_HPP_NOEXCEPT
      : sx( sx_ )
      , a( a_ )
      , b( b_ )
      , pvx( pvx_ )
      , sy( sy_ )
      , c( c_ )
      , pvy( pvy_ )
      , sz( sz_ )
      , pvz( pvz_ )
      , qx( qx_ )
      , qy( qy_ )
      , qz( qz_ )
      , qw( qw_ )
      , tx( tx_ )
      , ty( ty_ )
      , tz( tz_ )
    {
    }

    VULKAN_HPP_CONSTEXPR SRTDataNV( SRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SRTDataNV( VkSRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT : SRTDataNV( *reinterpret_cast<SRTDataNV const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SRTDataNV & operator=( SRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SRTDataNV & operator=( VkSRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SRTDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setSx( float sx_ ) VULKAN_HPP_NOEXCEPT
    {
      sx = sx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setA( float a_ ) VULKAN_HPP_NOEXCEPT
    {
      a = a_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setB( float b_ ) VULKAN_HPP_NOEXCEPT
    {
      b = b_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setPvx( float pvx_ ) VULKAN_HPP_NOEXCEPT
    {
      pvx = pvx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setSy( float sy_ ) VULKAN_HPP_NOEXCEPT
    {
      sy = sy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setC( float c_ ) VULKAN_HPP_NOEXCEPT
    {
      c = c_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setPvy( float pvy_ ) VULKAN_HPP_NOEXCEPT
    {
      pvy = pvy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setSz( float sz_ ) VULKAN_HPP_NOEXCEPT
    {
      sz = sz_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setPvz( float pvz_ ) VULKAN_HPP_NOEXCEPT
    {
      pvz = pvz_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQx( float qx_ ) VULKAN_HPP_NOEXCEPT
    {
      qx = qx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQy( float qy_ ) VULKAN_HPP_NOEXCEPT
    {
      qy = qy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQz( float qz_ ) VULKAN_HPP_NOEXCEPT
    {
      qz = qz_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQw( float qw_ ) VULKAN_HPP_NOEXCEPT
    {
      qw = qw_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setTx( float tx_ ) VULKAN_HPP_NOEXCEPT
    {
      tx = tx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setTy( float ty_ ) VULKAN_HPP_NOEXCEPT
    {
      ty = ty_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setTz( float tz_ ) VULKAN_HPP_NOEXCEPT
    {
      tz = tz_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkSRTDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSRTDataNV *>( this );
    }

    explicit operator VkSRTDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSRTDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sx, a, b, pvx, sy, c, pvy, sz, pvz, qx, qy, qz, qw, tx, ty, tz );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SRTDataNV const & ) const = default;
#else
    bool operator==( SRTDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sx == rhs.sx ) && ( a == rhs.a ) && ( b == rhs.b ) && ( pvx == rhs.pvx ) && ( sy == rhs.sy ) && ( c == rhs.c ) && ( pvy == rhs.pvy ) &&
             ( sz == rhs.sz ) && ( pvz == rhs.pvz ) && ( qx == rhs.qx ) && ( qy == rhs.qy ) && ( qz == rhs.qz ) && ( qw == rhs.qw ) && ( tx == rhs.tx ) &&
             ( ty == rhs.ty ) && ( tz == rhs.tz );
#  endif
    }

    bool operator!=( SRTDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float sx  = {};
    float a   = {};
    float b   = {};
    float pvx = {};
    float sy  = {};
    float c   = {};
    float pvy = {};
    float sz  = {};
    float pvz = {};
    float qx  = {};
    float qy  = {};
    float qz  = {};
    float qw  = {};
    float tx  = {};
    float ty  = {};
    float tz  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SRTDataNV ) == sizeof( VkSRTDataNV ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SRTDataNV>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SRTDataNV>::value, "SRTDataNV is not nothrow_move_constructible!" );

  struct AccelerationStructureSRTMotionInstanceNV
  {
    using NativeType = VkAccelerationStructureSRTMotionInstanceNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureSRTMotionInstanceNV( VULKAN_HPP_NAMESPACE::SRTDataNV                transformT0_                            = {},
                                                                   VULKAN_HPP_NAMESPACE::SRTDataNV                transformT1_                            = {},
                                                                   uint32_t                                       instanceCustomIndex_                    = {},
                                                                   uint32_t                                       mask_                                   = {},
                                                                   uint32_t                                       instanceShaderBindingTableRecordOffset_ = {},
                                                                   VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_                                  = {},
                                                                   uint64_t accelerationStructureReference_ = {} ) VULKAN_HPP_NOEXCEPT
      : transformT0( transformT0_ )
      , transformT1( transformT1_ )
      , instanceCustomIndex( instanceCustomIndex_ )
      , mask( mask_ )
      , instanceShaderBindingTableRecordOffset( instanceShaderBindingTableRecordOffset_ )
      , flags( flags_ )
      , accelerationStructureReference( accelerationStructureReference_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureSRTMotionInstanceNV( AccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureSRTMotionInstanceNV( VkAccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureSRTMotionInstanceNV( *reinterpret_cast<AccelerationStructureSRTMotionInstanceNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureSRTMotionInstanceNV & operator=( AccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureSRTMotionInstanceNV & operator=( VkAccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
                            setTransformT0( VULKAN_HPP_NAMESPACE::SRTDataNV const & transformT0_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT0 = transformT0_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
                            setTransformT1( VULKAN_HPP_NAMESPACE::SRTDataNV const & transformT1_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT1 = transformT1_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV & setInstanceCustomIndex( uint32_t instanceCustomIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCustomIndex = instanceCustomIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV & setMask( uint32_t mask_ ) VULKAN_HPP_NOEXCEPT
    {
      mask = mask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
                            setInstanceShaderBindingTableRecordOffset( uint32_t instanceShaderBindingTableRecordOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceShaderBindingTableRecordOffset = instanceShaderBindingTableRecordOffset_;
      return *this;
    }

    AccelerationStructureSRTMotionInstanceNV & setFlags( VULKAN_HPP_NAMESPACE::GeometryInstanceFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = *reinterpret_cast<VkGeometryInstanceFlagsKHR *>( &flags_ );
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
                            setAccelerationStructureReference( uint64_t accelerationStructureReference_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureReference = accelerationStructureReference_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureSRTMotionInstanceNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureSRTMotionInstanceNV *>( this );
    }

    explicit operator VkAccelerationStructureSRTMotionInstanceNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureSRTMotionInstanceNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::SRTDataNV const &,
               VULKAN_HPP_NAMESPACE::SRTDataNV const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VkGeometryInstanceFlagsKHR const &,
               uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( transformT0, transformT1, instanceCustomIndex, mask, instanceShaderBindingTableRecordOffset, flags, accelerationStructureReference );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureSRTMotionInstanceNV const & ) const = default;
#else
    bool operator==( AccelerationStructureSRTMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( transformT0 == rhs.transformT0 ) && ( transformT1 == rhs.transformT1 ) && ( instanceCustomIndex == rhs.instanceCustomIndex ) &&
             ( mask == rhs.mask ) && ( instanceShaderBindingTableRecordOffset == rhs.instanceShaderBindingTableRecordOffset ) && ( flags == rhs.flags ) &&
             ( accelerationStructureReference == rhs.accelerationStructureReference );
#  endif
    }

    bool operator!=( AccelerationStructureSRTMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::SRTDataNV transformT0 = {};
    VULKAN_HPP_NAMESPACE::SRTDataNV transformT1 = {};
    uint32_t                        instanceCustomIndex : 24;
    uint32_t                        mask : 8;
    uint32_t                        instanceShaderBindingTableRecordOffset : 24;
    VkGeometryInstanceFlagsKHR      flags : 8;
    uint64_t                        accelerationStructureReference = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV ) == sizeof( VkAccelerationStructureSRTMotionInstanceNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV>::value,
                            "AccelerationStructureSRTMotionInstanceNV is not nothrow_move_constructible!" );

  union AccelerationStructureMotionInstanceDataNV
  {
    using NativeType = VkAccelerationStructureMotionInstanceDataNV;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV( VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR staticInstance_ = {} )
      : staticInstance( staticInstance_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV( VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV matrixMotionInstance_ )
      : matrixMotionInstance( matrixMotionInstance_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV( VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV srtMotionInstance_ )
      : srtMotionInstance( srtMotionInstance_ )
    {
    }
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV &
                            setStaticInstance( VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR const & staticInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      staticInstance = staticInstance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV &
      setMatrixMotionInstance( VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV const & matrixMotionInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      matrixMotionInstance = matrixMotionInstance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV &
      setSrtMotionInstance( VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV const & srtMotionInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      srtMotionInstance = srtMotionInstance_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkAccelerationStructureMotionInstanceDataNV const &() const
    {
      return *reinterpret_cast<const VkAccelerationStructureMotionInstanceDataNV *>( this );
    }

    operator VkAccelerationStructureMotionInstanceDataNV &()
    {
      return *reinterpret_cast<VkAccelerationStructureMotionInstanceDataNV *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::AccelerationStructureInstanceKHR            staticInstance;
    VULKAN_HPP_NAMESPACE::AccelerationStructureMatrixMotionInstanceNV matrixMotionInstance;
    VULKAN_HPP_NAMESPACE::AccelerationStructureSRTMotionInstanceNV    srtMotionInstance;
#else
    VkAccelerationStructureInstanceKHR            staticInstance;
    VkAccelerationStructureMatrixMotionInstanceNV matrixMotionInstance;
    VkAccelerationStructureSRTMotionInstanceNV    srtMotionInstance;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct AccelerationStructureMotionInstanceNV
  {
    using NativeType = VkAccelerationStructureMotionInstanceNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV(
      VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV  type_  = VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV::eStatic,
      VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceFlagsNV flags_ = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceDataNV  data_  = {} ) VULKAN_HPP_NOEXCEPT
      : type( type_ )
      , flags( flags_ )
      , data( data_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV( AccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMotionInstanceNV( VkAccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMotionInstanceNV( *reinterpret_cast<AccelerationStructureMotionInstanceNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureMotionInstanceNV & operator=( AccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMotionInstanceNV & operator=( VkAccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV &
                            setType( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV &
                            setFlags( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceFlagsNV flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV &
                            setData( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceDataNV const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      data = data_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureMotionInstanceNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMotionInstanceNV *>( this );
    }

    explicit operator VkAccelerationStructureMotionInstanceNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMotionInstanceNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceFlagsNV const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceDataNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( type, flags, data );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV  type  = VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceTypeNV::eStatic;
    VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceFlagsNV flags = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceDataNV  data  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceNV ) == sizeof( VkAccelerationStructureMotionInstanceNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureMotionInstanceNV>::value,
                            "AccelerationStructureMotionInstanceNV is not nothrow_move_constructible!" );

  struct AccelerationStructureVersionInfoKHR
  {
    using NativeType = VkAccelerationStructureVersionInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureVersionInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureVersionInfoKHR( const uint8_t * pVersionData_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , pVersionData( pVersionData_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureVersionInfoKHR( AccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureVersionInfoKHR( VkAccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureVersionInfoKHR( *reinterpret_cast<AccelerationStructureVersionInfoKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AccelerationStructureVersionInfoKHR & operator=( AccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureVersionInfoKHR & operator=( VkAccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AccelerationStructureVersionInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureVersionInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureVersionInfoKHR & setPVersionData( const uint8_t * pVersionData_ ) VULKAN_HPP_NOEXCEPT
    {
      pVersionData = pVersionData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAccelerationStructureVersionInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureVersionInfoKHR *>( this );
    }

    explicit operator VkAccelerationStructureVersionInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureVersionInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, const uint8_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pVersionData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureVersionInfoKHR const & ) const = default;
#else
    bool                                          operator==( AccelerationStructureVersionInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pVersionData == rhs.pVersionData );
#  endif
    }

    bool operator!=( AccelerationStructureVersionInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eAccelerationStructureVersionInfoKHR;
    const void *                        pNext        = {};
    const uint8_t *                     pVersionData = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AccelerationStructureVersionInfoKHR ) == sizeof( VkAccelerationStructureVersionInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AccelerationStructureVersionInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AccelerationStructureVersionInfoKHR>::value,
                            "AccelerationStructureVersionInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureVersionInfoKHR>
  {
    using Type = AccelerationStructureVersionInfoKHR;
  };

  struct AcquireNextImageInfoKHR
  {
    using NativeType = VkAcquireNextImageInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAcquireNextImageInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AcquireNextImageInfoKHR( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_  = {},
                                                  uint64_t                           timeout_    = {},
                                                  VULKAN_HPP_NAMESPACE::Semaphore    semaphore_  = {},
                                                  VULKAN_HPP_NAMESPACE::Fence        fence_      = {},
                                                  uint32_t                           deviceMask_ = {},
                                                  const void *                       pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , swapchain( swapchain_ )
      , timeout( timeout_ )
      , semaphore( semaphore_ )
      , fence( fence_ )
      , deviceMask( deviceMask_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AcquireNextImageInfoKHR( AcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireNextImageInfoKHR( VkAcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AcquireNextImageInfoKHR( *reinterpret_cast<AcquireNextImageInfoKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AcquireNextImageInfoKHR & operator=( AcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireNextImageInfoKHR & operator=( VkAcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AcquireNextImageInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setSwapchain( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_ ) VULKAN_HPP_NOEXCEPT
    {
      swapchain = swapchain_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setTimeout( uint64_t timeout_ ) VULKAN_HPP_NOEXCEPT
    {
      timeout = timeout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setSemaphore( VULKAN_HPP_NAMESPACE::Semaphore semaphore_ ) VULKAN_HPP_NOEXCEPT
    {
      semaphore = semaphore_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setFence( VULKAN_HPP_NAMESPACE::Fence fence_ ) VULKAN_HPP_NOEXCEPT
    {
      fence = fence_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setDeviceMask( uint32_t deviceMask_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceMask = deviceMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAcquireNextImageInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAcquireNextImageInfoKHR *>( this );
    }

    explicit operator VkAcquireNextImageInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAcquireNextImageInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::SwapchainKHR const &,
               uint64_t const &,
               VULKAN_HPP_NAMESPACE::Semaphore const &,
               VULKAN_HPP_NAMESPACE::Fence const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, swapchain, timeout, semaphore, fence, deviceMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AcquireNextImageInfoKHR const & ) const = default;
#else
    bool operator==( AcquireNextImageInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( swapchain == rhs.swapchain ) && ( timeout == rhs.timeout ) &&
             ( semaphore == rhs.semaphore ) && ( fence == rhs.fence ) && ( deviceMask == rhs.deviceMask );
#  endif
    }

    bool operator!=( AcquireNextImageInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eAcquireNextImageInfoKHR;
    const void *                        pNext      = {};
    VULKAN_HPP_NAMESPACE::SwapchainKHR  swapchain  = {};
    uint64_t                            timeout    = {};
    VULKAN_HPP_NAMESPACE::Semaphore     semaphore  = {};
    VULKAN_HPP_NAMESPACE::Fence         fence      = {};
    uint32_t                            deviceMask = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AcquireNextImageInfoKHR ) == sizeof( VkAcquireNextImageInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AcquireNextImageInfoKHR>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AcquireNextImageInfoKHR>::value,
                            "AcquireNextImageInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAcquireNextImageInfoKHR>
  {
    using Type = AcquireNextImageInfoKHR;
  };

  struct AcquireProfilingLockInfoKHR
  {
    using NativeType = VkAcquireProfilingLockInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAcquireProfilingLockInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AcquireProfilingLockInfoKHR( VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR flags_   = {},
                                                      uint64_t                                           timeout_ = {},
                                                      const void *                                       pNext_   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , timeout( timeout_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AcquireProfilingLockInfoKHR( AcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireProfilingLockInfoKHR( VkAcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AcquireProfilingLockInfoKHR( *reinterpret_cast<AcquireProfilingLockInfoKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AcquireProfilingLockInfoKHR & operator=( AcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireProfilingLockInfoKHR & operator=( VkAcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AcquireProfilingLockInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setFlags( VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setTimeout( uint64_t timeout_ ) VULKAN_HPP_NOEXCEPT
    {
      timeout = timeout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAcquireProfilingLockInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAcquireProfilingLockInfoKHR *>( this );
    }

    explicit operator VkAcquireProfilingLockInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAcquireProfilingLockInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, timeout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AcquireProfilingLockInfoKHR const & ) const = default;
#else
    bool operator==( AcquireProfilingLockInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( timeout == rhs.timeout );
#  endif
    }

    bool operator!=( AcquireProfilingLockInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType   = StructureType::eAcquireProfilingLockInfoKHR;
    const void *                                       pNext   = {};
    VULKAN_HPP_NAMESPACE::AcquireProfilingLockFlagsKHR flags   = {};
    uint64_t                                           timeout = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AcquireProfilingLockInfoKHR ) == sizeof( VkAcquireProfilingLockInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AcquireProfilingLockInfoKHR>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AcquireProfilingLockInfoKHR>::value,
                            "AcquireProfilingLockInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAcquireProfilingLockInfoKHR>
  {
    using Type = AcquireProfilingLockInfoKHR;
  };

  struct AllocationCallbacks
  {
    using NativeType = VkAllocationCallbacks;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AllocationCallbacks( void *                               pUserData_             = {},
                                              PFN_vkAllocationFunction             pfnAllocation_         = {},
                                              PFN_vkReallocationFunction           pfnReallocation_       = {},
                                              PFN_vkFreeFunction                   pfnFree_               = {},
                                              PFN_vkInternalAllocationNotification pfnInternalAllocation_ = {},
                                              PFN_vkInternalFreeNotification       pfnInternalFree_       = {} ) VULKAN_HPP_NOEXCEPT
      : pUserData( pUserData_ )
      , pfnAllocation( pfnAllocation_ )
      , pfnReallocation( pfnReallocation_ )
      , pfnFree( pfnFree_ )
      , pfnInternalAllocation( pfnInternalAllocation_ )
      , pfnInternalFree( pfnInternalFree_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AllocationCallbacks( AllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AllocationCallbacks( VkAllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT : AllocationCallbacks( *reinterpret_cast<AllocationCallbacks const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AllocationCallbacks & operator=( AllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AllocationCallbacks & operator=( VkAllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AllocationCallbacks const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPUserData( void * pUserData_ ) VULKAN_HPP_NOEXCEPT
    {
      pUserData = pUserData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnAllocation( PFN_vkAllocationFunction pfnAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnAllocation = pfnAllocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnReallocation( PFN_vkReallocationFunction pfnReallocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnReallocation = pfnReallocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnFree( PFN_vkFreeFunction pfnFree_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnFree = pfnFree_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnInternalAllocation( PFN_vkInternalAllocationNotification pfnInternalAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnInternalAllocation = pfnInternalAllocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnInternalFree( PFN_vkInternalFreeNotification pfnInternalFree_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnInternalFree = pfnInternalFree_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAllocationCallbacks const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAllocationCallbacks *>( this );
    }

    explicit operator VkAllocationCallbacks &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAllocationCallbacks *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<void * const &,
               PFN_vkAllocationFunction const &,
               PFN_vkReallocationFunction const &,
               PFN_vkFreeFunction const &,
               PFN_vkInternalAllocationNotification const &,
               PFN_vkInternalFreeNotification const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( pUserData, pfnAllocation, pfnReallocation, pfnFree, pfnInternalAllocation, pfnInternalFree );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AllocationCallbacks const & ) const = default;
#else
    bool operator==( AllocationCallbacks const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( pUserData == rhs.pUserData ) && ( pfnAllocation == rhs.pfnAllocation ) && ( pfnReallocation == rhs.pfnReallocation ) &&
             ( pfnFree == rhs.pfnFree ) && ( pfnInternalAllocation == rhs.pfnInternalAllocation ) && ( pfnInternalFree == rhs.pfnInternalFree );
#  endif
    }

    bool operator!=( AllocationCallbacks const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    void *                               pUserData             = {};
    PFN_vkAllocationFunction             pfnAllocation         = {};
    PFN_vkReallocationFunction           pfnReallocation       = {};
    PFN_vkFreeFunction                   pfnFree               = {};
    PFN_vkInternalAllocationNotification pfnInternalAllocation = {};
    PFN_vkInternalFreeNotification       pfnInternalFree       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AllocationCallbacks ) == sizeof( VkAllocationCallbacks ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AllocationCallbacks>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AllocationCallbacks>::value,
                            "AllocationCallbacks is not nothrow_move_constructible!" );

  struct ComponentMapping
  {
    using NativeType = VkComponentMapping;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ComponentMapping( VULKAN_HPP_NAMESPACE::ComponentSwizzle r_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity,
                                           VULKAN_HPP_NAMESPACE::ComponentSwizzle g_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity,
                                           VULKAN_HPP_NAMESPACE::ComponentSwizzle b_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity,
                                           VULKAN_HPP_NAMESPACE::ComponentSwizzle a_ = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity ) VULKAN_HPP_NOEXCEPT
      : r( r_ )
      , g( g_ )
      , b( b_ )
      , a( a_ )
    {
    }

    VULKAN_HPP_CONSTEXPR ComponentMapping( ComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComponentMapping( VkComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT : ComponentMapping( *reinterpret_cast<ComponentMapping const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ComponentMapping & operator=( ComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComponentMapping & operator=( VkComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ComponentMapping const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setR( VULKAN_HPP_NAMESPACE::ComponentSwizzle r_ ) VULKAN_HPP_NOEXCEPT
    {
      r = r_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setG( VULKAN_HPP_NAMESPACE::ComponentSwizzle g_ ) VULKAN_HPP_NOEXCEPT
    {
      g = g_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setB( VULKAN_HPP_NAMESPACE::ComponentSwizzle b_ ) VULKAN_HPP_NOEXCEPT
    {
      b = b_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setA( VULKAN_HPP_NAMESPACE::ComponentSwizzle a_ ) VULKAN_HPP_NOEXCEPT
    {
      a = a_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkComponentMapping const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkComponentMapping *>( this );
    }

    explicit operator VkComponentMapping &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkComponentMapping *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ComponentSwizzle const &,
               VULKAN_HPP_NAMESPACE::ComponentSwizzle const &,
               VULKAN_HPP_NAMESPACE::ComponentSwizzle const &,
               VULKAN_HPP_NAMESPACE::ComponentSwizzle const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( r, g, b, a );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ComponentMapping const & ) const = default;
#else
    bool operator==( ComponentMapping const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( r == rhs.r ) && ( g == rhs.g ) && ( b == rhs.b ) && ( a == rhs.a );
#  endif
    }

    bool operator!=( ComponentMapping const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ComponentSwizzle r = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
    VULKAN_HPP_NAMESPACE::ComponentSwizzle g = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
    VULKAN_HPP_NAMESPACE::ComponentSwizzle b = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
    VULKAN_HPP_NAMESPACE::ComponentSwizzle a = VULKAN_HPP_NAMESPACE::ComponentSwizzle::eIdentity;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ComponentMapping ) == sizeof( VkComponentMapping ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ComponentMapping>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ComponentMapping>::value,
                            "ComponentMapping is not nothrow_move_constructible!" );

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidHardwareBufferFormatProperties2ANDROID
  {
    using NativeType = VkAndroidHardwareBufferFormatProperties2ANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferFormatProperties2ANDROID;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferFormatProperties2ANDROID(
      VULKAN_HPP_NAMESPACE::Format                      format_                           = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      uint64_t                                          externalFormat_                   = {},
      VULKAN_HPP_NAMESPACE::FormatFeatureFlags2         formatFeatures_                   = {},
      VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents_ = {},
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel_              = VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity,
      VULKAN_HPP_NAMESPACE::SamplerYcbcrRange           suggestedYcbcrRange_              = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull,
      VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedXChromaOffset_           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedYChromaOffset_           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      void *                                            pNext_                            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , format( format_ )
      , externalFormat( externalFormat_ )
      , formatFeatures( formatFeatures_ )
      , samplerYcbcrConversionComponents( samplerYcbcrConversionComponents_ )
      , suggestedYcbcrModel( suggestedYcbcrModel_ )
      , suggestedYcbcrRange( suggestedYcbcrRange_ )
      , suggestedXChromaOffset( suggestedXChromaOffset_ )
      , suggestedYChromaOffset( suggestedYChromaOffset_ )
    {
    }

    VULKAN_HPP_CONSTEXPR
      AndroidHardwareBufferFormatProperties2ANDROID( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatProperties2ANDROID( VkAndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferFormatProperties2ANDROID( *reinterpret_cast<AndroidHardwareBufferFormatProperties2ANDROID const *>( &rhs ) )
    {
    }
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AndroidHardwareBufferFormatProperties2ANDROID & operator=( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatProperties2ANDROID & operator=( VkAndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatProperties2ANDROID const *>( &rhs );
      return *this;
    }

    explicit operator VkAndroidHardwareBufferFormatProperties2ANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferFormatProperties2ANDROID *>( this );
    }

    explicit operator VkAndroidHardwareBufferFormatProperties2ANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferFormatProperties2ANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               uint64_t const &,
               VULKAN_HPP_NAMESPACE::FormatFeatureFlags2 const &,
               VULKAN_HPP_NAMESPACE::ComponentMapping const &,
               VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion const &,
               VULKAN_HPP_NAMESPACE::SamplerYcbcrRange const &,
               VULKAN_HPP_NAMESPACE::ChromaLocation const &,
               VULKAN_HPP_NAMESPACE::ChromaLocation const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       format,
                       externalFormat,
                       formatFeatures,
                       samplerYcbcrConversionComponents,
                       suggestedYcbcrModel,
                       suggestedYcbcrRange,
                       suggestedXChromaOffset,
                       suggestedYChromaOffset );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferFormatProperties2ANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( format == rhs.format ) && ( externalFormat == rhs.externalFormat ) &&
             ( formatFeatures == rhs.formatFeatures ) && ( samplerYcbcrConversionComponents == rhs.samplerYcbcrConversionComponents ) &&
             ( suggestedYcbcrModel == rhs.suggestedYcbcrModel ) && ( suggestedYcbcrRange == rhs.suggestedYcbcrRange ) &&
             ( suggestedXChromaOffset == rhs.suggestedXChromaOffset ) && ( suggestedYChromaOffset == rhs.suggestedYChromaOffset );
#    endif
    }

    bool operator!=( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType                            = StructureType::eAndroidHardwareBufferFormatProperties2ANDROID;
    void *                                            pNext                            = {};
    VULKAN_HPP_NAMESPACE::Format                      format                           = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    uint64_t                                          externalFormat                   = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags2         formatFeatures                   = {};
    VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents = {};
    VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel              = VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity;
    VULKAN_HPP_NAMESPACE::SamplerYcbcrRange           suggestedYcbcrRange              = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull;
    VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedXChromaOffset           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
    VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedYChromaOffset           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatProperties2ANDROID ) ==
                              sizeof( VkAndroidHardwareBufferFormatProperties2ANDROID ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatProperties2ANDROID>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatProperties2ANDROID>::value,
                            "AndroidHardwareBufferFormatProperties2ANDROID is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferFormatProperties2ANDROID>
  {
    using Type = AndroidHardwareBufferFormatProperties2ANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidHardwareBufferFormatPropertiesANDROID
  {
    using NativeType = VkAndroidHardwareBufferFormatPropertiesANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferFormatPropertiesANDROID;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferFormatPropertiesANDROID(
      VULKAN_HPP_NAMESPACE::Format                      format_                           = VULKAN_HPP_NAMESPACE::Format::eUndefined,
      uint64_t                                          externalFormat_                   = {},
      VULKAN_HPP_NAMESPACE::FormatFeatureFlags          formatFeatures_                   = {},
      VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents_ = {},
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel_              = VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity,
      VULKAN_HPP_NAMESPACE::SamplerYcbcrRange           suggestedYcbcrRange_              = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull,
      VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedXChromaOffset_           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedYChromaOffset_           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      void *                                            pNext_                            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , format( format_ )
      , externalFormat( externalFormat_ )
      , formatFeatures( formatFeatures_ )
      , samplerYcbcrConversionComponents( samplerYcbcrConversionComponents_ )
      , suggestedYcbcrModel( suggestedYcbcrModel_ )
      , suggestedYcbcrRange( suggestedYcbcrRange_ )
      , suggestedXChromaOffset( suggestedXChromaOffset_ )
      , suggestedYChromaOffset( suggestedYChromaOffset_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferFormatPropertiesANDROID( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatPropertiesANDROID( VkAndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferFormatPropertiesANDROID( *reinterpret_cast<AndroidHardwareBufferFormatPropertiesANDROID const *>( &rhs ) )
    {
    }
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AndroidHardwareBufferFormatPropertiesANDROID & operator=( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatPropertiesANDROID & operator=( VkAndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatPropertiesANDROID const *>( &rhs );
      return *this;
    }

    explicit operator VkAndroidHardwareBufferFormatPropertiesANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferFormatPropertiesANDROID *>( this );
    }

    explicit operator VkAndroidHardwareBufferFormatPropertiesANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferFormatPropertiesANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               uint64_t const &,
               VULKAN_HPP_NAMESPACE::FormatFeatureFlags const &,
               VULKAN_HPP_NAMESPACE::ComponentMapping const &,
               VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion const &,
               VULKAN_HPP_NAMESPACE::SamplerYcbcrRange const &,
               VULKAN_HPP_NAMESPACE::ChromaLocation const &,
               VULKAN_HPP_NAMESPACE::ChromaLocation const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       format,
                       externalFormat,
                       formatFeatures,
                       samplerYcbcrConversionComponents,
                       suggestedYcbcrModel,
                       suggestedYcbcrRange,
                       suggestedXChromaOffset,
                       suggestedYChromaOffset );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferFormatPropertiesANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( format == rhs.format ) && ( externalFormat == rhs.externalFormat ) &&
             ( formatFeatures == rhs.formatFeatures ) && ( samplerYcbcrConversionComponents == rhs.samplerYcbcrConversionComponents ) &&
             ( suggestedYcbcrModel == rhs.suggestedYcbcrModel ) && ( suggestedYcbcrRange == rhs.suggestedYcbcrRange ) &&
             ( suggestedXChromaOffset == rhs.suggestedXChromaOffset ) && ( suggestedYChromaOffset == rhs.suggestedYChromaOffset );
#    endif
    }

    bool operator!=( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType                            = StructureType::eAndroidHardwareBufferFormatPropertiesANDROID;
    void *                                            pNext                            = {};
    VULKAN_HPP_NAMESPACE::Format                      format                           = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    uint64_t                                          externalFormat                   = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags          formatFeatures                   = {};
    VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents = {};
    VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel              = VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity;
    VULKAN_HPP_NAMESPACE::SamplerYcbcrRange           suggestedYcbcrRange              = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull;
    VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedXChromaOffset           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
    VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedYChromaOffset           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatPropertiesANDROID ) ==
                              sizeof( VkAndroidHardwareBufferFormatPropertiesANDROID ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatPropertiesANDROID>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferFormatPropertiesANDROID>::value,
                            "AndroidHardwareBufferFormatPropertiesANDROID is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferFormatPropertiesANDROID>
  {
    using Type = AndroidHardwareBufferFormatPropertiesANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidHardwareBufferPropertiesANDROID
  {
    using NativeType = VkAndroidHardwareBufferPropertiesANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferPropertiesANDROID;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferPropertiesANDROID( VULKAN_HPP_NAMESPACE::DeviceSize allocationSize_ = {},
                                                                 uint32_t                         memoryTypeBits_ = {},
                                                                 void *                           pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , allocationSize( allocationSize_ )
      , memoryTypeBits( memoryTypeBits_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferPropertiesANDROID( AndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferPropertiesANDROID( VkAndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferPropertiesANDROID( *reinterpret_cast<AndroidHardwareBufferPropertiesANDROID const *>( &rhs ) )
    {
    }
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AndroidHardwareBufferPropertiesANDROID & operator=( AndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferPropertiesANDROID & operator=( VkAndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferPropertiesANDROID const *>( &rhs );
      return *this;
    }

    explicit operator VkAndroidHardwareBufferPropertiesANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferPropertiesANDROID *>( this );
    }

    explicit operator VkAndroidHardwareBufferPropertiesANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferPropertiesANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::DeviceSize const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, allocationSize, memoryTypeBits );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferPropertiesANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( allocationSize == rhs.allocationSize ) && ( memoryTypeBits == rhs.memoryTypeBits );
#    endif
    }

    bool operator!=( AndroidHardwareBufferPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType          = StructureType::eAndroidHardwareBufferPropertiesANDROID;
    void *                              pNext          = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    allocationSize = {};
    uint32_t                            memoryTypeBits = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AndroidHardwareBufferPropertiesANDROID ) == sizeof( VkAndroidHardwareBufferPropertiesANDROID ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferPropertiesANDROID>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferPropertiesANDROID>::value,
                            "AndroidHardwareBufferPropertiesANDROID is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferPropertiesANDROID>
  {
    using Type = AndroidHardwareBufferPropertiesANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidHardwareBufferUsageANDROID
  {
    using NativeType = VkAndroidHardwareBufferUsageANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferUsageANDROID;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferUsageANDROID( uint64_t androidHardwareBufferUsage_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , androidHardwareBufferUsage( androidHardwareBufferUsage_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferUsageANDROID( AndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferUsageANDROID( VkAndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferUsageANDROID( *reinterpret_cast<AndroidHardwareBufferUsageANDROID const *>( &rhs ) )
    {
    }
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AndroidHardwareBufferUsageANDROID & operator=( AndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferUsageANDROID & operator=( VkAndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferUsageANDROID const *>( &rhs );
      return *this;
    }

    explicit operator VkAndroidHardwareBufferUsageANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferUsageANDROID *>( this );
    }

    explicit operator VkAndroidHardwareBufferUsageANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferUsageANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, uint64_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, androidHardwareBufferUsage );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferUsageANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferUsageANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( androidHardwareBufferUsage == rhs.androidHardwareBufferUsage );
#    endif
    }

    bool operator!=( AndroidHardwareBufferUsageANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                      = StructureType::eAndroidHardwareBufferUsageANDROID;
    void *                              pNext                      = {};
    uint64_t                            androidHardwareBufferUsage = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AndroidHardwareBufferUsageANDROID ) == sizeof( VkAndroidHardwareBufferUsageANDROID ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferUsageANDROID>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AndroidHardwareBufferUsageANDROID>::value,
                            "AndroidHardwareBufferUsageANDROID is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferUsageANDROID>
  {
    using Type = AndroidHardwareBufferUsageANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  struct AndroidSurfaceCreateInfoKHR
  {
    using NativeType = VkAndroidSurfaceCreateInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidSurfaceCreateInfoKHR;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidSurfaceCreateInfoKHR( VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateFlagsKHR flags_  = {},
                                                      struct ANativeWindow *                             window_ = {},
                                                      const void *                                       pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , window( window_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AndroidSurfaceCreateInfoKHR( AndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidSurfaceCreateInfoKHR( VkAndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidSurfaceCreateInfoKHR( *reinterpret_cast<AndroidSurfaceCreateInfoKHR const *>( &rhs ) )
    {
    }
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AndroidSurfaceCreateInfoKHR & operator=( AndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidSurfaceCreateInfoKHR & operator=( VkAndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateInfoKHR const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AndroidSurfaceCreateInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AndroidSurfaceCreateInfoKHR & setFlags( VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AndroidSurfaceCreateInfoKHR & setWindow( struct ANativeWindow * window_ ) VULKAN_HPP_NOEXCEPT
    {
      window = window_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAndroidSurfaceCreateInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidSurfaceCreateInfoKHR *>( this );
    }

    explicit operator VkAndroidSurfaceCreateInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidSurfaceCreateInfoKHR *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateFlagsKHR const &,
               struct ANativeWindow * const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, window );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidSurfaceCreateInfoKHR const & ) const = default;
#  else
    bool operator==( AndroidSurfaceCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( window == rhs.window );
#    endif
    }

    bool operator!=( AndroidSurfaceCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType  = StructureType::eAndroidSurfaceCreateInfoKHR;
    const void *                                       pNext  = {};
    VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateFlagsKHR flags  = {};
    struct ANativeWindow *                             window = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateInfoKHR ) == sizeof( VkAndroidSurfaceCreateInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateInfoKHR>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AndroidSurfaceCreateInfoKHR>::value,
                            "AndroidSurfaceCreateInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAndroidSurfaceCreateInfoKHR>
  {
    using Type = AndroidSurfaceCreateInfoKHR;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

  struct ApplicationInfo
  {
    using NativeType = VkApplicationInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eApplicationInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ApplicationInfo( const char * pApplicationName_   = {},
                                          uint32_t     applicationVersion_ = {},
                                          const char * pEngineName_        = {},
                                          uint32_t     engineVersion_      = {},
                                          uint32_t     apiVersion_         = {},
                                          const void * pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , pApplicationName( pApplicationName_ )
      , applicationVersion( applicationVersion_ )
      , pEngineName( pEngineName_ )
      , engineVersion( engineVersion_ )
      , apiVersion( apiVersion_ )
    {
    }

    VULKAN_HPP_CONSTEXPR ApplicationInfo( ApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ApplicationInfo( VkApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT : ApplicationInfo( *reinterpret_cast<ApplicationInfo const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ApplicationInfo & operator=( ApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ApplicationInfo & operator=( VkApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ApplicationInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPApplicationName( const char * pApplicationName_ ) VULKAN_HPP_NOEXCEPT
    {
      pApplicationName = pApplicationName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setApplicationVersion( uint32_t applicationVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      applicationVersion = applicationVersion_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPEngineName( const char * pEngineName_ ) VULKAN_HPP_NOEXCEPT
    {
      pEngineName = pEngineName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setEngineVersion( uint32_t engineVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      engineVersion = engineVersion_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setApiVersion( uint32_t apiVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      apiVersion = apiVersion_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkApplicationInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkApplicationInfo *>( this );
    }

    explicit operator VkApplicationInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkApplicationInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               const char * const &,
               uint32_t const &,
               const char * const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pApplicationName, applicationVersion, pEngineName, engineVersion, apiVersion );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( pApplicationName != rhs.pApplicationName )
        if ( auto cmp = strcmp( pApplicationName, rhs.pApplicationName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = applicationVersion <=> rhs.applicationVersion; cmp != 0 )
        return cmp;
      if ( pEngineName != rhs.pEngineName )
        if ( auto cmp = strcmp( pEngineName, rhs.pEngineName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = engineVersion <=> rhs.engineVersion; cmp != 0 )
        return cmp;
      if ( auto cmp = apiVersion <=> rhs.apiVersion; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) &&
             ( ( pApplicationName == rhs.pApplicationName ) || ( strcmp( pApplicationName, rhs.pApplicationName ) == 0 ) ) &&
             ( applicationVersion == rhs.applicationVersion ) && ( ( pEngineName == rhs.pEngineName ) || ( strcmp( pEngineName, rhs.pEngineName ) == 0 ) ) &&
             ( engineVersion == rhs.engineVersion ) && ( apiVersion == rhs.apiVersion );
    }

    bool operator!=( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType              = StructureType::eApplicationInfo;
    const void *                        pNext              = {};
    const char *                        pApplicationName   = {};
    uint32_t                            applicationVersion = {};
    const char *                        pEngineName        = {};
    uint32_t                            engineVersion      = {};
    uint32_t                            apiVersion         = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ApplicationInfo ) == sizeof( VkApplicationInfo ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ApplicationInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ApplicationInfo>::value,
                            "ApplicationInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eApplicationInfo>
  {
    using Type = ApplicationInfo;
  };

  struct AttachmentDescription
  {
    using NativeType = VkAttachmentDescription;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AttachmentDescription( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_          = {},
                             VULKAN_HPP_NAMESPACE::Format                     format_         = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                             VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples_        = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                             VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp_         = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
                             VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp_        = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
                             VULKAN_HPP_NAMESPACE::AttachmentLoadOp           stencilLoadOp_  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
                             VULKAN_HPP_NAMESPACE::AttachmentStoreOp          stencilStoreOp_ = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
                             VULKAN_HPP_NAMESPACE::ImageLayout                initialLayout_  = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                             VULKAN_HPP_NAMESPACE::ImageLayout                finalLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined ) VULKAN_HPP_NOEXCEPT
      : flags( flags_ )
      , format( format_ )
      , samples( samples_ )
      , loadOp( loadOp_ )
      , storeOp( storeOp_ )
      , stencilLoadOp( stencilLoadOp_ )
      , stencilStoreOp( stencilStoreOp_ )
      , initialLayout( initialLayout_ )
      , finalLayout( finalLayout_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentDescription( AttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription( VkAttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescription( *reinterpret_cast<AttachmentDescription const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentDescription & operator=( AttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription & operator=( VkAttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentDescription const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setFlags( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits samples_ ) VULKAN_HPP_NOEXCEPT
    {
      samples = samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp loadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      loadOp = loadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp storeOp_ ) VULKAN_HPP_NOEXCEPT
    {
      storeOp = storeOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setStencilLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp stencilLoadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLoadOp = stencilLoadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setStencilStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp stencilStoreOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilStoreOp = stencilStoreOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setInitialLayout( VULKAN_HPP_NAMESPACE::ImageLayout initialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      initialLayout = initialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setFinalLayout( VULKAN_HPP_NAMESPACE::ImageLayout finalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      finalLayout = finalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAttachmentDescription const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescription *>( this );
    }

    explicit operator VkAttachmentDescription &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescription *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &,
               VULKAN_HPP_NAMESPACE::AttachmentLoadOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentStoreOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentLoadOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentStoreOp const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( flags, format, samples, loadOp, storeOp, stencilLoadOp, stencilStoreOp, initialLayout, finalLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescription const & ) const = default;
#else
    bool operator==( AttachmentDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( flags == rhs.flags ) && ( format == rhs.format ) && ( samples == rhs.samples ) && ( loadOp == rhs.loadOp ) && ( storeOp == rhs.storeOp ) &&
             ( stencilLoadOp == rhs.stencilLoadOp ) && ( stencilStoreOp == rhs.stencilStoreOp ) && ( initialLayout == rhs.initialLayout ) &&
             ( finalLayout == rhs.finalLayout );
#  endif
    }

    bool operator!=( AttachmentDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags          = {};
    VULKAN_HPP_NAMESPACE::Format                     format         = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples        = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp         = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp        = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           stencilLoadOp  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          stencilStoreOp = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::ImageLayout                initialLayout  = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout                finalLayout    = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentDescription ) == sizeof( VkAttachmentDescription ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentDescription>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentDescription>::value,
                            "AttachmentDescription is not nothrow_move_constructible!" );

  struct AttachmentDescription2
  {
    using NativeType = VkAttachmentDescription2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentDescription2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentDescription2( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_   = {},
                                                 VULKAN_HPP_NAMESPACE::Format                     format_  = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                                 VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples_ = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                                                 VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp_  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
                                                 VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp_ = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
                                                 VULKAN_HPP_NAMESPACE::AttachmentLoadOp  stencilLoadOp_    = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad,
                                                 VULKAN_HPP_NAMESPACE::AttachmentStoreOp stencilStoreOp_   = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore,
                                                 VULKAN_HPP_NAMESPACE::ImageLayout       initialLayout_    = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                 VULKAN_HPP_NAMESPACE::ImageLayout       finalLayout_      = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                 const void *                            pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , format( format_ )
      , samples( samples_ )
      , loadOp( loadOp_ )
      , storeOp( storeOp_ )
      , stencilLoadOp( stencilLoadOp_ )
      , stencilStoreOp( stencilStoreOp_ )
      , initialLayout( initialLayout_ )
      , finalLayout( finalLayout_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentDescription2( AttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription2( VkAttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescription2( *reinterpret_cast<AttachmentDescription2 const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentDescription2 & operator=( AttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription2 & operator=( VkAttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentDescription2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setFlags( VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits samples_ ) VULKAN_HPP_NOEXCEPT
    {
      samples = samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp loadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      loadOp = loadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp storeOp_ ) VULKAN_HPP_NOEXCEPT
    {
      storeOp = storeOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setStencilLoadOp( VULKAN_HPP_NAMESPACE::AttachmentLoadOp stencilLoadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLoadOp = stencilLoadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setStencilStoreOp( VULKAN_HPP_NAMESPACE::AttachmentStoreOp stencilStoreOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilStoreOp = stencilStoreOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setInitialLayout( VULKAN_HPP_NAMESPACE::ImageLayout initialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      initialLayout = initialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setFinalLayout( VULKAN_HPP_NAMESPACE::ImageLayout finalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      finalLayout = finalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAttachmentDescription2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescription2 *>( this );
    }

    explicit operator VkAttachmentDescription2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescription2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &,
               VULKAN_HPP_NAMESPACE::AttachmentLoadOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentStoreOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentLoadOp const &,
               VULKAN_HPP_NAMESPACE::AttachmentStoreOp const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, format, samples, loadOp, storeOp, stencilLoadOp, stencilStoreOp, initialLayout, finalLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescription2 const & ) const = default;
#else
    bool operator==( AttachmentDescription2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( format == rhs.format ) && ( samples == rhs.samples ) &&
             ( loadOp == rhs.loadOp ) && ( storeOp == rhs.storeOp ) && ( stencilLoadOp == rhs.stencilLoadOp ) && ( stencilStoreOp == rhs.stencilStoreOp ) &&
             ( initialLayout == rhs.initialLayout ) && ( finalLayout == rhs.finalLayout );
#  endif
    }

    bool operator!=( AttachmentDescription2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType              sType          = StructureType::eAttachmentDescription2;
    const void *                                     pNext          = {};
    VULKAN_HPP_NAMESPACE::AttachmentDescriptionFlags flags          = {};
    VULKAN_HPP_NAMESPACE::Format                     format         = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits        samples        = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           loadOp         = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          storeOp        = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::AttachmentLoadOp           stencilLoadOp  = VULKAN_HPP_NAMESPACE::AttachmentLoadOp::eLoad;
    VULKAN_HPP_NAMESPACE::AttachmentStoreOp          stencilStoreOp = VULKAN_HPP_NAMESPACE::AttachmentStoreOp::eStore;
    VULKAN_HPP_NAMESPACE::ImageLayout                initialLayout  = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout                finalLayout    = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentDescription2 ) == sizeof( VkAttachmentDescription2 ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentDescription2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentDescription2>::value,
                            "AttachmentDescription2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAttachmentDescription2>
  {
    using Type = AttachmentDescription2;
  };
  using AttachmentDescription2KHR = AttachmentDescription2;

  struct AttachmentDescriptionStencilLayout
  {
    using NativeType = VkAttachmentDescriptionStencilLayout;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentDescriptionStencilLayout;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AttachmentDescriptionStencilLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilInitialLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                          VULKAN_HPP_NAMESPACE::ImageLayout stencilFinalLayout_   = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                          void *                            pNext_                = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , stencilInitialLayout( stencilInitialLayout_ )
      , stencilFinalLayout( stencilFinalLayout_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentDescriptionStencilLayout( AttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescriptionStencilLayout( VkAttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescriptionStencilLayout( *reinterpret_cast<AttachmentDescriptionStencilLayout const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentDescriptionStencilLayout & operator=( AttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescriptionStencilLayout & operator=( VkAttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentDescriptionStencilLayout const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout &
                            setStencilInitialLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilInitialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilInitialLayout = stencilInitialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout &
                            setStencilFinalLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilFinalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilFinalLayout = stencilFinalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAttachmentDescriptionStencilLayout const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescriptionStencilLayout *>( this );
    }

    explicit operator VkAttachmentDescriptionStencilLayout &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescriptionStencilLayout *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::
      tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::ImageLayout const &, VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stencilInitialLayout, stencilFinalLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescriptionStencilLayout const & ) const = default;
#else
    bool operator==( AttachmentDescriptionStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stencilInitialLayout == rhs.stencilInitialLayout ) &&
             ( stencilFinalLayout == rhs.stencilFinalLayout );
#  endif
    }

    bool operator!=( AttachmentDescriptionStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                = StructureType::eAttachmentDescriptionStencilLayout;
    void *                              pNext                = {};
    VULKAN_HPP_NAMESPACE::ImageLayout   stencilInitialLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout   stencilFinalLayout   = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentDescriptionStencilLayout ) == sizeof( VkAttachmentDescriptionStencilLayout ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentDescriptionStencilLayout>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentDescriptionStencilLayout>::value,
                            "AttachmentDescriptionStencilLayout is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAttachmentDescriptionStencilLayout>
  {
    using Type = AttachmentDescriptionStencilLayout;
  };
  using AttachmentDescriptionStencilLayoutKHR = AttachmentDescriptionStencilLayout;

  struct AttachmentReference
  {
    using NativeType = VkAttachmentReference;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentReference( uint32_t                          attachment_ = {},
                                              VULKAN_HPP_NAMESPACE::ImageLayout layout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined ) VULKAN_HPP_NOEXCEPT
      : attachment( attachment_ )
      , layout( layout_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentReference( AttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference( VkAttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT : AttachmentReference( *reinterpret_cast<AttachmentReference const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentReference & operator=( AttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference & operator=( VkAttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentReference const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReference & setAttachment( uint32_t attachment_ ) VULKAN_HPP_NOEXCEPT
    {
      attachment = attachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference & setLayout( VULKAN_HPP_NAMESPACE::ImageLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAttachmentReference const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReference *>( this );
    }

    explicit operator VkAttachmentReference &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReference *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( attachment, layout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReference const & ) const = default;
#else
    bool operator==( AttachmentReference const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( attachment == rhs.attachment ) && ( layout == rhs.layout );
#  endif
    }

    bool operator!=( AttachmentReference const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                          attachment = {};
    VULKAN_HPP_NAMESPACE::ImageLayout layout     = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentReference ) == sizeof( VkAttachmentReference ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentReference>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentReference>::value,
                            "AttachmentReference is not nothrow_move_constructible!" );

  struct AttachmentReference2
  {
    using NativeType = VkAttachmentReference2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentReference2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentReference2( uint32_t                               attachment_ = {},
                                               VULKAN_HPP_NAMESPACE::ImageLayout      layout_     = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                               VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ = {},
                                               const void *                           pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , attachment( attachment_ )
      , layout( layout_ )
      , aspectMask( aspectMask_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentReference2( AttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference2( VkAttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentReference2( *reinterpret_cast<AttachmentReference2 const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentReference2 & operator=( AttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference2 & operator=( VkAttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentReference2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setAttachment( uint32_t attachment_ ) VULKAN_HPP_NOEXCEPT
    {
      attachment = attachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setLayout( VULKAN_HPP_NAMESPACE::ImageLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAttachmentReference2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReference2 *>( this );
    }

    explicit operator VkAttachmentReference2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReference2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::ImageAspectFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, attachment, layout, aspectMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReference2 const & ) const = default;
#else
    bool operator==( AttachmentReference2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( attachment == rhs.attachment ) && ( layout == rhs.layout ) &&
             ( aspectMask == rhs.aspectMask );
#  endif
    }

    bool operator!=( AttachmentReference2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType      = StructureType::eAttachmentReference2;
    const void *                           pNext      = {};
    uint32_t                               attachment = {};
    VULKAN_HPP_NAMESPACE::ImageLayout      layout     = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentReference2 ) == sizeof( VkAttachmentReference2 ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentReference2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentReference2>::value,
                            "AttachmentReference2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAttachmentReference2>
  {
    using Type = AttachmentReference2;
  };
  using AttachmentReference2KHR = AttachmentReference2;

  struct AttachmentReferenceStencilLayout
  {
    using NativeType = VkAttachmentReferenceStencilLayout;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentReferenceStencilLayout;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentReferenceStencilLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                           void *                            pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , stencilLayout( stencilLayout_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentReferenceStencilLayout( AttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReferenceStencilLayout( VkAttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentReferenceStencilLayout( *reinterpret_cast<AttachmentReferenceStencilLayout const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentReferenceStencilLayout & operator=( AttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReferenceStencilLayout & operator=( VkAttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentReferenceStencilLayout const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReferenceStencilLayout & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReferenceStencilLayout & setStencilLayout( VULKAN_HPP_NAMESPACE::ImageLayout stencilLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLayout = stencilLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAttachmentReferenceStencilLayout const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReferenceStencilLayout *>( this );
    }

    explicit operator VkAttachmentReferenceStencilLayout &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReferenceStencilLayout *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stencilLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReferenceStencilLayout const & ) const = default;
#else
    bool operator==( AttachmentReferenceStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stencilLayout == rhs.stencilLayout );
#  endif
    }

    bool operator!=( AttachmentReferenceStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType         = StructureType::eAttachmentReferenceStencilLayout;
    void *                              pNext         = {};
    VULKAN_HPP_NAMESPACE::ImageLayout   stencilLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentReferenceStencilLayout ) == sizeof( VkAttachmentReferenceStencilLayout ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentReferenceStencilLayout>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentReferenceStencilLayout>::value,
                            "AttachmentReferenceStencilLayout is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAttachmentReferenceStencilLayout>
  {
    using Type = AttachmentReferenceStencilLayout;
  };
  using AttachmentReferenceStencilLayoutKHR = AttachmentReferenceStencilLayout;

  struct AttachmentSampleCountInfoAMD
  {
    using NativeType = VkAttachmentSampleCountInfoAMD;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentSampleCountInfoAMD;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AttachmentSampleCountInfoAMD( uint32_t                                          colorAttachmentCount_    = {},
                                    const VULKAN_HPP_NAMESPACE::SampleCountFlagBits * pColorAttachmentSamples_ = {},
                                    VULKAN_HPP_NAMESPACE::SampleCountFlagBits depthStencilAttachmentSamples_   = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                                    const void *                              pNext_                           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , colorAttachmentCount( colorAttachmentCount_ )
      , pColorAttachmentSamples( pColorAttachmentSamples_ )
      , depthStencilAttachmentSamples( depthStencilAttachmentSamples_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentSampleCountInfoAMD( AttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentSampleCountInfoAMD( VkAttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentSampleCountInfoAMD( *reinterpret_cast<AttachmentSampleCountInfoAMD const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AttachmentSampleCountInfoAMD(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SampleCountFlagBits> const & colorAttachmentSamples_,
      VULKAN_HPP_NAMESPACE::SampleCountFlagBits depthStencilAttachmentSamples_ = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
      const void *                              pNext_                         = nullptr )
      : pNext( pNext_ )
      , colorAttachmentCount( static_cast<uint32_t>( colorAttachmentSamples_.size() ) )
      , pColorAttachmentSamples( colorAttachmentSamples_.data() )
      , depthStencilAttachmentSamples( depthStencilAttachmentSamples_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentSampleCountInfoAMD & operator=( AttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentSampleCountInfoAMD & operator=( VkAttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentSampleCountInfoAMD const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD & setColorAttachmentCount( uint32_t colorAttachmentCount_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount = colorAttachmentCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD &
                            setPColorAttachmentSamples( const VULKAN_HPP_NAMESPACE::SampleCountFlagBits * pColorAttachmentSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      pColorAttachmentSamples = pColorAttachmentSamples_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AttachmentSampleCountInfoAMD & setColorAttachmentSamples(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SampleCountFlagBits> const & colorAttachmentSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount    = static_cast<uint32_t>( colorAttachmentSamples_.size() );
      pColorAttachmentSamples = colorAttachmentSamples_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD &
                            setDepthStencilAttachmentSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits depthStencilAttachmentSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      depthStencilAttachmentSamples = depthStencilAttachmentSamples_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAttachmentSampleCountInfoAMD const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentSampleCountInfoAMD *>( this );
    }

    explicit operator VkAttachmentSampleCountInfoAMD &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentSampleCountInfoAMD *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::SampleCountFlagBits * const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, colorAttachmentCount, pColorAttachmentSamples, depthStencilAttachmentSamples );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentSampleCountInfoAMD const & ) const = default;
#else
    bool operator==( AttachmentSampleCountInfoAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( colorAttachmentCount == rhs.colorAttachmentCount ) &&
             ( pColorAttachmentSamples == rhs.pColorAttachmentSamples ) && ( depthStencilAttachmentSamples == rhs.depthStencilAttachmentSamples );
#  endif
    }

    bool operator!=( AttachmentSampleCountInfoAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType                         = StructureType::eAttachmentSampleCountInfoAMD;
    const void *                                      pNext                         = {};
    uint32_t                                          colorAttachmentCount          = {};
    const VULKAN_HPP_NAMESPACE::SampleCountFlagBits * pColorAttachmentSamples       = {};
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits         depthStencilAttachmentSamples = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentSampleCountInfoAMD ) == sizeof( VkAttachmentSampleCountInfoAMD ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentSampleCountInfoAMD>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentSampleCountInfoAMD>::value,
                            "AttachmentSampleCountInfoAMD is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eAttachmentSampleCountInfoAMD>
  {
    using Type = AttachmentSampleCountInfoAMD;
  };
  using AttachmentSampleCountInfoNV = AttachmentSampleCountInfoAMD;

  struct Extent2D
  {
    using NativeType = VkExtent2D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Extent2D( uint32_t width_ = {}, uint32_t height_ = {} ) VULKAN_HPP_NOEXCEPT
      : width( width_ )
      , height( height_ )
    {
    }

    VULKAN_HPP_CONSTEXPR Extent2D( Extent2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent2D( VkExtent2D const & rhs ) VULKAN_HPP_NOEXCEPT : Extent2D( *reinterpret_cast<Extent2D const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Extent2D & operator=( Extent2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent2D & operator=( VkExtent2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Extent2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Extent2D & setWidth( uint32_t width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent2D & setHeight( uint32_t height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkExtent2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExtent2D *>( this );
    }

    explicit operator VkExtent2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExtent2D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( width, height );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Extent2D const & ) const = default;
#else
    bool operator==( Extent2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( width == rhs.width ) && ( height == rhs.height );
#  endif
    }

    bool operator!=( Extent2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t width  = {};
    uint32_t height = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::Extent2D ) == sizeof( VkExtent2D ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::Extent2D>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::Extent2D>::value, "Extent2D is not nothrow_move_constructible!" );

  struct SampleLocationEXT
  {
    using NativeType = VkSampleLocationEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SampleLocationEXT( float x_ = {}, float y_ = {} ) VULKAN_HPP_NOEXCEPT
      : x( x_ )
      , y( y_ )
    {
    }

    VULKAN_HPP_CONSTEXPR SampleLocationEXT( SampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationEXT( VkSampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT : SampleLocationEXT( *reinterpret_cast<SampleLocationEXT const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SampleLocationEXT & operator=( SampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationEXT & operator=( VkSampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SampleLocationEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SampleLocationEXT & setX( float x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationEXT & setY( float y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkSampleLocationEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSampleLocationEXT *>( this );
    }

    explicit operator VkSampleLocationEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSampleLocationEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SampleLocationEXT const & ) const = default;
#else
    bool operator==( SampleLocationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y );
#  endif
    }

    bool operator!=( SampleLocationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float x = {};
    float y = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SampleLocationEXT ) == sizeof( VkSampleLocationEXT ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SampleLocationEXT>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SampleLocationEXT>::value,
                            "SampleLocationEXT is not nothrow_move_constructible!" );

  struct SampleLocationsInfoEXT
  {
    using NativeType = VkSampleLocationsInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eSampleLocationsInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      SampleLocationsInfoEXT( VULKAN_HPP_NAMESPACE::SampleCountFlagBits       sampleLocationsPerPixel_ = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                              VULKAN_HPP_NAMESPACE::Extent2D                  sampleLocationGridSize_  = {},
                              uint32_t                                        sampleLocationsCount_    = {},
                              const VULKAN_HPP_NAMESPACE::SampleLocationEXT * pSampleLocations_        = {},
                              const void *                                    pNext_                   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , sampleLocationsPerPixel( sampleLocationsPerPixel_ )
      , sampleLocationGridSize( sampleLocationGridSize_ )
      , sampleLocationsCount( sampleLocationsCount_ )
      , pSampleLocations( pSampleLocations_ )
    {
    }

    VULKAN_HPP_CONSTEXPR SampleLocationsInfoEXT( SampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationsInfoEXT( VkSampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : SampleLocationsInfoEXT( *reinterpret_cast<SampleLocationsInfoEXT const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SampleLocationsInfoEXT( VULKAN_HPP_NAMESPACE::SampleCountFlagBits                                                            sampleLocationsPerPixel_,
                            VULKAN_HPP_NAMESPACE::Extent2D                                                                       sampleLocationGridSize_,
                            VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SampleLocationEXT> const & sampleLocations_,
                            const void *                                                                                         pNext_ = nullptr )
      : pNext( pNext_ )
      , sampleLocationsPerPixel( sampleLocationsPerPixel_ )
      , sampleLocationGridSize( sampleLocationGridSize_ )
      , sampleLocationsCount( static_cast<uint32_t>( sampleLocations_.size() ) )
      , pSampleLocations( sampleLocations_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SampleLocationsInfoEXT & operator=( SampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationsInfoEXT & operator=( VkSampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT &
                            setSampleLocationsPerPixel( VULKAN_HPP_NAMESPACE::SampleCountFlagBits sampleLocationsPerPixel_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsPerPixel = sampleLocationsPerPixel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT &
                            setSampleLocationGridSize( VULKAN_HPP_NAMESPACE::Extent2D const & sampleLocationGridSize_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationGridSize = sampleLocationGridSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT & setSampleLocationsCount( uint32_t sampleLocationsCount_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsCount = sampleLocationsCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT &
                            setPSampleLocations( const VULKAN_HPP_NAMESPACE::SampleLocationEXT * pSampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      pSampleLocations = pSampleLocations_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SampleLocationsInfoEXT & setSampleLocations(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SampleLocationEXT> const & sampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsCount = static_cast<uint32_t>( sampleLocations_.size() );
      pSampleLocations     = sampleLocations_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkSampleLocationsInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSampleLocationsInfoEXT *>( this );
    }

    explicit operator VkSampleLocationsInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSampleLocationsInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &,
               VULKAN_HPP_NAMESPACE::Extent2D const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::SampleLocationEXT * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, sampleLocationsPerPixel, sampleLocationGridSize, sampleLocationsCount, pSampleLocations );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SampleLocationsInfoEXT const & ) const = default;
#else
    bool operator==( SampleLocationsInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( sampleLocationsPerPixel == rhs.sampleLocationsPerPixel ) &&
             ( sampleLocationGridSize == rhs.sampleLocationGridSize ) && ( sampleLocationsCount == rhs.sampleLocationsCount ) &&
             ( pSampleLocations == rhs.pSampleLocations );
#  endif
    }

    bool operator!=( SampleLocationsInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType             sType                   = StructureType::eSampleLocationsInfoEXT;
    const void *                                    pNext                   = {};
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits       sampleLocationsPerPixel = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
    VULKAN_HPP_NAMESPACE::Extent2D                  sampleLocationGridSize  = {};
    uint32_t                                        sampleLocationsCount    = {};
    const VULKAN_HPP_NAMESPACE::SampleLocationEXT * pSampleLocations        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT ) == sizeof( VkSampleLocationsInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT>::value,
                            "SampleLocationsInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eSampleLocationsInfoEXT>
  {
    using Type = SampleLocationsInfoEXT;
  };

  struct AttachmentSampleLocationsEXT
  {
    using NativeType = VkAttachmentSampleLocationsEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentSampleLocationsEXT( uint32_t                                     attachmentIndex_     = {},
                                                       VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT sampleLocationsInfo_ = {} ) VULKAN_HPP_NOEXCEPT
      : attachmentIndex( attachmentIndex_ )
      , sampleLocationsInfo( sampleLocationsInfo_ )
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentSampleLocationsEXT( AttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentSampleLocationsEXT( VkAttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentSampleLocationsEXT( *reinterpret_cast<AttachmentSampleLocationsEXT const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    AttachmentSampleLocationsEXT & operator=( AttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentSampleLocationsEXT & operator=( VkAttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::AttachmentSampleLocationsEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleLocationsEXT & setAttachmentIndex( uint32_t attachmentIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      attachmentIndex = attachmentIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleLocationsEXT &
                            setSampleLocationsInfo( VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT const & sampleLocationsInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsInfo = sampleLocationsInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkAttachmentSampleLocationsEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentSampleLocationsEXT *>( this );
    }

    explicit operator VkAttachmentSampleLocationsEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentSampleLocationsEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( attachmentIndex, sampleLocationsInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentSampleLocationsEXT const & ) const = default;
#else
    bool operator==( AttachmentSampleLocationsEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( attachmentIndex == rhs.attachmentIndex ) && ( sampleLocationsInfo == rhs.sampleLocationsInfo );
#  endif
    }

    bool operator!=( AttachmentSampleLocationsEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                                     attachmentIndex     = {};
    VULKAN_HPP_NAMESPACE::SampleLocationsInfoEXT sampleLocationsInfo = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::AttachmentSampleLocationsEXT ) == sizeof( VkAttachmentSampleLocationsEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::AttachmentSampleLocationsEXT>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::AttachmentSampleLocationsEXT>::value,
                            "AttachmentSampleLocationsEXT is not nothrow_move_constructible!" );

  struct BaseInStructure
  {
    using NativeType = VkBaseInStructure;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    BaseInStructure( VULKAN_HPP_NAMESPACE::StructureType                  sType_ = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo,
                     const struct VULKAN_HPP_NAMESPACE::BaseInStructure * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : sType( sType_ )
      , pNext( pNext_ )
    {
    }

    BaseInStructure( BaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseInStructure( VkBaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT : BaseInStructure( *reinterpret_cast<BaseInStructure const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BaseInStructure & operator=( BaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseInStructure & operator=( VkBaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BaseInStructure const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BaseInStructure & setPNext( const struct VULKAN_HPP_NAMESPACE::BaseInStructure * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBaseInStructure const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBaseInStructure *>( this );
    }

    explicit operator VkBaseInStructure &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBaseInStructure *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const struct VULKAN_HPP_NAMESPACE::BaseInStructure * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BaseInStructure const & ) const = default;
#else
    bool operator==( BaseInStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext );
#  endif
    }

    bool operator!=( BaseInStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo;
    const struct VULKAN_HPP_NAMESPACE::BaseInStructure * pNext = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BaseInStructure ) == sizeof( VkBaseInStructure ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BaseInStructure>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BaseInStructure>::value,
                            "BaseInStructure is not nothrow_move_constructible!" );

  struct BaseOutStructure
  {
    using NativeType = VkBaseOutStructure;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    BaseOutStructure( VULKAN_HPP_NAMESPACE::StructureType             sType_ = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo,
                      struct VULKAN_HPP_NAMESPACE::BaseOutStructure * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : sType( sType_ )
      , pNext( pNext_ )
    {
    }

    BaseOutStructure( BaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseOutStructure( VkBaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT : BaseOutStructure( *reinterpret_cast<BaseOutStructure const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BaseOutStructure & operator=( BaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseOutStructure & operator=( VkBaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BaseOutStructure const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BaseOutStructure & setPNext( struct VULKAN_HPP_NAMESPACE::BaseOutStructure * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBaseOutStructure const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBaseOutStructure *>( this );
    }

    explicit operator VkBaseOutStructure &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBaseOutStructure *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, struct VULKAN_HPP_NAMESPACE::BaseOutStructure * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BaseOutStructure const & ) const = default;
#else
    bool operator==( BaseOutStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext );
#  endif
    }

    bool operator!=( BaseOutStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType             sType = VULKAN_HPP_NAMESPACE::StructureType::eApplicationInfo;
    struct VULKAN_HPP_NAMESPACE::BaseOutStructure * pNext = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BaseOutStructure ) == sizeof( VkBaseOutStructure ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BaseOutStructure>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BaseOutStructure>::value,
                            "BaseOutStructure is not nothrow_move_constructible!" );

  struct BindAccelerationStructureMemoryInfoNV
  {
    using NativeType = VkBindAccelerationStructureMemoryInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindAccelerationStructureMemoryInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindAccelerationStructureMemoryInfoNV( VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure_ = {},
                                                                VULKAN_HPP_NAMESPACE::DeviceMemory            memory_                = {},
                                                                VULKAN_HPP_NAMESPACE::DeviceSize              memoryOffset_          = {},
                                                                uint32_t                                      deviceIndexCount_      = {},
                                                                const uint32_t *                              pDeviceIndices_        = {},
                                                                const void *                                  pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , accelerationStructure( accelerationStructure_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
      , deviceIndexCount( deviceIndexCount_ )
      , pDeviceIndices( pDeviceIndices_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BindAccelerationStructureMemoryInfoNV( BindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindAccelerationStructureMemoryInfoNV( VkBindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindAccelerationStructureMemoryInfoNV( *reinterpret_cast<BindAccelerationStructureMemoryInfoNV const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindAccelerationStructureMemoryInfoNV( VULKAN_HPP_NAMESPACE::AccelerationStructureNV                         accelerationStructure_,
                                           VULKAN_HPP_NAMESPACE::DeviceMemory                                    memory_,
                                           VULKAN_HPP_NAMESPACE::DeviceSize                                      memoryOffset_,
                                           VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_,
                                           const void *                                                          pNext_ = nullptr )
      : pNext( pNext_ )
      , accelerationStructure( accelerationStructure_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
      , deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) )
      , pDeviceIndices( deviceIndices_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindAccelerationStructureMemoryInfoNV & operator=( BindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindAccelerationStructureMemoryInfoNV & operator=( VkBindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindAccelerationStructureMemoryInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV &
                            setAccelerationStructure( VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindAccelerationStructureMemoryInfoNV &
      setDeviceIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBindAccelerationStructureMemoryInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindAccelerationStructureMemoryInfoNV *>( this );
    }

    explicit operator VkBindAccelerationStructureMemoryInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindAccelerationStructureMemoryInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureNV const &,
               VULKAN_HPP_NAMESPACE::DeviceMemory const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, accelerationStructure, memory, memoryOffset, deviceIndexCount, pDeviceIndices );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindAccelerationStructureMemoryInfoNV const & ) const = default;
#else
    bool operator==( BindAccelerationStructureMemoryInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( accelerationStructure == rhs.accelerationStructure ) && ( memory == rhs.memory ) &&
             ( memoryOffset == rhs.memoryOffset ) && ( deviceIndexCount == rhs.deviceIndexCount ) && ( pDeviceIndices == rhs.pDeviceIndices );
#  endif
    }

    bool operator!=( BindAccelerationStructureMemoryInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType           sType                 = StructureType::eBindAccelerationStructureMemoryInfoNV;
    const void *                                  pNext                 = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureNV accelerationStructure = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory            memory                = {};
    VULKAN_HPP_NAMESPACE::DeviceSize              memoryOffset          = {};
    uint32_t                                      deviceIndexCount      = {};
    const uint32_t *                              pDeviceIndices        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindAccelerationStructureMemoryInfoNV ) == sizeof( VkBindAccelerationStructureMemoryInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindAccelerationStructureMemoryInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindAccelerationStructureMemoryInfoNV>::value,
                            "BindAccelerationStructureMemoryInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindAccelerationStructureMemoryInfoNV>
  {
    using Type = BindAccelerationStructureMemoryInfoNV;
  };

  struct BindBufferMemoryDeviceGroupInfo
  {
    using NativeType = VkBindBufferMemoryDeviceGroupInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindBufferMemoryDeviceGroupInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindBufferMemoryDeviceGroupInfo( uint32_t         deviceIndexCount_ = {},
                                                          const uint32_t * pDeviceIndices_   = {},
                                                          const void *     pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , deviceIndexCount( deviceIndexCount_ )
      , pDeviceIndices( pDeviceIndices_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BindBufferMemoryDeviceGroupInfo( BindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryDeviceGroupInfo( VkBindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindBufferMemoryDeviceGroupInfo( *reinterpret_cast<BindBufferMemoryDeviceGroupInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindBufferMemoryDeviceGroupInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_, const void * pNext_ = nullptr )
      : pNext( pNext_ ), deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) ), pDeviceIndices( deviceIndices_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindBufferMemoryDeviceGroupInfo & operator=( BindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryDeviceGroupInfo & operator=( VkBindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindBufferMemoryDeviceGroupInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo & setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo & setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindBufferMemoryDeviceGroupInfo &
      setDeviceIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBindBufferMemoryDeviceGroupInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindBufferMemoryDeviceGroupInfo *>( this );
    }

    explicit operator VkBindBufferMemoryDeviceGroupInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindBufferMemoryDeviceGroupInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &, const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceIndexCount, pDeviceIndices );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindBufferMemoryDeviceGroupInfo const & ) const = default;
#else
    bool operator==( BindBufferMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceIndexCount == rhs.deviceIndexCount ) && ( pDeviceIndices == rhs.pDeviceIndices );
#  endif
    }

    bool operator!=( BindBufferMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType            = StructureType::eBindBufferMemoryDeviceGroupInfo;
    const void *                        pNext            = {};
    uint32_t                            deviceIndexCount = {};
    const uint32_t *                    pDeviceIndices   = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindBufferMemoryDeviceGroupInfo ) == sizeof( VkBindBufferMemoryDeviceGroupInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindBufferMemoryDeviceGroupInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindBufferMemoryDeviceGroupInfo>::value,
                            "BindBufferMemoryDeviceGroupInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindBufferMemoryDeviceGroupInfo>
  {
    using Type = BindBufferMemoryDeviceGroupInfo;
  };
  using BindBufferMemoryDeviceGroupInfoKHR = BindBufferMemoryDeviceGroupInfo;

  struct BindBufferMemoryInfo
  {
    using NativeType = VkBindBufferMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindBufferMemoryInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindBufferMemoryInfo( VULKAN_HPP_NAMESPACE::Buffer       buffer_       = {},
                                               VULKAN_HPP_NAMESPACE::DeviceMemory memory_       = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize   memoryOffset_ = {},
                                               const void *                       pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , buffer( buffer_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BindBufferMemoryInfo( BindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryInfo( VkBindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindBufferMemoryInfo( *reinterpret_cast<BindBufferMemoryInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindBufferMemoryInfo & operator=( BindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryInfo & operator=( VkBindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindBufferMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBindBufferMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindBufferMemoryInfo *>( this );
    }

    explicit operator VkBindBufferMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindBufferMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceMemory const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer, memory, memoryOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindBufferMemoryInfo const & ) const = default;
#else
    bool operator==( BindBufferMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer ) && ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset );
#  endif
    }

    bool operator!=( BindBufferMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eBindBufferMemoryInfo;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer       = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory  memory       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    memoryOffset = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindBufferMemoryInfo ) == sizeof( VkBindBufferMemoryInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindBufferMemoryInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindBufferMemoryInfo>::value,
                            "BindBufferMemoryInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindBufferMemoryInfo>
  {
    using Type = BindBufferMemoryInfo;
  };
  using BindBufferMemoryInfoKHR = BindBufferMemoryInfo;

  struct Offset2D
  {
    using NativeType = VkOffset2D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Offset2D( int32_t x_ = {}, int32_t y_ = {} ) VULKAN_HPP_NOEXCEPT
      : x( x_ )
      , y( y_ )
    {
    }

    VULKAN_HPP_CONSTEXPR Offset2D( Offset2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset2D( VkOffset2D const & rhs ) VULKAN_HPP_NOEXCEPT : Offset2D( *reinterpret_cast<Offset2D const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Offset2D & operator=( Offset2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset2D & operator=( VkOffset2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Offset2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Offset2D & setX( int32_t x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset2D & setY( int32_t y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkOffset2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkOffset2D *>( this );
    }

    explicit operator VkOffset2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkOffset2D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<int32_t const &, int32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Offset2D const & ) const = default;
#else
    bool operator==( Offset2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y );
#  endif
    }

    bool operator!=( Offset2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    int32_t x = {};
    int32_t y = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::Offset2D ) == sizeof( VkOffset2D ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::Offset2D>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::Offset2D>::value, "Offset2D is not nothrow_move_constructible!" );

  struct Rect2D
  {
    using NativeType = VkRect2D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Rect2D( VULKAN_HPP_NAMESPACE::Offset2D offset_ = {}, VULKAN_HPP_NAMESPACE::Extent2D extent_ = {} ) VULKAN_HPP_NOEXCEPT
      : offset( offset_ )
      , extent( extent_ )
    {
    }

    VULKAN_HPP_CONSTEXPR Rect2D( Rect2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Rect2D( VkRect2D const & rhs ) VULKAN_HPP_NOEXCEPT : Rect2D( *reinterpret_cast<Rect2D const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Rect2D & operator=( Rect2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Rect2D & operator=( VkRect2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Rect2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Rect2D & setOffset( VULKAN_HPP_NAMESPACE::Offset2D const & offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Rect2D & setExtent( VULKAN_HPP_NAMESPACE::Extent2D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkRect2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkRect2D *>( this );
    }

    explicit operator VkRect2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkRect2D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Offset2D const &, VULKAN_HPP_NAMESPACE::Extent2D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( offset, extent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Rect2D const & ) const = default;
#else
    bool operator==( Rect2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( offset == rhs.offset ) && ( extent == rhs.extent );
#  endif
    }

    bool operator!=( Rect2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Offset2D offset = {};
    VULKAN_HPP_NAMESPACE::Extent2D extent = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::Rect2D ) == sizeof( VkRect2D ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::Rect2D>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::Rect2D>::value, "Rect2D is not nothrow_move_constructible!" );

  struct BindImageMemoryDeviceGroupInfo
  {
    using NativeType = VkBindImageMemoryDeviceGroupInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemoryDeviceGroupInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImageMemoryDeviceGroupInfo( uint32_t                             deviceIndexCount_             = {},
                                                         const uint32_t *                     pDeviceIndices_               = {},
                                                         uint32_t                             splitInstanceBindRegionCount_ = {},
                                                         const VULKAN_HPP_NAMESPACE::Rect2D * pSplitInstanceBindRegions_    = {},
                                                         const void *                         pNext_                        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , deviceIndexCount( deviceIndexCount_ )
      , pDeviceIndices( pDeviceIndices_ )
      , splitInstanceBindRegionCount( splitInstanceBindRegionCount_ )
      , pSplitInstanceBindRegions( pSplitInstanceBindRegions_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BindImageMemoryDeviceGroupInfo( BindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryDeviceGroupInfo( VkBindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImageMemoryDeviceGroupInfo( *reinterpret_cast<BindImageMemoryDeviceGroupInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const &                     deviceIndices_,
                                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Rect2D> const & splitInstanceBindRegions_ = {},
                                    const void *                                                                              pNext_ = nullptr )
      : pNext( pNext_ )
      , deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) )
      , pDeviceIndices( deviceIndices_.data() )
      , splitInstanceBindRegionCount( static_cast<uint32_t>( splitInstanceBindRegions_.size() ) )
      , pSplitInstanceBindRegions( splitInstanceBindRegions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindImageMemoryDeviceGroupInfo & operator=( BindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryDeviceGroupInfo & operator=( VkBindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImageMemoryDeviceGroupInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo &
      setDeviceIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setSplitInstanceBindRegionCount( uint32_t splitInstanceBindRegionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      splitInstanceBindRegionCount = splitInstanceBindRegionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo &
                            setPSplitInstanceBindRegions( const VULKAN_HPP_NAMESPACE::Rect2D * pSplitInstanceBindRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pSplitInstanceBindRegions = pSplitInstanceBindRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo & setSplitInstanceBindRegions(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Rect2D> const & splitInstanceBindRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      splitInstanceBindRegionCount = static_cast<uint32_t>( splitInstanceBindRegions_.size() );
      pSplitInstanceBindRegions    = splitInstanceBindRegions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBindImageMemoryDeviceGroupInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemoryDeviceGroupInfo *>( this );
    }

    explicit operator VkBindImageMemoryDeviceGroupInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemoryDeviceGroupInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               const uint32_t * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Rect2D * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceIndexCount, pDeviceIndices, splitInstanceBindRegionCount, pSplitInstanceBindRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemoryDeviceGroupInfo const & ) const = default;
#else
    bool operator==( BindImageMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceIndexCount == rhs.deviceIndexCount ) && ( pDeviceIndices == rhs.pDeviceIndices ) &&
             ( splitInstanceBindRegionCount == rhs.splitInstanceBindRegionCount ) && ( pSplitInstanceBindRegions == rhs.pSplitInstanceBindRegions );
#  endif
    }

    bool operator!=( BindImageMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType  sType                        = StructureType::eBindImageMemoryDeviceGroupInfo;
    const void *                         pNext                        = {};
    uint32_t                             deviceIndexCount             = {};
    const uint32_t *                     pDeviceIndices               = {};
    uint32_t                             splitInstanceBindRegionCount = {};
    const VULKAN_HPP_NAMESPACE::Rect2D * pSplitInstanceBindRegions    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindImageMemoryDeviceGroupInfo ) == sizeof( VkBindImageMemoryDeviceGroupInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindImageMemoryDeviceGroupInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindImageMemoryDeviceGroupInfo>::value,
                            "BindImageMemoryDeviceGroupInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemoryDeviceGroupInfo>
  {
    using Type = BindImageMemoryDeviceGroupInfo;
  };
  using BindImageMemoryDeviceGroupInfoKHR = BindImageMemoryDeviceGroupInfo;

  struct BindImageMemoryInfo
  {
    using NativeType = VkBindImageMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemoryInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImageMemoryInfo( VULKAN_HPP_NAMESPACE::Image        image_        = {},
                                              VULKAN_HPP_NAMESPACE::DeviceMemory memory_       = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize   memoryOffset_ = {},
                                              const void *                       pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , image( image_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BindImageMemoryInfo( BindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryInfo( VkBindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT : BindImageMemoryInfo( *reinterpret_cast<BindImageMemoryInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindImageMemoryInfo & operator=( BindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryInfo & operator=( VkBindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImageMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBindImageMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemoryInfo *>( this );
    }

    explicit operator VkBindImageMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::DeviceMemory const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, image, memory, memoryOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemoryInfo const & ) const = default;
#else
    bool operator==( BindImageMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( image == rhs.image ) && ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset );
#  endif
    }

    bool operator!=( BindImageMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eBindImageMemoryInfo;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::Image         image        = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory  memory       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    memoryOffset = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindImageMemoryInfo ) == sizeof( VkBindImageMemoryInfo ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindImageMemoryInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindImageMemoryInfo>::value,
                            "BindImageMemoryInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemoryInfo>
  {
    using Type = BindImageMemoryInfo;
  };
  using BindImageMemoryInfoKHR = BindImageMemoryInfo;

  struct BindImageMemorySwapchainInfoKHR
  {
    using NativeType = VkBindImageMemorySwapchainInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemorySwapchainInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImageMemorySwapchainInfoKHR( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_  = {},
                                                          uint32_t                           imageIndex_ = {},
                                                          const void *                       pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , swapchain( swapchain_ )
      , imageIndex( imageIndex_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BindImageMemorySwapchainInfoKHR( BindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemorySwapchainInfoKHR( VkBindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImageMemorySwapchainInfoKHR( *reinterpret_cast<BindImageMemorySwapchainInfoKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindImageMemorySwapchainInfoKHR & operator=( BindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemorySwapchainInfoKHR & operator=( VkBindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImageMemorySwapchainInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setSwapchain( VULKAN_HPP_NAMESPACE::SwapchainKHR swapchain_ ) VULKAN_HPP_NOEXCEPT
    {
      swapchain = swapchain_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setImageIndex( uint32_t imageIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      imageIndex = imageIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBindImageMemorySwapchainInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemorySwapchainInfoKHR *>( this );
    }

    explicit operator VkBindImageMemorySwapchainInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemorySwapchainInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::SwapchainKHR const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, swapchain, imageIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemorySwapchainInfoKHR const & ) const = default;
#else
    bool operator==( BindImageMemorySwapchainInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( swapchain == rhs.swapchain ) && ( imageIndex == rhs.imageIndex );
#  endif
    }

    bool operator!=( BindImageMemorySwapchainInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eBindImageMemorySwapchainInfoKHR;
    const void *                        pNext      = {};
    VULKAN_HPP_NAMESPACE::SwapchainKHR  swapchain  = {};
    uint32_t                            imageIndex = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindImageMemorySwapchainInfoKHR ) == sizeof( VkBindImageMemorySwapchainInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindImageMemorySwapchainInfoKHR>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindImageMemorySwapchainInfoKHR>::value,
                            "BindImageMemorySwapchainInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemorySwapchainInfoKHR>
  {
    using Type = BindImageMemorySwapchainInfoKHR;
  };

  struct BindImagePlaneMemoryInfo
  {
    using NativeType = VkBindImagePlaneMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImagePlaneMemoryInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImagePlaneMemoryInfo( VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect_ = VULKAN_HPP_NAMESPACE::ImageAspectFlagBits::eColor,
                                                   const void *                              pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , planeAspect( planeAspect_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BindImagePlaneMemoryInfo( BindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImagePlaneMemoryInfo( VkBindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImagePlaneMemoryInfo( *reinterpret_cast<BindImagePlaneMemoryInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindImagePlaneMemoryInfo & operator=( BindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImagePlaneMemoryInfo & operator=( VkBindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindImagePlaneMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImagePlaneMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImagePlaneMemoryInfo & setPlaneAspect( VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect_ ) VULKAN_HPP_NOEXCEPT
    {
      planeAspect = planeAspect_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBindImagePlaneMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImagePlaneMemoryInfo *>( this );
    }

    explicit operator VkBindImagePlaneMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImagePlaneMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::ImageAspectFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, planeAspect );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImagePlaneMemoryInfo const & ) const = default;
#else
    bool operator==( BindImagePlaneMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( planeAspect == rhs.planeAspect );
#  endif
    }

    bool operator!=( BindImagePlaneMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType       = StructureType::eBindImagePlaneMemoryInfo;
    const void *                              pNext       = {};
    VULKAN_HPP_NAMESPACE::ImageAspectFlagBits planeAspect = VULKAN_HPP_NAMESPACE::ImageAspectFlagBits::eColor;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindImagePlaneMemoryInfo ) == sizeof( VkBindImagePlaneMemoryInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindImagePlaneMemoryInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindImagePlaneMemoryInfo>::value,
                            "BindImagePlaneMemoryInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindImagePlaneMemoryInfo>
  {
    using Type = BindImagePlaneMemoryInfo;
  };
  using BindImagePlaneMemoryInfoKHR = BindImagePlaneMemoryInfo;

  struct BindIndexBufferIndirectCommandNV
  {
    using NativeType = VkBindIndexBufferIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BindIndexBufferIndirectCommandNV( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ = {},
                                        uint32_t                            size_          = {},
                                        VULKAN_HPP_NAMESPACE::IndexType     indexType_     = VULKAN_HPP_NAMESPACE::IndexType::eUint16 ) VULKAN_HPP_NOEXCEPT
      : bufferAddress( bufferAddress_ )
      , size( size_ )
      , indexType( indexType_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BindIndexBufferIndirectCommandNV( BindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindIndexBufferIndirectCommandNV( VkBindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindIndexBufferIndirectCommandNV( *reinterpret_cast<BindIndexBufferIndirectCommandNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindIndexBufferIndirectCommandNV & operator=( BindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindIndexBufferIndirectCommandNV & operator=( VkBindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindIndexBufferIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandNV & setBufferAddress( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferAddress = bufferAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandNV & setSize( uint32_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandNV & setIndexType( VULKAN_HPP_NAMESPACE::IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBindIndexBufferIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindIndexBufferIndirectCommandNV *>( this );
    }

    explicit operator VkBindIndexBufferIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindIndexBufferIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceAddress const &, uint32_t const &, VULKAN_HPP_NAMESPACE::IndexType const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferAddress, size, indexType );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindIndexBufferIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindIndexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferAddress == rhs.bufferAddress ) && ( size == rhs.size ) && ( indexType == rhs.indexType );
#  endif
    }

    bool operator!=( BindIndexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress = {};
    uint32_t                            size          = {};
    VULKAN_HPP_NAMESPACE::IndexType     indexType     = VULKAN_HPP_NAMESPACE::IndexType::eUint16;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindIndexBufferIndirectCommandNV ) == sizeof( VkBindIndexBufferIndirectCommandNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindIndexBufferIndirectCommandNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindIndexBufferIndirectCommandNV>::value,
                            "BindIndexBufferIndirectCommandNV is not nothrow_move_constructible!" );

  struct BindShaderGroupIndirectCommandNV
  {
    using NativeType = VkBindShaderGroupIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindShaderGroupIndirectCommandNV( uint32_t groupIndex_ = {} ) VULKAN_HPP_NOEXCEPT : groupIndex( groupIndex_ ) {}

    VULKAN_HPP_CONSTEXPR BindShaderGroupIndirectCommandNV( BindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindShaderGroupIndirectCommandNV( VkBindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindShaderGroupIndirectCommandNV( *reinterpret_cast<BindShaderGroupIndirectCommandNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindShaderGroupIndirectCommandNV & operator=( BindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindShaderGroupIndirectCommandNV & operator=( VkBindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindShaderGroupIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindShaderGroupIndirectCommandNV & setGroupIndex( uint32_t groupIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      groupIndex = groupIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBindShaderGroupIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindShaderGroupIndirectCommandNV *>( this );
    }

    explicit operator VkBindShaderGroupIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindShaderGroupIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( groupIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindShaderGroupIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindShaderGroupIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( groupIndex == rhs.groupIndex );
#  endif
    }

    bool operator!=( BindShaderGroupIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t groupIndex = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindShaderGroupIndirectCommandNV ) == sizeof( VkBindShaderGroupIndirectCommandNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindShaderGroupIndirectCommandNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindShaderGroupIndirectCommandNV>::value,
                            "BindShaderGroupIndirectCommandNV is not nothrow_move_constructible!" );

  struct SparseMemoryBind
  {
    using NativeType = VkSparseMemoryBind;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseMemoryBind( VULKAN_HPP_NAMESPACE::DeviceSize            resourceOffset_ = {},
                                           VULKAN_HPP_NAMESPACE::DeviceSize            size_           = {},
                                           VULKAN_HPP_NAMESPACE::DeviceMemory          memory_         = {},
                                           VULKAN_HPP_NAMESPACE::DeviceSize            memoryOffset_   = {},
                                           VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags_          = {} ) VULKAN_HPP_NOEXCEPT
      : resourceOffset( resourceOffset_ )
      , size( size_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
      , flags( flags_ )
    {
    }

    VULKAN_HPP_CONSTEXPR SparseMemoryBind( SparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseMemoryBind( VkSparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT : SparseMemoryBind( *reinterpret_cast<SparseMemoryBind const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SparseMemoryBind & operator=( SparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseMemoryBind & operator=( VkSparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseMemoryBind const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setResourceOffset( VULKAN_HPP_NAMESPACE::DeviceSize resourceOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      resourceOffset = resourceOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setFlags( VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkSparseMemoryBind const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseMemoryBind *>( this );
    }

    explicit operator VkSparseMemoryBind &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseMemoryBind *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceMemory const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( resourceOffset, size, memory, memoryOffset, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseMemoryBind const & ) const = default;
#else
    bool operator==( SparseMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( resourceOffset == rhs.resourceOffset ) && ( size == rhs.size ) && ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset ) &&
             ( flags == rhs.flags );
#  endif
    }

    bool operator!=( SparseMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceSize            resourceOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize            size           = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory          memory         = {};
    VULKAN_HPP_NAMESPACE::DeviceSize            memoryOffset   = {};
    VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags          = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SparseMemoryBind ) == sizeof( VkSparseMemoryBind ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SparseMemoryBind>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SparseMemoryBind>::value,
                            "SparseMemoryBind is not nothrow_move_constructible!" );

  struct SparseBufferMemoryBindInfo
  {
    using NativeType = VkSparseBufferMemoryBindInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseBufferMemoryBindInfo( VULKAN_HPP_NAMESPACE::Buffer                   buffer_    = {},
                                                     uint32_t                                       bindCount_ = {},
                                                     const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds_    = {} ) VULKAN_HPP_NOEXCEPT
      : buffer( buffer_ )
      , bindCount( bindCount_ )
      , pBinds( pBinds_ )
    {
    }

    VULKAN_HPP_CONSTEXPR SparseBufferMemoryBindInfo( SparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseBufferMemoryBindInfo( VkSparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseBufferMemoryBindInfo( *reinterpret_cast<SparseBufferMemoryBindInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseBufferMemoryBindInfo( VULKAN_HPP_NAMESPACE::Buffer                                                                        buffer_,
                                VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseMemoryBind> const & binds_ )
      : buffer( buffer_ ), bindCount( static_cast<uint32_t>( binds_.size() ) ), pBinds( binds_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SparseBufferMemoryBindInfo & operator=( SparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseBufferMemoryBindInfo & operator=( VkSparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseBufferMemoryBindInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseBufferMemoryBindInfo & setBindCount( uint32_t bindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = bindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseBufferMemoryBindInfo & setPBinds( const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBinds = pBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseBufferMemoryBindInfo &
      setBinds( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseMemoryBind> const & binds_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = static_cast<uint32_t>( binds_.size() );
      pBinds    = binds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkSparseBufferMemoryBindInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseBufferMemoryBindInfo *>( this );
    }

    explicit operator VkSparseBufferMemoryBindInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseBufferMemoryBindInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Buffer const &, uint32_t const &, const VULKAN_HPP_NAMESPACE::SparseMemoryBind * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( buffer, bindCount, pBinds );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseBufferMemoryBindInfo const & ) const = default;
#else
    bool operator==( SparseBufferMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( buffer == rhs.buffer ) && ( bindCount == rhs.bindCount ) && ( pBinds == rhs.pBinds );
#  endif
    }

    bool operator!=( SparseBufferMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Buffer                   buffer    = {};
    uint32_t                                       bindCount = {};
    const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo ) == sizeof( VkSparseBufferMemoryBindInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo>::value,
                            "SparseBufferMemoryBindInfo is not nothrow_move_constructible!" );

  struct SparseImageOpaqueMemoryBindInfo
  {
    using NativeType = VkSparseImageOpaqueMemoryBindInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseImageOpaqueMemoryBindInfo( VULKAN_HPP_NAMESPACE::Image                    image_     = {},
                                                          uint32_t                                       bindCount_ = {},
                                                          const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds_    = {} ) VULKAN_HPP_NOEXCEPT
      : image( image_ )
      , bindCount( bindCount_ )
      , pBinds( pBinds_ )
    {
    }

    VULKAN_HPP_CONSTEXPR SparseImageOpaqueMemoryBindInfo( SparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageOpaqueMemoryBindInfo( VkSparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseImageOpaqueMemoryBindInfo( *reinterpret_cast<SparseImageOpaqueMemoryBindInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageOpaqueMemoryBindInfo( VULKAN_HPP_NAMESPACE::Image                                                                         image_,
                                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseMemoryBind> const & binds_ )
      : image( image_ ), bindCount( static_cast<uint32_t>( binds_.size() ) ), pBinds( binds_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SparseImageOpaqueMemoryBindInfo & operator=( SparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageOpaqueMemoryBindInfo & operator=( VkSparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseImageOpaqueMemoryBindInfo & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageOpaqueMemoryBindInfo & setBindCount( uint32_t bindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = bindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageOpaqueMemoryBindInfo & setPBinds( const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBinds = pBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageOpaqueMemoryBindInfo &
      setBinds( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseMemoryBind> const & binds_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = static_cast<uint32_t>( binds_.size() );
      pBinds    = binds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkSparseImageOpaqueMemoryBindInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseImageOpaqueMemoryBindInfo *>( this );
    }

    explicit operator VkSparseImageOpaqueMemoryBindInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseImageOpaqueMemoryBindInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Image const &, uint32_t const &, const VULKAN_HPP_NAMESPACE::SparseMemoryBind * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( image, bindCount, pBinds );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseImageOpaqueMemoryBindInfo const & ) const = default;
#else
    bool operator==( SparseImageOpaqueMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( image == rhs.image ) && ( bindCount == rhs.bindCount ) && ( pBinds == rhs.pBinds );
#  endif
    }

    bool operator!=( SparseImageOpaqueMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Image                    image     = {};
    uint32_t                                       bindCount = {};
    const VULKAN_HPP_NAMESPACE::SparseMemoryBind * pBinds    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo ) == sizeof( VkSparseImageOpaqueMemoryBindInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo>::value,
                            "SparseImageOpaqueMemoryBindInfo is not nothrow_move_constructible!" );

  struct ImageSubresource
  {
    using NativeType = VkImageSubresource;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      ImageSubresource( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ = {}, uint32_t mipLevel_ = {}, uint32_t arrayLayer_ = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask( aspectMask_ )
      , mipLevel( mipLevel_ )
      , arrayLayer( arrayLayer_ )
    {
    }

    VULKAN_HPP_CONSTEXPR ImageSubresource( ImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresource( VkImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT : ImageSubresource( *reinterpret_cast<ImageSubresource const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageSubresource & operator=( ImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresource & operator=( VkImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageSubresource const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageSubresource & setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresource & setMipLevel( uint32_t mipLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      mipLevel = mipLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresource & setArrayLayer( uint32_t arrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      arrayLayer = arrayLayer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkImageSubresource const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageSubresource *>( this );
    }

    explicit operator VkImageSubresource &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageSubresource *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageAspectFlags const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( aspectMask, mipLevel, arrayLayer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageSubresource const & ) const = default;
#else
    bool operator==( ImageSubresource const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( aspectMask == rhs.aspectMask ) && ( mipLevel == rhs.mipLevel ) && ( arrayLayer == rhs.arrayLayer );
#  endif
    }

    bool operator!=( ImageSubresource const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask = {};
    uint32_t                               mipLevel   = {};
    uint32_t                               arrayLayer = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ImageSubresource ) == sizeof( VkImageSubresource ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ImageSubresource>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ImageSubresource>::value,
                            "ImageSubresource is not nothrow_move_constructible!" );

  struct Offset3D
  {
    using NativeType = VkOffset3D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Offset3D( int32_t x_ = {}, int32_t y_ = {}, int32_t z_ = {} ) VULKAN_HPP_NOEXCEPT
      : x( x_ )
      , y( y_ )
      , z( z_ )
    {
    }

    VULKAN_HPP_CONSTEXPR Offset3D( Offset3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset3D( VkOffset3D const & rhs ) VULKAN_HPP_NOEXCEPT : Offset3D( *reinterpret_cast<Offset3D const *>( &rhs ) ) {}

    explicit Offset3D( Offset2D const & offset2D, int32_t z_ = {} ) : x( offset2D.x ), y( offset2D.y ), z( z_ ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Offset3D & operator=( Offset3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset3D & operator=( VkOffset3D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Offset3D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Offset3D & setX( int32_t x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset3D & setY( int32_t y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset3D & setZ( int32_t z_ ) VULKAN_HPP_NOEXCEPT
    {
      z = z_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkOffset3D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkOffset3D *>( this );
    }

    explicit operator VkOffset3D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkOffset3D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<int32_t const &, int32_t const &, int32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y, z );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Offset3D const & ) const = default;
#else
    bool operator==( Offset3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y ) && ( z == rhs.z );
#  endif
    }

    bool operator!=( Offset3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    int32_t x = {};
    int32_t y = {};
    int32_t z = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::Offset3D ) == sizeof( VkOffset3D ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::Offset3D>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::Offset3D>::value, "Offset3D is not nothrow_move_constructible!" );

  struct Extent3D
  {
    using NativeType = VkExtent3D;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Extent3D( uint32_t width_ = {}, uint32_t height_ = {}, uint32_t depth_ = {} ) VULKAN_HPP_NOEXCEPT
      : width( width_ )
      , height( height_ )
      , depth( depth_ )
    {
    }

    VULKAN_HPP_CONSTEXPR Extent3D( Extent3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent3D( VkExtent3D const & rhs ) VULKAN_HPP_NOEXCEPT : Extent3D( *reinterpret_cast<Extent3D const *>( &rhs ) ) {}

    explicit Extent3D( Extent2D const & extent2D, uint32_t depth_ = {} ) : width( extent2D.width ), height( extent2D.height ), depth( depth_ ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Extent3D & operator=( Extent3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent3D & operator=( VkExtent3D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Extent3D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Extent3D & setWidth( uint32_t width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent3D & setHeight( uint32_t height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent3D & setDepth( uint32_t depth_ ) VULKAN_HPP_NOEXCEPT
    {
      depth = depth_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkExtent3D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExtent3D *>( this );
    }

    explicit operator VkExtent3D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExtent3D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( width, height, depth );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Extent3D const & ) const = default;
#else
    bool operator==( Extent3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( width == rhs.width ) && ( height == rhs.height ) && ( depth == rhs.depth );
#  endif
    }

    bool operator!=( Extent3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t width  = {};
    uint32_t height = {};
    uint32_t depth  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::Extent3D ) == sizeof( VkExtent3D ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::Extent3D>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::Extent3D>::value, "Extent3D is not nothrow_move_constructible!" );

  struct SparseImageMemoryBind
  {
    using NativeType = VkSparseImageMemoryBind;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseImageMemoryBind( VULKAN_HPP_NAMESPACE::ImageSubresource      subresource_  = {},
                                                VULKAN_HPP_NAMESPACE::Offset3D              offset_       = {},
                                                VULKAN_HPP_NAMESPACE::Extent3D              extent_       = {},
                                                VULKAN_HPP_NAMESPACE::DeviceMemory          memory_       = {},
                                                VULKAN_HPP_NAMESPACE::DeviceSize            memoryOffset_ = {},
                                                VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags_        = {} ) VULKAN_HPP_NOEXCEPT
      : subresource( subresource_ )
      , offset( offset_ )
      , extent( extent_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
      , flags( flags_ )
    {
    }

    VULKAN_HPP_CONSTEXPR SparseImageMemoryBind( SparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageMemoryBind( VkSparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseImageMemoryBind( *reinterpret_cast<SparseImageMemoryBind const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SparseImageMemoryBind & operator=( SparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageMemoryBind & operator=( VkSparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseImageMemoryBind const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setSubresource( VULKAN_HPP_NAMESPACE::ImageSubresource const & subresource_ ) VULKAN_HPP_NOEXCEPT
    {
      subresource = subresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setOffset( VULKAN_HPP_NAMESPACE::Offset3D const & offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setExtent( VULKAN_HPP_NAMESPACE::Extent3D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setMemoryOffset( VULKAN_HPP_NAMESPACE::DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setFlags( VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkSparseImageMemoryBind const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseImageMemoryBind *>( this );
    }

    explicit operator VkSparseImageMemoryBind &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseImageMemoryBind *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageSubresource const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &,
               VULKAN_HPP_NAMESPACE::DeviceMemory const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( subresource, offset, extent, memory, memoryOffset, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseImageMemoryBind const & ) const = default;
#else
    bool operator==( SparseImageMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( subresource == rhs.subresource ) && ( offset == rhs.offset ) && ( extent == rhs.extent ) && ( memory == rhs.memory ) &&
             ( memoryOffset == rhs.memoryOffset ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( SparseImageMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageSubresource      subresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D              offset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D              extent       = {};
    VULKAN_HPP_NAMESPACE::DeviceMemory          memory       = {};
    VULKAN_HPP_NAMESPACE::DeviceSize            memoryOffset = {};
    VULKAN_HPP_NAMESPACE::SparseMemoryBindFlags flags        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SparseImageMemoryBind ) == sizeof( VkSparseImageMemoryBind ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SparseImageMemoryBind>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SparseImageMemoryBind>::value,
                            "SparseImageMemoryBind is not nothrow_move_constructible!" );

  struct SparseImageMemoryBindInfo
  {
    using NativeType = VkSparseImageMemoryBindInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseImageMemoryBindInfo( VULKAN_HPP_NAMESPACE::Image                         image_     = {},
                                                    uint32_t                                            bindCount_ = {},
                                                    const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind * pBinds_    = {} ) VULKAN_HPP_NOEXCEPT
      : image( image_ )
      , bindCount( bindCount_ )
      , pBinds( pBinds_ )
    {
    }

    VULKAN_HPP_CONSTEXPR SparseImageMemoryBindInfo( SparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageMemoryBindInfo( VkSparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseImageMemoryBindInfo( *reinterpret_cast<SparseImageMemoryBindInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageMemoryBindInfo( VULKAN_HPP_NAMESPACE::Image                                                                              image_,
                               VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind> const & binds_ )
      : image( image_ ), bindCount( static_cast<uint32_t>( binds_.size() ) ), pBinds( binds_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SparseImageMemoryBindInfo & operator=( SparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageMemoryBindInfo & operator=( VkSparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBindInfo & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBindInfo & setBindCount( uint32_t bindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = bindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBindInfo & setPBinds( const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind * pBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBinds = pBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageMemoryBindInfo &
      setBinds( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind> const & binds_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = static_cast<uint32_t>( binds_.size() );
      pBinds    = binds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkSparseImageMemoryBindInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseImageMemoryBindInfo *>( this );
    }

    explicit operator VkSparseImageMemoryBindInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseImageMemoryBindInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Image const &, uint32_t const &, const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( image, bindCount, pBinds );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseImageMemoryBindInfo const & ) const = default;
#else
    bool operator==( SparseImageMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( image == rhs.image ) && ( bindCount == rhs.bindCount ) && ( pBinds == rhs.pBinds );
#  endif
    }

    bool operator!=( SparseImageMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Image                         image     = {};
    uint32_t                                            bindCount = {};
    const VULKAN_HPP_NAMESPACE::SparseImageMemoryBind * pBinds    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo ) == sizeof( VkSparseImageMemoryBindInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo>::value,
                            "SparseImageMemoryBindInfo is not nothrow_move_constructible!" );

  struct BindSparseInfo
  {
    using NativeType = VkBindSparseInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindSparseInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindSparseInfo( uint32_t                                                      waitSemaphoreCount_   = {},
                                         const VULKAN_HPP_NAMESPACE::Semaphore *                       pWaitSemaphores_      = {},
                                         uint32_t                                                      bufferBindCount_      = {},
                                         const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo *      pBufferBinds_         = {},
                                         uint32_t                                                      imageOpaqueBindCount_ = {},
                                         const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo * pImageOpaqueBinds_    = {},
                                         uint32_t                                                      imageBindCount_       = {},
                                         const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo *       pImageBinds_          = {},
                                         uint32_t                                                      signalSemaphoreCount_ = {},
                                         const VULKAN_HPP_NAMESPACE::Semaphore *                       pSignalSemaphores_    = {},
                                         const void *                                                  pNext_                = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , waitSemaphoreCount( waitSemaphoreCount_ )
      , pWaitSemaphores( pWaitSemaphores_ )
      , bufferBindCount( bufferBindCount_ )
      , pBufferBinds( pBufferBinds_ )
      , imageOpaqueBindCount( imageOpaqueBindCount_ )
      , pImageOpaqueBinds( pImageOpaqueBinds_ )
      , imageBindCount( imageBindCount_ )
      , pImageBinds( pImageBinds_ )
      , signalSemaphoreCount( signalSemaphoreCount_ )
      , pSignalSemaphores( pSignalSemaphores_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BindSparseInfo( BindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindSparseInfo( VkBindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT : BindSparseInfo( *reinterpret_cast<BindSparseInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Semaphore> const &                       waitSemaphores_,
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo> const &      bufferBinds_      = {},
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo> const & imageOpaqueBinds_ = {},
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo> const &       imageBinds_       = {},
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Semaphore> const &                       signalSemaphores_ = {},
                    const void *                                                                                                       pNext_ = nullptr )
      : pNext( pNext_ )
      , waitSemaphoreCount( static_cast<uint32_t>( waitSemaphores_.size() ) )
      , pWaitSemaphores( waitSemaphores_.data() )
      , bufferBindCount( static_cast<uint32_t>( bufferBinds_.size() ) )
      , pBufferBinds( bufferBinds_.data() )
      , imageOpaqueBindCount( static_cast<uint32_t>( imageOpaqueBinds_.size() ) )
      , pImageOpaqueBinds( imageOpaqueBinds_.data() )
      , imageBindCount( static_cast<uint32_t>( imageBinds_.size() ) )
      , pImageBinds( imageBinds_.data() )
      , signalSemaphoreCount( static_cast<uint32_t>( signalSemaphores_.size() ) )
      , pSignalSemaphores( signalSemaphores_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindSparseInfo & operator=( BindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindSparseInfo & operator=( VkBindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindSparseInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setWaitSemaphoreCount( uint32_t waitSemaphoreCount_ ) VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreCount = waitSemaphoreCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPWaitSemaphores( const VULKAN_HPP_NAMESPACE::Semaphore * pWaitSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      pWaitSemaphores = pWaitSemaphores_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo &
      setWaitSemaphores( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Semaphore> const & waitSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreCount = static_cast<uint32_t>( waitSemaphores_.size() );
      pWaitSemaphores    = waitSemaphores_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setBufferBindCount( uint32_t bufferBindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferBindCount = bufferBindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPBufferBinds( const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo * pBufferBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBufferBinds = pBufferBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setBufferBinds(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo> const & bufferBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferBindCount = static_cast<uint32_t>( bufferBinds_.size() );
      pBufferBinds    = bufferBinds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setImageOpaqueBindCount( uint32_t imageOpaqueBindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOpaqueBindCount = imageOpaqueBindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo &
                            setPImageOpaqueBinds( const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo * pImageOpaqueBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pImageOpaqueBinds = pImageOpaqueBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setImageOpaqueBinds(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo> const & imageOpaqueBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOpaqueBindCount = static_cast<uint32_t>( imageOpaqueBinds_.size() );
      pImageOpaqueBinds    = imageOpaqueBinds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setImageBindCount( uint32_t imageBindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      imageBindCount = imageBindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPImageBinds( const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo * pImageBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pImageBinds = pImageBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setImageBinds( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo> const & imageBinds_ )
      VULKAN_HPP_NOEXCEPT
    {
      imageBindCount = static_cast<uint32_t>( imageBinds_.size() );
      pImageBinds    = imageBinds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setSignalSemaphoreCount( uint32_t signalSemaphoreCount_ ) VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreCount = signalSemaphoreCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPSignalSemaphores( const VULKAN_HPP_NAMESPACE::Semaphore * pSignalSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      pSignalSemaphores = pSignalSemaphores_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo &
      setSignalSemaphores( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Semaphore> const & signalSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreCount = static_cast<uint32_t>( signalSemaphores_.size() );
      pSignalSemaphores    = signalSemaphores_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBindSparseInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindSparseInfo *>( this );
    }

    explicit operator VkBindSparseInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindSparseInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Semaphore * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Semaphore * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       waitSemaphoreCount,
                       pWaitSemaphores,
                       bufferBindCount,
                       pBufferBinds,
                       imageOpaqueBindCount,
                       pImageOpaqueBinds,
                       imageBindCount,
                       pImageBinds,
                       signalSemaphoreCount,
                       pSignalSemaphores );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindSparseInfo const & ) const = default;
#else
    bool operator==( BindSparseInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( waitSemaphoreCount == rhs.waitSemaphoreCount ) &&
             ( pWaitSemaphores == rhs.pWaitSemaphores ) && ( bufferBindCount == rhs.bufferBindCount ) && ( pBufferBinds == rhs.pBufferBinds ) &&
             ( imageOpaqueBindCount == rhs.imageOpaqueBindCount ) && ( pImageOpaqueBinds == rhs.pImageOpaqueBinds ) &&
             ( imageBindCount == rhs.imageBindCount ) && ( pImageBinds == rhs.pImageBinds ) && ( signalSemaphoreCount == rhs.signalSemaphoreCount ) &&
             ( pSignalSemaphores == rhs.pSignalSemaphores );
#  endif
    }

    bool operator!=( BindSparseInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                           sType                = StructureType::eBindSparseInfo;
    const void *                                                  pNext                = {};
    uint32_t                                                      waitSemaphoreCount   = {};
    const VULKAN_HPP_NAMESPACE::Semaphore *                       pWaitSemaphores      = {};
    uint32_t                                                      bufferBindCount      = {};
    const VULKAN_HPP_NAMESPACE::SparseBufferMemoryBindInfo *      pBufferBinds         = {};
    uint32_t                                                      imageOpaqueBindCount = {};
    const VULKAN_HPP_NAMESPACE::SparseImageOpaqueMemoryBindInfo * pImageOpaqueBinds    = {};
    uint32_t                                                      imageBindCount       = {};
    const VULKAN_HPP_NAMESPACE::SparseImageMemoryBindInfo *       pImageBinds          = {};
    uint32_t                                                      signalSemaphoreCount = {};
    const VULKAN_HPP_NAMESPACE::Semaphore *                       pSignalSemaphores    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindSparseInfo ) == sizeof( VkBindSparseInfo ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindSparseInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindSparseInfo>::value,
                            "BindSparseInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBindSparseInfo>
  {
    using Type = BindSparseInfo;
  };

  struct BindVertexBufferIndirectCommandNV
  {
    using NativeType = VkBindVertexBufferIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindVertexBufferIndirectCommandNV( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ = {},
                                                            uint32_t                            size_          = {},
                                                            uint32_t                            stride_        = {} ) VULKAN_HPP_NOEXCEPT
      : bufferAddress( bufferAddress_ )
      , size( size_ )
      , stride( stride_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BindVertexBufferIndirectCommandNV( BindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindVertexBufferIndirectCommandNV( VkBindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindVertexBufferIndirectCommandNV( *reinterpret_cast<BindVertexBufferIndirectCommandNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BindVertexBufferIndirectCommandNV & operator=( BindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindVertexBufferIndirectCommandNV & operator=( VkBindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BindVertexBufferIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandNV & setBufferAddress( VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferAddress = bufferAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandNV & setSize( uint32_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandNV & setStride( uint32_t stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBindVertexBufferIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindVertexBufferIndirectCommandNV *>( this );
    }

    explicit operator VkBindVertexBufferIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindVertexBufferIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceAddress const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferAddress, size, stride );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindVertexBufferIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindVertexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferAddress == rhs.bufferAddress ) && ( size == rhs.size ) && ( stride == rhs.stride );
#  endif
    }

    bool operator!=( BindVertexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceAddress bufferAddress = {};
    uint32_t                            size          = {};
    uint32_t                            stride        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BindVertexBufferIndirectCommandNV ) == sizeof( VkBindVertexBufferIndirectCommandNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BindVertexBufferIndirectCommandNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BindVertexBufferIndirectCommandNV>::value,
                            "BindVertexBufferIndirectCommandNV is not nothrow_move_constructible!" );

  struct ImageSubresourceLayers
  {
    using NativeType = VkImageSubresourceLayers;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageSubresourceLayers( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_     = {},
                                                 uint32_t                               mipLevel_       = {},
                                                 uint32_t                               baseArrayLayer_ = {},
                                                 uint32_t                               layerCount_     = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask( aspectMask_ )
      , mipLevel( mipLevel_ )
      , baseArrayLayer( baseArrayLayer_ )
      , layerCount( layerCount_ )
    {
    }

    VULKAN_HPP_CONSTEXPR ImageSubresourceLayers( ImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresourceLayers( VkImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageSubresourceLayers( *reinterpret_cast<ImageSubresourceLayers const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageSubresourceLayers & operator=( ImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresourceLayers & operator=( VkImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setMipLevel( uint32_t mipLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      mipLevel = mipLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setBaseArrayLayer( uint32_t baseArrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      baseArrayLayer = baseArrayLayer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkImageSubresourceLayers const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageSubresourceLayers *>( this );
    }

    explicit operator VkImageSubresourceLayers &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageSubresourceLayers *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageAspectFlags const &, uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( aspectMask, mipLevel, baseArrayLayer, layerCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageSubresourceLayers const & ) const = default;
#else
    bool operator==( ImageSubresourceLayers const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( aspectMask == rhs.aspectMask ) && ( mipLevel == rhs.mipLevel ) && ( baseArrayLayer == rhs.baseArrayLayer ) && ( layerCount == rhs.layerCount );
#  endif
    }

    bool operator!=( ImageSubresourceLayers const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask     = {};
    uint32_t                               mipLevel       = {};
    uint32_t                               baseArrayLayer = {};
    uint32_t                               layerCount     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers ) == sizeof( VkImageSubresourceLayers ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ImageSubresourceLayers>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ImageSubresourceLayers>::value,
                            "ImageSubresourceLayers is not nothrow_move_constructible!" );

  struct ImageBlit2
  {
    using NativeType = VkImageBlit2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageBlit2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ImageBlit2( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers          srcSubresource_ = {},
                                        std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & srcOffsets_     = {},
                                        VULKAN_HPP_NAMESPACE::ImageSubresourceLayers          dstSubresource_ = {},
                                        std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & dstOffsets_     = {},
                                        const void *                                          pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , srcSubresource( srcSubresource_ )
      , srcOffsets( srcOffsets_ )
      , dstSubresource( dstSubresource_ )
      , dstOffsets( dstOffsets_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2( ImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageBlit2( VkImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT : ImageBlit2( *reinterpret_cast<ImageBlit2 const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageBlit2 & operator=( ImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageBlit2 & operator=( VkImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageBlit2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setSrcSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & srcSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSubresource = srcSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setSrcOffsets( std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & srcOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffsets = srcOffsets_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setDstSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & dstSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSubresource = dstSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setDstOffsets( std::array<VULKAN_HPP_NAMESPACE::Offset3D, 2> const & dstOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffsets = dstOffsets_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkImageBlit2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageBlit2 *>( this );
    }

    explicit operator VkImageBlit2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageBlit2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcSubresource, srcOffsets, dstSubresource, dstOffsets );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageBlit2 const & ) const = default;
#else
    bool operator==( ImageBlit2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSubresource == rhs.srcSubresource ) && ( srcOffsets == rhs.srcOffsets ) &&
             ( dstSubresource == rhs.dstSubresource ) && ( dstOffsets == rhs.dstOffsets );
#  endif
    }

    bool operator!=( ImageBlit2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                                     sType          = StructureType::eImageBlit2;
    const void *                                                            pNext          = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers                            srcSubresource = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> srcOffsets     = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers                            dstSubresource = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<VULKAN_HPP_NAMESPACE::Offset3D, 2> dstOffsets     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ImageBlit2 ) == sizeof( VkImageBlit2 ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ImageBlit2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ImageBlit2>::value, "ImageBlit2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eImageBlit2>
  {
    using Type = ImageBlit2;
  };
  using ImageBlit2KHR = ImageBlit2;

  struct BlitImageInfo2
  {
    using NativeType = VkBlitImageInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBlitImageInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2( VULKAN_HPP_NAMESPACE::Image              srcImage_       = {},
                                            VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                            VULKAN_HPP_NAMESPACE::Image              dstImage_       = {},
                                            VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                            uint32_t                                 regionCount_    = {},
                                            const VULKAN_HPP_NAMESPACE::ImageBlit2 * pRegions_       = {},
                                            VULKAN_HPP_NAMESPACE::Filter             filter_         = VULKAN_HPP_NAMESPACE::Filter::eNearest,
                                            const void *                             pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( regionCount_ )
      , pRegions( pRegions_ )
      , filter( filter_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2( BlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BlitImageInfo2( VkBlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT : BlitImageInfo2( *reinterpret_cast<BlitImageInfo2 const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BlitImageInfo2( VULKAN_HPP_NAMESPACE::Image                                                                   srcImage_,
                    VULKAN_HPP_NAMESPACE::ImageLayout                                                             srcImageLayout_,
                    VULKAN_HPP_NAMESPACE::Image                                                                   dstImage_,
                    VULKAN_HPP_NAMESPACE::ImageLayout                                                             dstImageLayout_,
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageBlit2> const & regions_,
                    VULKAN_HPP_NAMESPACE::Filter filter_ = VULKAN_HPP_NAMESPACE::Filter::eNearest,
                    const void *                 pNext_  = nullptr )
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
      , filter( filter_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BlitImageInfo2 & operator=( BlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BlitImageInfo2 & operator=( VkBlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BlitImageInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::ImageBlit2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BlitImageInfo2 & setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageBlit2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setFilter( VULKAN_HPP_NAMESPACE::Filter filter_ ) VULKAN_HPP_NOEXCEPT
    {
      filter = filter_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBlitImageInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBlitImageInfo2 *>( this );
    }

    explicit operator VkBlitImageInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBlitImageInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::ImageBlit2 * const &,
               VULKAN_HPP_NAMESPACE::Filter const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BlitImageInfo2 const & ) const = default;
#else
    bool operator==( BlitImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) && ( srcImageLayout == rhs.srcImageLayout ) &&
             ( dstImage == rhs.dstImage ) && ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions ) &&
             ( filter == rhs.filter );
#  endif
    }

    bool operator!=( BlitImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType      sType          = StructureType::eBlitImageInfo2;
    const void *                             pNext          = {};
    VULKAN_HPP_NAMESPACE::Image              srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::Image              dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                 regionCount    = {};
    const VULKAN_HPP_NAMESPACE::ImageBlit2 * pRegions       = {};
    VULKAN_HPP_NAMESPACE::Filter             filter         = VULKAN_HPP_NAMESPACE::Filter::eNearest;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BlitImageInfo2 ) == sizeof( VkBlitImageInfo2 ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BlitImageInfo2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BlitImageInfo2>::value,
                            "BlitImageInfo2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBlitImageInfo2>
  {
    using Type = BlitImageInfo2;
  };
  using BlitImageInfo2KHR = BlitImageInfo2;

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionBufferCreateInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionBufferCreateInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionBufferCreateInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionBufferCreateInfoFUCHSIA( VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection_ = {},
                                                                  uint32_t                                      index_      = {},
                                                                  const void *                                  pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , collection( collection_ )
      , index( index_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionBufferCreateInfoFUCHSIA( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionBufferCreateInfoFUCHSIA( VkBufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionBufferCreateInfoFUCHSIA( *reinterpret_cast<BufferCollectionBufferCreateInfoFUCHSIA const *>( &rhs ) )
    {
    }
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCollectionBufferCreateInfoFUCHSIA & operator=( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionBufferCreateInfoFUCHSIA & operator=( VkBufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionBufferCreateInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionBufferCreateInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionBufferCreateInfoFUCHSIA &
                            setCollection( VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection_ ) VULKAN_HPP_NOEXCEPT
    {
      collection = collection_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionBufferCreateInfoFUCHSIA & setIndex( uint32_t index_ ) VULKAN_HPP_NOEXCEPT
    {
      index = index_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferCollectionBufferCreateInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionBufferCreateInfoFUCHSIA *>( this );
    }

    explicit operator VkBufferCollectionBufferCreateInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionBufferCreateInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, collection, index );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionBufferCreateInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( collection == rhs.collection ) && ( index == rhs.index );
#    endif
    }

    bool operator!=( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType           sType      = StructureType::eBufferCollectionBufferCreateInfoFUCHSIA;
    const void *                                  pNext      = {};
    VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection = {};
    uint32_t                                      index      = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCollectionBufferCreateInfoFUCHSIA ) == sizeof( VkBufferCollectionBufferCreateInfoFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCollectionBufferCreateInfoFUCHSIA>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCollectionBufferCreateInfoFUCHSIA>::value,
                            "BufferCollectionBufferCreateInfoFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionBufferCreateInfoFUCHSIA>
  {
    using Type = BufferCollectionBufferCreateInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionConstraintsInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionConstraintsInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionConstraintsInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionConstraintsInfoFUCHSIA( uint32_t     minBufferCount_                  = {},
                                                                 uint32_t     maxBufferCount_                  = {},
                                                                 uint32_t     minBufferCountForCamping_        = {},
                                                                 uint32_t     minBufferCountForDedicatedSlack_ = {},
                                                                 uint32_t     minBufferCountForSharedSlack_    = {},
                                                                 const void * pNext_                           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , minBufferCount( minBufferCount_ )
      , maxBufferCount( maxBufferCount_ )
      , minBufferCountForCamping( minBufferCountForCamping_ )
      , minBufferCountForDedicatedSlack( minBufferCountForDedicatedSlack_ )
      , minBufferCountForSharedSlack( minBufferCountForSharedSlack_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionConstraintsInfoFUCHSIA( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionConstraintsInfoFUCHSIA( VkBufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionConstraintsInfoFUCHSIA( *reinterpret_cast<BufferCollectionConstraintsInfoFUCHSIA const *>( &rhs ) )
    {
    }
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCollectionConstraintsInfoFUCHSIA & operator=( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionConstraintsInfoFUCHSIA & operator=( VkBufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA & setMinBufferCount( uint32_t minBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCount = minBufferCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA & setMaxBufferCount( uint32_t maxBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxBufferCount = maxBufferCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA & setMinBufferCountForCamping( uint32_t minBufferCountForCamping_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCountForCamping = minBufferCountForCamping_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA &
                            setMinBufferCountForDedicatedSlack( uint32_t minBufferCountForDedicatedSlack_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCountForDedicatedSlack = minBufferCountForDedicatedSlack_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA &
                            setMinBufferCountForSharedSlack( uint32_t minBufferCountForSharedSlack_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCountForSharedSlack = minBufferCountForSharedSlack_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferCollectionConstraintsInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionConstraintsInfoFUCHSIA *>( this );
    }

    explicit operator VkBufferCollectionConstraintsInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionConstraintsInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, minBufferCount, maxBufferCount, minBufferCountForCamping, minBufferCountForDedicatedSlack, minBufferCountForSharedSlack );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionConstraintsInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( minBufferCount == rhs.minBufferCount ) && ( maxBufferCount == rhs.maxBufferCount ) &&
             ( minBufferCountForCamping == rhs.minBufferCountForCamping ) && ( minBufferCountForDedicatedSlack == rhs.minBufferCountForDedicatedSlack ) &&
             ( minBufferCountForSharedSlack == rhs.minBufferCountForSharedSlack );
#    endif
    }

    bool operator!=( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                           = StructureType::eBufferCollectionConstraintsInfoFUCHSIA;
    const void *                        pNext                           = {};
    uint32_t                            minBufferCount                  = {};
    uint32_t                            maxBufferCount                  = {};
    uint32_t                            minBufferCountForCamping        = {};
    uint32_t                            minBufferCountForDedicatedSlack = {};
    uint32_t                            minBufferCountForSharedSlack    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA ) == sizeof( VkBufferCollectionConstraintsInfoFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA>::value,
                            "BufferCollectionConstraintsInfoFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionConstraintsInfoFUCHSIA>
  {
    using Type = BufferCollectionConstraintsInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionCreateInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionCreateInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionCreateInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionCreateInfoFUCHSIA( zx_handle_t collectionToken_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , collectionToken( collectionToken_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionCreateInfoFUCHSIA( BufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionCreateInfoFUCHSIA( VkBufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionCreateInfoFUCHSIA( *reinterpret_cast<BufferCollectionCreateInfoFUCHSIA const *>( &rhs ) )
    {
    }
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCollectionCreateInfoFUCHSIA & operator=( BufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionCreateInfoFUCHSIA & operator=( VkBufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionCreateInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionCreateInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionCreateInfoFUCHSIA & setCollectionToken( zx_handle_t collectionToken_ ) VULKAN_HPP_NOEXCEPT
    {
      collectionToken = collectionToken_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferCollectionCreateInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionCreateInfoFUCHSIA *>( this );
    }

    explicit operator VkBufferCollectionCreateInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionCreateInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, zx_handle_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, collectionToken );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( BufferCollectionCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = memcmp( &collectionToken, &rhs.collectionToken, sizeof( zx_handle_t ) ); cmp != 0 )
        return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;

      return std::strong_ordering::equivalent;
    }
#  endif

    bool operator==( BufferCollectionCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( memcmp( &collectionToken, &rhs.collectionToken, sizeof( zx_handle_t ) ) == 0 );
    }

    bool operator!=( BufferCollectionCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType           = StructureType::eBufferCollectionCreateInfoFUCHSIA;
    const void *                        pNext           = {};
    zx_handle_t                         collectionToken = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCollectionCreateInfoFUCHSIA ) == sizeof( VkBufferCollectionCreateInfoFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCollectionCreateInfoFUCHSIA>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCollectionCreateInfoFUCHSIA>::value,
                            "BufferCollectionCreateInfoFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionCreateInfoFUCHSIA>
  {
    using Type = BufferCollectionCreateInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionImageCreateInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionImageCreateInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionImageCreateInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionImageCreateInfoFUCHSIA( VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection_ = {},
                                                                 uint32_t                                      index_      = {},
                                                                 const void *                                  pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , collection( collection_ )
      , index( index_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionImageCreateInfoFUCHSIA( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionImageCreateInfoFUCHSIA( VkBufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionImageCreateInfoFUCHSIA( *reinterpret_cast<BufferCollectionImageCreateInfoFUCHSIA const *>( &rhs ) )
    {
    }
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCollectionImageCreateInfoFUCHSIA & operator=( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionImageCreateInfoFUCHSIA & operator=( VkBufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionImageCreateInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionImageCreateInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionImageCreateInfoFUCHSIA &
                            setCollection( VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection_ ) VULKAN_HPP_NOEXCEPT
    {
      collection = collection_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionImageCreateInfoFUCHSIA & setIndex( uint32_t index_ ) VULKAN_HPP_NOEXCEPT
    {
      index = index_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferCollectionImageCreateInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionImageCreateInfoFUCHSIA *>( this );
    }

    explicit operator VkBufferCollectionImageCreateInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionImageCreateInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, collection, index );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionImageCreateInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( collection == rhs.collection ) && ( index == rhs.index );
#    endif
    }

    bool operator!=( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType           sType      = StructureType::eBufferCollectionImageCreateInfoFUCHSIA;
    const void *                                  pNext      = {};
    VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA collection = {};
    uint32_t                                      index      = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCollectionImageCreateInfoFUCHSIA ) == sizeof( VkBufferCollectionImageCreateInfoFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCollectionImageCreateInfoFUCHSIA>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCollectionImageCreateInfoFUCHSIA>::value,
                            "BufferCollectionImageCreateInfoFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionImageCreateInfoFUCHSIA>
  {
    using Type = BufferCollectionImageCreateInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct SysmemColorSpaceFUCHSIA
  {
    using NativeType = VkSysmemColorSpaceFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eSysmemColorSpaceFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SysmemColorSpaceFUCHSIA( uint32_t colorSpace_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , colorSpace( colorSpace_ )
    {
    }

    VULKAN_HPP_CONSTEXPR SysmemColorSpaceFUCHSIA( SysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SysmemColorSpaceFUCHSIA( VkSysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : SysmemColorSpaceFUCHSIA( *reinterpret_cast<SysmemColorSpaceFUCHSIA const *>( &rhs ) )
    {
    }
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SysmemColorSpaceFUCHSIA & operator=( SysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SysmemColorSpaceFUCHSIA & operator=( VkSysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SysmemColorSpaceFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SysmemColorSpaceFUCHSIA & setColorSpace( uint32_t colorSpace_ ) VULKAN_HPP_NOEXCEPT
    {
      colorSpace = colorSpace_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkSysmemColorSpaceFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSysmemColorSpaceFUCHSIA *>( this );
    }

    explicit operator VkSysmemColorSpaceFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSysmemColorSpaceFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, colorSpace );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SysmemColorSpaceFUCHSIA const & ) const = default;
#  else
    bool operator==( SysmemColorSpaceFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( colorSpace == rhs.colorSpace );
#    endif
    }

    bool operator!=( SysmemColorSpaceFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eSysmemColorSpaceFUCHSIA;
    const void *                        pNext      = {};
    uint32_t                            colorSpace = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA ) == sizeof( VkSysmemColorSpaceFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA>::value,
                            "SysmemColorSpaceFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eSysmemColorSpaceFUCHSIA>
  {
    using Type = SysmemColorSpaceFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferCollectionPropertiesFUCHSIA
  {
    using NativeType = VkBufferCollectionPropertiesFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionPropertiesFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionPropertiesFUCHSIA(
      uint32_t                                          memoryTypeBits_                   = {},
      uint32_t                                          bufferCount_                      = {},
      uint32_t                                          createInfoIndex_                  = {},
      uint64_t                                          sysmemPixelFormat_                = {},
      VULKAN_HPP_NAMESPACE::FormatFeatureFlags          formatFeatures_                   = {},
      VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA     sysmemColorSpaceIndex_            = {},
      VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents_ = {},
      VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel_              = VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity,
      VULKAN_HPP_NAMESPACE::SamplerYcbcrRange           suggestedYcbcrRange_              = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull,
      VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedXChromaOffset_           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedYChromaOffset_           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven,
      void *                                            pNext_                            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , memoryTypeBits( memoryTypeBits_ )
      , bufferCount( bufferCount_ )
      , createInfoIndex( createInfoIndex_ )
      , sysmemPixelFormat( sysmemPixelFormat_ )
      , formatFeatures( formatFeatures_ )
      , sysmemColorSpaceIndex( sysmemColorSpaceIndex_ )
      , samplerYcbcrConversionComponents( samplerYcbcrConversionComponents_ )
      , suggestedYcbcrModel( suggestedYcbcrModel_ )
      , suggestedYcbcrRange( suggestedYcbcrRange_ )
      , suggestedXChromaOffset( suggestedXChromaOffset_ )
      , suggestedYChromaOffset( suggestedYChromaOffset_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionPropertiesFUCHSIA( BufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionPropertiesFUCHSIA( VkBufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionPropertiesFUCHSIA( *reinterpret_cast<BufferCollectionPropertiesFUCHSIA const *>( &rhs ) )
    {
    }
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCollectionPropertiesFUCHSIA & operator=( BufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionPropertiesFUCHSIA & operator=( VkBufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCollectionPropertiesFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA & setMemoryTypeBits( uint32_t memoryTypeBits_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryTypeBits = memoryTypeBits_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA & setBufferCount( uint32_t bufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferCount = bufferCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA & setCreateInfoIndex( uint32_t createInfoIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      createInfoIndex = createInfoIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA & setSysmemPixelFormat( uint64_t sysmemPixelFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      sysmemPixelFormat = sysmemPixelFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
                            setFormatFeatures( VULKAN_HPP_NAMESPACE::FormatFeatureFlags formatFeatures_ ) VULKAN_HPP_NOEXCEPT
    {
      formatFeatures = formatFeatures_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
                            setSysmemColorSpaceIndex( VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA const & sysmemColorSpaceIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      sysmemColorSpaceIndex = sysmemColorSpaceIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
      setSamplerYcbcrConversionComponents( VULKAN_HPP_NAMESPACE::ComponentMapping const & samplerYcbcrConversionComponents_ ) VULKAN_HPP_NOEXCEPT
    {
      samplerYcbcrConversionComponents = samplerYcbcrConversionComponents_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
                            setSuggestedYcbcrModel( VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel_ ) VULKAN_HPP_NOEXCEPT
    {
      suggestedYcbcrModel = suggestedYcbcrModel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
                            setSuggestedYcbcrRange( VULKAN_HPP_NAMESPACE::SamplerYcbcrRange suggestedYcbcrRange_ ) VULKAN_HPP_NOEXCEPT
    {
      suggestedYcbcrRange = suggestedYcbcrRange_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
                            setSuggestedXChromaOffset( VULKAN_HPP_NAMESPACE::ChromaLocation suggestedXChromaOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      suggestedXChromaOffset = suggestedXChromaOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionPropertiesFUCHSIA &
                            setSuggestedYChromaOffset( VULKAN_HPP_NAMESPACE::ChromaLocation suggestedYChromaOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      suggestedYChromaOffset = suggestedYChromaOffset_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferCollectionPropertiesFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionPropertiesFUCHSIA *>( this );
    }

    explicit operator VkBufferCollectionPropertiesFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionPropertiesFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint64_t const &,
               VULKAN_HPP_NAMESPACE::FormatFeatureFlags const &,
               VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA const &,
               VULKAN_HPP_NAMESPACE::ComponentMapping const &,
               VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion const &,
               VULKAN_HPP_NAMESPACE::SamplerYcbcrRange const &,
               VULKAN_HPP_NAMESPACE::ChromaLocation const &,
               VULKAN_HPP_NAMESPACE::ChromaLocation const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       memoryTypeBits,
                       bufferCount,
                       createInfoIndex,
                       sysmemPixelFormat,
                       formatFeatures,
                       sysmemColorSpaceIndex,
                       samplerYcbcrConversionComponents,
                       suggestedYcbcrModel,
                       suggestedYcbcrRange,
                       suggestedXChromaOffset,
                       suggestedYChromaOffset );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionPropertiesFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionPropertiesFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( memoryTypeBits == rhs.memoryTypeBits ) && ( bufferCount == rhs.bufferCount ) &&
             ( createInfoIndex == rhs.createInfoIndex ) && ( sysmemPixelFormat == rhs.sysmemPixelFormat ) && ( formatFeatures == rhs.formatFeatures ) &&
             ( sysmemColorSpaceIndex == rhs.sysmemColorSpaceIndex ) && ( samplerYcbcrConversionComponents == rhs.samplerYcbcrConversionComponents ) &&
             ( suggestedYcbcrModel == rhs.suggestedYcbcrModel ) && ( suggestedYcbcrRange == rhs.suggestedYcbcrRange ) &&
             ( suggestedXChromaOffset == rhs.suggestedXChromaOffset ) && ( suggestedYChromaOffset == rhs.suggestedYChromaOffset );
#    endif
    }

    bool operator!=( BufferCollectionPropertiesFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType                            = StructureType::eBufferCollectionPropertiesFUCHSIA;
    void *                                            pNext                            = {};
    uint32_t                                          memoryTypeBits                   = {};
    uint32_t                                          bufferCount                      = {};
    uint32_t                                          createInfoIndex                  = {};
    uint64_t                                          sysmemPixelFormat                = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags          formatFeatures                   = {};
    VULKAN_HPP_NAMESPACE::SysmemColorSpaceFUCHSIA     sysmemColorSpaceIndex            = {};
    VULKAN_HPP_NAMESPACE::ComponentMapping            samplerYcbcrConversionComponents = {};
    VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion suggestedYcbcrModel              = VULKAN_HPP_NAMESPACE::SamplerYcbcrModelConversion::eRgbIdentity;
    VULKAN_HPP_NAMESPACE::SamplerYcbcrRange           suggestedYcbcrRange              = VULKAN_HPP_NAMESPACE::SamplerYcbcrRange::eItuFull;
    VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedXChromaOffset           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
    VULKAN_HPP_NAMESPACE::ChromaLocation              suggestedYChromaOffset           = VULKAN_HPP_NAMESPACE::ChromaLocation::eCositedEven;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCollectionPropertiesFUCHSIA ) == sizeof( VkBufferCollectionPropertiesFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCollectionPropertiesFUCHSIA>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCollectionPropertiesFUCHSIA>::value,
                            "BufferCollectionPropertiesFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionPropertiesFUCHSIA>
  {
    using Type = BufferCollectionPropertiesFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

  struct BufferCreateInfo
  {
    using NativeType = VkBufferCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCreateInfo( VULKAN_HPP_NAMESPACE::BufferCreateFlags flags_                 = {},
                                           VULKAN_HPP_NAMESPACE::DeviceSize        size_                  = {},
                                           VULKAN_HPP_NAMESPACE::BufferUsageFlags  usage_                 = {},
                                           VULKAN_HPP_NAMESPACE::SharingMode       sharingMode_           = VULKAN_HPP_NAMESPACE::SharingMode::eExclusive,
                                           uint32_t                                queueFamilyIndexCount_ = {},
                                           const uint32_t *                        pQueueFamilyIndices_   = {},
                                           const void *                            pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , size( size_ )
      , usage( usage_ )
      , sharingMode( sharingMode_ )
      , queueFamilyIndexCount( queueFamilyIndexCount_ )
      , pQueueFamilyIndices( pQueueFamilyIndices_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCreateInfo( BufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCreateInfo( VkBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT : BufferCreateInfo( *reinterpret_cast<BufferCreateInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BufferCreateInfo( VULKAN_HPP_NAMESPACE::BufferCreateFlags                               flags_,
                      VULKAN_HPP_NAMESPACE::DeviceSize                                      size_,
                      VULKAN_HPP_NAMESPACE::BufferUsageFlags                                usage_,
                      VULKAN_HPP_NAMESPACE::SharingMode                                     sharingMode_,
                      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & queueFamilyIndices_,
                      const void *                                                          pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , size( size_ )
      , usage( usage_ )
      , sharingMode( sharingMode_ )
      , queueFamilyIndexCount( static_cast<uint32_t>( queueFamilyIndices_.size() ) )
      , pQueueFamilyIndices( queueFamilyIndices_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCreateInfo & operator=( BufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCreateInfo & operator=( VkBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::BufferCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setUsage( VULKAN_HPP_NAMESPACE::BufferUsageFlags usage_ ) VULKAN_HPP_NOEXCEPT
    {
      usage = usage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setSharingMode( VULKAN_HPP_NAMESPACE::SharingMode sharingMode_ ) VULKAN_HPP_NOEXCEPT
    {
      sharingMode = sharingMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setQueueFamilyIndexCount( uint32_t queueFamilyIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndexCount = queueFamilyIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setPQueueFamilyIndices( const uint32_t * pQueueFamilyIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueueFamilyIndices = pQueueFamilyIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BufferCreateInfo & setQueueFamilyIndices( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & queueFamilyIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndexCount = static_cast<uint32_t>( queueFamilyIndices_.size() );
      pQueueFamilyIndices   = queueFamilyIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCreateInfo *>( this );
    }

    explicit operator VkBufferCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::BufferCreateFlags const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::BufferUsageFlags const &,
               VULKAN_HPP_NAMESPACE::SharingMode const &,
               uint32_t const &,
               const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, size, usage, sharingMode, queueFamilyIndexCount, pQueueFamilyIndices );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCreateInfo const & ) const = default;
#else
    bool operator==( BufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( size == rhs.size ) && ( usage == rhs.usage ) &&
             ( sharingMode == rhs.sharingMode ) && ( queueFamilyIndexCount == rhs.queueFamilyIndexCount ) && ( pQueueFamilyIndices == rhs.pQueueFamilyIndices );
#  endif
    }

    bool operator!=( BufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType     sType                 = StructureType::eBufferCreateInfo;
    const void *                            pNext                 = {};
    VULKAN_HPP_NAMESPACE::BufferCreateFlags flags                 = {};
    VULKAN_HPP_NAMESPACE::DeviceSize        size                  = {};
    VULKAN_HPP_NAMESPACE::BufferUsageFlags  usage                 = {};
    VULKAN_HPP_NAMESPACE::SharingMode       sharingMode           = VULKAN_HPP_NAMESPACE::SharingMode::eExclusive;
    uint32_t                                queueFamilyIndexCount = {};
    const uint32_t *                        pQueueFamilyIndices   = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCreateInfo ) == sizeof( VkBufferCreateInfo ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCreateInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCreateInfo>::value,
                            "BufferCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCreateInfo>
  {
    using Type = BufferCreateInfo;
  };

#if defined( VK_USE_PLATFORM_FUCHSIA )
  struct BufferConstraintsInfoFUCHSIA
  {
    using NativeType = VkBufferConstraintsInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferConstraintsInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferConstraintsInfoFUCHSIA( VULKAN_HPP_NAMESPACE::BufferCreateInfo                       createInfo_                  = {},
                                                       VULKAN_HPP_NAMESPACE::FormatFeatureFlags                     requiredFormatFeatures_      = {},
                                                       VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA bufferCollectionConstraints_ = {},
                                                       const void *                                                 pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , createInfo( createInfo_ )
      , requiredFormatFeatures( requiredFormatFeatures_ )
      , bufferCollectionConstraints( bufferCollectionConstraints_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferConstraintsInfoFUCHSIA( BufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferConstraintsInfoFUCHSIA( VkBufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferConstraintsInfoFUCHSIA( *reinterpret_cast<BufferConstraintsInfoFUCHSIA const *>( &rhs ) )
    {
    }
#  endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferConstraintsInfoFUCHSIA & operator=( BufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferConstraintsInfoFUCHSIA & operator=( VkBufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferConstraintsInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA & setCreateInfo( VULKAN_HPP_NAMESPACE::BufferCreateInfo const & createInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      createInfo = createInfo_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA &
                            setRequiredFormatFeatures( VULKAN_HPP_NAMESPACE::FormatFeatureFlags requiredFormatFeatures_ ) VULKAN_HPP_NOEXCEPT
    {
      requiredFormatFeatures = requiredFormatFeatures_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA &
      setBufferCollectionConstraints( VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA const & bufferCollectionConstraints_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferCollectionConstraints = bufferCollectionConstraints_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferConstraintsInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferConstraintsInfoFUCHSIA *>( this );
    }

    explicit operator VkBufferConstraintsInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferConstraintsInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::BufferCreateInfo const &,
               VULKAN_HPP_NAMESPACE::FormatFeatureFlags const &,
               VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, createInfo, requiredFormatFeatures, bufferCollectionConstraints );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferConstraintsInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( createInfo == rhs.createInfo ) && ( requiredFormatFeatures == rhs.requiredFormatFeatures ) &&
             ( bufferCollectionConstraints == rhs.bufferCollectionConstraints );
#    endif
    }

    bool operator!=( BufferConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                          sType                       = StructureType::eBufferConstraintsInfoFUCHSIA;
    const void *                                                 pNext                       = {};
    VULKAN_HPP_NAMESPACE::BufferCreateInfo                       createInfo                  = {};
    VULKAN_HPP_NAMESPACE::FormatFeatureFlags                     requiredFormatFeatures      = {};
    VULKAN_HPP_NAMESPACE::BufferCollectionConstraintsInfoFUCHSIA bufferCollectionConstraints = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferConstraintsInfoFUCHSIA ) == sizeof( VkBufferConstraintsInfoFUCHSIA ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferConstraintsInfoFUCHSIA>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferConstraintsInfoFUCHSIA>::value,
                            "BufferConstraintsInfoFUCHSIA is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferConstraintsInfoFUCHSIA>
  {
    using Type = BufferConstraintsInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

  struct BufferCopy
  {
    using NativeType = VkBufferCopy;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCopy( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ = {},
                                     VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ = {},
                                     VULKAN_HPP_NAMESPACE::DeviceSize size_      = {} ) VULKAN_HPP_NOEXCEPT
      : srcOffset( srcOffset_ )
      , dstOffset( dstOffset_ )
      , size( size_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCopy( BufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy( VkBufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT : BufferCopy( *reinterpret_cast<BufferCopy const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCopy & operator=( BufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy & operator=( VkBufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setSrcOffset( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setDstOffset( VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCopy *>( this );
    }

    explicit operator VkBufferCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCopy *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceSize const &, VULKAN_HPP_NAMESPACE::DeviceSize const &, VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcOffset, dstOffset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCopy const & ) const = default;
#else
    bool operator==( BufferCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcOffset == rhs.srcOffset ) && ( dstOffset == rhs.dstOffset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceSize srcOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize dstOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize size      = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCopy ) == sizeof( VkBufferCopy ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCopy>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCopy>::value, "BufferCopy is not nothrow_move_constructible!" );

  struct BufferCopy2
  {
    using NativeType = VkBufferCopy2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCopy2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCopy2( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ = {},
                                      VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ = {},
                                      VULKAN_HPP_NAMESPACE::DeviceSize size_      = {},
                                      const void *                     pNext_     = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , srcOffset( srcOffset_ )
      , dstOffset( dstOffset_ )
      , size( size_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCopy2( BufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy2( VkBufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT : BufferCopy2( *reinterpret_cast<BufferCopy2 const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferCopy2 & operator=( BufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy2 & operator=( VkBufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferCopy2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setSrcOffset( VULKAN_HPP_NAMESPACE::DeviceSize srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setDstOffset( VULKAN_HPP_NAMESPACE::DeviceSize dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferCopy2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCopy2 *>( this );
    }

    explicit operator VkBufferCopy2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCopy2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcOffset, dstOffset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCopy2 const & ) const = default;
#else
    bool operator==( BufferCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcOffset == rhs.srcOffset ) && ( dstOffset == rhs.dstOffset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType     = StructureType::eBufferCopy2;
    const void *                        pNext     = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    srcOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    dstOffset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    size      = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferCopy2 ) == sizeof( VkBufferCopy2 ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferCopy2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferCopy2>::value, "BufferCopy2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferCopy2>
  {
    using Type = BufferCopy2;
  };
  using BufferCopy2KHR = BufferCopy2;

  struct BufferDeviceAddressCreateInfoEXT
  {
    using NativeType = VkBufferDeviceAddressCreateInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferDeviceAddressCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferDeviceAddressCreateInfoEXT( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ = {},
                                                           const void *                        pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , deviceAddress( deviceAddress_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferDeviceAddressCreateInfoEXT( BufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferDeviceAddressCreateInfoEXT( VkBufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferDeviceAddressCreateInfoEXT( *reinterpret_cast<BufferDeviceAddressCreateInfoEXT const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferDeviceAddressCreateInfoEXT & operator=( BufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferDeviceAddressCreateInfoEXT & operator=( VkBufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferDeviceAddressCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressCreateInfoEXT & setDeviceAddress( VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferDeviceAddressCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferDeviceAddressCreateInfoEXT *>( this );
    }

    explicit operator VkBufferDeviceAddressCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferDeviceAddressCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceAddress );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferDeviceAddressCreateInfoEXT const & ) const = default;
#else
    bool operator==( BufferDeviceAddressCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceAddress == rhs.deviceAddress );
#  endif
    }

    bool operator!=( BufferDeviceAddressCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType         = StructureType::eBufferDeviceAddressCreateInfoEXT;
    const void *                        pNext         = {};
    VULKAN_HPP_NAMESPACE::DeviceAddress deviceAddress = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferDeviceAddressCreateInfoEXT ) == sizeof( VkBufferDeviceAddressCreateInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferDeviceAddressCreateInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferDeviceAddressCreateInfoEXT>::value,
                            "BufferDeviceAddressCreateInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferDeviceAddressCreateInfoEXT>
  {
    using Type = BufferDeviceAddressCreateInfoEXT;
  };

  struct BufferDeviceAddressInfo
  {
    using NativeType = VkBufferDeviceAddressInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferDeviceAddressInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferDeviceAddressInfo( VULKAN_HPP_NAMESPACE::Buffer buffer_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , buffer( buffer_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferDeviceAddressInfo( BufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferDeviceAddressInfo( VkBufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferDeviceAddressInfo( *reinterpret_cast<BufferDeviceAddressInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferDeviceAddressInfo & operator=( BufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferDeviceAddressInfo & operator=( VkBufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferDeviceAddressInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferDeviceAddressInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferDeviceAddressInfo *>( this );
    }

    explicit operator VkBufferDeviceAddressInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferDeviceAddressInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Buffer const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferDeviceAddressInfo const & ) const = default;
#else
    bool operator==( BufferDeviceAddressInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer );
#  endif
    }

    bool operator!=( BufferDeviceAddressInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eBufferDeviceAddressInfo;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferDeviceAddressInfo ) == sizeof( VkBufferDeviceAddressInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferDeviceAddressInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferDeviceAddressInfo>::value,
                            "BufferDeviceAddressInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferDeviceAddressInfo>
  {
    using Type = BufferDeviceAddressInfo;
  };
  using BufferDeviceAddressInfoEXT = BufferDeviceAddressInfo;
  using BufferDeviceAddressInfoKHR = BufferDeviceAddressInfo;

  struct BufferImageCopy
  {
    using NativeType = VkBufferImageCopy;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferImageCopy( VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset_      = {},
                                          uint32_t                                     bufferRowLength_   = {},
                                          uint32_t                                     bufferImageHeight_ = {},
                                          VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource_  = {},
                                          VULKAN_HPP_NAMESPACE::Offset3D               imageOffset_       = {},
                                          VULKAN_HPP_NAMESPACE::Extent3D               imageExtent_       = {} ) VULKAN_HPP_NOEXCEPT
      : bufferOffset( bufferOffset_ )
      , bufferRowLength( bufferRowLength_ )
      , bufferImageHeight( bufferImageHeight_ )
      , imageSubresource( imageSubresource_ )
      , imageOffset( imageOffset_ )
      , imageExtent( imageExtent_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferImageCopy( BufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy( VkBufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT : BufferImageCopy( *reinterpret_cast<BufferImageCopy const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferImageCopy & operator=( BufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy & operator=( VkBufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferImageCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferOffset( VULKAN_HPP_NAMESPACE::DeviceSize bufferOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferOffset = bufferOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferRowLength( uint32_t bufferRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferRowLength = bufferRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferImageHeight( uint32_t bufferImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferImageHeight = bufferImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setImageSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setImageOffset( VULKAN_HPP_NAMESPACE::Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setImageExtent( VULKAN_HPP_NAMESPACE::Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferImageCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferImageCopy *>( this );
    }

    explicit operator VkBufferImageCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferImageCopy *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferOffset, bufferRowLength, bufferImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferImageCopy const & ) const = default;
#else
    bool operator==( BufferImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferOffset == rhs.bufferOffset ) && ( bufferRowLength == rhs.bufferRowLength ) && ( bufferImageHeight == rhs.bufferImageHeight ) &&
             ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) && ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( BufferImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset      = {};
    uint32_t                                     bufferRowLength   = {};
    uint32_t                                     bufferImageHeight = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D               imageOffset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D               imageExtent       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferImageCopy ) == sizeof( VkBufferImageCopy ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferImageCopy>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferImageCopy>::value,
                            "BufferImageCopy is not nothrow_move_constructible!" );

  struct BufferImageCopy2
  {
    using NativeType = VkBufferImageCopy2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferImageCopy2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferImageCopy2( VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset_      = {},
                                           uint32_t                                     bufferRowLength_   = {},
                                           uint32_t                                     bufferImageHeight_ = {},
                                           VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource_  = {},
                                           VULKAN_HPP_NAMESPACE::Offset3D               imageOffset_       = {},
                                           VULKAN_HPP_NAMESPACE::Extent3D               imageExtent_       = {},
                                           const void *                                 pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , bufferOffset( bufferOffset_ )
      , bufferRowLength( bufferRowLength_ )
      , bufferImageHeight( bufferImageHeight_ )
      , imageSubresource( imageSubresource_ )
      , imageOffset( imageOffset_ )
      , imageExtent( imageExtent_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferImageCopy2( BufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy2( VkBufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT : BufferImageCopy2( *reinterpret_cast<BufferImageCopy2 const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferImageCopy2 & operator=( BufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy2 & operator=( VkBufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferImageCopy2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setBufferOffset( VULKAN_HPP_NAMESPACE::DeviceSize bufferOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferOffset = bufferOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setBufferRowLength( uint32_t bufferRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferRowLength = bufferRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setBufferImageHeight( uint32_t bufferImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferImageHeight = bufferImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setImageSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setImageOffset( VULKAN_HPP_NAMESPACE::Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setImageExtent( VULKAN_HPP_NAMESPACE::Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferImageCopy2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferImageCopy2 *>( this );
    }

    explicit operator VkBufferImageCopy2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferImageCopy2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, bufferOffset, bufferRowLength, bufferImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferImageCopy2 const & ) const = default;
#else
    bool operator==( BufferImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( bufferOffset == rhs.bufferOffset ) && ( bufferRowLength == rhs.bufferRowLength ) &&
             ( bufferImageHeight == rhs.bufferImageHeight ) && ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) &&
             ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( BufferImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType             = StructureType::eBufferImageCopy2;
    const void *                                 pNext             = {};
    VULKAN_HPP_NAMESPACE::DeviceSize             bufferOffset      = {};
    uint32_t                                     bufferRowLength   = {};
    uint32_t                                     bufferImageHeight = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers imageSubresource  = {};
    VULKAN_HPP_NAMESPACE::Offset3D               imageOffset       = {};
    VULKAN_HPP_NAMESPACE::Extent3D               imageExtent       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferImageCopy2 ) == sizeof( VkBufferImageCopy2 ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferImageCopy2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferImageCopy2>::value,
                            "BufferImageCopy2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferImageCopy2>
  {
    using Type = BufferImageCopy2;
  };
  using BufferImageCopy2KHR = BufferImageCopy2;

  struct BufferMemoryBarrier
  {
    using NativeType = VkBufferMemoryBarrier;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryBarrier;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier( VULKAN_HPP_NAMESPACE::AccessFlags srcAccessMask_       = {},
                                              VULKAN_HPP_NAMESPACE::AccessFlags dstAccessMask_       = {},
                                              uint32_t                          srcQueueFamilyIndex_ = {},
                                              uint32_t                          dstQueueFamilyIndex_ = {},
                                              VULKAN_HPP_NAMESPACE::Buffer      buffer_              = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize  offset_              = {},
                                              VULKAN_HPP_NAMESPACE::DeviceSize  size_                = {},
                                              const void *                      pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , srcAccessMask( srcAccessMask_ )
      , dstAccessMask( dstAccessMask_ )
      , srcQueueFamilyIndex( srcQueueFamilyIndex_ )
      , dstQueueFamilyIndex( dstQueueFamilyIndex_ )
      , buffer( buffer_ )
      , offset( offset_ )
      , size( size_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier( BufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier( VkBufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT : BufferMemoryBarrier( *reinterpret_cast<BufferMemoryBarrier const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferMemoryBarrier & operator=( BufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier & operator=( VkBufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferMemoryBarrier const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryBarrier *>( this );
    }

    explicit operator VkBufferMemoryBarrier &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryBarrier *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccessFlags const &,
               VULKAN_HPP_NAMESPACE::AccessFlags const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcAccessMask, dstAccessMask, srcQueueFamilyIndex, dstQueueFamilyIndex, buffer, offset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryBarrier const & ) const = default;
#else
    bool operator==( BufferMemoryBarrier const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcAccessMask == rhs.srcAccessMask ) && ( dstAccessMask == rhs.dstAccessMask ) &&
             ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) && ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) && ( buffer == rhs.buffer ) &&
             ( offset == rhs.offset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferMemoryBarrier const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType               = StructureType::eBufferMemoryBarrier;
    const void *                        pNext               = {};
    VULKAN_HPP_NAMESPACE::AccessFlags   srcAccessMask       = {};
    VULKAN_HPP_NAMESPACE::AccessFlags   dstAccessMask       = {};
    uint32_t                            srcQueueFamilyIndex = {};
    uint32_t                            dstQueueFamilyIndex = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    offset              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize    size                = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferMemoryBarrier ) == sizeof( VkBufferMemoryBarrier ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier>::value,
                            "BufferMemoryBarrier is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryBarrier>
  {
    using Type = BufferMemoryBarrier;
  };

  struct BufferMemoryBarrier2
  {
    using NativeType = VkBufferMemoryBarrier2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryBarrier2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier2( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask_        = {},
                                               VULKAN_HPP_NAMESPACE::AccessFlags2        srcAccessMask_       = {},
                                               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask_        = {},
                                               VULKAN_HPP_NAMESPACE::AccessFlags2        dstAccessMask_       = {},
                                               uint32_t                                  srcQueueFamilyIndex_ = {},
                                               uint32_t                                  dstQueueFamilyIndex_ = {},
                                               VULKAN_HPP_NAMESPACE::Buffer              buffer_              = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize          offset_              = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize          size_                = {},
                                               const void *                              pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , srcStageMask( srcStageMask_ )
      , srcAccessMask( srcAccessMask_ )
      , dstStageMask( dstStageMask_ )
      , dstAccessMask( dstAccessMask_ )
      , srcQueueFamilyIndex( srcQueueFamilyIndex_ )
      , dstQueueFamilyIndex( dstQueueFamilyIndex_ )
      , buffer( buffer_ )
      , offset( offset_ )
      , size( size_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier2( BufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier2( VkBufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferMemoryBarrier2( *reinterpret_cast<BufferMemoryBarrier2 const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferMemoryBarrier2 & operator=( BufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier2 & operator=( VkBufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSrcStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcStageMask = srcStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setDstStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstStageMask = dstStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSize( VULKAN_HPP_NAMESPACE::DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferMemoryBarrier2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryBarrier2 *>( this );
    }

    explicit operator VkBufferMemoryBarrier2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryBarrier2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcStageMask, srcAccessMask, dstStageMask, dstAccessMask, srcQueueFamilyIndex, dstQueueFamilyIndex, buffer, offset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryBarrier2 const & ) const = default;
#else
    bool operator==( BufferMemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcStageMask == rhs.srcStageMask ) && ( srcAccessMask == rhs.srcAccessMask ) &&
             ( dstStageMask == rhs.dstStageMask ) && ( dstAccessMask == rhs.dstAccessMask ) && ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) &&
             ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) && ( buffer == rhs.buffer ) && ( offset == rhs.offset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferMemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType               = StructureType::eBufferMemoryBarrier2;
    const void *                              pNext               = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2        srcAccessMask       = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2        dstAccessMask       = {};
    uint32_t                                  srcQueueFamilyIndex = {};
    uint32_t                                  dstQueueFamilyIndex = {};
    VULKAN_HPP_NAMESPACE::Buffer              buffer              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize          offset              = {};
    VULKAN_HPP_NAMESPACE::DeviceSize          size                = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2 ) == sizeof( VkBufferMemoryBarrier2 ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2>::value,
                            "BufferMemoryBarrier2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryBarrier2>
  {
    using Type = BufferMemoryBarrier2;
  };
  using BufferMemoryBarrier2KHR = BufferMemoryBarrier2;

  struct BufferMemoryRequirementsInfo2
  {
    using NativeType = VkBufferMemoryRequirementsInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryRequirementsInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryRequirementsInfo2( VULKAN_HPP_NAMESPACE::Buffer buffer_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , buffer( buffer_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferMemoryRequirementsInfo2( BufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryRequirementsInfo2( VkBufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferMemoryRequirementsInfo2( *reinterpret_cast<BufferMemoryRequirementsInfo2 const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferMemoryRequirementsInfo2 & operator=( BufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryRequirementsInfo2 & operator=( VkBufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferMemoryRequirementsInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryRequirementsInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryRequirementsInfo2 & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferMemoryRequirementsInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryRequirementsInfo2 *>( this );
    }

    explicit operator VkBufferMemoryRequirementsInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryRequirementsInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Buffer const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryRequirementsInfo2 const & ) const = default;
#else
    bool operator==( BufferMemoryRequirementsInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer );
#  endif
    }

    bool operator!=( BufferMemoryRequirementsInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eBufferMemoryRequirementsInfo2;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferMemoryRequirementsInfo2 ) == sizeof( VkBufferMemoryRequirementsInfo2 ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferMemoryRequirementsInfo2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferMemoryRequirementsInfo2>::value,
                            "BufferMemoryRequirementsInfo2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryRequirementsInfo2>
  {
    using Type = BufferMemoryRequirementsInfo2;
  };
  using BufferMemoryRequirementsInfo2KHR = BufferMemoryRequirementsInfo2;

  struct BufferOpaqueCaptureAddressCreateInfo
  {
    using NativeType = VkBufferOpaqueCaptureAddressCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferOpaqueCaptureAddressCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferOpaqueCaptureAddressCreateInfo( uint64_t opaqueCaptureAddress_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , opaqueCaptureAddress( opaqueCaptureAddress_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferOpaqueCaptureAddressCreateInfo( BufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferOpaqueCaptureAddressCreateInfo( VkBufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferOpaqueCaptureAddressCreateInfo( *reinterpret_cast<BufferOpaqueCaptureAddressCreateInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferOpaqueCaptureAddressCreateInfo & operator=( BufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferOpaqueCaptureAddressCreateInfo & operator=( VkBufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferOpaqueCaptureAddressCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferOpaqueCaptureAddressCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferOpaqueCaptureAddressCreateInfo & setOpaqueCaptureAddress( uint64_t opaqueCaptureAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      opaqueCaptureAddress = opaqueCaptureAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferOpaqueCaptureAddressCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferOpaqueCaptureAddressCreateInfo *>( this );
    }

    explicit operator VkBufferOpaqueCaptureAddressCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferOpaqueCaptureAddressCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, opaqueCaptureAddress );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferOpaqueCaptureAddressCreateInfo const & ) const = default;
#else
    bool operator==( BufferOpaqueCaptureAddressCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( opaqueCaptureAddress == rhs.opaqueCaptureAddress );
#  endif
    }

    bool operator!=( BufferOpaqueCaptureAddressCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                = StructureType::eBufferOpaqueCaptureAddressCreateInfo;
    const void *                        pNext                = {};
    uint64_t                            opaqueCaptureAddress = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferOpaqueCaptureAddressCreateInfo ) == sizeof( VkBufferOpaqueCaptureAddressCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferOpaqueCaptureAddressCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferOpaqueCaptureAddressCreateInfo>::value,
                            "BufferOpaqueCaptureAddressCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferOpaqueCaptureAddressCreateInfo>
  {
    using Type = BufferOpaqueCaptureAddressCreateInfo;
  };
  using BufferOpaqueCaptureAddressCreateInfoKHR = BufferOpaqueCaptureAddressCreateInfo;

  struct BufferViewCreateInfo
  {
    using NativeType = VkBufferViewCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferViewCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferViewCreateInfo( VULKAN_HPP_NAMESPACE::BufferViewCreateFlags flags_  = {},
                                               VULKAN_HPP_NAMESPACE::Buffer                buffer_ = {},
                                               VULKAN_HPP_NAMESPACE::Format                format_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                               VULKAN_HPP_NAMESPACE::DeviceSize            offset_ = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize            range_  = {},
                                               const void *                                pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , buffer( buffer_ )
      , format( format_ )
      , offset( offset_ )
      , range( range_ )
    {
    }

    VULKAN_HPP_CONSTEXPR BufferViewCreateInfo( BufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferViewCreateInfo( VkBufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferViewCreateInfo( *reinterpret_cast<BufferViewCreateInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    BufferViewCreateInfo & operator=( BufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferViewCreateInfo & operator=( VkBufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::BufferViewCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::BufferViewCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setFormat( VULKAN_HPP_NAMESPACE::Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setRange( VULKAN_HPP_NAMESPACE::DeviceSize range_ ) VULKAN_HPP_NOEXCEPT
    {
      range = range_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkBufferViewCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferViewCreateInfo *>( this );
    }

    explicit operator VkBufferViewCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferViewCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::BufferViewCreateFlags const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, buffer, format, offset, range );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferViewCreateInfo const & ) const = default;
#else
    bool operator==( BufferViewCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( buffer == rhs.buffer ) && ( format == rhs.format ) &&
             ( offset == rhs.offset ) && ( range == rhs.range );
#  endif
    }

    bool operator!=( BufferViewCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType  = StructureType::eBufferViewCreateInfo;
    const void *                                pNext  = {};
    VULKAN_HPP_NAMESPACE::BufferViewCreateFlags flags  = {};
    VULKAN_HPP_NAMESPACE::Buffer                buffer = {};
    VULKAN_HPP_NAMESPACE::Format                format = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::DeviceSize            offset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize            range  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::BufferViewCreateInfo ) == sizeof( VkBufferViewCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::BufferViewCreateInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::BufferViewCreateInfo>::value,
                            "BufferViewCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eBufferViewCreateInfo>
  {
    using Type = BufferViewCreateInfo;
  };

  struct CalibratedTimestampInfoEXT
  {
    using NativeType = VkCalibratedTimestampInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCalibratedTimestampInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CalibratedTimestampInfoEXT( VULKAN_HPP_NAMESPACE::TimeDomainEXT timeDomain_ = VULKAN_HPP_NAMESPACE::TimeDomainEXT::eDevice,
                                                     const void *                        pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , timeDomain( timeDomain_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CalibratedTimestampInfoEXT( CalibratedTimestampInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CalibratedTimestampInfoEXT( VkCalibratedTimestampInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : CalibratedTimestampInfoEXT( *reinterpret_cast<CalibratedTimestampInfoEXT const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CalibratedTimestampInfoEXT & operator=( CalibratedTimestampInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CalibratedTimestampInfoEXT & operator=( VkCalibratedTimestampInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CalibratedTimestampInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CalibratedTimestampInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CalibratedTimestampInfoEXT & setTimeDomain( VULKAN_HPP_NAMESPACE::TimeDomainEXT timeDomain_ ) VULKAN_HPP_NOEXCEPT
    {
      timeDomain = timeDomain_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCalibratedTimestampInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCalibratedTimestampInfoEXT *>( this );
    }

    explicit operator VkCalibratedTimestampInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCalibratedTimestampInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::TimeDomainEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, timeDomain );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CalibratedTimestampInfoEXT const & ) const = default;
#else
    bool operator==( CalibratedTimestampInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( timeDomain == rhs.timeDomain );
#  endif
    }

    bool operator!=( CalibratedTimestampInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType      = StructureType::eCalibratedTimestampInfoEXT;
    const void *                        pNext      = {};
    VULKAN_HPP_NAMESPACE::TimeDomainEXT timeDomain = VULKAN_HPP_NAMESPACE::TimeDomainEXT::eDevice;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CalibratedTimestampInfoEXT ) == sizeof( VkCalibratedTimestampInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CalibratedTimestampInfoEXT>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CalibratedTimestampInfoEXT>::value,
                            "CalibratedTimestampInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCalibratedTimestampInfoEXT>
  {
    using Type = CalibratedTimestampInfoEXT;
  };

  struct CheckpointData2NV
  {
    using NativeType = VkCheckpointData2NV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCheckpointData2NV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CheckpointData2NV( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 stage_ = {}, void * pCheckpointMarker_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , stage( stage_ )
      , pCheckpointMarker( pCheckpointMarker_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CheckpointData2NV( CheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CheckpointData2NV( VkCheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT : CheckpointData2NV( *reinterpret_cast<CheckpointData2NV const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CheckpointData2NV & operator=( CheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CheckpointData2NV & operator=( VkCheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CheckpointData2NV const *>( &rhs );
      return *this;
    }

    explicit operator VkCheckpointData2NV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCheckpointData2NV *>( this );
    }

    explicit operator VkCheckpointData2NV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCheckpointData2NV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &, void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stage, pCheckpointMarker );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CheckpointData2NV const & ) const = default;
#else
    bool operator==( CheckpointData2NV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stage == rhs.stage ) && ( pCheckpointMarker == rhs.pCheckpointMarker );
#  endif
    }

    bool operator!=( CheckpointData2NV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType             = StructureType::eCheckpointData2NV;
    void *                                    pNext             = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2 stage             = {};
    void *                                    pCheckpointMarker = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CheckpointData2NV ) == sizeof( VkCheckpointData2NV ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CheckpointData2NV>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CheckpointData2NV>::value,
                            "CheckpointData2NV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCheckpointData2NV>
  {
    using Type = CheckpointData2NV;
  };

  struct CheckpointDataNV
  {
    using NativeType = VkCheckpointDataNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCheckpointDataNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CheckpointDataNV( VULKAN_HPP_NAMESPACE::PipelineStageFlagBits stage_ = VULKAN_HPP_NAMESPACE::PipelineStageFlagBits::eTopOfPipe,
                                           void *                                      pCheckpointMarker_ = {},
                                           void *                                      pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , stage( stage_ )
      , pCheckpointMarker( pCheckpointMarker_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CheckpointDataNV( CheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CheckpointDataNV( VkCheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT : CheckpointDataNV( *reinterpret_cast<CheckpointDataNV const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CheckpointDataNV & operator=( CheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CheckpointDataNV & operator=( VkCheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CheckpointDataNV const *>( &rhs );
      return *this;
    }

    explicit operator VkCheckpointDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCheckpointDataNV *>( this );
    }

    explicit operator VkCheckpointDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCheckpointDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::PipelineStageFlagBits const &, void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stage, pCheckpointMarker );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CheckpointDataNV const & ) const = default;
#else
    bool operator==( CheckpointDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stage == rhs.stage ) && ( pCheckpointMarker == rhs.pCheckpointMarker );
#  endif
    }

    bool operator!=( CheckpointDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType             = StructureType::eCheckpointDataNV;
    void *                                      pNext             = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlagBits stage             = VULKAN_HPP_NAMESPACE::PipelineStageFlagBits::eTopOfPipe;
    void *                                      pCheckpointMarker = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CheckpointDataNV ) == sizeof( VkCheckpointDataNV ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CheckpointDataNV>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CheckpointDataNV>::value,
                            "CheckpointDataNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCheckpointDataNV>
  {
    using Type = CheckpointDataNV;
  };

  union ClearColorValue
  {
    using NativeType = VkClearColorValue;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<float, 4> & float32_ = {} ) : float32( float32_ ) {}

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<int32_t, 4> & int32_ ) : int32( int32_ ) {}

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<uint32_t, 4> & uint32_ ) : uint32( uint32_ ) {}
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setFloat32( std::array<float, 4> float32_ ) VULKAN_HPP_NOEXCEPT
    {
      float32 = float32_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setInt32( std::array<int32_t, 4> int32_ ) VULKAN_HPP_NOEXCEPT
    {
      int32 = int32_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setUint32( std::array<uint32_t, 4> uint32_ ) VULKAN_HPP_NOEXCEPT
    {
      uint32 = uint32_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkClearColorValue const &() const
    {
      return *reinterpret_cast<const VkClearColorValue *>( this );
    }

    operator VkClearColorValue &()
    {
      return *reinterpret_cast<VkClearColorValue *>( this );
    }

    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4>    float32;
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<int32_t, 4>  int32;
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<uint32_t, 4> uint32;
  };

  struct ClearDepthStencilValue
  {
    using NativeType = VkClearDepthStencilValue;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClearDepthStencilValue( float depth_ = {}, uint32_t stencil_ = {} ) VULKAN_HPP_NOEXCEPT
      : depth( depth_ )
      , stencil( stencil_ )
    {
    }

    VULKAN_HPP_CONSTEXPR ClearDepthStencilValue( ClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearDepthStencilValue( VkClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClearDepthStencilValue( *reinterpret_cast<ClearDepthStencilValue const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ClearDepthStencilValue & operator=( ClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearDepthStencilValue & operator=( VkClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClearDepthStencilValue const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearDepthStencilValue & setDepth( float depth_ ) VULKAN_HPP_NOEXCEPT
    {
      depth = depth_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearDepthStencilValue & setStencil( uint32_t stencil_ ) VULKAN_HPP_NOEXCEPT
    {
      stencil = stencil_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkClearDepthStencilValue const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearDepthStencilValue *>( this );
    }

    explicit operator VkClearDepthStencilValue &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearDepthStencilValue *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( depth, stencil );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClearDepthStencilValue const & ) const = default;
#else
    bool operator==( ClearDepthStencilValue const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( depth == rhs.depth ) && ( stencil == rhs.stencil );
#  endif
    }

    bool operator!=( ClearDepthStencilValue const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float    depth   = {};
    uint32_t stencil = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ClearDepthStencilValue ) == sizeof( VkClearDepthStencilValue ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ClearDepthStencilValue>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ClearDepthStencilValue>::value,
                            "ClearDepthStencilValue is not nothrow_move_constructible!" );

  union ClearValue
  {
    using NativeType = VkClearValue;
#if !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 ClearValue( VULKAN_HPP_NAMESPACE::ClearColorValue color_ = {} ) : color( color_ ) {}

    VULKAN_HPP_CONSTEXPR_14 ClearValue( VULKAN_HPP_NAMESPACE::ClearDepthStencilValue depthStencil_ ) : depthStencil( depthStencil_ ) {}
#endif /*VULKAN_HPP_NO_UNION_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearValue & setColor( VULKAN_HPP_NAMESPACE::ClearColorValue const & color_ ) VULKAN_HPP_NOEXCEPT
    {
      color = color_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearValue & setDepthStencil( VULKAN_HPP_NAMESPACE::ClearDepthStencilValue const & depthStencil_ ) VULKAN_HPP_NOEXCEPT
    {
      depthStencil = depthStencil_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_UNION_SETTERS*/

    operator VkClearValue const &() const
    {
      return *reinterpret_cast<const VkClearValue *>( this );
    }

    operator VkClearValue &()
    {
      return *reinterpret_cast<VkClearValue *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    VULKAN_HPP_NAMESPACE::ClearColorValue        color;
    VULKAN_HPP_NAMESPACE::ClearDepthStencilValue depthStencil;
#else
    VkClearColorValue        color;
    VkClearDepthStencilValue depthStencil;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  struct ClearAttachment
  {
    using NativeType = VkClearAttachment;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ClearAttachment( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_      = {},
                                             uint32_t                               colorAttachment_ = {},
                                             VULKAN_HPP_NAMESPACE::ClearValue       clearValue_      = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask( aspectMask_ )
      , colorAttachment( colorAttachment_ )
      , clearValue( clearValue_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment( ClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearAttachment( VkClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT : ClearAttachment( *reinterpret_cast<ClearAttachment const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ClearAttachment & operator=( ClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearAttachment & operator=( VkClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClearAttachment const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearAttachment & setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment & setColorAttachment( uint32_t colorAttachment_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachment = colorAttachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment & setClearValue( VULKAN_HPP_NAMESPACE::ClearValue const & clearValue_ ) VULKAN_HPP_NOEXCEPT
    {
      clearValue = clearValue_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkClearAttachment const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearAttachment *>( this );
    }

    explicit operator VkClearAttachment &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearAttachment *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageAspectFlags const &, uint32_t const &, VULKAN_HPP_NAMESPACE::ClearValue const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( aspectMask, colorAttachment, clearValue );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask      = {};
    uint32_t                               colorAttachment = {};
    VULKAN_HPP_NAMESPACE::ClearValue       clearValue      = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ClearAttachment ) == sizeof( VkClearAttachment ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ClearAttachment>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ClearAttachment>::value,
                            "ClearAttachment is not nothrow_move_constructible!" );

  struct ClearRect
  {
    using NativeType = VkClearRect;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClearRect( VULKAN_HPP_NAMESPACE::Rect2D rect_ = {}, uint32_t baseArrayLayer_ = {}, uint32_t layerCount_ = {} ) VULKAN_HPP_NOEXCEPT
      : rect( rect_ )
      , baseArrayLayer( baseArrayLayer_ )
      , layerCount( layerCount_ )
    {
    }

    VULKAN_HPP_CONSTEXPR ClearRect( ClearRect const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearRect( VkClearRect const & rhs ) VULKAN_HPP_NOEXCEPT : ClearRect( *reinterpret_cast<ClearRect const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ClearRect & operator=( ClearRect const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearRect & operator=( VkClearRect const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ClearRect const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearRect & setRect( VULKAN_HPP_NAMESPACE::Rect2D const & rect_ ) VULKAN_HPP_NOEXCEPT
    {
      rect = rect_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearRect & setBaseArrayLayer( uint32_t baseArrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      baseArrayLayer = baseArrayLayer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearRect & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkClearRect const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearRect *>( this );
    }

    explicit operator VkClearRect &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearRect *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Rect2D const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( rect, baseArrayLayer, layerCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClearRect const & ) const = default;
#else
    bool                     operator==( ClearRect const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( rect == rhs.rect ) && ( baseArrayLayer == rhs.baseArrayLayer ) && ( layerCount == rhs.layerCount );
#  endif
    }

    bool operator!=( ClearRect const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Rect2D rect           = {};
    uint32_t                     baseArrayLayer = {};
    uint32_t                     layerCount     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ClearRect ) == sizeof( VkClearRect ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ClearRect>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ClearRect>::value, "ClearRect is not nothrow_move_constructible!" );

  struct CoarseSampleLocationNV
  {
    using NativeType = VkCoarseSampleLocationNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CoarseSampleLocationNV( uint32_t pixelX_ = {}, uint32_t pixelY_ = {}, uint32_t sample_ = {} ) VULKAN_HPP_NOEXCEPT
      : pixelX( pixelX_ )
      , pixelY( pixelY_ )
      , sample( sample_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CoarseSampleLocationNV( CoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CoarseSampleLocationNV( VkCoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CoarseSampleLocationNV( *reinterpret_cast<CoarseSampleLocationNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CoarseSampleLocationNV & operator=( CoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CoarseSampleLocationNV & operator=( VkCoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CoarseSampleLocationNV & setPixelX( uint32_t pixelX_ ) VULKAN_HPP_NOEXCEPT
    {
      pixelX = pixelX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleLocationNV & setPixelY( uint32_t pixelY_ ) VULKAN_HPP_NOEXCEPT
    {
      pixelY = pixelY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleLocationNV & setSample( uint32_t sample_ ) VULKAN_HPP_NOEXCEPT
    {
      sample = sample_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCoarseSampleLocationNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCoarseSampleLocationNV *>( this );
    }

    explicit operator VkCoarseSampleLocationNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCoarseSampleLocationNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( pixelX, pixelY, sample );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CoarseSampleLocationNV const & ) const = default;
#else
    bool operator==( CoarseSampleLocationNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( pixelX == rhs.pixelX ) && ( pixelY == rhs.pixelY ) && ( sample == rhs.sample );
#  endif
    }

    bool operator!=( CoarseSampleLocationNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t pixelX = {};
    uint32_t pixelY = {};
    uint32_t sample = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV ) == sizeof( VkCoarseSampleLocationNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV>::value,
                            "CoarseSampleLocationNV is not nothrow_move_constructible!" );

  struct CoarseSampleOrderCustomNV
  {
    using NativeType = VkCoarseSampleOrderCustomNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CoarseSampleOrderCustomNV( VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV shadingRate_ = VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV::eNoInvocations,
                                 uint32_t                                        sampleCount_ = {},
                                 uint32_t                                        sampleLocationCount_   = {},
                                 const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV * pSampleLocations_ = {} ) VULKAN_HPP_NOEXCEPT
      : shadingRate( shadingRate_ )
      , sampleCount( sampleCount_ )
      , sampleLocationCount( sampleLocationCount_ )
      , pSampleLocations( pSampleLocations_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CoarseSampleOrderCustomNV( CoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CoarseSampleOrderCustomNV( VkCoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CoarseSampleOrderCustomNV( *reinterpret_cast<CoarseSampleOrderCustomNV const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CoarseSampleOrderCustomNV( VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV                                                           shadingRate_,
                               uint32_t                                                                                                  sampleCount_,
                               VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV> const & sampleLocations_ )
      : shadingRate( shadingRate_ )
      , sampleCount( sampleCount_ )
      , sampleLocationCount( static_cast<uint32_t>( sampleLocations_.size() ) )
      , pSampleLocations( sampleLocations_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CoarseSampleOrderCustomNV & operator=( CoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CoarseSampleOrderCustomNV & operator=( VkCoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CoarseSampleOrderCustomNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV & setShadingRate( VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV shadingRate_ ) VULKAN_HPP_NOEXCEPT
    {
      shadingRate = shadingRate_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV & setSampleCount( uint32_t sampleCount_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleCount = sampleCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV & setSampleLocationCount( uint32_t sampleLocationCount_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationCount = sampleLocationCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV &
                            setPSampleLocations( const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV * pSampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      pSampleLocations = pSampleLocations_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CoarseSampleOrderCustomNV & setSampleLocations(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV> const & sampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationCount = static_cast<uint32_t>( sampleLocations_.size() );
      pSampleLocations    = sampleLocations_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCoarseSampleOrderCustomNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCoarseSampleOrderCustomNV *>( this );
    }

    explicit operator VkCoarseSampleOrderCustomNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCoarseSampleOrderCustomNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV const &,
               uint32_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( shadingRate, sampleCount, sampleLocationCount, pSampleLocations );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CoarseSampleOrderCustomNV const & ) const = default;
#else
    bool operator==( CoarseSampleOrderCustomNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( shadingRate == rhs.shadingRate ) && ( sampleCount == rhs.sampleCount ) && ( sampleLocationCount == rhs.sampleLocationCount ) &&
             ( pSampleLocations == rhs.pSampleLocations );
#  endif
    }

    bool operator!=( CoarseSampleOrderCustomNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV      shadingRate         = VULKAN_HPP_NAMESPACE::ShadingRatePaletteEntryNV::eNoInvocations;
    uint32_t                                             sampleCount         = {};
    uint32_t                                             sampleLocationCount = {};
    const VULKAN_HPP_NAMESPACE::CoarseSampleLocationNV * pSampleLocations    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CoarseSampleOrderCustomNV ) == sizeof( VkCoarseSampleOrderCustomNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CoarseSampleOrderCustomNV>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CoarseSampleOrderCustomNV>::value,
                            "CoarseSampleOrderCustomNV is not nothrow_move_constructible!" );

  struct CommandBufferAllocateInfo
  {
    using NativeType = VkCommandBufferAllocateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferAllocateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferAllocateInfo( VULKAN_HPP_NAMESPACE::CommandPool        commandPool_ = {},
                                                    VULKAN_HPP_NAMESPACE::CommandBufferLevel level_       = VULKAN_HPP_NAMESPACE::CommandBufferLevel::ePrimary,
                                                    uint32_t                                 commandBufferCount_ = {},
                                                    const void *                             pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , commandPool( commandPool_ )
      , level( level_ )
      , commandBufferCount( commandBufferCount_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferAllocateInfo( CommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferAllocateInfo( VkCommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferAllocateInfo( *reinterpret_cast<CommandBufferAllocateInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferAllocateInfo & operator=( CommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferAllocateInfo & operator=( VkCommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferAllocateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setCommandPool( VULKAN_HPP_NAMESPACE::CommandPool commandPool_ ) VULKAN_HPP_NOEXCEPT
    {
      commandPool = commandPool_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setLevel( VULKAN_HPP_NAMESPACE::CommandBufferLevel level_ ) VULKAN_HPP_NOEXCEPT
    {
      level = level_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setCommandBufferCount( uint32_t commandBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      commandBufferCount = commandBufferCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCommandBufferAllocateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferAllocateInfo *>( this );
    }

    explicit operator VkCommandBufferAllocateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferAllocateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::CommandPool const &,
               VULKAN_HPP_NAMESPACE::CommandBufferLevel const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, commandPool, level, commandBufferCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferAllocateInfo const & ) const = default;
#else
    bool operator==( CommandBufferAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( commandPool == rhs.commandPool ) && ( level == rhs.level ) &&
             ( commandBufferCount == rhs.commandBufferCount );
#  endif
    }

    bool operator!=( CommandBufferAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType      sType              = StructureType::eCommandBufferAllocateInfo;
    const void *                             pNext              = {};
    VULKAN_HPP_NAMESPACE::CommandPool        commandPool        = {};
    VULKAN_HPP_NAMESPACE::CommandBufferLevel level              = VULKAN_HPP_NAMESPACE::CommandBufferLevel::ePrimary;
    uint32_t                                 commandBufferCount = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferAllocateInfo ) == sizeof( VkCommandBufferAllocateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferAllocateInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferAllocateInfo>::value,
                            "CommandBufferAllocateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferAllocateInfo>
  {
    using Type = CommandBufferAllocateInfo;
  };

  struct CommandBufferInheritanceInfo
  {
    using NativeType = VkCommandBufferInheritanceInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceInfo( VULKAN_HPP_NAMESPACE::RenderPass                  renderPass_           = {},
                                                       uint32_t                                          subpass_              = {},
                                                       VULKAN_HPP_NAMESPACE::Framebuffer                 framebuffer_          = {},
                                                       VULKAN_HPP_NAMESPACE::Bool32                      occlusionQueryEnable_ = {},
                                                       VULKAN_HPP_NAMESPACE::QueryControlFlags           queryFlags_           = {},
                                                       VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags pipelineStatistics_   = {},
                                                       const void *                                      pNext_                = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , renderPass( renderPass_ )
      , subpass( subpass_ )
      , framebuffer( framebuffer_ )
      , occlusionQueryEnable( occlusionQueryEnable_ )
      , queryFlags( queryFlags_ )
      , pipelineStatistics( pipelineStatistics_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceInfo( CommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceInfo( VkCommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceInfo( *reinterpret_cast<CommandBufferInheritanceInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferInheritanceInfo & operator=( CommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceInfo & operator=( VkCommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setRenderPass( VULKAN_HPP_NAMESPACE::RenderPass renderPass_ ) VULKAN_HPP_NOEXCEPT
    {
      renderPass = renderPass_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setSubpass( uint32_t subpass_ ) VULKAN_HPP_NOEXCEPT
    {
      subpass = subpass_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setFramebuffer( VULKAN_HPP_NAMESPACE::Framebuffer framebuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      framebuffer = framebuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setOcclusionQueryEnable( VULKAN_HPP_NAMESPACE::Bool32 occlusionQueryEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      occlusionQueryEnable = occlusionQueryEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setQueryFlags( VULKAN_HPP_NAMESPACE::QueryControlFlags queryFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      queryFlags = queryFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo &
                            setPipelineStatistics( VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags pipelineStatistics_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineStatistics = pipelineStatistics_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCommandBufferInheritanceInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceInfo *>( this );
    }

    explicit operator VkCommandBufferInheritanceInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::RenderPass const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::Framebuffer const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::QueryControlFlags const &,
               VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, renderPass, subpass, framebuffer, occlusionQueryEnable, queryFlags, pipelineStatistics );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceInfo const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( renderPass == rhs.renderPass ) && ( subpass == rhs.subpass ) &&
             ( framebuffer == rhs.framebuffer ) && ( occlusionQueryEnable == rhs.occlusionQueryEnable ) && ( queryFlags == rhs.queryFlags ) &&
             ( pipelineStatistics == rhs.pipelineStatistics );
#  endif
    }

    bool operator!=( CommandBufferInheritanceInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType                = StructureType::eCommandBufferInheritanceInfo;
    const void *                                      pNext                = {};
    VULKAN_HPP_NAMESPACE::RenderPass                  renderPass           = {};
    uint32_t                                          subpass              = {};
    VULKAN_HPP_NAMESPACE::Framebuffer                 framebuffer          = {};
    VULKAN_HPP_NAMESPACE::Bool32                      occlusionQueryEnable = {};
    VULKAN_HPP_NAMESPACE::QueryControlFlags           queryFlags           = {};
    VULKAN_HPP_NAMESPACE::QueryPipelineStatisticFlags pipelineStatistics   = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo ) == sizeof( VkCommandBufferInheritanceInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo>::value,
                            "CommandBufferInheritanceInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceInfo>
  {
    using Type = CommandBufferInheritanceInfo;
  };

  struct CommandBufferBeginInfo
  {
    using NativeType = VkCommandBufferBeginInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferBeginInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferBeginInfo( VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags              flags_            = {},
                                                 const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * pInheritanceInfo_ = {},
                                                 const void *                                               pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , pInheritanceInfo( pInheritanceInfo_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferBeginInfo( CommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferBeginInfo( VkCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferBeginInfo( *reinterpret_cast<CommandBufferBeginInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferBeginInfo & operator=( CommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferBeginInfo & operator=( VkCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferBeginInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo & setFlags( VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo &
                            setPInheritanceInfo( const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * pInheritanceInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pInheritanceInfo = pInheritanceInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCommandBufferBeginInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferBeginInfo *>( this );
    }

    explicit operator VkCommandBufferBeginInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferBeginInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags const &,
               const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, pInheritanceInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferBeginInfo const & ) const = default;
#else
    bool operator==( CommandBufferBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( pInheritanceInfo == rhs.pInheritanceInfo );
#  endif
    }

    bool operator!=( CommandBufferBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                        sType            = StructureType::eCommandBufferBeginInfo;
    const void *                                               pNext            = {};
    VULKAN_HPP_NAMESPACE::CommandBufferUsageFlags              flags            = {};
    const VULKAN_HPP_NAMESPACE::CommandBufferInheritanceInfo * pInheritanceInfo = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferBeginInfo ) == sizeof( VkCommandBufferBeginInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferBeginInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferBeginInfo>::value,
                            "CommandBufferBeginInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferBeginInfo>
  {
    using Type = CommandBufferBeginInfo;
  };

  struct CommandBufferInheritanceConditionalRenderingInfoEXT
  {
    using NativeType = VkCommandBufferInheritanceConditionalRenderingInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceConditionalRenderingInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceConditionalRenderingInfoEXT( VULKAN_HPP_NAMESPACE::Bool32 conditionalRenderingEnable_ = {},
                                                                              const void *                 pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , conditionalRenderingEnable( conditionalRenderingEnable_ )
    {
    }

    VULKAN_HPP_CONSTEXPR
      CommandBufferInheritanceConditionalRenderingInfoEXT( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceConditionalRenderingInfoEXT( VkCommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceConditionalRenderingInfoEXT( *reinterpret_cast<CommandBufferInheritanceConditionalRenderingInfoEXT const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferInheritanceConditionalRenderingInfoEXT &
      operator=( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceConditionalRenderingInfoEXT & operator=( VkCommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceConditionalRenderingInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceConditionalRenderingInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceConditionalRenderingInfoEXT &
                            setConditionalRenderingEnable( VULKAN_HPP_NAMESPACE::Bool32 conditionalRenderingEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      conditionalRenderingEnable = conditionalRenderingEnable_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCommandBufferInheritanceConditionalRenderingInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceConditionalRenderingInfoEXT *>( this );
    }

    explicit operator VkCommandBufferInheritanceConditionalRenderingInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceConditionalRenderingInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, conditionalRenderingEnable );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceConditionalRenderingInfoEXT const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( conditionalRenderingEnable == rhs.conditionalRenderingEnable );
#  endif
    }

    bool operator!=( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                      = StructureType::eCommandBufferInheritanceConditionalRenderingInfoEXT;
    const void *                        pNext                      = {};
    VULKAN_HPP_NAMESPACE::Bool32        conditionalRenderingEnable = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceConditionalRenderingInfoEXT ) ==
                              sizeof( VkCommandBufferInheritanceConditionalRenderingInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceConditionalRenderingInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceConditionalRenderingInfoEXT>::value,
                            "CommandBufferInheritanceConditionalRenderingInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceConditionalRenderingInfoEXT>
  {
    using Type = CommandBufferInheritanceConditionalRenderingInfoEXT;
  };

  struct CommandBufferInheritanceRenderPassTransformInfoQCOM
  {
    using NativeType = VkCommandBufferInheritanceRenderPassTransformInfoQCOM;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceRenderPassTransformInfoQCOM;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceRenderPassTransformInfoQCOM(
      VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform_  = VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity,
      VULKAN_HPP_NAMESPACE::Rect2D                      renderArea_ = {},
      void *                                            pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , transform( transform_ )
      , renderArea( renderArea_ )
    {
    }

    VULKAN_HPP_CONSTEXPR
      CommandBufferInheritanceRenderPassTransformInfoQCOM( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceRenderPassTransformInfoQCOM( VkCommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceRenderPassTransformInfoQCOM( *reinterpret_cast<CommandBufferInheritanceRenderPassTransformInfoQCOM const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferInheritanceRenderPassTransformInfoQCOM &
      operator=( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceRenderPassTransformInfoQCOM & operator=( VkCommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderPassTransformInfoQCOM const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderPassTransformInfoQCOM & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderPassTransformInfoQCOM &
                            setTransform( VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform_ ) VULKAN_HPP_NOEXCEPT
    {
      transform = transform_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderPassTransformInfoQCOM &
                            setRenderArea( VULKAN_HPP_NAMESPACE::Rect2D const & renderArea_ ) VULKAN_HPP_NOEXCEPT
    {
      renderArea = renderArea_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCommandBufferInheritanceRenderPassTransformInfoQCOM const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceRenderPassTransformInfoQCOM *>( this );
    }

    explicit operator VkCommandBufferInheritanceRenderPassTransformInfoQCOM &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceRenderPassTransformInfoQCOM *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR const &,
               VULKAN_HPP_NAMESPACE::Rect2D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, transform, renderArea );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceRenderPassTransformInfoQCOM const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( transform == rhs.transform ) && ( renderArea == rhs.renderArea );
#  endif
    }

    bool operator!=( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType      = StructureType::eCommandBufferInheritanceRenderPassTransformInfoQCOM;
    void *                                            pNext      = {};
    VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform  = VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity;
    VULKAN_HPP_NAMESPACE::Rect2D                      renderArea = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderPassTransformInfoQCOM ) ==
                              sizeof( VkCommandBufferInheritanceRenderPassTransformInfoQCOM ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderPassTransformInfoQCOM>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderPassTransformInfoQCOM>::value,
                            "CommandBufferInheritanceRenderPassTransformInfoQCOM is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceRenderPassTransformInfoQCOM>
  {
    using Type = CommandBufferInheritanceRenderPassTransformInfoQCOM;
  };

  struct CommandBufferInheritanceRenderingInfo
  {
    using NativeType = VkCommandBufferInheritanceRenderingInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceRenderingInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CommandBufferInheritanceRenderingInfo( VULKAN_HPP_NAMESPACE::RenderingFlags      flags_                   = {},
                                             uint32_t                                  viewMask_                = {},
                                             uint32_t                                  colorAttachmentCount_    = {},
                                             const VULKAN_HPP_NAMESPACE::Format *      pColorAttachmentFormats_ = {},
                                             VULKAN_HPP_NAMESPACE::Format              depthAttachmentFormat_   = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                             VULKAN_HPP_NAMESPACE::Format              stencilAttachmentFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                             VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_    = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                                             const void *                              pNext_                   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , viewMask( viewMask_ )
      , colorAttachmentCount( colorAttachmentCount_ )
      , pColorAttachmentFormats( pColorAttachmentFormats_ )
      , depthAttachmentFormat( depthAttachmentFormat_ )
      , stencilAttachmentFormat( stencilAttachmentFormat_ )
      , rasterizationSamples( rasterizationSamples_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceRenderingInfo( CommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceRenderingInfo( VkCommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceRenderingInfo( *reinterpret_cast<CommandBufferInheritanceRenderingInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CommandBufferInheritanceRenderingInfo( VULKAN_HPP_NAMESPACE::RenderingFlags                                                      flags_,
                                           uint32_t                                                                                  viewMask_,
                                           VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Format> const & colorAttachmentFormats_,
                                           VULKAN_HPP_NAMESPACE::Format              depthAttachmentFormat_   = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                           VULKAN_HPP_NAMESPACE::Format              stencilAttachmentFormat_ = VULKAN_HPP_NAMESPACE::Format::eUndefined,
                                           VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_    = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1,
                                           const void *                              pNext_                   = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , viewMask( viewMask_ )
      , colorAttachmentCount( static_cast<uint32_t>( colorAttachmentFormats_.size() ) )
      , pColorAttachmentFormats( colorAttachmentFormats_.data() )
      , depthAttachmentFormat( depthAttachmentFormat_ )
      , stencilAttachmentFormat( stencilAttachmentFormat_ )
      , rasterizationSamples( rasterizationSamples_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferInheritanceRenderingInfo & operator=( CommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceRenderingInfo & operator=( VkCommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderingInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setFlags( VULKAN_HPP_NAMESPACE::RenderingFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setViewMask( uint32_t viewMask_ ) VULKAN_HPP_NOEXCEPT
    {
      viewMask = viewMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setColorAttachmentCount( uint32_t colorAttachmentCount_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount = colorAttachmentCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo &
                            setPColorAttachmentFormats( const VULKAN_HPP_NAMESPACE::Format * pColorAttachmentFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      pColorAttachmentFormats = pColorAttachmentFormats_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CommandBufferInheritanceRenderingInfo & setColorAttachmentFormats(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Format> const & colorAttachmentFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount    = static_cast<uint32_t>( colorAttachmentFormats_.size() );
      pColorAttachmentFormats = colorAttachmentFormats_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo &
                            setDepthAttachmentFormat( VULKAN_HPP_NAMESPACE::Format depthAttachmentFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      depthAttachmentFormat = depthAttachmentFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo &
                            setStencilAttachmentFormat( VULKAN_HPP_NAMESPACE::Format stencilAttachmentFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilAttachmentFormat = stencilAttachmentFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo &
                            setRasterizationSamples( VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      rasterizationSamples = rasterizationSamples_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCommandBufferInheritanceRenderingInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceRenderingInfo *>( this );
    }

    explicit operator VkCommandBufferInheritanceRenderingInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceRenderingInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::RenderingFlags const &,
               uint32_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Format * const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::Format const &,
               VULKAN_HPP_NAMESPACE::SampleCountFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, flags, viewMask, colorAttachmentCount, pColorAttachmentFormats, depthAttachmentFormat, stencilAttachmentFormat, rasterizationSamples );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceRenderingInfo const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceRenderingInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( viewMask == rhs.viewMask ) &&
             ( colorAttachmentCount == rhs.colorAttachmentCount ) && ( pColorAttachmentFormats == rhs.pColorAttachmentFormats ) &&
             ( depthAttachmentFormat == rhs.depthAttachmentFormat ) && ( stencilAttachmentFormat == rhs.stencilAttachmentFormat ) &&
             ( rasterizationSamples == rhs.rasterizationSamples );
#  endif
    }

    bool operator!=( CommandBufferInheritanceRenderingInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType                   = StructureType::eCommandBufferInheritanceRenderingInfo;
    const void *                              pNext                   = {};
    VULKAN_HPP_NAMESPACE::RenderingFlags      flags                   = {};
    uint32_t                                  viewMask                = {};
    uint32_t                                  colorAttachmentCount    = {};
    const VULKAN_HPP_NAMESPACE::Format *      pColorAttachmentFormats = {};
    VULKAN_HPP_NAMESPACE::Format              depthAttachmentFormat   = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::Format              stencilAttachmentFormat = VULKAN_HPP_NAMESPACE::Format::eUndefined;
    VULKAN_HPP_NAMESPACE::SampleCountFlagBits rasterizationSamples    = VULKAN_HPP_NAMESPACE::SampleCountFlagBits::e1;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderingInfo ) == sizeof( VkCommandBufferInheritanceRenderingInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderingInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceRenderingInfo>::value,
                            "CommandBufferInheritanceRenderingInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceRenderingInfo>
  {
    using Type = CommandBufferInheritanceRenderingInfo;
  };
  using CommandBufferInheritanceRenderingInfoKHR = CommandBufferInheritanceRenderingInfo;

  struct Viewport
  {
    using NativeType = VkViewport;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      Viewport( float x_ = {}, float y_ = {}, float width_ = {}, float height_ = {}, float minDepth_ = {}, float maxDepth_ = {} ) VULKAN_HPP_NOEXCEPT
      : x( x_ )
      , y( y_ )
      , width( width_ )
      , height( height_ )
      , minDepth( minDepth_ )
      , maxDepth( maxDepth_ )
    {
    }

    VULKAN_HPP_CONSTEXPR Viewport( Viewport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Viewport( VkViewport const & rhs ) VULKAN_HPP_NOEXCEPT : Viewport( *reinterpret_cast<Viewport const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    Viewport & operator=( Viewport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Viewport & operator=( VkViewport const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::Viewport const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Viewport & setX( float x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setY( float y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setWidth( float width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setHeight( float height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setMinDepth( float minDepth_ ) VULKAN_HPP_NOEXCEPT
    {
      minDepth = minDepth_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setMaxDepth( float maxDepth_ ) VULKAN_HPP_NOEXCEPT
    {
      maxDepth = maxDepth_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkViewport const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkViewport *>( this );
    }

    explicit operator VkViewport &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkViewport *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, float const &, float const &, float const &, float const &, float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y, width, height, minDepth, maxDepth );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Viewport const & ) const = default;
#else
    bool operator==( Viewport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y ) && ( width == rhs.width ) && ( height == rhs.height ) && ( minDepth == rhs.minDepth ) &&
             ( maxDepth == rhs.maxDepth );
#  endif
    }

    bool operator!=( Viewport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float x        = {};
    float y        = {};
    float width    = {};
    float height   = {};
    float minDepth = {};
    float maxDepth = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::Viewport ) == sizeof( VkViewport ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::Viewport>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::Viewport>::value, "Viewport is not nothrow_move_constructible!" );

  struct CommandBufferInheritanceViewportScissorInfoNV
  {
    using NativeType = VkCommandBufferInheritanceViewportScissorInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceViewportScissorInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceViewportScissorInfoNV( VULKAN_HPP_NAMESPACE::Bool32           viewportScissor2D_  = {},
                                                                        uint32_t                               viewportDepthCount_ = {},
                                                                        const VULKAN_HPP_NAMESPACE::Viewport * pViewportDepths_    = {},
                                                                        const void *                           pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , viewportScissor2D( viewportScissor2D_ )
      , viewportDepthCount( viewportDepthCount_ )
      , pViewportDepths( pViewportDepths_ )
    {
    }

    VULKAN_HPP_CONSTEXPR
      CommandBufferInheritanceViewportScissorInfoNV( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceViewportScissorInfoNV( VkCommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceViewportScissorInfoNV( *reinterpret_cast<CommandBufferInheritanceViewportScissorInfoNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferInheritanceViewportScissorInfoNV & operator=( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceViewportScissorInfoNV & operator=( VkCommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceViewportScissorInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV &
                            setViewportScissor2D( VULKAN_HPP_NAMESPACE::Bool32 viewportScissor2D_ ) VULKAN_HPP_NOEXCEPT
    {
      viewportScissor2D = viewportScissor2D_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV & setViewportDepthCount( uint32_t viewportDepthCount_ ) VULKAN_HPP_NOEXCEPT
    {
      viewportDepthCount = viewportDepthCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV &
                            setPViewportDepths( const VULKAN_HPP_NAMESPACE::Viewport * pViewportDepths_ ) VULKAN_HPP_NOEXCEPT
    {
      pViewportDepths = pViewportDepths_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCommandBufferInheritanceViewportScissorInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceViewportScissorInfoNV *>( this );
    }

    explicit operator VkCommandBufferInheritanceViewportScissorInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceViewportScissorInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::Viewport * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, viewportScissor2D, viewportDepthCount, pViewportDepths );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceViewportScissorInfoNV const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( viewportScissor2D == rhs.viewportScissor2D ) &&
             ( viewportDepthCount == rhs.viewportDepthCount ) && ( pViewportDepths == rhs.pViewportDepths );
#  endif
    }

    bool operator!=( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType    sType              = StructureType::eCommandBufferInheritanceViewportScissorInfoNV;
    const void *                           pNext              = {};
    VULKAN_HPP_NAMESPACE::Bool32           viewportScissor2D  = {};
    uint32_t                               viewportDepthCount = {};
    const VULKAN_HPP_NAMESPACE::Viewport * pViewportDepths    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferInheritanceViewportScissorInfoNV ) ==
                              sizeof( VkCommandBufferInheritanceViewportScissorInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceViewportScissorInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferInheritanceViewportScissorInfoNV>::value,
                            "CommandBufferInheritanceViewportScissorInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceViewportScissorInfoNV>
  {
    using Type = CommandBufferInheritanceViewportScissorInfoNV;
  };

  struct CommandBufferSubmitInfo
  {
    using NativeType = VkCommandBufferSubmitInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferSubmitInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferSubmitInfo( VULKAN_HPP_NAMESPACE::CommandBuffer commandBuffer_ = {},
                                                  uint32_t                            deviceMask_    = {},
                                                  const void *                        pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , commandBuffer( commandBuffer_ )
      , deviceMask( deviceMask_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferSubmitInfo( CommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferSubmitInfo( VkCommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferSubmitInfo( *reinterpret_cast<CommandBufferSubmitInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandBufferSubmitInfo & operator=( CommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferSubmitInfo & operator=( VkCommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandBufferSubmitInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfo & setCommandBuffer( VULKAN_HPP_NAMESPACE::CommandBuffer commandBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      commandBuffer = commandBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfo & setDeviceMask( uint32_t deviceMask_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceMask = deviceMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCommandBufferSubmitInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferSubmitInfo *>( this );
    }

    explicit operator VkCommandBufferSubmitInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferSubmitInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::CommandBuffer const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, commandBuffer, deviceMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferSubmitInfo const & ) const = default;
#else
    bool operator==( CommandBufferSubmitInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( commandBuffer == rhs.commandBuffer ) && ( deviceMask == rhs.deviceMask );
#  endif
    }

    bool operator!=( CommandBufferSubmitInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType         = StructureType::eCommandBufferSubmitInfo;
    const void *                        pNext         = {};
    VULKAN_HPP_NAMESPACE::CommandBuffer commandBuffer = {};
    uint32_t                            deviceMask    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandBufferSubmitInfo ) == sizeof( VkCommandBufferSubmitInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandBufferSubmitInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandBufferSubmitInfo>::value,
                            "CommandBufferSubmitInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferSubmitInfo>
  {
    using Type = CommandBufferSubmitInfo;
  };
  using CommandBufferSubmitInfoKHR = CommandBufferSubmitInfo;

  struct CommandPoolCreateInfo
  {
    using NativeType = VkCommandPoolCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandPoolCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandPoolCreateInfo( VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags flags_            = {},
                                                uint32_t                                     queueFamilyIndex_ = {},
                                                const void *                                 pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , queueFamilyIndex( queueFamilyIndex_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CommandPoolCreateInfo( CommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandPoolCreateInfo( VkCommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandPoolCreateInfo( *reinterpret_cast<CommandPoolCreateInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CommandPoolCreateInfo & operator=( CommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandPoolCreateInfo & operator=( VkCommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CommandPoolCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo & setQueueFamilyIndex( uint32_t queueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndex = queueFamilyIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCommandPoolCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandPoolCreateInfo *>( this );
    }

    explicit operator VkCommandPoolCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandPoolCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, queueFamilyIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandPoolCreateInfo const & ) const = default;
#else
    bool operator==( CommandPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( queueFamilyIndex == rhs.queueFamilyIndex );
#  endif
    }

    bool operator!=( CommandPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType            = StructureType::eCommandPoolCreateInfo;
    const void *                                 pNext            = {};
    VULKAN_HPP_NAMESPACE::CommandPoolCreateFlags flags            = {};
    uint32_t                                     queueFamilyIndex = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CommandPoolCreateInfo ) == sizeof( VkCommandPoolCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CommandPoolCreateInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CommandPoolCreateInfo>::value,
                            "CommandPoolCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCommandPoolCreateInfo>
  {
    using Type = CommandPoolCreateInfo;
  };

  struct SpecializationMapEntry
  {
    using NativeType = VkSpecializationMapEntry;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SpecializationMapEntry( uint32_t constantID_ = {}, uint32_t offset_ = {}, size_t size_ = {} ) VULKAN_HPP_NOEXCEPT
      : constantID( constantID_ )
      , offset( offset_ )
      , size( size_ )
    {
    }

    VULKAN_HPP_CONSTEXPR SpecializationMapEntry( SpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationMapEntry( VkSpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT
      : SpecializationMapEntry( *reinterpret_cast<SpecializationMapEntry const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SpecializationMapEntry & operator=( SpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationMapEntry & operator=( VkSpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SpecializationMapEntry const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setConstantID( uint32_t constantID_ ) VULKAN_HPP_NOEXCEPT
    {
      constantID = constantID_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setOffset( uint32_t offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setSize( size_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkSpecializationMapEntry const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSpecializationMapEntry *>( this );
    }

    explicit operator VkSpecializationMapEntry &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSpecializationMapEntry *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, size_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( constantID, offset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SpecializationMapEntry const & ) const = default;
#else
    bool operator==( SpecializationMapEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( constantID == rhs.constantID ) && ( offset == rhs.offset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( SpecializationMapEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t constantID = {};
    uint32_t offset     = {};
    size_t   size       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SpecializationMapEntry ) == sizeof( VkSpecializationMapEntry ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SpecializationMapEntry>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SpecializationMapEntry>::value,
                            "SpecializationMapEntry is not nothrow_move_constructible!" );

  struct SpecializationInfo
  {
    using NativeType = VkSpecializationInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SpecializationInfo( uint32_t                                             mapEntryCount_ = {},
                                             const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * pMapEntries_   = {},
                                             size_t                                               dataSize_      = {},
                                             const void *                                         pData_         = {} ) VULKAN_HPP_NOEXCEPT
      : mapEntryCount( mapEntryCount_ )
      , pMapEntries( pMapEntries_ )
      , dataSize( dataSize_ )
      , pData( pData_ )
    {
    }

    VULKAN_HPP_CONSTEXPR SpecializationInfo( SpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationInfo( VkSpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT : SpecializationInfo( *reinterpret_cast<SpecializationInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    SpecializationInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SpecializationMapEntry> const & mapEntries_,
                        VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const &                                            data_ = {} )
      : mapEntryCount( static_cast<uint32_t>( mapEntries_.size() ) )
      , pMapEntries( mapEntries_.data() )
      , dataSize( data_.size() * sizeof( T ) )
      , pData( data_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    SpecializationInfo & operator=( SpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationInfo & operator=( VkSpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::SpecializationInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setMapEntryCount( uint32_t mapEntryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      mapEntryCount = mapEntryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setPMapEntries( const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * pMapEntries_ ) VULKAN_HPP_NOEXCEPT
    {
      pMapEntries = pMapEntries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SpecializationInfo &
      setMapEntries( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::SpecializationMapEntry> const & mapEntries_ ) VULKAN_HPP_NOEXCEPT
    {
      mapEntryCount = static_cast<uint32_t>( mapEntries_.size() );
      pMapEntries   = mapEntries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setDataSize( size_t dataSize_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = dataSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setPData( const void * pData_ ) VULKAN_HPP_NOEXCEPT
    {
      pData = pData_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    SpecializationInfo & setData( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = data_.size() * sizeof( T );
      pData    = data_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkSpecializationInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSpecializationInfo *>( this );
    }

    explicit operator VkSpecializationInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSpecializationInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * const &, size_t const &, const void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( mapEntryCount, pMapEntries, dataSize, pData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SpecializationInfo const & ) const = default;
#else
    bool operator==( SpecializationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( mapEntryCount == rhs.mapEntryCount ) && ( pMapEntries == rhs.pMapEntries ) && ( dataSize == rhs.dataSize ) && ( pData == rhs.pData );
#  endif
    }

    bool operator!=( SpecializationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                                             mapEntryCount = {};
    const VULKAN_HPP_NAMESPACE::SpecializationMapEntry * pMapEntries   = {};
    size_t                                               dataSize      = {};
    const void *                                         pData         = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::SpecializationInfo ) == sizeof( VkSpecializationInfo ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::SpecializationInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::SpecializationInfo>::value,
                            "SpecializationInfo is not nothrow_move_constructible!" );

  struct PipelineShaderStageCreateInfo
  {
    using NativeType = VkPipelineShaderStageCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineShaderStageCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PipelineShaderStageCreateInfo( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags flags_ = {},
                                                        VULKAN_HPP_NAMESPACE::ShaderStageFlagBits stage_  = VULKAN_HPP_NAMESPACE::ShaderStageFlagBits::eVertex,
                                                        VULKAN_HPP_NAMESPACE::ShaderModule        module_ = {},
                                                        const char *                              pName_  = {},
                                                        const VULKAN_HPP_NAMESPACE::SpecializationInfo * pSpecializationInfo_ = {},
                                                        const void *                                     pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , stage( stage_ )
      , module( module_ )
      , pName( pName_ )
      , pSpecializationInfo( pSpecializationInfo_ )
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineShaderStageCreateInfo( PipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineShaderStageCreateInfo( VkPipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineShaderStageCreateInfo( *reinterpret_cast<PipelineShaderStageCreateInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PipelineShaderStageCreateInfo & operator=( PipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineShaderStageCreateInfo & operator=( VkPipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setStage( VULKAN_HPP_NAMESPACE::ShaderStageFlagBits stage_ ) VULKAN_HPP_NOEXCEPT
    {
      stage = stage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setModule( VULKAN_HPP_NAMESPACE::ShaderModule module_ ) VULKAN_HPP_NOEXCEPT
    {
      module = module_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setPName( const char * pName_ ) VULKAN_HPP_NOEXCEPT
    {
      pName = pName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo &
                            setPSpecializationInfo( const VULKAN_HPP_NAMESPACE::SpecializationInfo * pSpecializationInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pSpecializationInfo = pSpecializationInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkPipelineShaderStageCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineShaderStageCreateInfo *>( this );
    }

    explicit operator VkPipelineShaderStageCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineShaderStageCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags const &,
               VULKAN_HPP_NAMESPACE::ShaderStageFlagBits const &,
               VULKAN_HPP_NAMESPACE::ShaderModule const &,
               const char * const &,
               const VULKAN_HPP_NAMESPACE::SpecializationInfo * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, stage, module, pName, pSpecializationInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = flags <=> rhs.flags; cmp != 0 )
        return cmp;
      if ( auto cmp = stage <=> rhs.stage; cmp != 0 )
        return cmp;
      if ( auto cmp = module <=> rhs.module; cmp != 0 )
        return cmp;
      if ( pName != rhs.pName )
        if ( auto cmp = strcmp( pName, rhs.pName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = pSpecializationInfo <=> rhs.pSpecializationInfo; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( stage == rhs.stage ) && ( module == rhs.module ) &&
             ( ( pName == rhs.pName ) || ( strcmp( pName, rhs.pName ) == 0 ) ) && ( pSpecializationInfo == rhs.pSpecializationInfo );
    }

    bool operator!=( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType               = StructureType::ePipelineShaderStageCreateInfo;
    const void *                                         pNext               = {};
    VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateFlags flags               = {};
    VULKAN_HPP_NAMESPACE::ShaderStageFlagBits            stage               = VULKAN_HPP_NAMESPACE::ShaderStageFlagBits::eVertex;
    VULKAN_HPP_NAMESPACE::ShaderModule                   module              = {};
    const char *                                         pName               = {};
    const VULKAN_HPP_NAMESPACE::SpecializationInfo *     pSpecializationInfo = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo ) == sizeof( VkPipelineShaderStageCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo>::value,
                            "PipelineShaderStageCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::ePipelineShaderStageCreateInfo>
  {
    using Type = PipelineShaderStageCreateInfo;
  };

  struct ComputePipelineCreateInfo
  {
    using NativeType = VkComputePipelineCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eComputePipelineCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ComputePipelineCreateInfo( VULKAN_HPP_NAMESPACE::PipelineCreateFlags           flags_              = {},
                                                    VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo stage_              = {},
                                                    VULKAN_HPP_NAMESPACE::PipelineLayout                layout_             = {},
                                                    VULKAN_HPP_NAMESPACE::Pipeline                      basePipelineHandle_ = {},
                                                    int32_t                                             basePipelineIndex_  = {},
                                                    const void *                                        pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , stage( stage_ )
      , layout( layout_ )
      , basePipelineHandle( basePipelineHandle_ )
      , basePipelineIndex( basePipelineIndex_ )
    {
    }

    VULKAN_HPP_CONSTEXPR ComputePipelineCreateInfo( ComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComputePipelineCreateInfo( VkComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : ComputePipelineCreateInfo( *reinterpret_cast<ComputePipelineCreateInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ComputePipelineCreateInfo & operator=( ComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComputePipelineCreateInfo & operator=( VkComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ComputePipelineCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::PipelineCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setStage( VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo const & stage_ ) VULKAN_HPP_NOEXCEPT
    {
      stage = stage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setLayout( VULKAN_HPP_NAMESPACE::PipelineLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setBasePipelineHandle( VULKAN_HPP_NAMESPACE::Pipeline basePipelineHandle_ ) VULKAN_HPP_NOEXCEPT
    {
      basePipelineHandle = basePipelineHandle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setBasePipelineIndex( int32_t basePipelineIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      basePipelineIndex = basePipelineIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkComputePipelineCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkComputePipelineCreateInfo *>( this );
    }

    explicit operator VkComputePipelineCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkComputePipelineCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineCreateFlags const &,
               VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo const &,
               VULKAN_HPP_NAMESPACE::PipelineLayout const &,
               VULKAN_HPP_NAMESPACE::Pipeline const &,
               int32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, stage, layout, basePipelineHandle, basePipelineIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ComputePipelineCreateInfo const & ) const = default;
#else
    bool operator==( ComputePipelineCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( stage == rhs.stage ) && ( layout == rhs.layout ) &&
             ( basePipelineHandle == rhs.basePipelineHandle ) && ( basePipelineIndex == rhs.basePipelineIndex );
#  endif
    }

    bool operator!=( ComputePipelineCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                 sType              = StructureType::eComputePipelineCreateInfo;
    const void *                                        pNext              = {};
    VULKAN_HPP_NAMESPACE::PipelineCreateFlags           flags              = {};
    VULKAN_HPP_NAMESPACE::PipelineShaderStageCreateInfo stage              = {};
    VULKAN_HPP_NAMESPACE::PipelineLayout                layout             = {};
    VULKAN_HPP_NAMESPACE::Pipeline                      basePipelineHandle = {};
    int32_t                                             basePipelineIndex  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ComputePipelineCreateInfo ) == sizeof( VkComputePipelineCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ComputePipelineCreateInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ComputePipelineCreateInfo>::value,
                            "ComputePipelineCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eComputePipelineCreateInfo>
  {
    using Type = ComputePipelineCreateInfo;
  };

  struct ConditionalRenderingBeginInfoEXT
  {
    using NativeType = VkConditionalRenderingBeginInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eConditionalRenderingBeginInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ConditionalRenderingBeginInfoEXT( VULKAN_HPP_NAMESPACE::Buffer                       buffer_ = {},
                                                           VULKAN_HPP_NAMESPACE::DeviceSize                   offset_ = {},
                                                           VULKAN_HPP_NAMESPACE::ConditionalRenderingFlagsEXT flags_  = {},
                                                           const void *                                       pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , buffer( buffer_ )
      , offset( offset_ )
      , flags( flags_ )
    {
    }

    VULKAN_HPP_CONSTEXPR ConditionalRenderingBeginInfoEXT( ConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConditionalRenderingBeginInfoEXT( VkConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : ConditionalRenderingBeginInfoEXT( *reinterpret_cast<ConditionalRenderingBeginInfoEXT const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ConditionalRenderingBeginInfoEXT & operator=( ConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConditionalRenderingBeginInfoEXT & operator=( VkConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ConditionalRenderingBeginInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT & setFlags( VULKAN_HPP_NAMESPACE::ConditionalRenderingFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkConditionalRenderingBeginInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkConditionalRenderingBeginInfoEXT *>( this );
    }

    explicit operator VkConditionalRenderingBeginInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkConditionalRenderingBeginInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::DeviceSize const &,
               VULKAN_HPP_NAMESPACE::ConditionalRenderingFlagsEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer, offset, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ConditionalRenderingBeginInfoEXT const & ) const = default;
#else
    bool operator==( ConditionalRenderingBeginInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer ) && ( offset == rhs.offset ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( ConditionalRenderingBeginInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType  = StructureType::eConditionalRenderingBeginInfoEXT;
    const void *                                       pNext  = {};
    VULKAN_HPP_NAMESPACE::Buffer                       buffer = {};
    VULKAN_HPP_NAMESPACE::DeviceSize                   offset = {};
    VULKAN_HPP_NAMESPACE::ConditionalRenderingFlagsEXT flags  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ConditionalRenderingBeginInfoEXT ) == sizeof( VkConditionalRenderingBeginInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ConditionalRenderingBeginInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ConditionalRenderingBeginInfoEXT>::value,
                            "ConditionalRenderingBeginInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eConditionalRenderingBeginInfoEXT>
  {
    using Type = ConditionalRenderingBeginInfoEXT;
  };

  struct ConformanceVersion
  {
    using NativeType = VkConformanceVersion;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ConformanceVersion( uint8_t major_ = {}, uint8_t minor_ = {}, uint8_t subminor_ = {}, uint8_t patch_ = {} ) VULKAN_HPP_NOEXCEPT
      : major( major_ )
      , minor( minor_ )
      , subminor( subminor_ )
      , patch( patch_ )
    {
    }

    VULKAN_HPP_CONSTEXPR ConformanceVersion( ConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConformanceVersion( VkConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT : ConformanceVersion( *reinterpret_cast<ConformanceVersion const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ConformanceVersion & operator=( ConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConformanceVersion & operator=( VkConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ConformanceVersion const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setMajor( uint8_t major_ ) VULKAN_HPP_NOEXCEPT
    {
      major = major_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setMinor( uint8_t minor_ ) VULKAN_HPP_NOEXCEPT
    {
      minor = minor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setSubminor( uint8_t subminor_ ) VULKAN_HPP_NOEXCEPT
    {
      subminor = subminor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setPatch( uint8_t patch_ ) VULKAN_HPP_NOEXCEPT
    {
      patch = patch_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkConformanceVersion const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkConformanceVersion *>( this );
    }

    explicit operator VkConformanceVersion &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkConformanceVersion *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint8_t const &, uint8_t const &, uint8_t const &, uint8_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( major, minor, subminor, patch );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ConformanceVersion const & ) const = default;
#else
    bool operator==( ConformanceVersion const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( major == rhs.major ) && ( minor == rhs.minor ) && ( subminor == rhs.subminor ) && ( patch == rhs.patch );
#  endif
    }

    bool operator!=( ConformanceVersion const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint8_t major    = {};
    uint8_t minor    = {};
    uint8_t subminor = {};
    uint8_t patch    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ConformanceVersion ) == sizeof( VkConformanceVersion ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ConformanceVersion>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ConformanceVersion>::value,
                            "ConformanceVersion is not nothrow_move_constructible!" );
  using ConformanceVersionKHR = ConformanceVersion;

  struct CooperativeMatrixPropertiesNV
  {
    using NativeType = VkCooperativeMatrixPropertiesNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCooperativeMatrixPropertiesNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CooperativeMatrixPropertiesNV( uint32_t                              MSize_ = {},
                                                        uint32_t                              NSize_ = {},
                                                        uint32_t                              KSize_ = {},
                                                        VULKAN_HPP_NAMESPACE::ComponentTypeNV AType_ = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16,
                                                        VULKAN_HPP_NAMESPACE::ComponentTypeNV BType_ = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16,
                                                        VULKAN_HPP_NAMESPACE::ComponentTypeNV CType_ = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16,
                                                        VULKAN_HPP_NAMESPACE::ComponentTypeNV DType_ = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16,
                                                        VULKAN_HPP_NAMESPACE::ScopeNV         scope_ = VULKAN_HPP_NAMESPACE::ScopeNV::eDevice,
                                                        void *                                pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , MSize( MSize_ )
      , NSize( NSize_ )
      , KSize( KSize_ )
      , AType( AType_ )
      , BType( BType_ )
      , CType( CType_ )
      , DType( DType_ )
      , scope( scope_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CooperativeMatrixPropertiesNV( CooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CooperativeMatrixPropertiesNV( VkCooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CooperativeMatrixPropertiesNV( *reinterpret_cast<CooperativeMatrixPropertiesNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CooperativeMatrixPropertiesNV & operator=( CooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CooperativeMatrixPropertiesNV & operator=( VkCooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CooperativeMatrixPropertiesNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV & setMSize( uint32_t MSize_ ) VULKAN_HPP_NOEXCEPT
    {
      MSize = MSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV & setNSize( uint32_t NSize_ ) VULKAN_HPP_NOEXCEPT
    {
      NSize = NSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV & setKSize( uint32_t KSize_ ) VULKAN_HPP_NOEXCEPT
    {
      KSize = KSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV & setAType( VULKAN_HPP_NAMESPACE::ComponentTypeNV AType_ ) VULKAN_HPP_NOEXCEPT
    {
      AType = AType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV & setBType( VULKAN_HPP_NAMESPACE::ComponentTypeNV BType_ ) VULKAN_HPP_NOEXCEPT
    {
      BType = BType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV & setCType( VULKAN_HPP_NAMESPACE::ComponentTypeNV CType_ ) VULKAN_HPP_NOEXCEPT
    {
      CType = CType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV & setDType( VULKAN_HPP_NAMESPACE::ComponentTypeNV DType_ ) VULKAN_HPP_NOEXCEPT
    {
      DType = DType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeMatrixPropertiesNV & setScope( VULKAN_HPP_NAMESPACE::ScopeNV scope_ ) VULKAN_HPP_NOEXCEPT
    {
      scope = scope_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCooperativeMatrixPropertiesNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCooperativeMatrixPropertiesNV *>( this );
    }

    explicit operator VkCooperativeMatrixPropertiesNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCooperativeMatrixPropertiesNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               void * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeNV const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeNV const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeNV const &,
               VULKAN_HPP_NAMESPACE::ComponentTypeNV const &,
               VULKAN_HPP_NAMESPACE::ScopeNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, MSize, NSize, KSize, AType, BType, CType, DType, scope );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CooperativeMatrixPropertiesNV const & ) const = default;
#else
    bool operator==( CooperativeMatrixPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( MSize == rhs.MSize ) && ( NSize == rhs.NSize ) && ( KSize == rhs.KSize ) &&
             ( AType == rhs.AType ) && ( BType == rhs.BType ) && ( CType == rhs.CType ) && ( DType == rhs.DType ) && ( scope == rhs.scope );
#  endif
    }

    bool operator!=( CooperativeMatrixPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType   sType = StructureType::eCooperativeMatrixPropertiesNV;
    void *                                pNext = {};
    uint32_t                              MSize = {};
    uint32_t                              NSize = {};
    uint32_t                              KSize = {};
    VULKAN_HPP_NAMESPACE::ComponentTypeNV AType = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeNV BType = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeNV CType = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16;
    VULKAN_HPP_NAMESPACE::ComponentTypeNV DType = VULKAN_HPP_NAMESPACE::ComponentTypeNV::eFloat16;
    VULKAN_HPP_NAMESPACE::ScopeNV         scope = VULKAN_HPP_NAMESPACE::ScopeNV::eDevice;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CooperativeMatrixPropertiesNV ) == sizeof( VkCooperativeMatrixPropertiesNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CooperativeMatrixPropertiesNV>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CooperativeMatrixPropertiesNV>::value,
                            "CooperativeMatrixPropertiesNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCooperativeMatrixPropertiesNV>
  {
    using Type = CooperativeMatrixPropertiesNV;
  };

  struct CopyAccelerationStructureInfoKHR
  {
    using NativeType = VkCopyAccelerationStructureInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyAccelerationStructureInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyAccelerationStructureInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         src_   = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         dst_   = {},
      VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_  = VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone,
      const void *                                           pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , src( src_ )
      , dst( dst_ )
      , mode( mode_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CopyAccelerationStructureInfoKHR( CopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyAccelerationStructureInfoKHR( VkCopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyAccelerationStructureInfoKHR( *reinterpret_cast<CopyAccelerationStructureInfoKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyAccelerationStructureInfoKHR & operator=( CopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyAccelerationStructureInfoKHR & operator=( VkCopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR & setSrc( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR & setDst( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR & setMode( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCopyAccelerationStructureInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyAccelerationStructureInfoKHR *>( this );
    }

    explicit operator VkCopyAccelerationStructureInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyAccelerationStructureInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &,
               VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyAccelerationStructureInfoKHR const & ) const = default;
#else
    bool operator==( CopyAccelerationStructureInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( src == rhs.src ) && ( dst == rhs.dst ) && ( mode == rhs.mode );
#  endif
    }

    bool operator!=( CopyAccelerationStructureInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                    sType = StructureType::eCopyAccelerationStructureInfoKHR;
    const void *                                           pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         src   = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         dst   = {};
    VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode  = VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureInfoKHR ) == sizeof( VkCopyAccelerationStructureInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureInfoKHR>::value,
                            "CopyAccelerationStructureInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyAccelerationStructureInfoKHR>
  {
    using Type = CopyAccelerationStructureInfoKHR;
  };

  struct CopyAccelerationStructureToMemoryInfoKHR
  {
    using NativeType = VkCopyAccelerationStructureToMemoryInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyAccelerationStructureToMemoryInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR(
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         src_   = {},
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR           dst_   = {},
      VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_  = VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone,
      const void *                                           pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , src( src_ )
      , dst( dst_ )
      , mode( mode_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR( CopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyAccelerationStructureToMemoryInfoKHR( VkCopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyAccelerationStructureToMemoryInfoKHR( *reinterpret_cast<CopyAccelerationStructureToMemoryInfoKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyAccelerationStructureToMemoryInfoKHR & operator=( CopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyAccelerationStructureToMemoryInfoKHR & operator=( VkCopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureToMemoryInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR & setSrc( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR & setDst( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const & dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR &
                            setMode( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCopyAccelerationStructureToMemoryInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyAccelerationStructureToMemoryInfoKHR *>( this );
    }

    explicit operator VkCopyAccelerationStructureToMemoryInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyAccelerationStructureToMemoryInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR const &,
               VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                    sType = StructureType::eCopyAccelerationStructureToMemoryInfoKHR;
    const void *                                           pNext = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         src   = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressKHR           dst   = {};
    VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode  = VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureToMemoryInfoKHR ) == sizeof( VkCopyAccelerationStructureToMemoryInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureToMemoryInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyAccelerationStructureToMemoryInfoKHR>::value,
                            "CopyAccelerationStructureToMemoryInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyAccelerationStructureToMemoryInfoKHR>
  {
    using Type = CopyAccelerationStructureToMemoryInfoKHR;
  };

  struct CopyBufferInfo2
  {
    using NativeType = VkCopyBufferInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyBufferInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyBufferInfo2( VULKAN_HPP_NAMESPACE::Buffer              srcBuffer_   = {},
                                          VULKAN_HPP_NAMESPACE::Buffer              dstBuffer_   = {},
                                          uint32_t                                  regionCount_ = {},
                                          const VULKAN_HPP_NAMESPACE::BufferCopy2 * pRegions_    = {},
                                          const void *                              pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , srcBuffer( srcBuffer_ )
      , dstBuffer( dstBuffer_ )
      , regionCount( regionCount_ )
      , pRegions( pRegions_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CopyBufferInfo2( CopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferInfo2( VkCopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT : CopyBufferInfo2( *reinterpret_cast<CopyBufferInfo2 const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferInfo2( VULKAN_HPP_NAMESPACE::Buffer                                                                   srcBuffer_,
                     VULKAN_HPP_NAMESPACE::Buffer                                                                   dstBuffer_,
                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferCopy2> const & regions_,
                     const void *                                                                                   pNext_ = nullptr )
      : pNext( pNext_ ), srcBuffer( srcBuffer_ ), dstBuffer( dstBuffer_ ), regionCount( static_cast<uint32_t>( regions_.size() ) ), pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyBufferInfo2 & operator=( CopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferInfo2 & operator=( VkCopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyBufferInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setSrcBuffer( VULKAN_HPP_NAMESPACE::Buffer srcBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBuffer = srcBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setDstBuffer( VULKAN_HPP_NAMESPACE::Buffer dstBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBuffer = dstBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::BufferCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferInfo2 & setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCopyBufferInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyBufferInfo2 *>( this );
    }

    explicit operator VkCopyBufferInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyBufferInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::BufferCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcBuffer, dstBuffer, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyBufferInfo2 const & ) const = default;
#else
    bool operator==( CopyBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcBuffer == rhs.srcBuffer ) && ( dstBuffer == rhs.dstBuffer ) &&
             ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType       = StructureType::eCopyBufferInfo2;
    const void *                              pNext       = {};
    VULKAN_HPP_NAMESPACE::Buffer              srcBuffer   = {};
    VULKAN_HPP_NAMESPACE::Buffer              dstBuffer   = {};
    uint32_t                                  regionCount = {};
    const VULKAN_HPP_NAMESPACE::BufferCopy2 * pRegions    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyBufferInfo2 ) == sizeof( VkCopyBufferInfo2 ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyBufferInfo2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyBufferInfo2>::value,
                            "CopyBufferInfo2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyBufferInfo2>
  {
    using Type = CopyBufferInfo2;
  };
  using CopyBufferInfo2KHR = CopyBufferInfo2;

  struct CopyBufferToImageInfo2
  {
    using NativeType = VkCopyBufferToImageInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyBufferToImageInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyBufferToImageInfo2( VULKAN_HPP_NAMESPACE::Buffer                   srcBuffer_      = {},
                                                 VULKAN_HPP_NAMESPACE::Image                    dstImage_       = {},
                                                 VULKAN_HPP_NAMESPACE::ImageLayout              dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                 uint32_t                                       regionCount_    = {},
                                                 const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions_       = {},
                                                 const void *                                   pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , srcBuffer( srcBuffer_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( regionCount_ )
      , pRegions( pRegions_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CopyBufferToImageInfo2( CopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferToImageInfo2( VkCopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyBufferToImageInfo2( *reinterpret_cast<CopyBufferToImageInfo2 const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferToImageInfo2( VULKAN_HPP_NAMESPACE::Buffer                                                                        srcBuffer_,
                            VULKAN_HPP_NAMESPACE::Image                                                                         dstImage_,
                            VULKAN_HPP_NAMESPACE::ImageLayout                                                                   dstImageLayout_,
                            VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2> const & regions_,
                            const void *                                                                                        pNext_ = nullptr )
      : pNext( pNext_ )
      , srcBuffer( srcBuffer_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyBufferToImageInfo2 & operator=( CopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferToImageInfo2 & operator=( VkCopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyBufferToImageInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setSrcBuffer( VULKAN_HPP_NAMESPACE::Buffer srcBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBuffer = srcBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferToImageInfo2 &
      setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCopyBufferToImageInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyBufferToImageInfo2 *>( this );
    }

    explicit operator VkCopyBufferToImageInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyBufferToImageInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyBufferToImageInfo2 const & ) const = default;
#else
    bool operator==( CopyBufferToImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcBuffer == rhs.srcBuffer ) && ( dstImage == rhs.dstImage ) &&
             ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyBufferToImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType          = StructureType::eCopyBufferToImageInfo2;
    const void *                                   pNext          = {};
    VULKAN_HPP_NAMESPACE::Buffer                   srcBuffer      = {};
    VULKAN_HPP_NAMESPACE::Image                    dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout              dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                       regionCount    = {};
    const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyBufferToImageInfo2 ) == sizeof( VkCopyBufferToImageInfo2 ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyBufferToImageInfo2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyBufferToImageInfo2>::value,
                            "CopyBufferToImageInfo2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyBufferToImageInfo2>
  {
    using Type = CopyBufferToImageInfo2;
  };
  using CopyBufferToImageInfo2KHR = CopyBufferToImageInfo2;

  struct CopyCommandTransformInfoQCOM
  {
    using NativeType = VkCopyCommandTransformInfoQCOM;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyCommandTransformInfoQCOM;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CopyCommandTransformInfoQCOM( VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform_ = VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity,
                                    const void *                                      pNext_     = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , transform( transform_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CopyCommandTransformInfoQCOM( CopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyCommandTransformInfoQCOM( VkCopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyCommandTransformInfoQCOM( *reinterpret_cast<CopyCommandTransformInfoQCOM const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyCommandTransformInfoQCOM & operator=( CopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyCommandTransformInfoQCOM & operator=( VkCopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyCommandTransformInfoQCOM const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyCommandTransformInfoQCOM & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyCommandTransformInfoQCOM & setTransform( VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform_ ) VULKAN_HPP_NOEXCEPT
    {
      transform = transform_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCopyCommandTransformInfoQCOM const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyCommandTransformInfoQCOM *>( this );
    }

    explicit operator VkCopyCommandTransformInfoQCOM &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyCommandTransformInfoQCOM *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, transform );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyCommandTransformInfoQCOM const & ) const = default;
#else
    bool operator==( CopyCommandTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( transform == rhs.transform );
#  endif
    }

    bool operator!=( CopyCommandTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType     = StructureType::eCopyCommandTransformInfoQCOM;
    const void *                                      pNext     = {};
    VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR transform = VULKAN_HPP_NAMESPACE::SurfaceTransformFlagBitsKHR::eIdentity;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyCommandTransformInfoQCOM ) == sizeof( VkCopyCommandTransformInfoQCOM ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyCommandTransformInfoQCOM>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyCommandTransformInfoQCOM>::value,
                            "CopyCommandTransformInfoQCOM is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyCommandTransformInfoQCOM>
  {
    using Type = CopyCommandTransformInfoQCOM;
  };

  struct CopyDescriptorSet
  {
    using NativeType = VkCopyDescriptorSet;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyDescriptorSet;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyDescriptorSet( VULKAN_HPP_NAMESPACE::DescriptorSet srcSet_          = {},
                                            uint32_t                            srcBinding_      = {},
                                            uint32_t                            srcArrayElement_ = {},
                                            VULKAN_HPP_NAMESPACE::DescriptorSet dstSet_          = {},
                                            uint32_t                            dstBinding_      = {},
                                            uint32_t                            dstArrayElement_ = {},
                                            uint32_t                            descriptorCount_ = {},
                                            const void *                        pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , srcSet( srcSet_ )
      , srcBinding( srcBinding_ )
      , srcArrayElement( srcArrayElement_ )
      , dstSet( dstSet_ )
      , dstBinding( dstBinding_ )
      , dstArrayElement( dstArrayElement_ )
      , descriptorCount( descriptorCount_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CopyDescriptorSet( CopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyDescriptorSet( VkCopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT : CopyDescriptorSet( *reinterpret_cast<CopyDescriptorSet const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyDescriptorSet & operator=( CopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyDescriptorSet & operator=( VkCopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyDescriptorSet const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcSet( VULKAN_HPP_NAMESPACE::DescriptorSet srcSet_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSet = srcSet_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcBinding( uint32_t srcBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBinding = srcBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcArrayElement( uint32_t srcArrayElement_ ) VULKAN_HPP_NOEXCEPT
    {
      srcArrayElement = srcArrayElement_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstSet( VULKAN_HPP_NAMESPACE::DescriptorSet dstSet_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSet = dstSet_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstBinding( uint32_t dstBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBinding = dstBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstArrayElement( uint32_t dstArrayElement_ ) VULKAN_HPP_NOEXCEPT
    {
      dstArrayElement = dstArrayElement_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDescriptorCount( uint32_t descriptorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount = descriptorCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCopyDescriptorSet const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyDescriptorSet *>( this );
    }

    explicit operator VkCopyDescriptorSet &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyDescriptorSet *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DescriptorSet const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::DescriptorSet const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcSet, srcBinding, srcArrayElement, dstSet, dstBinding, dstArrayElement, descriptorCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyDescriptorSet const & ) const = default;
#else
    bool operator==( CopyDescriptorSet const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSet == rhs.srcSet ) && ( srcBinding == rhs.srcBinding ) &&
             ( srcArrayElement == rhs.srcArrayElement ) && ( dstSet == rhs.dstSet ) && ( dstBinding == rhs.dstBinding ) &&
             ( dstArrayElement == rhs.dstArrayElement ) && ( descriptorCount == rhs.descriptorCount );
#  endif
    }

    bool operator!=( CopyDescriptorSet const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType           = StructureType::eCopyDescriptorSet;
    const void *                        pNext           = {};
    VULKAN_HPP_NAMESPACE::DescriptorSet srcSet          = {};
    uint32_t                            srcBinding      = {};
    uint32_t                            srcArrayElement = {};
    VULKAN_HPP_NAMESPACE::DescriptorSet dstSet          = {};
    uint32_t                            dstBinding      = {};
    uint32_t                            dstArrayElement = {};
    uint32_t                            descriptorCount = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyDescriptorSet ) == sizeof( VkCopyDescriptorSet ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyDescriptorSet>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyDescriptorSet>::value,
                            "CopyDescriptorSet is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyDescriptorSet>
  {
    using Type = CopyDescriptorSet;
  };

  struct ImageCopy2
  {
    using NativeType = VkImageCopy2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageCopy2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageCopy2( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers srcSubresource_ = {},
                                     VULKAN_HPP_NAMESPACE::Offset3D               srcOffset_      = {},
                                     VULKAN_HPP_NAMESPACE::ImageSubresourceLayers dstSubresource_ = {},
                                     VULKAN_HPP_NAMESPACE::Offset3D               dstOffset_      = {},
                                     VULKAN_HPP_NAMESPACE::Extent3D               extent_         = {},
                                     const void *                                 pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , srcSubresource( srcSubresource_ )
      , srcOffset( srcOffset_ )
      , dstSubresource( dstSubresource_ )
      , dstOffset( dstOffset_ )
      , extent( extent_ )
    {
    }

    VULKAN_HPP_CONSTEXPR ImageCopy2( ImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageCopy2( VkImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT : ImageCopy2( *reinterpret_cast<ImageCopy2 const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageCopy2 & operator=( ImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageCopy2 & operator=( VkImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageCopy2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setSrcSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & srcSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSubresource = srcSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setSrcOffset( VULKAN_HPP_NAMESPACE::Offset3D const & srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setDstSubresource( VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const & dstSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSubresource = dstSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setDstOffset( VULKAN_HPP_NAMESPACE::Offset3D const & dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setExtent( VULKAN_HPP_NAMESPACE::Extent3D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkImageCopy2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageCopy2 *>( this );
    }

    explicit operator VkImageCopy2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageCopy2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceLayers const &,
               VULKAN_HPP_NAMESPACE::Offset3D const &,
               VULKAN_HPP_NAMESPACE::Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcSubresource, srcOffset, dstSubresource, dstOffset, extent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageCopy2 const & ) const = default;
#else
    bool operator==( ImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSubresource == rhs.srcSubresource ) && ( srcOffset == rhs.srcOffset ) &&
             ( dstSubresource == rhs.dstSubresource ) && ( dstOffset == rhs.dstOffset ) && ( extent == rhs.extent );
#  endif
    }

    bool operator!=( ImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType          = StructureType::eImageCopy2;
    const void *                                 pNext          = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers srcSubresource = {};
    VULKAN_HPP_NAMESPACE::Offset3D               srcOffset      = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceLayers dstSubresource = {};
    VULKAN_HPP_NAMESPACE::Offset3D               dstOffset      = {};
    VULKAN_HPP_NAMESPACE::Extent3D               extent         = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ImageCopy2 ) == sizeof( VkImageCopy2 ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ImageCopy2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ImageCopy2>::value, "ImageCopy2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eImageCopy2>
  {
    using Type = ImageCopy2;
  };
  using ImageCopy2KHR = ImageCopy2;

  struct CopyImageInfo2
  {
    using NativeType = VkCopyImageInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageInfo2( VULKAN_HPP_NAMESPACE::Image              srcImage_       = {},
                                         VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                         VULKAN_HPP_NAMESPACE::Image              dstImage_       = {},
                                         VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                         uint32_t                                 regionCount_    = {},
                                         const VULKAN_HPP_NAMESPACE::ImageCopy2 * pRegions_       = {},
                                         const void *                             pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( regionCount_ )
      , pRegions( pRegions_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CopyImageInfo2( CopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageInfo2( VkCopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT : CopyImageInfo2( *reinterpret_cast<CopyImageInfo2 const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageInfo2( VULKAN_HPP_NAMESPACE::Image                                                                   srcImage_,
                    VULKAN_HPP_NAMESPACE::ImageLayout                                                             srcImageLayout_,
                    VULKAN_HPP_NAMESPACE::Image                                                                   dstImage_,
                    VULKAN_HPP_NAMESPACE::ImageLayout                                                             dstImageLayout_,
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageCopy2> const & regions_,
                    const void *                                                                                  pNext_ = nullptr )
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyImageInfo2 & operator=( CopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageInfo2 & operator=( VkCopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyImageInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setDstImage( VULKAN_HPP_NAMESPACE::Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setDstImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::ImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageInfo2 & setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCopyImageInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageInfo2 *>( this );
    }

    explicit operator VkCopyImageInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::ImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageInfo2 const & ) const = default;
#else
    bool operator==( CopyImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) && ( srcImageLayout == rhs.srcImageLayout ) &&
             ( dstImage == rhs.dstImage ) && ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType      sType          = StructureType::eCopyImageInfo2;
    const void *                             pNext          = {};
    VULKAN_HPP_NAMESPACE::Image              srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::Image              dstImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout        dstImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                 regionCount    = {};
    const VULKAN_HPP_NAMESPACE::ImageCopy2 * pRegions       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyImageInfo2 ) == sizeof( VkCopyImageInfo2 ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyImageInfo2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyImageInfo2>::value,
                            "CopyImageInfo2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyImageInfo2>
  {
    using Type = CopyImageInfo2;
  };
  using CopyImageInfo2KHR = CopyImageInfo2;

  struct CopyImageToBufferInfo2
  {
    using NativeType = VkCopyImageToBufferInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageToBufferInfo2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageToBufferInfo2( VULKAN_HPP_NAMESPACE::Image                    srcImage_       = {},
                                                 VULKAN_HPP_NAMESPACE::ImageLayout              srcImageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                                 VULKAN_HPP_NAMESPACE::Buffer                   dstBuffer_      = {},
                                                 uint32_t                                       regionCount_    = {},
                                                 const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions_       = {},
                                                 const void *                                   pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstBuffer( dstBuffer_ )
      , regionCount( regionCount_ )
      , pRegions( pRegions_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CopyImageToBufferInfo2( CopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageToBufferInfo2( VkCopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyImageToBufferInfo2( *reinterpret_cast<CopyImageToBufferInfo2 const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToBufferInfo2( VULKAN_HPP_NAMESPACE::Image                                                                         srcImage_,
                            VULKAN_HPP_NAMESPACE::ImageLayout                                                                   srcImageLayout_,
                            VULKAN_HPP_NAMESPACE::Buffer                                                                        dstBuffer_,
                            VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2> const & regions_,
                            const void *                                                                                        pNext_ = nullptr )
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstBuffer( dstBuffer_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyImageToBufferInfo2 & operator=( CopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageToBufferInfo2 & operator=( VkCopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyImageToBufferInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setSrcImage( VULKAN_HPP_NAMESPACE::Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setSrcImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setDstBuffer( VULKAN_HPP_NAMESPACE::Buffer dstBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBuffer = dstBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setPRegions( const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToBufferInfo2 &
      setRegions( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCopyImageToBufferInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageToBufferInfo2 *>( this );
    }

    explicit operator VkCopyImageToBufferInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageToBufferInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::Buffer const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageToBufferInfo2 const & ) const = default;
#else
    bool operator==( CopyImageToBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) && ( srcImageLayout == rhs.srcImageLayout ) &&
             ( dstBuffer == rhs.dstBuffer ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyImageToBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType          = StructureType::eCopyImageToBufferInfo2;
    const void *                                   pNext          = {};
    VULKAN_HPP_NAMESPACE::Image                    srcImage       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout              srcImageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::Buffer                   dstBuffer      = {};
    uint32_t                                       regionCount    = {};
    const VULKAN_HPP_NAMESPACE::BufferImageCopy2 * pRegions       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyImageToBufferInfo2 ) == sizeof( VkCopyImageToBufferInfo2 ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyImageToBufferInfo2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyImageToBufferInfo2>::value,
                            "CopyImageToBufferInfo2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyImageToBufferInfo2>
  {
    using Type = CopyImageToBufferInfo2;
  };
  using CopyImageToBufferInfo2KHR = CopyImageToBufferInfo2;

  struct CopyMemoryToAccelerationStructureInfoKHR
  {
    using NativeType = VkCopyMemoryToAccelerationStructureInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyMemoryToAccelerationStructureInfoKHR;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR(
      VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      src_   = {},
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         dst_   = {},
      VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_  = VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone,
      const void *                                           pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , src( src_ )
      , dst( dst_ )
      , mode( mode_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR( CopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryToAccelerationStructureInfoKHR( VkCopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyMemoryToAccelerationStructureInfoKHR( *reinterpret_cast<CopyMemoryToAccelerationStructureInfoKHR const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CopyMemoryToAccelerationStructureInfoKHR & operator=( CopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryToAccelerationStructureInfoKHR & operator=( VkCopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CopyMemoryToAccelerationStructureInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR &
                            setSrc( VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const & src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR & setDst( VULKAN_HPP_NAMESPACE::AccelerationStructureKHR dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR &
                            setMode( VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCopyMemoryToAccelerationStructureInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMemoryToAccelerationStructureInfoKHR *>( this );
    }

    explicit operator VkCopyMemoryToAccelerationStructureInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMemoryToAccelerationStructureInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR const &,
               VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const &,
               VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                    sType = StructureType::eCopyMemoryToAccelerationStructureInfoKHR;
    const void *                                           pNext = {};
    VULKAN_HPP_NAMESPACE::DeviceOrHostAddressConstKHR      src   = {};
    VULKAN_HPP_NAMESPACE::AccelerationStructureKHR         dst   = {};
    VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR mode  = VULKAN_HPP_NAMESPACE::CopyAccelerationStructureModeKHR::eClone;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CopyMemoryToAccelerationStructureInfoKHR ) == sizeof( VkCopyMemoryToAccelerationStructureInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CopyMemoryToAccelerationStructureInfoKHR>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CopyMemoryToAccelerationStructureInfoKHR>::value,
                            "CopyMemoryToAccelerationStructureInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCopyMemoryToAccelerationStructureInfoKHR>
  {
    using Type = CopyMemoryToAccelerationStructureInfoKHR;
  };

  struct CuFunctionCreateInfoNVX
  {
    using NativeType = VkCuFunctionCreateInfoNVX;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCuFunctionCreateInfoNVX;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CuFunctionCreateInfoNVX( VULKAN_HPP_NAMESPACE::CuModuleNVX module_ = {}, const char * pName_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , module( module_ )
      , pName( pName_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CuFunctionCreateInfoNVX( CuFunctionCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuFunctionCreateInfoNVX( VkCuFunctionCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
      : CuFunctionCreateInfoNVX( *reinterpret_cast<CuFunctionCreateInfoNVX const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CuFunctionCreateInfoNVX & operator=( CuFunctionCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuFunctionCreateInfoNVX & operator=( VkCuFunctionCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CuFunctionCreateInfoNVX const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CuFunctionCreateInfoNVX & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuFunctionCreateInfoNVX & setModule( VULKAN_HPP_NAMESPACE::CuModuleNVX module_ ) VULKAN_HPP_NOEXCEPT
    {
      module = module_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuFunctionCreateInfoNVX & setPName( const char * pName_ ) VULKAN_HPP_NOEXCEPT
    {
      pName = pName_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCuFunctionCreateInfoNVX const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCuFunctionCreateInfoNVX *>( this );
    }

    explicit operator VkCuFunctionCreateInfoNVX &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCuFunctionCreateInfoNVX *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::CuModuleNVX const &, const char * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, module, pName );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( CuFunctionCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = module <=> rhs.module; cmp != 0 )
        return cmp;
      if ( pName != rhs.pName )
        if ( auto cmp = strcmp( pName, rhs.pName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( CuFunctionCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( module == rhs.module ) && ( ( pName == rhs.pName ) || ( strcmp( pName, rhs.pName ) == 0 ) );
    }

    bool operator!=( CuFunctionCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eCuFunctionCreateInfoNVX;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::CuModuleNVX   module = {};
    const char *                        pName  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CuFunctionCreateInfoNVX ) == sizeof( VkCuFunctionCreateInfoNVX ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CuFunctionCreateInfoNVX>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CuFunctionCreateInfoNVX>::value,
                            "CuFunctionCreateInfoNVX is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCuFunctionCreateInfoNVX>
  {
    using Type = CuFunctionCreateInfoNVX;
  };

  struct CuLaunchInfoNVX
  {
    using NativeType = VkCuLaunchInfoNVX;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCuLaunchInfoNVX;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CuLaunchInfoNVX( VULKAN_HPP_NAMESPACE::CuFunctionNVX function_       = {},
                                          uint32_t                            gridDimX_       = {},
                                          uint32_t                            gridDimY_       = {},
                                          uint32_t                            gridDimZ_       = {},
                                          uint32_t                            blockDimX_      = {},
                                          uint32_t                            blockDimY_      = {},
                                          uint32_t                            blockDimZ_      = {},
                                          uint32_t                            sharedMemBytes_ = {},
                                          size_t                              paramCount_     = {},
                                          const void * const *                pParams_        = {},
                                          size_t                              extraCount_     = {},
                                          const void * const *                pExtras_        = {},
                                          const void *                        pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , function( function_ )
      , gridDimX( gridDimX_ )
      , gridDimY( gridDimY_ )
      , gridDimZ( gridDimZ_ )
      , blockDimX( blockDimX_ )
      , blockDimY( blockDimY_ )
      , blockDimZ( blockDimZ_ )
      , sharedMemBytes( sharedMemBytes_ )
      , paramCount( paramCount_ )
      , pParams( pParams_ )
      , extraCount( extraCount_ )
      , pExtras( pExtras_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CuLaunchInfoNVX( CuLaunchInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuLaunchInfoNVX( VkCuLaunchInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT : CuLaunchInfoNVX( *reinterpret_cast<CuLaunchInfoNVX const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CuLaunchInfoNVX( VULKAN_HPP_NAMESPACE::CuFunctionNVX                                       function_,
                     uint32_t                                                                  gridDimX_,
                     uint32_t                                                                  gridDimY_,
                     uint32_t                                                                  gridDimZ_,
                     uint32_t                                                                  blockDimX_,
                     uint32_t                                                                  blockDimY_,
                     uint32_t                                                                  blockDimZ_,
                     uint32_t                                                                  sharedMemBytes_,
                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & params_,
                     VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & extras_ = {},
                     const void *                                                              pNext_  = nullptr )
      : pNext( pNext_ )
      , function( function_ )
      , gridDimX( gridDimX_ )
      , gridDimY( gridDimY_ )
      , gridDimZ( gridDimZ_ )
      , blockDimX( blockDimX_ )
      , blockDimY( blockDimY_ )
      , blockDimZ( blockDimZ_ )
      , sharedMemBytes( sharedMemBytes_ )
      , paramCount( params_.size() )
      , pParams( params_.data() )
      , extraCount( extras_.size() )
      , pExtras( extras_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CuLaunchInfoNVX & operator=( CuLaunchInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuLaunchInfoNVX & operator=( VkCuLaunchInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CuLaunchInfoNVX const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setFunction( VULKAN_HPP_NAMESPACE::CuFunctionNVX function_ ) VULKAN_HPP_NOEXCEPT
    {
      function = function_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setGridDimX( uint32_t gridDimX_ ) VULKAN_HPP_NOEXCEPT
    {
      gridDimX = gridDimX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setGridDimY( uint32_t gridDimY_ ) VULKAN_HPP_NOEXCEPT
    {
      gridDimY = gridDimY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setGridDimZ( uint32_t gridDimZ_ ) VULKAN_HPP_NOEXCEPT
    {
      gridDimZ = gridDimZ_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setBlockDimX( uint32_t blockDimX_ ) VULKAN_HPP_NOEXCEPT
    {
      blockDimX = blockDimX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setBlockDimY( uint32_t blockDimY_ ) VULKAN_HPP_NOEXCEPT
    {
      blockDimY = blockDimY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setBlockDimZ( uint32_t blockDimZ_ ) VULKAN_HPP_NOEXCEPT
    {
      blockDimZ = blockDimZ_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setSharedMemBytes( uint32_t sharedMemBytes_ ) VULKAN_HPP_NOEXCEPT
    {
      sharedMemBytes = sharedMemBytes_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setParamCount( size_t paramCount_ ) VULKAN_HPP_NOEXCEPT
    {
      paramCount = paramCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setPParams( const void * const * pParams_ ) VULKAN_HPP_NOEXCEPT
    {
      pParams = pParams_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CuLaunchInfoNVX & setParams( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & params_ ) VULKAN_HPP_NOEXCEPT
    {
      paramCount = params_.size();
      pParams    = params_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setExtraCount( size_t extraCount_ ) VULKAN_HPP_NOEXCEPT
    {
      extraCount = extraCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuLaunchInfoNVX & setPExtras( const void * const * pExtras_ ) VULKAN_HPP_NOEXCEPT
    {
      pExtras = pExtras_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CuLaunchInfoNVX & setExtras( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const void * const> const & extras_ ) VULKAN_HPP_NOEXCEPT
    {
      extraCount = extras_.size();
      pExtras    = extras_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCuLaunchInfoNVX const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCuLaunchInfoNVX *>( this );
    }

    explicit operator VkCuLaunchInfoNVX &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCuLaunchInfoNVX *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::CuFunctionNVX const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               size_t const &,
               const void * const * const &,
               size_t const &,
               const void * const * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, function, gridDimX, gridDimY, gridDimZ, blockDimX, blockDimY, blockDimZ, sharedMemBytes, paramCount, pParams, extraCount, pExtras );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CuLaunchInfoNVX const & ) const = default;
#else
    bool operator==( CuLaunchInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( function == rhs.function ) && ( gridDimX == rhs.gridDimX ) && ( gridDimY == rhs.gridDimY ) &&
             ( gridDimZ == rhs.gridDimZ ) && ( blockDimX == rhs.blockDimX ) && ( blockDimY == rhs.blockDimY ) && ( blockDimZ == rhs.blockDimZ ) &&
             ( sharedMemBytes == rhs.sharedMemBytes ) && ( paramCount == rhs.paramCount ) && ( pParams == rhs.pParams ) && ( extraCount == rhs.extraCount ) &&
             ( pExtras == rhs.pExtras );
#  endif
    }

    bool operator!=( CuLaunchInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType          = StructureType::eCuLaunchInfoNVX;
    const void *                        pNext          = {};
    VULKAN_HPP_NAMESPACE::CuFunctionNVX function       = {};
    uint32_t                            gridDimX       = {};
    uint32_t                            gridDimY       = {};
    uint32_t                            gridDimZ       = {};
    uint32_t                            blockDimX      = {};
    uint32_t                            blockDimY      = {};
    uint32_t                            blockDimZ      = {};
    uint32_t                            sharedMemBytes = {};
    size_t                              paramCount     = {};
    const void * const *                pParams        = {};
    size_t                              extraCount     = {};
    const void * const *                pExtras        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CuLaunchInfoNVX ) == sizeof( VkCuLaunchInfoNVX ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CuLaunchInfoNVX>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CuLaunchInfoNVX>::value,
                            "CuLaunchInfoNVX is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCuLaunchInfoNVX>
  {
    using Type = CuLaunchInfoNVX;
  };

  struct CuModuleCreateInfoNVX
  {
    using NativeType = VkCuModuleCreateInfoNVX;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCuModuleCreateInfoNVX;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CuModuleCreateInfoNVX( size_t dataSize_ = {}, const void * pData_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , dataSize( dataSize_ )
      , pData( pData_ )
    {
    }

    VULKAN_HPP_CONSTEXPR CuModuleCreateInfoNVX( CuModuleCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuModuleCreateInfoNVX( VkCuModuleCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
      : CuModuleCreateInfoNVX( *reinterpret_cast<CuModuleCreateInfoNVX const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    CuModuleCreateInfoNVX( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & data_, const void * pNext_ = nullptr )
      : pNext( pNext_ ), dataSize( data_.size() * sizeof( T ) ), pData( data_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    CuModuleCreateInfoNVX & operator=( CuModuleCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CuModuleCreateInfoNVX & operator=( VkCuModuleCreateInfoNVX const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::CuModuleCreateInfoNVX const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CuModuleCreateInfoNVX & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuModuleCreateInfoNVX & setDataSize( size_t dataSize_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = dataSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CuModuleCreateInfoNVX & setPData( const void * pData_ ) VULKAN_HPP_NOEXCEPT
    {
      pData = pData_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    CuModuleCreateInfoNVX & setData( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = data_.size() * sizeof( T );
      pData    = data_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkCuModuleCreateInfoNVX const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCuModuleCreateInfoNVX *>( this );
    }

    explicit operator VkCuModuleCreateInfoNVX &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCuModuleCreateInfoNVX *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, size_t const &, const void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, dataSize, pData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CuModuleCreateInfoNVX const & ) const = default;
#else
    bool operator==( CuModuleCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( dataSize == rhs.dataSize ) && ( pData == rhs.pData );
#  endif
    }

    bool operator!=( CuModuleCreateInfoNVX const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType    = StructureType::eCuModuleCreateInfoNVX;
    const void *                        pNext    = {};
    size_t                              dataSize = {};
    const void *                        pData    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::CuModuleCreateInfoNVX ) == sizeof( VkCuModuleCreateInfoNVX ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::CuModuleCreateInfoNVX>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::CuModuleCreateInfoNVX>::value,
                            "CuModuleCreateInfoNVX is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eCuModuleCreateInfoNVX>
  {
    using Type = CuModuleCreateInfoNVX;
  };

#if defined( VK_USE_PLATFORM_WIN32_KHR )
  struct D3D12FenceSubmitInfoKHR
  {
    using NativeType = VkD3D12FenceSubmitInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eD3D12FenceSubmitInfoKHR;

#  if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR D3D12FenceSubmitInfoKHR( uint32_t         waitSemaphoreValuesCount_   = {},
                                                  const uint64_t * pWaitSemaphoreValues_       = {},
                                                  uint32_t         signalSemaphoreValuesCount_ = {},
                                                  const uint64_t * pSignalSemaphoreValues_     = {},
                                                  const void *     pNext_                      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , waitSemaphoreValuesCount( waitSemaphoreValuesCount_ )
      , pWaitSemaphoreValues( pWaitSemaphoreValues_ )
      , signalSemaphoreValuesCount( signalSemaphoreValuesCount_ )
      , pSignalSemaphoreValues( pSignalSemaphoreValues_ )
    {
    }

    VULKAN_HPP_CONSTEXPR D3D12FenceSubmitInfoKHR( D3D12FenceSubmitInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    D3D12FenceSubmitInfoKHR( VkD3D12FenceSubmitInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : D3D12FenceSubmitInfoKHR( *reinterpret_cast<D3D12FenceSubmitInfoKHR const *>( &rhs ) )
    {
    }

#    if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    D3D12FenceSubmitInfoKHR( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint64_t> const & waitSemaphoreValues_,
                             VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint64_t> const & signalSemaphoreValues_ = {},
                             const void *                                                          pNext_                 = nullptr )
      : pNext( pNext_ )
      , waitSemaphoreValuesCount( static_cast<uint32_t>( waitSemaphoreValues_.size() ) )
      , pWaitSemaphoreValues( waitSemaphoreValues_.data() )
      , signalSemaphoreValuesCount( static_cast<uint32_t>( signalSemaphoreValues_.size() ) )
      , pSignalSemaphoreValues( signalSemaphoreValues_.data() )
    {
    }
#    endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#  endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    D3D12FenceSubmitInfoKHR & operator=( D3D12FenceSubmitInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    D3D12FenceSubmitInfoKHR & operator=( VkD3D12FenceSubmitInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::D3D12FenceSubmitInfoKHR const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 D3D12FenceSubmitInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 D3D12FenceSubmitInfoKHR & setWaitSemaphoreValuesCount( uint32_t waitSemaphoreValuesCount_ ) VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreValuesCount = waitSemaphoreValuesCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 D3D12FenceSubmitInfoKHR & setPWaitSemaphoreValues( const uint64_t * pWaitSemaphoreValues_ ) VULKAN_HPP_NOEXCEPT
    {
      pWaitSemaphoreValues = pWaitSemaphoreValues_;
      return *this;
    }

#    if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    D3D12FenceSubmitInfoKHR &
      setWaitSemaphoreValues( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint64_t> const & waitSemaphoreValues_ ) VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreValuesCount = static_cast<uint32_t>( waitSemaphoreValues_.size() );
      pWaitSemaphoreValues     = waitSemaphoreValues_.data();
      return *this;
    }
#    endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 D3D12FenceSubmitInfoKHR & setSignalSemaphoreValuesCount( uint32_t signalSemaphoreValuesCount_ ) VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreValuesCount = signalSemaphoreValuesCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 D3D12FenceSubmitInfoKHR & setPSignalSemaphoreValues( const uint64_t * pSignalSemaphoreValues_ ) VULKAN_HPP_NOEXCEPT
    {
      pSignalSemaphoreValues = pSignalSemaphoreValues_;
      return *this;
    }

#    if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    D3D12FenceSubmitInfoKHR &
      setSignalSemaphoreValues( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint64_t> const & signalSemaphoreValues_ ) VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreValuesCount = static_cast<uint32_t>( signalSemaphoreValues_.size() );
      pSignalSemaphoreValues     = signalSemaphoreValues_.data();
      return *this;
    }
#    endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#  endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkD3D12FenceSubmitInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkD3D12FenceSubmitInfoKHR *>( this );
    }

    explicit operator VkD3D12FenceSubmitInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkD3D12FenceSubmitInfoKHR *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               uint32_t const &,
               const uint64_t * const &,
               uint32_t const &,
               const uint64_t * const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, waitSemaphoreValuesCount, pWaitSemaphoreValues, signalSemaphoreValuesCount, pSignalSemaphoreValues );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( D3D12FenceSubmitInfoKHR const & ) const = default;
#  else
    bool operator==( D3D12FenceSubmitInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( waitSemaphoreValuesCount == rhs.waitSemaphoreValuesCount ) &&
             ( pWaitSemaphoreValues == rhs.pWaitSemaphoreValues ) && ( signalSemaphoreValuesCount == rhs.signalSemaphoreValuesCount ) &&
             ( pSignalSemaphoreValues == rhs.pSignalSemaphoreValues );
#    endif
    }

    bool operator!=( D3D12FenceSubmitInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                      = StructureType::eD3D12FenceSubmitInfoKHR;
    const void *                        pNext                      = {};
    uint32_t                            waitSemaphoreValuesCount   = {};
    const uint64_t *                    pWaitSemaphoreValues       = {};
    uint32_t                            signalSemaphoreValuesCount = {};
    const uint64_t *                    pSignalSemaphoreValues     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::D3D12FenceSubmitInfoKHR ) == sizeof( VkD3D12FenceSubmitInfoKHR ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::D3D12FenceSubmitInfoKHR>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::D3D12FenceSubmitInfoKHR>::value,
                            "D3D12FenceSubmitInfoKHR is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eD3D12FenceSubmitInfoKHR>
  {
    using Type = D3D12FenceSubmitInfoKHR;
  };
#endif /*VK_USE_PLATFORM_WIN32_KHR*/

  struct DebugMarkerMarkerInfoEXT
  {
    using NativeType = VkDebugMarkerMarkerInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugMarkerMarkerInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      DebugMarkerMarkerInfoEXT( const char * pMarkerName_ = {}, std::array<float, 4> const & color_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , pMarkerName( pMarkerName_ )
      , color( color_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerMarkerInfoEXT( DebugMarkerMarkerInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugMarkerMarkerInfoEXT( VkDebugMarkerMarkerInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugMarkerMarkerInfoEXT( *reinterpret_cast<DebugMarkerMarkerInfoEXT const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugMarkerMarkerInfoEXT & operator=( DebugMarkerMarkerInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugMarkerMarkerInfoEXT & operator=( VkDebugMarkerMarkerInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugMarkerMarkerInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugMarkerMarkerInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerMarkerInfoEXT & setPMarkerName( const char * pMarkerName_ ) VULKAN_HPP_NOEXCEPT
    {
      pMarkerName = pMarkerName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerMarkerInfoEXT & setColor( std::array<float, 4> color_ ) VULKAN_HPP_NOEXCEPT
    {
      color = color_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDebugMarkerMarkerInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugMarkerMarkerInfoEXT *>( this );
    }

    explicit operator VkDebugMarkerMarkerInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugMarkerMarkerInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, const char * const &, VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4> const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pMarkerName, color );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::partial_ordering operator<=>( DebugMarkerMarkerInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( pMarkerName != rhs.pMarkerName )
        if ( auto cmp = strcmp( pMarkerName, rhs.pMarkerName ); cmp != 0 )
          return ( cmp < 0 ) ? std::partial_ordering::less : std::partial_ordering::greater;
      if ( auto cmp = color <=> rhs.color; cmp != 0 )
        return cmp;

      return std::partial_ordering::equivalent;
    }
#endif

    bool operator==( DebugMarkerMarkerInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( ( pMarkerName == rhs.pMarkerName ) || ( strcmp( pMarkerName, rhs.pMarkerName ) == 0 ) ) &&
             ( color == rhs.color );
    }

    bool operator!=( DebugMarkerMarkerInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType       = StructureType::eDebugMarkerMarkerInfoEXT;
    const void *                                   pNext       = {};
    const char *                                   pMarkerName = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4> color       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugMarkerMarkerInfoEXT ) == sizeof( VkDebugMarkerMarkerInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugMarkerMarkerInfoEXT>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugMarkerMarkerInfoEXT>::value,
                            "DebugMarkerMarkerInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugMarkerMarkerInfoEXT>
  {
    using Type = DebugMarkerMarkerInfoEXT;
  };

  struct DebugMarkerObjectNameInfoEXT
  {
    using NativeType = VkDebugMarkerObjectNameInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugMarkerObjectNameInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DebugMarkerObjectNameInfoEXT( VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT objectType_  = VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT::eUnknown,
                                    uint64_t                                       object_      = {},
                                    const char *                                   pObjectName_ = {},
                                    const void *                                   pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , objectType( objectType_ )
      , object( object_ )
      , pObjectName( pObjectName_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DebugMarkerObjectNameInfoEXT( DebugMarkerObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugMarkerObjectNameInfoEXT( VkDebugMarkerObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugMarkerObjectNameInfoEXT( *reinterpret_cast<DebugMarkerObjectNameInfoEXT const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugMarkerObjectNameInfoEXT & operator=( DebugMarkerObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugMarkerObjectNameInfoEXT & operator=( VkDebugMarkerObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugMarkerObjectNameInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectNameInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectNameInfoEXT & setObjectType( VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT objectType_ ) VULKAN_HPP_NOEXCEPT
    {
      objectType = objectType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectNameInfoEXT & setObject( uint64_t object_ ) VULKAN_HPP_NOEXCEPT
    {
      object = object_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectNameInfoEXT & setPObjectName( const char * pObjectName_ ) VULKAN_HPP_NOEXCEPT
    {
      pObjectName = pObjectName_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDebugMarkerObjectNameInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugMarkerObjectNameInfoEXT *>( this );
    }

    explicit operator VkDebugMarkerObjectNameInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugMarkerObjectNameInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT const &,
               uint64_t const &,
               const char * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, objectType, object, pObjectName );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( DebugMarkerObjectNameInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = objectType <=> rhs.objectType; cmp != 0 )
        return cmp;
      if ( auto cmp = object <=> rhs.object; cmp != 0 )
        return cmp;
      if ( pObjectName != rhs.pObjectName )
        if ( auto cmp = strcmp( pObjectName, rhs.pObjectName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( DebugMarkerObjectNameInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( objectType == rhs.objectType ) && ( object == rhs.object ) &&
             ( ( pObjectName == rhs.pObjectName ) || ( strcmp( pObjectName, rhs.pObjectName ) == 0 ) );
    }

    bool operator!=( DebugMarkerObjectNameInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType       = StructureType::eDebugMarkerObjectNameInfoEXT;
    const void *                                   pNext       = {};
    VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT objectType  = VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT::eUnknown;
    uint64_t                                       object      = {};
    const char *                                   pObjectName = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugMarkerObjectNameInfoEXT ) == sizeof( VkDebugMarkerObjectNameInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugMarkerObjectNameInfoEXT>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugMarkerObjectNameInfoEXT>::value,
                            "DebugMarkerObjectNameInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugMarkerObjectNameInfoEXT>
  {
    using Type = DebugMarkerObjectNameInfoEXT;
  };

  struct DebugMarkerObjectTagInfoEXT
  {
    using NativeType = VkDebugMarkerObjectTagInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugMarkerObjectTagInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DebugMarkerObjectTagInfoEXT( VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT objectType_ = VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT::eUnknown,
                                   uint64_t                                       object_     = {},
                                   uint64_t                                       tagName_    = {},
                                   size_t                                         tagSize_    = {},
                                   const void *                                   pTag_       = {},
                                   const void *                                   pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , objectType( objectType_ )
      , object( object_ )
      , tagName( tagName_ )
      , tagSize( tagSize_ )
      , pTag( pTag_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DebugMarkerObjectTagInfoEXT( DebugMarkerObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugMarkerObjectTagInfoEXT( VkDebugMarkerObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugMarkerObjectTagInfoEXT( *reinterpret_cast<DebugMarkerObjectTagInfoEXT const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    DebugMarkerObjectTagInfoEXT( VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT                 objectType_,
                                 uint64_t                                                       object_,
                                 uint64_t                                                       tagName_,
                                 VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & tag_,
                                 const void *                                                   pNext_ = nullptr )
      : pNext( pNext_ ), objectType( objectType_ ), object( object_ ), tagName( tagName_ ), tagSize( tag_.size() * sizeof( T ) ), pTag( tag_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugMarkerObjectTagInfoEXT & operator=( DebugMarkerObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugMarkerObjectTagInfoEXT & operator=( VkDebugMarkerObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugMarkerObjectTagInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectTagInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectTagInfoEXT & setObjectType( VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT objectType_ ) VULKAN_HPP_NOEXCEPT
    {
      objectType = objectType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectTagInfoEXT & setObject( uint64_t object_ ) VULKAN_HPP_NOEXCEPT
    {
      object = object_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectTagInfoEXT & setTagName( uint64_t tagName_ ) VULKAN_HPP_NOEXCEPT
    {
      tagName = tagName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectTagInfoEXT & setTagSize( size_t tagSize_ ) VULKAN_HPP_NOEXCEPT
    {
      tagSize = tagSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugMarkerObjectTagInfoEXT & setPTag( const void * pTag_ ) VULKAN_HPP_NOEXCEPT
    {
      pTag = pTag_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    DebugMarkerObjectTagInfoEXT & setTag( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & tag_ ) VULKAN_HPP_NOEXCEPT
    {
      tagSize = tag_.size() * sizeof( T );
      pTag    = tag_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDebugMarkerObjectTagInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugMarkerObjectTagInfoEXT *>( this );
    }

    explicit operator VkDebugMarkerObjectTagInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugMarkerObjectTagInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT const &,
               uint64_t const &,
               uint64_t const &,
               size_t const &,
               const void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, objectType, object, tagName, tagSize, pTag );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugMarkerObjectTagInfoEXT const & ) const = default;
#else
    bool operator==( DebugMarkerObjectTagInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( objectType == rhs.objectType ) && ( object == rhs.object ) && ( tagName == rhs.tagName ) &&
             ( tagSize == rhs.tagSize ) && ( pTag == rhs.pTag );
#  endif
    }

    bool operator!=( DebugMarkerObjectTagInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType      = StructureType::eDebugMarkerObjectTagInfoEXT;
    const void *                                   pNext      = {};
    VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT objectType = VULKAN_HPP_NAMESPACE::DebugReportObjectTypeEXT::eUnknown;
    uint64_t                                       object     = {};
    uint64_t                                       tagName    = {};
    size_t                                         tagSize    = {};
    const void *                                   pTag       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugMarkerObjectTagInfoEXT ) == sizeof( VkDebugMarkerObjectTagInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugMarkerObjectTagInfoEXT>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugMarkerObjectTagInfoEXT>::value,
                            "DebugMarkerObjectTagInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugMarkerObjectTagInfoEXT>
  {
    using Type = DebugMarkerObjectTagInfoEXT;
  };

  struct DebugReportCallbackCreateInfoEXT
  {
    using NativeType = VkDebugReportCallbackCreateInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugReportCallbackCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DebugReportCallbackCreateInfoEXT( VULKAN_HPP_NAMESPACE::DebugReportFlagsEXT flags_       = {},
                                                           PFN_vkDebugReportCallbackEXT              pfnCallback_ = {},
                                                           void *                                    pUserData_   = {},
                                                           const void *                              pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , pfnCallback( pfnCallback_ )
      , pUserData( pUserData_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DebugReportCallbackCreateInfoEXT( DebugReportCallbackCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugReportCallbackCreateInfoEXT( VkDebugReportCallbackCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugReportCallbackCreateInfoEXT( *reinterpret_cast<DebugReportCallbackCreateInfoEXT const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugReportCallbackCreateInfoEXT & operator=( DebugReportCallbackCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugReportCallbackCreateInfoEXT & operator=( VkDebugReportCallbackCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugReportCallbackCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugReportCallbackCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugReportCallbackCreateInfoEXT & setFlags( VULKAN_HPP_NAMESPACE::DebugReportFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugReportCallbackCreateInfoEXT & setPfnCallback( PFN_vkDebugReportCallbackEXT pfnCallback_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnCallback = pfnCallback_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugReportCallbackCreateInfoEXT & setPUserData( void * pUserData_ ) VULKAN_HPP_NOEXCEPT
    {
      pUserData = pUserData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDebugReportCallbackCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugReportCallbackCreateInfoEXT *>( this );
    }

    explicit operator VkDebugReportCallbackCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugReportCallbackCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DebugReportFlagsEXT const &,
               PFN_vkDebugReportCallbackEXT const &,
               void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, pfnCallback, pUserData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugReportCallbackCreateInfoEXT const & ) const = default;
#else
    bool operator==( DebugReportCallbackCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( pfnCallback == rhs.pfnCallback ) && ( pUserData == rhs.pUserData );
#  endif
    }

    bool operator!=( DebugReportCallbackCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType       = StructureType::eDebugReportCallbackCreateInfoEXT;
    const void *                              pNext       = {};
    VULKAN_HPP_NAMESPACE::DebugReportFlagsEXT flags       = {};
    PFN_vkDebugReportCallbackEXT              pfnCallback = {};
    void *                                    pUserData   = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugReportCallbackCreateInfoEXT ) == sizeof( VkDebugReportCallbackCreateInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugReportCallbackCreateInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugReportCallbackCreateInfoEXT>::value,
                            "DebugReportCallbackCreateInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugReportCallbackCreateInfoEXT>
  {
    using Type = DebugReportCallbackCreateInfoEXT;
  };

  struct DebugUtilsLabelEXT
  {
    using NativeType = VkDebugUtilsLabelEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugUtilsLabelEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      DebugUtilsLabelEXT( const char * pLabelName_ = {}, std::array<float, 4> const & color_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , pLabelName( pLabelName_ )
      , color( color_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsLabelEXT( DebugUtilsLabelEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsLabelEXT( VkDebugUtilsLabelEXT const & rhs ) VULKAN_HPP_NOEXCEPT : DebugUtilsLabelEXT( *reinterpret_cast<DebugUtilsLabelEXT const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsLabelEXT & operator=( DebugUtilsLabelEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsLabelEXT & operator=( VkDebugUtilsLabelEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsLabelEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsLabelEXT & setPLabelName( const char * pLabelName_ ) VULKAN_HPP_NOEXCEPT
    {
      pLabelName = pLabelName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsLabelEXT & setColor( std::array<float, 4> color_ ) VULKAN_HPP_NOEXCEPT
    {
      color = color_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDebugUtilsLabelEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsLabelEXT *>( this );
    }

    explicit operator VkDebugUtilsLabelEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsLabelEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, const char * const &, VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4> const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pLabelName, color );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::partial_ordering operator<=>( DebugUtilsLabelEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( pLabelName != rhs.pLabelName )
        if ( auto cmp = strcmp( pLabelName, rhs.pLabelName ); cmp != 0 )
          return ( cmp < 0 ) ? std::partial_ordering::less : std::partial_ordering::greater;
      if ( auto cmp = color <=> rhs.color; cmp != 0 )
        return cmp;

      return std::partial_ordering::equivalent;
    }
#endif

    bool operator==( DebugUtilsLabelEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( ( pLabelName == rhs.pLabelName ) || ( strcmp( pLabelName, rhs.pLabelName ) == 0 ) ) &&
             ( color == rhs.color );
    }

    bool operator!=( DebugUtilsLabelEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType      = StructureType::eDebugUtilsLabelEXT;
    const void *                                   pNext      = {};
    const char *                                   pLabelName = {};
    VULKAN_HPP_NAMESPACE::ArrayWrapper1D<float, 4> color      = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT ) == sizeof( VkDebugUtilsLabelEXT ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT>::value,
                            "DebugUtilsLabelEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsLabelEXT>
  {
    using Type = DebugUtilsLabelEXT;
  };

  struct DebugUtilsObjectNameInfoEXT
  {
    using NativeType = VkDebugUtilsObjectNameInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugUtilsObjectNameInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DebugUtilsObjectNameInfoEXT( VULKAN_HPP_NAMESPACE::ObjectType objectType_   = VULKAN_HPP_NAMESPACE::ObjectType::eUnknown,
                                                      uint64_t                         objectHandle_ = {},
                                                      const char *                     pObjectName_  = {},
                                                      const void *                     pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , objectType( objectType_ )
      , objectHandle( objectHandle_ )
      , pObjectName( pObjectName_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DebugUtilsObjectNameInfoEXT( DebugUtilsObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsObjectNameInfoEXT( VkDebugUtilsObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugUtilsObjectNameInfoEXT( *reinterpret_cast<DebugUtilsObjectNameInfoEXT const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsObjectNameInfoEXT & operator=( DebugUtilsObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsObjectNameInfoEXT & operator=( VkDebugUtilsObjectNameInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectNameInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectNameInfoEXT & setObjectType( VULKAN_HPP_NAMESPACE::ObjectType objectType_ ) VULKAN_HPP_NOEXCEPT
    {
      objectType = objectType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectNameInfoEXT & setObjectHandle( uint64_t objectHandle_ ) VULKAN_HPP_NOEXCEPT
    {
      objectHandle = objectHandle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectNameInfoEXT & setPObjectName( const char * pObjectName_ ) VULKAN_HPP_NOEXCEPT
    {
      pObjectName = pObjectName_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDebugUtilsObjectNameInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsObjectNameInfoEXT *>( this );
    }

    explicit operator VkDebugUtilsObjectNameInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsObjectNameInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::
      tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::ObjectType const &, uint64_t const &, const char * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, objectType, objectHandle, pObjectName );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( DebugUtilsObjectNameInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = objectType <=> rhs.objectType; cmp != 0 )
        return cmp;
      if ( auto cmp = objectHandle <=> rhs.objectHandle; cmp != 0 )
        return cmp;
      if ( pObjectName != rhs.pObjectName )
        if ( auto cmp = strcmp( pObjectName, rhs.pObjectName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( DebugUtilsObjectNameInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( objectType == rhs.objectType ) && ( objectHandle == rhs.objectHandle ) &&
             ( ( pObjectName == rhs.pObjectName ) || ( strcmp( pObjectName, rhs.pObjectName ) == 0 ) );
    }

    bool operator!=( DebugUtilsObjectNameInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eDebugUtilsObjectNameInfoEXT;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::ObjectType    objectType   = VULKAN_HPP_NAMESPACE::ObjectType::eUnknown;
    uint64_t                            objectHandle = {};
    const char *                        pObjectName  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT ) == sizeof( VkDebugUtilsObjectNameInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT>::value,
                            "DebugUtilsObjectNameInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsObjectNameInfoEXT>
  {
    using Type = DebugUtilsObjectNameInfoEXT;
  };

  struct DebugUtilsMessengerCallbackDataEXT
  {
    using NativeType = VkDebugUtilsMessengerCallbackDataEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugUtilsMessengerCallbackDataEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT flags_            = {},
                                                                const char *                                                  pMessageIdName_   = {},
                                                                int32_t                                                       messageIdNumber_  = {},
                                                                const char *                                                  pMessage_         = {},
                                                                uint32_t                                                      queueLabelCount_  = {},
                                                                const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *              pQueueLabels_     = {},
                                                                uint32_t                                                      cmdBufLabelCount_ = {},
                                                                const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *              pCmdBufLabels_    = {},
                                                                uint32_t                                                      objectCount_      = {},
                                                                const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT *     pObjects_         = {},
                                                                const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , pMessageIdName( pMessageIdName_ )
      , messageIdNumber( messageIdNumber_ )
      , pMessage( pMessage_ )
      , queueLabelCount( queueLabelCount_ )
      , pQueueLabels( pQueueLabels_ )
      , cmdBufLabelCount( cmdBufLabelCount_ )
      , pCmdBufLabels( pCmdBufLabels_ )
      , objectCount( objectCount_ )
      , pObjects( pObjects_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT( DebugUtilsMessengerCallbackDataEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsMessengerCallbackDataEXT( VkDebugUtilsMessengerCallbackDataEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugUtilsMessengerCallbackDataEXT( *reinterpret_cast<DebugUtilsMessengerCallbackDataEXT const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DebugUtilsMessengerCallbackDataEXT(
      VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT                                                  flags_,
      const char *                                                                                                   pMessageIdName_,
      int32_t                                                                                                        messageIdNumber_,
      const char *                                                                                                   pMessage_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT> const &          queueLabels_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT> const &          cmdBufLabels_ = {},
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT> const & objects_      = {},
      const void *                                                                                                   pNext_        = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , pMessageIdName( pMessageIdName_ )
      , messageIdNumber( messageIdNumber_ )
      , pMessage( pMessage_ )
      , queueLabelCount( static_cast<uint32_t>( queueLabels_.size() ) )
      , pQueueLabels( queueLabels_.data() )
      , cmdBufLabelCount( static_cast<uint32_t>( cmdBufLabels_.size() ) )
      , pCmdBufLabels( cmdBufLabels_.data() )
      , objectCount( static_cast<uint32_t>( objects_.size() ) )
      , pObjects( objects_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsMessengerCallbackDataEXT & operator=( DebugUtilsMessengerCallbackDataEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsMessengerCallbackDataEXT & operator=( VkDebugUtilsMessengerCallbackDataEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
                            setFlags( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setPMessageIdName( const char * pMessageIdName_ ) VULKAN_HPP_NOEXCEPT
    {
      pMessageIdName = pMessageIdName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setMessageIdNumber( int32_t messageIdNumber_ ) VULKAN_HPP_NOEXCEPT
    {
      messageIdNumber = messageIdNumber_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setPMessage( const char * pMessage_ ) VULKAN_HPP_NOEXCEPT
    {
      pMessage = pMessage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setQueueLabelCount( uint32_t queueLabelCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueLabelCount = queueLabelCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
                            setPQueueLabels( const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT * pQueueLabels_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueueLabels = pQueueLabels_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DebugUtilsMessengerCallbackDataEXT &
      setQueueLabels( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT> const & queueLabels_ ) VULKAN_HPP_NOEXCEPT
    {
      queueLabelCount = static_cast<uint32_t>( queueLabels_.size() );
      pQueueLabels    = queueLabels_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setCmdBufLabelCount( uint32_t cmdBufLabelCount_ ) VULKAN_HPP_NOEXCEPT
    {
      cmdBufLabelCount = cmdBufLabelCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
                            setPCmdBufLabels( const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT * pCmdBufLabels_ ) VULKAN_HPP_NOEXCEPT
    {
      pCmdBufLabels = pCmdBufLabels_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DebugUtilsMessengerCallbackDataEXT &
      setCmdBufLabels( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT> const & cmdBufLabels_ ) VULKAN_HPP_NOEXCEPT
    {
      cmdBufLabelCount = static_cast<uint32_t>( cmdBufLabels_.size() );
      pCmdBufLabels    = cmdBufLabels_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT & setObjectCount( uint32_t objectCount_ ) VULKAN_HPP_NOEXCEPT
    {
      objectCount = objectCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCallbackDataEXT &
                            setPObjects( const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT * pObjects_ ) VULKAN_HPP_NOEXCEPT
    {
      pObjects = pObjects_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DebugUtilsMessengerCallbackDataEXT &
      setObjects( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT> const & objects_ ) VULKAN_HPP_NOEXCEPT
    {
      objectCount = static_cast<uint32_t>( objects_.size() );
      pObjects    = objects_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDebugUtilsMessengerCallbackDataEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsMessengerCallbackDataEXT *>( this );
    }

    explicit operator VkDebugUtilsMessengerCallbackDataEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsMessengerCallbackDataEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT const &,
               const char * const &,
               int32_t const &,
               const char * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, flags, pMessageIdName, messageIdNumber, pMessage, queueLabelCount, pQueueLabels, cmdBufLabelCount, pCmdBufLabels, objectCount, pObjects );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( DebugUtilsMessengerCallbackDataEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = flags <=> rhs.flags; cmp != 0 )
        return cmp;
      if ( pMessageIdName != rhs.pMessageIdName )
        if ( auto cmp = strcmp( pMessageIdName, rhs.pMessageIdName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = messageIdNumber <=> rhs.messageIdNumber; cmp != 0 )
        return cmp;
      if ( pMessage != rhs.pMessage )
        if ( auto cmp = strcmp( pMessage, rhs.pMessage ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = queueLabelCount <=> rhs.queueLabelCount; cmp != 0 )
        return cmp;
      if ( auto cmp = pQueueLabels <=> rhs.pQueueLabels; cmp != 0 )
        return cmp;
      if ( auto cmp = cmdBufLabelCount <=> rhs.cmdBufLabelCount; cmp != 0 )
        return cmp;
      if ( auto cmp = pCmdBufLabels <=> rhs.pCmdBufLabels; cmp != 0 )
        return cmp;
      if ( auto cmp = objectCount <=> rhs.objectCount; cmp != 0 )
        return cmp;
      if ( auto cmp = pObjects <=> rhs.pObjects; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( DebugUtilsMessengerCallbackDataEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) &&
             ( ( pMessageIdName == rhs.pMessageIdName ) || ( strcmp( pMessageIdName, rhs.pMessageIdName ) == 0 ) ) &&
             ( messageIdNumber == rhs.messageIdNumber ) && ( ( pMessage == rhs.pMessage ) || ( strcmp( pMessage, rhs.pMessage ) == 0 ) ) &&
             ( queueLabelCount == rhs.queueLabelCount ) && ( pQueueLabels == rhs.pQueueLabels ) && ( cmdBufLabelCount == rhs.cmdBufLabelCount ) &&
             ( pCmdBufLabels == rhs.pCmdBufLabels ) && ( objectCount == rhs.objectCount ) && ( pObjects == rhs.pObjects );
    }

    bool operator!=( DebugUtilsMessengerCallbackDataEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType                           sType            = StructureType::eDebugUtilsMessengerCallbackDataEXT;
    const void *                                                  pNext            = {};
    VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataFlagsEXT flags            = {};
    const char *                                                  pMessageIdName   = {};
    int32_t                                                       messageIdNumber  = {};
    const char *                                                  pMessage         = {};
    uint32_t                                                      queueLabelCount  = {};
    const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *              pQueueLabels     = {};
    uint32_t                                                      cmdBufLabelCount = {};
    const VULKAN_HPP_NAMESPACE::DebugUtilsLabelEXT *              pCmdBufLabels    = {};
    uint32_t                                                      objectCount      = {};
    const VULKAN_HPP_NAMESPACE::DebugUtilsObjectNameInfoEXT *     pObjects         = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataEXT ) == sizeof( VkDebugUtilsMessengerCallbackDataEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCallbackDataEXT>::value,
                            "DebugUtilsMessengerCallbackDataEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsMessengerCallbackDataEXT>
  {
    using Type = DebugUtilsMessengerCallbackDataEXT;
  };

  struct DebugUtilsMessengerCreateInfoEXT
  {
    using NativeType = VkDebugUtilsMessengerCreateInfoEXT;

    static const bool                                  allowDuplicate = true;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugUtilsMessengerCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DebugUtilsMessengerCreateInfoEXT( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateFlagsEXT flags_           = {},
                                                           VULKAN_HPP_NAMESPACE::DebugUtilsMessageSeverityFlagsEXT messageSeverity_ = {},
                                                           VULKAN_HPP_NAMESPACE::DebugUtilsMessageTypeFlagsEXT     messageType_     = {},
                                                           PFN_vkDebugUtilsMessengerCallbackEXT                    pfnUserCallback_ = {},
                                                           void *                                                  pUserData_       = {},
                                                           const void *                                            pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , messageSeverity( messageSeverity_ )
      , messageType( messageType_ )
      , pfnUserCallback( pfnUserCallback_ )
      , pUserData( pUserData_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DebugUtilsMessengerCreateInfoEXT( DebugUtilsMessengerCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsMessengerCreateInfoEXT( VkDebugUtilsMessengerCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugUtilsMessengerCreateInfoEXT( *reinterpret_cast<DebugUtilsMessengerCreateInfoEXT const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsMessengerCreateInfoEXT & operator=( DebugUtilsMessengerCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsMessengerCreateInfoEXT & operator=( VkDebugUtilsMessengerCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT & setFlags( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT &
                            setMessageSeverity( VULKAN_HPP_NAMESPACE::DebugUtilsMessageSeverityFlagsEXT messageSeverity_ ) VULKAN_HPP_NOEXCEPT
    {
      messageSeverity = messageSeverity_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT &
                            setMessageType( VULKAN_HPP_NAMESPACE::DebugUtilsMessageTypeFlagsEXT messageType_ ) VULKAN_HPP_NOEXCEPT
    {
      messageType = messageType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT & setPfnUserCallback( PFN_vkDebugUtilsMessengerCallbackEXT pfnUserCallback_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnUserCallback = pfnUserCallback_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsMessengerCreateInfoEXT & setPUserData( void * pUserData_ ) VULKAN_HPP_NOEXCEPT
    {
      pUserData = pUserData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDebugUtilsMessengerCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsMessengerCreateInfoEXT *>( this );
    }

    explicit operator VkDebugUtilsMessengerCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsMessengerCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateFlagsEXT const &,
               VULKAN_HPP_NAMESPACE::DebugUtilsMessageSeverityFlagsEXT const &,
               VULKAN_HPP_NAMESPACE::DebugUtilsMessageTypeFlagsEXT const &,
               PFN_vkDebugUtilsMessengerCallbackEXT const &,
               void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, messageSeverity, messageType, pfnUserCallback, pUserData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugUtilsMessengerCreateInfoEXT const & ) const = default;
#else
    bool operator==( DebugUtilsMessengerCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( messageSeverity == rhs.messageSeverity ) &&
             ( messageType == rhs.messageType ) && ( pfnUserCallback == rhs.pfnUserCallback ) && ( pUserData == rhs.pUserData );
#  endif
    }

    bool operator!=( DebugUtilsMessengerCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                     sType           = StructureType::eDebugUtilsMessengerCreateInfoEXT;
    const void *                                            pNext           = {};
    VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateFlagsEXT flags           = {};
    VULKAN_HPP_NAMESPACE::DebugUtilsMessageSeverityFlagsEXT messageSeverity = {};
    VULKAN_HPP_NAMESPACE::DebugUtilsMessageTypeFlagsEXT     messageType     = {};
    PFN_vkDebugUtilsMessengerCallbackEXT                    pfnUserCallback = {};
    void *                                                  pUserData       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateInfoEXT ) == sizeof( VkDebugUtilsMessengerCreateInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugUtilsMessengerCreateInfoEXT>::value,
                            "DebugUtilsMessengerCreateInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsMessengerCreateInfoEXT>
  {
    using Type = DebugUtilsMessengerCreateInfoEXT;
  };

  struct DebugUtilsObjectTagInfoEXT
  {
    using NativeType = VkDebugUtilsObjectTagInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDebugUtilsObjectTagInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DebugUtilsObjectTagInfoEXT( VULKAN_HPP_NAMESPACE::ObjectType objectType_   = VULKAN_HPP_NAMESPACE::ObjectType::eUnknown,
                                                     uint64_t                         objectHandle_ = {},
                                                     uint64_t                         tagName_      = {},
                                                     size_t                           tagSize_      = {},
                                                     const void *                     pTag_         = {},
                                                     const void *                     pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , objectType( objectType_ )
      , objectHandle( objectHandle_ )
      , tagName( tagName_ )
      , tagSize( tagSize_ )
      , pTag( pTag_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DebugUtilsObjectTagInfoEXT( DebugUtilsObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsObjectTagInfoEXT( VkDebugUtilsObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DebugUtilsObjectTagInfoEXT( *reinterpret_cast<DebugUtilsObjectTagInfoEXT const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    DebugUtilsObjectTagInfoEXT( VULKAN_HPP_NAMESPACE::ObjectType                               objectType_,
                                uint64_t                                                       objectHandle_,
                                uint64_t                                                       tagName_,
                                VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & tag_,
                                const void *                                                   pNext_ = nullptr )
      : pNext( pNext_ )
      , objectType( objectType_ )
      , objectHandle( objectHandle_ )
      , tagName( tagName_ )
      , tagSize( tag_.size() * sizeof( T ) )
      , pTag( tag_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DebugUtilsObjectTagInfoEXT & operator=( DebugUtilsObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DebugUtilsObjectTagInfoEXT & operator=( VkDebugUtilsObjectTagInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DebugUtilsObjectTagInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setObjectType( VULKAN_HPP_NAMESPACE::ObjectType objectType_ ) VULKAN_HPP_NOEXCEPT
    {
      objectType = objectType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setObjectHandle( uint64_t objectHandle_ ) VULKAN_HPP_NOEXCEPT
    {
      objectHandle = objectHandle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setTagName( uint64_t tagName_ ) VULKAN_HPP_NOEXCEPT
    {
      tagName = tagName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setTagSize( size_t tagSize_ ) VULKAN_HPP_NOEXCEPT
    {
      tagSize = tagSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DebugUtilsObjectTagInfoEXT & setPTag( const void * pTag_ ) VULKAN_HPP_NOEXCEPT
    {
      pTag = pTag_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    DebugUtilsObjectTagInfoEXT & setTag( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const T> const & tag_ ) VULKAN_HPP_NOEXCEPT
    {
      tagSize = tag_.size() * sizeof( T );
      pTag    = tag_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDebugUtilsObjectTagInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDebugUtilsObjectTagInfoEXT *>( this );
    }

    explicit operator VkDebugUtilsObjectTagInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDebugUtilsObjectTagInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::ObjectType const &,
               uint64_t const &,
               uint64_t const &,
               size_t const &,
               const void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, objectType, objectHandle, tagName, tagSize, pTag );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DebugUtilsObjectTagInfoEXT const & ) const = default;
#else
    bool operator==( DebugUtilsObjectTagInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( objectType == rhs.objectType ) && ( objectHandle == rhs.objectHandle ) &&
             ( tagName == rhs.tagName ) && ( tagSize == rhs.tagSize ) && ( pTag == rhs.pTag );
#  endif
    }

    bool operator!=( DebugUtilsObjectTagInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType        = StructureType::eDebugUtilsObjectTagInfoEXT;
    const void *                        pNext        = {};
    VULKAN_HPP_NAMESPACE::ObjectType    objectType   = VULKAN_HPP_NAMESPACE::ObjectType::eUnknown;
    uint64_t                            objectHandle = {};
    uint64_t                            tagName      = {};
    size_t                              tagSize      = {};
    const void *                        pTag         = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DebugUtilsObjectTagInfoEXT ) == sizeof( VkDebugUtilsObjectTagInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DebugUtilsObjectTagInfoEXT>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DebugUtilsObjectTagInfoEXT>::value,
                            "DebugUtilsObjectTagInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDebugUtilsObjectTagInfoEXT>
  {
    using Type = DebugUtilsObjectTagInfoEXT;
  };

  struct DedicatedAllocationBufferCreateInfoNV
  {
    using NativeType = VkDedicatedAllocationBufferCreateInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDedicatedAllocationBufferCreateInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DedicatedAllocationBufferCreateInfoNV( VULKAN_HPP_NAMESPACE::Bool32 dedicatedAllocation_ = {},
                                                                const void *                 pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , dedicatedAllocation( dedicatedAllocation_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DedicatedAllocationBufferCreateInfoNV( DedicatedAllocationBufferCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DedicatedAllocationBufferCreateInfoNV( VkDedicatedAllocationBufferCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : DedicatedAllocationBufferCreateInfoNV( *reinterpret_cast<DedicatedAllocationBufferCreateInfoNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DedicatedAllocationBufferCreateInfoNV & operator=( DedicatedAllocationBufferCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DedicatedAllocationBufferCreateInfoNV & operator=( VkDedicatedAllocationBufferCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DedicatedAllocationBufferCreateInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationBufferCreateInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationBufferCreateInfoNV &
                            setDedicatedAllocation( VULKAN_HPP_NAMESPACE::Bool32 dedicatedAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      dedicatedAllocation = dedicatedAllocation_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDedicatedAllocationBufferCreateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDedicatedAllocationBufferCreateInfoNV *>( this );
    }

    explicit operator VkDedicatedAllocationBufferCreateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDedicatedAllocationBufferCreateInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, dedicatedAllocation );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DedicatedAllocationBufferCreateInfoNV const & ) const = default;
#else
    bool operator==( DedicatedAllocationBufferCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( dedicatedAllocation == rhs.dedicatedAllocation );
#  endif
    }

    bool operator!=( DedicatedAllocationBufferCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType               = StructureType::eDedicatedAllocationBufferCreateInfoNV;
    const void *                        pNext               = {};
    VULKAN_HPP_NAMESPACE::Bool32        dedicatedAllocation = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DedicatedAllocationBufferCreateInfoNV ) == sizeof( VkDedicatedAllocationBufferCreateInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DedicatedAllocationBufferCreateInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DedicatedAllocationBufferCreateInfoNV>::value,
                            "DedicatedAllocationBufferCreateInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDedicatedAllocationBufferCreateInfoNV>
  {
    using Type = DedicatedAllocationBufferCreateInfoNV;
  };

  struct DedicatedAllocationImageCreateInfoNV
  {
    using NativeType = VkDedicatedAllocationImageCreateInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDedicatedAllocationImageCreateInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DedicatedAllocationImageCreateInfoNV( VULKAN_HPP_NAMESPACE::Bool32 dedicatedAllocation_ = {},
                                                               const void *                 pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , dedicatedAllocation( dedicatedAllocation_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DedicatedAllocationImageCreateInfoNV( DedicatedAllocationImageCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DedicatedAllocationImageCreateInfoNV( VkDedicatedAllocationImageCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : DedicatedAllocationImageCreateInfoNV( *reinterpret_cast<DedicatedAllocationImageCreateInfoNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DedicatedAllocationImageCreateInfoNV & operator=( DedicatedAllocationImageCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DedicatedAllocationImageCreateInfoNV & operator=( VkDedicatedAllocationImageCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DedicatedAllocationImageCreateInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationImageCreateInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationImageCreateInfoNV &
                            setDedicatedAllocation( VULKAN_HPP_NAMESPACE::Bool32 dedicatedAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      dedicatedAllocation = dedicatedAllocation_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDedicatedAllocationImageCreateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDedicatedAllocationImageCreateInfoNV *>( this );
    }

    explicit operator VkDedicatedAllocationImageCreateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDedicatedAllocationImageCreateInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, dedicatedAllocation );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DedicatedAllocationImageCreateInfoNV const & ) const = default;
#else
    bool operator==( DedicatedAllocationImageCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( dedicatedAllocation == rhs.dedicatedAllocation );
#  endif
    }

    bool operator!=( DedicatedAllocationImageCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType               = StructureType::eDedicatedAllocationImageCreateInfoNV;
    const void *                        pNext               = {};
    VULKAN_HPP_NAMESPACE::Bool32        dedicatedAllocation = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DedicatedAllocationImageCreateInfoNV ) == sizeof( VkDedicatedAllocationImageCreateInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DedicatedAllocationImageCreateInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DedicatedAllocationImageCreateInfoNV>::value,
                            "DedicatedAllocationImageCreateInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDedicatedAllocationImageCreateInfoNV>
  {
    using Type = DedicatedAllocationImageCreateInfoNV;
  };

  struct DedicatedAllocationMemoryAllocateInfoNV
  {
    using NativeType = VkDedicatedAllocationMemoryAllocateInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDedicatedAllocationMemoryAllocateInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DedicatedAllocationMemoryAllocateInfoNV( VULKAN_HPP_NAMESPACE::Image  image_  = {},
                                                                  VULKAN_HPP_NAMESPACE::Buffer buffer_ = {},
                                                                  const void *                 pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , image( image_ )
      , buffer( buffer_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DedicatedAllocationMemoryAllocateInfoNV( DedicatedAllocationMemoryAllocateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DedicatedAllocationMemoryAllocateInfoNV( VkDedicatedAllocationMemoryAllocateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : DedicatedAllocationMemoryAllocateInfoNV( *reinterpret_cast<DedicatedAllocationMemoryAllocateInfoNV const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DedicatedAllocationMemoryAllocateInfoNV & operator=( DedicatedAllocationMemoryAllocateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DedicatedAllocationMemoryAllocateInfoNV & operator=( VkDedicatedAllocationMemoryAllocateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DedicatedAllocationMemoryAllocateInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationMemoryAllocateInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationMemoryAllocateInfoNV & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DedicatedAllocationMemoryAllocateInfoNV & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDedicatedAllocationMemoryAllocateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDedicatedAllocationMemoryAllocateInfoNV *>( this );
    }

    explicit operator VkDedicatedAllocationMemoryAllocateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDedicatedAllocationMemoryAllocateInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::Image const &, VULKAN_HPP_NAMESPACE::Buffer const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, image, buffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DedicatedAllocationMemoryAllocateInfoNV const & ) const = default;
#else
    bool operator==( DedicatedAllocationMemoryAllocateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( image == rhs.image ) && ( buffer == rhs.buffer );
#  endif
    }

    bool operator!=( DedicatedAllocationMemoryAllocateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType  = StructureType::eDedicatedAllocationMemoryAllocateInfoNV;
    const void *                        pNext  = {};
    VULKAN_HPP_NAMESPACE::Image         image  = {};
    VULKAN_HPP_NAMESPACE::Buffer        buffer = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DedicatedAllocationMemoryAllocateInfoNV ) == sizeof( VkDedicatedAllocationMemoryAllocateInfoNV ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DedicatedAllocationMemoryAllocateInfoNV>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DedicatedAllocationMemoryAllocateInfoNV>::value,
                            "DedicatedAllocationMemoryAllocateInfoNV is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDedicatedAllocationMemoryAllocateInfoNV>
  {
    using Type = DedicatedAllocationMemoryAllocateInfoNV;
  };

  struct MemoryBarrier2
  {
    using NativeType = VkMemoryBarrier2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eMemoryBarrier2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR MemoryBarrier2( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask_  = {},
                                         VULKAN_HPP_NAMESPACE::AccessFlags2        srcAccessMask_ = {},
                                         VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask_  = {},
                                         VULKAN_HPP_NAMESPACE::AccessFlags2        dstAccessMask_ = {},
                                         const void *                              pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , srcStageMask( srcStageMask_ )
      , srcAccessMask( srcAccessMask_ )
      , dstStageMask( dstStageMask_ )
      , dstAccessMask( dstAccessMask_ )
    {
    }

    VULKAN_HPP_CONSTEXPR MemoryBarrier2( MemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    MemoryBarrier2( VkMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT : MemoryBarrier2( *reinterpret_cast<MemoryBarrier2 const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    MemoryBarrier2 & operator=( MemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    MemoryBarrier2 & operator=( VkMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::MemoryBarrier2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2 & setSrcStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcStageMask = srcStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2 & setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2 & setDstStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstStageMask = dstStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryBarrier2 & setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkMemoryBarrier2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkMemoryBarrier2 *>( this );
    }

    explicit operator VkMemoryBarrier2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkMemoryBarrier2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcStageMask, srcAccessMask, dstStageMask, dstAccessMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( MemoryBarrier2 const & ) const = default;
#else
    bool operator==( MemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcStageMask == rhs.srcStageMask ) && ( srcAccessMask == rhs.srcAccessMask ) &&
             ( dstStageMask == rhs.dstStageMask ) && ( dstAccessMask == rhs.dstAccessMask );
#  endif
    }

    bool operator!=( MemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType         = StructureType::eMemoryBarrier2;
    const void *                              pNext         = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask  = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2        srcAccessMask = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask  = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2        dstAccessMask = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::MemoryBarrier2 ) == sizeof( VkMemoryBarrier2 ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::MemoryBarrier2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::MemoryBarrier2>::value,
                            "MemoryBarrier2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eMemoryBarrier2>
  {
    using Type = MemoryBarrier2;
  };
  using MemoryBarrier2KHR = MemoryBarrier2;

  struct ImageSubresourceRange
  {
    using NativeType = VkImageSubresourceRange;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageSubresourceRange( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_     = {},
                                                uint32_t                               baseMipLevel_   = {},
                                                uint32_t                               levelCount_     = {},
                                                uint32_t                               baseArrayLayer_ = {},
                                                uint32_t                               layerCount_     = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask( aspectMask_ )
      , baseMipLevel( baseMipLevel_ )
      , levelCount( levelCount_ )
      , baseArrayLayer( baseArrayLayer_ )
      , layerCount( layerCount_ )
    {
    }

    VULKAN_HPP_CONSTEXPR ImageSubresourceRange( ImageSubresourceRange const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresourceRange( VkImageSubresourceRange const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageSubresourceRange( *reinterpret_cast<ImageSubresourceRange const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageSubresourceRange & operator=( ImageSubresourceRange const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresourceRange & operator=( VkImageSubresourceRange const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageSubresourceRange const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setAspectMask( VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setBaseMipLevel( uint32_t baseMipLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      baseMipLevel = baseMipLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setLevelCount( uint32_t levelCount_ ) VULKAN_HPP_NOEXCEPT
    {
      levelCount = levelCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setBaseArrayLayer( uint32_t baseArrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      baseArrayLayer = baseArrayLayer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceRange & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkImageSubresourceRange const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageSubresourceRange *>( this );
    }

    explicit operator VkImageSubresourceRange &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageSubresourceRange *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::ImageAspectFlags const &, uint32_t const &, uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( aspectMask, baseMipLevel, levelCount, baseArrayLayer, layerCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageSubresourceRange const & ) const = default;
#else
    bool operator==( ImageSubresourceRange const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( aspectMask == rhs.aspectMask ) && ( baseMipLevel == rhs.baseMipLevel ) && ( levelCount == rhs.levelCount ) &&
             ( baseArrayLayer == rhs.baseArrayLayer ) && ( layerCount == rhs.layerCount );
#  endif
    }

    bool operator!=( ImageSubresourceRange const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::ImageAspectFlags aspectMask     = {};
    uint32_t                               baseMipLevel   = {};
    uint32_t                               levelCount     = {};
    uint32_t                               baseArrayLayer = {};
    uint32_t                               layerCount     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ImageSubresourceRange ) == sizeof( VkImageSubresourceRange ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ImageSubresourceRange>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ImageSubresourceRange>::value,
                            "ImageSubresourceRange is not nothrow_move_constructible!" );

  struct ImageMemoryBarrier2
  {
    using NativeType = VkImageMemoryBarrier2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageMemoryBarrier2;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageMemoryBarrier2( VULKAN_HPP_NAMESPACE::PipelineStageFlags2   srcStageMask_        = {},
                                              VULKAN_HPP_NAMESPACE::AccessFlags2          srcAccessMask_       = {},
                                              VULKAN_HPP_NAMESPACE::PipelineStageFlags2   dstStageMask_        = {},
                                              VULKAN_HPP_NAMESPACE::AccessFlags2          dstAccessMask_       = {},
                                              VULKAN_HPP_NAMESPACE::ImageLayout           oldLayout_           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                              VULKAN_HPP_NAMESPACE::ImageLayout           newLayout_           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined,
                                              uint32_t                                    srcQueueFamilyIndex_ = {},
                                              uint32_t                                    dstQueueFamilyIndex_ = {},
                                              VULKAN_HPP_NAMESPACE::Image                 image_               = {},
                                              VULKAN_HPP_NAMESPACE::ImageSubresourceRange subresourceRange_    = {},
                                              const void *                                pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , srcStageMask( srcStageMask_ )
      , srcAccessMask( srcAccessMask_ )
      , dstStageMask( dstStageMask_ )
      , dstAccessMask( dstAccessMask_ )
      , oldLayout( oldLayout_ )
      , newLayout( newLayout_ )
      , srcQueueFamilyIndex( srcQueueFamilyIndex_ )
      , dstQueueFamilyIndex( dstQueueFamilyIndex_ )
      , image( image_ )
      , subresourceRange( subresourceRange_ )
    {
    }

    VULKAN_HPP_CONSTEXPR ImageMemoryBarrier2( ImageMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageMemoryBarrier2( VkImageMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT : ImageMemoryBarrier2( *reinterpret_cast<ImageMemoryBarrier2 const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    ImageMemoryBarrier2 & operator=( ImageMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageMemoryBarrier2 & operator=( VkImageMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setSrcStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 srcStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcStageMask = srcStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setSrcAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setDstStageMask( VULKAN_HPP_NAMESPACE::PipelineStageFlags2 dstStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstStageMask = dstStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setDstAccessMask( VULKAN_HPP_NAMESPACE::AccessFlags2 dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setOldLayout( VULKAN_HPP_NAMESPACE::ImageLayout oldLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      oldLayout = oldLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setNewLayout( VULKAN_HPP_NAMESPACE::ImageLayout newLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      newLayout = newLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 & setImage( VULKAN_HPP_NAMESPACE::Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageMemoryBarrier2 &
                            setSubresourceRange( VULKAN_HPP_NAMESPACE::ImageSubresourceRange const & subresourceRange_ ) VULKAN_HPP_NOEXCEPT
    {
      subresourceRange = subresourceRange_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkImageMemoryBarrier2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageMemoryBarrier2 *>( this );
    }

    explicit operator VkImageMemoryBarrier2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageMemoryBarrier2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &,
               VULKAN_HPP_NAMESPACE::PipelineStageFlags2 const &,
               VULKAN_HPP_NAMESPACE::AccessFlags2 const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               VULKAN_HPP_NAMESPACE::ImageLayout const &,
               uint32_t const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::Image const &,
               VULKAN_HPP_NAMESPACE::ImageSubresourceRange const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       srcStageMask,
                       srcAccessMask,
                       dstStageMask,
                       dstAccessMask,
                       oldLayout,
                       newLayout,
                       srcQueueFamilyIndex,
                       dstQueueFamilyIndex,
                       image,
                       subresourceRange );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageMemoryBarrier2 const & ) const = default;
#else
    bool operator==( ImageMemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcStageMask == rhs.srcStageMask ) && ( srcAccessMask == rhs.srcAccessMask ) &&
             ( dstStageMask == rhs.dstStageMask ) && ( dstAccessMask == rhs.dstAccessMask ) && ( oldLayout == rhs.oldLayout ) &&
             ( newLayout == rhs.newLayout ) && ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) && ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) &&
             ( image == rhs.image ) && ( subresourceRange == rhs.subresourceRange );
#  endif
    }

    bool operator!=( ImageMemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType         sType               = StructureType::eImageMemoryBarrier2;
    const void *                                pNext               = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2   srcStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2          srcAccessMask       = {};
    VULKAN_HPP_NAMESPACE::PipelineStageFlags2   dstStageMask        = {};
    VULKAN_HPP_NAMESPACE::AccessFlags2          dstAccessMask       = {};
    VULKAN_HPP_NAMESPACE::ImageLayout           oldLayout           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    VULKAN_HPP_NAMESPACE::ImageLayout           newLayout           = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
    uint32_t                                    srcQueueFamilyIndex = {};
    uint32_t                                    dstQueueFamilyIndex = {};
    VULKAN_HPP_NAMESPACE::Image                 image               = {};
    VULKAN_HPP_NAMESPACE::ImageSubresourceRange subresourceRange    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2 ) == sizeof( VkImageMemoryBarrier2 ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2>::value,
                            "ImageMemoryBarrier2 is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eImageMemoryBarrier2>
  {
    using Type = ImageMemoryBarrier2;
  };
  using ImageMemoryBarrier2KHR = ImageMemoryBarrier2;

  struct DependencyInfo
  {
    using NativeType = VkDependencyInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDependencyInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DependencyInfo( VULKAN_HPP_NAMESPACE::DependencyFlags              dependencyFlags_          = {},
                                         uint32_t                                           memoryBarrierCount_       = {},
                                         const VULKAN_HPP_NAMESPACE::MemoryBarrier2 *       pMemoryBarriers_          = {},
                                         uint32_t                                           bufferMemoryBarrierCount_ = {},
                                         const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2 * pBufferMemoryBarriers_    = {},
                                         uint32_t                                           imageMemoryBarrierCount_  = {},
                                         const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2 *  pImageMemoryBarriers_     = {},
                                         const void *                                       pNext_                    = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , dependencyFlags( dependencyFlags_ )
      , memoryBarrierCount( memoryBarrierCount_ )
      , pMemoryBarriers( pMemoryBarriers_ )
      , bufferMemoryBarrierCount( bufferMemoryBarrierCount_ )
      , pBufferMemoryBarriers( pBufferMemoryBarriers_ )
      , imageMemoryBarrierCount( imageMemoryBarrierCount_ )
      , pImageMemoryBarriers( pImageMemoryBarriers_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DependencyInfo( DependencyInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DependencyInfo( VkDependencyInfo const & rhs ) VULKAN_HPP_NOEXCEPT : DependencyInfo( *reinterpret_cast<DependencyInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DependencyInfo( VULKAN_HPP_NAMESPACE::DependencyFlags                                                                   dependencyFlags_,
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MemoryBarrier2> const &       memoryBarriers_,
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2> const & bufferMemoryBarriers_ = {},
                    VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2> const &  imageMemoryBarriers_  = {},
                    const void *                                                                                            pNext_                = nullptr )
      : pNext( pNext_ )
      , dependencyFlags( dependencyFlags_ )
      , memoryBarrierCount( static_cast<uint32_t>( memoryBarriers_.size() ) )
      , pMemoryBarriers( memoryBarriers_.data() )
      , bufferMemoryBarrierCount( static_cast<uint32_t>( bufferMemoryBarriers_.size() ) )
      , pBufferMemoryBarriers( bufferMemoryBarriers_.data() )
      , imageMemoryBarrierCount( static_cast<uint32_t>( imageMemoryBarriers_.size() ) )
      , pImageMemoryBarriers( imageMemoryBarriers_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DependencyInfo & operator=( DependencyInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DependencyInfo & operator=( VkDependencyInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DependencyInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DependencyInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo & setDependencyFlags( VULKAN_HPP_NAMESPACE::DependencyFlags dependencyFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      dependencyFlags = dependencyFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo & setMemoryBarrierCount( uint32_t memoryBarrierCount_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryBarrierCount = memoryBarrierCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo & setPMemoryBarriers( const VULKAN_HPP_NAMESPACE::MemoryBarrier2 * pMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      pMemoryBarriers = pMemoryBarriers_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DependencyInfo &
      setMemoryBarriers( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::MemoryBarrier2> const & memoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryBarrierCount = static_cast<uint32_t>( memoryBarriers_.size() );
      pMemoryBarriers    = memoryBarriers_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo & setBufferMemoryBarrierCount( uint32_t bufferMemoryBarrierCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferMemoryBarrierCount = bufferMemoryBarrierCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo &
                            setPBufferMemoryBarriers( const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2 * pBufferMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      pBufferMemoryBarriers = pBufferMemoryBarriers_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DependencyInfo & setBufferMemoryBarriers(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2> const & bufferMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferMemoryBarrierCount = static_cast<uint32_t>( bufferMemoryBarriers_.size() );
      pBufferMemoryBarriers    = bufferMemoryBarriers_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo & setImageMemoryBarrierCount( uint32_t imageMemoryBarrierCount_ ) VULKAN_HPP_NOEXCEPT
    {
      imageMemoryBarrierCount = imageMemoryBarrierCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DependencyInfo &
                            setPImageMemoryBarriers( const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2 * pImageMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      pImageMemoryBarriers = pImageMemoryBarriers_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DependencyInfo & setImageMemoryBarriers(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2> const & imageMemoryBarriers_ ) VULKAN_HPP_NOEXCEPT
    {
      imageMemoryBarrierCount = static_cast<uint32_t>( imageMemoryBarriers_.size() );
      pImageMemoryBarriers    = imageMemoryBarriers_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDependencyInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDependencyInfo *>( this );
    }

    explicit operator VkDependencyInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDependencyInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DependencyFlags const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::MemoryBarrier2 * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2 * const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       dependencyFlags,
                       memoryBarrierCount,
                       pMemoryBarriers,
                       bufferMemoryBarrierCount,
                       pBufferMemoryBarriers,
                       imageMemoryBarrierCount,
                       pImageMemoryBarriers );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DependencyInfo const & ) const = default;
#else
    bool operator==( DependencyInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( dependencyFlags == rhs.dependencyFlags ) &&
             ( memoryBarrierCount == rhs.memoryBarrierCount ) && ( pMemoryBarriers == rhs.pMemoryBarriers ) &&
             ( bufferMemoryBarrierCount == rhs.bufferMemoryBarrierCount ) && ( pBufferMemoryBarriers == rhs.pBufferMemoryBarriers ) &&
             ( imageMemoryBarrierCount == rhs.imageMemoryBarrierCount ) && ( pImageMemoryBarriers == rhs.pImageMemoryBarriers );
#  endif
    }

    bool operator!=( DependencyInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                sType                    = StructureType::eDependencyInfo;
    const void *                                       pNext                    = {};
    VULKAN_HPP_NAMESPACE::DependencyFlags              dependencyFlags          = {};
    uint32_t                                           memoryBarrierCount       = {};
    const VULKAN_HPP_NAMESPACE::MemoryBarrier2 *       pMemoryBarriers          = {};
    uint32_t                                           bufferMemoryBarrierCount = {};
    const VULKAN_HPP_NAMESPACE::BufferMemoryBarrier2 * pBufferMemoryBarriers    = {};
    uint32_t                                           imageMemoryBarrierCount  = {};
    const VULKAN_HPP_NAMESPACE::ImageMemoryBarrier2 *  pImageMemoryBarriers     = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DependencyInfo ) == sizeof( VkDependencyInfo ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DependencyInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DependencyInfo>::value,
                            "DependencyInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDependencyInfo>
  {
    using Type = DependencyInfo;
  };
  using DependencyInfoKHR = DependencyInfo;

  struct DescriptorBufferInfo
  {
    using NativeType = VkDescriptorBufferInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorBufferInfo( VULKAN_HPP_NAMESPACE::Buffer     buffer_ = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize offset_ = {},
                                               VULKAN_HPP_NAMESPACE::DeviceSize range_  = {} ) VULKAN_HPP_NOEXCEPT
      : buffer( buffer_ )
      , offset( offset_ )
      , range( range_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorBufferInfo( DescriptorBufferInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorBufferInfo( VkDescriptorBufferInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorBufferInfo( *reinterpret_cast<DescriptorBufferInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorBufferInfo & operator=( DescriptorBufferInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorBufferInfo & operator=( VkDescriptorBufferInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorBufferInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorBufferInfo & setBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorBufferInfo & setOffset( VULKAN_HPP_NAMESPACE::DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorBufferInfo & setRange( VULKAN_HPP_NAMESPACE::DeviceSize range_ ) VULKAN_HPP_NOEXCEPT
    {
      range = range_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorBufferInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorBufferInfo *>( this );
    }

    explicit operator VkDescriptorBufferInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorBufferInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Buffer const &, VULKAN_HPP_NAMESPACE::DeviceSize const &, VULKAN_HPP_NAMESPACE::DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( buffer, offset, range );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorBufferInfo const & ) const = default;
#else
    bool operator==( DescriptorBufferInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( buffer == rhs.buffer ) && ( offset == rhs.offset ) && ( range == rhs.range );
#  endif
    }

    bool operator!=( DescriptorBufferInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Buffer     buffer = {};
    VULKAN_HPP_NAMESPACE::DeviceSize offset = {};
    VULKAN_HPP_NAMESPACE::DeviceSize range  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorBufferInfo ) == sizeof( VkDescriptorBufferInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorBufferInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorBufferInfo>::value,
                            "DescriptorBufferInfo is not nothrow_move_constructible!" );

  struct DescriptorImageInfo
  {
    using NativeType = VkDescriptorImageInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DescriptorImageInfo( VULKAN_HPP_NAMESPACE::Sampler     sampler_     = {},
                           VULKAN_HPP_NAMESPACE::ImageView   imageView_   = {},
                           VULKAN_HPP_NAMESPACE::ImageLayout imageLayout_ = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined ) VULKAN_HPP_NOEXCEPT
      : sampler( sampler_ )
      , imageView( imageView_ )
      , imageLayout( imageLayout_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorImageInfo( DescriptorImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorImageInfo( VkDescriptorImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT : DescriptorImageInfo( *reinterpret_cast<DescriptorImageInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorImageInfo & operator=( DescriptorImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorImageInfo & operator=( VkDescriptorImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorImageInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorImageInfo & setSampler( VULKAN_HPP_NAMESPACE::Sampler sampler_ ) VULKAN_HPP_NOEXCEPT
    {
      sampler = sampler_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorImageInfo & setImageView( VULKAN_HPP_NAMESPACE::ImageView imageView_ ) VULKAN_HPP_NOEXCEPT
    {
      imageView = imageView_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorImageInfo & setImageLayout( VULKAN_HPP_NAMESPACE::ImageLayout imageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      imageLayout = imageLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorImageInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorImageInfo *>( this );
    }

    explicit operator VkDescriptorImageInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorImageInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Sampler const &, VULKAN_HPP_NAMESPACE::ImageView const &, VULKAN_HPP_NAMESPACE::ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sampler, imageView, imageLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorImageInfo const & ) const = default;
#else
    bool operator==( DescriptorImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sampler == rhs.sampler ) && ( imageView == rhs.imageView ) && ( imageLayout == rhs.imageLayout );
#  endif
    }

    bool operator!=( DescriptorImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Sampler     sampler     = {};
    VULKAN_HPP_NAMESPACE::ImageView   imageView   = {};
    VULKAN_HPP_NAMESPACE::ImageLayout imageLayout = VULKAN_HPP_NAMESPACE::ImageLayout::eUndefined;
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorImageInfo ) == sizeof( VkDescriptorImageInfo ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorImageInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorImageInfo>::value,
                            "DescriptorImageInfo is not nothrow_move_constructible!" );

  struct DescriptorPoolSize
  {
    using NativeType = VkDescriptorPoolSize;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorPoolSize( VULKAN_HPP_NAMESPACE::DescriptorType type_            = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler,
                                             uint32_t                             descriptorCount_ = {} ) VULKAN_HPP_NOEXCEPT
      : type( type_ )
      , descriptorCount( descriptorCount_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorPoolSize( DescriptorPoolSize const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolSize( VkDescriptorPoolSize const & rhs ) VULKAN_HPP_NOEXCEPT : DescriptorPoolSize( *reinterpret_cast<DescriptorPoolSize const *>( &rhs ) ) {}
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorPoolSize & operator=( DescriptorPoolSize const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolSize & operator=( VkDescriptorPoolSize const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorPoolSize const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolSize & setType( VULKAN_HPP_NAMESPACE::DescriptorType type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolSize & setDescriptorCount( uint32_t descriptorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount = descriptorCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorPoolSize const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorPoolSize *>( this );
    }

    explicit operator VkDescriptorPoolSize &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorPoolSize *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::DescriptorType const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( type, descriptorCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorPoolSize const & ) const = default;
#else
    bool operator==( DescriptorPoolSize const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( type == rhs.type ) && ( descriptorCount == rhs.descriptorCount );
#  endif
    }

    bool operator!=( DescriptorPoolSize const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::DescriptorType type            = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler;
    uint32_t                             descriptorCount = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorPoolSize ) == sizeof( VkDescriptorPoolSize ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorPoolSize>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorPoolSize>::value,
                            "DescriptorPoolSize is not nothrow_move_constructible!" );

  struct DescriptorPoolCreateInfo
  {
    using NativeType = VkDescriptorPoolCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorPoolCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorPoolCreateInfo( VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags  flags_         = {},
                                                   uint32_t                                         maxSets_       = {},
                                                   uint32_t                                         poolSizeCount_ = {},
                                                   const VULKAN_HPP_NAMESPACE::DescriptorPoolSize * pPoolSizes_    = {},
                                                   const void *                                     pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , maxSets( maxSets_ )
      , poolSizeCount( poolSizeCount_ )
      , pPoolSizes( pPoolSizes_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorPoolCreateInfo( DescriptorPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolCreateInfo( VkDescriptorPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorPoolCreateInfo( *reinterpret_cast<DescriptorPoolCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorPoolCreateInfo( VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags                                                       flags_,
                              uint32_t                                                                                              maxSets_,
                              VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorPoolSize> const & poolSizes_,
                              const void *                                                                                          pNext_ = nullptr )
      : pNext( pNext_ ), flags( flags_ ), maxSets( maxSets_ ), poolSizeCount( static_cast<uint32_t>( poolSizes_.size() ) ), pPoolSizes( poolSizes_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorPoolCreateInfo & operator=( DescriptorPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolCreateInfo & operator=( VkDescriptorPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorPoolCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo & setMaxSets( uint32_t maxSets_ ) VULKAN_HPP_NOEXCEPT
    {
      maxSets = maxSets_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo & setPoolSizeCount( uint32_t poolSizeCount_ ) VULKAN_HPP_NOEXCEPT
    {
      poolSizeCount = poolSizeCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolCreateInfo & setPPoolSizes( const VULKAN_HPP_NAMESPACE::DescriptorPoolSize * pPoolSizes_ ) VULKAN_HPP_NOEXCEPT
    {
      pPoolSizes = pPoolSizes_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorPoolCreateInfo &
      setPoolSizes( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorPoolSize> const & poolSizes_ ) VULKAN_HPP_NOEXCEPT
    {
      poolSizeCount = static_cast<uint32_t>( poolSizes_.size() );
      pPoolSizes    = poolSizes_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorPoolCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorPoolCreateInfo *>( this );
    }

    explicit operator VkDescriptorPoolCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorPoolCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags const &,
               uint32_t const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DescriptorPoolSize * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, maxSets, poolSizeCount, pPoolSizes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorPoolCreateInfo const & ) const = default;
#else
    bool operator==( DescriptorPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( maxSets == rhs.maxSets ) &&
             ( poolSizeCount == rhs.poolSizeCount ) && ( pPoolSizes == rhs.pPoolSizes );
#  endif
    }

    bool operator!=( DescriptorPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType              sType         = StructureType::eDescriptorPoolCreateInfo;
    const void *                                     pNext         = {};
    VULKAN_HPP_NAMESPACE::DescriptorPoolCreateFlags  flags         = {};
    uint32_t                                         maxSets       = {};
    uint32_t                                         poolSizeCount = {};
    const VULKAN_HPP_NAMESPACE::DescriptorPoolSize * pPoolSizes    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorPoolCreateInfo ) == sizeof( VkDescriptorPoolCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorPoolCreateInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorPoolCreateInfo>::value,
                            "DescriptorPoolCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorPoolCreateInfo>
  {
    using Type = DescriptorPoolCreateInfo;
  };

  struct DescriptorPoolInlineUniformBlockCreateInfo
  {
    using NativeType = VkDescriptorPoolInlineUniformBlockCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorPoolInlineUniformBlockCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorPoolInlineUniformBlockCreateInfo( uint32_t     maxInlineUniformBlockBindings_ = {},
                                                                     const void * pNext_                         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , maxInlineUniformBlockBindings( maxInlineUniformBlockBindings_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorPoolInlineUniformBlockCreateInfo( DescriptorPoolInlineUniformBlockCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolInlineUniformBlockCreateInfo( VkDescriptorPoolInlineUniformBlockCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorPoolInlineUniformBlockCreateInfo( *reinterpret_cast<DescriptorPoolInlineUniformBlockCreateInfo const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorPoolInlineUniformBlockCreateInfo & operator=( DescriptorPoolInlineUniformBlockCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorPoolInlineUniformBlockCreateInfo & operator=( VkDescriptorPoolInlineUniformBlockCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorPoolInlineUniformBlockCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolInlineUniformBlockCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorPoolInlineUniformBlockCreateInfo &
                            setMaxInlineUniformBlockBindings( uint32_t maxInlineUniformBlockBindings_ ) VULKAN_HPP_NOEXCEPT
    {
      maxInlineUniformBlockBindings = maxInlineUniformBlockBindings_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorPoolInlineUniformBlockCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorPoolInlineUniformBlockCreateInfo *>( this );
    }

    explicit operator VkDescriptorPoolInlineUniformBlockCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorPoolInlineUniformBlockCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, maxInlineUniformBlockBindings );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorPoolInlineUniformBlockCreateInfo const & ) const = default;
#else
    bool operator==( DescriptorPoolInlineUniformBlockCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( maxInlineUniformBlockBindings == rhs.maxInlineUniformBlockBindings );
#  endif
    }

    bool operator!=( DescriptorPoolInlineUniformBlockCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                         = StructureType::eDescriptorPoolInlineUniformBlockCreateInfo;
    const void *                        pNext                         = {};
    uint32_t                            maxInlineUniformBlockBindings = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorPoolInlineUniformBlockCreateInfo ) ==
                              sizeof( VkDescriptorPoolInlineUniformBlockCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorPoolInlineUniformBlockCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorPoolInlineUniformBlockCreateInfo>::value,
                            "DescriptorPoolInlineUniformBlockCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorPoolInlineUniformBlockCreateInfo>
  {
    using Type = DescriptorPoolInlineUniformBlockCreateInfo;
  };
  using DescriptorPoolInlineUniformBlockCreateInfoEXT = DescriptorPoolInlineUniformBlockCreateInfo;

  struct DescriptorSetAllocateInfo
  {
    using NativeType = VkDescriptorSetAllocateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetAllocateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetAllocateInfo( VULKAN_HPP_NAMESPACE::DescriptorPool              descriptorPool_     = {},
                                                    uint32_t                                          descriptorSetCount_ = {},
                                                    const VULKAN_HPP_NAMESPACE::DescriptorSetLayout * pSetLayouts_        = {},
                                                    const void *                                      pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , descriptorPool( descriptorPool_ )
      , descriptorSetCount( descriptorSetCount_ )
      , pSetLayouts( pSetLayouts_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorSetAllocateInfo( DescriptorSetAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetAllocateInfo( VkDescriptorSetAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetAllocateInfo( *reinterpret_cast<DescriptorSetAllocateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetAllocateInfo( VULKAN_HPP_NAMESPACE::DescriptorPool                                                                   descriptorPool_,
                               VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSetLayout> const & setLayouts_,
                               const void *                                                                                           pNext_ = nullptr )
      : pNext( pNext_ ), descriptorPool( descriptorPool_ ), descriptorSetCount( static_cast<uint32_t>( setLayouts_.size() ) ), pSetLayouts( setLayouts_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetAllocateInfo & operator=( DescriptorSetAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetAllocateInfo & operator=( VkDescriptorSetAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetAllocateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetAllocateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetAllocateInfo & setDescriptorPool( VULKAN_HPP_NAMESPACE::DescriptorPool descriptorPool_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorPool = descriptorPool_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetAllocateInfo & setDescriptorSetCount( uint32_t descriptorSetCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = descriptorSetCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetAllocateInfo & setPSetLayouts( const VULKAN_HPP_NAMESPACE::DescriptorSetLayout * pSetLayouts_ ) VULKAN_HPP_NOEXCEPT
    {
      pSetLayouts = pSetLayouts_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetAllocateInfo &
      setSetLayouts( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSetLayout> const & setLayouts_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = static_cast<uint32_t>( setLayouts_.size() );
      pSetLayouts        = setLayouts_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorSetAllocateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetAllocateInfo *>( this );
    }

    explicit operator VkDescriptorSetAllocateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetAllocateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DescriptorPool const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DescriptorSetLayout * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, descriptorPool, descriptorSetCount, pSetLayouts );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetAllocateInfo const & ) const = default;
#else
    bool operator==( DescriptorSetAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( descriptorPool == rhs.descriptorPool ) && ( descriptorSetCount == rhs.descriptorSetCount ) &&
             ( pSetLayouts == rhs.pSetLayouts );
#  endif
    }

    bool operator!=( DescriptorSetAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType               sType              = StructureType::eDescriptorSetAllocateInfo;
    const void *                                      pNext              = {};
    VULKAN_HPP_NAMESPACE::DescriptorPool              descriptorPool     = {};
    uint32_t                                          descriptorSetCount = {};
    const VULKAN_HPP_NAMESPACE::DescriptorSetLayout * pSetLayouts        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetAllocateInfo ) == sizeof( VkDescriptorSetAllocateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetAllocateInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetAllocateInfo>::value,
                            "DescriptorSetAllocateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetAllocateInfo>
  {
    using Type = DescriptorSetAllocateInfo;
  };

  struct DescriptorSetBindingReferenceVALVE
  {
    using NativeType = VkDescriptorSetBindingReferenceVALVE;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetBindingReferenceVALVE;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetBindingReferenceVALVE( VULKAN_HPP_NAMESPACE::DescriptorSetLayout descriptorSetLayout_ = {},
                                                             uint32_t                                  binding_             = {},
                                                             const void *                              pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , descriptorSetLayout( descriptorSetLayout_ )
      , binding( binding_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorSetBindingReferenceVALVE( DescriptorSetBindingReferenceVALVE const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetBindingReferenceVALVE( VkDescriptorSetBindingReferenceVALVE const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetBindingReferenceVALVE( *reinterpret_cast<DescriptorSetBindingReferenceVALVE const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetBindingReferenceVALVE & operator=( DescriptorSetBindingReferenceVALVE const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetBindingReferenceVALVE & operator=( VkDescriptorSetBindingReferenceVALVE const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetBindingReferenceVALVE const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetBindingReferenceVALVE & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetBindingReferenceVALVE &
                            setDescriptorSetLayout( VULKAN_HPP_NAMESPACE::DescriptorSetLayout descriptorSetLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetLayout = descriptorSetLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetBindingReferenceVALVE & setBinding( uint32_t binding_ ) VULKAN_HPP_NOEXCEPT
    {
      binding = binding_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorSetBindingReferenceVALVE const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetBindingReferenceVALVE *>( this );
    }

    explicit operator VkDescriptorSetBindingReferenceVALVE &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetBindingReferenceVALVE *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, VULKAN_HPP_NAMESPACE::DescriptorSetLayout const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, descriptorSetLayout, binding );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetBindingReferenceVALVE const & ) const = default;
#else
    bool operator==( DescriptorSetBindingReferenceVALVE const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( descriptorSetLayout == rhs.descriptorSetLayout ) && ( binding == rhs.binding );
#  endif
    }

    bool operator!=( DescriptorSetBindingReferenceVALVE const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType       sType               = StructureType::eDescriptorSetBindingReferenceVALVE;
    const void *                              pNext               = {};
    VULKAN_HPP_NAMESPACE::DescriptorSetLayout descriptorSetLayout = {};
    uint32_t                                  binding             = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetBindingReferenceVALVE ) == sizeof( VkDescriptorSetBindingReferenceVALVE ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetBindingReferenceVALVE>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetBindingReferenceVALVE>::value,
                            "DescriptorSetBindingReferenceVALVE is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetBindingReferenceVALVE>
  {
    using Type = DescriptorSetBindingReferenceVALVE;
  };

  struct DescriptorSetLayoutBinding
  {
    using NativeType = VkDescriptorSetLayoutBinding;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutBinding( uint32_t                               binding_         = {},
                                                     VULKAN_HPP_NAMESPACE::DescriptorType   descriptorType_  = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler,
                                                     uint32_t                               descriptorCount_ = {},
                                                     VULKAN_HPP_NAMESPACE::ShaderStageFlags stageFlags_      = {},
                                                     const VULKAN_HPP_NAMESPACE::Sampler *  pImmutableSamplers_ = {} ) VULKAN_HPP_NOEXCEPT
      : binding( binding_ )
      , descriptorType( descriptorType_ )
      , descriptorCount( descriptorCount_ )
      , stageFlags( stageFlags_ )
      , pImmutableSamplers( pImmutableSamplers_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutBinding( DescriptorSetLayoutBinding const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutBinding( VkDescriptorSetLayoutBinding const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetLayoutBinding( *reinterpret_cast<DescriptorSetLayoutBinding const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutBinding( uint32_t                                                                                   binding_,
                                VULKAN_HPP_NAMESPACE::DescriptorType                                                       descriptorType_,
                                VULKAN_HPP_NAMESPACE::ShaderStageFlags                                                     stageFlags_,
                                VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Sampler> const & immutableSamplers_ )
      : binding( binding_ )
      , descriptorType( descriptorType_ )
      , descriptorCount( static_cast<uint32_t>( immutableSamplers_.size() ) )
      , stageFlags( stageFlags_ )
      , pImmutableSamplers( immutableSamplers_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetLayoutBinding & operator=( DescriptorSetLayoutBinding const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutBinding & operator=( VkDescriptorSetLayoutBinding const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding & setBinding( uint32_t binding_ ) VULKAN_HPP_NOEXCEPT
    {
      binding = binding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding & setDescriptorType( VULKAN_HPP_NAMESPACE::DescriptorType descriptorType_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorType = descriptorType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding & setDescriptorCount( uint32_t descriptorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount = descriptorCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding & setStageFlags( VULKAN_HPP_NAMESPACE::ShaderStageFlags stageFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      stageFlags = stageFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBinding & setPImmutableSamplers( const VULKAN_HPP_NAMESPACE::Sampler * pImmutableSamplers_ ) VULKAN_HPP_NOEXCEPT
    {
      pImmutableSamplers = pImmutableSamplers_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutBinding &
      setImmutableSamplers( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::Sampler> const & immutableSamplers_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount    = static_cast<uint32_t>( immutableSamplers_.size() );
      pImmutableSamplers = immutableSamplers_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorSetLayoutBinding const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetLayoutBinding *>( this );
    }

    explicit operator VkDescriptorSetLayoutBinding &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetLayoutBinding *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &,
               VULKAN_HPP_NAMESPACE::DescriptorType const &,
               uint32_t const &,
               VULKAN_HPP_NAMESPACE::ShaderStageFlags const &,
               const VULKAN_HPP_NAMESPACE::Sampler * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( binding, descriptorType, descriptorCount, stageFlags, pImmutableSamplers );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetLayoutBinding const & ) const = default;
#else
    bool operator==( DescriptorSetLayoutBinding const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( binding == rhs.binding ) && ( descriptorType == rhs.descriptorType ) && ( descriptorCount == rhs.descriptorCount ) &&
             ( stageFlags == rhs.stageFlags ) && ( pImmutableSamplers == rhs.pImmutableSamplers );
#  endif
    }

    bool operator!=( DescriptorSetLayoutBinding const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                               binding            = {};
    VULKAN_HPP_NAMESPACE::DescriptorType   descriptorType     = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler;
    uint32_t                               descriptorCount    = {};
    VULKAN_HPP_NAMESPACE::ShaderStageFlags stageFlags         = {};
    const VULKAN_HPP_NAMESPACE::Sampler *  pImmutableSamplers = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding ) == sizeof( VkDescriptorSetLayoutBinding ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding>::value,
                            "DescriptorSetLayoutBinding is not nothrow_move_constructible!" );

  struct DescriptorSetLayoutBindingFlagsCreateInfo
  {
    using NativeType = VkDescriptorSetLayoutBindingFlagsCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetLayoutBindingFlagsCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutBindingFlagsCreateInfo( uint32_t                                             bindingCount_  = {},
                                                                    const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags * pBindingFlags_ = {},
                                                                    const void *                                         pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , bindingCount( bindingCount_ )
      , pBindingFlags( pBindingFlags_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutBindingFlagsCreateInfo( DescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutBindingFlagsCreateInfo( VkDescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetLayoutBindingFlagsCreateInfo( *reinterpret_cast<DescriptorSetLayoutBindingFlagsCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutBindingFlagsCreateInfo(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags> const & bindingFlags_, const void * pNext_ = nullptr )
      : pNext( pNext_ ), bindingCount( static_cast<uint32_t>( bindingFlags_.size() ) ), pBindingFlags( bindingFlags_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetLayoutBindingFlagsCreateInfo & operator=( DescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutBindingFlagsCreateInfo & operator=( VkDescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBindingFlagsCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBindingFlagsCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBindingFlagsCreateInfo & setBindingCount( uint32_t bindingCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindingCount = bindingCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutBindingFlagsCreateInfo &
                            setPBindingFlags( const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags * pBindingFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      pBindingFlags = pBindingFlags_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutBindingFlagsCreateInfo & setBindingFlags(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags> const & bindingFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      bindingCount  = static_cast<uint32_t>( bindingFlags_.size() );
      pBindingFlags = bindingFlags_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorSetLayoutBindingFlagsCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetLayoutBindingFlagsCreateInfo *>( this );
    }

    explicit operator VkDescriptorSetLayoutBindingFlagsCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetLayoutBindingFlagsCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::
      tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &, const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, bindingCount, pBindingFlags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetLayoutBindingFlagsCreateInfo const & ) const = default;
#else
    bool operator==( DescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( bindingCount == rhs.bindingCount ) && ( pBindingFlags == rhs.pBindingFlags );
#  endif
    }

    bool operator!=( DescriptorSetLayoutBindingFlagsCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType         = StructureType::eDescriptorSetLayoutBindingFlagsCreateInfo;
    const void *                                         pNext         = {};
    uint32_t                                             bindingCount  = {};
    const VULKAN_HPP_NAMESPACE::DescriptorBindingFlags * pBindingFlags = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBindingFlagsCreateInfo ) == sizeof( VkDescriptorSetLayoutBindingFlagsCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBindingFlagsCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBindingFlagsCreateInfo>::value,
                            "DescriptorSetLayoutBindingFlagsCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetLayoutBindingFlagsCreateInfo>
  {
    using Type = DescriptorSetLayoutBindingFlagsCreateInfo;
  };
  using DescriptorSetLayoutBindingFlagsCreateInfoEXT = DescriptorSetLayoutBindingFlagsCreateInfo;

  struct DescriptorSetLayoutCreateInfo
  {
    using NativeType = VkDescriptorSetLayoutCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetLayoutCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutCreateInfo( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags     flags_        = {},
                                                        uint32_t                                                 bindingCount_ = {},
                                                        const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding * pBindings_    = {},
                                                        const void *                                             pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , bindingCount( bindingCount_ )
      , pBindings( pBindings_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutCreateInfo( DescriptorSetLayoutCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutCreateInfo( VkDescriptorSetLayoutCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetLayoutCreateInfo( *reinterpret_cast<DescriptorSetLayoutCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutCreateInfo( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags                                                          flags_,
                                   VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding> const & bindings_,
                                   const void * pNext_ = nullptr )
      : pNext( pNext_ ), flags( flags_ ), bindingCount( static_cast<uint32_t>( bindings_.size() ) ), pBindings( bindings_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetLayoutCreateInfo & operator=( DescriptorSetLayoutCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutCreateInfo & operator=( VkDescriptorSetLayoutCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutCreateInfo & setBindingCount( uint32_t bindingCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindingCount = bindingCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutCreateInfo &
                            setPBindings( const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding * pBindings_ ) VULKAN_HPP_NOEXCEPT
    {
      pBindings = pBindings_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetLayoutCreateInfo &
      setBindings( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding> const & bindings_ ) VULKAN_HPP_NOEXCEPT
    {
      bindingCount = static_cast<uint32_t>( bindings_.size() );
      pBindings    = bindings_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorSetLayoutCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetLayoutCreateInfo *>( this );
    }

    explicit operator VkDescriptorSetLayoutCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetLayoutCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, bindingCount, pBindings );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetLayoutCreateInfo const & ) const = default;
#else
    bool operator==( DescriptorSetLayoutCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( bindingCount == rhs.bindingCount ) &&
             ( pBindings == rhs.pBindings );
#  endif
    }

    bool operator!=( DescriptorSetLayoutCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                      sType        = StructureType::eDescriptorSetLayoutCreateInfo;
    const void *                                             pNext        = {};
    VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateFlags     flags        = {};
    uint32_t                                                 bindingCount = {};
    const VULKAN_HPP_NAMESPACE::DescriptorSetLayoutBinding * pBindings    = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateInfo ) == sizeof( VkDescriptorSetLayoutCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutCreateInfo>::value,
                            "DescriptorSetLayoutCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetLayoutCreateInfo>
  {
    using Type = DescriptorSetLayoutCreateInfo;
  };

  struct DescriptorSetLayoutHostMappingInfoVALVE
  {
    using NativeType = VkDescriptorSetLayoutHostMappingInfoVALVE;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetLayoutHostMappingInfoVALVE;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      DescriptorSetLayoutHostMappingInfoVALVE( size_t descriptorOffset_ = {}, uint32_t descriptorSize_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , descriptorOffset( descriptorOffset_ )
      , descriptorSize( descriptorSize_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutHostMappingInfoVALVE( DescriptorSetLayoutHostMappingInfoVALVE const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutHostMappingInfoVALVE( VkDescriptorSetLayoutHostMappingInfoVALVE const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetLayoutHostMappingInfoVALVE( *reinterpret_cast<DescriptorSetLayoutHostMappingInfoVALVE const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetLayoutHostMappingInfoVALVE & operator=( DescriptorSetLayoutHostMappingInfoVALVE const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutHostMappingInfoVALVE & operator=( VkDescriptorSetLayoutHostMappingInfoVALVE const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutHostMappingInfoVALVE const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutHostMappingInfoVALVE & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutHostMappingInfoVALVE & setDescriptorOffset( size_t descriptorOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorOffset = descriptorOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetLayoutHostMappingInfoVALVE & setDescriptorSize( uint32_t descriptorSize_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSize = descriptorSize_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorSetLayoutHostMappingInfoVALVE const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetLayoutHostMappingInfoVALVE *>( this );
    }

    explicit operator VkDescriptorSetLayoutHostMappingInfoVALVE &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetLayoutHostMappingInfoVALVE *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, size_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, descriptorOffset, descriptorSize );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetLayoutHostMappingInfoVALVE const & ) const = default;
#else
    bool operator==( DescriptorSetLayoutHostMappingInfoVALVE const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( descriptorOffset == rhs.descriptorOffset ) && ( descriptorSize == rhs.descriptorSize );
#  endif
    }

    bool operator!=( DescriptorSetLayoutHostMappingInfoVALVE const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType            = StructureType::eDescriptorSetLayoutHostMappingInfoVALVE;
    void *                              pNext            = {};
    size_t                              descriptorOffset = {};
    uint32_t                            descriptorSize   = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutHostMappingInfoVALVE ) == sizeof( VkDescriptorSetLayoutHostMappingInfoVALVE ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutHostMappingInfoVALVE>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutHostMappingInfoVALVE>::value,
                            "DescriptorSetLayoutHostMappingInfoVALVE is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetLayoutHostMappingInfoVALVE>
  {
    using Type = DescriptorSetLayoutHostMappingInfoVALVE;
  };

  struct DescriptorSetLayoutSupport
  {
    using NativeType = VkDescriptorSetLayoutSupport;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetLayoutSupport;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutSupport( VULKAN_HPP_NAMESPACE::Bool32 supported_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , supported( supported_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorSetLayoutSupport( DescriptorSetLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutSupport( VkDescriptorSetLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetLayoutSupport( *reinterpret_cast<DescriptorSetLayoutSupport const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetLayoutSupport & operator=( DescriptorSetLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetLayoutSupport & operator=( VkDescriptorSetLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutSupport const *>( &rhs );
      return *this;
    }

    explicit operator VkDescriptorSetLayoutSupport const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetLayoutSupport *>( this );
    }

    explicit operator VkDescriptorSetLayoutSupport &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetLayoutSupport *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, supported );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetLayoutSupport const & ) const = default;
#else
    bool operator==( DescriptorSetLayoutSupport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( supported == rhs.supported );
#  endif
    }

    bool operator!=( DescriptorSetLayoutSupport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType     = StructureType::eDescriptorSetLayoutSupport;
    void *                              pNext     = {};
    VULKAN_HPP_NAMESPACE::Bool32        supported = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetLayoutSupport ) == sizeof( VkDescriptorSetLayoutSupport ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutSupport>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetLayoutSupport>::value,
                            "DescriptorSetLayoutSupport is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetLayoutSupport>
  {
    using Type = DescriptorSetLayoutSupport;
  };
  using DescriptorSetLayoutSupportKHR = DescriptorSetLayoutSupport;

  struct DescriptorSetVariableDescriptorCountAllocateInfo
  {
    using NativeType = VkDescriptorSetVariableDescriptorCountAllocateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetVariableDescriptorCountAllocateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetVariableDescriptorCountAllocateInfo( uint32_t         descriptorSetCount_ = {},
                                                                           const uint32_t * pDescriptorCounts_  = {},
                                                                           const void *     pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , descriptorSetCount( descriptorSetCount_ )
      , pDescriptorCounts( pDescriptorCounts_ )
    {
    }

    VULKAN_HPP_CONSTEXPR
      DescriptorSetVariableDescriptorCountAllocateInfo( DescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetVariableDescriptorCountAllocateInfo( VkDescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetVariableDescriptorCountAllocateInfo( *reinterpret_cast<DescriptorSetVariableDescriptorCountAllocateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetVariableDescriptorCountAllocateInfo( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & descriptorCounts_,
                                                      const void *                                                          pNext_ = nullptr )
      : pNext( pNext_ ), descriptorSetCount( static_cast<uint32_t>( descriptorCounts_.size() ) ), pDescriptorCounts( descriptorCounts_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetVariableDescriptorCountAllocateInfo & operator=( DescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetVariableDescriptorCountAllocateInfo & operator=( VkDescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountAllocateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorSetVariableDescriptorCountAllocateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetVariableDescriptorCountAllocateInfo & setDescriptorSetCount( uint32_t descriptorSetCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = descriptorSetCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorSetVariableDescriptorCountAllocateInfo & setPDescriptorCounts( const uint32_t * pDescriptorCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      pDescriptorCounts = pDescriptorCounts_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorSetVariableDescriptorCountAllocateInfo &
      setDescriptorCounts( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const uint32_t> const & descriptorCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = static_cast<uint32_t>( descriptorCounts_.size() );
      pDescriptorCounts  = descriptorCounts_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorSetVariableDescriptorCountAllocateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetVariableDescriptorCountAllocateInfo *>( this );
    }

    explicit operator VkDescriptorSetVariableDescriptorCountAllocateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetVariableDescriptorCountAllocateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, uint32_t const &, const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, descriptorSetCount, pDescriptorCounts );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetVariableDescriptorCountAllocateInfo const & ) const = default;
#else
    bool operator==( DescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( descriptorSetCount == rhs.descriptorSetCount ) &&
             ( pDescriptorCounts == rhs.pDescriptorCounts );
#  endif
    }

    bool operator!=( DescriptorSetVariableDescriptorCountAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType              = StructureType::eDescriptorSetVariableDescriptorCountAllocateInfo;
    const void *                        pNext              = {};
    uint32_t                            descriptorSetCount = {};
    const uint32_t *                    pDescriptorCounts  = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountAllocateInfo ) ==
                              sizeof( VkDescriptorSetVariableDescriptorCountAllocateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountAllocateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountAllocateInfo>::value,
                            "DescriptorSetVariableDescriptorCountAllocateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetVariableDescriptorCountAllocateInfo>
  {
    using Type = DescriptorSetVariableDescriptorCountAllocateInfo;
  };
  using DescriptorSetVariableDescriptorCountAllocateInfoEXT = DescriptorSetVariableDescriptorCountAllocateInfo;

  struct DescriptorSetVariableDescriptorCountLayoutSupport
  {
    using NativeType = VkDescriptorSetVariableDescriptorCountLayoutSupport;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorSetVariableDescriptorCountLayoutSupport;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorSetVariableDescriptorCountLayoutSupport( uint32_t maxVariableDescriptorCount_ = {},
                                                                            void *   pNext_                      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , maxVariableDescriptorCount( maxVariableDescriptorCount_ )
    {
    }

    VULKAN_HPP_CONSTEXPR
      DescriptorSetVariableDescriptorCountLayoutSupport( DescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetVariableDescriptorCountLayoutSupport( VkDescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorSetVariableDescriptorCountLayoutSupport( *reinterpret_cast<DescriptorSetVariableDescriptorCountLayoutSupport const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorSetVariableDescriptorCountLayoutSupport &
      operator=( DescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorSetVariableDescriptorCountLayoutSupport & operator=( VkDescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountLayoutSupport const *>( &rhs );
      return *this;
    }

    explicit operator VkDescriptorSetVariableDescriptorCountLayoutSupport const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorSetVariableDescriptorCountLayoutSupport *>( this );
    }

    explicit operator VkDescriptorSetVariableDescriptorCountLayoutSupport &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorSetVariableDescriptorCountLayoutSupport *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, void * const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, maxVariableDescriptorCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorSetVariableDescriptorCountLayoutSupport const & ) const = default;
#else
    bool operator==( DescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( maxVariableDescriptorCount == rhs.maxVariableDescriptorCount );
#  endif
    }

    bool operator!=( DescriptorSetVariableDescriptorCountLayoutSupport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType sType                      = StructureType::eDescriptorSetVariableDescriptorCountLayoutSupport;
    void *                              pNext                      = {};
    uint32_t                            maxVariableDescriptorCount = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountLayoutSupport ) ==
                              sizeof( VkDescriptorSetVariableDescriptorCountLayoutSupport ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountLayoutSupport>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorSetVariableDescriptorCountLayoutSupport>::value,
                            "DescriptorSetVariableDescriptorCountLayoutSupport is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorSetVariableDescriptorCountLayoutSupport>
  {
    using Type = DescriptorSetVariableDescriptorCountLayoutSupport;
  };
  using DescriptorSetVariableDescriptorCountLayoutSupportEXT = DescriptorSetVariableDescriptorCountLayoutSupport;

  struct DescriptorUpdateTemplateEntry
  {
    using NativeType = VkDescriptorUpdateTemplateEntry;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorUpdateTemplateEntry( uint32_t                             dstBinding_      = {},
                                                        uint32_t                             dstArrayElement_ = {},
                                                        uint32_t                             descriptorCount_ = {},
                                                        VULKAN_HPP_NAMESPACE::DescriptorType descriptorType_  = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler,
                                                        size_t                               offset_          = {},
                                                        size_t                               stride_          = {} ) VULKAN_HPP_NOEXCEPT
      : dstBinding( dstBinding_ )
      , dstArrayElement( dstArrayElement_ )
      , descriptorCount( descriptorCount_ )
      , descriptorType( descriptorType_ )
      , offset( offset_ )
      , stride( stride_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorUpdateTemplateEntry( DescriptorUpdateTemplateEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorUpdateTemplateEntry( VkDescriptorUpdateTemplateEntry const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorUpdateTemplateEntry( *reinterpret_cast<DescriptorUpdateTemplateEntry const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorUpdateTemplateEntry & operator=( DescriptorUpdateTemplateEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorUpdateTemplateEntry & operator=( VkDescriptorUpdateTemplateEntry const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateEntry & setDstBinding( uint32_t dstBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBinding = dstBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateEntry & setDstArrayElement( uint32_t dstArrayElement_ ) VULKAN_HPP_NOEXCEPT
    {
      dstArrayElement = dstArrayElement_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateEntry & setDescriptorCount( uint32_t descriptorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount = descriptorCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateEntry & setDescriptorType( VULKAN_HPP_NAMESPACE::DescriptorType descriptorType_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorType = descriptorType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateEntry & setOffset( size_t offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateEntry & setStride( size_t stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorUpdateTemplateEntry const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorUpdateTemplateEntry *>( this );
    }

    explicit operator VkDescriptorUpdateTemplateEntry &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorUpdateTemplateEntry *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &, VULKAN_HPP_NAMESPACE::DescriptorType const &, size_t const &, size_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( dstBinding, dstArrayElement, descriptorCount, descriptorType, offset, stride );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorUpdateTemplateEntry const & ) const = default;
#else
    bool operator==( DescriptorUpdateTemplateEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( dstBinding == rhs.dstBinding ) && ( dstArrayElement == rhs.dstArrayElement ) && ( descriptorCount == rhs.descriptorCount ) &&
             ( descriptorType == rhs.descriptorType ) && ( offset == rhs.offset ) && ( stride == rhs.stride );
#  endif
    }

    bool operator!=( DescriptorUpdateTemplateEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                             dstBinding      = {};
    uint32_t                             dstArrayElement = {};
    uint32_t                             descriptorCount = {};
    VULKAN_HPP_NAMESPACE::DescriptorType descriptorType  = VULKAN_HPP_NAMESPACE::DescriptorType::eSampler;
    size_t                               offset          = {};
    size_t                               stride          = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry ) == sizeof( VkDescriptorUpdateTemplateEntry ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry>::value,
                            "DescriptorUpdateTemplateEntry is not nothrow_move_constructible!" );
  using DescriptorUpdateTemplateEntryKHR = DescriptorUpdateTemplateEntry;

  struct DescriptorUpdateTemplateCreateInfo
  {
    using NativeType = VkDescriptorUpdateTemplateCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDescriptorUpdateTemplateCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DescriptorUpdateTemplateCreateInfo(
      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateFlags   flags_                      = {},
      uint32_t                                                    descriptorUpdateEntryCount_ = {},
      const VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry * pDescriptorUpdateEntries_   = {},
      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType          templateType_        = VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType::eDescriptorSet,
      VULKAN_HPP_NAMESPACE::DescriptorSetLayout                   descriptorSetLayout_ = {},
      VULKAN_HPP_NAMESPACE::PipelineBindPoint                     pipelineBindPoint_   = VULKAN_HPP_NAMESPACE::PipelineBindPoint::eGraphics,
      VULKAN_HPP_NAMESPACE::PipelineLayout                        pipelineLayout_      = {},
      uint32_t                                                    set_                 = {},
      const void *                                                pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , descriptorUpdateEntryCount( descriptorUpdateEntryCount_ )
      , pDescriptorUpdateEntries( pDescriptorUpdateEntries_ )
      , templateType( templateType_ )
      , descriptorSetLayout( descriptorSetLayout_ )
      , pipelineBindPoint( pipelineBindPoint_ )
      , pipelineLayout( pipelineLayout_ )
      , set( set_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DescriptorUpdateTemplateCreateInfo( DescriptorUpdateTemplateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorUpdateTemplateCreateInfo( VkDescriptorUpdateTemplateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DescriptorUpdateTemplateCreateInfo( *reinterpret_cast<DescriptorUpdateTemplateCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorUpdateTemplateCreateInfo(
      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateFlags                                                        flags_,
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry> const & descriptorUpdateEntries_,
      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType templateType_        = VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType::eDescriptorSet,
      VULKAN_HPP_NAMESPACE::DescriptorSetLayout          descriptorSetLayout_ = {},
      VULKAN_HPP_NAMESPACE::PipelineBindPoint            pipelineBindPoint_   = VULKAN_HPP_NAMESPACE::PipelineBindPoint::eGraphics,
      VULKAN_HPP_NAMESPACE::PipelineLayout               pipelineLayout_      = {},
      uint32_t                                           set_                 = {},
      const void *                                       pNext_               = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , descriptorUpdateEntryCount( static_cast<uint32_t>( descriptorUpdateEntries_.size() ) )
      , pDescriptorUpdateEntries( descriptorUpdateEntries_.data() )
      , templateType( templateType_ )
      , descriptorSetLayout( descriptorSetLayout_ )
      , pipelineBindPoint( pipelineBindPoint_ )
      , pipelineLayout( pipelineLayout_ )
      , set( set_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DescriptorUpdateTemplateCreateInfo & operator=( DescriptorUpdateTemplateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DescriptorUpdateTemplateCreateInfo & operator=( VkDescriptorUpdateTemplateCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo &
                            setFlags( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo & setDescriptorUpdateEntryCount( uint32_t descriptorUpdateEntryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorUpdateEntryCount = descriptorUpdateEntryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo &
      setPDescriptorUpdateEntries( const VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry * pDescriptorUpdateEntries_ ) VULKAN_HPP_NOEXCEPT
    {
      pDescriptorUpdateEntries = pDescriptorUpdateEntries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DescriptorUpdateTemplateCreateInfo & setDescriptorUpdateEntries(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry> const & descriptorUpdateEntries_ )
      VULKAN_HPP_NOEXCEPT
    {
      descriptorUpdateEntryCount = static_cast<uint32_t>( descriptorUpdateEntries_.size() );
      pDescriptorUpdateEntries   = descriptorUpdateEntries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo &
                            setTemplateType( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType templateType_ ) VULKAN_HPP_NOEXCEPT
    {
      templateType = templateType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo &
                            setDescriptorSetLayout( VULKAN_HPP_NAMESPACE::DescriptorSetLayout descriptorSetLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetLayout = descriptorSetLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo &
                            setPipelineBindPoint( VULKAN_HPP_NAMESPACE::PipelineBindPoint pipelineBindPoint_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineBindPoint = pipelineBindPoint_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo & setPipelineLayout( VULKAN_HPP_NAMESPACE::PipelineLayout pipelineLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineLayout = pipelineLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DescriptorUpdateTemplateCreateInfo & setSet( uint32_t set_ ) VULKAN_HPP_NOEXCEPT
    {
      set = set_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDescriptorUpdateTemplateCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDescriptorUpdateTemplateCreateInfo *>( this );
    }

    explicit operator VkDescriptorUpdateTemplateCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDescriptorUpdateTemplateCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateFlags const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry * const &,
               VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType const &,
               VULKAN_HPP_NAMESPACE::DescriptorSetLayout const &,
               VULKAN_HPP_NAMESPACE::PipelineBindPoint const &,
               VULKAN_HPP_NAMESPACE::PipelineLayout const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, flags, descriptorUpdateEntryCount, pDescriptorUpdateEntries, templateType, descriptorSetLayout, pipelineBindPoint, pipelineLayout, set );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DescriptorUpdateTemplateCreateInfo const & ) const = default;
#else
    bool operator==( DescriptorUpdateTemplateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( descriptorUpdateEntryCount == rhs.descriptorUpdateEntryCount ) &&
             ( pDescriptorUpdateEntries == rhs.pDescriptorUpdateEntries ) && ( templateType == rhs.templateType ) &&
             ( descriptorSetLayout == rhs.descriptorSetLayout ) && ( pipelineBindPoint == rhs.pipelineBindPoint ) && ( pipelineLayout == rhs.pipelineLayout ) &&
             ( set == rhs.set );
#  endif
    }

    bool operator!=( DescriptorUpdateTemplateCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType                         sType                      = StructureType::eDescriptorUpdateTemplateCreateInfo;
    const void *                                                pNext                      = {};
    VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateFlags   flags                      = {};
    uint32_t                                                    descriptorUpdateEntryCount = {};
    const VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateEntry * pDescriptorUpdateEntries   = {};
    VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType          templateType               = VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateType::eDescriptorSet;
    VULKAN_HPP_NAMESPACE::DescriptorSetLayout                   descriptorSetLayout        = {};
    VULKAN_HPP_NAMESPACE::PipelineBindPoint                     pipelineBindPoint          = VULKAN_HPP_NAMESPACE::PipelineBindPoint::eGraphics;
    VULKAN_HPP_NAMESPACE::PipelineLayout                        pipelineLayout             = {};
    uint32_t                                                    set                        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateInfo ) == sizeof( VkDescriptorUpdateTemplateCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateInfo>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplateCreateInfo>::value,
                            "DescriptorUpdateTemplateCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDescriptorUpdateTemplateCreateInfo>
  {
    using Type = DescriptorUpdateTemplateCreateInfo;
  };
  using DescriptorUpdateTemplateCreateInfoKHR = DescriptorUpdateTemplateCreateInfo;

  struct DeviceBufferMemoryRequirements
  {
    using NativeType = VkDeviceBufferMemoryRequirements;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceBufferMemoryRequirements;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceBufferMemoryRequirements( const VULKAN_HPP_NAMESPACE::BufferCreateInfo * pCreateInfo_ = {},
                                                         const void *                                   pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , pCreateInfo( pCreateInfo_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceBufferMemoryRequirements( DeviceBufferMemoryRequirements const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceBufferMemoryRequirements( VkDeviceBufferMemoryRequirements const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceBufferMemoryRequirements( *reinterpret_cast<DeviceBufferMemoryRequirements const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceBufferMemoryRequirements & operator=( DeviceBufferMemoryRequirements const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceBufferMemoryRequirements & operator=( VkDeviceBufferMemoryRequirements const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceBufferMemoryRequirements const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceBufferMemoryRequirements & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceBufferMemoryRequirements & setPCreateInfo( const VULKAN_HPP_NAMESPACE::BufferCreateInfo * pCreateInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pCreateInfo = pCreateInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDeviceBufferMemoryRequirements const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceBufferMemoryRequirements *>( this );
    }

    explicit operator VkDeviceBufferMemoryRequirements &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceBufferMemoryRequirements *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &, const void * const &, const VULKAN_HPP_NAMESPACE::BufferCreateInfo * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pCreateInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceBufferMemoryRequirements const & ) const = default;
#else
    bool operator==( DeviceBufferMemoryRequirements const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pCreateInfo == rhs.pCreateInfo );
#  endif
    }

    bool operator!=( DeviceBufferMemoryRequirements const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType            sType       = StructureType::eDeviceBufferMemoryRequirements;
    const void *                                   pNext       = {};
    const VULKAN_HPP_NAMESPACE::BufferCreateInfo * pCreateInfo = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DeviceBufferMemoryRequirements ) == sizeof( VkDeviceBufferMemoryRequirements ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DeviceBufferMemoryRequirements>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DeviceBufferMemoryRequirements>::value,
                            "DeviceBufferMemoryRequirements is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDeviceBufferMemoryRequirements>
  {
    using Type = DeviceBufferMemoryRequirements;
  };
  using DeviceBufferMemoryRequirementsKHR = DeviceBufferMemoryRequirements;

  struct DeviceQueueCreateInfo
  {
    using NativeType = VkDeviceQueueCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceQueueCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceQueueCreateInfo( VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags flags_            = {},
                                                uint32_t                                     queueFamilyIndex_ = {},
                                                uint32_t                                     queueCount_       = {},
                                                const float *                                pQueuePriorities_ = {},
                                                const void *                                 pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , queueFamilyIndex( queueFamilyIndex_ )
      , queueCount( queueCount_ )
      , pQueuePriorities( pQueuePriorities_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceQueueCreateInfo( DeviceQueueCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceQueueCreateInfo( VkDeviceQueueCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceQueueCreateInfo( *reinterpret_cast<DeviceQueueCreateInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceQueueCreateInfo( VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags                       flags_,
                           uint32_t                                                           queueFamilyIndex_,
                           VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const float> const & queuePriorities_,
                           const void *                                                       pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , queueFamilyIndex( queueFamilyIndex_ )
      , queueCount( static_cast<uint32_t>( queuePriorities_.size() ) )
      , pQueuePriorities( queuePriorities_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceQueueCreateInfo & operator=( DeviceQueueCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceQueueCreateInfo & operator=( VkDeviceQueueCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo & setQueueFamilyIndex( uint32_t queueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndex = queueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo & setQueueCount( uint32_t queueCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueCount = queueCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceQueueCreateInfo & setPQueuePriorities( const float * pQueuePriorities_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueuePriorities = pQueuePriorities_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceQueueCreateInfo & setQueuePriorities( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const float> const & queuePriorities_ ) VULKAN_HPP_NOEXCEPT
    {
      queueCount       = static_cast<uint32_t>( queuePriorities_.size() );
      pQueuePriorities = queuePriorities_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDeviceQueueCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceQueueCreateInfo *>( this );
    }

    explicit operator VkDeviceQueueCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceQueueCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags const &,
               uint32_t const &,
               uint32_t const &,
               const float * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, queueFamilyIndex, queueCount, pQueuePriorities );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceQueueCreateInfo const & ) const = default;
#else
    bool operator==( DeviceQueueCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( queueFamilyIndex == rhs.queueFamilyIndex ) &&
             ( queueCount == rhs.queueCount ) && ( pQueuePriorities == rhs.pQueuePriorities );
#  endif
    }

    bool operator!=( DeviceQueueCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType          sType            = StructureType::eDeviceQueueCreateInfo;
    const void *                                 pNext            = {};
    VULKAN_HPP_NAMESPACE::DeviceQueueCreateFlags flags            = {};
    uint32_t                                     queueFamilyIndex = {};
    uint32_t                                     queueCount       = {};
    const float *                                pQueuePriorities = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo ) == sizeof( VkDeviceQueueCreateInfo ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo>::value,
                            "DeviceQueueCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDeviceQueueCreateInfo>
  {
    using Type = DeviceQueueCreateInfo;
  };

  struct PhysicalDeviceFeatures
  {
    using NativeType = VkPhysicalDeviceFeatures;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PhysicalDeviceFeatures( VULKAN_HPP_NAMESPACE::Bool32 robustBufferAccess_                      = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 fullDrawIndexUint32_                     = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 imageCubeArray_                          = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 independentBlend_                        = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 geometryShader_                          = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 tessellationShader_                      = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sampleRateShading_                       = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 dualSrcBlend_                            = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 logicOp_                                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 multiDrawIndirect_                       = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 drawIndirectFirstInstance_               = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 depthClamp_                              = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 depthBiasClamp_                          = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 fillModeNonSolid_                        = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 depthBounds_                             = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 wideLines_                               = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 largePoints_                             = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 alphaToOne_                              = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 multiViewport_                           = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 samplerAnisotropy_                       = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 textureCompressionETC2_                  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 textureCompressionASTC_LDR_              = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 textureCompressionBC_                    = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 occlusionQueryPrecise_                   = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 pipelineStatisticsQuery_                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 vertexPipelineStoresAndAtomics_          = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 fragmentStoresAndAtomics_                = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderTessellationAndGeometryPointSize_  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderImageGatherExtended_               = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageExtendedFormats_       = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageMultisample_           = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageReadWithoutFormat_     = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageWriteWithoutFormat_    = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderUniformBufferArrayDynamicIndexing_ = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderSampledImageArrayDynamicIndexing_  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderStorageBufferArrayDynamicIndexing_ = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageArrayDynamicIndexing_  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderClipDistance_                      = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderCullDistance_                      = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderFloat64_                           = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderInt64_                             = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderInt16_                             = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderResourceResidency_                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 shaderResourceMinLod_                    = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseBinding_                           = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyBuffer_                   = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage2D_                  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage3D_                  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidency2Samples_                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidency4Samples_                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidency8Samples_                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidency16Samples_                = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyAliased_                  = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 variableMultisampleRate_                 = {},
                                                 VULKAN_HPP_NAMESPACE::Bool32 inheritedQueries_                        = {} ) VULKAN_HPP_NOEXCEPT
      : robustBufferAccess( robustBufferAccess_ )
      , fullDrawIndexUint32( fullDrawIndexUint32_ )
      , imageCubeArray( imageCubeArray_ )
      , independentBlend( independentBlend_ )
      , geometryShader( geometryShader_ )
      , tessellationShader( tessellationShader_ )
      , sampleRateShading( sampleRateShading_ )
      , dualSrcBlend( dualSrcBlend_ )
      , logicOp( logicOp_ )
      , multiDrawIndirect( multiDrawIndirect_ )
      , drawIndirectFirstInstance( drawIndirectFirstInstance_ )
      , depthClamp( depthClamp_ )
      , depthBiasClamp( depthBiasClamp_ )
      , fillModeNonSolid( fillModeNonSolid_ )
      , depthBounds( depthBounds_ )
      , wideLines( wideLines_ )
      , largePoints( largePoints_ )
      , alphaToOne( alphaToOne_ )
      , multiViewport( multiViewport_ )
      , samplerAnisotropy( samplerAnisotropy_ )
      , textureCompressionETC2( textureCompressionETC2_ )
      , textureCompressionASTC_LDR( textureCompressionASTC_LDR_ )
      , textureCompressionBC( textureCompressionBC_ )
      , occlusionQueryPrecise( occlusionQueryPrecise_ )
      , pipelineStatisticsQuery( pipelineStatisticsQuery_ )
      , vertexPipelineStoresAndAtomics( vertexPipelineStoresAndAtomics_ )
      , fragmentStoresAndAtomics( fragmentStoresAndAtomics_ )
      , shaderTessellationAndGeometryPointSize( shaderTessellationAndGeometryPointSize_ )
      , shaderImageGatherExtended( shaderImageGatherExtended_ )
      , shaderStorageImageExtendedFormats( shaderStorageImageExtendedFormats_ )
      , shaderStorageImageMultisample( shaderStorageImageMultisample_ )
      , shaderStorageImageReadWithoutFormat( shaderStorageImageReadWithoutFormat_ )
      , shaderStorageImageWriteWithoutFormat( shaderStorageImageWriteWithoutFormat_ )
      , shaderUniformBufferArrayDynamicIndexing( shaderUniformBufferArrayDynamicIndexing_ )
      , shaderSampledImageArrayDynamicIndexing( shaderSampledImageArrayDynamicIndexing_ )
      , shaderStorageBufferArrayDynamicIndexing( shaderStorageBufferArrayDynamicIndexing_ )
      , shaderStorageImageArrayDynamicIndexing( shaderStorageImageArrayDynamicIndexing_ )
      , shaderClipDistance( shaderClipDistance_ )
      , shaderCullDistance( shaderCullDistance_ )
      , shaderFloat64( shaderFloat64_ )
      , shaderInt64( shaderInt64_ )
      , shaderInt16( shaderInt16_ )
      , shaderResourceResidency( shaderResourceResidency_ )
      , shaderResourceMinLod( shaderResourceMinLod_ )
      , sparseBinding( sparseBinding_ )
      , sparseResidencyBuffer( sparseResidencyBuffer_ )
      , sparseResidencyImage2D( sparseResidencyImage2D_ )
      , sparseResidencyImage3D( sparseResidencyImage3D_ )
      , sparseResidency2Samples( sparseResidency2Samples_ )
      , sparseResidency4Samples( sparseResidency4Samples_ )
      , sparseResidency8Samples( sparseResidency8Samples_ )
      , sparseResidency16Samples( sparseResidency16Samples_ )
      , sparseResidencyAliased( sparseResidencyAliased_ )
      , variableMultisampleRate( variableMultisampleRate_ )
      , inheritedQueries( inheritedQueries_ )
    {
    }

    VULKAN_HPP_CONSTEXPR PhysicalDeviceFeatures( PhysicalDeviceFeatures const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PhysicalDeviceFeatures( VkPhysicalDeviceFeatures const & rhs ) VULKAN_HPP_NOEXCEPT
      : PhysicalDeviceFeatures( *reinterpret_cast<PhysicalDeviceFeatures const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    PhysicalDeviceFeatures & operator=( PhysicalDeviceFeatures const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PhysicalDeviceFeatures & operator=( VkPhysicalDeviceFeatures const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setRobustBufferAccess( VULKAN_HPP_NAMESPACE::Bool32 robustBufferAccess_ ) VULKAN_HPP_NOEXCEPT
    {
      robustBufferAccess = robustBufferAccess_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setFullDrawIndexUint32( VULKAN_HPP_NAMESPACE::Bool32 fullDrawIndexUint32_ ) VULKAN_HPP_NOEXCEPT
    {
      fullDrawIndexUint32 = fullDrawIndexUint32_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setImageCubeArray( VULKAN_HPP_NAMESPACE::Bool32 imageCubeArray_ ) VULKAN_HPP_NOEXCEPT
    {
      imageCubeArray = imageCubeArray_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setIndependentBlend( VULKAN_HPP_NAMESPACE::Bool32 independentBlend_ ) VULKAN_HPP_NOEXCEPT
    {
      independentBlend = independentBlend_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setGeometryShader( VULKAN_HPP_NAMESPACE::Bool32 geometryShader_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryShader = geometryShader_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setTessellationShader( VULKAN_HPP_NAMESPACE::Bool32 tessellationShader_ ) VULKAN_HPP_NOEXCEPT
    {
      tessellationShader = tessellationShader_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSampleRateShading( VULKAN_HPP_NAMESPACE::Bool32 sampleRateShading_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleRateShading = sampleRateShading_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setDualSrcBlend( VULKAN_HPP_NAMESPACE::Bool32 dualSrcBlend_ ) VULKAN_HPP_NOEXCEPT
    {
      dualSrcBlend = dualSrcBlend_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setLogicOp( VULKAN_HPP_NAMESPACE::Bool32 logicOp_ ) VULKAN_HPP_NOEXCEPT
    {
      logicOp = logicOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setMultiDrawIndirect( VULKAN_HPP_NAMESPACE::Bool32 multiDrawIndirect_ ) VULKAN_HPP_NOEXCEPT
    {
      multiDrawIndirect = multiDrawIndirect_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setDrawIndirectFirstInstance( VULKAN_HPP_NAMESPACE::Bool32 drawIndirectFirstInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      drawIndirectFirstInstance = drawIndirectFirstInstance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setDepthClamp( VULKAN_HPP_NAMESPACE::Bool32 depthClamp_ ) VULKAN_HPP_NOEXCEPT
    {
      depthClamp = depthClamp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setDepthBiasClamp( VULKAN_HPP_NAMESPACE::Bool32 depthBiasClamp_ ) VULKAN_HPP_NOEXCEPT
    {
      depthBiasClamp = depthBiasClamp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setFillModeNonSolid( VULKAN_HPP_NAMESPACE::Bool32 fillModeNonSolid_ ) VULKAN_HPP_NOEXCEPT
    {
      fillModeNonSolid = fillModeNonSolid_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setDepthBounds( VULKAN_HPP_NAMESPACE::Bool32 depthBounds_ ) VULKAN_HPP_NOEXCEPT
    {
      depthBounds = depthBounds_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setWideLines( VULKAN_HPP_NAMESPACE::Bool32 wideLines_ ) VULKAN_HPP_NOEXCEPT
    {
      wideLines = wideLines_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setLargePoints( VULKAN_HPP_NAMESPACE::Bool32 largePoints_ ) VULKAN_HPP_NOEXCEPT
    {
      largePoints = largePoints_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setAlphaToOne( VULKAN_HPP_NAMESPACE::Bool32 alphaToOne_ ) VULKAN_HPP_NOEXCEPT
    {
      alphaToOne = alphaToOne_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setMultiViewport( VULKAN_HPP_NAMESPACE::Bool32 multiViewport_ ) VULKAN_HPP_NOEXCEPT
    {
      multiViewport = multiViewport_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSamplerAnisotropy( VULKAN_HPP_NAMESPACE::Bool32 samplerAnisotropy_ ) VULKAN_HPP_NOEXCEPT
    {
      samplerAnisotropy = samplerAnisotropy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setTextureCompressionETC2( VULKAN_HPP_NAMESPACE::Bool32 textureCompressionETC2_ ) VULKAN_HPP_NOEXCEPT
    {
      textureCompressionETC2 = textureCompressionETC2_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setTextureCompressionASTC_LDR( VULKAN_HPP_NAMESPACE::Bool32 textureCompressionASTC_LDR_ ) VULKAN_HPP_NOEXCEPT
    {
      textureCompressionASTC_LDR = textureCompressionASTC_LDR_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setTextureCompressionBC( VULKAN_HPP_NAMESPACE::Bool32 textureCompressionBC_ ) VULKAN_HPP_NOEXCEPT
    {
      textureCompressionBC = textureCompressionBC_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setOcclusionQueryPrecise( VULKAN_HPP_NAMESPACE::Bool32 occlusionQueryPrecise_ ) VULKAN_HPP_NOEXCEPT
    {
      occlusionQueryPrecise = occlusionQueryPrecise_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setPipelineStatisticsQuery( VULKAN_HPP_NAMESPACE::Bool32 pipelineStatisticsQuery_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineStatisticsQuery = pipelineStatisticsQuery_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setVertexPipelineStoresAndAtomics( VULKAN_HPP_NAMESPACE::Bool32 vertexPipelineStoresAndAtomics_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexPipelineStoresAndAtomics = vertexPipelineStoresAndAtomics_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setFragmentStoresAndAtomics( VULKAN_HPP_NAMESPACE::Bool32 fragmentStoresAndAtomics_ ) VULKAN_HPP_NOEXCEPT
    {
      fragmentStoresAndAtomics = fragmentStoresAndAtomics_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderTessellationAndGeometryPointSize( VULKAN_HPP_NAMESPACE::Bool32 shaderTessellationAndGeometryPointSize_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderTessellationAndGeometryPointSize = shaderTessellationAndGeometryPointSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderImageGatherExtended( VULKAN_HPP_NAMESPACE::Bool32 shaderImageGatherExtended_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderImageGatherExtended = shaderImageGatherExtended_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setShaderStorageImageExtendedFormats( VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageExtendedFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageExtendedFormats = shaderStorageImageExtendedFormats_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setShaderStorageImageMultisample( VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageMultisample_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageMultisample = shaderStorageImageMultisample_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setShaderStorageImageReadWithoutFormat( VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageReadWithoutFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageReadWithoutFormat = shaderStorageImageReadWithoutFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
                            setShaderStorageImageWriteWithoutFormat( VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageWriteWithoutFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageWriteWithoutFormat = shaderStorageImageWriteWithoutFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderUniformBufferArrayDynamicIndexing( VULKAN_HPP_NAMESPACE::Bool32 shaderUniformBufferArrayDynamicIndexing_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderUniformBufferArrayDynamicIndexing = shaderUniformBufferArrayDynamicIndexing_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderSampledImageArrayDynamicIndexing( VULKAN_HPP_NAMESPACE::Bool32 shaderSampledImageArrayDynamicIndexing_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderSampledImageArrayDynamicIndexing = shaderSampledImageArrayDynamicIndexing_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderStorageBufferArrayDynamicIndexing( VULKAN_HPP_NAMESPACE::Bool32 shaderStorageBufferArrayDynamicIndexing_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageBufferArrayDynamicIndexing = shaderStorageBufferArrayDynamicIndexing_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures &
      setShaderStorageImageArrayDynamicIndexing( VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageArrayDynamicIndexing_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderStorageImageArrayDynamicIndexing = shaderStorageImageArrayDynamicIndexing_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderClipDistance( VULKAN_HPP_NAMESPACE::Bool32 shaderClipDistance_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderClipDistance = shaderClipDistance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderCullDistance( VULKAN_HPP_NAMESPACE::Bool32 shaderCullDistance_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderCullDistance = shaderCullDistance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderFloat64( VULKAN_HPP_NAMESPACE::Bool32 shaderFloat64_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderFloat64 = shaderFloat64_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderInt64( VULKAN_HPP_NAMESPACE::Bool32 shaderInt64_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderInt64 = shaderInt64_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderInt16( VULKAN_HPP_NAMESPACE::Bool32 shaderInt16_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderInt16 = shaderInt16_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderResourceResidency( VULKAN_HPP_NAMESPACE::Bool32 shaderResourceResidency_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderResourceResidency = shaderResourceResidency_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setShaderResourceMinLod( VULKAN_HPP_NAMESPACE::Bool32 shaderResourceMinLod_ ) VULKAN_HPP_NOEXCEPT
    {
      shaderResourceMinLod = shaderResourceMinLod_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseBinding( VULKAN_HPP_NAMESPACE::Bool32 sparseBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseBinding = sparseBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidencyBuffer( VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidencyBuffer = sparseResidencyBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidencyImage2D( VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage2D_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidencyImage2D = sparseResidencyImage2D_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidencyImage3D( VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage3D_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidencyImage3D = sparseResidencyImage3D_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidency2Samples( VULKAN_HPP_NAMESPACE::Bool32 sparseResidency2Samples_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidency2Samples = sparseResidency2Samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidency4Samples( VULKAN_HPP_NAMESPACE::Bool32 sparseResidency4Samples_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidency4Samples = sparseResidency4Samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidency8Samples( VULKAN_HPP_NAMESPACE::Bool32 sparseResidency8Samples_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidency8Samples = sparseResidency8Samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidency16Samples( VULKAN_HPP_NAMESPACE::Bool32 sparseResidency16Samples_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidency16Samples = sparseResidency16Samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setSparseResidencyAliased( VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyAliased_ ) VULKAN_HPP_NOEXCEPT
    {
      sparseResidencyAliased = sparseResidencyAliased_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setVariableMultisampleRate( VULKAN_HPP_NAMESPACE::Bool32 variableMultisampleRate_ ) VULKAN_HPP_NOEXCEPT
    {
      variableMultisampleRate = variableMultisampleRate_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PhysicalDeviceFeatures & setInheritedQueries( VULKAN_HPP_NAMESPACE::Bool32 inheritedQueries_ ) VULKAN_HPP_NOEXCEPT
    {
      inheritedQueries = inheritedQueries_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkPhysicalDeviceFeatures const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPhysicalDeviceFeatures *>( this );
    }

    explicit operator VkPhysicalDeviceFeatures &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPhysicalDeviceFeatures *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &,
               VULKAN_HPP_NAMESPACE::Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( robustBufferAccess,
                       fullDrawIndexUint32,
                       imageCubeArray,
                       independentBlend,
                       geometryShader,
                       tessellationShader,
                       sampleRateShading,
                       dualSrcBlend,
                       logicOp,
                       multiDrawIndirect,
                       drawIndirectFirstInstance,
                       depthClamp,
                       depthBiasClamp,
                       fillModeNonSolid,
                       depthBounds,
                       wideLines,
                       largePoints,
                       alphaToOne,
                       multiViewport,
                       samplerAnisotropy,
                       textureCompressionETC2,
                       textureCompressionASTC_LDR,
                       textureCompressionBC,
                       occlusionQueryPrecise,
                       pipelineStatisticsQuery,
                       vertexPipelineStoresAndAtomics,
                       fragmentStoresAndAtomics,
                       shaderTessellationAndGeometryPointSize,
                       shaderImageGatherExtended,
                       shaderStorageImageExtendedFormats,
                       shaderStorageImageMultisample,
                       shaderStorageImageReadWithoutFormat,
                       shaderStorageImageWriteWithoutFormat,
                       shaderUniformBufferArrayDynamicIndexing,
                       shaderSampledImageArrayDynamicIndexing,
                       shaderStorageBufferArrayDynamicIndexing,
                       shaderStorageImageArrayDynamicIndexing,
                       shaderClipDistance,
                       shaderCullDistance,
                       shaderFloat64,
                       shaderInt64,
                       shaderInt16,
                       shaderResourceResidency,
                       shaderResourceMinLod,
                       sparseBinding,
                       sparseResidencyBuffer,
                       sparseResidencyImage2D,
                       sparseResidencyImage3D,
                       sparseResidency2Samples,
                       sparseResidency4Samples,
                       sparseResidency8Samples,
                       sparseResidency16Samples,
                       sparseResidencyAliased,
                       variableMultisampleRate,
                       inheritedQueries );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PhysicalDeviceFeatures const & ) const = default;
#else
    bool operator==( PhysicalDeviceFeatures const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( robustBufferAccess == rhs.robustBufferAccess ) && ( fullDrawIndexUint32 == rhs.fullDrawIndexUint32 ) &&
             ( imageCubeArray == rhs.imageCubeArray ) && ( independentBlend == rhs.independentBlend ) && ( geometryShader == rhs.geometryShader ) &&
             ( tessellationShader == rhs.tessellationShader ) && ( sampleRateShading == rhs.sampleRateShading ) && ( dualSrcBlend == rhs.dualSrcBlend ) &&
             ( logicOp == rhs.logicOp ) && ( multiDrawIndirect == rhs.multiDrawIndirect ) && ( drawIndirectFirstInstance == rhs.drawIndirectFirstInstance ) &&
             ( depthClamp == rhs.depthClamp ) && ( depthBiasClamp == rhs.depthBiasClamp ) && ( fillModeNonSolid == rhs.fillModeNonSolid ) &&
             ( depthBounds == rhs.depthBounds ) && ( wideLines == rhs.wideLines ) && ( largePoints == rhs.largePoints ) && ( alphaToOne == rhs.alphaToOne ) &&
             ( multiViewport == rhs.multiViewport ) && ( samplerAnisotropy == rhs.samplerAnisotropy ) &&
             ( textureCompressionETC2 == rhs.textureCompressionETC2 ) && ( textureCompressionASTC_LDR == rhs.textureCompressionASTC_LDR ) &&
             ( textureCompressionBC == rhs.textureCompressionBC ) && ( occlusionQueryPrecise == rhs.occlusionQueryPrecise ) &&
             ( pipelineStatisticsQuery == rhs.pipelineStatisticsQuery ) && ( vertexPipelineStoresAndAtomics == rhs.vertexPipelineStoresAndAtomics ) &&
             ( fragmentStoresAndAtomics == rhs.fragmentStoresAndAtomics ) &&
             ( shaderTessellationAndGeometryPointSize == rhs.shaderTessellationAndGeometryPointSize ) &&
             ( shaderImageGatherExtended == rhs.shaderImageGatherExtended ) && ( shaderStorageImageExtendedFormats == rhs.shaderStorageImageExtendedFormats ) &&
             ( shaderStorageImageMultisample == rhs.shaderStorageImageMultisample ) &&
             ( shaderStorageImageReadWithoutFormat == rhs.shaderStorageImageReadWithoutFormat ) &&
             ( shaderStorageImageWriteWithoutFormat == rhs.shaderStorageImageWriteWithoutFormat ) &&
             ( shaderUniformBufferArrayDynamicIndexing == rhs.shaderUniformBufferArrayDynamicIndexing ) &&
             ( shaderSampledImageArrayDynamicIndexing == rhs.shaderSampledImageArrayDynamicIndexing ) &&
             ( shaderStorageBufferArrayDynamicIndexing == rhs.shaderStorageBufferArrayDynamicIndexing ) &&
             ( shaderStorageImageArrayDynamicIndexing == rhs.shaderStorageImageArrayDynamicIndexing ) && ( shaderClipDistance == rhs.shaderClipDistance ) &&
             ( shaderCullDistance == rhs.shaderCullDistance ) && ( shaderFloat64 == rhs.shaderFloat64 ) && ( shaderInt64 == rhs.shaderInt64 ) &&
             ( shaderInt16 == rhs.shaderInt16 ) && ( shaderResourceResidency == rhs.shaderResourceResidency ) &&
             ( shaderResourceMinLod == rhs.shaderResourceMinLod ) && ( sparseBinding == rhs.sparseBinding ) &&
             ( sparseResidencyBuffer == rhs.sparseResidencyBuffer ) && ( sparseResidencyImage2D == rhs.sparseResidencyImage2D ) &&
             ( sparseResidencyImage3D == rhs.sparseResidencyImage3D ) && ( sparseResidency2Samples == rhs.sparseResidency2Samples ) &&
             ( sparseResidency4Samples == rhs.sparseResidency4Samples ) && ( sparseResidency8Samples == rhs.sparseResidency8Samples ) &&
             ( sparseResidency16Samples == rhs.sparseResidency16Samples ) && ( sparseResidencyAliased == rhs.sparseResidencyAliased ) &&
             ( variableMultisampleRate == rhs.variableMultisampleRate ) && ( inheritedQueries == rhs.inheritedQueries );
#  endif
    }

    bool operator!=( PhysicalDeviceFeatures const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::Bool32 robustBufferAccess                      = {};
    VULKAN_HPP_NAMESPACE::Bool32 fullDrawIndexUint32                     = {};
    VULKAN_HPP_NAMESPACE::Bool32 imageCubeArray                          = {};
    VULKAN_HPP_NAMESPACE::Bool32 independentBlend                        = {};
    VULKAN_HPP_NAMESPACE::Bool32 geometryShader                          = {};
    VULKAN_HPP_NAMESPACE::Bool32 tessellationShader                      = {};
    VULKAN_HPP_NAMESPACE::Bool32 sampleRateShading                       = {};
    VULKAN_HPP_NAMESPACE::Bool32 dualSrcBlend                            = {};
    VULKAN_HPP_NAMESPACE::Bool32 logicOp                                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 multiDrawIndirect                       = {};
    VULKAN_HPP_NAMESPACE::Bool32 drawIndirectFirstInstance               = {};
    VULKAN_HPP_NAMESPACE::Bool32 depthClamp                              = {};
    VULKAN_HPP_NAMESPACE::Bool32 depthBiasClamp                          = {};
    VULKAN_HPP_NAMESPACE::Bool32 fillModeNonSolid                        = {};
    VULKAN_HPP_NAMESPACE::Bool32 depthBounds                             = {};
    VULKAN_HPP_NAMESPACE::Bool32 wideLines                               = {};
    VULKAN_HPP_NAMESPACE::Bool32 largePoints                             = {};
    VULKAN_HPP_NAMESPACE::Bool32 alphaToOne                              = {};
    VULKAN_HPP_NAMESPACE::Bool32 multiViewport                           = {};
    VULKAN_HPP_NAMESPACE::Bool32 samplerAnisotropy                       = {};
    VULKAN_HPP_NAMESPACE::Bool32 textureCompressionETC2                  = {};
    VULKAN_HPP_NAMESPACE::Bool32 textureCompressionASTC_LDR              = {};
    VULKAN_HPP_NAMESPACE::Bool32 textureCompressionBC                    = {};
    VULKAN_HPP_NAMESPACE::Bool32 occlusionQueryPrecise                   = {};
    VULKAN_HPP_NAMESPACE::Bool32 pipelineStatisticsQuery                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 vertexPipelineStoresAndAtomics          = {};
    VULKAN_HPP_NAMESPACE::Bool32 fragmentStoresAndAtomics                = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderTessellationAndGeometryPointSize  = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderImageGatherExtended               = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageExtendedFormats       = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageMultisample           = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageReadWithoutFormat     = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageWriteWithoutFormat    = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderUniformBufferArrayDynamicIndexing = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderSampledImageArrayDynamicIndexing  = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageBufferArrayDynamicIndexing = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderStorageImageArrayDynamicIndexing  = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderClipDistance                      = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderCullDistance                      = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderFloat64                           = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderInt64                             = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderInt16                             = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderResourceResidency                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 shaderResourceMinLod                    = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseBinding                           = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyBuffer                   = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage2D                  = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyImage3D                  = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidency2Samples                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidency4Samples                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidency8Samples                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidency16Samples                = {};
    VULKAN_HPP_NAMESPACE::Bool32 sparseResidencyAliased                  = {};
    VULKAN_HPP_NAMESPACE::Bool32 variableMultisampleRate                 = {};
    VULKAN_HPP_NAMESPACE::Bool32 inheritedQueries                        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures ) == sizeof( VkPhysicalDeviceFeatures ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures>::value,
                            "PhysicalDeviceFeatures is not nothrow_move_constructible!" );

  struct DeviceCreateInfo
  {
    using NativeType = VkDeviceCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceCreateInfo;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceCreateInfo( VULKAN_HPP_NAMESPACE::DeviceCreateFlags              flags_                   = {},
                                           uint32_t                                             queueCreateInfoCount_    = {},
                                           const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo *  pQueueCreateInfos_       = {},
                                           uint32_t                                             enabledLayerCount_       = {},
                                           const char * const *                                 ppEnabledLayerNames_     = {},
                                           uint32_t                                             enabledExtensionCount_   = {},
                                           const char * const *                                 ppEnabledExtensionNames_ = {},
                                           const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures * pEnabledFeatures_        = {},
                                           const void *                                         pNext_                   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , queueCreateInfoCount( queueCreateInfoCount_ )
      , pQueueCreateInfos( pQueueCreateInfos_ )
      , enabledLayerCount( enabledLayerCount_ )
      , ppEnabledLayerNames( ppEnabledLayerNames_ )
      , enabledExtensionCount( enabledExtensionCount_ )
      , ppEnabledExtensionNames( ppEnabledExtensionNames_ )
      , pEnabledFeatures( pEnabledFeatures_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceCreateInfo( DeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceCreateInfo( VkDeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT : DeviceCreateInfo( *reinterpret_cast<DeviceCreateInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceCreateInfo( VULKAN_HPP_NAMESPACE::DeviceCreateFlags                                                                  flags_,
                      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo> const & queueCreateInfos_,
                      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const char * const> const &                                pEnabledLayerNames_     = {},
                      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const char * const> const &                                pEnabledExtensionNames_ = {},
                      const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures *                                                     pEnabledFeatures_       = {},
                      const void *                                                                                             pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , queueCreateInfoCount( static_cast<uint32_t>( queueCreateInfos_.size() ) )
      , pQueueCreateInfos( queueCreateInfos_.data() )
      , enabledLayerCount( static_cast<uint32_t>( pEnabledLayerNames_.size() ) )
      , ppEnabledLayerNames( pEnabledLayerNames_.data() )
      , enabledExtensionCount( static_cast<uint32_t>( pEnabledExtensionNames_.size() ) )
      , ppEnabledExtensionNames( pEnabledExtensionNames_.data() )
      , pEnabledFeatures( pEnabledFeatures_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceCreateInfo & operator=( DeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceCreateInfo & operator=( VkDeviceCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setFlags( VULKAN_HPP_NAMESPACE::DeviceCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setQueueCreateInfoCount( uint32_t queueCreateInfoCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueCreateInfoCount = queueCreateInfoCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo &
                            setPQueueCreateInfos( const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo * pQueueCreateInfos_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueueCreateInfos = pQueueCreateInfos_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceCreateInfo & setQueueCreateInfos(
      VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo> const & queueCreateInfos_ ) VULKAN_HPP_NOEXCEPT
    {
      queueCreateInfoCount = static_cast<uint32_t>( queueCreateInfos_.size() );
      pQueueCreateInfos    = queueCreateInfos_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setEnabledLayerCount( uint32_t enabledLayerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      enabledLayerCount = enabledLayerCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setPpEnabledLayerNames( const char * const * ppEnabledLayerNames_ ) VULKAN_HPP_NOEXCEPT
    {
      ppEnabledLayerNames = ppEnabledLayerNames_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceCreateInfo &
      setPEnabledLayerNames( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const char * const> const & pEnabledLayerNames_ ) VULKAN_HPP_NOEXCEPT
    {
      enabledLayerCount   = static_cast<uint32_t>( pEnabledLayerNames_.size() );
      ppEnabledLayerNames = pEnabledLayerNames_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setEnabledExtensionCount( uint32_t enabledExtensionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      enabledExtensionCount = enabledExtensionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setPpEnabledExtensionNames( const char * const * ppEnabledExtensionNames_ ) VULKAN_HPP_NOEXCEPT
    {
      ppEnabledExtensionNames = ppEnabledExtensionNames_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    DeviceCreateInfo &
      setPEnabledExtensionNames( VULKAN_HPP_NAMESPACE::ArrayProxyNoTemporaries<const char * const> const & pEnabledExtensionNames_ ) VULKAN_HPP_NOEXCEPT
    {
      enabledExtensionCount   = static_cast<uint32_t>( pEnabledExtensionNames_.size() );
      ppEnabledExtensionNames = pEnabledExtensionNames_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 DeviceCreateInfo & setPEnabledFeatures( const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures * pEnabledFeatures_ ) VULKAN_HPP_NOEXCEPT
    {
      pEnabledFeatures = pEnabledFeatures_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDeviceCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceCreateInfo *>( this );
    }

    explicit operator VkDeviceCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceCreateFlags const &,
               uint32_t const &,
               const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo * const &,
               uint32_t const &,
               const char * const * const &,
               uint32_t const &,
               const char * const * const &,
               const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       flags,
                       queueCreateInfoCount,
                       pQueueCreateInfos,
                       enabledLayerCount,
                       ppEnabledLayerNames,
                       enabledExtensionCount,
                       ppEnabledExtensionNames,
                       pEnabledFeatures );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( DeviceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = flags <=> rhs.flags; cmp != 0 )
        return cmp;
      if ( auto cmp = queueCreateInfoCount <=> rhs.queueCreateInfoCount; cmp != 0 )
        return cmp;
      if ( auto cmp = pQueueCreateInfos <=> rhs.pQueueCreateInfos; cmp != 0 )
        return cmp;
      if ( auto cmp = enabledLayerCount <=> rhs.enabledLayerCount; cmp != 0 )
        return cmp;
      for ( size_t i = 0; i < enabledLayerCount; ++i )
      {
        if ( ppEnabledLayerNames[i] != rhs.ppEnabledLayerNames[i] )
          if ( auto cmp = strcmp( ppEnabledLayerNames[i], rhs.ppEnabledLayerNames[i] ); cmp != 0 )
            return cmp < 0 ? std::strong_ordering::less : std::strong_ordering::greater;
      }
      if ( auto cmp = enabledExtensionCount <=> rhs.enabledExtensionCount; cmp != 0 )
        return cmp;
      for ( size_t i = 0; i < enabledExtensionCount; ++i )
      {
        if ( ppEnabledExtensionNames[i] != rhs.ppEnabledExtensionNames[i] )
          if ( auto cmp = strcmp( ppEnabledExtensionNames[i], rhs.ppEnabledExtensionNames[i] ); cmp != 0 )
            return cmp < 0 ? std::strong_ordering::less : std::strong_ordering::greater;
      }
      if ( auto cmp = pEnabledFeatures <=> rhs.pEnabledFeatures; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( DeviceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( queueCreateInfoCount == rhs.queueCreateInfoCount ) &&
             ( pQueueCreateInfos == rhs.pQueueCreateInfos ) && ( enabledLayerCount == rhs.enabledLayerCount ) &&
             [this, rhs]
      {
        bool equal = true;
        for ( size_t i = 0; equal && ( i < enabledLayerCount ); ++i )
        {
          equal = ( ( ppEnabledLayerNames[i] == rhs.ppEnabledLayerNames[i] ) || ( strcmp( ppEnabledLayerNames[i], rhs.ppEnabledLayerNames[i] ) == 0 ) );
        }
        return equal;
      }() && ( enabledExtensionCount == rhs.enabledExtensionCount ) &&
             [this, rhs]
      {
        bool equal = true;
        for ( size_t i = 0; equal && ( i < enabledExtensionCount ); ++i )
        {
          equal = ( ( ppEnabledExtensionNames[i] == rhs.ppEnabledExtensionNames[i] ) ||
                    ( strcmp( ppEnabledExtensionNames[i], rhs.ppEnabledExtensionNames[i] ) == 0 ) );
        }
        return equal;
      }() && ( pEnabledFeatures == rhs.pEnabledFeatures );
    }

    bool operator!=( DeviceCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    VULKAN_HPP_NAMESPACE::StructureType                  sType                   = StructureType::eDeviceCreateInfo;
    const void *                                         pNext                   = {};
    VULKAN_HPP_NAMESPACE::DeviceCreateFlags              flags                   = {};
    uint32_t                                             queueCreateInfoCount    = {};
    const VULKAN_HPP_NAMESPACE::DeviceQueueCreateInfo *  pQueueCreateInfos       = {};
    uint32_t                                             enabledLayerCount       = {};
    const char * const *                                 ppEnabledLayerNames     = {};
    uint32_t                                             enabledExtensionCount   = {};
    const char * const *                                 ppEnabledExtensionNames = {};
    const VULKAN_HPP_NAMESPACE::PhysicalDeviceFeatures * pEnabledFeatures        = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DeviceCreateInfo ) == sizeof( VkDeviceCreateInfo ), "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DeviceCreateInfo>::value, "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DeviceCreateInfo>::value,
                            "DeviceCreateInfo is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDeviceCreateInfo>
  {
    using Type = DeviceCreateInfo;
  };

  struct DeviceDeviceMemoryReportCreateInfoEXT
  {
    using NativeType = VkDeviceDeviceMemoryReportCreateInfoEXT;

    static const bool                                  allowDuplicate = true;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceDeviceMemoryReportCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceDeviceMemoryReportCreateInfoEXT( VULKAN_HPP_NAMESPACE::DeviceMemoryReportFlagsEXT flags_           = {},
                                                                PFN_vkDeviceMemoryReportCallbackEXT              pfnUserCallback_ = {},
                                                                void *                                           pUserData_       = {},
                                                                const void *                                     pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext( pNext_ )
      , flags( flags_ )
      , pfnUserCallback( pfnUserCallback_ )
      , pUserData( pUserData_ )
    {
    }

    VULKAN_HPP_CONSTEXPR DeviceDeviceMemoryReportCreateInfoEXT( DeviceDeviceMemoryReportCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceDeviceMemoryReportCreateInfoEXT( VkDeviceDeviceMemoryReportCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : DeviceDeviceMemoryReportCreateInfoEXT( *reinterpret_cast<DeviceDeviceMemoryReportCreateInfoEXT const *>( &rhs ) )
    {
    }
#endif /*VULKAN_HPP_NO_STRUCT_CONSTRUCTORS*/

    DeviceDeviceMemoryReportCreateInfoEXT & operator=( DeviceDeviceMemoryReportCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    DeviceDeviceMemoryReportCreateInfoEXT & operator=( VkDeviceDeviceMemoryReportCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<VULKAN_HPP_NAMESPACE::DeviceDeviceMemoryReportCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceDeviceMemoryReportCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceDeviceMemoryReportCreateInfoEXT & setFlags( VULKAN_HPP_NAMESPACE::DeviceMemoryReportFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceDeviceMemoryReportCreateInfoEXT &
                            setPfnUserCallback( PFN_vkDeviceMemoryReportCallbackEXT pfnUserCallback_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnUserCallback = pfnUserCallback_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceDeviceMemoryReportCreateInfoEXT & setPUserData( void * pUserData_ ) VULKAN_HPP_NOEXCEPT
    {
      pUserData = pUserData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_STRUCT_SETTERS*/

    explicit operator VkDeviceDeviceMemoryReportCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkDeviceDeviceMemoryReportCreateInfoEXT *>( this );
    }

    explicit operator VkDeviceDeviceMemoryReportCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkDeviceDeviceMemoryReportCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<VULKAN_HPP_NAMESPACE::StructureType const &,
               const void * const &,
               VULKAN_HPP_NAMESPACE::DeviceMemoryReportFlagsEXT const &,
               PFN_vkDeviceMemoryReportCallbackEXT const &,
               void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, pfnUserCallback, pUserData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( DeviceDeviceMemoryReportCreateInfoEXT const & ) const = default;
#else
    bool operator==( DeviceDeviceMemoryReportCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( pfnUserCallback == rhs.pfnUserCallback ) &&
             ( pUserData == rhs.pUserData );
#  endif
    }

    bool operator!=( DeviceDeviceMemoryReportCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    VULKAN_HPP_NAMESPACE::StructureType              sType           = StructureType::eDeviceDeviceMemoryReportCreateInfoEXT;
    const void *                                     pNext           = {};
    VULKAN_HPP_NAMESPACE::DeviceMemoryReportFlagsEXT flags           = {};
    PFN_vkDeviceMemoryReportCallbackEXT              pfnUserCallback = {};
    void *                                           pUserData       = {};
  };
  VULKAN_HPP_STATIC_ASSERT( sizeof( VULKAN_HPP_NAMESPACE::DeviceDeviceMemoryReportCreateInfoEXT ) == sizeof( VkDeviceDeviceMemoryReportCreateInfoEXT ),
                            "struct and wrapper have different size!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_standard_layout<VULKAN_HPP_NAMESPACE::DeviceDeviceMemoryReportCreateInfoEXT>::value,
                            "struct wrapper is not a standard layout!" );
  VULKAN_HPP_STATIC_ASSERT( std::is_nothrow_move_constructible<VULKAN_HPP_NAMESPACE::DeviceDeviceMemoryReportCreateInfoEXT>::value,
                            "DeviceDeviceMemoryReportCreateInfoEXT is not nothrow_move_constructible!" );

  template <>
  struct CppType<StructureType, StructureType::eDeviceDeviceMemoryReportCreateInfoEXT>
  {
    using Type = DeviceDeviceMemoryReportCreateInfoEXT;
  };

  struct DeviceDiagnosticsConfigCreateInfoNV
  {
    using NativeType = VkDeviceDiagnosticsConfigCreateInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eDeviceDiagnosticsConfigCreateInfoNV;

#if !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR DeviceDiagnosticsConfigCreateInfoNV( VULKAN_HPP_NAMESPACE::DeviceDiagnosticsConfigFlagsNV flags_ = {},
                                                              const void *                                         pNext_ = nullptr )