/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "org.freedesktop.NetworkManager.VPN.Plugin.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.NetworkManager.VPN.Plugin
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NMDBusVpnPlugin
 * @title: NMDBusVpnPlugin
 * @short_description: Generated C code for the org.freedesktop.NetworkManager.VPN.Plugin D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-VPN-Plugin.top_of_page">org.freedesktop.NetworkManager.VPN.Plugin</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.NetworkManager.VPN.Plugin ---- */

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_method_info_connect_IN_ARG_connection =
{
  {
    -1,
    (gchar *) "connection",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_method_info_connect_IN_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_method_info_connect_IN_ARG_connection.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _nmdbus_vpn_plugin_method_connect_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "impl_vpn_plugin_connect",
  NULL
};

static const GDBusAnnotationInfo * const _nmdbus_vpn_plugin_method_connect_annotation_info_pointers[] =
{
  &_nmdbus_vpn_plugin_method_connect_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_vpn_plugin_method_info_connect =
{
  {
    -1,
    (gchar *) "Connect",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_method_info_connect_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_nmdbus_vpn_plugin_method_connect_annotation_info_pointers
  },
  "handle-connect",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_method_info_connect_interactive_IN_ARG_connection =
{
  {
    -1,
    (gchar *) "connection",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_method_info_connect_interactive_IN_ARG_details =
{
  {
    -1,
    (gchar *) "details",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_method_info_connect_interactive_IN_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_method_info_connect_interactive_IN_ARG_connection.parent_struct,
  &_nmdbus_vpn_plugin_method_info_connect_interactive_IN_ARG_details.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _nmdbus_vpn_plugin_method_connect_interactive_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "impl_vpn_plugin_connect_interactive",
  NULL
};

static const GDBusAnnotationInfo * const _nmdbus_vpn_plugin_method_connect_interactive_annotation_info_pointers[] =
{
  &_nmdbus_vpn_plugin_method_connect_interactive_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_vpn_plugin_method_info_connect_interactive =
{
  {
    -1,
    (gchar *) "ConnectInteractive",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_method_info_connect_interactive_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_nmdbus_vpn_plugin_method_connect_interactive_annotation_info_pointers
  },
  "handle-connect-interactive",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_method_info_need_secrets_IN_ARG_settings =
{
  {
    -1,
    (gchar *) "settings",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_method_info_need_secrets_IN_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_method_info_need_secrets_IN_ARG_settings.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_method_info_need_secrets_OUT_ARG_setting_name =
{
  {
    -1,
    (gchar *) "setting_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_method_info_need_secrets_OUT_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_method_info_need_secrets_OUT_ARG_setting_name.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _nmdbus_vpn_plugin_method_need_secrets_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "impl_vpn_plugin_need_secrets",
  NULL
};

static const GDBusAnnotationInfo * const _nmdbus_vpn_plugin_method_need_secrets_annotation_info_pointers[] =
{
  &_nmdbus_vpn_plugin_method_need_secrets_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_vpn_plugin_method_info_need_secrets =
{
  {
    -1,
    (gchar *) "NeedSecrets",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_method_info_need_secrets_IN_ARG_pointers,
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_method_info_need_secrets_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_nmdbus_vpn_plugin_method_need_secrets_annotation_info_pointers
  },
  "handle-need-secrets",
  FALSE
};

static const GDBusAnnotationInfo _nmdbus_vpn_plugin_method_disconnect_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "impl_vpn_plugin_disconnect",
  NULL
};

static const GDBusAnnotationInfo * const _nmdbus_vpn_plugin_method_disconnect_annotation_info_pointers[] =
{
  &_nmdbus_vpn_plugin_method_disconnect_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_vpn_plugin_method_info_disconnect =
{
  {
    -1,
    (gchar *) "Disconnect",
    NULL,
    NULL,
    (GDBusAnnotationInfo **) &_nmdbus_vpn_plugin_method_disconnect_annotation_info_pointers
  },
  "handle-disconnect",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_method_info_set_config_IN_ARG_config =
{
  {
    -1,
    (gchar *) "config",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_method_info_set_config_IN_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_method_info_set_config_IN_ARG_config.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _nmdbus_vpn_plugin_method_set_config_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "impl_vpn_plugin_set_config",
  NULL
};

static const GDBusAnnotationInfo * const _nmdbus_vpn_plugin_method_set_config_annotation_info_pointers[] =
{
  &_nmdbus_vpn_plugin_method_set_config_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_vpn_plugin_method_info_set_config =
{
  {
    -1,
    (gchar *) "SetConfig",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_method_info_set_config_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_nmdbus_vpn_plugin_method_set_config_annotation_info_pointers
  },
  "handle-set-config",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_method_info_set_ip4_config_IN_ARG_config =
{
  {
    -1,
    (gchar *) "config",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_method_info_set_ip4_config_IN_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_method_info_set_ip4_config_IN_ARG_config.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _nmdbus_vpn_plugin_method_set_ip4_config_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "impl_vpn_plugin_set_ip4_config",
  NULL
};

static const GDBusAnnotationInfo * const _nmdbus_vpn_plugin_method_set_ip4_config_annotation_info_pointers[] =
{
  &_nmdbus_vpn_plugin_method_set_ip4_config_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_vpn_plugin_method_info_set_ip4_config =
{
  {
    -1,
    (gchar *) "SetIp4Config",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_method_info_set_ip4_config_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_nmdbus_vpn_plugin_method_set_ip4_config_annotation_info_pointers
  },
  "handle-set-ip4-config",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_method_info_set_ip6_config_IN_ARG_config =
{
  {
    -1,
    (gchar *) "config",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_method_info_set_ip6_config_IN_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_method_info_set_ip6_config_IN_ARG_config.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _nmdbus_vpn_plugin_method_set_ip6_config_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "impl_vpn_plugin_set_ip6_config",
  NULL
};

static const GDBusAnnotationInfo * const _nmdbus_vpn_plugin_method_set_ip6_config_annotation_info_pointers[] =
{
  &_nmdbus_vpn_plugin_method_set_ip6_config_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_vpn_plugin_method_info_set_ip6_config =
{
  {
    -1,
    (gchar *) "SetIp6Config",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_method_info_set_ip6_config_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_nmdbus_vpn_plugin_method_set_ip6_config_annotation_info_pointers
  },
  "handle-set-ip6-config",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_method_info_set_failure_IN_ARG_reason =
{
  {
    -1,
    (gchar *) "reason",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_method_info_set_failure_IN_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_method_info_set_failure_IN_ARG_reason.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _nmdbus_vpn_plugin_method_set_failure_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "impl_vpn_plugin_set_failure",
  NULL
};

static const GDBusAnnotationInfo * const _nmdbus_vpn_plugin_method_set_failure_annotation_info_pointers[] =
{
  &_nmdbus_vpn_plugin_method_set_failure_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_vpn_plugin_method_info_set_failure =
{
  {
    -1,
    (gchar *) "SetFailure",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_method_info_set_failure_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_nmdbus_vpn_plugin_method_set_failure_annotation_info_pointers
  },
  "handle-set-failure",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_method_info_new_secrets_IN_ARG_connection =
{
  {
    -1,
    (gchar *) "connection",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_method_info_new_secrets_IN_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_method_info_new_secrets_IN_ARG_connection.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _nmdbus_vpn_plugin_method_new_secrets_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "impl_vpn_plugin_new_secrets",
  NULL
};

static const GDBusAnnotationInfo * const _nmdbus_vpn_plugin_method_new_secrets_annotation_info_pointers[] =
{
  &_nmdbus_vpn_plugin_method_new_secrets_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_vpn_plugin_method_info_new_secrets =
{
  {
    -1,
    (gchar *) "NewSecrets",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_method_info_new_secrets_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_nmdbus_vpn_plugin_method_new_secrets_annotation_info_pointers
  },
  "handle-new-secrets",
  FALSE
};

static const GDBusMethodInfo * const _nmdbus_vpn_plugin_method_info_pointers[] =
{
  &_nmdbus_vpn_plugin_method_info_connect.parent_struct,
  &_nmdbus_vpn_plugin_method_info_connect_interactive.parent_struct,
  &_nmdbus_vpn_plugin_method_info_need_secrets.parent_struct,
  &_nmdbus_vpn_plugin_method_info_disconnect.parent_struct,
  &_nmdbus_vpn_plugin_method_info_set_config.parent_struct,
  &_nmdbus_vpn_plugin_method_info_set_ip4_config.parent_struct,
  &_nmdbus_vpn_plugin_method_info_set_ip6_config.parent_struct,
  &_nmdbus_vpn_plugin_method_info_set_failure.parent_struct,
  &_nmdbus_vpn_plugin_method_info_new_secrets.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_signal_info_state_changed_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_signal_info_state_changed_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_signal_info_state_changed_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_vpn_plugin_signal_info_state_changed =
{
  {
    -1,
    (gchar *) "StateChanged",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_signal_info_state_changed_ARG_pointers,
    NULL
  },
  "state-changed"
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_signal_info_secrets_required_ARG_message =
{
  {
    -1,
    (gchar *) "message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_signal_info_secrets_required_ARG_secrets =
{
  {
    -1,
    (gchar *) "secrets",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_signal_info_secrets_required_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_signal_info_secrets_required_ARG_message.parent_struct,
  &_nmdbus_vpn_plugin_signal_info_secrets_required_ARG_secrets.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_vpn_plugin_signal_info_secrets_required =
{
  {
    -1,
    (gchar *) "SecretsRequired",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_signal_info_secrets_required_ARG_pointers,
    NULL
  },
  "secrets-required"
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_signal_info_config_ARG_config =
{
  {
    -1,
    (gchar *) "config",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_signal_info_config_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_signal_info_config_ARG_config.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_vpn_plugin_signal_info_config =
{
  {
    -1,
    (gchar *) "Config",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_signal_info_config_ARG_pointers,
    NULL
  },
  "config"
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_signal_info_ip4_config_ARG_ip4config =
{
  {
    -1,
    (gchar *) "ip4config",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_signal_info_ip4_config_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_signal_info_ip4_config_ARG_ip4config.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_vpn_plugin_signal_info_ip4_config =
{
  {
    -1,
    (gchar *) "Ip4Config",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_signal_info_ip4_config_ARG_pointers,
    NULL
  },
  "ip4-config"
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_signal_info_ip6_config_ARG_ip6config =
{
  {
    -1,
    (gchar *) "ip6config",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_signal_info_ip6_config_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_signal_info_ip6_config_ARG_ip6config.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_vpn_plugin_signal_info_ip6_config =
{
  {
    -1,
    (gchar *) "Ip6Config",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_signal_info_ip6_config_ARG_pointers,
    NULL
  },
  "ip6-config"
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_signal_info_login_banner_ARG_banner =
{
  {
    -1,
    (gchar *) "banner",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_signal_info_login_banner_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_signal_info_login_banner_ARG_banner.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_vpn_plugin_signal_info_login_banner =
{
  {
    -1,
    (gchar *) "LoginBanner",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_signal_info_login_banner_ARG_pointers,
    NULL
  },
  "login-banner"
};

static const _ExtendedGDBusArgInfo _nmdbus_vpn_plugin_signal_info_failure_ARG_reason =
{
  {
    -1,
    (gchar *) "reason",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_vpn_plugin_signal_info_failure_ARG_pointers[] =
{
  &_nmdbus_vpn_plugin_signal_info_failure_ARG_reason.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_vpn_plugin_signal_info_failure =
{
  {
    -1,
    (gchar *) "Failure",
    (GDBusArgInfo **) &_nmdbus_vpn_plugin_signal_info_failure_ARG_pointers,
    NULL
  },
  "failure"
};

static const GDBusSignalInfo * const _nmdbus_vpn_plugin_signal_info_pointers[] =
{
  &_nmdbus_vpn_plugin_signal_info_state_changed.parent_struct,
  &_nmdbus_vpn_plugin_signal_info_secrets_required.parent_struct,
  &_nmdbus_vpn_plugin_signal_info_config.parent_struct,
  &_nmdbus_vpn_plugin_signal_info_ip4_config.parent_struct,
  &_nmdbus_vpn_plugin_signal_info_ip6_config.parent_struct,
  &_nmdbus_vpn_plugin_signal_info_login_banner.parent_struct,
  &_nmdbus_vpn_plugin_signal_info_failure.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _nmdbus_vpn_plugin_property_info_state =
{
  {
    -1,
    (gchar *) "State",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _nmdbus_vpn_plugin_property_info_pointers[] =
{
  &_nmdbus_vpn_plugin_property_info_state.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _nmdbus_vpn_plugin_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.NetworkManager.VPN.Plugin",
    (GDBusMethodInfo **) &_nmdbus_vpn_plugin_method_info_pointers,
    (GDBusSignalInfo **) &_nmdbus_vpn_plugin_signal_info_pointers,
    (GDBusPropertyInfo **) &_nmdbus_vpn_plugin_property_info_pointers,
    NULL
  },
  "vpn-plugin",
};


/**
 * nmdbus_vpn_plugin_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-VPN-Plugin.top_of_page">org.freedesktop.NetworkManager.VPN.Plugin</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
nmdbus_vpn_plugin_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_nmdbus_vpn_plugin_interface_info.parent_struct;
}

/**
 * nmdbus_vpn_plugin_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NMDBusVpnPlugin interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
nmdbus_vpn_plugin_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "state");
  return property_id_begin - 1;
}



/**
 * NMDBusVpnPlugin:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-VPN-Plugin.top_of_page">org.freedesktop.NetworkManager.VPN.Plugin</link>.
 */

/**
 * NMDBusVpnPluginIface:
 * @parent_iface: The parent interface.
 * @handle_connect: Handler for the #NMDBusVpnPlugin::handle-connect signal.
 * @handle_connect_interactive: Handler for the #NMDBusVpnPlugin::handle-connect-interactive signal.
 * @handle_disconnect: Handler for the #NMDBusVpnPlugin::handle-disconnect signal.
 * @handle_need_secrets: Handler for the #NMDBusVpnPlugin::handle-need-secrets signal.
 * @handle_new_secrets: Handler for the #NMDBusVpnPlugin::handle-new-secrets signal.
 * @handle_set_config: Handler for the #NMDBusVpnPlugin::handle-set-config signal.
 * @handle_set_failure: Handler for the #NMDBusVpnPlugin::handle-set-failure signal.
 * @handle_set_ip4_config: Handler for the #NMDBusVpnPlugin::handle-set-ip4-config signal.
 * @handle_set_ip6_config: Handler for the #NMDBusVpnPlugin::handle-set-ip6-config signal.
 * @get_state: Getter for the #NMDBusVpnPlugin:state property.
 * @config: Handler for the #NMDBusVpnPlugin::config signal.
 * @failure: Handler for the #NMDBusVpnPlugin::failure signal.
 * @ip4_config: Handler for the #NMDBusVpnPlugin::ip4-config signal.
 * @ip6_config: Handler for the #NMDBusVpnPlugin::ip6-config signal.
 * @login_banner: Handler for the #NMDBusVpnPlugin::login-banner signal.
 * @secrets_required: Handler for the #NMDBusVpnPlugin::secrets-required signal.
 * @state_changed: Handler for the #NMDBusVpnPlugin::state-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-VPN-Plugin.top_of_page">org.freedesktop.NetworkManager.VPN.Plugin</link>.
 */

typedef NMDBusVpnPluginIface NMDBusVpnPluginInterface;
G_DEFINE_INTERFACE (NMDBusVpnPlugin, nmdbus_vpn_plugin, G_TYPE_OBJECT)

static void
nmdbus_vpn_plugin_default_init (NMDBusVpnPluginIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NMDBusVpnPlugin::handle-connect:
   * @object: A #NMDBusVpnPlugin.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_connection: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.Connect">Connect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_vpn_plugin_complete_connect() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-connect",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, handle_connect),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * NMDBusVpnPlugin::handle-connect-interactive:
   * @object: A #NMDBusVpnPlugin.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_connection: Argument passed by remote caller.
   * @arg_details: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.ConnectInteractive">ConnectInteractive()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_vpn_plugin_complete_connect_interactive() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-connect-interactive",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, handle_connect_interactive),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * NMDBusVpnPlugin::handle-need-secrets:
   * @object: A #NMDBusVpnPlugin.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_settings: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.NeedSecrets">NeedSecrets()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_vpn_plugin_complete_need_secrets() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-need-secrets",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, handle_need_secrets),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * NMDBusVpnPlugin::handle-disconnect:
   * @object: A #NMDBusVpnPlugin.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.Disconnect">Disconnect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_vpn_plugin_complete_disconnect() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disconnect",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, handle_disconnect),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusVpnPlugin::handle-set-config:
   * @object: A #NMDBusVpnPlugin.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_config: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetConfig">SetConfig()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_vpn_plugin_complete_set_config() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-config",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, handle_set_config),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * NMDBusVpnPlugin::handle-set-ip4-config:
   * @object: A #NMDBusVpnPlugin.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_config: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetIp4Config">SetIp4Config()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_vpn_plugin_complete_set_ip4_config() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-ip4-config",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, handle_set_ip4_config),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * NMDBusVpnPlugin::handle-set-ip6-config:
   * @object: A #NMDBusVpnPlugin.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_config: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetIp6Config">SetIp6Config()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_vpn_plugin_complete_set_ip6_config() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-ip6-config",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, handle_set_ip6_config),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * NMDBusVpnPlugin::handle-set-failure:
   * @object: A #NMDBusVpnPlugin.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_reason: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetFailure">SetFailure()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_vpn_plugin_complete_set_failure() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-failure",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, handle_set_failure),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * NMDBusVpnPlugin::handle-new-secrets:
   * @object: A #NMDBusVpnPlugin.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_connection: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.NewSecrets">NewSecrets()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_vpn_plugin_complete_new_secrets() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-new-secrets",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, handle_new_secrets),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * NMDBusVpnPlugin::state-changed:
   * @object: A #NMDBusVpnPlugin.
   * @arg_state: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.StateChanged">"StateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("state-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, state_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_UINT);

  /**
   * NMDBusVpnPlugin::secrets-required:
   * @object: A #NMDBusVpnPlugin.
   * @arg_message: Argument.
   * @arg_secrets: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.SecretsRequired">"SecretsRequired"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("secrets-required",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, secrets_required),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_STRV);

  /**
   * NMDBusVpnPlugin::config:
   * @object: A #NMDBusVpnPlugin.
   * @arg_config: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.Config">"Config"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("config",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, config),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_VARIANT);

  /**
   * NMDBusVpnPlugin::ip4-config:
   * @object: A #NMDBusVpnPlugin.
   * @arg_ip4config: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.Ip4Config">"Ip4Config"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("ip4-config",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, ip4_config),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_VARIANT);

  /**
   * NMDBusVpnPlugin::ip6-config:
   * @object: A #NMDBusVpnPlugin.
   * @arg_ip6config: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.Ip6Config">"Ip6Config"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("ip6-config",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, ip6_config),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_VARIANT);

  /**
   * NMDBusVpnPlugin::login-banner:
   * @object: A #NMDBusVpnPlugin.
   * @arg_banner: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.LoginBanner">"LoginBanner"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("login-banner",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, login_banner),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * NMDBusVpnPlugin::failure:
   * @object: A #NMDBusVpnPlugin.
   * @arg_reason: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.Failure">"Failure"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("failure",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusVpnPluginIface, failure),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * NMDBusVpnPlugin:state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-VPN-Plugin.State">"State"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("state", "State", "State", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * nmdbus_vpn_plugin_get_state: (skip)
 * @object: A #NMDBusVpnPlugin.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-VPN-Plugin.State">"State"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_vpn_plugin_get_state (NMDBusVpnPlugin *object)
{
  return NMDBUS_VPN_PLUGIN_GET_IFACE (object)->get_state (object);
}

/**
 * nmdbus_vpn_plugin_set_state: (skip)
 * @object: A #NMDBusVpnPlugin.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-VPN-Plugin.State">"State"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_vpn_plugin_set_state (NMDBusVpnPlugin *object, guint value)
{
  g_object_set (G_OBJECT (object), "state", value, NULL);
}

/**
 * nmdbus_vpn_plugin_emit_state_changed:
 * @object: A #NMDBusVpnPlugin.
 * @arg_state: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.StateChanged">"StateChanged"</link> D-Bus signal.
 */
void
nmdbus_vpn_plugin_emit_state_changed (
    NMDBusVpnPlugin *object,
    guint arg_state)
{
  g_signal_emit_by_name (object, "state-changed", arg_state);
}

/**
 * nmdbus_vpn_plugin_emit_secrets_required:
 * @object: A #NMDBusVpnPlugin.
 * @arg_message: Argument to pass with the signal.
 * @arg_secrets: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.SecretsRequired">"SecretsRequired"</link> D-Bus signal.
 */
void
nmdbus_vpn_plugin_emit_secrets_required (
    NMDBusVpnPlugin *object,
    const gchar *arg_message,
    const gchar *const *arg_secrets)
{
  g_signal_emit_by_name (object, "secrets-required", arg_message, arg_secrets);
}

/**
 * nmdbus_vpn_plugin_emit_config:
 * @object: A #NMDBusVpnPlugin.
 * @arg_config: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.Config">"Config"</link> D-Bus signal.
 */
void
nmdbus_vpn_plugin_emit_config (
    NMDBusVpnPlugin *object,
    GVariant *arg_config)
{
  g_signal_emit_by_name (object, "config", arg_config);
}

/**
 * nmdbus_vpn_plugin_emit_ip4_config:
 * @object: A #NMDBusVpnPlugin.
 * @arg_ip4config: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.Ip4Config">"Ip4Config"</link> D-Bus signal.
 */
void
nmdbus_vpn_plugin_emit_ip4_config (
    NMDBusVpnPlugin *object,
    GVariant *arg_ip4config)
{
  g_signal_emit_by_name (object, "ip4-config", arg_ip4config);
}

/**
 * nmdbus_vpn_plugin_emit_ip6_config:
 * @object: A #NMDBusVpnPlugin.
 * @arg_ip6config: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.Ip6Config">"Ip6Config"</link> D-Bus signal.
 */
void
nmdbus_vpn_plugin_emit_ip6_config (
    NMDBusVpnPlugin *object,
    GVariant *arg_ip6config)
{
  g_signal_emit_by_name (object, "ip6-config", arg_ip6config);
}

/**
 * nmdbus_vpn_plugin_emit_login_banner:
 * @object: A #NMDBusVpnPlugin.
 * @arg_banner: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.LoginBanner">"LoginBanner"</link> D-Bus signal.
 */
void
nmdbus_vpn_plugin_emit_login_banner (
    NMDBusVpnPlugin *object,
    const gchar *arg_banner)
{
  g_signal_emit_by_name (object, "login-banner", arg_banner);
}

/**
 * nmdbus_vpn_plugin_emit_failure:
 * @object: A #NMDBusVpnPlugin.
 * @arg_reason: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager-VPN-Plugin.Failure">"Failure"</link> D-Bus signal.
 */
void
nmdbus_vpn_plugin_emit_failure (
    NMDBusVpnPlugin *object,
    guint arg_reason)
{
  g_signal_emit_by_name (object, "failure", arg_reason);
}

/**
 * nmdbus_vpn_plugin_call_connect:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.Connect">Connect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_vpn_plugin_call_connect_finish() to get the result of the operation.
 *
 * See nmdbus_vpn_plugin_call_connect_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_vpn_plugin_call_connect (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_connection,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Connect",
    g_variant_new ("(@a{sa{sv}})",
                   arg_connection),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_vpn_plugin_call_connect_finish:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_vpn_plugin_call_connect().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_vpn_plugin_call_connect().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_connect_finish (
    NMDBusVpnPlugin *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_connect_sync:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.Connect">Connect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_vpn_plugin_call_connect() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_connect_sync (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_connection,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Connect",
    g_variant_new ("(@a{sa{sv}})",
                   arg_connection),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_connect_interactive:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @arg_details: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.ConnectInteractive">ConnectInteractive()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_vpn_plugin_call_connect_interactive_finish() to get the result of the operation.
 *
 * See nmdbus_vpn_plugin_call_connect_interactive_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_vpn_plugin_call_connect_interactive (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_connection,
    GVariant *arg_details,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ConnectInteractive",
    g_variant_new ("(@a{sa{sv}}@a{sv})",
                   arg_connection,
                   arg_details),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_vpn_plugin_call_connect_interactive_finish:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_vpn_plugin_call_connect_interactive().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_vpn_plugin_call_connect_interactive().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_connect_interactive_finish (
    NMDBusVpnPlugin *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_connect_interactive_sync:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @arg_details: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.ConnectInteractive">ConnectInteractive()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_vpn_plugin_call_connect_interactive() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_connect_interactive_sync (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_connection,
    GVariant *arg_details,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ConnectInteractive",
    g_variant_new ("(@a{sa{sv}}@a{sv})",
                   arg_connection,
                   arg_details),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_need_secrets:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_settings: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.NeedSecrets">NeedSecrets()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_vpn_plugin_call_need_secrets_finish() to get the result of the operation.
 *
 * See nmdbus_vpn_plugin_call_need_secrets_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_vpn_plugin_call_need_secrets (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_settings,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NeedSecrets",
    g_variant_new ("(@a{sa{sv}})",
                   arg_settings),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_vpn_plugin_call_need_secrets_finish:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @out_setting_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_vpn_plugin_call_need_secrets().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_vpn_plugin_call_need_secrets().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_need_secrets_finish (
    NMDBusVpnPlugin *proxy,
    gchar **out_setting_name,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_setting_name);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_need_secrets_sync:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_settings: Argument to pass with the method invocation.
 * @out_setting_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.NeedSecrets">NeedSecrets()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_vpn_plugin_call_need_secrets() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_need_secrets_sync (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_settings,
    gchar **out_setting_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NeedSecrets",
    g_variant_new ("(@a{sa{sv}})",
                   arg_settings),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_setting_name);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_disconnect:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.Disconnect">Disconnect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_vpn_plugin_call_disconnect_finish() to get the result of the operation.
 *
 * See nmdbus_vpn_plugin_call_disconnect_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_vpn_plugin_call_disconnect (
    NMDBusVpnPlugin *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Disconnect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_vpn_plugin_call_disconnect_finish:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_vpn_plugin_call_disconnect().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_vpn_plugin_call_disconnect().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_disconnect_finish (
    NMDBusVpnPlugin *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_disconnect_sync:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.Disconnect">Disconnect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_vpn_plugin_call_disconnect() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_disconnect_sync (
    NMDBusVpnPlugin *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Disconnect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_set_config:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_config: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetConfig">SetConfig()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_vpn_plugin_call_set_config_finish() to get the result of the operation.
 *
 * See nmdbus_vpn_plugin_call_set_config_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_vpn_plugin_call_set_config (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_config,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetConfig",
    g_variant_new ("(@a{sv})",
                   arg_config),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_vpn_plugin_call_set_config_finish:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_vpn_plugin_call_set_config().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_vpn_plugin_call_set_config().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_set_config_finish (
    NMDBusVpnPlugin *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_set_config_sync:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_config: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetConfig">SetConfig()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_vpn_plugin_call_set_config() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_set_config_sync (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_config,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetConfig",
    g_variant_new ("(@a{sv})",
                   arg_config),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_set_ip4_config:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_config: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetIp4Config">SetIp4Config()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_vpn_plugin_call_set_ip4_config_finish() to get the result of the operation.
 *
 * See nmdbus_vpn_plugin_call_set_ip4_config_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_vpn_plugin_call_set_ip4_config (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_config,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetIp4Config",
    g_variant_new ("(@a{sv})",
                   arg_config),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_vpn_plugin_call_set_ip4_config_finish:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_vpn_plugin_call_set_ip4_config().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_vpn_plugin_call_set_ip4_config().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_set_ip4_config_finish (
    NMDBusVpnPlugin *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_set_ip4_config_sync:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_config: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetIp4Config">SetIp4Config()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_vpn_plugin_call_set_ip4_config() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_set_ip4_config_sync (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_config,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetIp4Config",
    g_variant_new ("(@a{sv})",
                   arg_config),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_set_ip6_config:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_config: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetIp6Config">SetIp6Config()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_vpn_plugin_call_set_ip6_config_finish() to get the result of the operation.
 *
 * See nmdbus_vpn_plugin_call_set_ip6_config_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_vpn_plugin_call_set_ip6_config (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_config,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetIp6Config",
    g_variant_new ("(@a{sv})",
                   arg_config),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_vpn_plugin_call_set_ip6_config_finish:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_vpn_plugin_call_set_ip6_config().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_vpn_plugin_call_set_ip6_config().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_set_ip6_config_finish (
    NMDBusVpnPlugin *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_set_ip6_config_sync:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_config: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetIp6Config">SetIp6Config()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_vpn_plugin_call_set_ip6_config() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_set_ip6_config_sync (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_config,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetIp6Config",
    g_variant_new ("(@a{sv})",
                   arg_config),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_set_failure:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_reason: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetFailure">SetFailure()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_vpn_plugin_call_set_failure_finish() to get the result of the operation.
 *
 * See nmdbus_vpn_plugin_call_set_failure_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_vpn_plugin_call_set_failure (
    NMDBusVpnPlugin *proxy,
    const gchar *arg_reason,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetFailure",
    g_variant_new ("(s)",
                   arg_reason),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_vpn_plugin_call_set_failure_finish:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_vpn_plugin_call_set_failure().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_vpn_plugin_call_set_failure().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_set_failure_finish (
    NMDBusVpnPlugin *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_set_failure_sync:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_reason: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetFailure">SetFailure()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_vpn_plugin_call_set_failure() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_set_failure_sync (
    NMDBusVpnPlugin *proxy,
    const gchar *arg_reason,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetFailure",
    g_variant_new ("(s)",
                   arg_reason),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_new_secrets:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.NewSecrets">NewSecrets()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_vpn_plugin_call_new_secrets_finish() to get the result of the operation.
 *
 * See nmdbus_vpn_plugin_call_new_secrets_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_vpn_plugin_call_new_secrets (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_connection,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NewSecrets",
    g_variant_new ("(@a{sa{sv}})",
                   arg_connection),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_vpn_plugin_call_new_secrets_finish:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_vpn_plugin_call_new_secrets().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_vpn_plugin_call_new_secrets().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_new_secrets_finish (
    NMDBusVpnPlugin *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_call_new_secrets_sync:
 * @proxy: A #NMDBusVpnPluginProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.NewSecrets">NewSecrets()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_vpn_plugin_call_new_secrets() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_vpn_plugin_call_new_secrets_sync (
    NMDBusVpnPlugin *proxy,
    GVariant *arg_connection,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NewSecrets",
    g_variant_new ("(@a{sa{sv}})",
                   arg_connection),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_vpn_plugin_complete_connect:
 * @object: A #NMDBusVpnPlugin.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.Connect">Connect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_vpn_plugin_complete_connect (
    NMDBusVpnPlugin *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_vpn_plugin_complete_connect_interactive:
 * @object: A #NMDBusVpnPlugin.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.ConnectInteractive">ConnectInteractive()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_vpn_plugin_complete_connect_interactive (
    NMDBusVpnPlugin *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_vpn_plugin_complete_need_secrets:
 * @object: A #NMDBusVpnPlugin.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @setting_name: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.NeedSecrets">NeedSecrets()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_vpn_plugin_complete_need_secrets (
    NMDBusVpnPlugin *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *setting_name)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   setting_name));
}

/**
 * nmdbus_vpn_plugin_complete_disconnect:
 * @object: A #NMDBusVpnPlugin.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.Disconnect">Disconnect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_vpn_plugin_complete_disconnect (
    NMDBusVpnPlugin *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_vpn_plugin_complete_set_config:
 * @object: A #NMDBusVpnPlugin.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetConfig">SetConfig()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_vpn_plugin_complete_set_config (
    NMDBusVpnPlugin *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_vpn_plugin_complete_set_ip4_config:
 * @object: A #NMDBusVpnPlugin.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetIp4Config">SetIp4Config()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_vpn_plugin_complete_set_ip4_config (
    NMDBusVpnPlugin *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_vpn_plugin_complete_set_ip6_config:
 * @object: A #NMDBusVpnPlugin.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetIp6Config">SetIp6Config()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_vpn_plugin_complete_set_ip6_config (
    NMDBusVpnPlugin *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_vpn_plugin_complete_set_failure:
 * @object: A #NMDBusVpnPlugin.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.SetFailure">SetFailure()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_vpn_plugin_complete_set_failure (
    NMDBusVpnPlugin *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_vpn_plugin_complete_new_secrets:
 * @object: A #NMDBusVpnPlugin.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-VPN-Plugin.NewSecrets">NewSecrets()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_vpn_plugin_complete_new_secrets (
    NMDBusVpnPlugin *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * NMDBusVpnPluginProxy:
 *
 * The #NMDBusVpnPluginProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusVpnPluginProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusVpnPluginProxy.
 */

struct _NMDBusVpnPluginProxyPrivate
{
  GData *qdata;
};

static void nmdbus_vpn_plugin_proxy_iface_init (NMDBusVpnPluginIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusVpnPluginProxy, nmdbus_vpn_plugin_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NMDBusVpnPluginProxy)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_VPN_PLUGIN, nmdbus_vpn_plugin_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusVpnPluginProxy, nmdbus_vpn_plugin_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_VPN_PLUGIN, nmdbus_vpn_plugin_proxy_iface_init))

#endif
static void
nmdbus_vpn_plugin_proxy_finalize (GObject *object)
{
  NMDBusVpnPluginProxy *proxy = NMDBUS_VPN_PLUGIN_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (nmdbus_vpn_plugin_proxy_parent_class)->finalize (object);
}

static void
nmdbus_vpn_plugin_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_vpn_plugin_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
nmdbus_vpn_plugin_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.NetworkManager.VPN.Plugin: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
nmdbus_vpn_plugin_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_vpn_plugin_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.NetworkManager.VPN.Plugin", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) nmdbus_vpn_plugin_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
nmdbus_vpn_plugin_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_nmdbus_vpn_plugin_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NMDBUS_TYPE_VPN_PLUGIN);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_VPN_PLUGIN);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
nmdbus_vpn_plugin_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NMDBusVpnPluginProxy *proxy = NMDBUS_VPN_PLUGIN_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_vpn_plugin_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_vpn_plugin_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
nmdbus_vpn_plugin_proxy_get_state (NMDBusVpnPlugin *object)
{
  NMDBusVpnPluginProxy *proxy = NMDBUS_VPN_PLUGIN_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "State");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
nmdbus_vpn_plugin_proxy_init (NMDBusVpnPluginProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = nmdbus_vpn_plugin_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NMDBUS_TYPE_VPN_PLUGIN_PROXY, NMDBusVpnPluginProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), nmdbus_vpn_plugin_interface_info ());
}

static void
nmdbus_vpn_plugin_proxy_class_init (NMDBusVpnPluginProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = nmdbus_vpn_plugin_proxy_finalize;
  gobject_class->get_property = nmdbus_vpn_plugin_proxy_get_property;
  gobject_class->set_property = nmdbus_vpn_plugin_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = nmdbus_vpn_plugin_proxy_g_signal;
  proxy_class->g_properties_changed = nmdbus_vpn_plugin_proxy_g_properties_changed;

  nmdbus_vpn_plugin_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusVpnPluginProxyPrivate));
#endif
}

static void
nmdbus_vpn_plugin_proxy_iface_init (NMDBusVpnPluginIface *iface)
{
  iface->get_state = nmdbus_vpn_plugin_proxy_get_state;
}

/**
 * nmdbus_vpn_plugin_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-VPN-Plugin.top_of_page">org.freedesktop.NetworkManager.VPN.Plugin</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_vpn_plugin_proxy_new_finish() to get the result of the operation.
 *
 * See nmdbus_vpn_plugin_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_vpn_plugin_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_VPN_PLUGIN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.VPN.Plugin", NULL);
}

/**
 * nmdbus_vpn_plugin_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_vpn_plugin_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_vpn_plugin_proxy_new().
 *
 * Returns: (transfer full) (type NMDBusVpnPluginProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusVpnPlugin *
nmdbus_vpn_plugin_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_VPN_PLUGIN (ret);
  else
    return NULL;
}

/**
 * nmdbus_vpn_plugin_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-VPN-Plugin.top_of_page">org.freedesktop.NetworkManager.VPN.Plugin</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_vpn_plugin_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusVpnPluginProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusVpnPlugin *
nmdbus_vpn_plugin_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_VPN_PLUGIN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.VPN.Plugin", NULL);
  if (ret != NULL)
    return NMDBUS_VPN_PLUGIN (ret);
  else
    return NULL;
}


/**
 * nmdbus_vpn_plugin_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like nmdbus_vpn_plugin_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_vpn_plugin_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See nmdbus_vpn_plugin_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_vpn_plugin_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_VPN_PLUGIN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.VPN.Plugin", NULL);
}

/**
 * nmdbus_vpn_plugin_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_vpn_plugin_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_vpn_plugin_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NMDBusVpnPluginProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusVpnPlugin *
nmdbus_vpn_plugin_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_VPN_PLUGIN (ret);
  else
    return NULL;
}

/**
 * nmdbus_vpn_plugin_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like nmdbus_vpn_plugin_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_vpn_plugin_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusVpnPluginProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusVpnPlugin *
nmdbus_vpn_plugin_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_VPN_PLUGIN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.VPN.Plugin", NULL);
  if (ret != NULL)
    return NMDBUS_VPN_PLUGIN (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NMDBusVpnPluginSkeleton:
 *
 * The #NMDBusVpnPluginSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusVpnPluginSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusVpnPluginSkeleton.
 */

struct _NMDBusVpnPluginSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_nmdbus_vpn_plugin_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NMDBUS_TYPE_VPN_PLUGIN);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_VPN_PLUGIN);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_nmdbus_vpn_plugin_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_vpn_plugin_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_nmdbus_vpn_plugin_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_vpn_plugin_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _nmdbus_vpn_plugin_skeleton_vtable =
{
  _nmdbus_vpn_plugin_skeleton_handle_method_call,
  _nmdbus_vpn_plugin_skeleton_handle_get_property,
  _nmdbus_vpn_plugin_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
nmdbus_vpn_plugin_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return nmdbus_vpn_plugin_interface_info ();
}

static GDBusInterfaceVTable *
nmdbus_vpn_plugin_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_nmdbus_vpn_plugin_skeleton_vtable;
}

static GVariant *
nmdbus_vpn_plugin_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_nmdbus_vpn_plugin_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _nmdbus_vpn_plugin_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _nmdbus_vpn_plugin_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _nmdbus_vpn_plugin_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.VPN.Plugin", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _nmdbus_vpn_plugin_emit_changed (gpointer user_data);

static void
nmdbus_vpn_plugin_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _nmdbus_vpn_plugin_emit_changed (skeleton);
}

static void
_nmdbus_vpn_plugin_on_signal_state_changed (
    NMDBusVpnPlugin *object,
    guint arg_state)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u)",
                   arg_state));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.VPN.Plugin", "StateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_nmdbus_vpn_plugin_on_signal_secrets_required (
    NMDBusVpnPlugin *object,
    const gchar *arg_message,
    const gchar *const *arg_secrets)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s^as)",
                   arg_message,
                   arg_secrets));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.VPN.Plugin", "SecretsRequired",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_nmdbus_vpn_plugin_on_signal_config (
    NMDBusVpnPlugin *object,
    GVariant *arg_config)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a{sv})",
                   arg_config));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.VPN.Plugin", "Config",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_nmdbus_vpn_plugin_on_signal_ip4_config (
    NMDBusVpnPlugin *object,
    GVariant *arg_ip4config)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a{sv})",
                   arg_ip4config));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.VPN.Plugin", "Ip4Config",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_nmdbus_vpn_plugin_on_signal_ip6_config (
    NMDBusVpnPlugin *object,
    GVariant *arg_ip6config)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a{sv})",
                   arg_ip6config));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.VPN.Plugin", "Ip6Config",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_nmdbus_vpn_plugin_on_signal_login_banner (
    NMDBusVpnPlugin *object,
    const gchar *arg_banner)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_banner));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.VPN.Plugin", "LoginBanner",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_nmdbus_vpn_plugin_on_signal_failure (
    NMDBusVpnPlugin *object,
    guint arg_reason)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u)",
                   arg_reason));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.VPN.Plugin", "Failure",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void nmdbus_vpn_plugin_skeleton_iface_init (NMDBusVpnPluginIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusVpnPluginSkeleton, nmdbus_vpn_plugin_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NMDBusVpnPluginSkeleton)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_VPN_PLUGIN, nmdbus_vpn_plugin_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusVpnPluginSkeleton, nmdbus_vpn_plugin_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_VPN_PLUGIN, nmdbus_vpn_plugin_skeleton_iface_init))

#endif
static void
nmdbus_vpn_plugin_skeleton_finalize (GObject *object)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (nmdbus_vpn_plugin_skeleton_parent_class)->finalize (object);
}

static void
nmdbus_vpn_plugin_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_nmdbus_vpn_plugin_emit_changed (gpointer user_data)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.NetworkManager.VPN.Plugin",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_nmdbus_vpn_plugin_schedule_emit_changed (NMDBusVpnPluginSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
nmdbus_vpn_plugin_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _nmdbus_vpn_plugin_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _nmdbus_vpn_plugin_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
nmdbus_vpn_plugin_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_vpn_plugin_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _nmdbus_vpn_plugin_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
nmdbus_vpn_plugin_skeleton_init (NMDBusVpnPluginSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = nmdbus_vpn_plugin_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NMDBUS_TYPE_VPN_PLUGIN_SKELETON, NMDBusVpnPluginSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
nmdbus_vpn_plugin_skeleton_get_state (NMDBusVpnPlugin *object)
{
  NMDBusVpnPluginSkeleton *skeleton = NMDBUS_VPN_PLUGIN_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
nmdbus_vpn_plugin_skeleton_class_init (NMDBusVpnPluginSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = nmdbus_vpn_plugin_skeleton_finalize;
  gobject_class->get_property = nmdbus_vpn_plugin_skeleton_get_property;
  gobject_class->set_property = nmdbus_vpn_plugin_skeleton_set_property;
  gobject_class->notify       = nmdbus_vpn_plugin_skeleton_notify;


  nmdbus_vpn_plugin_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = nmdbus_vpn_plugin_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = nmdbus_vpn_plugin_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = nmdbus_vpn_plugin_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = nmdbus_vpn_plugin_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusVpnPluginSkeletonPrivate));
#endif
}

static void
nmdbus_vpn_plugin_skeleton_iface_init (NMDBusVpnPluginIface *iface)
{
  iface->state_changed = _nmdbus_vpn_plugin_on_signal_state_changed;
  iface->secrets_required = _nmdbus_vpn_plugin_on_signal_secrets_required;
  iface->config = _nmdbus_vpn_plugin_on_signal_config;
  iface->ip4_config = _nmdbus_vpn_plugin_on_signal_ip4_config;
  iface->ip6_config = _nmdbus_vpn_plugin_on_signal_ip6_config;
  iface->login_banner = _nmdbus_vpn_plugin_on_signal_login_banner;
  iface->failure = _nmdbus_vpn_plugin_on_signal_failure;
  iface->get_state = nmdbus_vpn_plugin_skeleton_get_state;
}

/**
 * nmdbus_vpn_plugin_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-VPN-Plugin.top_of_page">org.freedesktop.NetworkManager.VPN.Plugin</link>.
 *
 * Returns: (transfer full) (type NMDBusVpnPluginSkeleton): The skeleton object.
 */
NMDBusVpnPlugin *
nmdbus_vpn_plugin_skeleton_new (void)
{
  return NMDBUS_VPN_PLUGIN (g_object_new (NMDBUS_TYPE_VPN_PLUGIN_SKELETON, NULL));
}

