// services/network/public/mojom/url_loader_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/url_loader_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/url_loader_factory.mojom-params-data.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared-message-ids.h"

#include "services/network/public/mojom/url_loader_factory.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_FACTORY_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_FACTORY_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
const char URLLoaderFactory::Name_[] = "network.mojom.URLLoaderFactory";

URLLoaderFactoryProxy::URLLoaderFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderFactoryProxy::CreateLoaderAndStart(
    ::mojo::PendingReceiver<::network::mojom::URLLoader> in_loader, int32_t in_routing_id, int32_t in_request_id, uint32_t in_options, const ::network::ResourceRequest& in_request, ::mojo::PendingRemote<::network::mojom::URLLoaderClient> in_client, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderFactory::CreateLoaderAndStart", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("loader", in_loader.is_valid());
      raw_value->SetInteger("routing_id", in_routing_id);
      raw_value->SetInteger("request_id", in_request_id);
      raw_value->SetString("options", base::NumberToString(in_options));
      raw_value->SetString("request", base::trace_event::ValueToString(in_request, "<value of type const ::network::ResourceRequest&>"));
      raw_value->SetBoolean("client", in_client.is_valid());
      raw_value->SetString("traffic_annotation", base::trace_event::ValueToString(in_traffic_annotation, "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderFactory_CreateLoaderAndStart_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoaderFactory_CreateLoaderAndStart_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderInterfaceBase>>(
      in_loader, &params->loader, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->loader),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid loader in URLLoaderFactory.CreateLoaderAndStart request");
  params->routing_id = in_routing_id;
  params->request_id = in_request_id;
  params->options = in_options;
  typename decltype(params->request)::BaseType::BufferWriter
      request_writer;
  mojo::internal::Serialize<::network::mojom::URLRequestDataView>(
      in_request, buffer, &request_writer, &serialization_context);
  params->request.Set(
      request_writer.is_null() ? nullptr : request_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in URLLoaderFactory.CreateLoaderAndStart request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in URLLoaderFactory.CreateLoaderAndStart request");
  typename decltype(params->traffic_annotation)::BaseType::BufferWriter
      traffic_annotation_writer;
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, buffer, &traffic_annotation_writer, &serialization_context);
  params->traffic_annotation.Set(
      traffic_annotation_writer.is_null() ? nullptr : traffic_annotation_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in URLLoaderFactory.CreateLoaderAndStart request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderFactory::Name_);
  message.set_method_name("CreateLoaderAndStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderFactoryProxy::Clone(
    ::mojo::PendingReceiver<URLLoaderFactory> in_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderFactory::Clone", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("factory", in_factory.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderFactory_Clone_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoaderFactory_Clone_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_factory, &params->factory, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid factory in URLLoaderFactory.Clone request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderFactory::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool URLLoaderFactoryStubDispatch::Accept(
    URLLoaderFactory* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kURLLoaderFactory_CreateLoaderAndStart_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderFactory::CreateLoaderAndStart",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderFactory::CreateLoaderAndStart");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderFactory_CreateLoaderAndStart_Params_Data* params =
          reinterpret_cast<internal::URLLoaderFactory_CreateLoaderAndStart_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::URLLoader> p_loader{};
      int32_t p_routing_id{};
      int32_t p_request_id{};
      uint32_t p_options{};
      ::network::ResourceRequest p_request{};
      ::mojo::PendingRemote<::network::mojom::URLLoaderClient> p_client{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      URLLoaderFactory_CreateLoaderAndStart_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_loader =
            input_data_view.TakeLoader<decltype(p_loader)>();
      }
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success)
        p_request_id = input_data_view.request_id();
      if (success)
        p_options = input_data_view.options();
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateLoaderAndStart(
std::move(p_loader), 
std::move(p_routing_id), 
std::move(p_request_id), 
std::move(p_options), 
std::move(p_request), 
std::move(p_client), 
std::move(p_traffic_annotation));
      return true;
    }
    case internal::kURLLoaderFactory_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderFactory::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderFactory::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderFactory_Clone_Params_Data* params =
          reinterpret_cast<internal::URLLoaderFactory_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<URLLoaderFactory> p_factory{};
      URLLoaderFactory_Clone_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_factory));
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderFactoryStubDispatch::AcceptWithResponder(
    URLLoaderFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kURLLoaderFactory_CreateLoaderAndStart_Name: {
      break;
    }
    case internal::kURLLoaderFactory_Clone_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kURLLoaderFactoryValidationInfo[] = {
    {internal::kURLLoaderFactory_CreateLoaderAndStart_Name,
     {&internal::URLLoaderFactory_CreateLoaderAndStart_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderFactory_Clone_Name,
     {&internal::URLLoaderFactory_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool URLLoaderFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::URLLoaderFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kURLLoaderFactoryValidationInfo);
}

}  // namespace mojom
}  // namespace network

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif